<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;
use App\Repositories\Backend\Auth\RoleRepository;
use App\Repositories\Backend\Auth\PermissionRepository;
use App\Models\Auth\User;
use App\Models\Auth\UserDetails;
use App\Models\Auth\Batch;
use App\Models\Auth\Lead;
use App\Models\Auth\LeadActivity;
use App\Models\Auth\UniversityCourses;
use App\Models\Auth\Universities;
use App\Models\Auth\Countries;
use Illuminate\Support\Facades\Input;
use App\Repositories\Backend\Auth\UserRepository;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;
use App\Models\MailTemplates;
use App\Notifications\Backend\UserAlert;
use App\Models\Auth\Course;
use App\Models\Auth\Country;
use Flash;
use Illuminate\Validation\Rule;
use App\Models\StudyLevels;
use App\Models\Auth\UniversityCourseCategories;
use App\Models\Auth\UniversityCourseSubcategories;

class ImportExportController extends Controller
{

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('import'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }
            return $next($request);
        });
    }

    public function index($currentPage)
    {
        $userRepo = new UserRepository();
        $staff = $userRepo->getNonStudentsTrainers();
        $courseCategory = DB::table('university_course_categories')->get();
        $countries = Country::orderBy('title_en')->where('overseas_status',1)->select('id', 'title_en as name')->get();
        $branchList = get_staff_branches(\Auth::user()->id);
        return view('backend.import_export.index', compact('staff','courseCategory','currentPage','countries','branchList'));
    }

    public function custom()
    {
        $userRepo = new UserRepository();
        $staff = $userRepo->getNonStudentsTrainers();
        $courseCategory = DB::table('university_course_categories')->get();
        return view('backend.import_export.custom', compact('staff', 'courseCategory'));
    }

    public function uploadStudents(Request $request)
    {

        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('import'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }

        set_time_limit(0);
        $file_allowed_ext = array('csv');
        $serial_no_column = false;
        $import_file_headers = array(0 => 'SI No.', 1 => 'First name', 2 => 'Last name', 3 => 'Email', 4 => 'Dialcode', 5 => 'Mobile', 6 => 'Title', 7 => 'Type');
        $valid_column_header = true;
        $invalid_header_name = '';
        $created_cnt = 0;

        if ($request->file('data_file')) {
            $file = $request->file('data_file');
            $filename = $file->getClientOriginalName();
            $file_ext = $file->getClientOriginalExtension();
            $err_msg = array();
            $all_err_msg = $success_msg = array();
            if ($file->getSize() > 0 && in_array($file_ext, $file_allowed_ext)) {
                \Log::debug("Importing Students File:" . $filename);
                // $filename = str_replace(" ", "-", $filename);
                // $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '-', $filename);
                // $file_name_part = date('dmyhis');
                // $filename = $filename .'_'.$file_name_part.'.'. $file_ext;
                // $path = $file->storeAs('/import_files', $filename , 'public');
                // \Log::debug("::savedpath::$path");

                $file_path = $file->getRealPath();
                if (($handle = fopen($file_path, "r")) !== FALSE) {
                    $i = 0;
                    while (($data = fgetcsv($handle)) !== FALSE) {
                        
                        $data[0] = preg_replace("/\xEF\xBB\xBF/", "", $data[0]);
                        if ($data[0] == 'SI No.') {
                            $serial_no_column = true;

                            //check for valid file headers----------------------
                            for ($i = 0; $i <= count($import_file_headers) - 1; $i++) {
                                if (!isset($data[$i]) || strtolower(trim($data[$i])) != strtolower($import_file_headers[$i])) {
                                    $valid_column_header = false;
                                    $invalid_header_name .= $import_file_headers[$i] . ', ';
                                }
                            }
                            //-------------------------------------------------
                            continue;
                        }

                        if ($data[0] != '' && is_numeric($data[0]) && $serial_no_column && $valid_column_header) {
                            $insert_data = array();
                            $serial_no = $data[0];
                            $password = Str::random(1) . rand(10000, 99999);

                            $insert_data['first_name'] = trim($data[1]);
                            $insert_data['last_name'] = trim($data[2]);
                            $insert_data['email'] = trim($data[3]);
                            if(!empty($insert_data['email'])){
                                if(DB::table('users')
                                    ->where('email', $insert_data['email'])
                                    ->exists()){
                                        $err_msg[] = 'Row:' . $i . ", Error: Lead With Email '".$insert_data['email']."' Already Exists!";
                                        $i++;
                                        continue;
                                }
                            }
                            
                            $insert_data['dialcode'] = trim($data[4]);
                            if(!empty($insert_data['dialcode'])){
                                if (!is_numeric($insert_data['dialcode'])) { 
                                    $err_msg[] = 'Row:' . $serial_no . ", Error: Dialcode '" .$insert_data['dialcode']. "' Invalid Dialcode Format!";
                                    $i++;
                                    continue;
                                }
                            }

                            $insert_data['mobile'] = trim($data[5]);
                            if(!empty($insert_data['mobile'])){
                                if (!is_numeric($insert_data['mobile'])) { 
                                    $err_msg[] = 'Row:' . $serial_no . ", Error: Mobile number '" .$insert_data['mobile']. "' Invalid Mobile Number Format!";
                                    $i++;
                                    continue;
                                }
                                if(strlen($insert_data['mobile']) > config('app.USER_MOBILE_MAX_LENGTH') || strlen($insert_data['mobile']) < config('app.USER_MOBILE_MIN_LENGTH')){
                                    $err_msg[] = 'Row:' . $serial_no . ", Error: Mobile number '" .$insert_data['mobile']. "' Invalid Number!";
                                    $i++;
                                    continue;
                                }
                                if(DB::table('users')
                                    ->where('mobile', $insert_data['mobile'])
                                    ->exists()){
                                        $err_msg[] = 'Row:' . $i . ", Error: Lead With Mobile '".$insert_data['mobile']."' Already Exists!";
                                        $i++;
                                        continue;
                                }
                            }

                            // if(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email'){
                            //     if($insert_data['email'] == ""){
                            //         $err_msg[] = 'Mandatory fields (Email) missing in Row:' . $serial_no;
                            //         $i++;
                            //         continue;
                            //     }
                            // } elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_and_mobile'){
                            //     if($insert_data['email'] == "" || $insert_data['mobile'] == ""){
                            //         $err_msg[] = 'Mandatory fields (Email and Mobile) missing in Row:' . $serial_no;
                            //         $i++;
                            //         continue;
                            //     }
                            // } elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_or_mobile'){
                            //     if($insert_data['email'] == "" && $insert_data['mobile'] == ""){
                            //         $err_msg[] = 'Mandatory fields (Email or Mobile) missing in Row:' . $serial_no;
                            //         $i++;
                            //         continue;
                            //     }
                            // } elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'mobile'){
                            //     if($insert_data['mobile'] == ""){
                            //         $err_msg[] = 'Mandatory fields (Mobile) missing in Row:' . $serial_no;
                            //         $i++;
                            //         continue;
                            //     }           
                            // }

                            $title = trim($data[6]);
                            if (empty($title))
                                $title = "Mr.";
                            $insert_data['title'] = $title;

                            $type = trim($data[7]);
                            if ($type == 'Study Abroad') {
                                $insert_data['student_type'] = 'study_abroad';
                            } elseif ($type == 'Coaching') {
                                $insert_data['student_type'] = 'course';
                            } elseif ($type == 'Study Abroad & Coaching') {
                                $insert_data['student_type'] = 'study_abroad_course';
                            } else {
                                if (config('app.product_code') == 'OVERSEAS') {
                                    $insert_data['student_type'] = 'study_abroad';
                                } elseif (config('app.product_code') == 'TRAINING') {
                                    $insert_data['student_type'] = 'course';
                                } else {
                                    $insert_data['student_type'] = 'study_abroad_course';
                                }
                            }

                            $insert_data['birthday'] = NULL;
                            $insert_data['active'] = 1;
                            $insert_data['confirmed'] = 1;
                            $insert_data['password'] = $password;
                            $insert_data['roles'] = ['user'];
                            $insert_data['created_mode'] = "import";
                            $insert_data['state'] = "";
                            $insert_data['study_level'] = "";
                            $insert_data['currently_studying_course'] = "";
                            $insert_data['branch'] = empty($request->input('branch')) ? '1' : $request->input('branch');

                            //$batch_code = trim($data[5]);
                            
                            if ($insert_data['first_name'] != '') {
                                $user_repo = new UserRepository();
                                try {
                                    $refcode = generate_refcode($insert_data['first_name']);
                                    $insert_data['refcode'] = $refcode;
                                    $student = $user_repo->create($insert_data);
                                    $student->assignRole('user');
                                    \Log::debug("Student imported:" . $student->first_name . ", " . $student->email);
                                    $created_cnt++;

                                    // $userdetails = new UserDetails([
                                    //     'userid'    => $student->id,
                                    //     // 'campaign_id' => trim($data[9]),
                                    //     // 'lead_source_detail' => trim($data[10]),
                                    //     // 'passout_year' => trim($data[11]),
                                    //     // 'lead_notes' => trim($data[12])
                                    // ]);
                                    // $userdetails->save();

                                    // if ($mobile) {
                                    //     $student->mobile = $mobile;
                                    // }
                                    //$student->save();

                                    //email
                                    if ($request->input('email_password')) {
                                        $mail_tpl = MailTemplates::find("student_import");
                                        if($mail_tpl && $mail_tpl->status){
                                            $email_message = $mail_tpl->message;
                                            $email_message = str_ireplace("#sitename#", app_name(), $email_message);
                                            $email_message = str_ireplace("#siteurl#", url(''), $email_message);
                                            $email_message = str_ireplace("#first_name#", $student->first_name, $email_message);
                                            $email_message = str_ireplace("#full_name#", $student->full_name, $email_message);
                                            $email_message = str_ireplace("#email#", $insert_data['email'], $email_message);
                                            $email_message = str_ireplace("#password#", $password, $email_message);
                                        
                                            try {
                                                //$student->notify(new UserAlert($mail_tpl->subject, $email_message));
                                                user_notify($student, $mail_tpl->subject, $email_message);
                                                \Log::debug("Password sent to student");
                                            } catch (\Exception $e) {
                                                $message = $e->getMessage();
                                                \Log::debug("Mail Error: (Password sent to student) " . $message);
                                            }
                                        }
                                    }
                                    //

                                    /*if ($batch_code) {
                                        $batch_id = DB::table('batch')->where('code', $batch_code)->value('id');
                                        if ($batch_id) {
                                            DB::table('batch_students')->insert(['batch' => $batch_id, 'student' => $student->id, 'created_at' => date("Y-m-d H:i:s"), "updated_at" => NULL]);
                                            \Log::debug("Student added to batch");
                                        } else {
                                            $err_msg[] = 'Row:' . $serial_no . ", Error: Batch Code:" . $batch_code . " Not found!";
                                        }
                                    }*/
                                } catch (\Illuminate\Database\QueryException $ex) {
                                    $err_code = $ex->getCode();
                                    if ($ex->getCode() == 23000) {
                                        $b = preg_match('/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i', $ex->getMessage(), $matches);
                                        if ($b) {
                                            $err_msg[] = 'Row: ' . $serial_no . ' Duplicate entry for email: ' . $matches[0];
                                        }
                                    }
                                    //$err_msg[] = 'Row:' . $serial_no . ", Error:" . $ex->getMessage();
                                }
                            } else {
                                $err_msg[] = 'Mandatory fields missing in Row:' . $serial_no;
                            }
                        } elseif (!$serial_no_column) {
                            $err_msg[] = "File format issue. No Serial number found";
                            $all_err_msg = array_merge($all_err_msg, $err_msg);
                            break;
                        } elseif (!$valid_column_header) {
                            $err_msg[] = "File format issue. Invalid Header Name(s) : " . $invalid_header_name;
                            $all_err_msg = array_merge($all_err_msg, $err_msg);
                            break;
                        }
                    }
                    $all_err_msg = array_merge($all_err_msg, $err_msg);
                    fclose($handle);
                }

                if (empty($all_err_msg)) {
                    $success_msg[] = $created_cnt . ' Students imported successfully.';
                }
            } else {
                $err_msg[] = 'File Format Error!!! Allowed file format is .csv';
                $all_err_msg = array_merge($all_err_msg, $err_msg);
            }
        }

        $userRepo = new UserRepository();
        $staff = $userRepo->getNonStudentsTrainers();
        $courseCategory = DB::table('university_course_categories')->get();
        $currentPage = 'students';
        $countries = Country::orderBy('title_en')->where('overseas_status',1)->select('id', 'title_en as name')->get();
        // return view('backend.import_export.index', ['countries' => $countries, 'currentPage' => $currentPage, 'staff' => $staff, 'courseCategory' => $courseCategory, 'import_errors' => $all_err_msg, 'import_success' => $success_msg]);

        if (empty($all_err_msg)) {
            $currentPage = 'students';
            return redirect()->route('admin.import-export.index', $currentPage)->with("result_title", "<strong>Student Import Results: </strong>")->withFlashSuccess(implode('<br>',$success_msg));
        }else{
            // dd($success_msg);
            $currentPage = 'students';
            return redirect()->route('admin.import-export.index', $currentPage)->with("result_title", "<strong>Student Import Results: </strong>")->with('flash_success'.implode('<br>',$success_msg))->with('flash_danger',implode('<br>',$all_err_msg));
        }
    }

    public function uploadLeads(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('import'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }

        set_time_limit(0);
        $file_allowed_ext = array('csv');
        $serial_no_column = false;
        $import_file_headers = array(0 => 'SI No.', 1 => 'First name', 2 => 'Last name', 3 => 'Email', 4 => 'Dialcode', 5 => 'Mobile', 6 => 'Lead Status', 7 => 'Gender', 8 => 'Date of Birth', 9 => 'Residence Country',10 => 'State',  11 => 'City', 12 => 'Qualification', 13 => 'Passout Year', 14 => 'Lead Source', 15 => 'Lead Source Details', 16 => 'Lead Campaign Name', 17 => 'Notes');
        // $import_file_headers = array(0 => 'SI No.', 1 => 'First name', 2 => 'Last name', 3 => 'Email', 4 => 'Mobile', 5 => 'Status', 6 => 'Type', 7 => 'Source', 8 => 'Notes');
        $valid_column_header = true;
        $invalid_header_name = '';
        $created_cnt = 0;
        $err_msg = array();

        if ($request->file('data_file')) {
            $file = $request->file('data_file');
            $filename = $file->getClientOriginalName();
            $file_ext = $file->getClientOriginalExtension();
            $all_err_msg = $success_msg = array();
            // $all_err_msg = $success_msg = array();
            if ($file->getSize() > 0 && in_array($file_ext, $file_allowed_ext)) {
                \Log::debug("Importing Lead File:" . $filename);
                // $filename = str_replace(" ", "-", $filename);
                // $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '-', $filename);
                // $file_name_part = date('dmyhis');
                // $filename = $filename .'_'.$file_name_part.'.'. $file_ext;
                // $path = $file->storeAs('/import_files', $filename , 'public');
                // \Log::debug("::savedpath::$path");

                $file_path = $file->getRealPath();
                if (($handle = fopen($file_path, "r")) !== FALSE) {
                    $i = 0;
                    while (($data = fgetcsv($handle)) !== FALSE) {
                        \Log::debug($i);
                        $data[0] = preg_replace("/\xEF\xBB\xBF/", "", $data[0]);
                        if ($data[0] == 'SI No.') {
                            $serial_no_column = true;

                            //check for valid file headers----------------------
                            for ($j = 0; $j <= count($import_file_headers) - 1; $j++) {
                                if (!isset($data[$j]) || strtolower(trim($data[$j])) != strtolower($import_file_headers[$j])) {
                                    $valid_column_header = false;
                                    $invalid_header_name .= $import_file_headers[$j] . ', ';
                                }
                            }
                            //-------------------------------------------------
                            continue;
                        }

                        if ($data[0] != '' && is_numeric($data[0]) && $serial_no_column && $valid_column_header) {
                            $insert_data = array();
                            $insert_data_user_detail = array();
                            $serial_no = $data[0];

                            $insert_data['first_name'] = trim($data[1]);
                            $insert_data['last_name'] = trim($data[2]);

                            $insert_data['email'] = trim($data[3]);

			                $insert_data['dialcode'] = trim($data[4]);
                            if(!empty($insert_data['dialcode'])){
                                if (!is_numeric($insert_data['dialcode'])) { 
                                    $err_msg[] = 'Row:' . $serial_no . ", Error: Dialcode '" .$insert_data['dialcode']. "' Invalid Dialcode Format!";
                                    $i++;
                                    continue;
                                }
                            }

                            $insert_data['mobile'] = trim($data[5]);
                            if(!empty($insert_data['mobile'])){
                                if (!is_numeric($insert_data['mobile'])) { 
                                    $err_msg[] = 'Row:' . $serial_no . ", Error: Mobile number '" .$insert_data['mobile']. "' Invalid Mobile Number Format!";
                                    $i++;
                                    continue;
                                }
                                if(strlen($insert_data['mobile']) > config('app.USER_MOBILE_MAX_LENGTH') || strlen($insert_data['mobile']) < config('app.USER_MOBILE_MIN_LENGTH')){
                                    $err_msg[] = 'Row:' . $serial_no . ", Error: Mobile number '" .$insert_data['mobile']. "' Invalid Number!";
                                    $i++;
                                    continue;
                                }
                            }

                            if(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email'){
                                if($insert_data['email'] == ""){
                                    $err_msg[] = 'Mandatory fields (Email) missing in Row:' . $serial_no;
                                    $i++;
                                    continue;
                                }else{
                                    if(DB::table('users')
                                        ->where('email', $insert_data['email'])
                                        ->exists()){
                                            $err_msg[] = 'Row:' . $i . ", Error: Lead With Email '".$insert_data['email']."' Already Exists!";
                                            $i++;
                                            continue;
                                    }
                                }
                            } elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_and_mobile'){
                                if($insert_data['email'] == "" || $insert_data['mobile'] == ""){
                                    $err_msg[] = 'Mandatory fields (Email and Mobile) missing in Row:' . $serial_no;
                                    $i++;
                                    continue;
                                }else{
                                    if(DB::table('users')
                                        ->where('email', $insert_data['email'])
                                        ->exists()){
                                            $err_msg[] = 'Row:' . $i . ", Error: Lead With Email '".$insert_data['email']."' Already Exists!";
                                            $i++;
                                            continue;
                                    }
                                    if(DB::table('users')
                                        ->where('mobile', $insert_data['mobile'])
                                        ->exists()){
                                            $err_msg[] = 'Row:' . $i . ", Error: Lead With Mobile '".$insert_data['mobile']."' Already Exists!";
                                            $i++;
                                            continue;
                                    }
                                }
                            } elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_or_mobile'){
                                if($insert_data['email'] == "" && $insert_data['mobile'] == ""){
                                    $err_msg[] = 'Mandatory fields (Email or Mobile) missing in Row:' . $serial_no;
                                    $i++;
                                    continue;
                                }else{
                                    if(!empty($insert_data['email'])){
                                        if(DB::table('users')
                                            ->where('email', $insert_data['email'])
                                            ->exists()){
                                                $err_msg[] = 'Row:' . $i . ", Error: Lead With Email '".$insert_data['email']."' Already Exists!";
                                                $i++;
                                                continue;
                                        }
                                    }
                                    if(!empty($insert_data['mobile'])){
                                        if(DB::table('users')
                                            ->where('mobile', $insert_data['mobile'])
                                            ->exists()){
                                                $err_msg[] = 'Row:' . $i . ", Error: Lead With Mobile '".$insert_data['mobile']."' Already Exists!";
                                                $i++;
                                                continue;
                                        }
                                    }
                                }
                            } elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'mobile'){
                                if($insert_data['mobile'] == ""){
                                    $err_msg[] = 'Mandatory fields (Mobile) missing in Row:' . $serial_no;
                                    $i++;
                                    continue;
                                }else{
                                    if(DB::table('users')
                                        ->where('mobile', $insert_data['mobile'])
                                        ->exists()){
                                            $err_msg[] = 'Row:' . $i . ", Error: Lead With Mobile '".$insert_data['mobile']."' Already Exists!";
                                            $i++;
                                            continue;
                                    }
                                }         
                            }

                            $status = trim($data[6]);
                            $insert_data['lead_status'] = empty($status) ? get_default_lead_status() : $status;
                            
                            $insert_data['student_type'] = 'study_abroad';

                            $insert_data['gender'] = trim($data[7]);
                            $insert_data['birthday'] = date('Y-m-d',strtotime(trim($data[8])));
                            $insert_data['country'] = trim($data[9]);
                            $insert_data['state'] = trim($data[10]);
                            $insert_data['city'] = trim($data[11]);

                            $insert_data_user_detail['highest_level_education'] = trim($data[12]);
                            if(!empty($insert_data_user_detail['highest_level_education'])){
                                $qualification = $insert_data_user_detail['highest_level_education'];
            
                                if($insert_data_user_detail['highest_level_education'] != "9th"){
                                    $insert_data_user_detail['highest_level_education'] = strtolower($qualification);
                                }elseif($insert_data['highest_level_education'] != "10th"){
                                    $insert_data_user_detail['highest_level_education'] = strtolower($qualification);
                                }elseif($insert_data_user_detail['highest_level_education'] != "11th"){
                                    $insert_data_user_detail['highest_level_education'] = strtolower($qualification);
                                }elseif($insert_data_user_detail['highest_level_education'] != "12th"){
                                    $insert_data_user_detail['highest_level_education'] = strtolower($qualification);
                                }elseif($insert_data_user_detail['highest_level_education'] != "Bachelors"){
                                    $insert_data_user_detail['highest_level_education'] = strtolower($qualification);
                                }elseif($insert_data_user_detail['highest_level_education'] != "Masters"){
                                    $insert_data_user_detail['highest_level_education'] = strtolower($qualification);
                                } else {
                                    $err_msg[] = "Row: " . $serial_no . " Qualification '" . $qualification . "' not found in DB!";
                                    $i++;
                                    continue;
                                }
                            }

                            $insert_data_user_detail['passout_year'] = trim($data[13]);
                            
                            $source = trim($data[14]);
                            $insert_data['lead_source'] = empty($source) ? 'other' : strtolower($source);

                            $insert_data_user_detail['lead_source_detail'] = trim($data[15]);
                            $insert_data_user_detail['lead_campaign_name'] = trim($data[16]);
                            $insert_data_user_detail['lead_notes'] = trim($data[17]);

                            $insert_data['assigned_to'] = $request->input('assign_to');
                            $insert_data['branch'] = empty($request->input('branch')) ? '1' : $request->input('branch');
                            $insert_data['is_lead'] = 1;
                            $insert_data['created_mode'] = "import";
                            $insert_data['confirmed'] = 1;
                            if($request->input('set_followup_today'))  {
                                $insert_data['next_followup'] = now();
                            }else{
                                $insert_data['next_followup'] = NULL;
                            }
                            

                            // if ($insert_data['first_name'] != '' && $insert_data['email'] != '') {
                            if ($insert_data['first_name'] != '') {
                                try {
                                    $refcode = generate_refcode($insert_data['first_name']);
                                    $insert_data['refcode'] = $refcode;
                                    $lead = User::create($insert_data);
                                    $created_cnt++;
                                    \Log::debug("Lead imported:" . $lead->first_name . ", " . $lead->email);

                                    $insert_data_user_detail['userid'] = $lead->id;
                                    $leadDetail = UserDetails::create($insert_data_user_detail);
                                    \Log::debug("Lead user detail imported:" . $leadDetail->highest_level_education . ", " . $leadDetail->lead_notes);

                                    if (!empty($notes)) {
                                        $followup = new LeadActivity;
                                        $followup->lead_id = $lead->id;
                                        $followup->date = now();
                                        $followup->type = 'others';
                                        $followup->staff = $insert_data['assigned_to'];
                                        $followup->detail = "LEAD IMPORTED WITH NOTES: " . $notes;
                                        $followup->save();
                                    }
                                } catch (\Illuminate\Database\QueryException $ex) {
                                    \Log::error("Lead create error:".$ex->getMessage());
                                    $err_msg[] = 'Row:' . $i . ", Error: Something Went Wrong!";
                                }
                            } else {
                                $err_msg[] = 'Mandatory fields missing in Row:' . $serial_no;
                            }
                        } elseif (!$serial_no_column) {
                            $all_err_msg = array_merge($all_err_msg, $err_msg);
                            $err_msg[] = "File format issue. No Serial number found";
                            break;
                        } elseif (!$valid_column_header) {
                            $all_err_msg = array_merge($all_err_msg, $err_msg);
                            $err_msg[] = "File format issue. Invalid Header Name(s) : " . $invalid_header_name;
                            break;
                        }
                    }
                    fclose($handle);
                    $all_err_msg = array_merge($all_err_msg, $err_msg);
                }
                if($created_cnt){
                    $success_msg[] = $created_cnt . ' Leads Imported Successfully.';
                }
            } else {
                $err_msg[] = 'File Format Error!!! Allowed file format is .csv';
                $all_err_msg = array_merge($all_err_msg, $err_msg);
            }
        }

        $userRepo = new UserRepository();
        $staff = $userRepo->getNonStudentsTrainers();
        $courseCategory = DB::table('university_course_categories')->get();
        $currentPage = 'leads';
        // return view('backend.import_export.index', ['currentPage' => $currentPage, 'staff' => $staff, 'courseCategory' => $courseCategory, 'import_errors' => $err_msg, 'import_success' => $success_msg]);

        if (empty($all_err_msg)) {
            $currentPage = 'leads';
            return redirect()->route('admin.import-export.index', $currentPage)->with("result_title", "<strong>Leads Import Results: </strong>")->withFlashSuccess(implode('<br>',$success_msg));
        }else{
            // dd($success_msg);
            $currentPage = 'leads';
            return redirect()->route('admin.import-export.index', $currentPage)->with("result_title", "<strong>Leads Import Results: </strong>")->with('flash_success'.implode('<br>',$success_msg))->with('flash_danger',implode('<br>',$all_err_msg));
        }
    }

    public function uploadCustom(Request $request)
    {

        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('import'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }

        set_time_limit(0);
        $file_allowed_ext = array('csv');
        $serial_no_column = false;
        $import_file_headers = array(0 => 'SI No.', 1 => 'First name', 2 => 'Last name', 3 => 'Email', 4 => 'Mobile', 5 => 'Status', 6 => 'Type', 7 => 'Source', 8 => 'Notes');
        $valid_column_header = true;
        $invalid_header_name = '';
        $created_cnt = 0;

        if ($request->file('data_file')) {
            $file = $request->file('data_file');
            $filename = $file->getClientOriginalName();
            $file_ext = $file->getClientOriginalExtension();
            $all_err_msg = $success_msg = array();
            if ($file->getSize() > 0 && in_array($file_ext, $file_allowed_ext)) {
                \Log::debug("Importing Lead File:" . $filename);
                // $filename = str_replace(" ", "-", $filename);
                // $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '-', $filename);
                // $file_name_part = date('dmyhis');
                // $filename = $filename .'_'.$file_name_part.'.'. $file_ext;
                // $path = $file->storeAs('/import_files', $filename , 'public');
                // \Log::debug("::savedpath::$path");

                $file_path = $file->getRealPath();
                if (($handle = fopen($file_path, "r")) !== FALSE) {
                    while (($data = fgetcsv($handle)) !== FALSE) {

                        $data[0] = preg_replace("/\xEF\xBB\xBF/", "", $data[0]);
                        if ($data[0] == 'SI No.') {
                            $serial_no_column = true;

                            //check for valid file headers----------------------
                            // for ($i = 0; $i <= count($import_file_headers) - 1; $i++) {
                            //     if (!isset($data[$i]) || strtolower(trim($data[$i])) != strtolower($import_file_headers[$i])) {
                            //         $valid_column_header = false;
                            //         $invalid_header_name .= $import_file_headers[$i] . ', ';
                            //     }
                            // }
                            //-------------------------------------------------
                            continue;
                        }

                        if ($data[0] != '' && is_numeric($data[0]) && $serial_no_column && $valid_column_header) {
                            $insert_data = array();
                            $serial_no = $data[0];
                            $err_msg = array();

                            $insert_data['first_name'] = trim($data[1]);
                            $last_name = trim($data[2]);
                            if ($insert_data['first_name'] == "") {
                                $space = strpos($last_name, " ");
                                if ($space) {
                                    $insert_data['first_name'] = substr($last_name, 0, $space);
                                    $last_name = substr($last_name, $space + 1);
                                } else {
                                    $insert_data['first_name'] = $last_name;
                                    $last_name = "";
                                }
                            }
                            $insert_data['last_name'] = $last_name;
                            $insert_data['email'] = trim($data[3]);
                            $insert_data['mobile'] = trim($data[4]);

                            $status = trim($data[5]);
                            // $insert_data['status'] = empty($status) ? 'New' : $status;
                            $insert_data['lead_status'] = empty($status) ? 'New' : $status;

                            // $insert_data['lead_type'] = 'Study Abroad';
                            $insert_data['student_type'] = 'Study Abroad';

                            $source = trim($data[6]);
                            $insert_data['lead_source'] = empty($source) ? 'other' : $source;

                            $date_created = date("Y-m-d H:i:00", strtotime(trim($data[20])));
                            $date_modified = date("Y-m-d H:i:00", strtotime(trim($data[21])));

                            $description = "
                            Lead Quality: " . trim($data[23]) . "
                            <br />Gender: " . trim($data[7]) . "
                            <br />Date of Birth: " . trim($data[18]) . "
                            <br />Country of Residence: " . trim($data[8]) . "
                            <br />Course Level: " . trim($data[9]) . "
                            <br />Course Title: " . trim($data[10]) . "
                            <br />Desire Intake/Semester: " . trim($data[29]) . "
                            <br />English Test: " . trim($data[11]) . "
                            <br />Require Accommodation: " . trim($data[24]) . "
                            <br />Currently Studying (Course): " . trim($data[25]) . "
                            <br />Course Subject: " . trim($data[26]) . "
                            <br />Previous Qualification 1: " . trim($data[22]) . "
                            <br />Country of Citizenship: " . trim($data[27]) . "
                            <br />Require Study Permit: " . trim($data[28]) . "
                            <br />Primary Address Street: " . trim($data[12]) . "
                            <br />Primary Address City: " . trim($data[13]) . "
                            <br />Primary Address State: " . trim($data[14]) . "
                            <br />Primary Address Postalcode: " . trim($data[15]) . "
                            <br />Assigned to: " . trim($data[19]) . "
                            <br />Date Created: " . trim($data[20]) . "
                            <br />Date Modified: " . trim($data[21]) . "
                            <br />Lead Campaign Name: " . trim($data[17]) . "
                            <br />Description: " . trim($data[16]);

                            $insert_data['description'] = $description;

                            if ($insert_data['first_name'] != '' && $insert_data['email'] != '') {
                                try {
                                    // $lead = Lead::create($insert_data);
                                    $refcode = generate_refcode($insert_data['first_name']);
                                    $insert_data['refcode'] = $refcode;
                                    $lead = User::create($insert_data);
                                    \Log::debug("Lead imported:" . $lead->first_name . ", " . $lead->last_name . ", " . $lead->email);
                                    $created_cnt++;

                                    $lead->tmp_created = $date_created;
                                    $lead->tmp_updated = $date_modified;
                                    $lead->next_followup = date("Y-m-d H:i:00");
                                    $lead->save();

                                    //if($created_cnt == 2) break;
                                    // if(!empty($notes)) {
                                    //     $followup = new LeadActivity;
                                    //     $followup->lead_id = $lead->id;
                                    //     $followup->date = now();
                                    //     $followup->type = 'others';
                                    //     $followup->staff = $insert_data['assigned_to'];
                                    //     $followup->detail = "LEAD IMPORTED WITH NOTES: ".$notes;
                                    //     $followup->save();
                                    // }

                                } catch (\Illuminate\Database\QueryException $ex) {
                                    $err_msg[] = 'Row:' . $serial_no . ", Error:" . $ex->getMessage();
                                }
                            } else {
                                $err_msg[] = 'Mandatory fields missing in Row:' . $serial_no;
                            }
                        } elseif (!$serial_no_column) {
                            $err_msg[] = "File format issue. No Serial number found";
                            $all_err_msg = array_merge($all_err_msg, $err_msg);
                            break;
                        } elseif (!$valid_column_header) {
                            $err_msg[] = "File format issue. Invalid Header Name(s) : " . $invalid_header_name;
                            $all_err_msg = array_merge($all_err_msg, $err_msg);
                            break;
                        }
                        $all_err_msg = array_merge($all_err_msg, $err_msg);
                    }
                    fclose($handle);
                }

                if (empty($all_err_msg)) {
                    $success_msg[] = $created_cnt . ' Leads imported successfully.';
                }
            } else {
                $err_msg[] = 'File Format Error!!! Allowed file format is .csv';
                $all_err_msg = array_merge($all_err_msg, $err_msg);
            }
        }

        $userRepo = new UserRepository();
        $staff = $userRepo->getNonStudentsTrainers();
        $courseCategory = DB::table('university_course_categories')->get();
        $currentPage = 'leads';
        return view('backend.import_export.index', ['currentPage' => $currentPage, 'staff' => $staff, 'courseCategory' => $courseCategory, 'import_errors' => $all_err_msg, 'import_success' => $success_msg]);
    }

    public function uploadCourse(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('import'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }

        set_time_limit(0);
        $file_allowed_ext = array('csv');
        $import_file_key = $err_msg = array();
        $serial_no_column = $valid_column_header = false;
        $created_cnt = 0;
        $updated_cnt = 0;
        $category_for_print = "";
        $import_file_key['category'] = $import_file_key['sub-category'] = $import_file_key['university'] = $import_file_key['course_name'] = $import_file_key['concentration'] = $import_file_key['website_url'] = $import_file_key['campus'] = $import_file_key['country'] =  $import_file_key['study_level'] = $import_file_key['duration'] = $import_file_key['intakes'] = $import_file_key['year'] = $import_file_key['gre_score'] = $import_file_key['gmat_score'] = $import_file_key['entry_requirements'] = $import_file_key['ielts_score'] =  $import_file_key['ielts_no_band_less_than'] = $import_file_key['tofel_score'] = $import_file_key['tofel_no_band_less_than'] = $import_file_key['pte_score'] = $import_file_key['pte_no_band_less_than'] = $import_file_key['application_deadline'] = $import_file_key['application_fee'] = $import_file_key['scholarship_available'] = $import_file_key['scholarship_detail'] = $import_file_key['backlog_range'] = $import_file_key['remarks'] = $import_file_key['esl_elp_detail'] = $import_file_key['applicationmode'] = $import_file_key['detscore'] = $import_file_key['course_details'] = $import_file_key['occupation_outcome'] = $import_file_key['practical_work'] = $import_file_key['course_content'] = $import_file_key['qualify_extended_visa'] = $import_file_key['regional_location'] = $import_file_key['country_students_not_accepted'] = $import_file_key['yearly_tuition_fee'] = $import_file_key['non_tuition_fee'] = '';

        if ($request->file('data_file')) {
            $file = $request->file('data_file');
            $filename = $file->getClientOriginalName();
            $file_ext = $file->getClientOriginalExtension();
            $all_err_msg = $success_msg = array();
            if ($file->getSize() > 0 && in_array($file_ext, $file_allowed_ext)) {
                \Log::debug("Importing Course File:" . $filename);
                $file_path = $file->getRealPath();
                if (($handle = fopen($file_path, "r")) !== FALSE) {
                    $error_count = 0;
                    $i = 0;
                    $j = 0;
                    while (($data = fgetcsv($handle)) !== FALSE) {
                        $i++;
                        try{
                            if($error_count >= 25){
                                break;
                            }

                            $data[0] = preg_replace("/\xEF\xBB\xBF/", "", $data[0]);
                            
                            if ($data[0] == 'Category ID') {
                                $serial_no_column = true;
                                $import_file_key['category'] = $import_file_key['sub-category'] = $import_file_key['university'] = $import_file_key['course_name'] = $import_file_key['concentration'] = $import_file_key['website_url'] = $import_file_key['campus'] = $import_file_key['country'] =  $import_file_key['study_level'] = $import_file_key['duration'] = $import_file_key['intakes'] = $import_file_key['year'] = $import_file_key['gre_score'] = $import_file_key['gmat_score'] = $import_file_key['entry_requirements'] = $import_file_key['ielts_score'] =  $import_file_key['ielts_no_band_less_than'] = $import_file_key['tofel_score'] = $import_file_key['tofel_no_band_less_than'] = $import_file_key['pte_score'] = $import_file_key['pte_no_band_less_than'] = $import_file_key['application_deadline'] = $import_file_key['application_fee'] = $import_file_key['scholarship_available'] = $import_file_key['scholarship_detail'] = $import_file_key['backlog_range'] = $import_file_key['remarks'] = $import_file_key['esl_elp_detail'] = $import_file_key['applicationmode'] = $import_file_key['detscore'] = $import_file_key['course_details'] = $import_file_key['occupation_outcome'] = $import_file_key['practical_work'] = $import_file_key['course_content'] = $import_file_key['qualify_extended_visa'] = $import_file_key['regional_location'] = $import_file_key['country_students_not_accepted'] = $import_file_key['yearly_tuition_fee'] = $import_file_key['non_tuition_fee'] = '';
                                
                                foreach ($data as $key => $value) {
                                    $formated_value = trim($this->getFormatedText($value));
                                    if ($formated_value == 'category-id') {
                                        $import_file_key['category'] = $key;
                                    } else if ($formated_value == 'sub-category') {
                                        $import_file_key['sub-category'] = $key;
                                    } else if ($formated_value == 'university') {
                                        $import_file_key['university'] = $key;
                                    } else if ($formated_value == 'name') {
                                        $import_file_key['course_name'] = $key;
                                    } else if ($formated_value == 'concentration') {
                                        $import_file_key['concentration'] = $key;
                                    } else if ($formated_value == 'website-url') {
                                        $import_file_key['website_url'] = $key;
                                    } else if ($formated_value == 'campus') {
                                        $import_file_key['campus'] = $key;
                                    } else if ($formated_value == 'country') {
                                        $import_file_key['country'] = $key;
                                    } else if ($formated_value == 'study-level') {
                                        $import_file_key['study_level'] = $key;
                                    } else if ($formated_value == 'duration') {
                                        $import_file_key['duration'] = $key;
                                    } else if ($formated_value == 'intakes') {
                                        $import_file_key['intakes'] = $key;
                                    } else if ($formated_value == 'year') {
                                        $import_file_key['year'] = $key;
                                    } else if ($formated_value == 'entry-requirements') {
                                        $import_file_key['entry_requirements'] = $key;
                                    } else if ($formated_value == 'ielts-score') {
                                        $import_file_key['ielts_score'] = $key;
                                    } else if ($formated_value == 'ielts-no-band-less-than') {
                                        $import_file_key['ielts_no_band_less_than'] = $key;
                                    } else if ($formated_value == 'tofel-score' || $formated_value == 'toefl-score') {
                                        $import_file_key['tofel_score'] = $key;
                                    } else if ($formated_value == 'tofel-no-band-less-than' || $formated_value == 'toefl-no-band-less-than') {
                                        $import_file_key['tofel_no_band_less_than'] = $key;
                                    } else if ($formated_value == 'pte-score') {
                                        $import_file_key['pte_score'] = $key;
                                    } else if ($formated_value == 'pte-no-band-less-than') {
                                        $import_file_key['pte_no_band_less_than'] = $key;
                                    } else if ($formated_value == 'gre-score') {
                                        $import_file_key['gre_score'] = $key;
                                    } else if ($formated_value == 'gmat-score') {
                                        $import_file_key['gmat_score'] = $key;
                                    } else if ($formated_value == 'application-deadline') {
                                        $import_file_key['application_deadline'] = $key;
                                    } else if ($formated_value == 'application-fee') {
                                        $import_file_key['application_fee'] = $key;
                                    } 

                                    // Newly added fields
                                    else if ($formated_value == 'yearly-tuition-fees') {
                                        $import_file_key['yearly_tuition_fee'] = $key;
                                    } 
                                    else if ($formated_value == 'course-details') {
                                        $import_file_key['course_details'] = $key;
                                    } 
                                    else if ($formated_value == 'occupation-outcome') {
                                        $import_file_key['occupation_outcome'] = $key;
                                    } 
                                    else if ($formated_value == 'practical-work') {
                                        $import_file_key['practical_work'] = $key;
                                    } 
                                    else if ($formated_value == 'course-content') {
                                        $import_file_key['course_content'] = $key;
                                    } 
                                    else if ($formated_value == 'qualify-extended-visa') {
                                        $import_file_key['qualify_extended_visa'] = $key;
                                    } 
                                    else if ($formated_value == 'regional-location') {
                                        $import_file_key['regional_location'] = $key;
                                    } 
                                    else if ($formated_value == 'country-students-not-accepted') {
                                        $import_file_key['country_students_not_accepted'] = $key;
                                    } 
                                    else if ($formated_value == 'non-tuition-fee') {
                                        $import_file_key['non_tuition_fee'] = $key;
                                    } 
                                    // Newly added fields                               
                                    
                                    else if ($formated_value == 'scholarship-available') {
                                        $import_file_key['scholarship_available'] = $key;
                                    } else if ($formated_value == 'scholarship-detail') {
                                        $import_file_key['scholarship_detail'] = $key;
                                    } else if ($formated_value == 'backlog-range') {
                                        $import_file_key['backlog_range'] = $key;
                                    } else if ($formated_value == 'remarks') {
                                        $import_file_key['remarks'] = $key;
                                    } else if ($formated_value == 'esl-elp-detail') {
                                        $import_file_key['esl_elp_detail'] = $key;
                                    } else if ($formated_value == 'application-mode') {
                                        $import_file_key['applicationmode'] = $key;
                                    } else if ($formated_value == 'detscore') {
                                        $import_file_key['detscore'] = $key;
                                    }
                                }
                                continue;
                            }
                            
                            if (!empty($import_file_key) && !empty($import_file_key['university']) && !empty($import_file_key['course_name']) && $import_file_key['category']!="" && !empty($import_file_key['country']) && !empty($import_file_key['campus']) && !empty($import_file_key['study_level'])) {
                                $valid_column_header = true;
                            }
                           
                            if ($serial_no_column && $valid_column_header) {
                                $insert_data = $insert_university_data = array();
                                $serial_no = $data[0];
                                $err_msg = array();

                                
                                $university_name = trim($data[$import_file_key['university']]);
                                
                                $country = trim($data[$import_file_key['country']]);
                                $category = trim($data[$import_file_key['category']]);
                                // $sub_category = trim($data[$import_file_key['sub-category']]);
                                
                                // if($category != ""){
                                //     $category_for_print = $category;
                                // }

                                // // cat = select id from ucc where name=<category> and parent=0
                                // // subcatid = select id from ucc where name=<sub category> and parent=<cat>

                                // $length = 5;
                                // $randomletter = substr(str_shuffle("123456789"), 0, $length);

                                // $category = str_replace(" and ", " & ", $category);
                                // dd($category);
                                // exit();
                                // $sub_category = str_replace(" and ", " & ", $sub_category);
                                // $cat = DB::table('university_course_categories')->where('title', "=", $category)->where('parent_id', 0)->first();
                                // $cat_id = 0;
                                // $sub_cat = 0;
                                // $sub_cat_id = 0;
                                // if(!$cat){
                                //     // Create the parent category
                                //     \Log::debug("Creating the parent category...." . $category);
                                //     $universityCourseCategories = new UniversityCourseCategories;
                                //     $universityCourseCategories->title = $category;
                                //     $universityCourseCategories->status = 1;
                                //     $universityCourseCategories->parent_id = 0;
                                //     $universityCourseCategories->display_order = 99;
                                //     $universityCourseCategories->seo_url_slug = $this->getFormatedText($category).$randomletter;
                                //     $universityCourseCategories->save();

                                //     // Creating the sub category
                                //     \Log::debug("Creating the child category...." . $sub_category);
                                //     $universityCourseChildCategories = new UniversityCourseCategories;
                                //     $universityCourseChildCategories->title = $sub_category;
                                //     $universityCourseChildCategories->status = 1;
                                //     $universityCourseChildCategories->parent_id = $universityCourseCategories->id;
                                //     $universityCourseChildCategories->display_order = 99;
                                //     $universityCourseChildCategories->seo_url_slug = $this->getFormatedText($sub_category).$randomletter;
                                //     $universityCourseChildCategories->save();

                                //     $category = $universityCourseChildCategories->id;
                                // } else{
                                //     // Check sub category
                                //     $cat_id = $cat->id;
                                //     $sub_cat = DB::table('university_course_categories')->where('title', "=", $sub_category)->where('parent_id', $cat_id)->first();

                                //     if(!$sub_cat){
                                //         // Crreate sub category
                                //         \Log::debug("Creating the child category...." . $sub_category);
                                //         $universityCourseChildCategories = new UniversityCourseCategories;
                                //         $universityCourseChildCategories->title = $sub_category;
                                //         $universityCourseChildCategories->status = 1;
                                //         $universityCourseChildCategories->parent_id = $cat_id;
                                //         $universityCourseChildCategories->display_order = 99;
                                //         $universityCourseChildCategories->seo_url_slug = $this->getFormatedText($sub_category).$randomletter;
                                //         $universityCourseChildCategories->save();

                                //         $category = $universityCourseChildCategories->id;
                                //     } else{
                                //         \Log::debug("Parent abd Child category is present....");
                                //         $category = $sub_cat->id;
                                //     }
                                // }

                                // check Sub-category ----- Now I have commented the code
                                if (!DB::table('university_course_categories')
                                    ->where('id', $category)
                                    // ->where('parent_id','!=',0)
                                    ->exists()) {
                                    $err_msg[] = "Row: " . $i . " Sub-category(Discipline Area) '" . $category . "' not found!";
                                    $all_err_msg = array_merge($all_err_msg, $err_msg);
                                    $error_count++;
                                    continue;
                                }

                                //check Study level data exist-----
                                $study_level_check = trim($data[$import_file_key['study_level']]);

                                if(isset($study_level_check) && $study_level_check != "") {
                                    \Log::debug("Checking Study Level");
                                    if (!in_array($study_level_check, get_study_levels())) {
                                        if($request->input('create_study_level'))  {
                                            $has_header = $request->input('create_study_level');
                                            \Log::debug("Creating Study Level....");
                                            $degree = "";
                                            $study_level_first_word = explode(' ', trim($study_level_check ))[0];

                                            if($study_level_first_word == "Diploma"){
                                                $degree = "Pre-bachelors";
                                            } elseif($study_level_first_word == "Advanced"){
                                                $degree = "Pre-bachelors";
                                            } elseif($study_level_first_word == "Primary"){
                                                $degree = "Pre-bachelors";
                                            } elseif($study_level_first_word == "Senior"){
                                                $degree = "Pre-bachelors";
                                            } elseif($study_level_first_word == "Attestation"){
                                                $degree = "Pre-bachelors";
                                            } elseif($study_level_first_word == "Grade"){
                                                $degree = "Pre-bachelors";
                                            } elseif($study_level_first_word == "Summer"){
                                                $degree = "Pre-bachelors";
                                            } elseif($study_level_first_word == "UG"){
                                                $degree = "Pre-bachelors";
                                            } 
                                            elseif($study_level_first_word == "Bachelor" || $study_level_first_word == "Bachelors"){
                                                $degree = "Bachelors";
                                            } elseif($study_level_first_word == "Dual"){
                                                $degree = "Bachelors";
                                            } elseif($study_level_first_word == "Associate"){
                                                $degree = "Bachelors";
                                            } elseif($study_level_first_word == "Associate"){
                                                $degree = "Bachelors";
                                            } elseif($study_level_first_word == "Baccalaureate"){
                                                $degree = "Bachelors";
                                            } elseif($study_level_first_word == "Combined"){
                                                $degree = "Bachelors";
                                            } elseif($study_level_first_word == "Double"){
                                                $degree = "Bachelors";
                                            } elseif($study_level_first_word == "Pre-Master"){
                                                $degree = "Bachelors";
                                            } elseif($study_level_first_word == "Undergraduate"){
                                                $degree = "Bachelors";
                                            } elseif($study_level_first_word == "Graduate"){
                                                $degree = "Bachelors";
                                            } elseif($study_level_first_word == "UG+PG"){
                                                $degree = "Bachelors";
                                            } elseif($study_level_check == "Twinning Programmes (UG)"){
                                                $degree = "Bachelors";
                                            }
                                            elseif($study_level_first_word == "Master's"){
                                                $degree = "Masters";
                                            } elseif($study_level_first_word == "Postgraduate"){
                                                $degree = "Masters";
                                            } elseif($study_level_first_word == "PG"){
                                                $degree = "Masters";
                                            } elseif($study_level_check == "Twinning Programmes (PG)"){
                                                $degree = "Masters";
                                            }
                                            elseif($study_level_first_word == "Doctorate"){
                                                $degree = "Ph.D";
                                            } elseif($study_level_first_word == "PhD"){
                                                $degree = "Ph.D";
                                            }
                                            else{
                                                $degree = "Others";
                                            }

                                            $dispaly_order = 1;

                                            $study_level = new StudyLevels();
                                            $study_level->study_level = $study_level_check;
                                            $study_level->degree = $degree;
                                            $study_level->display_order = $dispaly_order;
                                            $study_level->save();

                                            \Log::debug("Study Levels Created:" . $study_level_check);
                                        }else{
                                            $has_header = 0;
                                            $err_msg[] = "Row: " . $i . " Study Level '" . $study_level_check . "' not found in System.";
                                            $all_err_msg = array_merge($all_err_msg, $err_msg);
                                            $error_count++;
                                            $i++;
                                            continue;
                                        }
                                    }
                                }
                                //  else {
                                //     $study_level = $study_level_check;
                                // }

                                //check country data exist-----
                                if($country == 'United States of America' || $country == 'United States America' || $country == 'United States of America (USA)' || $country == 'United States (USA)' || $country == 'United States') {
                                    $country = 'USA';
                                } elseif($country == 'UAE' || $country == 'United Arab Emirates (UAE)' || $country == 'Dubai') {
                                    $country = 'United Arab Emirates';
                                } elseif($country == 'UK' || $country == 'United Kingdom (UK)') {
                                    $country = 'United Kingdom';
                                }
                                
                                $countrydata = DB::table('countries')
                                    ->where('title_en', '=', $country)
                                    ->first();

                                if (!$countrydata) {
                                    $err_msg[] = "Row: " . $i . " Country '" . $country . "' not found in DB.";
                                    $all_err_msg = array_merge($all_err_msg, $err_msg);
                                    $error_count++;
                                    continue;
                                    // $countrydetails = new Countries;
                                    // $countrydetails->country = $country;
                                    // $countrydetails->save();
                                    // $country_id = DB::getPdo()->lastInsertId();
                                } else {
                                    $country_id = $countrydata->id;
                                }
                                
                                //check university data exist-----
                                $university_name = mb_convert_encoding($university_name, 'UTF-8', 'ISO-8859-1');
                                $univstydata = DB::table('universities')
                                    ->where('university_name',  'like', $university_name)
                                    ->where('country', $country_id)
                                    ->first();
                                if (!isset($univstydata->id)) {
                                    /*$err_msg[] = "Row: ".$serial_no." University ".$university_name." not supported!";
                                    $all_err_msg = array_merge($all_err_msg, $err_msg);
                                    break;*/
                                    $storedetails = new Universities;
                                    $storedetails->university_name = $university_name;
                                    $storedetails->country = $country_id;
                                    $storedetails->save();
                                    $university_id = DB::getPdo()->lastInsertId();
                                } else {
                                    $university_id = $univstydata->id;
                                }
                                $insert_data['course_name'] = trim($data[$import_file_key['course_name']]);
                                $insert_data['category'] = $category;
                                $insert_data['university'] = $university_id;
                                //$insert_data['year'] = str_replace(' ','',trim($data[$import_file_key['year']]));
                                if ($data[$import_file_key['study_level']] != '') {
                                    $insert_data['study_level'] = trim($data[$import_file_key['study_level']]);
                                }
                                
                                if ($import_file_key['concentration'] && $data[$import_file_key['concentration']] != '') {
                                    $insert_data['concentration'] = trim($data[$import_file_key['concentration']]);
                                } else {
                                    $insert_data['concentration'] = "";
                                }

                                if ($import_file_key['campus'] && $data[$import_file_key['campus']] != '') {
                                    $insert_data['campus'] = trim($data[$import_file_key['campus']]);
                                } else {
                                    $insert_data['campus'] = "";
                                }

                                //Optional columns
                                if ($import_file_key['intakes'] && $data[$import_file_key['intakes']]) {
                                    $insert_data['intakes'] = str_replace(' ','',trim($data[$import_file_key['intakes']]));
                                }

                                if ($import_file_key['duration'] && $data[$import_file_key['duration']] != '') {
                                    $insert_data['duration'] = trim($data[$import_file_key['duration']]);
                                }else{
                                    $insert_data['duration'] = NULL;
                                }
                                if ($import_file_key['website_url'] && $data[$import_file_key['website_url']] != '') {
                                    $insert_data['website_url'] = trim($data[$import_file_key['website_url']]);
                                }
                                if ($import_file_key['entry_requirements'] && $data[$import_file_key['entry_requirements']] != '') {
                                    $insert_data['entry_requirements'] = get_utf8_string(trim($data[$import_file_key['entry_requirements']]));
                                }

                                if ($import_file_key['ielts_score'] && $data[$import_file_key['ielts_score']] != '') {
                                    $insert_data['ielts_score'] = trim($data[$import_file_key['ielts_score']]);
                                }

                                if ($import_file_key['ielts_no_band_less_than'] && $data[$import_file_key['ielts_no_band_less_than']] != '') {
                                    $insert_data['ielts_no_band_less_than'] = trim($data[$import_file_key['ielts_no_band_less_than']]);
                                }

                                if ($import_file_key['tofel_score'] && $data[$import_file_key['tofel_score']] != '') {
                                    $insert_data['toefl_score'] = trim($data[$import_file_key['tofel_score']]);
                                }

                                if ($import_file_key['tofel_no_band_less_than'] && $data[$import_file_key['tofel_no_band_less_than']] != '') {
                                    $insert_data['toefl_no_band_less_than'] = trim($data[$import_file_key['tofel_no_band_less_than']]);
                                }
                                if ($import_file_key['pte_score'] && $data[$import_file_key['pte_score']]) {
                                    $insert_data['pte_score'] = trim($data[$import_file_key['pte_score']]);
                                }

                                if ($import_file_key['pte_no_band_less_than'] && $data[$import_file_key['pte_no_band_less_than']] != '') {
                                    $insert_data['pte_no_band_less_than'] = trim($data[$import_file_key['pte_no_band_less_than']]);
                                }

                                if ($import_file_key['gre_score'] && $data[$import_file_key['gre_score']] != '') {
                                    $insert_data['gre_score'] = trim($data[$import_file_key['gre_score']]);
                                }

                                if ($import_file_key['gmat_score'] && $data[$import_file_key['gmat_score']] != '') {
                                    $insert_data['gmat_score'] = trim($data[$import_file_key['gmat_score']]);
                                }

                                if ($import_file_key['application_deadline'] && $data[$import_file_key['application_deadline']] != '') {
                                    $insert_data['application_deadline'] = trim($data[$import_file_key['application_deadline']]);
                                }

                                if ($import_file_key['application_fee'] && $data[$import_file_key['application_fee']] != '') {
                                    $insert_data['application_fee'] = trim($data[$import_file_key['application_fee']]);
                                    if(isset($insert_data['application_fee']) && $insert_data['application_fee'] != "") {
                                        $currency_and_application_fee = $insert_data['application_fee'];
                                        $application_fee_currency = get_currency_code_from_symbol($currency_and_application_fee);
                                        $insert_data['currency'] = $application_fee_currency;
                                        $insert_data['application_fee'] = preg_replace('/[^0-9.]/', '', $insert_data['application_fee']);
                                    }
                                }
                                if ($import_file_key['yearly_tuition_fee'] && $data[$import_file_key['yearly_tuition_fee']] != '') {
                                    $insert_data['yearly_tuition_fee'] = trim($data[$import_file_key['yearly_tuition_fee']]);
                                    //Change Yearly Tution Fee  
                                    if(isset($insert_data['yearly_tuition_fee']) && $insert_data['yearly_tuition_fee'] != '') {
                                        $currency_and_tution_fee = $insert_data['yearly_tuition_fee'];
                                        $tution_fee_currency = get_currency_code_from_symbol($currency_and_tution_fee);
                                        $insert_data['currency'] = $tution_fee_currency;
                                        $insert_data['yearly_tuition_fee'] = preg_replace('/[^0-9.]/', '', $currency_and_tution_fee);
                                    }
                                }
                                if ($import_file_key['non_tuition_fee'] && $data[$import_file_key['non_tuition_fee']] != '') {
                                    $insert_data['non_tuition_fee'] = trim($data[$import_file_key['non_tuition_fee']]);
                                    // Newly added columns
                                    if(isset($insert_data['non_tuition_fee']) && $insert_data['non_tuition_fee'] != '') {
                                        $currency_and_non_tution_fee = $insert_data['non_tuition_fee'];
                                        $non_application_fee_currency = get_currency_code_from_symbol($currency_and_non_tution_fee);
                                        $insert_data['currency'] = $non_application_fee_currency;
                                        $insert_data['non_tuition_fee'] = preg_replace('/[^0-9.]/', '', $insert_data['non_tuition_fee']);
                                    }
                                }
                
                                if ($import_file_key['course_details'] && $data[$import_file_key['course_details']] != '') {
                                    $insert_data['course_details'] = trim($data[$import_file_key['course_details']]);
                                }
                                if ($import_file_key['course_content'] && $data[$import_file_key['course_content']] != '') {
                                    $insert_data['course_content'] = trim($data[$import_file_key['course_content']]);
                                }
                                if ($import_file_key['occupation_outcome'] && $data[$import_file_key['occupation_outcome']] != '') {
                                    $insert_data['occupation_outcome'] = trim($data[$import_file_key['occupation_outcome']]);
                                }
                                if ($import_file_key['practical_work'] && $data[$import_file_key['practical_work']] != '') {
                                    $insert_data['practical_work'] = trim($data[$import_file_key['practical_work']]);
                                }
                                if ($import_file_key['qualify_extended_visa'] && $data[$import_file_key['qualify_extended_visa']] != '') {
                                    $insert_data['qualify_extended_visa'] = trim($data[$import_file_key['qualify_extended_visa']]);
                                }
                                if ($import_file_key['regional_location'] && $data[$import_file_key['regional_location']] != '') {
                                    $insert_data['regional_location'] = trim($data[$import_file_key['regional_location']]);
                                }
                                if ($import_file_key['country_students_not_accepted'] && $data[$import_file_key['country_students_not_accepted']] != '') {
                                    $insert_data['country_students_not_accepted'] = trim($data[$import_file_key['country_students_not_accepted']]);
                                }
                                // Newly added columns


                                if ($import_file_key['scholarship_available'] && $data[$import_file_key['scholarship_available']] != '') {
                                    $insert_data['scholarship_available'] = trim($data[$import_file_key['scholarship_available']]);
                                }

                                if ($import_file_key['scholarship_detail'] && $data[$import_file_key['scholarship_detail']] != '') {
                                    $insert_data['scholarship_detail'] = get_utf8_string(trim($data[$import_file_key['scholarship_detail']]));
                                }

                                if ($import_file_key['backlog_range'] && $data[$import_file_key['backlog_range']] != '') {
                                    $insert_data['backlog_range'] = trim($data[$import_file_key['backlog_range']]);
                                }

                                if ($import_file_key['remarks'] && $data[$import_file_key['remarks']] != '') {
                                    $insert_data['remarks'] = get_utf8_string(trim($data[$import_file_key['remarks']]));
                                }

                                if ($import_file_key['esl_elp_detail'] && $data[$import_file_key['esl_elp_detail']] != '') {
                                    $insert_data['esl_elp_detail'] = get_utf8_string(trim($data[$import_file_key['esl_elp_detail']]));
                                }

                                if ($import_file_key['applicationmode'] && $data[$import_file_key['applicationmode']] != '') {
                                    $insert_data['applicationmode'] = trim($data[$import_file_key['applicationmode']]);
                                }

                                if ($import_file_key['detscore'] && $data[$import_file_key['detscore']] != '') {
                                    $insert_data['detscore'] = trim($data[$import_file_key['detscore']]);
                                }

                                $insert_data['status'] = 1;
                                // $insert_data['lead_status'] = 1;
                                \Log::debug("INSERT/UPDATE:". $insert_data['course_name'] ."|". $university_id ."|". $category ."|". $insert_data['campus'] ."|". $insert_data['study_level']);
                                // if ($insert_data['course_name'] != '' && $university_id != '' && $category != '' && $insert_data['campus'] != '' && $insert_data['study_level'] != '') {
                                if ($insert_data['course_name'] != '' && $university_id != '' && $category != '' && $insert_data['study_level'] != '') {

                                    \Log::debug("INSERT/UPDATE:".print_r($insert_data, true));
                                    $coursedata = DB::table('university_courses')
                                        ->where('course_name', $insert_data['course_name'])
                                        ->where('university', $university_id)
                                        ->where('category', $category)
                                        ->where('study_level', $insert_data['study_level'])
                                        ->where('campus', $insert_data['campus'])
                                        ->where('duration', $insert_data['duration'])
                                        ->first();
                                    $UniversityCourses = new UniversityCourses;
                                    if (!isset($coursedata->id)) {
                                        $UniversityCourses->create($insert_data);
                                        $created_cnt++;
                                    } else {
                                        $UniversityCourses->where('id', $coursedata->id)->update($insert_data);
                                        $updated_cnt++;
                                    }
                                } else {
                                    $err_msg[] = 'Mandatory fields missing in Serial number:' . $i;
                                }
                            } elseif (!$serial_no_column) {
                                
                                $err_msg[] = "File format issue. Category ID Not found. First Column must be Category ID";
                                $all_err_msg = array_merge($all_err_msg, $err_msg);
                                break;
                            } elseif (!$valid_column_header) {
                                $err_msg[] = "File format issue. Invalid Header Name(s) : [Category ID/ Course Name/ University/ Country/ Campus/ Study Level]";
                                $all_err_msg = array_merge($all_err_msg, $err_msg);
                                break;
                            }
                            $all_err_msg = array_merge($all_err_msg, $err_msg);
                        } catch(\Exception $e){
                            $message = array();
                            $message[] = $e->getMessage();
                            $all_err_msg = array_merge($all_err_msg, $message);
                            // \Log::debug("ERROR: " . $message);
                        } 
                    }
                    fclose($handle);
                }

                // if (empty($all_err_msg)) {
                //     if($updated_cnt){
                //         $currentPage = 'course';
                //         return redirect()->route('admin.import-export.index', $currentPage)->withFlashSuccess($created_cnt . ' Courses data imported and '.$updated_cnt.' Courses data updated successfully');
                //     } else{
                //         $currentPage = 'course';
                //         return redirect()->route('admin.import-export.index', $currentPage)->withFlashSuccess($created_cnt . ' Courses data imported successfully');
                //     }
                // }

                if (empty($all_err_msg)) {
                    if($updated_cnt){
                        $currentPage = 'course';
                        return redirect()->route('admin.import-export.index', $currentPage)->with("result_title", "<strong>Predefined CSV Import Results: </strong>")->withFlashSuccess($created_cnt . ' Courses data imported and '.$updated_cnt.' Courses data updated successfully.');
                    } else{
                        $currentPage = 'course';
                        return redirect()->route('admin.import-export.index', $currentPage)->with("result_title", "<strong>Predefined CSV Import Results: </strong>")->withFlashSuccess($created_cnt . ' Courses data imported successfully.');
                    }
                }else{
                    if($updated_cnt){
                        $currentPage = 'course';
                        return redirect()->route('admin.import-export.index', $currentPage)->with("result_title", "<strong>Predefined CSV Import Results: </strong>")->with('flash_success', $created_cnt . ' Courses data imported and '.$updated_cnt.' Courses data updated successfully.')->with('flash_danger',implode('<br>',$all_err_msg));
                    } else{
                        $currentPage = 'course';
                        return redirect()->route('admin.import-export.index', $currentPage)->with("result_title", "<strong>Predefined CSV Import Results: </strong>")->with('flash_success', $created_cnt . ' Courses data imported successfully.')->with('flash_danger',implode('<br>',$all_err_msg));
                    }
                }
            } else {
                $err_msg[] = 'File Format Error!!! Allowed file format is .csv';
                $all_err_msg = array_merge($all_err_msg, $err_msg);
                $currentPage = 'course';
                return redirect()->route('admin.import-export.index', $currentPage)->with("result_title", "<strong>Predefined CSV Import Results: </strong>")->with('flash_danger',implode('<br>',$all_err_msg));
            }
        }

        // $userRepo = new UserRepository();
        // $staff = $userRepo->getNonStudentsTrainers();
        // $courseCategory = DB::table('university_course_categories')->get();
        // $currentPage = 'course';
        // return view('backend.import_export.index', ['currentPage' => $currentPage, 'staff' => $staff, 'courseCategory' => $courseCategory, 'import_errors' => $all_err_msg, 'import_success' => $success_msg]);
    }


    public function anyCsvLeads(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('import'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $request->validate([
            'data_file' => 'required|mimes:csv,txt',
            'assign_to' => 'required',
        ]);

        if ($request->file('data_file')) {
            $file = $request->file('data_file');
            if ($file->getSize() > 0) {
                $file_path = $file->store('private/tmp');
                $file_path = "app/".$file_path;
                if (($handle = fopen(storage_path($file_path), "r")) !== FALSE) {
                    $i = 0;
                    $header_row = array();
                    $header_row2 = array();
                    $header_row3 = array();

                    while (($data = fgetcsv($handle)) !== FALSE) {

                        $data[0] = preg_replace("/\xEF\xBB\xBF/", "", $data[0]);
                        if($i == 0) {
                            $j=0;
                            foreach($data as $col) {
                                $header_row[$j++] = trim($col);
                            }
                        }elseif($i == 1){
                            if(!$data[0])
                                break;
                            $j=0;
                            foreach($data as $col) {
                                $header_row2[$j++] = trim($col);
                            }
                        }elseif($i == 2){
                            if(!$data[0])
                                break;
                            $j=0;
                            foreach($data as $col) {
                                $header_row3[$j++] = trim($col);
                            }
                        }
                        $i++;
                        if($i==3) {
                            break;
                        }
                    }

                } else {
                    return redirect()->back()->withFlashDanger("Error: Cannot read file");
                }

                $assign_to = $request->input('assign_to'); 
                // $branch = $request->input('branch');
                $branch = empty($request->input('branch')) ? '1' : $request->input('branch');        
                if($request->input('has_header'))  {
                    $has_header = $request->input('has_header');
                }else{
                    $has_header = 0;
                }
                if($request->input('set_followup_today'))  {
                    $set_followup_today = $request->input('set_followup_today');
                }else{
                    $set_followup_today = 0;
                }

                return view('backend.import_export.anycsv-leads', ['file' => $file_path, 'header_row' => $header_row,  'header_row2' => $header_row2,  'header_row3' => $header_row3,  'assign_to' => $assign_to,'branch'=>$branch, 'has_header' => $has_header, 'set_followup_today' => $set_followup_today]);
            } else {
                return redirect()->back()->withFlashDanger("Error: File size error");
            }
        } else {
            return redirect()->back()->withFlashDanger("Error: File upload error");
        }
    }

    public function anyCsvCourseManagement(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('import'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }

        $request->validate([
            'data_file' => 'required|mimes:csv,txt',
            // 'category' => 'required',
        ]);

        if ($request->file('data_file')) {
            $file = $request->file('data_file');
            if ($file->getSize() > 0) {
                $file_path = $file->store('private/tmp');
                $file_path = "app/".$file_path;
                if (($handle = fopen(storage_path($file_path), "r")) !== FALSE) {
                    $i = 0;
                    $header_row = array();
                    $header_row2 = array();
                    $header_row3 = array();

                    while (($data = fgetcsv($handle)) !== FALSE) {

                        $data[0] = preg_replace("/\xEF\xBB\xBF/", "", $data[0]);
                        if($i == 0) {
                            $j=0;
                            foreach($data as $col) {
                                $header_row[$j++] = trim($col);
                            }
                        }elseif($i == 1){
                            if(!$data[0])
                                break;
                            $j=0;
                            foreach($data as $col) {
                                $header_row2[$j++] = trim($col);
                            }
                        }elseif($i == 2){
                            if(!$data[0])
                                break;
                            $j=0;
                            foreach($data as $col) {
                                $header_row3[$j++] = trim($col);
                            }
                        }
                        $i++;
                        if($i==3) {
                            break;
                        }
                    }

                } else {
                    return redirect()->back()->withFlashDanger("Error: Cannot read file");
                }

                $category = $request->input('category');  
                if($request->input('has_header'))  {
                    $has_header = $request->input('has_header');
                }else{
                    $has_header = 0;
                }  

                if($request->input('create_study_level'))  {
                    $has_study_level = $request->input('create_study_level');
                }else{
                    $has_study_level = 0;
                }

                return view('backend.import_export.anycsv-courseManagement', ['file' => $file_path, 'header_row' => $header_row, 'header_row2' => $header_row2, 'header_row3' => $header_row3,  'category' => $category, 'has_header' => $has_header,'has_study_level'=>$has_study_level]);
            } else {
                return redirect()->back()->withFlashDanger("Error: File size error");
            }
        } else {
            return redirect()->back()->withFlashDanger("Error: File upload error");
        }
    }

    public function anyCsvUniversityCourseManagement(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('import'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $request->validate([
            'data_file' => 'required|mimes:csv,txt',
            'country' => 'required',
            'university' => 'required',
        ]);
        if ($request->file('data_file')) {
            $file = $request->file('data_file');
            if ($file->getSize() > 0) {
                $file_path = $file->store('private/tmp');
                $file_path = "app/".$file_path;
                if (($handle = fopen(storage_path($file_path), "r")) !== FALSE) {
                    $i = 0;
                    $header_row = array();
                    $header_row2 = array();
                    $header_row3 = array();
                    while (($data = fgetcsv($handle)) !== FALSE) {

                        $data[0] = preg_replace("/\xEF\xBB\xBF/", "", $data[0]);
                        if($i == 0) {
                            $j=0;
                            foreach($data as $col) {
                                $header_row[$j++] = trim($col);
                            }
                        }elseif($i == 1){
                            if(!$data[0])
                                break;
                            $j=0;
                            foreach($data as $col) {
                                $header_row2[$j++] = trim($col);
                            }
                        }elseif($i == 2){
                            if(!$data[0])
                                break;
                            $j=0;
                            foreach($data as $col) {
                                $header_row3[$j++] = trim($col);
                            }
                        }
                        $i++;
                        if($i==3) {
                            break;
                        }
                    }

                } else {
                    return redirect()->back()->withFlashDanger("Error: Cannot read file");
                }
                $category = $request->input('category');  
                if($request->input('has_header'))  {
                    $has_header = $request->input('has_header');
                }else{
                    $has_header = 0;
                }
                $country = $request->input('country'); 
                $university = $request->input('university'); 

                return view('backend.import_export.anycsv-university-courseManagement', ['file' => $file_path, 'header_row' => $header_row, 'header_row2' => $header_row2, 'header_row3' => $header_row3,  'category' => $category, 'has_header' => $has_header,'country' => $country,'university' => $university]);
            } else {
                return redirect()->back()->withFlashDanger("Error: File size error");
            }
        } else {
            return redirect()->back()->withFlashDanger("Error: File upload error");
        }
    }

    public function anyCsvLeadsSave(Request $request){
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('import'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }

        $request->validate([
            'file' => 'required',
            'assign_to' => 'required',
            'has_header' => 'required',
           
        ]);        
        \Log::debug("Lead imported any csv:");
        $columnmap = $request->input('columnmap');
        if(!(in_array("first_name", $columnmap))) {
            unlink(storage_path($request->input('file')));
            $currentPage = 'leads';
            return redirect()->route('admin.import-export.index', $currentPage)->withFlashDanger("First name is required");
        }

        if (($handle = fopen(storage_path($request->input('file')), "r")) !== FALSE) {
            $i = 1;
            $created_cnt =0;
            $err_msg = array();

            while (($data = fgetcsv($handle)) !== FALSE) {
                if($i == 1 && $request->input("has_header")) {
                    $i++;
                    continue;
                }

                $insert_data = array();
                $insert_data_user_detail = array();

                foreach($columnmap as $key => $value) {
                    if($value) {
                        if(isset($data[$key])) {
                            if($value == "lead_campaign_name" || $value == "lead_source_detail" || $value == "passout_year" || $value == "lead_notes" || $value == "highest_level_education"){
                                $insert_data_user_detail[$value] = trim($data[$key]);
                            }else{
                                $insert_data[$value] = trim($data[$key]);
                            }
                        } else {
                            $insert_data[$value] = "";
                        }
                    }
                }

                if(!empty($insert_data['email'])){
                    if(DB::table('users')
                        ->where('email', $insert_data['email'])
                        ->exists()){
                            $err_msg[] = 'Row:' . $i . ", Error: Lead With Email '".$insert_data['email']."' Already Exists!";
                            $i++;
                            continue;
                    }
                }

                // Checking dialcode is valid or not
                if(!empty($insert_data['dialcode'])){
                    if (!is_numeric($insert_data['dialcode'])) { 
                        $err_msg[] = 'Row:' . $i . ", Error: Dialcode number '" .$insert_data['dialcode']. "' Invalid Dialcode Format!";
                        $i++;
                        continue;
                    }
                }

                // Checking mobile number length and it contain number or not
                if(!empty($insert_data['mobile'])){
                    if (!is_numeric($insert_data['mobile'])) { 
                        $err_msg[] = 'Row:' . $i . ", Error: Mobile number '" .$insert_data['mobile']. "' Invalid Mobile Number Format!";
                        $i++;
                        continue;
                    }
                    if(strlen($insert_data['mobile']) > config('app.USER_MOBILE_MAX_LENGTH') || strlen($insert_data['mobile']) < config('app.USER_MOBILE_MIN_LENGTH')){
                        $err_msg[] = 'Row:' . $i . ", Error: Mobile number '" .$insert_data['mobile']. "' Invalid Number Length!";
                        $i++;
                        continue;
                    }
                    if(DB::table('users')
                        ->where('mobile', $insert_data['mobile'])
                        ->exists()){
                            $err_msg[] = 'Row:' . $i . ", Error: Lead With Mobile '".$insert_data['mobile']."' Already Exists!";
                            $i++;
                            continue;
                    }
                }

                if(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email'){
                    if(!isset($insert_data['email']) || $insert_data['email'] == ""){
                        $err_msg[] = 'Mandatory fields (Email) missing in Row:' . $i;
                        $i++;
                        continue;
                    }else{
                        if(DB::table('users')
                            ->where('email', $insert_data['email'])
                            ->exists()){
                                $err_msg[] = 'Row:' . $i . ", Error: Lead With Email '".$insert_data['email']."' Already Exists!";
                                $i++;
                                continue;
                        }
                    }
                } elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_and_mobile'){
                    if((!isset($insert_data['email']) || $insert_data['email'] == "") || (!isset($insert_data['mobile']) || $insert_data['mobile'] == "")){
                        $err_msg[] = 'Mandatory fields (Email and Mobile) missing in Row:' . $i;
                        $i++;
                        continue;
                    }else{
                        if(DB::table('users')
                            ->where('email', $insert_data['email'])
                            ->exists()){
                                $err_msg[] = 'Row:' . $i . ", Error: Lead With Email '".$insert_data['email']."' Already Exists!";
                                $i++;
                                continue;
                        }
                        if(DB::table('users')
                            ->where('mobile', $insert_data['mobile'])
                            ->exists()){
                                $err_msg[] = 'Row:' . $i . ", Error: Lead With Mobile '".$insert_data['mobile']."' Already Exists!";
                                $i++;
                                continue;
                        }
                    }
                } elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_or_mobile'){
                    if((!isset($insert_data['email']) || $insert_data['email'] == "") && (!isset($insert_data['mobile']) || $insert_data['mobile'] == "")){
                        $err_msg[] = 'Mandatory fields (Email or Mobile) missing in Row:' . $i;
                        $i++;
                        continue;
                    }else{
                        if(!empty($insert_data['dialcode'])){
                            if(DB::table('users')
                                ->where('email', $insert_data['email'])
                                ->exists()){
                                    $err_msg[] = 'Row:' . $i . ", Error: Lead With Email '".$insert_data['email']."' Already Exists!";
                                    $i++;
                                    continue;
                            }
                        }
                        if(!empty($insert_data['mobile'])){
                            if(DB::table('users')
                                ->where('mobile', $insert_data['mobile'])
                                ->exists()){
                                    $err_msg[] = 'Row:' . $i . ", Error: Lead With Mobile '".$insert_data['mobile']."' Already Exists!";
                                    $i++;
                                    continue;
                            }
                        }
                    }
                } elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'mobile'){
                    if(!isset($insert_data['mobile']) || $insert_data['mobile'] == ""){
                        $err_msg[] = 'Mandatory fields (Mobile) missing in Row:' . $i;
                        $i++;
                        continue;
                    }else{
                        if(DB::table('users')
                            ->where('mobile', $insert_data['mobile'])
                            ->exists()){
                                $err_msg[] = 'Row:' . $i . ", Error: Lead With Mobile '".$insert_data['mobile']."' Already Exists!";
                                $i++;
                                continue;
                        }
                    }         
                }

                // $type = $request->input('student_type');
                // if ($type == 'Study Abroad')
                //     $insert_data['student_type'] = 'study_abroad';
                // elseif ($type == 'Coaching')
                //     $insert_data['student_type'] = 'course';
                // elseif ($type == 'Study Abroad & Coaching')
                //     $insert_data['student_type'] = 'study_abroad_course';
                // else
                //     $insert_data['student_type'] = NULL;

                $insert_data['student_type'] = 'study_abroad';
                
                if(!empty($insert_data_user_detail['highest_level_education'])){
                    $qualification = $insert_data_user_detail['highest_level_education'];

                    if($qualification == "9th"){
                        $insert_data_user_detail['highest_level_education'] = strtolower($qualification);
                    }elseif($qualification == "10th"){
                        $insert_data_user_detail['highest_level_education'] = strtolower($qualification);
                    }elseif($qualification == "11th"){
                        $insert_data_user_detail['highest_level_education'] = strtolower($qualification);
                    }elseif($qualification == "12th"){
                        $insert_data_user_detail['highest_level_education'] = strtolower($qualification);
                    }elseif($qualification == "Bachelors"){
                        $insert_data_user_detail['highest_level_education'] = strtolower($qualification);
                    }elseif($qualification == "Masters"){
                        $insert_data_user_detail['highest_level_education'] = strtolower($qualification);
                    } else {
                        $err_msg[] = "Row: " . $i . " Qualification '" . $qualification . "' not found in DB!";
                        $i++;
                        continue;                        
                    }
                }
    
                if(!empty($request->input('set_followup_today'))) {
                    $insert_data['next_followup'] = now();
                }
                else{
                    if(isset($insert_data['next_followup']) && strtotime($insert_data['next_followup'])!='' && strpos($insert_data['next_followup'], '/') == false){
                        $insert_data['next_followup'] = date('Y-m-d H:i:s',strtotime($insert_data['next_followup']));
                    }
                    elseif(isset($insert_data['next_followup']) && strpos($insert_data['next_followup'], '/') !== false){
                        $passedDate = $insert_data['next_followup'];
                        $explodedDateTime = explode(" ", $passedDate);
                        if(count($explodedDateTime) == 1){
                            $explodedDateTime = explode("  ", $passedDate);
                            $explodedDate = explode("/", $explodedDateTime[0]);
                            $formattedDate = date("Y-m-d", strtotime($explodedDate[2]."-".$explodedDate[0]."-".$explodedDate[1]));
                        }else{
                            if($explodedDateTime[1]){
                                $explodedDate = explode("/", $explodedDateTime[0]);
                                $explodedTime = explode(":", $explodedDateTime[1]);
                            }else{
                                $explodedDateTime = explode("  ", $passedDate);
                                $explodedDate = explode("/", $explodedDateTime[0]);
                                $explodedTime = explode(":", $explodedDateTime[1]);
                            }
                            $formattedDate = date("Y-m-d", strtotime($explodedDate[2]."-".$explodedDate[0]."-".$explodedDate[1]));
                        }
                        $insert_data['next_followup'] = $formattedDate;
                    }else{
                        $insert_data['next_followup'] = NULL; 
                    }
                }

                if(!isset($insert_data['lead_status']) || $insert_data['lead_status'] == "") {
                    $insert_data['lead_status'] = get_default_lead_status();
                }
                if(!isset($insert_data['country']) || $insert_data['country'] == "") {
                    $insert_data['country'] = env('USER_DEFAULT_COUNTRY');
                }
                if(!isset($insert_data['created_at']) || $insert_data['created_at'] == "") {
                    $insert_data['created_at'] = now();
                }else{
                    if(strtotime($insert_data['created_at']) != '' && strpos($insert_data['created_at'], '/') == false){
                        $insert_data['created_at'] = date('Y-m-d H:i:s', strtotime($insert_data['created_at']));
                    }
                    elseif(strpos($insert_data['created_at'], '/') !== false){
                        $passedDate = $insert_data['created_at'];
                        $explodedDateTime = explode(" ", $passedDate);
                        if(count($explodedDateTime) == 1){
                            $explodedDateTime = explode("  ", $passedDate);
                            $explodedDate = explode("/", $explodedDateTime[0]);

                            $formattedDate = date("Y-m-d", strtotime($explodedDate[2]."-".$explodedDate[0]."-".$explodedDate[1]));
                        }else{
                            if($explodedDateTime[1]){
                                $explodedDate = explode("/", $explodedDateTime[0]);
                                $explodedTime = explode(":", $explodedDateTime[1]);
                            }else{
                                $explodedDateTime = explode("  ", $passedDate);
                                $explodedDate = explode("/", $explodedDateTime[0]);
                                $explodedTime = explode(":", $explodedDateTime[1]);
                            }
                            $formattedDate = date("Y-m-d", strtotime($explodedDate[2]."-".$explodedDate[0]."-".$explodedDate[1]));
                        }
                        $insert_data['created_at'] = $formattedDate;
                    }else{
                        $insert_data['created_at'] = now(); 
                    }
                }                
                
                if(isset($insert_data['birthday']) && $insert_data['birthday']!='') {
                    $insert_data['birthday'] = preg_replace("/(\d+)\D+(\d+)\D+(\d+)/","$3-$2-$1",$insert_data['birthday']);
                }else{
                    $insert_data['birthday'] = NULL;
                }

                $insert_data['assigned_to'] = $request->input('assign_to');
                $insert_data['branch'] = empty($request->input('branch')) ? '1' : $request->input('branch');
                $insert_data['is_lead'] = 1;
                $insert_data['created_mode'] = "import";
                $insert_data['confirmed'] = 1;

                 \Log::debug("Lead imported data:".print_r($insert_data,true));
                if ($insert_data['first_name'] != '') {
                    try {

                        // if(DB::table('users')
                        //     ->where('email', $insert_data['email'])
                        //     ->exists()){
                        //         $err_msg[] = 'Row:' . $i . ", Error: Lead With Email '".$insert_data['email']."' Already Exists!";
                        //         $i++;
                        //         continue;
                        //     }
                        $refcode = generate_refcode($insert_data['first_name']);
                        $insert_data['refcode'] = $refcode;
                        $lead = User::create($insert_data);

                        // $lead->assignRole('user');
                        \Log::debug("Lead imported:" . $lead->first_name . ", " . $lead->email);
                        $created_cnt++;
                        $insert_data_user_detail['userid'] = $lead->id;
                        $userdetails = UserDetails::create($insert_data_user_detail);

                        LeadActivity::create(['lead_id' => $lead->id, 'date' => date("Y-m-d H:i:s"), 'staff' => \Auth::user()->id, 'detail' => "LEAD IMPORTED"]);
                    } catch (\Illuminate\Database\QueryException $ex) {
                        \Log::error("Lead any csv create lead error:".$ex->getMessage());
                        $err_msg[] = 'Row:' . $i . ", Error: Something Went Wrong!";
                    }
                } else {
                    $err_msg[] = 'Mandatory fields missing in Row:' . $i;
                }
                $i++;                
            }
            //exit();
            fclose($handle);
            unlink(storage_path($request->input('file')));
            $currentPage = 'leads';
            return redirect()->route('admin.import-export.index', $currentPage)->with('flash_success',$created_cnt . ' Leads Imported!')->with('flash_danger',implode('<br>',$err_msg));
        } else {
            $currentPage = 'leads';
            return redirect()->route('admin.import-export.index', $currentPage)->withFlashDanger("Error: Cannot read file");
        }
    }

    public function anyCsvCourseSave(Request $request){
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('import'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }

        \Log::debug("Any Csv Course Save Start");

        $request->validate([
            'file' => 'required',
            // 'category' => 'required',
            'has_header' => 'required',           
        ]);  
        
        $all_err_msg = array();

        $columnmap = $request->input('columnmap');
        if(!(in_array("course_name", $columnmap))) {
            unlink(storage_path($request->input('file')));
            $currentPage = "course";
            return redirect()->route('admin.import-export.index', $currentPage)->withFlashDanger("Course Name is required");
        }
        // if(!(in_array("category", $columnmap))) {
        //     unlink(storage_path($request->input('file')));
        //     return redirect()->route('admin.import-export.index')->withFlashDanger("Category are required");
        // }
        if(!(in_array("university", $columnmap))) {
            unlink(storage_path($request->input('file')));
            $currentPage = "course";
            return redirect()->route('admin.import-export.index', $currentPage)->withFlashDanger("University name is required");
        }
        if(!(in_array("country", $columnmap))) {
            unlink(storage_path($request->input('file')));
            $currentPage = "course";
            return redirect()->route('admin.import-export.index', $currentPage)->withFlashDanger("Country is required");
        }
        if(!(in_array("study_level", $columnmap))) {
            unlink(storage_path($request->input('file')));
            $currentPage = "course";
            return redirect()->route('admin.import-export.index', $currentPage)->withFlashDanger("Study Level is required");
        }
        // if(!(in_array("campus", $columnmap))) {
        //     unlink(storage_path($request->input('file')));
        //     return redirect()->route('admin.import-export.index')->withFlashDanger("Campus are required");
        // }

        if (($handle = fopen(storage_path($request->input('file')), "r")) !== FALSE) {
            $i = 1;
            $created_cnt = 0;
            $updated_cnt = 0;
            $serial_no = 0;
            $error_count = 0;
            while (($data = fgetcsv($handle)) !== FALSE) {
                try{
                    \Log::debug("Row: ".$i);
                    
                    if($error_count >= 25){
                        break;
                    }
                    
                    if($i == 1 && $request->input("has_header")) {
                        $i++;
                        continue;
                    }
                    $insert_data = array();
                    $err_msg = array();

                    foreach($columnmap as $key => $value) {
                        if($value) {
                            if(isset($data[$key])) {
                                $insert_data[$value] = trim($data[$key]);
                            } else {
                                $insert_data[$value] = "";//is it required?
                            }
                        }
                    }
                    //We have add 'tution_fee_currency' manually because in column it is not present
                    $insert_data['currency'] = '';

                    $university_name = trim($insert_data['university']);
                    $country = trim($insert_data['country']);
                    $category = trim($request->input("category"));
                    $serial_no += 1;

                    //check country data exist-----
                    if($country == 'United States of America' || $country == 'United States America' || $country == 'United States of America (USA)' || $country == 'United States (USA)' || $country == 'United States') {
                        $country = 'USA';
                    } elseif($country == 'UAE' || $country == 'United Arab Emirates (UAE)' || $country == 'Dubai') {
                        $country = 'United Arab Emirates';
                    } elseif($country == 'UK' || $country == 'United Kingdom (UK)') {
                        $country = 'United Kingdom';
                    }

                    // echo $university_name."<br>";
                    // echo $country;
                    // exit();

                    $countrydata = DB::table('countries')
                        ->where('title_en', '=', $country)
                        ->first();
                    if (!$countrydata) {
                        \Log::debug("Country not found in DB: ".$i);
                        $err_msg[] = "Row: " . $serial_no . " Country '" . $country . "' not found in DB.";
                        $all_err_msg = array_merge($all_err_msg, $err_msg);
                        $error_count++;
                        $i++;
                        continue;
                    } else {
                        \Log::debug("Country found in DB: ".$i);
                        $country_id = $countrydata->id;
                    }                

                    //check Sub-category -----
                    // if (!DB::table('university_course_categories')
                    //     ->where('id', $category)
                    //     // ->where('parent_id','!=',0)
                    //     ->exists()) {
                    //         \Log::debug("University not found in DB: ".$i);
                    //     $err_msg[] = "Row: " . $serial_no . " Sub-category(Discipline Area) '" . $category . "' not found!";
                    //     $all_err_msg = array_merge($all_err_msg, $err_msg);            
                    //     $error_count++;
                    //     $i++;
                    //     continue;
                    // }

                    //check Sub-category -----
                    if (!DB::table('university_course_categories')
                        ->where('id', $category)
                        // ->where('parent_id','!=',0)
                        ->exists()) {
                        \Log::debug("Category not selected");
                        $category = 0;
                        //$err_msg[] = "Row: " . $serial_no . " Sub-category(Discipline Area) '" . $category . "' not found!";
                        // $all_err_msg = array_merge($all_err_msg, $err_msg);            
                        // $error_count++;
                        // $i++;
                        // continue;
                    }
                
                    //check university data exist-----
                    $university_name = mb_convert_encoding($university_name, 'UTF-8', 'ISO-8859-1');
                    $univstydata = DB::table('universities')
                                ->where('university_name',  '=', $university_name)
                                ->where('country', $country_id)
                                ->first();
                    if (!isset($univstydata->id)) {
                        \Log::debug("Creating University: ");
                        /*$err_msg[] = "Row: ".$serial_no." University ".$university_name." not supported!";
                        $all_err_msg = array_merge($all_err_msg, $err_msg);
                        break;*/
                        $storedetails = new Universities;
                        $storedetails->university_name = $university_name;
                        $storedetails->country = $country_id;
                        $storedetails->save();
                        $university_id = DB::getPdo()->lastInsertId();
                        
                    } else {
                        \Log::debug("University already present: ");
                        $university_id = $univstydata->id;
                    }

                    $insert_data['course_name'] = $insert_data['course_name'];
                    $insert_data['category'] = $category;
                    $insert_data['university'] = $university_id;
                    // $insert_data['study_level'] = $insert_data['study_level'];
                    $insert_data['country'] = $insert_data['country'];

                    //check Study level data exist-----
                    $study_level_check = trim($insert_data['study_level']);
                    if(isset($study_level_check) && $study_level_check != "") {
                        \Log::debug("Checking Study Level");
                        if (!in_array($study_level_check, get_study_levels())) {
                            if($request->input('create_study_level'))  {
                                $has_header = $request->input('create_study_level');
                                \Log::debug("Creating Study Level....");
                                $degree = "";
                                $study_level_first_word = explode(' ', trim($study_level_check ))[0];

                                if($study_level_first_word == "Diploma"){
                                    $degree = "Pre-bachelors";
                                } elseif($study_level_first_word == "Advanced"){
                                    $degree = "Pre-bachelors";
                                } elseif($study_level_first_word == "Primary"){
                                    $degree = "Pre-bachelors";
                                } elseif($study_level_first_word == "Senior"){
                                    $degree = "Pre-bachelors";
                                } elseif($study_level_first_word == "Attestation"){
                                    $degree = "Pre-bachelors";
                                } elseif($study_level_first_word == "Grade"){
                                    $degree = "Pre-bachelors";
                                } elseif($study_level_first_word == "Summer"){
                                    $degree = "Pre-bachelors";
                                } elseif($study_level_first_word == "UG"){
                                    $degree = "Pre-bachelors";
                                } 
                                elseif($study_level_first_word == "Bachelor" || $study_level_first_word == "Bachelors"){
                                    $degree = "Bachelors";
                                } elseif($study_level_first_word == "Dual"){
                                    $degree = "Bachelors";
                                } elseif($study_level_first_word == "Associate"){
                                    $degree = "Bachelors";
                                } elseif($study_level_first_word == "Associate"){
                                    $degree = "Bachelors";
                                } elseif($study_level_first_word == "Baccalaureate"){
                                    $degree = "Bachelors";
                                } elseif($study_level_first_word == "Combined"){
                                    $degree = "Bachelors";
                                } elseif($study_level_first_word == "Double"){
                                    $degree = "Bachelors";
                                } elseif($study_level_first_word == "Pre-Master"){
                                    $degree = "Bachelors";
                                } elseif($study_level_first_word == "Undergraduate"){
                                    $degree = "Bachelors";
                                } elseif($study_level_first_word == "Graduate"){
                                    $degree = "Bachelors";
                                } elseif($study_level_first_word == "UG+PG"){
                                    $degree = "Bachelors";
                                } elseif($study_level_check == "Twinning Programmes (UG)"){
                                    $degree = "Bachelors";
                                }
                                elseif($study_level_first_word == "Master's"){
                                    $degree = "Masters";
                                } elseif($study_level_first_word == "Postgraduate"){
                                    $degree = "Masters";
                                } elseif($study_level_first_word == "PG"){
                                    $degree = "Masters";
                                } elseif($study_level_check == "Twinning Programmes (PG)"){
                                    $degree = "Masters";
                                }
                                elseif($study_level_first_word == "Doctorate"){
                                    $degree = "Ph.D";
                                } elseif($study_level_first_word == "PhD"){
                                    $degree = "Ph.D";
                                }
                                else{
                                    $degree = "Others";
                                }

                                $dispaly_order = 1;

                                $study_level = new StudyLevels();
                                $study_level->study_level = $study_level_check;
                                $study_level->degree = $degree;
                                $study_level->display_order = $dispaly_order;
                                $study_level->save();

                                \Log::debug("Study Levels Created:" . $study_level_check);
                            } else{
                                $has_header = 0;
                                $err_msg[] = "Row: " . $i . " Study Level '" . $study_level_check . "' not found in System.";
                                $all_err_msg = array_merge($all_err_msg, $err_msg);
                                $error_count++;
                                $i++;
                                continue;
                            }
                        }
                    }
                    // if(isset($insert_data['study_level']) && $insert_data['study_level'] != "") {
                    //     \Log::debug("Inside study level: ".$insert_data['study_level']);

                    //     if (!in_array($insert_data['study_level'], get_study_levels())) {
                    //         $valid_levels = '"'.implode('", "', get_study_levels()).'"';
                    //         $err_msg[] = "Row: " . $serial_no . " Invalid Study Level: '" . $insert_data['study_level'] . "'.<br> Valid Values are: ".$valid_levels.".<br> Aborting Import!";
                    //         $all_err_msg = array_merge($all_err_msg, $err_msg);
                    //         $error_count++;
                    //         $i++;
                    //         continue;
                    //     }                 
                    //     $insert_data['study_level'] = $insert_data['study_level'];
                    // }

                    if (isset($insert_data['study_level']) && $insert_data['study_level'] != '') {
                        $insert_data['study_level'] = $insert_data['study_level'];
                    }
                    if(isset($insert_data['campus']) && $insert_data['campus'] != "") {                    
                        $insert_data['campus'] = $insert_data['campus'];
                    }else{
                        $insert_data['campus'] = NULL;
                    }
                    if(isset($insert_data['duration']) && $insert_data['duration'] != "") {
                        $insert_data['duration'] = $insert_data['duration'];
                    }else{
                        $insert_data['duration'] = NULL;
                    }
                    if(isset($insert_data['intakes']) && $insert_data['intakes'] != "") {
                        $insert_data['intakes'] = $insert_data['intakes'];
                    }
                    // if(isset($insert_data['year']) && $insert_data['year'] != "") {
                    //     $insert_data['year'] = $insert_data['year'];
                    // }
                    // else {
                    //     $currentYear = date('Y');
                    //     $nextYear = $currentYear + 1;
                    //     $insert_data['year'] = $currentYear . "," .$nextYear;
                    // }
                    if(isset($insert_data['website_url']) && $insert_data['website_url'] != "") {
                        $insert_data['website_url'] = $insert_data['website_url'];
                    }
                    if(isset($insert_data['entry_requirements']) && $insert_data['entry_requirements'] != "") {
                        $insert_data['entry_requirements'] = get_utf8_string($insert_data['entry_requirements']);
                    }
                    if(isset($insert_data['ielts_score']) && $insert_data['ielts_score'] != "") {
                        $insert_data['ielts_score'] = $insert_data['ielts_score'];
                    }
                    if(isset($insert_data['ielts_no_band_less_than']) && $insert_data['ielts_no_band_less_than'] != "") {
                        $insert_data['ielts_no_band_less_than'] = $insert_data['ielts_no_band_less_than'];
                    }
                    if(isset($insert_data['toefl_score']) && $insert_data['toefl_score'] != "") {
                        $insert_data['toefl_score'] = $insert_data['toefl_score'];
                    }
                    if(isset($insert_data['toefl_no_band_less_than']) && $insert_data['toefl_no_band_less_than'] != "") {
                        $insert_data['toefl_no_band_less_than'] = $insert_data['toefl_no_band_less_than'];
                    }
                    if(isset($insert_data['pte_score']) && $insert_data['pte_score'] != "") {
                        $insert_data['pte_score'] = $insert_data['pte_score'];
                    }
                    if(isset($insert_data['pte_no_band_less_than']) && $insert_data['pte_no_band_less_than'] != "") {
                        $insert_data['pte_no_band_less_than'] = $insert_data['pte_no_band_less_than'];
                    }
                    if(isset($insert_data['gre_score']) && $insert_data['gre_score'] != "") {
                        $insert_data['gre_score'] = $insert_data['gre_score'];
                    }
                    if(isset($insert_data['gmat_score']) && $insert_data['gmat_score'] != "") {
                        $insert_data['gmat_score'] = $insert_data['gmat_score'];
                    }
                    if(isset($insert_data['application_deadline']) && $insert_data['application_deadline'] != "") {
                        $insert_data['application_deadline'] = $insert_data['application_deadline'];
                    }
                    if(isset($insert_data['application_fee']) && $insert_data['application_fee'] != "") {
                        $currency_and_application_fee = $insert_data['application_fee'];
                        $application_fee_currency = get_currency_code_from_symbol($currency_and_application_fee);
                        $insert_data['currency'] = $application_fee_currency;
                        $insert_data['application_fee'] = preg_replace('/[^0-9.]/', '', $insert_data['application_fee']);
                    }

                    //Change Yearly Tution Fee  
                    if(isset($insert_data['yearly_tuition_fee']) && $insert_data['yearly_tuition_fee'] != '') {
                        $currency_and_tution_fee = $insert_data['yearly_tuition_fee'];
                        $tution_fee_currency = get_currency_code_from_symbol($currency_and_tution_fee);
                        $insert_data['currency'] = $tution_fee_currency;
                        $insert_data['yearly_tuition_fee'] = preg_replace('/[^0-9.]/', '', $currency_and_tution_fee);
                    }

                    // Newly added columns
                    // if(isset($insert_data['tuition_fee_onshore']) && $insert_data['tuition_fee_onshore'] != '') {
                    //     $insert_data['tuition_fee_onshore'] = $insert_data['tuition_fee_onshore'];
                    // }
                    // if(isset($insert_data['tuition_fee_offshore']) && $insert_data['tuition_fee_offshore'] != '') {
                    //     $insert_data['tuition_fee_offshore'] = $insert_data['tuition_fee_offshore'];
                    // }
                    if(isset($insert_data['non_tuition_fee']) && $insert_data['non_tuition_fee'] != '') {
                        $currency_and_non_tution_fee = $insert_data['non_tuition_fee'];
                        $non_application_fee_currency = get_currency_code_from_symbol($currency_and_non_tution_fee);
                        $insert_data['currency'] = $non_application_fee_currency;
                        $insert_data['non_tuition_fee'] = preg_replace('/[^0-9.]/', '', $insert_data['non_tuition_fee']);
                    }
                    if(isset($insert_data['course_details']) && $insert_data['course_details'] != '') {
                        $insert_data['course_details'] = $insert_data['course_details'];
                    }
                    if(isset($insert_data['course_content']) && $insert_data['course_content'] != '') {
                        $insert_data['course_content'] = $insert_data['course_content'];
                    }
                    if(isset($insert_data['occupation_outcome']) && $insert_data['occupation_outcome'] != '') {
                        $insert_data['occupation_outcome'] = $insert_data['occupation_outcome'];
                    }
                    if(isset($insert_data['practical_work']) && $insert_data['practical_work'] != '') {
                        $insert_data['practical_work'] = $insert_data['practical_work'];
                    }
                    if(isset($insert_data['qualify_extended_visa']) && $insert_data['qualify_extended_visa'] != '') {
                        $insert_data['qualify_extended_visa'] = $insert_data['qualify_extended_visa'];
                    }
                    if(isset($insert_data['regional_location']) && $insert_data['regional_location'] != '') {
                        $insert_data['regional_location'] = $insert_data['regional_location'];
                    }
                    if(isset($insert_data['country_students_not_accepted']) && $insert_data['country_students_not_accepted'] != '') {
                        $insert_data['country_students_not_accepted'] = $insert_data['country_students_not_accepted'];
                    }
                    // Newly added columns

                    if(isset($insert_data['scholarship_available']) && $insert_data['scholarship_available'] != "") {
                        $insert_data['scholarship_available'] = $insert_data['scholarship_available'];
                    }
                    if(isset($insert_data['scholarship_detail']) && $insert_data['scholarship_detail'] != "") {
                        $insert_data['scholarship_detail'] =  get_utf8_string($insert_data['scholarship_detail']);
                    }
                    if(isset($insert_data['backlog_range']) && $insert_data['backlog_range'] != "") {
                        $insert_data['backlog_range'] = $insert_data['backlog_range'];
                    }
                    if(isset($insert_data['remarks']) && $insert_data['remarks'] != "") {
                        $insert_data['remarks'] = get_utf8_string($insert_data['remarks']);
                    }
                    if(isset($insert_data['esl_elp_detail']) && $insert_data['esl_elp_detail'] != "") {
                        $insert_data['esl_elp_detail'] = get_utf8_string($insert_data['esl_elp_detail']);
                    }
                    if(isset($insert_data['applicationmode']) && $insert_data['applicationmode'] != "") {
                        $insert_data['applicationmode'] = $insert_data['applicationmode'];
                    }
                    if(isset($insert_data['detscore']) && $insert_data['detscore'] != "") {
                        $insert_data['detscore'] = $insert_data['detscore'];
                    }

                    $insert_data['status'] = 1;
                    // echo "<pre>";
                    // print_r($insert_data);
                    // exit();
                    if ($insert_data['course_name'] != '' && $university_id != '' && $category != '' && $insert_data['study_level'] != '') {
                        // echo "<pre>";
                        $insert_data = array_except($insert_data,['country']);
                        // print_r($insert_data);
                        // exit();
                        \Log::debug("Before Going Into In Try Block");
                        try {
                            $coursedata = DB::table('university_courses')
                                ->where('course_name', 'like', $insert_data['course_name'])
                                ->where('university', $university_id)
                                ->where('category', $category)
                                ->where('study_level', $insert_data['study_level'])
                                ->where('campus', $insert_data['campus'])
                                ->where('duration', $insert_data['duration'])
                                ->first();
                                        
                            $UniversityCourses = new UniversityCourses;
                            if (!isset($coursedata->id)) {
                                \Log::debug("University Course Created: ".$i);
                                $UniversityCourses->create($insert_data);
                                $created_cnt++;
                            } else {
                                \Log::debug("Duplicate Course Data: ".$i);
                                $err_msg[] = "Row: " . $serial_no . " Duplicate Course Data";
                                $all_err_msg = array_merge($all_err_msg, $err_msg); 
                                
                                $UniversityCourses->where('id', $coursedata->id)->update($insert_data);
                                $updated_cnt++;
                            }
                        } catch (\Illuminate\Database\QueryException $ex) {
                            $err_msg[] = 'Row:' . $i . ", Error:" . $ex->getMessage();
                        }
                    } else {
                        $err_msg[] = 'Mandatory fields missing in Row:' . $i;
                    }
                    $i++;   
                } catch(\Exception $e){
                    $message = array();
                    $message[] = $e->getMessage();
                    $all_err_msg = array_merge($all_err_msg, $message);
                    // \Log::debug("ERROR: " . $message);
                }              
            }

            fclose($handle);
            unlink(storage_path($request->input('file')));

            if (empty($all_err_msg)) {
                if($updated_cnt){
                    $currentPage = 'course';
                    return redirect()->route('admin.import-export.index', $currentPage)->with("result_title", "<strong>Any CSV Import Results: </strong>")->withFlashSuccess($created_cnt . ' Courses data imported and '.$updated_cnt.' Courses data updated successfully');
                } else{
                    $currentPage = 'course';
                    return redirect()->route('admin.import-export.index', $currentPage)->with("result_title", "<strong>Any CSV Import Results: </strong>")->withFlashSuccess($created_cnt . ' Courses data imported successfully');
                }
            }else{
                if($updated_cnt){
                    $currentPage = 'course';
                    return redirect()->route('admin.import-export.index', $currentPage)->with("result_title", "<strong>Any CSV Import Results: </strong>")->with('flash_success', $created_cnt . ' Courses data imported and '.$updated_cnt.' Courses data updated successfully')->with('flash_danger',implode('<br>',$all_err_msg));
                } else{
                    $currentPage = 'course';
                    return redirect()->route('admin.import-export.index', $currentPage)->with("result_title", "<strong>Any CSV Import Results: </strong>")->with('flash_success', $created_cnt . ' Courses data imported successfully')->with('flash_danger',implode('<br>',$all_err_msg));
                }
            }

        } else {
            $currentPage = 'course';
            return redirect()->route('admin.import-export.index', $currentPage)->with("result_title", "<strong>Any CSV Import Results: </strong>")->withFlashDanger("Error: Cannot read file");
        }       

    }



    public function anyCsvUniversityCourseSave(Request $request){
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('import'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        \Log::debug("Any Csv University Course Save Start");
        $request->validate([
            'file' => 'required',
            'has_header' => 'required',
            'country' => 'country',
            'university' => 'required'         
        ]);  
        
        $all_err_msg = array();

        $columnmap = $request->input('columnmap');
        if(!(in_array("course_name", $columnmap))) {
            unlink(storage_path($request->input('file')));
            $currentPage = "course";
            return redirect()->route('admin.import-export.index', $currentPage)->withFlashDanger("Course Name is required");
        }
        // if(!(in_array("university", $columnmap))) {
        //     unlink(storage_path($request->input('file')));
        //     $currentPage = "course";
        //     return redirect()->route('admin.import-export.index', $currentPage)->withFlashDanger("University name is required");
        // }
        // if(!(in_array("country", $columnmap))) {
        //     unlink(storage_path($request->input('file')));
        //     $currentPage = "course";
        //     return redirect()->route('admin.import-export.index', $currentPage)->withFlashDanger("Country is required");
        // }
        if(!(in_array("study_level", $columnmap))) {
            unlink(storage_path($request->input('file')));
            $currentPage = "course";
            return redirect()->route('admin.import-export.index', $currentPage)->withFlashDanger("Study Level is required");
        }

        if (($handle = fopen(storage_path($request->input('file')), "r")) !== FALSE) {
            $i = 1;
            $created_cnt = 0;
            $updated_cnt = 0;
            $serial_no = 0;
            $error_count = 0;
            while (($data = fgetcsv($handle)) !== FALSE) {
                try{
                    \Log::debug("Row: ".$i);
                    
                    if($error_count >= 25){
                        break;
                    }
                    
                    if($i == 1 && $request->input("has_header")) {
                        $i++;
                        continue;
                    }
                    $insert_data = array();
                    $err_msg = array();

                    foreach($columnmap as $key => $value) {
                        if($value) {
                            if(isset($data[$key])) {
                                $insert_data[$value] = trim($data[$key]);
                            } else {
                                $insert_data[$value] = "";//is it required?
                            }
                        }
                    }
                    //We have add 'tution_fee_currency' manually because in column it is not present
                    $insert_data['currency'] = '';

                    $category = trim($request->input("category"));
                    $serial_no += 1;

                    $university_id = $request->input('university');
                                  
                    //check Sub-category -----
                    if (!DB::table('university_course_categories')
                        ->where('id', $category)
                        // ->where('parent_id','!=',0)
                        ->exists()) {
                        \Log::debug("Category not selected");
                        $category  = 0;
                        //$err_msg[] = "Row: " . $serial_no . " Sub-category(Discipline Area) '" . $category . "' not found!";
                        // $all_err_msg = array_merge($all_err_msg, $err_msg);            
                        // $error_count++;
                        // $i++;
                        // continue;
                    }
                    

                    $insert_data['course_name'] = $insert_data['course_name'];
                    $insert_data['category'] = $category;
                    $insert_data['university'] = $university_id;
                                
                    if(isset($insert_data['study_level']) && $insert_data['study_level'] != "") {
                        \Log::debug("Inside study level: ".$insert_data['study_level']);

                        if (!in_array($insert_data['study_level'], get_study_levels())) {
                            $valid_levels = '"'.implode('", "', get_study_levels()).'"';
                            $err_msg[] = "Row: " . $serial_no . " Invalid Study Level: '" . $insert_data['study_level'] . "'.<br> Valid Values are: ".$valid_levels.".<br> Aborting Import!";
                            $all_err_msg = array_merge($all_err_msg, $err_msg);
                            $error_count++;
                            $i++;
                            continue;
                        }                 
                        $insert_data['study_level'] = $insert_data['study_level'];
                    }

                    if(isset($insert_data['campus']) && $insert_data['campus'] != "") {                    
                        $insert_data['campus'] = $insert_data['campus'];
                    }else{
                        $insert_data['campus'] = NULL;
                    }
                    if(isset($insert_data['duration']) && $insert_data['duration'] != "") {
                        $insert_data['duration'] = $insert_data['duration'];
                    }else{
                        $insert_data['duration'] = NULL;
                    }
                    if(isset($insert_data['intakes']) && $insert_data['intakes'] != "") {
                        $insert_data['intakes'] = $insert_data['intakes'];
                    }
                    if(isset($insert_data['website_url']) && $insert_data['website_url'] != "") {
                        $insert_data['website_url'] = $insert_data['website_url'];
                    }
                    if(isset($insert_data['entry_requirements']) && $insert_data['entry_requirements'] != "") {
                        $insert_data['entry_requirements'] = get_utf8_string($insert_data['entry_requirements']);
                    }
                    if(isset($insert_data['ielts_score']) && $insert_data['ielts_score'] != "") {
                        $insert_data['ielts_score'] = $insert_data['ielts_score'];
                    }
                    if(isset($insert_data['ielts_no_band_less_than']) && $insert_data['ielts_no_band_less_than'] != "") {
                        $insert_data['ielts_no_band_less_than'] = $insert_data['ielts_no_band_less_than'];
                    }
                    if(isset($insert_data['toefl_score']) && $insert_data['toefl_score'] != "") {
                        $insert_data['toefl_score'] = $insert_data['toefl_score'];
                    }
                    if(isset($insert_data['toefl_no_band_less_than']) && $insert_data['toefl_no_band_less_than'] != "") {
                        $insert_data['toefl_no_band_less_than'] = $insert_data['toefl_no_band_less_than'];
                    }
                    if(isset($insert_data['pte_score']) && $insert_data['pte_score'] != "") {
                        $insert_data['pte_score'] = $insert_data['pte_score'];
                    }
                    if(isset($insert_data['pte_no_band_less_than']) && $insert_data['pte_no_band_less_than'] != "") {
                        $insert_data['pte_no_band_less_than'] = $insert_data['pte_no_band_less_than'];
                    }
                    if(isset($insert_data['gre_score']) && $insert_data['gre_score'] != "") {
                        $insert_data['gre_score'] = $insert_data['gre_score'];
                    }
                    if(isset($insert_data['gmat_score']) && $insert_data['gmat_score'] != "") {
                        $insert_data['gmat_score'] = $insert_data['gmat_score'];
                    }
                    if(isset($insert_data['application_deadline']) && $insert_data['application_deadline'] != "") {
                        $insert_data['application_deadline'] = $insert_data['application_deadline'];
                    }
                    if(isset($insert_data['application_fee']) && $insert_data['application_fee'] != "") {
                        $currency_and_application_fee = $insert_data['application_fee'];
                        $application_fee_currency = get_currency_code_from_symbol($currency_and_application_fee);
                        $insert_data['currency'] = $application_fee_currency;
                        $insert_data['application_fee'] = preg_replace('/[^0-9.]/', '', $insert_data['application_fee']);
                    }
                    //Change Yearly Tution Fee  
                    if(isset($insert_data['yearly_tuition_fee']) && $insert_data['yearly_tuition_fee'] != '') {
                        $currency_and_tution_fee = $insert_data['yearly_tuition_fee'];
                        $tution_fee_currency = get_currency_code_from_symbol($currency_and_tution_fee);
                        $insert_data['currency'] = $tution_fee_currency;
                        $insert_data['yearly_tuition_fee'] = preg_replace('/[^0-9.]/', '', $currency_and_tution_fee);
                    }
                    if(isset($insert_data['non_tuition_fee']) && $insert_data['non_tuition_fee'] != '') {
                        $currency_and_non_tution_fee = $insert_data['non_tuition_fee'];
                        $non_application_fee_currency = get_currency_code_from_symbol($currency_and_non_tution_fee);
                        $insert_data['currency'] = $non_application_fee_currency;
                        $insert_data['non_tuition_fee'] = preg_replace('/[^0-9.]/', '', $insert_data['non_tuition_fee']);
                    }
                    if(isset($insert_data['course_details']) && $insert_data['course_details'] != '') {
                        $insert_data['course_details'] = $insert_data['course_details'];
                    }
                    if(isset($insert_data['course_content']) && $insert_data['course_content'] != '') {
                        $insert_data['course_content'] = $insert_data['course_content'];
                    }
                    if(isset($insert_data['occupation_outcome']) && $insert_data['occupation_outcome'] != '') {
                        $insert_data['occupation_outcome'] = $insert_data['occupation_outcome'];
                    }
                    if(isset($insert_data['practical_work']) && $insert_data['practical_work'] != '') {
                        $insert_data['practical_work'] = $insert_data['practical_work'];
                    }
                    if(isset($insert_data['qualify_extended_visa']) && $insert_data['qualify_extended_visa'] != '') {
                        $insert_data['qualify_extended_visa'] = $insert_data['qualify_extended_visa'];
                    }
                    if(isset($insert_data['regional_location']) && $insert_data['regional_location'] != '') {
                        $insert_data['regional_location'] = $insert_data['regional_location'];
                    }
                    if(isset($insert_data['country_students_not_accepted']) && $insert_data['country_students_not_accepted'] != '') {
                        $insert_data['country_students_not_accepted'] = $insert_data['country_students_not_accepted'];
                    }
                    // Newly added columns
                    if(isset($insert_data['scholarship_available']) && $insert_data['scholarship_available'] != "") {
                        $insert_data['scholarship_available'] = get_utf8_string($insert_data['scholarship_available']);
                    }
                    if(isset($insert_data['scholarship_detail']) && $insert_data['scholarship_detail'] != "") {
                        $insert_data['scholarship_detail'] = $insert_data['scholarship_detail'];
                    }
                    if(isset($insert_data['backlog_range']) && $insert_data['backlog_range'] != "") {
                        $insert_data['backlog_range'] = $insert_data['backlog_range'];
                    }
                    if(isset($insert_data['remarks']) && $insert_data['remarks'] != "") {
                        $insert_data['remarks'] = get_utf8_string($insert_data['remarks']);
                    }
                    if(isset($insert_data['esl_elp_detail']) && $insert_data['esl_elp_detail'] != "") {
                        $insert_data['esl_elp_detail'] = get_utf8_string($insert_data['esl_elp_detail']);
                    }
                    if(isset($insert_data['applicationmode']) && $insert_data['applicationmode'] != "") {
                        $insert_data['applicationmode'] = $insert_data['applicationmode'];
                    }
                    if(isset($insert_data['detscore']) && $insert_data['detscore'] != "") {
                        $insert_data['detscore'] = $insert_data['detscore'];
                    }
                    $insert_data['status'] = 1;
                    if ($insert_data['course_name'] != '' && $university_id != '' && $category != '' && $insert_data['study_level'] != '') {
                        $insert_data = array_except($insert_data,['country']);
                        \Log::debug("Before Going Into In Try Block");
                        try {
                            $coursedata = DB::table('university_courses')
                                        ->where('course_name', 'like', $insert_data['course_name'])
                                        ->where('university', $university_id)
                                        ->where('category', $category)
                                        ->where('study_level', $insert_data['study_level'])
                                        ->where('campus', $insert_data['campus'])
                                        ->where('duration', $insert_data['duration'])
                                        ->first();
                                        
                            $UniversityCourses = new UniversityCourses;
                            if (!isset($coursedata->id)) {
                                \Log::debug("University Course Created: ".$i);
                                $UniversityCourses->create($insert_data);
                                $created_cnt++;
                            } else {
                                \Log::debug("Duplicate Course Data: ".$i);
                                $err_msg[] = "Row: " . $serial_no . " Duplicate Course Data";
                                $all_err_msg = array_merge($all_err_msg, $err_msg); 
                                
                                $UniversityCourses->where('id', $coursedata->id)->update($insert_data);
                                $updated_cnt++;
                                // $error_count++;
                                // $i++;
                                // continue;
                            }
                        } catch (\Illuminate\Database\QueryException $ex) {
                            $err_msg[] = 'Row:' . $i . ", Error:" . $ex->getMessage();
                        }
                    } else {
                        $err_msg[] = 'Mandatory fields missing in Row:' . $i;
                    }
                    $i++;   
                } catch(\Exception $e){
                    $message = array();
                    $message[] = $e->getMessage();
                    $all_err_msg = array_merge($all_err_msg, $message);
                    // \Log::debug("ERROR: " . $message);
                }             
            }
            fclose($handle);
            unlink(storage_path($request->input('file')));

            if (empty($all_err_msg)) {
                if($updated_cnt){
                    $currentPage = 'course';
                    return redirect()->route('admin.import-export.index', $currentPage)->with("result_title", "<strong>Any CSV Import Results: </strong>")->withFlashSuccess($created_cnt . ' Courses data imported and '.$updated_cnt.' Courses data updated successfully');
                } else{
                    $currentPage = 'course';
                    return redirect()->route('admin.import-export.index', $currentPage)->with("result_title", "<strong>Any CSV Import Results: </strong>")->withFlashSuccess($created_cnt . ' Courses data imported successfully');
                }
            }else{
                if($updated_cnt){
                    $currentPage = 'course';
                    return redirect()->route('admin.import-export.index', $currentPage)->with("result_title", "<strong>Any CSV Import Results: </strong>")->with('flash_success', $created_cnt . ' Courses data imported and '.$updated_cnt.' Courses data updated successfully')->with('flash_danger',implode('<br>',$all_err_msg));
                } else{
                    $currentPage = 'course';
                    return redirect()->route('admin.import-export.index', $currentPage)->with("result_title", "<strong>Any CSV Import Results: </strong>")->with('flash_success', $created_cnt . ' Courses data imported successfully')->with('flash_danger',implode('<br>',$all_err_msg));
                }
            }
        } else {
            $currentPage = 'course';
            return redirect()->route('admin.import-export.index', $currentPage)->with("result_title", "<strong>Any CSV Import Results: </strong>")->withFlashDanger("Error: Cannot read file");
        }       
    }

    public function getFormatedText($str = '')
    {
        //decode html entities (&quot; -> ")
        $str = html_entity_decode($str);
        //replace other than alpha numeric to hyphen
        $url = trim(strtolower(preg_replace("/[^a-z0-9]/i", '-', $str)));
        //replace more hyphen to one hyphen
        $url = preg_replace("/\-{2,}/", '-', $url);
        //trim hyphen
        $url = preg_replace("/^\-+|\-+$/", '', $url);
        return $url;
    }

    public function get_staff_branch($staff_id) {
        // dd($staff_id);
        // $user = User::find($staff_id);
        // if($user->isAdmin()) {
        //     return DB::table('branch')->pluck('branch_name','id')->toArray();
        // } else {

            $html = '';      
            // $rtr = DB::table('staff_branch')
            // ->join('branch', 'branch.id', '=', 'staff_branch.branch_id')
            // ->where('staff_branch.staff_id', $staff_id)
            // ->pluck('branch_name','id')->toArray();
            
            $rtr = DB::table('staff_branch')->select(DB::raw("CONCAT(first_name,' ',last_name) AS full_name"), 'id')
            ->join('users', 'users.id', '=', 'staff_branch.staff_id')
            ->where('staff_branch.branch_id', $staff_id)
            ->pluck('full_name','id')->toArray();
            
            
            // foreach ($rtr as $brnchs) {
            //     $html .= '<option value="'.$brnchs->id.'">'.$brnchs->branch_name.'</option>';
            // }
            return response()->json($rtr);
       // }
    }
    
}
