<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Auth\User;
use App\Models\Auth\LeadStatus;
use App\Models\Banners;
use App\Models\Configs;
use App\Models\Auth\Posts;
use App\Models\ContentBlocks;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\Auth\CountryStudy;
use App\Repositories\Backend\Auth\UserRepository;
use Illuminate\Support\Arr;
use App\Models\MailTemplates;
use App\Mail\MailSend;
use Illuminate\Support\Facades\Mail;

/**
 * Class LandingPagesController.
 */
class LandingPagesController extends Controller
{

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!\Auth::user()->isAdmin()) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }
            return $next($request);
        });
    }

    public function index()
    {
        $content_pages = Posts::where('type', 'content_page')->where('status', 1)->select('id', 'title')->get();
        $branches = DB::table('branch')->get();
        return view('backend.settings.landing_pages', compact('content_pages', 'branches'));
    }


    public function show_page(Request $request)
    {

        $p1_banner_heading = $p1_banner_desc = $p1_intro_b1_title = $p1_intro_b1_desc =  $p1_intro_b2_title = $p1_intro_b2_desc = $p1_intro_b3_title = $p1_intro_b3_desc = $p1_intro_b4_title = $p1_intro_b4_desc = $p1_ub1_title = $p1_ub1_desc =  $p1_ub2_title = $p1_ub2_desc = "";

        $p2_banner_heading = $p2_banner_desc = $p2_intro_title = $p2_intro_desc = $p2_study_b1_title = $p2_study_b1_desc = $p2_study_b2_title = $p2_study_b2_desc = $p2_study_b3_title = $p2_study_b3_desc = $p2_study_b4_title = $p2_study_b4_desc = "";

        if ($request->get('lead_page') == 'One') {

            if ($request->p1_banner_heading) {
                $p1_banner_heading = $request->p1_banner_heading;
            }
            if ($request->p1_banner_desc) {
                $p1_banner_desc = preg_replace('/\r\n|\r|\n/', '', nl2br($request->p1_banner_desc));
            }
            if ($request->p1_intro_b1_title) {
                $p1_intro_b1_title = $request->p1_intro_b1_title;
            }
            if ($request->p1_intro_b1_desc) {
                $p1_intro_b1_desc = preg_replace('/\r\n|\r|\n/', '', nl2br($request->p1_intro_b1_desc));
            }
            if ($request->p1_intro_b2_title) {
                $p1_intro_b2_title = $request->p1_intro_b2_title;
            }
            if ($request->p1_intro_b2_desc) {
                $p1_intro_b2_desc = preg_replace('/\r\n|\r|\n/', '', nl2br($request->p1_intro_b2_desc));
            }
            if ($request->p1_intro_b3_title) {
                $p1_intro_b3_title = $request->p1_intro_b3_title;
            }
            if ($request->p1_intro_b3_desc) {
                $p1_intro_b3_desc = preg_replace('/\r\n|\r|\n/', '', nl2br($request->p1_intro_b3_desc));
            }
            if ($request->p1_intro_b4_title) {
                $p1_intro_b4_title = $request->p1_intro_b4_title;
            }
            if ($request->p1_intro_b4_desc) {
                $p1_intro_b4_desc = preg_replace('/\r\n|\r|\n/', '', nl2br($request->p1_intro_b4_desc));
            }
            if ($request->p1_ub1_title) {
                $p1_ub1_title = $request->p1_ub1_title;
            }
            if ($request->p1_ub1_desc) {
                $p1_ub1_desc = preg_replace('/\r\n|\r|\n/', '', nl2br($request->p1_ub1_desc));
            }
            if ($request->p1_ub2_title) {
                $p1_ub2_title = $request->p1_ub2_title;
            }
            if ($request->p1_ub2_desc) {
                $p1_ub2_desc = preg_replace('/\r\n|\r|\n/', '', nl2br($request->p1_ub2_desc));
            }

            if ($request->get('sub_btn') == 'generate_page') {
                $html = view('backend.lead_capture_pages.page-one', compact(
                    'p1_banner_heading',
                    'p1_banner_desc',
                    'p1_intro_b1_title',
                    'p1_intro_b1_desc',
                    'p1_intro_b2_title',
                    'p1_intro_b2_desc',
                    'p1_intro_b3_title',
                    'p1_intro_b3_desc',
                    'p1_intro_b4_title',
                    'p1_intro_b4_desc',
                    'p1_ub1_title',
                    'p1_ub1_desc',
                    'p1_ub2_title',
                    'p1_ub2_desc'
                ));
                $html = $html->render();
                // \File::put('storage/pages/landing-page-one.html', $html);
                \File::put(public_path('storage/pages/landing-page-one.html'), $html);
                $file_path = public_path('storage/pages/landing-page-one.html');
                return response()->download($file_path);
            }
            if ($request->get('sub_btn') == 'view_page') {
                return view('backend.lead_capture_pages.page-one', compact(
                    'p1_banner_heading',
                    'p1_banner_desc',
                    'p1_intro_b1_title',
                    'p1_intro_b1_desc',
                    'p1_intro_b2_title',
                    'p1_intro_b2_desc',
                    'p1_intro_b3_title',
                    'p1_intro_b3_desc',
                    'p1_intro_b4_title',
                    'p1_intro_b4_desc',
                    'p1_ub1_title',
                    'p1_ub1_desc',
                    'p1_ub2_title',
                    'p1_ub2_desc',
                ));
            }
        }
        //Page Two
        if ($request->get('lead_page') == 'Two') {

            if ($request->p2_banner_heading) {
                $p2_banner_heading = $request->p2_banner_heading;
            }
            if ($request->p2_banner_desc) {
                $p2_banner_desc = preg_replace('/\r\n|\r|\n/', '', nl2br($request->p2_banner_desc));
            }
            if ($request->p2_intro_title) {
                $p2_intro_title = $request->p2_intro_title;
            }
            if ($request->p2_intro_desc) {
                $p2_intro_desc = preg_replace('/\r\n|\r|\n/', '', nl2br($request->p2_intro_desc));
            }


            if ($request->p2_study_b1_title) {
                $p2_study_b1_title = $request->p2_study_b1_title;
            }
            if ($request->p2_study_b1_desc) {
                $p2_study_b1_desc = preg_replace('/\r\n|\r|\n/', '', nl2br($request->p2_study_b1_desc));
            }

            if ($request->p2_study_b2_title) {
                $p2_study_b2_title = $request->p2_study_b2_title;
            }
            if ($request->p2_study_b2_desc) {
                $p2_study_b2_desc = preg_replace('/\r\n|\r|\n/', '', nl2br($request->p2_study_b2_desc));
            }

            if ($request->p2_study_b3_title) {
                $p2_study_b3_title = $request->p2_study_b3_title;
            }
            if ($request->p2_study_b3_desc) {
                $p2_study_b3_desc = preg_replace('/\r\n|\r|\n/', '', nl2br($request->p2_study_b3_desc));
            }

            if ($request->p2_study_b4_title) {
                $p2_study_b4_title = $request->p2_study_b4_title;
            }
            if ($request->p2_study_b4_desc) {
                $p2_study_b4_desc = preg_replace('/\r\n|\r|\n/', '', nl2br($request->p2_study_b4_desc));
            }


            if ($request->get('sub_btn') == 'generate_page') {
                $html = view('backend.lead_capture_pages.page-two', compact(
                    'p2_banner_heading',
                    'p2_banner_desc',
                    'p2_intro_title',
                    'p2_intro_desc',
                    'p2_study_b1_title',
                    'p2_study_b1_desc',
                    'p2_study_b2_title',
                    'p2_study_b2_desc',
                    'p2_study_b3_title',
                    'p2_study_b3_desc',
                    'p2_study_b4_title',
                    'p2_study_b4_desc',
                ));
                $html = $html->render();
                // \File::put('storage/pages/landing-page-two.html', $html);
                \File::put(public_path('storage/pages/landing-page-two.html'), $html);
                $file_path = public_path('storage/pages/landing-page-two.html');
                return response()->download($file_path);
            }
            if ($request->get('sub_btn') == 'view_page') {
                return view('backend.lead_capture_pages.page-two', compact(
                    'p2_banner_heading',
                    'p2_banner_desc',
                    'p2_intro_title',
                    'p2_intro_desc',
                    'p2_study_b1_title',
                    'p2_study_b1_desc',
                    'p2_study_b2_title',
                    'p2_study_b2_desc',
                    'p2_study_b3_title',
                    'p2_study_b3_desc',
                    'p2_study_b4_title',
                    'p2_study_b4_desc',
                ));
            }
        }
    }
}
