<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\UserActivity;
use App\Models\Auth\Course;
use App\Models\Auth\Country;
use App\Models\Auth\City;
use App\Models\Auth\Tags;
use App\Models\Auth\LeadStatus;
use App\Recipients\AdminRecipient;
use App\Models\Auth\Branch;
use App\Models\MailTemplates;
use App\Models\SMSTemplates;
use App\Notifications\Frontend\AdminAlert;
use App\Models\Auth\CountryStudy;
use Illuminate\Foundation\Http\FormRequest;
use App\Http\Requests\Backend\Auth\User\LeadRequest;
use Illuminate\Support\Facades\Input;
use App\Repositories\Backend\Auth\UserRepository;
use App\Notifications\Backend\UserAlert;
use Illuminate\Support\Str;
use App\Models\Auth\Batch;
use App\Models\Auth\User;
use App\Mail\MailSend;
use App\Models\Auth\UserDetails;
use Illuminate\Support\Facades\Mail;
use App\Models\StaffBranch;
use App\Repositories\Backend\Auth\StaffRepository;
use App\Exceptions\GeneralException;
use Illuminate\Database\Eloquent\Model;
use App\Http\Requests\Backend\Auth\User\ManageUserRequest;
use Illuminate\Pagination\LengthAwarePaginator;
use App\Events\Backend\Auth\User\UserPermanentlyDeleted;
use App\Events\Backend\Auth\User\UserRestored;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\File;
use Illuminate\Validation\Rule;
use App\Models\Auth\UserNotification;

use Log;

class LeadsController extends Controller
{

    private $itemsPerPages = 20;
    protected $model;
    protected $userRepository;

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('view leads'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }

            $model = app()->make($this->model());
            if (! $model instanceof Model) {
                throw new GeneralException("Class {$this->model()} must be an instance of ".Model::class);
            }
            $this->model = $model;
            
            return $next($request);
        });
    }

    public function model()
    {
        return User::class;
    }    

    public function index(Request $request)
    {
        // Updated searching with diffrent url paraemeter
        $search_status = $search_lead_type = $search = $my_data = $search_my_leads_type = $followup_daterange = $allOpenLeads = '';
        if ( $request->has('status') || $request->has('allStatus') || $request->has('allOpenLeads')
            || $request->has('followup_daterange') 
            || $request->has('counselling_daterange') 
            || $request->has('my_leads')
        ) {

            $search_type = "";
            $all_search_type = "";
            if($request->input('status') != ''){
                $search_type = $request->input('status');
            }
            if($request->input('allStatus') != ''){
                $all_search_type = $request->input('allStatus');
            }

            $search_followup_daterange_type = $request->input('followup_daterange') != '' ? $request->input('followup_daterange') : '';
            $search_counselling_daterange_type = $request->input('counselling_daterange') != '' ? $request->input('counselling_daterange') : '';
            
            $search_my_leads_type = $request->input('my_leads') != '' ? $request->input('my_leads') : '';

            if ($search_type != '' || $all_search_type != ''
                || $search_followup_daterange_type != '' 
                || $search_counselling_daterange_type != '' 
                || $search_my_leads_type != '') {
                $search_status_arr = explode('allOpenLeads', $search_type);

                $search_mynextfollowup_arr = explode('followup_daterange', $search_followup_daterange_type);

                $search_mynextcounselling_arr = explode('counselling_daterange', $search_counselling_daterange_type);
                    
                if (isset($search_status_arr[0]) && $search_status_arr[0] != '') {
                    $search_status = $search_status_arr[0];
                } elseif(isset($search_mynextfollowup_arr[0]) && $search_mynextfollowup_arr[0] == 'today') {
                    $followup_daterange = date("d-M-Y")." to ".date("d-M-Y");
                } elseif(isset($search_mynextfollowup_arr[0]) && $search_mynextfollowup_arr[0] == 'todayPlusPast') {
                    $followup_daterange = "01-Jan-2020 to ".date("d-M-Y");
                }
                elseif(isset($search_mynextfollowup_arr[0]) && $search_mynextfollowup_arr[0] == 'past') {
                    $followup_daterange = "01-Jan-2020 to ".date("d-M-Y", strtotime("-1 day"));
                }
                elseif(isset($search_mynextfollowup_arr[0]) && $search_mynextfollowup_arr[0] == 'future') {
                    $followup_daterange = date("d-M-Y", strtotime("+1 day"))." to ".date("d-M-Y", strtotime("+1 year"));
                } 
                elseif(isset($search_mynextcounselling_arr[0]) && $search_mynextcounselling_arr[0] == 'today') {
                    $followup_daterange = date("d-M-Y")." to ".date("d-M-Y");
                    $search_status = get_counselling_lead_status();
                }
                elseif(isset($search_mynextcounselling_arr[0]) && $search_mynextcounselling_arr[0] == 'todayPlusPast') {
                    $followup_daterange = "01-Jan-2020 to ".date("d-M-Y");
                    $search_status = get_counselling_lead_status();
                }elseif($search_my_leads_type){
                    $my_data = 1;
                }elseif($search_type) {
                    $my_data = 1;
                    $search_status = $search_type;
                }else{
                    $search_status = $all_search_type;
                }
            }
        }
        if($request->input('allOpenLeads')){
            $allOpenLeads = $request->input('allOpenLeads');
        }else{
            $allOpenLeads = 0;
        }
        $courses = Course::all();
        $filters = array("allOpenLeads" => $allOpenLeads,"status" => $search_status, "search" => "", "tags_filter" => "", "lead" => $search_lead_type, "lead_countries" => "", "lead_course" => "","assigned_to" => $search_my_leads_type, "followup_daterange" => $followup_daterange, "course" => "", "my_data" => $my_data);
        // $status_list = array('Open' => 'Open', 'Hot' => 'Hot', 'Warm' => 'Warm', 'Cold' => 'Cold', 'Long term nurture' => 'Long term nurture', 'Converted' => 'Converted', 'Disqualified' => 'Disqualified');

        $status_list = '';
        $lead_countries = User::whereNotNull('country')->where('country',"!=",'')->where('is_lead', 1)->distinct()->get(['country']);

        $userRepo = new StaffRepository();
        $staff = $userRepo->getStaffUsers(get_staff_branch_ids(\Auth::user()->id));

        $view_others_data = true;
        if (\Auth::user()->can('view assigned data only')) {
            $view_others_data = false;
        }

        $branch = get_staff_branch(\Auth::user()->id);
        $current_branch = $request->input('branch');

        $countriesFilter = Country::where('overseas_status', 1)->orderBy('title_en', 'ASC')->get();
        $courseFilter = User::select("overseas_course_intersted")
            ->whereNotNull("overseas_course_intersted")
            ->orderBy('overseas_course_intersted', 'ASC')
            ->distinct()
            ->get();
    
        return view('backend.lead.lead_index',  [
            'countriesFilter' => $countriesFilter, 
            'lead_countries' => $lead_countries, 
            'search' => $search, 
            'filters' => $filters, 
            'courses' => $courses, 
            'staff' => $staff, 
            'status_list' => $status_list, 
            'view_others_data' => $view_others_data, 
            'branch' => $branch, 
            'current_branch' => $current_branch,
            'courseFilter' => $courseFilter
        ]);
    }

    public function ajaxleadlist(Request $request)
    {
        if (!$request->ajax()) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this page.');
        }
        echo $this->getDatatableLeadlist($request);
    }


    public function getDatatableLeadlist($request)
    {
        // dd($request->all());
        // Query debug
        DB::enableQueryLog();

        $columns = array(
            // 0 => 'id',
            1 => 'users.id',
            2 => 'first_name',
            3 => 'first_name',
            10 => 'next_followup',
            11 => 'lead_status',
            // 11 => 'assigned_to_name',
            12 => 'assigned_to',
            13 => 'users.created_at',
        );

        $my_branch = "";
        $before_lead_age = ""; 
        $no_activity_since = ""; 
        $overdue = ""; 
        $today = ""; 
        $tomorrow = ""; 
        $in_next_7_days = ""; 
        $current_days = ""; 
        $followup_date_from = "";
        $followup_date_to = "";
        $created_date_from = "";
        $created_date_to = "";   

        if (\Auth::user()->can('view assigned data only')) {
            \Log::debug('view assigned data only. User: ' . \Auth::user()->id);
            $my_user_id = \Auth::user()->id;
        } else {
            $my_user_id = $request->input('myleads') == 1 ? \Auth::user()->id : '';
            //$my_branch = get_staff_branch_ids(\Auth::user()->id);
        }
        if ($request->input('branch') == "all") {
            $my_branch = get_staff_branch_ids(\Auth::user()->id);
        } else {
            $my_branch = array($request->input('branch'));
        }
        // \Log::debug('My User Id: '.$my_user_id);
        $excludeAgent = $request->input('excludeAgent');
        $agentListOnly = $request->input('agentListOnly');

        $leadsWithNoFollowup = $request->input('leadsWithNoFollowup');

        $next_followup_counselling_date = $request->input('next_followup_counselling_date');
        $created_date = $request->input('created_date');
        if($next_followup_counselling_date == "overdue"){
            $overdue = date("Y-m-d 00:00:00");
        } elseif($next_followup_counselling_date == "today"){
            $today = date("Y-m-d");
        } elseif($next_followup_counselling_date == "tomorrow"){
            $tomorrow = date("Y-m-d", strtotime("+1 days"));
        } elseif($next_followup_counselling_date == "in_next_7_days"){
            $in_next_7_days = date("Y-m-d 23:59:59", strtotime("+8 days")); 
            //$current_days = date("Y-m-d 00:00:00");
        } 
        elseif($next_followup_counselling_date == "custom"){     
            if(!empty($request->input('followup_daterange'))) {
                $followup_dts_str = $request->input('followup_daterange');
                $followup_dts = explode(" to ", $followup_dts_str);
                $followup_date_from = date("Y-m-d 00:00:00", strtotime($followup_dts[0]));
                $followup_date_to = date("Y-m-d 23:59:59", strtotime($followup_dts[1]));
            }
            // \Log::debug('Lead follow dt: '.$followup_date_from. ' to '.$followup_date_to);
        }
        elseif(!empty($request->input('followup_daterange'))) {
            $followup_dts_str = $request->input('followup_daterange');
            $followup_dts = explode(" to ", $followup_dts_str);
            $followup_date_from = date("Y-m-d 00:00:00", strtotime($followup_dts[0]));
            $followup_date_to = date("Y-m-d 23:59:59", strtotime($followup_dts[1]));
        }

        if(!empty($created_date)) {
            $created_dts_str = $created_date;
            $created_dts = explode(" to ", $created_dts_str);
            $created_date_from = date("Y-m-d 00:00:00", strtotime($created_dts[0]));
            $created_date_to = date("Y-m-d 23:59:59", strtotime($created_dts[1]));
            \Log::debug('Lead created dt: '.$created_date_from. ' to '.$created_date_to);
        }
        
        
        if(!empty($request->input('lead_age'))) {
            $lead_age = $request->input('lead_age');
            $before_lead_age = date("Y-m-d 00:00:00", strtotime("-".$lead_age." days"));
        }

        if(!empty($request->input('no_activity_since'))) {
            $no_activity_since_temp = $request->input('no_activity_since');
            $no_activity_since = date("Y-m-d 00:00:00", strtotime("-".$no_activity_since_temp." days"));
        }

        $totalData = $this->model
            ->active()
            ->whereIn('lead_status', lead_status_list_as_array())
            ->count();

            // $queries = DB::getQueryLog();
            // Log::debug(end($queries));

        $totalFiltered = $totalData;
        $converted_lead_status = get_converted_lead_status();
        $disqualified_lead_status = get_disqualified_lead_status();
        $counselling_lead_status = get_counselling_lead_status();

        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');
        $status = $request->input('status');
        $tags_filter = $request->input('tags_filter');
        if($status && in_array("all_leads", $status)){
            $status = lead_status_list_as_array();
        }
        $leadtype = $request->input('leadtype');
        $assigned_to = $request->input('assigned_to');
        // $my_user_id = $request->input('myleads') == 1 ? \Auth::user()->id : '';
        $lead_country = $request->input('lead_country');
        // \Log::debug("My branch(s):" . print_r($my_branch, true));

        $lead_source = $request->input('lead_source');
        $country_pref = "";
        if($request->input('country_pref') != ""){
            $country_pref = implode(',',$request->input('country_pref'));
        }

        $service_pref = "";
        if($request->input('service_pref') != ""){
            $service_pref = implode(',',$request->input('service_pref'));
        }
        $study_level_filter = $request->input('study_level_filter');
        $course_interested_filter = $request->input('course_interested_filter');
        $intatake_arr = "";
        if (!empty($request->input('intake_filter'))) {
            $intake = $request->input('intake_filter');
            $intatake_arr =  explode(" ", $intake);
        }
        
        if (empty($status)) {
            //We exclude converted & disqualified leads by default
            $get_search = $request->input('search.value');
            $users = $this->model
                ->leftjoin('user_details', 'users.id', '=', 'user_details.userid')
                ->leftjoin('countries', 'users.country', '=', 'countries.id')
                ->leftjoin('states', 'users.state', '=', 'states.id')
                ->leftjoin('branch', 'users.branch', '=', 'branch.id')
                ->select("users.*", "user_details.intake_year", "user_details.intake_month", "user_details.lead_disqualified_reason", "countries.title_en as country_name", "states.name as state_name", "branch.branch_name as branch_name")
                ->active()
                ->when(!empty($my_branch), function ($query) use ($my_branch) {
                    return $query->whereIn('users.branch', $my_branch);
                })
                ->where('lead_status', '!=', $converted_lead_status)
                ->where('lead_status', '!=', $disqualified_lead_status)
                // ->where('lead_status', '!=', get_counselling_lead_status())
                ->when(!empty($get_search), function ($query) use ($get_search) {
                    return $query->Where(function ($query) use ($get_search) {
                        $query->Where('users.first_name', 'like', "%$get_search%")
                            ->orWhere('users.last_name', 'like', "%$get_search%")
                            ->orWhereRaw("CONCAT(`users`.`first_name`, ' ', `users`.`last_name`) LIKE ?", ['%'.$get_search.'%'])
                            ->orWhere('users.mobile', '=', "$get_search")
                            ->orWhere('users.email', 'like', "%$get_search%")
                            ->orWhere('users.id', '=', "$get_search")
                            ->orWhere('users.created_at', 'like', "$get_search%") //search date like 2022-05-15
                            ->orWhere('lead_status', '=', "$get_search") //search open lead status from search input
                            ->orWhere('lead_source_detail', 'like', "%$get_search%")
                            ->orWhere('lead_source', 'like', "%$get_search%");
                    });
                })
                ->when(!empty($leadtype), function ($query) use ($leadtype) {
                    return  $query->Where('student_type', '=', "$leadtype");
                })
                ->when(!empty($tags_filter), function ($query) use ($tags_filter) {
                    return $query->Where(function ($query) use ($tags_filter) {
                        foreach ($tags_filter as $tag) {
                            $query->orWhere("tags", "like", "%" . $tag . "%");
                        }
                    });
                })
                ->when(!empty($lead_country), function ($query) use ($lead_country) {
                    return  $query->Where('users.country', '=', "$lead_country");
                })
                ->when(!empty($assigned_to), function ($query) use ($assigned_to) {
                    return  $query->Where('assigned_to', '=', "$assigned_to");
                })
                ->when(!empty($excludeAgent), function ($query) {
                    return $query->where('agent_id', 0);
                })
                ->when(!empty($agentListOnly), function ($query) {
                    return $query->where('agent_id', '!=', 0);
                })
                ->when(!empty($my_user_id), function ($query) use ($my_user_id) {
                    return  $query->Where('assigned_to', '=', "$my_user_id");
                })
                ->when(!empty($leadsWithNoFollowup), function ($query) {
                    return $query->where('next_followup', null);
                })
                ->when(!empty($before_lead_age), function ($query) use ($before_lead_age) {
                    return  $query->Where('users.created_at', '<=', "$before_lead_age");
                })
                ->when(!empty($no_activity_since), function ($query) use ($no_activity_since) {
                    return  $query->Where('last_followup', '<=', "$no_activity_since");
                })
                ->when(!empty($overdue), function ($query) use ($overdue) {
                    return  $query->Where('next_followup', '<', "$overdue");
                })
                ->when(!empty($today), function ($query) use ($today) {
                    return  $query->Where('next_followup', 'like', "$today%");
                })
                ->when(!empty($tomorrow), function ($query) use ($tomorrow) {
                    return  $query->Where('next_followup', 'like', "$tomorrow%");
                })
                ->when(!empty($in_next_7_days), function ($query) use ($in_next_7_days) {
                    return $query->Where(function ($query) use ($in_next_7_days) {
                        $query->where('next_followup', '>=', date("Y-m-d"))
                            ->Where('next_followup', '<=', "$in_next_7_days");
                    });
                })
                ->when(!empty($followup_date_from), function ($query) use ($followup_date_from) {
                    return  $query->Where('next_followup', '>=', "$followup_date_from");
                })
                ->when(!empty($followup_date_to), function ($query) use ($followup_date_to) {
                    return  $query->Where('next_followup', '<=', "$followup_date_to");
                }) 
                ->when(!empty($created_date_from), function ($query) use ($created_date_from) {
                    return  $query->Where('users.created_at', '>=', "$created_date_from");
                })
                ->when(!empty($created_date_to), function ($query) use ($created_date_to) {
                    return  $query->Where('users.created_at', '<=', "$created_date_to");
                })               
                ->when(!empty($country_pref), function ($query) use ($country_pref) {
                    return  $query->where('country_interested', 'like', "%$country_pref%");
                })
                ->when(!empty($lead_source), function ($query) use ($lead_source) {
                    return  $query->Where('lead_source', '=', "$lead_source");
                })
                ->when(!empty($study_level_filter), function ($query) use ($study_level_filter) {
                    return  $query->Where('overseas_study_level_selection', '=', "$study_level_filter");
                })
                ->when(!empty($course_interested_filter), function ($query) use ($course_interested_filter) {
                    return  $query->Where('overseas_course_intersted', '=', "$course_interested_filter");
                })
                ->when(!empty($service_pref), function ($query) use ($service_pref) {
                    return  $query->where('services', 'like', "%$service_pref%");
                })
                ->when(!empty($intatake_arr), function ($query) use ($intatake_arr) {
                    return $query->Where(function ($query) use ($intatake_arr) {
                        $query->where('user_details.intake_year', '=', $intatake_arr[1])
                            ->Where('user_details.intake_month', '=', $intatake_arr[0]);
                    });
                })
                ->where('is_lead', 1)
                ->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                ->get("users.*");

            // Query debug                
            // $queries = DB::getQueryLog();
            // Log::debug(end($queries));

            $totalFiltered = $this->model->leftjoin('user_details', 'users.id', '=', 'user_details.userid')
                ->active()
                ->leftjoin('countries', 'users.country', '=', 'countries.id')
                ->leftjoin('states', 'users.state', '=', 'states.id')
                ->leftjoin('branch', 'users.branch', '=', 'branch.id')
                ->select("users.*", "user_details.intake_year", "user_details.intake_month", "user_details.lead_disqualified_reason", "countries.title_en as country_name", "states.name as state_name", "branch.branch_name as branch_name")
                ->when(!empty($my_branch), function ($query) use ($my_branch) {
                    return $query->whereIn('users.branch', $my_branch);
                })
                ->where('lead_status', '!=', $converted_lead_status)
                ->where('lead_status', '!=', $disqualified_lead_status)
                // ->where('lead_status', '!=', get_counselling_lead_status())
                ->when(!empty($get_search), function ($query) use ($get_search) {
                    return $query->Where(function ($query) use ($get_search) {
                        $query->Where('users.first_name', 'like', "%$get_search%")
                            ->orWhere('users.last_name', 'like', "%$get_search%")
                            ->orWhereRaw("CONCAT(`users`.`first_name`, ' ', `users`.`last_name`) LIKE ?", ['%'.$get_search.'%'])
                            ->orWhere('users.mobile', '=', "$get_search")
                            ->orWhere('users.email', 'like', "%$get_search%")
                            ->orWhere('users.id', '=', "$get_search")
                            ->orWhere('users.created_at', 'like', "$get_search%") //search date like 2022-05-15
                            ->orWhere('lead_status', '=', "$get_search") //search open lead status from search input
                            ->orWhere('lead_source_detail', 'like', "%$get_search%");
                    });
                })
                ->when(!empty($leadtype), function ($query) use ($leadtype) {
                    return  $query->Where('student_type', '=', "$leadtype");
                })
                ->when(!empty($tags_filter), function ($query) use ($tags_filter) {
                    return $query->Where(function ($query) use ($tags_filter) {
                        foreach ($tags_filter as $tag) {
                            $query->orWhere("tags", "like", "%" . $tag . "%");
                        }
                    });
                })
                ->when(!empty($lead_country), function ($query) use ($lead_country) {
                    return  $query->Where('users.country', '=', "$lead_country");
                })
                ->when(!empty($assigned_to), function ($query) use ($assigned_to) {
                    return  $query->Where('assigned_to', '=', "$assigned_to");
                })
                ->when(!empty($excludeAgent), function ($query) {
                    return $query->where('agent_id', 0);
                })
                ->when(!empty($agentListOnly), function ($query) {
                    return $query->where('agent_id', '!=', 0);
                })
                ->when(!empty($my_user_id), function ($query) use ($my_user_id) {
                    return  $query->Where('assigned_to', '=', "$my_user_id");
                })
                ->when(!empty($leadsWithNoFollowup), function ($query) {
                    return $query->where('next_followup', null);
                })
                ->when(!empty($before_lead_age), function ($query) use ($before_lead_age) {
                    return  $query->Where('users.created_at', '<=', "$before_lead_age");
                })
                ->when(!empty($no_activity_since), function ($query) use ($no_activity_since) {
                    return  $query->Where('last_followup', '<=', "$no_activity_since");
                })
                ->when(!empty($overdue), function ($query) use ($overdue) {
                    return  $query->Where('next_followup', '<', "$overdue");
                })
                ->when(!empty($today), function ($query) use ($today) {
                    return  $query->Where('next_followup', 'like', "$today%");
                })
                ->when(!empty($tomorrow), function ($query) use ($tomorrow) {
                    return  $query->Where('next_followup', 'like', "$tomorrow%");
                })
                ->when(!empty($in_next_7_days), function ($query) use ($in_next_7_days) {
                    return $query->Where(function ($query) use ($in_next_7_days) {
                        $query->where('next_followup', '>=', date("Y-m-d"))
                            ->Where('next_followup', '<=', "$in_next_7_days");
                    });
                })
                ->when(!empty($followup_date_from), function ($query) use ($followup_date_from) {
                    return  $query->Where('next_followup', '>=', "$followup_date_from");
                })
                ->when(!empty($followup_date_to), function ($query) use ($followup_date_to) {
                    return  $query->Where('next_followup', '<=', "$followup_date_to");
                }) 
                ->when(!empty($created_date_from), function ($query) use ($created_date_from) {
                    return  $query->Where('users.created_at', '>=', "$created_date_from");
                })
                ->when(!empty($created_date_to), function ($query) use ($created_date_to) {
                    return  $query->Where('users.created_at', '<=', "$created_date_to");
                })               
                ->when(!empty($country_pref), function ($query) use ($country_pref) {
                    return  $query->where('country_interested', 'like', "%$country_pref%");
                })
                ->when(!empty($lead_source), function ($query) use ($lead_source) {
                    return  $query->Where('lead_source', '=', "$lead_source");
                })
                ->when(!empty($study_level_filter), function ($query) use ($study_level_filter) {
                    return  $query->Where('overseas_study_level_selection', '=', "$study_level_filter");
                })
                ->when(!empty($course_interested_filter), function ($query) use ($course_interested_filter) {
                    return  $query->Where('overseas_course_intersted', '=', "$course_interested_filter");
                })
                ->when(!empty($service_pref), function ($query) use ($service_pref) {
                    return  $query->where('services', 'like', "%$service_pref%");
                })
                ->when(!empty($intatake_arr), function ($query) use ($intatake_arr) {
                    return $query->Where(function ($query) use ($intatake_arr) {
                        $query->where('user_details.intake_year', '=', $intatake_arr[1])
                            ->Where('user_details.intake_month', '=', $intatake_arr[0]);
                    });
                })
                ->where('is_lead', 1)
                ->count();
        } else {
            $get_search = $request->input('search.value');
            $users = $this->model->leftjoin('user_details', 'users.id', '=', 'user_details.userid')
                ->active()
                ->leftjoin('countries', 'users.country', '=', 'countries.id')
                ->leftjoin('states', 'users.state', '=', 'states.id')
                ->leftjoin('branch', 'users.branch', '=', 'branch.id')
                ->select("users.*", "user_details.intake_year", "user_details.intake_month", "user_details.lead_disqualified_reason", "countries.title_en as country_name", "states.name as state_name", "branch.branch_name as branch_name")
                ->when(!empty($my_branch), function ($query) use ($my_branch) {
                    return $query->whereIn('users.branch', $my_branch);
                })
                ->whereIn('lead_status', $status)
                ->when(!empty($get_search), function ($query) use ($get_search) {
                    return $query->Where(function ($query) use ($get_search) {
                        $query->Where('users.first_name', 'like', "%$get_search%")
                            ->orWhere('users.last_name', 'like', "%$get_search%")
                            ->orWhereRaw("CONCAT(`users`.`first_name`, ' ', `users`.`last_name`) LIKE ?", ['%'.$get_search.'%'])
                            ->orWhere('users.mobile', '=', "$get_search")
                            ->orWhere('users.id', '=', "$get_search")
                            ->orWhere('users.email', 'like', "%$get_search%")
                            ->orWhere('users.created_at', 'like', "$get_search%")
                            ->orWhere('lead_source_detail', 'like', "%$get_search%");
                    });
                })
                ->when(!empty($leadtype), function ($query) use ($leadtype) {
                    return  $query->Where('student_type', '=', "$leadtype");
                })
                ->when(!empty($tags_filter), function ($query) use ($tags_filter) {
                    return $query->Where(function ($query) use ($tags_filter) {
                        foreach ($tags_filter as $tag) {
                            $query->orWhere("tags", "like", "%" . $tag . "%");
                        }
                    });
                })
                ->when(!empty($lead_country), function ($query) use ($lead_country) {
                    return  $query->Where('users.country', '=', "$lead_country");
                })
                ->when(!empty($assigned_to), function ($query) use ($assigned_to) {
                    return  $query->Where('assigned_to', '=', "$assigned_to");
                })
                ->when(!empty($my_user_id), function ($query) use ($my_user_id) {
                    return  $query->Where('assigned_to', '=', "$my_user_id");
                })
                ->when(!empty($excludeAgent), function ($query) {
                    return $query->where('agent_id', 0);
                })
                ->when(!empty($agentListOnly), function ($query) {
                    return $query->where('agent_id', '!=', 0);
                })
                ->when($status == $converted_lead_status, function ($query) use ($status) {
                    return $query->Where('is_lead', 0);
                })
                ->when($status == $converted_lead_status, function ($query) use ($status) {
                    return $query->Where('is_lead', "!=", 1);
                })
                ->when(!empty($before_lead_age), function ($query) use ($before_lead_age) {
                    return  $query->Where('users.created_at', '<=', "$before_lead_age");
                })
                ->when(!empty($no_activity_since), function ($query) use ($no_activity_since) {
                    return  $query->Where('last_followup', '<=', "$no_activity_since");
                })
                ->when(!empty($overdue), function ($query) use ($overdue) {
                    return  $query->Where('next_followup', '<', "$overdue");
                })
                ->when(!empty($today), function ($query) use ($today) {
                    return  $query->Where('next_followup', 'like', "$today%");
                })
                ->when(!empty($tomorrow), function ($query) use ($tomorrow) {
                    return  $query->Where('next_followup', 'like', "$tomorrow%");
                })
                ->when(!empty($in_next_7_days), function ($query) use ($in_next_7_days) {
                    return $query->Where(function ($query) use ($in_next_7_days) {
                        $query->where('next_followup', '>=', date("Y-m-d"))
                            ->Where('next_followup', '<=', "$in_next_7_days");
                    });
                })
                ->when(!empty($followup_date_from), function ($query) use ($followup_date_from) {
                    return  $query->Where('next_followup', '>=', "$followup_date_from");
                })
                ->when(!empty($followup_date_to), function ($query) use ($followup_date_to) {
                    return  $query->Where('next_followup', '<=', "$followup_date_to");
                })    
                ->when(!empty($created_date_from), function ($query) use ($created_date_from) {
                    return  $query->Where('users.created_at', '>=', "$created_date_from");
                })
                ->when(!empty($created_date_to), function ($query) use ($created_date_to) {
                    return  $query->Where('users.created_at', '<=', "$created_date_to");
                })                         
                ->when(!empty($country_pref), function ($query) use ($country_pref) {
                    return  $query->where('country_interested', 'like', "%$country_pref%");
                })
                ->when(!empty($lead_source), function ($query) use ($lead_source) {
                    return  $query->Where('lead_source', '=', "$lead_source");
                })
                ->when(!empty($study_level_filter), function ($query) use ($study_level_filter) {
                    return  $query->Where('overseas_study_level_selection', '=', "$study_level_filter");
                })
                ->when(!empty($course_interested_filter), function ($query) use ($course_interested_filter) {
                    return  $query->Where('overseas_course_intersted', '=', "$course_interested_filter");
                })
                ->when(!empty($service_pref), function ($query) use ($service_pref) {
                    return  $query->where('services', 'like', "%$service_pref%");
                })
                ->when(!empty($intatake_arr), function ($query) use ($intatake_arr) {
                    return $query->Where(function ($query) use ($intatake_arr) {
                        $query->where('user_details.intake_year', '=', $intatake_arr[1])
                            ->Where('user_details.intake_month', '=', $intatake_arr[0]);
                    });
                })
                // ->where('is_lead', 1)
                ->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                ->get("users.*");

            // $queries = DB::getQueryLog();
            // Log::debug(end($queries));

            $totalFiltered = $this->model->leftjoin('user_details', 'users.id', '=', 'user_details.userid')
                ->active()
                ->leftjoin('countries', 'users.country', '=', 'countries.id')
                ->leftjoin('states', 'users.state', '=', 'states.id')
                ->leftjoin('branch', 'users.branch', '=', 'branch.id')
                ->select("users.*", "user_details.intake_year", "user_details.intake_month", "user_details.lead_disqualified_reason", "countries.title_en as country_name", "states.name as state_name", "branch.branch_name as branch_name")
                ->when(!empty($my_branch), function ($query) use ($my_branch) {
                    return $query->whereIn('users.branch', $my_branch);
                })
                ->whereIn('lead_status', $status)
                ->when(!empty($get_search), function ($query) use ($get_search) {
                    return $query->Where(function ($query) use ($get_search) {
                        $query->Where('users.first_name', 'like', "%$get_search%")
                            ->orWhere('users.last_name', 'like', "%$get_search%")
                            ->orWhereRaw("CONCAT(`users`.`first_name`, ' ', `users`.`last_name`) LIKE ?", ['%'.$get_search.'%'])
                            ->orWhere('users.mobile', '=', "$get_search")
                            ->orWhere('users.id', '=', "$get_search")
                            ->orWhere('users.email', 'like', "%$get_search%")
                            ->orWhere('users.created_at', 'like', "$get_search%")
                            ->orWhere('lead_source_detail', 'like', "%$get_search%");
                    });
                })
                ->when(!empty($leadtype), function ($query) use ($leadtype) {
                    return  $query->Where('student_type', '=', "$leadtype");
                })
                ->when(!empty($tags_filter), function ($query) use ($tags_filter) {
                    return $query->Where(function ($query) use ($tags_filter) {
                        foreach ($tags_filter as $tag) {
                            $query->orWhere("tags", "like", "%" . $tag . "%");
                        }
                    });
                })
                ->when(!empty($lead_country), function ($query) use ($lead_country) {
                    return  $query->Where('users.country', '=', "$lead_country");
                })
                ->when(!empty($assigned_to), function ($query) use ($assigned_to) {
                    return  $query->Where('assigned_to', '=', "$assigned_to");
                })
                ->when(!empty($my_user_id), function ($query) use ($my_user_id) {
                    return  $query->Where('assigned_to', '=', "$my_user_id");
                })
                ->when(!empty($excludeAgent), function ($query) {
                    return $query->where('agent_id', 0);
                })
                ->when(!empty($agentListOnly), function ($query) {
                    return $query->where('agent_id', '!=', 0);
                })
                ->when($status == $converted_lead_status, function ($query) use ($status) {
                    return $query->Where('is_lead', 0);
                })
                ->when($status == $converted_lead_status, function ($query) use ($status) {
                    return $query->Where('is_lead', "!=", 1);
                })
                ->when(!empty($before_lead_age), function ($query) use ($before_lead_age) {
                    return  $query->Where('users.created_at', '<=', "$before_lead_age");
                })
                ->when(!empty($no_activity_since), function ($query) use ($no_activity_since) {
                    return  $query->Where('last_followup', '<=', "$no_activity_since");
                })
                ->when(!empty($overdue), function ($query) use ($overdue) {
                    return  $query->Where('next_followup', '<', "$overdue");
                })
                ->when(!empty($today), function ($query) use ($today) {
                    return  $query->Where('next_followup', 'like', "$today%");
                })
                ->when(!empty($tomorrow), function ($query) use ($tomorrow) {
                    return  $query->Where('next_followup', 'like', "$tomorrow%");
                })
                ->when(!empty($in_next_7_days), function ($query) use ($in_next_7_days) {
                    return $query->Where(function ($query) use ($in_next_7_days) {
                        $query->where('next_followup', '>=', date("Y-m-d"))
                            ->Where('next_followup', '<=', "$in_next_7_days");
                    });
                })
                ->when(!empty($followup_date_from), function ($query) use ($followup_date_from) {
                    return  $query->Where('next_followup', '>=', "$followup_date_from");
                })
                ->when(!empty($followup_date_to), function ($query) use ($followup_date_to) {
                    return  $query->Where('next_followup', '<=', "$followup_date_to");
                })  
                ->when(!empty($created_date_from), function ($query) use ($created_date_from) {
                    return  $query->Where('users.created_at', '>=', "$created_date_from");
                })
                ->when(!empty($created_date_to), function ($query) use ($created_date_to) {
                    return  $query->Where('users.created_at', '<=', "$created_date_to");
                })              
                ->when(!empty($country_pref), function ($query) use ($country_pref) {
                    return  $query->where('country_interested', 'like', "%$country_pref%");
                })
                ->when(!empty($lead_source), function ($query) use ($lead_source) {
                    return  $query->Where('lead_source', '=', "$lead_source");
                })
                ->when(!empty($study_level_filter), function ($query) use ($study_level_filter) {
                    return  $query->Where('overseas_study_level_selection', '=', "$study_level_filter");
                })
                ->when(!empty($course_interested_filter), function ($query) use ($course_interested_filter) {
                    return  $query->Where('overseas_course_intersted', '=', "$course_interested_filter");
                })
                ->when(!empty($service_pref), function ($query) use ($service_pref) {
                    return  $query->where('services', 'like', "%$service_pref%");
                })
                ->when(!empty($intatake_arr), function ($query) use ($intatake_arr) {
                    return $query->Where(function ($query) use ($intatake_arr) {
                        $query->where('user_details.intake_year', '=', $intatake_arr[1])
                            ->Where('user_details.intake_month', '=', $intatake_arr[0]);
                    });
                })
                // ->where('is_lead', 1)
                ->count();
        }
        // dd($today);
        $data = $customResult = array();
        if (!empty($users)) {
            $count = 1;
            foreach ($users as $page) {
                $customResult['id'] = $page->id;
                $folow_text = $this->get_lead_followup($page->id);

                $customResult['name'] = "<strong><p class='mb-2'><a style='font-size: 16px !important;' data-id='$page->id' class='followup-btn' href='#'>" . $page->first_name . ' ' . $page->last_name . "</a></p></strong>";
                //$customResult['name'] = "<strong><p class='mb-2'><a href='" . route('admin.auth.user.show', $page->id) . "'>" . $page->first_name . ' ' . $page->last_name . "</a></p></strong>";
                //Tags
                $customResult['name'] .= "<p class='text-sub m-0 mt-1'><i class='bi bi-tags-fill' title='Tags'></i> ";
                if($page->tags){
                    $tags_array = explode(',', $page->tags);
                    foreach($tags_array as $tags)
                    {
                        $customResult['name'] .="<span class='badge text-dark me-1 mb-1' title='".$tags."' style='cursor: pointer;background: #E9F8F4;'>".$tags."<span class='close text-secondary remove-tag ps-2' aria-hidden='true' id='".$page->id."' data-tag_name='".$tags."'> &times;</span></span>";
                    }
                }
                $customResult['name'] .=  "<a class='btn actionBtn add-tag-btn mb-0' style='font-size:12px;' data-id='". $page->id."' data-tooltip='Add' title='Add Tag' href='javascript:void(0)'><i class='fa fa-plus'></i></a>
                </p>";
                //Tags
                if ($page->email) {
                    $customResult['name'] .= "<span style='white-space:nowrap;'><i class='fas fa-envelope text-sub'></i> <span class='text-sub'>" . $page->email . "</span></span>";
                }
                if ($page->mobile) {
                    if ($page->email) {
                        $customResult['name'] .= '<br>';
                    }
                    
                    if ($page->dialcode != '') {
                        $mob = '+' . $page->dialcode . '-' . $page->mobile;
                    } else {
                        $mob = $page->mobile;
                    }
                    $customResult['name'] .= "<span style='white-space:nowrap;'><i class='fas fa-phone-alt text-sub'></i> <span class='text-sub'>" . $mob . "</span></span>";

                    //For Excel export
                    $customResult['mobile'] = $mob;
                    //For Excel export
                }else{
                    //For Excel export
                    $customResult['mobile'] = "";
                    //For Excel export 
                }

                if ($page->whatsapp) {
                    $customResult['name'] .= '<br>';
                    if ($page->whatsapp_dialcode != '') {
                        $whtsp = '+' . $page->whatsapp_dialcode . '-' . $page->whatsapp;
                    } else {
                        $whtsp = $page->whatsapp;
                    }
                    $customResult['name'] .= "<span style='white-space:nowrap;'><i class='fab fa-whatsapp'></i> <span><span class='text-sub'>" . $whtsp . "</span></span>";
                    //For Excel export
                    $customResult['whatsapp'] = $whtsp;
                    //For Excel export
                }else{
                    //For Excel export
                    $customResult['whatsapp'] = "";
                    //For Excel export
                }

                //For Excel export
                $customResult['location'] = "";
                //For Excel export
                if($page->country || $page->city || $page->state)
                    $customResult['name'] .= "<br /><span style='white-space:nowrap;'><i class='fas fa-globe text-sub'></i> <span class='text-sub'>";
                if ($page->city) {
                    $city = get_city_name($page->city);
                    $customResult['name'] .= $city . ", ";

                    //For Excel export
                    $customResult['location'] .= $city . ", ";
                    //For Excel export
                }
                if ($page->state) {
                    if($page->country){
                        $customResult['name'] .= $page->state_name  . ", <br>";
                    }else{
                        $customResult['name'] .= $page->state_name ;
                    }

                    //For Excel export
                    $customResult['location'] .= $page->state_name .", ";
                    //For Excel export
                }
                if ($page->country) {
                    $customResult['name'] .= $page->country_name . " ";

                    //For Excel export
                    $customResult['location'] .= $page->country_name . " ";
                    //For Excel export
                }
                $customResult['name'] .= "</span></span>";

                //For Excel export
                $customResult['lead_name'] = $page->first_name.' '.$page->last_name;
                $customResult['email'] = $page->email;
                $customResult['branch'] = $page->branch_name;
                $customResult['export_status'] =  $page->lead_status;
                //For Excel export

                $customResult['next_followup'] = $page->next_followup ? date('d M Y, g:ia', strtotime($page->next_followup)) : "";

                $customResult['created_at'] = $page->created_at ? date('d M Y', strtotime($page->created_at)) : "--";

                $customResult['assigned_to_name'] = "<div style='display: flex; justify-content: space-between;'>";
                $customResult['assigned_to_name'] .= $page->assigned_to ? get_user_full_name_by_id($page->assigned_to) : "<span style='color: red;'>Unassigned</span>";
                if($page->lead_status != $converted_lead_status) {
                    if (\Auth::user()->isAdmin() || \Auth::user()->can('lead-assignment')) {
                        // $customResult['assigned_to_name'] .= '<a target="_blank" style="padding:0;font-size:12px;float:right;" href="' . route('admin.leads.assignstaff', $page->id) . '" data-toggle="tooltip" data-placement="right" title="Assign Lead" class="btn"><i class="fas fa-user-edit"></i></a>';
                        $customResult['assigned_to_name'] .= '<button style="font-size:12px;" data-id="' . $page->id . '" class="assigned_to_staff btn actionBtn" data-toggle="tooltip" data-placement="right" title="Change Staff"><i class="fas fa-user-edit"></i></button>';
                    }
                }
                $customResult['assigned_to_name'] .= "</div>";
                
                $customResult['name'] .= '<div>';
                if(get_site_config('outbound_call_enabled')){
                    if($page->mobile){
                        $customResult['name'] .= '<a target="_blank" class="btn actionBtn" title="Call" href="' . route('admin.communicate.phoneCall', $page->id) . '"><i class="bi bi-telephone-outbound-fill contactIcon"></i></a>';
                    }
                }else{
                    if($page->mobile){
                        $customResult['name'] .= '<span class="btn actionBtnInactive" title="Outbound Call Not Enabled"><i class="bi bi-telephone-outbound-fill contactIcon"></i></span>';
                    }
                }
                if($page->mobile){
                    $customResult['name'] .= '<a target="_blank" class="btn actionBtn" title="SMS" href="' . route('admin.communicate.sms', $page->id) . '"><i class="fa fa-comment-dots contactIcon"></i></a>';
                }
                if($page->email){
                    $customResult['name'] .= '<a target="_blank" class="btn actionBtn" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Email" href="' . route('admin.communicate.mail', $page->id) . '"><i class="fas fa-envelope contactIcon"></i></a>';
                }
                // if (env('WATI_WHATSAPP_TOKEN')) {
                if(get_site_config('whatsapp_enabled')){
                    $whatsapp_link = '<a target="_blank" class="btn actionBtn" title="Whatsapp" href="' . route('admin.communicate.whatsapp', $page->id) . '"><i class="fab fa-whatsapp contactIcon"></i></a>';
                } else {
                    $whatsapp_link = '<a target="_blank" class="btn actionBtn" title="Whatsapp" href="https://wa.me/' . $page->dialcode . $page->mobile . '"><i class="fab fa-whatsapp contactIcon"></i></a>';
                }
                if($page->whatsapp){
                    $customResult['name'] .= $whatsapp_link;
                }
                $customResult['name'] .= '</div>';

                if($page->last_followup) {
                    $customResult['name'] .= "<div class='edu-tooltip px-2 py-2' style='border-radius: 8px; width: 300px !important; text-wrap: wrap; background-color: #EBEBEB; margin: 0px 0px 5px 0px !important;'><span class='pt-2' style='font-size: 13px !important;font-style: italic'>".mb_substr($folow_text, 0, 110) ."<span style='font-size: 20px;'>.....</span>
                    <span class='edu-tooltiptext'>" . $folow_text . "</span>
                    </span></div>";
                } else {
                    $customResult['name'] .= "<div></div>";
                }
                
                // Calculating data for tags
                $tagCount = 1;
                $today_date = time();
                $created_at_date = strtotime($page->created_at);
                $total_days_sec = (abs($today_date - $created_at_date));
                $lead_age = round($total_days_sec / (60 * 60 * 24));
                $customResult['name'] .= "<div style='width: 300px !important; display: flex; flex-wrap: wrap;'><span class='tagSuccess mb-1'>Lead Age: " . $lead_age . " Days</span>";

                $course_pref_count = DB::table('course_preference')->where('userid', $page->id)->count();
                if($course_pref_count){
                    $customResult['name'] .= "<span class='tagPrimary mb-1'>Course Pref: " . $course_pref_count . "</span>";
                }

                $course_sugg_count = DB::table('course_shortlisted')->where('student_id', $page->id)->where('staff_suggested', 1)->count();
                if($course_sugg_count){
                    $customResult['name'] .= "<span class='tagBrown mb-1'>Course Suggested: " . $course_sugg_count . "</span>";
                }
                if($page->overseas_study_level_selection){
                    $customResult['name'] .= "<span class='tagPurple mb-1'>" . $page->overseas_study_level_selection . "</span>";
                }
                if($page->country_interested){
                    $country_interested = explode(",",$page->country_interested);
                    $colorArray = [
                        'tagPrimary',
                        'tagDanger',
                        'tagSuccess',
                        'tagOrange',
                        'tagPurple',
                        'tagViolet',
                        'tagLightGreen',
                        'tagBrown',
                        'tagPink',
                    ];
                    foreach($country_interested as $country_interest){
                        $rand_no = rand(0,8);
                        $customResult['name'] .= "<span class='tagOrange mb-1'>" . $country_interest . "</span>";
                    }
                }
                if($page->overseas_course_intersted){
                    $customResult['name'] .= "<span class='tagViolet mb-1'>" . $page->overseas_course_intersted . "</span>";
                }
                if($page->services){
                    $services_interested = explode(",",$page->services);
                    $colorArray = [
                        'tagPrimary',
                        'tagDanger',
                        'tagSuccess',
                        'tagOrange',
                        'tagPurple',
                        'tagViolet',
                        'tagLightGreen',
                        'tagBrown',
                        'tagPink',
                    ];
                    foreach($services_interested as $services_interest){
                        $rand_no = rand(0,8);
                        $customResult['name'] .= "<span class='tagSuccess mb-1'>" . get_services($services_interest) . "</span>";
                    }
                }
                
                if($page->intake_year && $page->intake_month){
                    $customResult['name'] .= "<span class='tagOrange mb-1'>" . $page->intake_year . " " . date("M", mktime(0, 0, 0, $page->intake_month, 10)) . "</span>";
                }

                if($page->branch) {
                    $customResult['name'] .= "<span class='tagPink mb-1'>" . $page->branch_name . "</span>";
                }
		        if(config('app.product_code') == 'EDUCTRL_CRM'){
	                if($page->student_type == "study_abroad_course"){
	                    $customResult['name'] .= "<span class='tagBrown mb-1'>Study Abroad & Coaching</span>";
	                }
	                else if($page->student_type == "course"){
	                    $customResult['name'] .= "<span class='tagBrown mb-1'>Coaching</span>";
	                }
	                 else{
	                    $student_type = str_replace("_"," ",$page->student_type);
	                    $customResult['name'] .= "<span class='tagBrown mb-1'>" . ucwords($student_type) . "</span>";
	                }
		        }
                if($page->lead_source) {
                    //$customResult['name'] .= "<span class='tagSecondary mb-1' onmouseover='showLeadSourceDetail()'>" . $page->lead_source . ": " . get_lead_source_detail($page->id) . "</span>";
                    $customResult['name'] .= "<span class='tagSecondary mb-1' >" . $page->lead_source . "</span>";
                }
                $customResult['name'] .= "</div>";

                $customResult['status'] = '<div style="display: flex; ">';
                $lead_status_bg_color = "#FFFFFF";
                $lead_status_font_color = "#FFFFFF";
                if($page->lead_status) {
                    $lead_status_bg_color = get_lead_status_color($page->lead_status);
                    // $lead_status_font_color = get_lead_status_color($page->lead_status);
                }
                $customResult['status'] .= '<span class="tag" style="background-color:' . $lead_status_bg_color . '!important; height: 25px !important;">' . $page->lead_status . '</span>';

                if(!get_site_config('lead_followup_mandatory')){
                $customResult['status'] .= '<button type="button" class="btn actionBtn dropdown-toggle action_dropdown_btn" data-bs-toggle="dropdown" aria-expanded="true" title="Change Status" style="font-size: 11px !important; padding-top: 3px; padding-bottom: 3px; margin-left: 4px;">
                            <i class="fa fa-edit"></i>
                            </button>';
                    if($page->lead_status != $converted_lead_status) {
                        $customResult['status'] .= '<div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow" data-popper-placement="bottom-end">
                        <a href="#" class="py-1 dropdown-item"><b>Change Status to</b></a>
                        <div class="dropdown-divider"></div>';

                        foreach (lead_status_list() as $status_data) {
                            if ($status_data->status == $counselling_lead_status) {
                                $customResult['status'] .= '<button  data-id="' . $page->id . '" class="py-2 counselling-btn dropdown-item" style="margin-bottom: 0 !important" >
                                                            '.$counselling_lead_status.'
                                                            </button>';
                            } elseif($status_data->status == $disqualified_lead_status){
                                $customResult['status'] .= '<button data-id="' . $page->id . '" class="py-2 disqualified-btn dropdown-item" style="margin-bottom: 0 !important" >
                                                            '.$disqualified_lead_status.'
                                                            </button>';
                            }else{
                                // $customResult['status'] .= '<a href="' . route('admin.leads.changestatus', ['leadid' => $page->id, 'status' => $status_data->status]) . '"class="py-1 dropdown-item">' . $status_data->status . '</a>';
                                $customResult['status'] .= '<a href="#" data-lead_id="'.$page->id.'" data-lead_status="'.$status_data->status.'" id="'.$page->id.'" class="py-1 dropdown-item lead-status-row">' . $status_data->status . '</a>';
                            }
                        }
                        $customResult['status'] .= '</div>';
                    }
                }
                $customResult['status'] .= '</div>';
                if($page->lead_disqualified_reason && $page->lead_status == $disqualified_lead_status){
                    $customResult['status'] .= '<span class="" style="font-size: 11px">' . $page->lead_disqualified_reason . '</span>';
                }

                if($page->lead_status != $converted_lead_status) {
                    $customResult['actions'] =
                        '<div class="d-flex" role="group" aria-label="User Actions">
                                <button data-id="' . $page->id . '" data-toggle="tooltip" data-placement="top" title="Follow-Ups" class="btn btn-outline-primary followup-btn mx-1" style="padding: 4px 8px;">
                                <i class="fa fa-user-clock"></i>
                                </button>

                                <a title="Details" style="padding: 4px 8px;" class="btn btn-outline-success me-1" href="' . route('admin.auth.user.show', $page->id) . '"><i class="fa fa-eye"></i></a>
                                
                                <button style="padding: 4px 8px;" type="button" class="btn btn-outline-danger dropdown-toggle action_dropdown_btn" data-bs-toggle="dropdown" aria-expanded="true">
                                <b style="font-size: 13px; "><i class="fa fa-cog" style="width:13px;" aria-hidden="true"></i></b>
                                </button>
                                <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow" data-popper-placement="bottom-end">
                                    <a href="' . route('admin.leadmanagement.edit', $page->id) . '" class="py-2 dropdown-item "><i class="fas fa-edit text-sub"></i> &nbsp;Edit</a>
                                    <a href="' . url("admin/auth/user/".$page->id."/lead/password/change") . '" class="py-2 dropdown-item"><i class="fas fa-exchange-alt text-sub"></i> &nbsp;Change Password</a>
                                    <a href="' . route('admin.leadmanagement.destroy', $page->id) . '" class="py-1 dropdown-item" data-html="true" data-trans-title="Are you sure want to delete this Lead? <br><br><label style=&quot;color: red; font-size: 15px;&quot;>This action cannot be Undone!</label>" data-method="delete"><i class="fas fa-trash-alt text-sub"></i> &nbsp;Delete</a>
                                </div>';


                    $customResult['actions'] .= '</div>
                                </div>';
                } else {
                    $customResult['actions'] = "";
                }

                $data[] = $customResult;
            }
        }
        //\Log::debug('My User Id: ' . $my_user_id);
        $json_data = array(
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $data,
            "search" => $get_search,
            "Branch" => $my_branch,
            "user" => $my_user_id,
            "tags" => $tags_filter,
            "next_followup_counselling_date" => $next_followup_counselling_date,
        );

        return json_encode($json_data);
    }

    public function add_tag(Request $request){
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('lead create-update'))) {
            return response()->json([
                'success' => 0, 
                'message' => 'You do not have access permission to this feature.'
            ]);
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $lead = User::findOrFail($request->get('lead_id'));
        if($lead){
            //Comparing and merging values
            if($lead->tags!=''){
                $old_tags = explode(',',$lead->tags);
                $merged_values= array_unique(array_merge($old_tags, $request->lead_tags));
                $new_values = implode(',',$merged_values);
            }else{
                $merged_values= $request->lead_tags;
                $new_values = implode(',',$merged_values);
            }
            if (DB::table('users')->where("id", $lead->id)->update(['tags' => $new_values])){
            foreach($merged_values as $tags)
                {
                $tagsData = Tags::firstOrNew(['tag_name' => $tags]);
                $tagsData->tag_name = $tags;
                $tagsData->save();
                }
                return response()->json([
                    'success' => 1, 
                    'message' => 'Lead Tags Updated!'
                ]);
            }
            else {
                return response()->json([
                    'success' => 0,
                    'message' => 'Tag already exists!'
                ]);
            }
        }
    }

    public function remove_tag(Request $request){
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('lead create-update'))) {
            return response()->json([
                'success' => 0, 
                'message' => 'You do not have access permission to this feature.'
            ]);
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
		$lead = User::findOrFail($request->get('lead_id'));
        if($lead){
            if($lead->tags!=''){
                $old_tags = explode(',',$lead->tags);
                $tag_to_remove = $request->get('tag_name');
                $key = array_search($tag_to_remove, $old_tags);
                if (($key) !== false)
                {
                    unset($old_tags[$key]);
                    $new_values = implode(',',$old_tags);
                    if (DB::table('users')->where("id", $lead->id)->update(['tags' => $new_values])){
                        return response()->json([
                            'success' => 1, 
                            'message' => 'Tag Removed'
                        ]);
                    }else{
                        return response()->json([
                            'success' => 0, 
                            'message' => 'Caanot remove tag'
                        ]);
                    }
                }
            }
            else{
                return response()->json([
                    'success' => 0, 
                    'message' => 'No tag found for this lead'
                ]);
            }
        }
        else{
			return response()->json([
				'success' => 0, 
				'message' => 'Invalid Lead'
			]);
		}
	}

    public function get_lead_followup($lead_id)
    {
        $followup = DB::table('user_activity')->where("user_id", $lead_id)->where("type", "followup")->latest()->first();
        if ($followup) {
            return date('d M, g:i A', strtotime($followup->created_at)) . ": " . $followup->detail;
        } else {
            return 0;
        }
    }

    public function followups($id)
    {
        $lead = User::findOrFail($id);
        if (\Auth::user()->can('view assigned data only') && $lead->assigned_to != \Auth::user()->id) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $lead_details = UserDetails::where('userid', $id)->first();
        $lead_status = LeadStatus::orderBy('display_order', 'asc')->get();
        $lead_followups = UserActivity::where('user_id', $id)->latest()->get();
        $coursevalues = Course::find($lead->coaching_course_interested);
        $userRepo = new UserRepository();
        $staff = $userRepo->getNonStudentsTrainers();
        return view('backend.lead.followup_modal', compact('staff','lead', 'lead_details', 'lead_followups', 'coursevalues', 'lead_status'));
        //return view('backend.lead.lead_followups', compact('lead', 'lead_details', 'lead_followups', 'coursevalues', 'lead_status'));
    }

    public function counselling($id){
        $lead = User::findOrFail($id);
        if (\Auth::user()->can('view assigned data only') && $lead->assigned_to != \Auth::user()->id) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $userRepo = new UserRepository();
        $staff = $userRepo->getNonStudentsTrainers();
        return view('backend.lead.counselling_modal', compact('staff','lead'));
    }

    public function update_followups(Request $request, $id){
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('lead create-update'))) {
            return response()->json(['error' => 'You do not have access permission to this feature.']);
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $validator = \Validator::make($request->all(), [
            'followup_details' => 'required|max:500',
            'communication_mode' => 'required',
            'next_followup' => 'nullable|after:' . date('Y-m-d H:i:s')
        ]);

        if($request->get('status') == get_disqualified_lead_status()){
            $validator = \Validator::make($request->all(), [
                'lead_disqualified_reason' => 'required',
            ]);
        }

        if ($validator->fails()) {
            $message = $validator->getMessageBag()->toArray();

            if(isset($message['followup_details'][0])){
                return response()->json(['error' => $message['followup_details'][0]]);
            } elseif(isset($message['communication_mode'][0])){
                return response()->json(['error' => $message['communication_mode'][0]]);
            } elseif(isset($message['next_followup'][0])){
                return response()->json(['error' => $message['next_followup'][0]]);
            } elseif(isset($message['lead_disqualified_reason'][0])){
                return response()->json(['error' => $message['lead_disqualified_reason'][0]]);
            }
            // return redirect()->route('frontend.web-lead-error-page')->withErrors($validator)->withInput();
        }

        //counselling block
        $staffid = $request->counsellor;
        $leadid = $id;
        $counselling_datetime = $request->counselling_datetime;

        $changeLead = User::find($leadid);
        $old_status = $changeLead->lead_status;
        $new_status = "";

        if(isset($staffid) && isset($counselling_datetime)){
            $newDt = date('Y-m-d H:i:s', strtotime($counselling_datetime));
            //check if this staff is already assigned to any lead as counseller
            $checkCounseller = User::where("assigned_to", $staffid)->where("next_followup", $newDt)->first();
            $user = User::find($staffid);
            if (!$checkCounseller) {
                // if counseller is not assign to any counseller than
                \Log::debug("Consellor assigning");
                DB::table('users')->where("id", $leadid)->update([
                    'lead_status' => get_counselling_lead_status(), 
                    'assigned_to' => $staffid, 
                    'next_followup' => $newDt
                ]);

                $lead = User::find($leadid);
                $new_status = get_counselling_lead_status();
                //Adding activity
                $comm_mode = "";
                if($request->communication_mode){
                    $comm_mode = "<br><br>Mode of communication: ".$request->communication_mode;
                }
                $followup = new UserActivity;
                $followup->user_id = $leadid;
                $followup->type = 'others';
                $followup->staff = \Auth::user()->id;
                $followup->communication_mode = $request->communication_mode;
                $followup->lead_status_changed_to = get_counselling_lead_status();
                $followup->detail = "Lead status changed to Counselling. Counseller: " . get_user_full_name_by_id($user->id) . ", Previous Status: " . $old_status;
                $followup->detail .= "<br>".nl2br(preg_replace('/[\s]+/mu',' ', $request->get('followup_details')));
                $followup->save();
                $subject = "New Counselling Meeting Fixed";
                $email_message = "Hi $user->name, New Counselling Meeting is assigned to you.<br /><br />Lead Name: $lead->first_name $lead->last_name<br /><br />Mobile:$lead->mobile<br /><br />Email: $lead->email <br/><br/><a href=\"" . url("admin/leads/" . $leadid . "/followups") . "\">View Lead Details</a>";
                try {
                    //Mail::to($user->email)->send(new MailSend($subject, $email_message));
                    user_notify($user->email,$subject, $email_message);
                } catch (\Exception $e) {
                    $message = $e->getMessage();
                    \Log::debug("Mail Error: (New Counselling Meeting Fixed) " . $message);
                }
                
                // Send Push App Notification
                $message = "";
                $email_message = "";
                if(\Auth::user()->isAgent()){
                    // $message = "Lead Status Changed by Agent: " . get_user_full_name_by_id(\Auth::user()->id);
                    // $subject = $lead->first_name." ". $lead->last_name." ID: ". $lead->id. " Email: " . $lead->email . " Lead Status Changed by Agent: " . get_user_full_name_by_id(\Auth::user()->id);
                } else{
                    $message = "Lead Follow-up added. Lead Status changed by " . get_user_full_name_by_id(\Auth::user()->id);
                    $email_message = "Hi, <br>Lead Status Changed by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
                }
                
                //Sending email Notification
                $subject = "Lead: " . $lead->full_name . " (".$lead->id.") Status Changed to: $new_status";
                $email_message .= "<br><strong>Lead Details:</strong>
                <br>" . $lead->first_name ." ".$lead->last_name. 
                "<br>Old Status: " . $old_status . 
                "<br>New Status: " . $new_status . 
                "<br/>Mob: " . $lead->mobile . 
                "<br/>Email: " . $lead->email;
                send_mail_notification($lead->id,"","LEAD_STATUS_CHANGE",$subject,$email_message);
                
                $message .= ", Lead: <strong>" . $lead->full_name . "</strong> (".$lead->id.")";
                $subject = "";
                if($new_status){
                    $message .= ", Old Status: " . $old_status . ", New Status: <strong>" . $new_status."</strong> [COUNSELLING]";
                }
                send_in_app_notification(
                    $lead->id, 
                    $lead->id,
                    "LEAD_STATUS_CHANGE", 
                    $subject, 
                    $message,
                    "lead"
                );

                //Sending email to admin
                // $msg_details = "<p>New Counselling Meeting Fixed with counsellor: $user->name<br /><br />Lead Name: $lead->first_name $lead->last_name<br /><br />Mobile:$lead->mobile<br /><br />Email: $lead->email <br/><br/><a href=\"" . url("admin/leads/" . $leadid . "/followups") . "\">View Lead Details</a>";
                // if ($msg_details) {
                //     $email_message = "Dear Admin,<br><br>" . $msg_details;
                //     $recipient = new AdminRecipient();
                //     try {
                //         $recipient->notify(new AdminAlert("New Counselling Meeting Fixed", $email_message));
                //     } catch (\Exception $e) {
                //         $message = $e->getMessage();
                //         \Log::debug("Mail Error: (New Counselling Meeting Fixed) " . $message);
                //     }
                // }
                $notify_sms = get_sms_template('COUNSELLING_MEET_SCHEDULED');
                if ($notify_sms && $notify_sms->status) {
                    $notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
                    $notify_sms->message = str_replace("#siteurl#", url('/'), $notify_sms->message);
                    $notify_sms->message = str_replace("#first_name#", $user->first_name, $notify_sms->message);
                    $notify_sms->message = str_replace("#full_name#", $user->full_name, $notify_sms->message);
                    $user->sms($notify_sms->message, $notify_sms->template_id);
                }
                return response()->json(['success' => 'Counsellor Assigned!']);
            } else {
                \Log::debug("Consellor slot not available!");
                return response()->json(['error' => 'Selected Counsellor is already booked for selected date and time!']);
                //return redirect()->back()->withFlashDanger('Selected Counsellor is already booked for selected date and time!');
            }
            //counselling block end
        }else{
            // if status is not couselling

            $lead = User::find($id);
            $lead->last_followup = now();

            $converted = LeadStatus::where('converted_status', 1)->first();

            $comm_mode = "";
            if($request->communication_mode){
                $comm_mode = "<br><br>Mode of communication: ".$request->communication_mode;
            }
            if ($request->input('next_followup')) {
                $lead->next_followup = date("Y-m-d H:i", strtotime($request->get('next_followup')));
            }
            if(!$request->get('status')){
                //Adding activity
                $followup = new UserActivity;
                $followup->user_id = $leadid;
                $followup->type = 'others';
                $followup->staff = \Auth::user()->id;
                $followup->communication_mode = $request->communication_mode;
                $followup->detail = nl2br(preg_replace('/[\s]+/mu',' ', $request->get('followup_details')));
                $followup->save();
                $lead->save();
                if($request->form_type=='manual'){
                    return redirect()->route('admin.auth.user.show', $leadid)->withFlashSuccess('Lead Counselling Record saved!');
                }
            }
            
            if ($converted && $converted->status == $request->get('status')) { 
                // if status is converted   
                $converted_status = $converted->status;
                $lead_converted_by = $lead->assigned_to;
                if($lead->email){
                    if (DB::table('users')->where("id", $leadid)->update(['lead_converted_by'=> $lead_converted_by,'lead_status' => $converted_status, 'next_followup' => NULL,'overseas_status'=>get_default_student_status()])) {
                        // $lead->student_type = 'study_abroad_course';
                        $new_status = get_default_student_status();
                        if(!$lead->student_type){
                            if (config('app.product_code') == 'OVERSEAS') {
                                $lead->student_type = 'study_abroad';
                            } elseif (config('app.product_code') == 'TRAINING') {
                                $lead->student_type = 'course';
                            } else {
                                $lead->student_type = 'study_abroad_course';
                            }
                        }
                        
                        $lead->is_lead = 0;
                        $lead->confirmed = 1;
                        $lead->lead_converted_date = date("Y-m-d H:i:s");
                        $lead->student_created_at = date("Y-m-d H:i:s");
                        $lead->assignRole('user');
                        $pass = "";
                        if($lead->password){
                            \Log::debug("Lead already has password");
                            $lead->save();
                        }else{
                            \Log::debug("Lead Generate new password");
                            $pass = Str::random(6);
                            $lead->password = $pass;
                            $lead->save();

                            //send email to student
                            \Log::debug("Lead Convert: sending welcome mail");
                            $mail_tpl = MailTemplates::find("STUDENT_PASSWORD");
                            if ($mail_tpl && $mail_tpl->status) {
                                $email_message = $mail_tpl->message;
                                $email_message = str_ireplace("#sitename#", app_name(), $email_message);
                                $email_message = str_ireplace("#siteurl#", url(''), $email_message);
                                $email_message = str_ireplace("#first_name#", $lead->first_name, $email_message);
                                $email_message = str_ireplace("#full_name#", $lead->full_name, $email_message);
                                $email_message = str_ireplace("#email#", $lead->email, $email_message);
                                $email_message = str_ireplace("#password#", $pass, $email_message);
                                try {
                                    //$lead->notify(new UserAlert($mail_tpl->subject, $email_message));
                                    user_notify($lead, $mail_tpl->subject, $email_message);
                                } catch (\Exception $e) {
                                    $message = $e->getMessage();
                                    \Log::debug("Mail Error: (CONVERT LEAD)" . $message);
                                }
                            }

                            // Send Whatsapp
                            if (get_site_config('whatsapp_enabled')) {
                                $numbers = [$lead->whatsapp_dialcode.$lead->whatsapp];

                                $hook = 'student_password';

                                $customMessage = [
                                    'email'     => $lead->email,
                                    'password'  => $pass
                                ];

                                send_whatsapp_message($numbers, $hook, $lead->id, $customMessage);
                            }


                            $notify_sms = SMSTemplates::find("STUDENT_PASSWORD");
                            if ($notify_sms && $notify_sms->status) {
                                $notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
                                $notify_sms->message = str_replace("#siteurl#", url('/'), $notify_sms->message);
                                $notify_sms->message = str_replace("#first_name#", $lead->first_name, $notify_sms->message);
                                $notify_sms->message = str_replace("#full_name#", $lead->full_name, $notify_sms->message);
                                $notify_sms->message = str_replace("#password#", $pass, $notify_sms->message);
                                
                                \Log::debug("SMS Sending: (CONVERT LEAD)" . $notify_sms->message);
                                $numbers = [ $lead->dialcode.$lead->mobile ];
                                send_sms($numbers, $notify_sms->message, $notify_sms->template_id);
                            }
                        }
                        
                        //Adding activity
                        $followup = new UserActivity;
                        $followup->user_id = $leadid;
                        $followup->type = 'others';
                        $followup->staff = \Auth::user()->id;
                        $followup->lead_status_changed_to = $converted_status;
                        $followup->communication_mode = $request->communication_mode;
                        $followup->detail = "LEAD CONVERTED. ".nl2br(preg_replace('/[\s]+/mu',' ', $request->get('followup_details')));
                        $followup->save();

                        // Send Push App Notification
                        if(\Auth::user()->isAgent()){
                            $message = "Lead Status Changed by Agent: " . get_user_full_name_by_id(\Auth::user()->id);
                        } else{
                            $message = "Lead Follow-up added. Lead Status changed by " . get_user_full_name_by_id(\Auth::user()->id);
                            $email_message = "Hi, <br>Lead Status Changed by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
                        }
                        
                        //Sending email Notification
                        $subject = "Lead: " . $lead->full_name . " (".$lead->id.") Status Changed to: $new_status";
                        $email_message .= "<br><strong>Lead Details:</strong>
                        <br>" . $lead->first_name ." ".$lead->last_name. 
                        "<br>Old Status: " . $old_status . 
                        "<br>New Status: " . $new_status . 
                        "<br/>Mob: " . $lead->mobile . 
                        "<br/>Email: " . $lead->email;
                        send_mail_notification($lead->id,"","LEAD_STATUS_CHANGE",$subject,$email_message);
                        
                        $message .= ", Lead: <strong>" . $lead->full_name."</strong> (". $lead->id. ")";
                        if($new_status){
                            $message .= ", Old Status: " . $old_status . ", New Status: <strong>" . $new_status."</strong> [CONVERTED]";
                        }
                        $subject = "";
                        send_in_app_notification(
                            $lead->id, 
                            $lead->id,
                            "LEAD_STATUS_CHANGE", 
                            $subject, 
                            $message,
                            "lead"
                        );
                    } else {
                        return response()->json(['error' => 'This lead status change not allowed!']);
                        // return redirect()->route('admin.leadmanagementdetails')->withFlashDanger('This lead status change not allowed');
                    }
                }else{
                    return response()->json(['error' => 'Lead email missing. Email is required before converting to student!']);
                }
                return response()->json(['success' => 'Lead Converted Successfully!']);
                // return redirect()->route('admin.leadmanagementdetails')->withFlashSuccess('Lead Converted Successfully');
            }
            
            // if status is not couselling and not converted

            $followup = new UserActivity;
            $followup->user_id = $id;
            $followup->type = 'followup';
            $followup->staff = \Auth::user()->id;
            $followup->communication_mode = $request->communication_mode;
            $followup->detail = nl2br(preg_replace('/[\s]+/mu',' ', $request->get('followup_details')));
            if($lead->lead_status != $request->get('status')  && $request->get('status') != get_counselling_lead_status()) {
                $followup->detail .= "<br>LEAD STATUS CHANGED TO: " . $request->get('status') . ", Previous Status: " . $old_status;
                $followup->lead_status_changed_to = $request->get('status');
            }
            $followup->save();

            $lead->last_followup = now();
            $lead->save();

            if($lead->lead_status != $request->get('status') && $request->get('status') == get_counselling_lead_status()) {
                return redirect()->route('admin.leads.changestatus', [$lead->id, get_counselling_lead_status()]);
            }    

            $lead->lead_status = $request->get('status');
            $new_status = $request->get('status');
            if ($lead->lead_status == get_disqualified_lead_status()) {
                $lead->next_followup = NULL;
                $leadDetails = UserDetails::firstOrNew(array('userid' => $lead->id));
                $leadDetails->lead_disqualified_reason = $request->get('lead_disqualified_reason');
                $leadDetails->save();
            }else{
                if ($request->input('next_followup')) {
                    $lead->next_followup = date("Y-m-d H:i", strtotime($request->get('next_followup')));
                } else {
                    $lead->next_followup = NULL;
                }
            }
            $lead->save();

            // Send Push App Notification
            if($old_status != $new_status) {
                if(\Auth::user()->isAgent()){
                    $message = "Lead Status Changed by Agent: " . get_user_full_name_by_id(\Auth::user()->id);
                } else{
                    $message = "Lead Follow-up added. Lead Status changed by " . get_user_full_name_by_id(\Auth::user()->id);
                    $email_message = "Hi, <br>Lead Status Changed by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
                }
                
                //Sending email Notification
                $subject = "Lead: " . $lead->full_name . " (".$lead->id.") Status Changed to: $new_status";
                $email_message .= "<br><strong>Lead Details:</strong>
                <br>" . $lead->first_name ." ".$lead->last_name. 
                "<br>Old Status: " . $old_status . 
                "<br>New Status: " . $new_status . 
                "<br/>Mob: " . $lead->mobile . 
                "<br/>Email: " . $lead->email;
                send_mail_notification($lead->id,"","LEAD_STATUS_CHANGE",$subject,$email_message);

                $message .= ", Lead: <strong>" . $lead->full_name."</strong> (". $lead->id. ")";
                if($new_status){
                    $message .= ", Old Status: " . $old_status . ", New Status: <strong>" . $new_status."</strong>";
                }
                $subject = "";
                send_in_app_notification(
                    $lead->id, 
                    $lead->id,
                    "LEAD_STATUS_CHANGE", 
                    $subject, 
                    $message,
                    "lead"
                );
            }

            return response()->json(['success' => 'Lead Follow-up details saved!']);
            //return redirect()->route('admin.leadmanagement.followups', $id)->withFlashSuccess('Lead Follow-up details saved!');
        }
    
    }

    // public function update_notes(Request $request, $id)
    // {
    //     $leadupdate = User::find($id);
    //     $leadupdate->notes = $request->get('notes');
    //     $leadupdate->save();
    //     return redirect()->route('admin.leadmanagement.followups', $id)->withFlashSuccess('Lead Note updated!');
    // }

    public function assignStaff($leadid){
        $leaddata = User::find($leadid);
        if (\Auth::user()->can('view assigned data only') && $leaddata->assigned_to != \Auth::user()->id) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('lead-assignment'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }

        if (\Auth::user()->can('view assigned data only')) {
            $staff = User::where('id', \Auth::user()->id)->get();
        } else {
            $userRepo = new StaffRepository();
            $staff = $userRepo->getStaffUsers(get_staff_branch_ids(\Auth::user()->id));
        }

        return view('backend.lead.lead_assign_to_staff', ['leaddata' => $leaddata, 'staff' => $staff]);
    }


    public function bulkAssignStaff(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('lead-assignment'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        
        if (\Auth::user()->can('view assigned data only')) {
            $staff = User::where('id', \Auth::user()->id)->get();
        } else {
            $userRepo = new StaffRepository();
            $staff = $userRepo->getStaffUsers(get_staff_branch_ids(\Auth::user()->id));
        }
        $leaddata_arr = array();
        $id_arr = explode(',', $request->input('id_arr'));
        if (is_array($id_arr)) {
            foreach ($id_arr as $leadid) {
                $leaddata_arr[] = User::find($leadid);
            }
        }
        return view('backend.lead.bulk-lead-assign', ['leaddata_arr' => $leaddata_arr, 'staff' => $staff]);
    }

    public function assignStaffUpdate(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('lead-assignment'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        
        $staffid = $request->staff;
        $leadid = $request->lead_id;
        $user = User::find($staffid);
        $lead_assigned_success = false;
        $email_message_part = '';

        if (is_array($leadid)) {
            \Log::debug("Lead Assigned To array");
            foreach ($leadid as $each_leadid) {
                if (DB::table('users')->where("id", $each_leadid)->update(['assigned_to' => $staffid])) {
                    $lead = User::find($each_leadid);
                    $lead_assigned_success = true;

                    if(!$staffid){
                        $staffid = 0;
                    }
                    //Adding activity
                    $followup = new UserActivity;
                    $followup->user_id = $each_leadid;
                    $followup->type = 'lead_assignment';
                    $followup->lead_assigned_to = $staffid;
                    $followup->staff = \Auth::user()->id;
                    if($user){
                        $followup->detail = "LEAD ASSIGNED TO " . $user->name;
                    }else{
                        $followup->detail = "LEAD ASSIGNED REMOVED." ;
                    }
                    $followup->save();
                    
                    if($request->staff){
                        $staff = $request->staff;
                        
                        // New way to send email
                        //Sending email Notification
                        $subject = "Lead: " . $lead->full_name . " (".$lead->id.") Assigned to ".$user->full_name." by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
                        $email_message_part .= "<br> Lead Name: $lead->first_name $lead->last_name<br /><br />Mobile:$lead->mobile<br /><br />Email: $lead->email <br/><br/><a href=\"" . url("admin/leads/" . $each_leadid) . "\">View Lead Details</a>";
                        $email_message = "Hi $user->full_name, New leads assigned to you.<br />" . $email_message_part;
                        send_mail_notification($lead->id,"","LEAD_STUDENT_ASSIGMENT_STAFF",$subject,$email_message);

                        // Send Push App Notification
                        $message = "Lead <strong>" . $lead->full_name."</strong> (". $lead->id. ") assigned to <strong>".$user->full_name."</strong> by <strong>" . auth()->user()->full_name."</strong>";
                        $subject = "";
                        send_in_app_notification(
                            $each_leadid, 
                            $each_leadid,
                            "LEAD_STUDENT_ASSIGMENT_STAFF", 
                            $subject, 
                            $message,
                            "lead"
                        );
                    }
                } else {
                    return redirect()->route('admin.leadmanagementdetails')->withFlashDanger('Something Went Wrong');
                }
            }

            if ($lead_assigned_success) {
                if($staffid){

                    $notify_sms = get_sms_template('STAFF_LEAD_ASSIGNED');
                    if ($notify_sms && $notify_sms->status) {
                        $notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
                        $notify_sms->message = str_replace("#siteurl#", url('/'), $notify_sms->message);
                        $notify_sms->message = str_replace("#first_name#", $user->first_name, $notify_sms->message);
                        $notify_sms->message = str_replace("#full_name#", $user->full_name, $notify_sms->message);
                        $user->sms($notify_sms->message, $notify_sms->template_id);
                    }
                    return redirect()->route('admin.leadmanagementdetails')->withFlashSuccess('Staff Assigned!');
                }else{
                    return redirect()->route('admin.leadmanagementdetails')->withFlashSuccess('Staff Assignment removed!');
                }
            } else {
                return redirect()->route('admin.leadmanagementdetails')->withFlashSuccess('Staff Assigned!');
            }
        } else {
            \Log::debug("Lead Assigned To Single Value");

            if (DB::table('users')->where("id", $leadid)->update(['assigned_to' => $staffid])) {
                $lead = User::find($leadid);
                
                if(!$staffid){
                    $staffid = 0;
                }
                //Adding activity
                $followup = new UserActivity;
                $followup->user_id = $leadid;
                $followup->type = 'lead_assignment';
                $followup->lead_assigned_to = $staffid;
                $followup->staff = \Auth::user()->id;
                if($user){
                    $followup->detail = "LEAD ASSIGNED TO " . $user->name;
                }else{
                    $followup->detail = "LEAD ASSIGNED REMOVED." ;
                }
                $followup->save();
                if($user){
                    // Old way to send the lead assigned notification
                    // $subject = "New Lead Assigned";
                    // $email_message = "Hi $user->name, New lead assigned to you.<br /><br />Lead Name: $lead->first_name $lead->last_name<br /><br />Mobile:$lead->mobile<br /><br />Email: $lead->email <br/><br/><a href=\"" . url("admin/leads/" . $leadid) . "\">View Lead Details</a>";
                    // try {
                    //     Mail::to($user->email)->send(new MailSend($subject, $email_message));
                    // } catch (\Exception $e) {
                    //     $message = $e->getMessage();
                    //     \Log::debug("Mail Error: (New Leads Assigned) " . $message);
                    // }

                    $notify_sms = get_sms_template('STAFF_LEAD_ASSIGNED');
                    if ($notify_sms && $notify_sms->status) {
                        $notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
                        $notify_sms->message = str_replace("#siteurl#", url('/'), $notify_sms->message);
                        $notify_sms->message = str_replace("#first_name#", $user->first_name, $notify_sms->message);
                        $notify_sms->message = str_replace("#full_name#", $user->full_name, $notify_sms->message);
                        $user->sms($notify_sms->message, $notify_sms->template_id);
                    }

                    if(isset($request->staff)){
                        $staff = $request->staff;
                        
                        // New way to send email
                        //Sending email Notification
                        $subject = "Lead: " . $lead->full_name . " (".$lead->id.") Assigned to ".$user->full_name." by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
                        $email_message_part .= "<br> Lead Name: $lead->first_name $lead->last_name<br /><br />Mobile:$lead->mobile<br /><br />Email: $lead->email <br/><br/><a href=\"" . url("admin/leads/" . $lead->id) . "\">View Lead Details</a>";
                        $email_message = "Hi $user->full_name, New leads assigned to you.<br />" . $email_message_part;
                        send_mail_notification($lead->id,"","LEAD_STUDENT_ASSIGMENT_STAFF",$subject,$email_message);

                        // Send Push App Notification
                        $message = "Lead <strong>" . $lead->full_name."</strong> (". $lead->id. ") assigned to <strong>".$user->full_name."</strong> by staff <strong>" . auth()->user()->full_name."</strong>";
                        $subject = "";
                        send_in_app_notification(
                            $lead->id, 
                            $lead->id,
                            "LEAD_STUDENT_ASSIGMENT_STAFF",
                            $subject, 
                            $message,
                            "lead"
                        );
                    }
                    //return "Staff Assigned!";
                    // return redirect()->route('admin.leadmanagementdetails')->withFlashSuccess('Staff Assigned!');
                    return response()->json([
                        'success' => 1, 
                        'message' => 'Staff Assigned!'
                    ]);
                }
                
                // return redirect()->route('admin.leadmanagementdetails')->withFlashSuccess('Removed Staff Assigned!');
                return response()->json([
                    'success' => 1, 
                    'message' => 'Removed Staff Assigned!'
                ]);
            } else {
                // return redirect()->route('admin.leadmanagementdetails')->withFlashSuccess('Lead already assigned to staff!');
                return response()->json([
                    'success' => 0, 
                    'message' => 'Lead already assigned to staff!'
                ]);
            }
        }
    }

    public function bulkStatusChange(Request $request){
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('lead create-update'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        // if (!(\Auth::user()->isAdmin() || \Auth::user()->can('lead-assignment'))) {
        //     return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        // }
        $leaddata_arr = array();
        $id_arr = explode(',', $request->input('id_arr'));
        if (is_array($id_arr)) {
            foreach ($id_arr as $leadid) {
                $leaddata_arr[] = User::find($leadid);
            }
        }
        return view('backend.lead.bulk-status-change', ['leaddata_arr' => $leaddata_arr]);
    }

    public function bulkNextFollowupDateView(Request $request){

        $leaddata_arr = array();
        $id_arr = explode(',', $request->input('id_arr'));
        if (is_array($id_arr)) {
            foreach ($id_arr as $leadid) {
                $leaddata_arr[] = User::find($leadid);
            }
        }

        return view('backend.lead.bulk-lead-next-followup-update', ['leaddata_arr' => $leaddata_arr]);
    }

    public function bulkChangeStatus(Request $request){
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('lead create-update'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        // if (!(\Auth::user()->isAdmin() || \Auth::user()->can('lead-assignment'))) {
        //     return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        // }

        if($request->status == get_disqualified_lead_status_id()){
            $request->validate([
                'lead_disqualified_reason' => 'required',
            ]);
        }

        $all_err_msg = array();
        $status = $request->status;
        $leadid = $request->lead_id;
        $leadStatus = LeadStatus::where('id',$status)->first();
        $lead_assigned_success = false;

        if (is_array($leadid)) {
            \Log::debug("Lead changed status array");
           
            $changeCount = 0;
            foreach ($leadid as $each_leadid) {
                $followup = new UserActivity;
                $lead = User::findOrFail($each_leadid);
                $old_status = $lead->lead_status;
                $new_status = "";
                if ($lead->lead_status == $leadStatus->status) {
                    $err_msg = array();
                    $err_msg[] = "Lead: " . $lead->first_name . " " . $lead->last_name . " already in selected status.";
                    $all_err_msg = array_merge($all_err_msg, $err_msg);
                    continue;
                }

                $converted = LeadStatus::where('converted_status', 1)->first();
                if ($converted && $converted->status == $leadStatus->status) {    
                    $converted_status = $converted->status;
                    $lead_converted_by = $lead->assigned_to;
                    if($lead->email){
                        if (DB::table('users')->where("id", $each_leadid)->update([
                            'lead_converted_by'=> $lead_converted_by,
                            'lead_status' => $converted_status, 
                            'next_followup' => NULL,
                            'overseas_status'=>get_default_student_status()
                        ])) {
                            $new_status = get_default_student_status();
                            //CONCO
                            if(!$lead->student_type){
                                if(!$lead->student_type){
                                    if (config('app.product_code') == 'OVERSEAS') {
                                        $lead->student_type = 'study_abroad';
                                    } elseif (config('app.product_code') == 'TRAINING') {
                                        $lead->student_type = 'course';
                                    } else {
                                        $lead->student_type = 'study_abroad_course';
                                    }
                                }
                            }
                            $lead->is_lead = 0;
                            $lead->confirmed = 1;
                            $lead->lead_converted_date = date("Y-m-d H:i:s");
                            $lead->student_created_at = date("Y-m-d H:i:s");
                            $lead->assignRole('user');
                            $pass = "";
                            if($lead->password){
                                \Log::debug("Lead already has password");
                                $lead->save();
                            }else{
                                \Log::debug("Lead Generate new password");
                                $pass = Str::random(6);
                                $lead->password = $pass;
                                $lead->save();
            
                                //send email to student
                                \Log::debug("Lead Convert: sending welcome mail");
                                $mail_tpl = MailTemplates::find("STUDENT_PASSWORD");
                                if ($mail_tpl && $mail_tpl->status) {
                                    $email_message = $mail_tpl->message;
                                    $email_message = str_ireplace("#sitename#", app_name(), $email_message);
                                    $email_message = str_ireplace("#siteurl#", url(''), $email_message);
                                    $email_message = str_ireplace("#first_name#", $lead->first_name, $email_message);
                                    $email_message = str_ireplace("#full_name#", $lead->full_name, $email_message);
                                    $email_message = str_ireplace("#email#", $lead->email, $email_message);
                                    $email_message = str_ireplace("#password#", $pass, $email_message);
                                    try {
                                        //$lead->notify(new UserAlert($mail_tpl->subject, $email_message));
                                        user_notify($lead, $mail_tpl->subject, $email_message);
                                    } catch (\Exception $e) {
                                        $message = $e->getMessage();
                                        \Log::debug("Mail Error: (CONVERT LEAD)" . $message);
                                    }
                                }
                                
                                $notify_sms = SMSTemplates::find("STUDENT_PASSWORD");
                                if ($notify_sms && $notify_sms->status) {
                                    $notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
                                    $notify_sms->message = str_replace("#siteurl#", url('/'), $notify_sms->message);
                                    $notify_sms->message = str_replace("#first_name#", $lead->first_name, $notify_sms->message);
                                    $notify_sms->message = str_replace("#full_name#", $lead->full_name, $notify_sms->message);
                                    $notify_sms->message = str_replace("#password#", $pass, $notify_sms->message);
                                    
                                    \Log::debug("SMS Sending: (CONVERT LEAD)" . $notify_sms->message);
                                    $numbers = [ $lead->dialcode.$lead->mobile ];
                                    send_sms($numbers, $notify_sms->message, $notify_sms->template_id);
                                }
                            }
                            
                            //Adding activity
                            $followup->user_id = $each_leadid;
                            $followup->type = 'lead_status_change';
                            $followup->staff = \Auth::user()->id;
                            $followup->lead_status_changed_to = $converted_status;
                            $followup->detail = "LEAD CONVERTED. ";
                            $followup->save();

                            // Send Push App Notification
                            if(\Auth::user()->isAgent()){
                                $message = "Lead Status changed by Agent: " . get_user_full_name_by_id(\Auth::user()->id);
                            } else{
                                $message = "Lead Status changed by " . get_user_full_name_by_id(\Auth::user()->id);
                                $email_message = "Hi, <br>Lead Status Changed by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
                            }
                            
                            //Sending email Notification
                            $subject = "Lead: " . $lead->full_name . " (".$lead->id.") Status Changed to: $new_status";
                            $email_message .= "<br><strong>Lead Details:</strong>
                            <br>" . $lead->first_name ." ".$lead->last_name. 
                            "<br>Old Status: " . $old_status . 
                            "<br>New Status: " . $new_status . 
                            "<br/>Mob: " . $lead->mobile . 
                            "<br/>Email: " . $lead->email;
                            send_mail_notification($lead->id,"","LEAD_STATUS_CHANGE",$subject,$email_message);
                            
                            $message .= ", Lead: <strong>" . $lead->full_name."</strong> (". $lead->id. ")";
                            if($new_status){
                                $message .= ", Old Status: " . $old_status . ", New Status: <strong>" . $new_status."</strong>";
                            }
                            $subject = "";
                            send_in_app_notification(
                                $lead->id, 
                                $lead->id,
                                "LEAD_STATUS_CHANGE", 
                                $subject, 
                                $message,
                                "lead"
                            );
                        } else {
                            $err_msg[] = "This lead : " . $lead->first_name . " " . $lead->last_name . " status change not allowed.";
                            $all_err_msg2 = array_merge($all_err_msg, $err_msg);
                        }
                    }else{
                        $err_msg[] = "Lead ID: ".$lead->id.", Lead email missing. Email is required before converting to student!";
                        $all_err_msg2 = array_merge($all_err_msg, $err_msg);
                    }
                    // return response()->json(['success' => 'Lead Converted Successfully!']);
                    // return redirect()->route('admin.leadmanagementdetails')->withFlashSuccess('Lead Converted Successfully');
                }else{
                    $disqualified = LeadStatus::where('disqualified_status', 1)->first();        
                    if ($disqualified) {
                        $disqualified_status = $disqualified->status;
                    }
                    if (DB::table('users')->where("id", $each_leadid)->update(['lead_status' => $leadStatus->status])) {
                        $new_status = $leadStatus->status;
                        if ($leadStatus->status == $disqualified_status) {
                            $lead->next_followup = NULL;
                            $lead->save();

                            $leadDetails = UserDetails::firstOrNew(array('userid' => $lead->id));
                            $leadDetails->lead_disqualified_reason = $request->get('lead_disqualified_reason');
                            $leadDetails->save();
                        }

                        $changeCount += 1;
                        $lead_assigned_success = true;
                        //Adding activity
                        $followup->user_id = $each_leadid;
                        $followup->type = 'lead_status_change';
                        $followup->staff = \Auth::user()->id;
                        $followup->lead_status_changed_to = $status;
                        $followup->detail = "LEAD STATUS CHANGE TO " . (get_leads_status_by_id($status)) ." (BULK)";
                        $followup->save();

                        // Send Push App Notification
                        if(\Auth::user()->isAgent()){
                            // $message = "Lead Status Changed by Agent: " . get_user_full_name_by_id(\Auth::user()->id);
                        } else{
                            $message = "Lead Status changed by " . get_user_full_name_by_id(\Auth::user()->id);
                            $email_message = "Hi, <br>Lead Status Changed by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
                        }
                        
                        //Sending email Notification
                        $subject = "Lead: " . $lead->full_name . " (".$lead->id.") Status Changed to: $new_status";
                        $email_message .= "<br><strong>Lead Details:</strong>
                        <br>" . $lead->first_name ." ".$lead->last_name. 
                        "<br>Old Status: " . $old_status . 
                        "<br>New Status: " . $new_status . 
                        "<br/>Mob: " . $lead->mobile . 
                        "<br/>Email: " . $lead->email;
                        send_mail_notification($lead->id,"","LEAD_STATUS_CHANGE",$subject,$email_message);
                        
                        $message .= ", Lead: <strong>" . $lead->full_name."</strong> (". $lead->id. ")";
                        if($new_status){
                            $message .= ", Old Status: " . $old_status . ", New Status: <strong>" . $new_status."</strong>";
                        }
                        $subject = "";
                        send_in_app_notification(
                            $lead->id, 
                            $lead->id,
                            "LEAD_STATUS_CHANGE", 
                            $subject, 
                            $message,
                            "lead"
                        );
                    } else {
                        $err_msg[] = "This lead : " . $lead->first_name . " " . $lead->last_name . " status change not allowed.";
                        $all_err_msg2 = array_merge($all_err_msg, $err_msg);
                        // return redirect()->route('admin.leadmanagementdetails')->with('flash_danger',implode('<br>',$all_err_msg));
                    }
                }

            }

            if (empty($all_err_msg) && $changeCount != 0) {
                return redirect()->route('admin.leadmanagementdetails')->withFlashSuccess('Lead Status Changed Successfully!');
            } else if ((!empty($all_err_msg)) && $changeCount == 0){
                return redirect()->route('admin.leadmanagementdetails')->with('flash_danger',implode('<br>',$all_err_msg));
            } else if ((!empty($all_err_msg2)) && $changeCount == 0){
                return redirect()->route('admin.leadmanagementdetails')->with('flash_danger',implode('<br>',$all_err_msg2));
            } else if ((!empty($all_err_msg2)) && $changeCount != 0){
                return redirect()->route('admin.leadmanagementdetails')->withFlashSuccess('Lead Status Changed Successfully!')->with('flash_danger',implode('<br>',$all_err_msg2));
            } else {
                return redirect()->route('admin.leadmanagementdetails')->withFlashSuccess('Lead Status Changed Successfully!')->with('flash_danger',implode('<br>',$all_err_msg));
            }

        } 
    }

    public function bulkNextFollowupDateUpdate(Request $request){
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('lead create-update'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        // if (!(\Auth::user()->isAdmin() || \Auth::user()->can('lead-assignment'))) {
        //     return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        // }

        if (\Auth::user()->can('view assigned data only') && $user->assigned_to != \Auth::user()->id) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }

        $leadid = $request->lead_id;
        $next_followup = $request->next_followup;
        $newDt = date('Y-m-d H:i:s', strtotime($next_followup));

        if (is_array($leadid)) {
            foreach ($leadid as $each_leadid) {
                if($request->next_followup){
                    $lead = User::findOrFail($each_leadid);
                    $lead->next_followup = $newDt;
                    $lead->save();

                    $followup = new UserActivity;
                    $followup->user_id = $each_leadid;
                    $followup->type = 'others';
                    $followup->staff = \Auth::user()->id;
                    $followup->detail = "NEXT FOLLOW-UP DATE UPDATED TO: " .  $newDt;
                    $followup->save();
                }else{
                    $lead = User::findOrFail($each_leadid);
                    $lead->next_followup = null;
                    $lead->save();

                    $followup = new UserActivity;
                    $followup->user_id = $each_leadid;
                    $followup->type = 'others';
                    $followup->staff = \Auth::user()->id;
                    $followup->detail = "NEXT FOLLOW-UP DATE UPDATED TO: --";
                    $followup->save();
                }
            }
        }

        return redirect()->route('admin.leadmanagementdetails')->withFlashSuccess('Lead Next Folow-up Updated Successfully');
    }

    public function create()
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('lead create-update'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $batchs = Batch::orderBy('created_at', 'DESC')->get();
        $courses = Course::orderBy('title', 'ASC')->get();
        $countries = Country::where('overseas_status', 1)->orderBy('title_en', 'ASC')->get();
        $branch = get_staff_branches(\Auth::user()->id);

        if (\Auth::user()->can('view assigned data only')) {
            $staff = User::where('id', \Auth::user()->id)->get();
        } else {
            $userRepo = new StaffRepository();
            $staff = $userRepo->getStaffUsers(get_staff_branch_ids(\Auth::user()->id));
        }
        $dialcodes = Country::orderBy('country_code', 'asc')->get(['tel as code', 'code as country_code', 'title_en as name']);
        $country_list = Country::pluck('title_en', 'id');

        $custom_attributes = DB::table('custom_attributes')->where('for_lead', 1)->orderBy('display_order','asc')->get(["custom_attributes.*"]);
        $welcome_email = 0;
        $mail_tpl = MailTemplates::find("LEAD_WELCOME");
        if ($mail_tpl && $mail_tpl->status) {
            $welcome_email = 1;
        }

        return view('backend.lead.lead_create', ['welcome_email' => $welcome_email, 'courses' => $courses, 'countries' => $countries, 'batchs' => $batchs, 'branch' => $branch, 'staff' => $staff, 'dialcodes' => $dialcodes, 'country_list' => $country_list,'custom_attributes' =>$custom_attributes]);
    }

    public function store(LeadRequest $request){
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('lead create-update'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        if(get_site_config('lead_create_admin_mandatory') == 'email'){
            $request->validate([
                'email' => 'required|email:filter,filter_unicode|unique:users',
                'mobile' => ['nullable', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH')],
            ]);
        } elseif(get_site_config('lead_create_admin_mandatory') == 'email_and_mobile'){
            $request->validate([
                'email' => 'required|email:filter,filter_unicode|unique:users',
                'mobile' => ['required', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH'), Rule::unique('users')],
            ]);
        } elseif(get_site_config('lead_create_admin_mandatory') == 'email_or_mobile'){
            if($request->get('email') == "" && $request->get('mobile') == ""){
                return redirect()->back()->withFlashDanger('Email or Mobile is Required');
            } else{
                $request->validate([
                    'email' => 'nullable|email:filter,filter_unicode|unique:users',
                    'mobile' => ['nullable', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH'), Rule::unique('users')],
                ]);
            }
        } elseif(get_site_config('lead_create_admin_mandatory') == 'mobile'){
            $request->validate([
                'email' => 'nullable|email:filter,filter_unicode|unique:users',
                'mobile' => ['required', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH'), Rule::unique('users')],
            ]);            
        }

        //Checking custom attributes
        $custom_attributes = DB::table('custom_attributes')->where('for_lead', 1)->orderBy('display_order','asc')->get(["custom_attributes.*"]);
        $attributes_json = "";
        if(count($custom_attributes)){
            $all_atts = array();
            foreach($custom_attributes as $attrs){
                $name = $attrs->attr_name;
                $all_atts[$attrs->attr_name] = $request->$name;
                if($attrs->laravel_rules){
                    $request->validate([
                        "$attrs->attr_name" => "$attrs->laravel_rules",
                    ]);
                }
            }
            $attributes_json = json_encode($all_atts);
        }
        //Checking custom attributes
        
        $country_interested = "";
        $study_degree = "";
        $country_pref = $request->input('country_pref');
        if (!empty($country_pref) && count($country_pref)) {
            $country_interested = implode(",", $request->get('country_pref'));
        }
        
        $service_interested = "";
        $service_pref = $request->input('services');
        if (!empty($service_pref) && count($service_pref)) {
            $service_interested = implode(",", $request->get('services'));
        }

        if (!empty($request->input('date_of_birth'))) {
            $dob = substr($request->input('date_of_birth'), 6, 4) . "-" . substr($request->input('date_of_birth'), 3, 2) . "-" . substr($request->input('date_of_birth'), 0, 2);
        } else {
            $dob = NULL;
        }

        if (!empty($request->input('intake'))) {
            $intake = $request->input('intake');
            $intatake_arr =  explode(" ", $intake);
        } else {
            $intatake_arr = array(null, null);
        }

        // dd($request->get('password'));
        // $password = $request->get('password');
        // if($request->get('password')){
        //     $password = Hash::make('password');
        // }before:'.now()->subYears(18)->toDateString()

        if($request->input('study_level')){
            $study_degree = get_study_level_degree_level($request->input('study_level'));
        }else{
            $study_degree = NULL;
        }

        if ($request->input('referred_by')) {
            $ref_by = $request->input('referred_by');
        } else {
            $ref_by = 0;
        }
        $refcode = generate_refcode($request->get('first_name'));

        $next_followup = date("Y-m-d H:i", strtotime($request->get('next_followup')));
        $leaddetails = new User([
            'first_name' => $request->get('first_name'),
            'last_name' => $request->get('last_name'),
            'email' => $request->get('email'),
            // 'password' => $request->get('password'),
            'dialcode' => $request->get('dialcode'),
            'mobile' => $request->get('mobile'),
            'whatsapp_dialcode' => $request->get('whatsapp_dialcode'),
            'whatsapp' => $request->get('whatsapp_number'),
            'alternate_contact' => $request->get('alternate_contact'),
            'gender' => $request->get('gender'),
            'birthday' => $dob,
            // 'address_1' => $request->get('address'),
            'country' => $request->get('country'),
            'state' => $request->get('state'),
            'city' => $request->get('city'),
            'coaching_course_interested' => $request->get('course'),
            'country_interested' => $country_interested,
            'overseas_study_level' => $study_degree,
            'overseas_study_level_selection' => $request->get('study_level'),
            'overseas_course_intersted' => $request->get('course_interested'),
            'student_type' => $request->get('leadtype'),
            'lead_status' => get_default_lead_status(),
            'lead_source' => $request->get('lead_source'),
            'services' => $service_interested,
            'confirmed' => 1,
            'branch' => $request->get('branch'),
            'assigned_to' => $request->get('assign_to'),
            'ref_by' => $ref_by,
            'refcode'   => $refcode,
            'created_mode' => "staff",
            'created_by' => \Auth::user()->id,
            'next_followup' => $next_followup,
            'is_lead'   => 1
        ]);
        $leaddetails->save();

        if($request->get('password')){
            $leaddetails->password = $request->get('password');
            $leaddetails->save();
        }
        $success_msg = 'Lead added successfully';
        
        $userdetails = new UserDetails([
            'userid'    => $leaddetails->id,
            'highest_level_education' => $request->get('qualification'),
            'qualification_score' => $request->get('qualification_score'),
            'passout_year' => $request->get('passout_year'),
            'current_course' => $request->get('currently_studying_course'),
            // 'cgpa' => $request->get('cgpa'),
            'ielts' => $request->get('ielts'),
            'toefl' => $request->get('toefl'),
            'pte' => $request->get('pte'),
            'gre' => $request->get('gre'),
            'user_data_js' => $attributes_json,
            'duolingo' => $request->get('duolingo'),
            'work_experience' => $request->get('work_experience'),
            'accommodation' => $request->get('accommodation'),
            'study_permit' => $request->get('study_permit'),
            'education_loan' => $request->get('education_loan'),
            'intake_year' => $intatake_arr[1],
            'intake_month' => $intatake_arr[0],
            'lead_source_detail' => $request->get('lead_source_detail'),
            'lead_campaign_name' => $request->get('campaign_name'),
            'lead_notes' => $request->get('note')
        ]);
        $userdetails->save();

        //set the role
        // $leaddetails->assignRole('user');

        //Notify admin
        \Log::debug("Notify Admin: (ADMIN MAIL - Lead Generated)");
        $msg_details = "New Lead Added by Staff.<br /><br />Name: " . $request->get('first_name') . ' ' . $request->get('last_name') . "<br />Email: " . $request->get('email') . "<br />Mobile: " . $request->get('dialcode') . ' ' . $request->get('mobile') . "<br />Gender: " . $request->get('gender') . "<br />Lead Type: " . $request->get('leadtype') . "<br />Lead Source: " . $request->get('lead_source') . "<br />Assigned to: " . get_user_full_name_by_id($request->get('assign_to'));
        
        // if ($msg_details) {
            //     $email_message = "Dear Admin,<br><br>" . $msg_details;
        //     $recipient = new AdminRecipient();
        //     try {
        //         $recipient->notify(new AdminAlert("New Lead Added", $email_message));
        //     } catch (\Exception $e) {
        //         $message = $e->getMessage();
        //         \Log::debug("Mail Error: (ADMIN MAIL - Lead Added) " . $message);
        //     }
        // }
        
        $notify_emails = get_site_config('event_notification_email');
        if($notify_emails) {
            send_event_notification_email(explode(",", $notify_emails), "New Lead Added", $msg_details);
        } 

        $followup = new UserActivity;
        $followup->user_id = $leaddetails->id;
        $followup->type = 'others';
        $followup->staff = \Auth::user()->id;
        $followup->detail = "LEAD CREATED & ASSIGNED TO: " . get_user_full_name_by_id($request->get('assign_to'));
        $followup->save();

        //Email to lead
        // if (get_site_config('lead_welcome_email_lead_create')) {
            \Log::debug("Lead: sending welcome mail to lead");
            $mail_tpl = MailTemplates::find("LEAD_WELCOME");
            
            if ($mail_tpl && $mail_tpl->status) {
                $email_message = $mail_tpl->message;
                $full_name = $request->get('first_name') . ' ' . $request->get('last_name');
                $email_message = str_ireplace("#sitename#", app_name(), $email_message);
                $email_message = str_ireplace("#siteurl#", url(''), $email_message);
                $email_message = str_ireplace("#first_name#", $request->get('first_name'), $email_message);
                $email_message = str_ireplace("#full_name#", $full_name, $email_message);
                $email_message = str_ireplace("#email#", $request->get('email'), $email_message);
                $email_message = str_ireplace("#mobile#", $request->get('dialcode') . ' ' . $request->get('mobile'), $email_message);
                $email_message = str_ireplace("#password#", $request->get('password'), $email_message);
                try {
                    //$leaddetails->notify(new UserAlert($mail_tpl->subject, $email_message));
                    user_notify($leaddetails, $mail_tpl->subject, $email_message);
                    \Log::debug("Lead: mail sent to user- " . $email_message);
                    UserActivity::create(['user_id' => $leaddetails->id, 'type' => 'others', 'staff' => \Auth::user()->id, 'detail' => "Email Sent: Subject:" . $mail_tpl->subject . "<br>Message:" . $email_message]);
                } catch (\Exception $e) {
                    $message = $e->getMessage();
                    \Log::debug("Mail Error: (NEW LEAD) " . $message);
                }
            }

            // Send Whatsapp 
            if (get_site_config('whatsapp_enabled')) {
                $numbers = [$leaddetails->whatsapp_dialcode.$leaddetails->whatsapp];

                $hook = 'lead_welcome';

                send_whatsapp_message($numbers, $hook, $leaddetails->id);
            }



            $notify_sms = SMSTemplates::find("LEAD_WELCOME");
            if ($notify_sms && $notify_sms->status) {
                $full_name = $request->get('first_name') . ' ' . $request->get('last_name');
                $notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
                $notify_sms->message = str_replace("#siteurl#", url('/'), $notify_sms->message);
                $notify_sms->message = str_replace("#first_name#", $request->get('first_name'), $notify_sms->message);
                $notify_sms->message = str_replace("#full_name#", $full_name, $notify_sms->message);
                $notify_sms->message = str_replace("#password#", $request->get('password'), $notify_sms->message);
                
                \Log::debug("SMS Sending: (NEW LEAD)" . $notify_sms->message);
                $numbers = [ $request->get('dialcode').$request->get('mobile') ];
                send_sms($numbers, $notify_sms->message, $notify_sms->template_id);
            }
        // }

        // Send Push App Notification
        if(\Auth::user()->isAgent()){
            $message = "Lead <strong>".$leaddetails->full_name."</strong> (". $leaddetails->id. ") added by agent";
            $email_message = "Hi, <br><br>Lead Created by Agent: " . get_user_full_name_by_id(\Auth::user()->id);
        } else{
            $message = "Lead <strong>".$leaddetails->full_name."</strong> (". $leaddetails->id. ") added by staff";
            $email_message = "Hi, <br><br>Lead Created by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
        }

        // New way to send email
        //Sending email Notification
        $subject = "Lead: " . $leaddetails->full_name . " (".$leaddetails->id.") Created by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
        $email_message_part = "<br />Mobile:$leaddetails->mobile<br /><br />Email: $leaddetails->email <br/><br/><a href=\"" . url("admin/leads/" . $leaddetails->id) . "\">View Lead Details</a>";
        $email_message .= "<br><br>Lead: " . $leaddetails->full_name . " (".$leaddetails->id.") Created by Staff: " . get_user_full_name_by_id(\Auth::user()->id)."<br />" . $email_message_part;
        send_mail_notification($leaddetails->id,"","LEAD_STUDENT_CREATED",$subject,$email_message);

        $subject = "";
        send_in_app_notification(
            $leaddetails->id, 
            $leaddetails->id,
            "LEAD_STUDENT_CREATED", 
            $subject, 
            $message,
            "lead"
        );

        if($request->get('assign_to') && ($request->get('assign_to') != \Auth::user()->id)){
            $staff = $request->get('assign_to');
            //Sending email Notification
            $subject = "New Lead " . $leaddetails->full_name . " (".$leaddetails->id.") assigned to ".get_user_full_name_by_id($staff)." by " . auth()->user()->full_name."";
            $email_message_part = "<br>Lead Name: $leaddetails->first_name $leaddetails->last_name<br /><br />Mobile:$leaddetails->mobile<br /><br />Email: $leaddetails->email <br/><br/><a href=\"" . url("admin/auth/user/" . $leaddetails->id) . "\">View Lead Details</a>";
            $email_message = "Hi ".get_user_full_name_by_id($staff).", New lead assigned to you.<br />" . $email_message_part;
            send_mail_notification($leaddetails->id,"","LEAD_STUDENT_ASSIGMENT_STAFF",$subject,$email_message);

            // Send Whatsapp
            if (get_site_config('whatsapp_enabled')) {
                $staff_user = User::find($staff);
                $numbers = [$staff_user->whatsapp_dialcode.$staff_user->whatsapp]; 

                $hook = 'staff_lead_assigned';

                send_whatsapp_message($numbers, $hook, $staff_user->id);
            }

            // Send Push App Notification
            $message = "New Lead <strong>" . $leaddetails->full_name . "</strong> (".$leaddetails->id.") assigned to <strong>".get_user_full_name_by_id($staff)."</strong> by <strong>" . auth()->user()->full_name."</strong>";
            $subject = "";

            send_in_app_notification(
                $leaddetails->id, 
                $leaddetails->id,
                "LEAD_STUDENT_ASSIGMENT_STAFF", 
                $subject, 
                $message,
                "lead"
            );
        }
        
        return redirect()->route('admin.leadmanagementdetails')->withFlashSuccess($success_msg);
    }

    public function changestatus(Request $request){
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('lead create-update'))) {
            return response()->json(['success' => 0, 'message' => 'You do not have access permission to this feature.']);
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        \Log::debug("Lead : changestatus()");
        $leadid = $request->lead_id;
        $status = $request->lead_status;
        $lead = User::findOrFail($leadid);
        $old_status = $lead->lead_status;
        $new_status = "";

        if ($lead->lead_status == $status) {
            return response()->json([
                'success' => 0, 
                'message' => 'Lead already in selected status'
            ]);
            // return redirect()->route('admin.leadmanagementdetails')->withFlashDanger('Lead already in selected status');
        }

        $converted = LeadStatus::where('converted_status', 1)->first();
        if ($converted && $converted->status == $status) {    
            $converted_status = $converted->status;
            $lead_converted_by = $lead->assigned_to;
            if($lead->email){
                if (DB::table('users')->where("id", $leadid)->update(['lead_converted_by' => $lead_converted_by,'lead_status' => $converted_status, 'next_followup' => NULL,'overseas_status'=>get_default_student_status()])) {
                    $new_status = $converted_status;
                    if(!$lead->student_type){
                        if(!$lead->student_type){
                            if (config('app.product_code') == 'OVERSEAS') {
                                $lead->student_type = 'study_abroad';
                            } elseif (config('app.product_code') == 'TRAINING') {
                                $lead->student_type = 'course';
                            } else {
                                $lead->student_type = 'study_abroad_course';
                            }
                        }
                    }
                    $lead->is_lead = 0;
                    $lead->confirmed = 1;
                    $lead->lead_converted_date = date("Y-m-d H:i:s");
                    $lead->student_created_at = date("Y-m-d H:i:s");
                    $lead->assignRole('user');
                    $pass = "";
                    if($lead->password){
                        \Log::debug("Lead already has password");
                        $lead->save();
                    }else{
                        \Log::debug("Lead Generate new password");
                        $pass = Str::random(6);
                        $lead->password = $pass;
                        $lead->save();

                        //send email to student
                        \Log::debug("Lead Convert: sending welcome mail");
                        $mail_tpl = MailTemplates::find("STUDENT_PASSWORD");
                        if ($mail_tpl && $mail_tpl->status) {
                            $email_message = $mail_tpl->message;
                            $email_message = str_ireplace("#sitename#", app_name(), $email_message);
                            $email_message = str_ireplace("#siteurl#", url(''), $email_message);
                            $email_message = str_ireplace("#first_name#", $lead->first_name, $email_message);
                            $email_message = str_ireplace("#full_name#", $lead->full_name, $email_message);
                            $email_message = str_ireplace("#email#", $lead->email, $email_message);
                            $email_message = str_ireplace("#password#", $pass, $email_message);
                            try {
                                //$lead->notify(new UserAlert($mail_tpl->subject, $email_message));
                                user_notify($lead, $mail_tpl->subject, $email_message);
                                \Log::debug("Mail Success: (CONVERT LEAD)" . $email_message);
                            } catch (\Exception $e) {
                                $message = $e->getMessage();
                                \Log::debug("Mail Error: (CONVERT LEAD)" . $message);
                            }
                        }


                        //Whatsapp
                        if (get_site_config('whatsapp_enabled')) {
                            $numbers = [$lead->whatsapp_dialcode.$lead->whatsapp];

                            $customMessage = [
                                'email'  => $lead->email,
                                'password'  => $pass,
                            ];

                            $hook = 'student_password';

                            send_whatsapp_message($numbers, $hook, $lead->id,$customMessage);
                        }

                        $notify_sms = SMSTemplates::find("STUDENT_PASSWORD");
                        if ($notify_sms && $notify_sms->status) {
                            $notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
                            $notify_sms->message = str_replace("#siteurl#", url('/'), $notify_sms->message);
                            $notify_sms->message = str_replace("#first_name#", $lead->first_name, $notify_sms->message);
                            $notify_sms->message = str_replace("#full_name#", $lead->full_name, $notify_sms->message);
                            $notify_sms->message = str_replace("#password#", $pass, $notify_sms->message);
                            
                            \Log::debug("SMS Sending: (CONVERT LEAD)" . $notify_sms->message);
                            $numbers = [ $lead->dialcode.$lead->mobile ];
                            send_sms($numbers, $notify_sms->message, $notify_sms->template_id);
                        }
                    }
                    //Adding activity
                    $followup = new UserActivity;
                    $followup->user_id = $leadid;
                    $followup->type = 'lead_status_change';
                    $followup->lead_status_changed_to = $converted_status;
                    $followup->staff = \Auth::user()->id;
                    $followup->detail = "LEAD CONVERTED";
                    $followup->save();

                    // Send Push App Notification
                    if(\Auth::user()->isAgent()){
                        // $message = "Lead Status Changed by Agent: " . get_user_full_name_by_id(\Auth::user()->id);
                    } else{
                        $message = "Lead CONVERTED by " . get_user_full_name_by_id(\Auth::user()->id);
                        $email_message = "Hi, <br>Lead Status Changed by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
                    }
                    
                    //Sending email Notification
                    $subject = "Lead: " . $lead->full_name . " (".$lead->id.") Status Changed to: $new_status";
                    $email_message .= "<br><strong>Lead Details:</strong>
                    <br>" . $lead->first_name ." ".$lead->last_name. 
                    "<br>Old Status: " . $old_status . 
                    "<br>New Status: " . $new_status . 
                    "<br/>Mob: " . $lead->mobile . 
                    "<br/>Email: " . $lead->email;
                    send_mail_notification($lead->id,"","LEAD_STATUS_CHANGE",$subject,$email_message);
                    
                    
                    $subject = "";
                    $message .= ", Lead: <strong>" . $lead->full_name."</strong> (". $lead->id. ")";
                    if($new_status){
                        $message .= ", Old Status: " . $old_status . ", New Status: <strong>" . $new_status."</strong>";
                    }
                    send_in_app_notification(
                        $lead->id, 
                        $lead->id,
                        "LEAD_STATUS_CHANGE", 
                        $subject, 
                        $message,
                        "lead"
                    );

                    // return redirect()->route('admin.leadmanagementdetails')->withFlashSuccess('Lead Status Changed Successfully');
                    return response()->json([
                        'success' => 1, 
                        'message' => 'Lead Status Changed Successfully'
                    ]);
                } else {
                    // return redirect()->route('admin.leadmanagementdetails')->withFlashDanger('This lead status change not allowed');
                    return response()->json([
                        'success' => 0, 
                        'message' => 'This lead status change not allowed'
                    ]);
                }
            } else{
                // return redirect()->route('admin.leadmanagementdetails')->withFlashDanger('Lead email missing. Email is required before converting to student!');
                return response()->json([
                    'success' => 0, 
                    'message' => 'Lead email missing. Email is required before converting to student!'
                ]);
            }
        }

        $converted_status = $disqualified_status = "";
        if (DB::table('users')->where("id", $leadid)->update(['lead_status' => $status])) {
            $new_status = $status;
            //Adding activity
            $followup = new UserActivity;
            $followup->user_id = $leadid;
            $followup->type = 'lead_status_change';
            $followup->staff = \Auth::user()->id;
            $followup->lead_status_changed_to = $status;
            $followup->detail = "LEAD STATUS CHANGED TO: " . $status . ", Previous Status: " . $old_status;
            $followup->save();

            // Send Push App Notification
            if(\Auth::user()->isAgent()){
                $message = "Lead Status Changed by Agent: " . get_user_full_name_by_id(\Auth::user()->id);
            } else{
                $message = "Lead Status changed by " . get_user_full_name_by_id(\Auth::user()->id);
                $email_message = "Hi, <br>Lead Status Changed by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
            }
            
            //Sending email Notification
            $subject = "Lead: " . $lead->full_name . " (".$lead->id.") Status Changed to: $new_status";
            $email_message .= "<br><strong>Lead Details:</strong>
            <br>" . $lead->first_name ." ".$lead->last_name. 
            "<br>Old Status: " . $old_status . 
            "<br>New Status: " . $new_status . 
            "<br/>Mob: " . $lead->mobile . 
            "<br/>Email: " . $lead->email;
            send_mail_notification($lead->id,"","LEAD_STATUS_CHANGE",$subject,$email_message);
            
            
            $message .= ", Lead: <strong>" . $lead->full_name."</strong> (". $lead->id. ")";
            if($new_status){
                $message .= ", Old Status: " . $old_status . ", New Status: <strong>" . $new_status."</strong>";
            }
            $subject = "";
            send_in_app_notification(
                $lead->id, 
                $lead->id,
                "LEAD_STATUS_CHANGE", 
                $subject, 
                $message,
                "lead"
            );

            // return redirect()->route('admin.leadmanagementdetails')->withFlashSuccess('Lead Status Changed Successfully');
            return response()->json([
                'success' => 1, 
                'message' => 'Lead Status Changed Successfully'
            ]);
        } else {
            // return redirect()->route('admin.leadmanagementdetails')->withFlashDanger('This lead status change not allowed');
            return response()->json([
                'success' => 0, 
                'message' => 'This lead status change not allowed'
            ]);
        }
    }

    public function disqualified($id){
        $lead = User::findOrFail($id);
        return view('backend.lead.disqualified_modal', compact('lead'));
    }

    public function updateToDisqualified(Request $request){
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('lead create-update'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $request->validate([
            'lead_disqualified_reason' => 'required',
        ]);

        $lead = User::findOrFail($request->get('lead_id'));
        $old_status = $lead->lead_status;
        $new_status = "";

        if (DB::table('users')->where("id", $lead->id)->update(['lead_status' => get_disqualified_lead_status()])){
            $new_status = get_disqualified_lead_status();
            // $leadDetails = UserDetails::where('userid', $lead->id)->first();
            $leadDetails = UserDetails::firstOrNew(array('userid' => $lead->id));
            $leadDetails->lead_disqualified_reason = $request->get('lead_disqualified_reason');
            $leadDetails->save();

            $lead->next_followup = NULL;
            $lead->save();

            $followup = new UserActivity;
            $followup->user_id = $lead->id;
            $followup->type = 'others';
            $followup->staff = \Auth::user()->id;
            $followup->lead_status_changed_to = get_disqualified_lead_status();
            $followup->detail = "LEAD STATUS CHANGED TO: " . get_disqualified_lead_status() . ", Previous Status: " . $old_status;
            $followup->save();

            // Send Push App Notification
            if(\Auth::user()->isAgent()){
                $message = "Lead Status Changed by Agent: " . get_user_full_name_by_id(\Auth::user()->id);
            } else{
                $message = "Lead DISQUALIFIED by " . get_user_full_name_by_id(\Auth::user()->id);
                $email_message = "Hi, <br>Lead Status Changed by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
            }
            
            //Sending email Notification
            $subject = "Lead: " . $lead->full_name . " (".$lead->id.") Status Changed to: $new_status";
            $email_message .= "<br><strong>Lead Details:</strong>
            <br>" . $lead->first_name ." ".$lead->last_name. 
            "<br>Old Status: " . $old_status . 
            "<br>New Status: " . $new_status . 
            "<br/>Mob: " . $lead->mobile . 
            "<br/>Email: " . $lead->email;
            send_mail_notification($lead->id,"","LEAD_STATUS_CHANGE",$subject,$email_message);
            
            
            $message .= ", Lead: <strong>" . $lead->full_name."</strong> (". $lead->id. ")";
            if($new_status){
                $message .= ", Old Status: " . $old_status . ", New Status: <strong>" . $new_status."</strong>";
            }
            $subject ="";
            send_in_app_notification(
                $lead->id, 
                $lead->id,
                "LEAD_STATUS_CHANGE", 
                $subject, 
                $message,
                "lead"
            );

            // return redirect()->route('admin.leadmanagementdetails')->withFlashSuccess('Lead Status Changed Successfully');
            return response()->json([
                'success' => 1, 
                'message' => 'Lead Status Changed Successfully'
            ]);
        } else {
            // return redirect()->route('admin.leadmanagementdetails')->withFlashDanger('This lead status change not allowed');
            return response()->json([
                'success' => 0, 
                'message' => 'This lead status change not allowed'
            ]);
        }
    }

    public function edit($id)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('lead create-update'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $leaddata = User::find($id);
        // dd("leads checking",$leaddata);
        $leaddetails = UserDetails::where('userid', $id)->first();
        //$batchs = Batch::orderBy('created_at', 'DESC')->get();
        $courses = Course::orderBy('title', 'ASC')->get();
        $countries = Country::where('overseas_status', 1)->orderBy('title_en', 'ASC')->get();
        $branch = get_staff_branches(\Auth::user()->id);
        //$staff = $userRepo->getNonStudentsTrainers();
        $dialcodes = Country::orderBy('country_code', 'asc')->get(['tel as code', 'code as country_code', 'title_en as name']);
        $country_list = Country::pluck('title_en', 'id');
        $custom_attributes = DB::table('custom_attributes')->where('for_lead', 1)->orderBy('display_order','asc')->get(["custom_attributes.*"]);
        return view('backend.lead.lead_edit', [
            'custom_attributes' => $custom_attributes,
            'dialcodes' => $dialcodes, 
            'country_list' => $country_list, 
            'branch' => $branch, 
            'leaddata' => $leaddata, 
            'courses' => $courses, 
            'countries' => $countries, 
            'leaddetails' => $leaddetails
        ]);
    }

    public function update(Request $request, $id){

        $request->validate([
            'first_name' => ['required', 'max:191','regex:/^[\pL\s]+$/u'],
            'last_name'  => ['nullable', 'max:191','regex:/^[\pL\s]+$/u'],
            // 'email' => 'required|email|unique:users,email,' . $id,
            // 'mobile' => 'nullable|numeric|unique:users,mobile,' . $id,
            // 'study_level' => 'required',
            'date_of_birth' => 'nullable|before:'.now()->subYears(16)->toDateString()
        ],[
            'first_name.regex' => 'Only letters and space is allowed in First Name',
            'last_name.regex' => 'Only letters and space is allowed in Last Name',
        ]);

        if(get_site_config('lead_create_admin_mandatory') == 'email'){
            $request->validate([
                'email' => 'required|email:filter,filter_unicode|unique:users,email,' . $id,
                'mobile' => ['nullable', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH')],
            ]);
        } elseif(get_site_config('lead_create_admin_mandatory') == 'email_and_mobile'){
            $request->validate([
                'email' => 'required|email:filter,filter_unicode|unique:users,email,' . $id,
                'mobile' => ['required', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH'), 'unique:users,mobile,' . $id],
            ]);
        } elseif(get_site_config('lead_create_admin_mandatory') == 'email_or_mobile'){
            if($request->get('email') == "" && $request->get('mobile') == ""){
                return redirect()->back()->withFlashDanger('Email or Mobile is Required');
            } else{
                $request->validate([
                    'email' => 'nullable|email:filter,filter_unicode|unique:users,email,' . $id,
                    'mobile' => ['nullable', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH'), 'unique:users,mobile,' . $id],
                ]);
            }
        } elseif(get_site_config('lead_create_admin_mandatory') == 'mobile'){
            $request->validate([
                'email' => 'nullable|email:filter,filter_unicode|unique:users,email,' . $id,
                'mobile' => ['required', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH'), 'unique:users,mobile,' . $id],
            ]);            
        }

    //Checking custom attributes
    $custom_attributes = DB::table('custom_attributes')->where('for_lead', 1)->orderBy('display_order','asc')->get(["custom_attributes.*"]);
    $attributes_json = "";
    if(count($custom_attributes)){
        $all_atts = array();
        foreach($custom_attributes as $attrs){
            $name = $attrs->attr_name;
            $all_atts[$attrs->attr_name] = $request->$name;
            if($attrs->laravel_rules){
                $request->validate([
                    "$attrs->attr_name" => "$attrs->laravel_rules",
                ]);
            }
        }
        $attributes_json = json_encode($all_atts);
    }
    //Checking custom attributes

        $country_interested = "";
        $country_pref = $request->input('country_pref');
        if (!empty($country_pref) && count($country_pref)) {
            $country_interested = implode(",", $request->get('country_pref'));
        }

        $service_interested = "";
        $service_pref = $request->input('services');
        if (!empty($service_pref) && count($service_pref)) {
            $service_interested = implode(",", $request->get('services'));
        }

        if (!empty($request->input('date_of_birth'))) {
            $dob = substr($request->input('date_of_birth'), 6, 4) . "-" . substr($request->input('date_of_birth'), 3, 2) . "-" . substr($request->input('date_of_birth'), 0, 2);
        } else {
            $dob = NULL;
        }

        if (!empty($request->input('intake'))) {
            $intake = $request->input('intake');
            $intatake_arr =  explode(" ", $intake);
        } else {
            $intatake_arr = array(null, null);
        }

        $leadupdate = User::find($id);

        if($request->input('study_level')){
            $study_degree = get_study_level_degree_level($request->input('study_level'));
        }else{
            $study_degree = NULL;
        }

        if ($request->input('referred_by')) {
            $ref_by = $request->input('referred_by');
        } else {
            $ref_by = 0;
        }

        $leadupdate->first_name = $request->get('first_name');
        $leadupdate->last_name = $request->get('last_name');
        $leadupdate->email = $request->get('email');
        $leadupdate->dialcode = $request->get('dialcode');
        $leadupdate->mobile = $request->get('mobile');
        $leadupdate->whatsapp_dialcode = $request->get('whatsapp_dialcode');
        $leadupdate->whatsapp = $request->get('whatsapp_number');
        $leadupdate->alternate_contact = $request->get('alternate_contact');
        $leadupdate->gender = $request->get('gender');
        $leadupdate->birthday = $dob;
        // $leadupdate->address_1 = $request->get('address');
        $leadupdate->country = $request->get('country');
        $leadupdate->state = $request->get('state');
        $leadupdate->city = $request->get('city');
        $leadupdate->coaching_course_interested = $request->get('course');
        $leadupdate->country_interested = $country_interested;
        $leadupdate->overseas_study_level = $study_degree;
        $leadupdate->overseas_study_level_selection = $request->get('study_level');
        $leadupdate->overseas_course_intersted = $request->get('course_interested');
        
        $leadupdate->lead_source = $request->get('lead_source');
        $leadupdate->branch = $request->get('branch');
        $leadupdate->services = $service_interested;
        $leadupdate->ref_by = $ref_by;
        $leadupdate->save();


        $user_details = UserDetails::where('userid', $id)->first();
        if(!$user_details){
            $user_details = new UserDetails(['userid' => $id]);
            $user_details->save();
        }
        $user_details->highest_level_education = $request->get('qualification');
        $user_details->qualification_score = $request->get('qualification_score');
        $user_details->passout_year = $request->get('passout_year');
        $user_details->current_course = $request->get('currently_studying_course');
        // $user_details->cgpa = $request->get('cgpa');
        $user_details->user_data_js = $attributes_json;
        $user_details->ielts = $request->get('ielts');
        $user_details->toefl = $request->get('toefl');
        $user_details->pte = $request->get('pte');
        $user_details->gre = $request->get('gre');
        $user_details->duolingo = $request->get('duolingo');
        $user_details->work_experience = $request->get('work_experience');
        $user_details->accommodation = $request->get('accommodation');
        $user_details->study_permit = $request->get('study_permit');
        $user_details->education_loan = $request->get('education_loan');
        $user_details->intake_year = $intatake_arr[1];
        $user_details->intake_month = $intatake_arr[0];
        $user_details->lead_source_detail = $request->get('lead_source_detail');
        $user_details->lead_campaign_name = $request->get('campaign_name');
        $user_details->lead_notes = $request->get('note');
        $user_details->save();

        $followup = new UserActivity;
        $followup->user_id = $id;
        $followup->type = 'others';
        $followup->staff = \Auth::user()->id;
        $followup->detail = "LEAD UPDATED";
        $followup->save();

        // Send Push App Notification
        if(\Auth::user()->isAgent()){
            $message = "Lead <strong>".$leadupdate->full_name."</strong> (". $leadupdate->id. ") updated by Agent: " . get_user_full_name_by_id(\Auth::user()->id);
            $email_message = "Hi, <br><br>Lead Updated by Agent: " . get_user_full_name_by_id(\Auth::user()->id);
        } else{
            $message = "Lead <strong>".$leadupdate->full_name."</strong> (". $leadupdate->id. ") updated by " . get_user_full_name_by_id(\Auth::user()->id);
            $email_message = "Hi, <br><br>Lead Updated by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
        }

        // New way to send email
        //Sending email Notification
        $subject = "Lead: " . $leadupdate->full_name . " (".$leadupdate->id.") Updated by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
        $email_message_part = "<br />Mobile:$leadupdate->mobile<br /><br />Email: $leadupdate->email <br/><br/><a href=\"" . url("admin/leads/" . $leadupdate->id) . "\">View Lead Details</a>";
        $email_message .= "<br><br>Lead: " . $leadupdate->full_name . " (".$leadupdate->id.") Updated by Staff: " . get_user_full_name_by_id(\Auth::user()->id)."<br />" . $email_message_part;
        send_mail_notification($leadupdate->id,"","STUDENT_PROFILE_UPDATED",$subject,$email_message);

        $subject = "";
        send_in_app_notification(
            $leadupdate->id, 
            $leadupdate->id,
            "STUDENT_PROFILE_UPDATED", 
            $subject, 
            $message,
            "lead"
        );

        return redirect()->route('admin.leadmanagementdetails', $id)->withFlashSuccess('Lead Information saved!');
    }

    public function destroyed($id){
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('delete-lead-student-application'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }

        if(DB::table('users')->where('id', $id)->exists()){
            // Deleting all record from all table wherever this user id is used
            
            // $batch_students = DB::table('batch_students')->where('student', $id)->delete();

            $course_preference = DB::table('course_preference')->where('userid', $id)->delete();
            $course_recommendation = DB::table('course_recommendation')->where('userid', $id)->delete();
            $course_shortlisted = DB::table('course_shortlisted')->where('student_id', $id)->delete();

            $invoice = DB::table('invoice')->where('student_id', $id)->delete();

            $orders = DB::table('orders')->where('user_id', $id)->delete();

            $password_histories = DB::table('password_histories')->where('user_id', $id)->delete();

            $payment_gateway_trans = DB::table('payment_gateway_trans')->where('user_id', $id)->delete();

            $service_applications = DB::table('service_applications')->where('user_id', $id)->delete();
            $service_application_messages = DB::table('service_application_messages')->where('user_id', $id)->get();
            if(count($service_application_messages)){
                foreach($service_application_messages as $application_message){
                    \File::delete(public_path("storage/".$application_message->attachment_1));
                    \File::delete(public_path("storage/".$application_message->attachment_2));
                    \File::delete(public_path("storage/".$application_message->attachment_3));
                    \File::delete(public_path("storage/".$application_message->attachment_4));
                }
                $service_application_messages = DB::table('service_application_messages')->where('user_id', $id)->delete();
            }
            $social_accounts = DB::table('social_accounts')->where('user_id', $id)->delete();

            $student_course_certificate = DB::table('student_course_certificate')->where('student_id', $id)->delete();
            $student_exams = DB::table('student_exams')->where('student_id', $id)->delete();
            $student_exam_result = DB::table('student_exam_result')->where('student_id', $id)->delete();
            $student_marks = DB::table('student_marks')->where('student_id', $id)->delete();
            $student_online_course = DB::table('student_online_course')->where('student_id', $id)->delete();
            $student_quiz_answer = DB::table('student_quiz_answer')->where('student_id', $id)->delete();
            $student_quiz_result = DB::table('student_quiz_result')->where('student_id', $id)->delete();
            $student_webinar = DB::table('student_webinar')->where('student_id', $id)->delete();

            $tickets = DB::table('tickets')->where('userid', $id)->delete();

            $application_messages = DB::table('application_messages')->where('user_id', $id)->get();
            if(count($application_messages)){
                foreach($application_messages as $application_message){
                    \File::delete(public_path("storage/".$application_message->attachment_1));
                    \File::delete(public_path("storage/".$application_message->attachment_2));
                    \File::delete(public_path("storage/".$application_message->attachment_3));
                    \File::delete(public_path("storage/".$application_message->attachment_4));
                }
                $application_messages = DB::table('application_messages')->where('user_id', $id)->delete();;
            }

            $university_application = DB::table('university_application')->where('userid', $id)->delete();
            $user_academics = DB::table('user_academics')->where('userid', $id)->delete();
            $user_activity = DB::table('user_activity')->where('user_id', $id)->delete();
            $user_certification_eng = DB::table('user_certification_eng')->where('userid', $id)->delete();
            $user_certification_lang = DB::table('user_certification_lang')->where('userid', $id)->delete();
            $user_courses = DB::table('user_courses')->where('userid', $id)->delete();
            // $user_course_preference = DB::table('user_course_preference')->where('userid', $id)->delete();
            $user_democlass_permission = DB::table('user_democlass_permission')->where('userid', $id)->delete();
            $user_details = DB::table('user_details')->where('userid', $id)->delete();

            $user_docs_other = DB::table('user_docs_other')->where('userid', $id)->get();;
            if(count($user_docs_other)){
                foreach($user_docs_other as $user_docs){
                    \File::delete(public_path("storage/".$user_docs->file));
                }
                $user_docs_other = DB::table('user_docs_other')->where('userid', $id)->delete();;
            }

            $user_documents = DB::table('user_documents')->where('userid', $id)->first();
            if($user_documents){
                \File::delete(public_path("storage/".$user_documents->class10));
                \File::delete(public_path("storage/".$user_documents->class10_marks_sheet));
                \File::delete(public_path("storage/".$user_documents->class12));
                \File::delete(public_path("storage/".$user_documents->class12_marks_sheet));
                \File::delete(public_path("storage/".$user_documents->diploma));
                \File::delete(public_path("storage/".$user_documents->diploma_marks_sheet));
                \File::delete(public_path("storage/".$user_documents->grad_all_sem));
                \File::delete(public_path("storage/".$user_documents->grad_degree));
                \File::delete(public_path("storage/".$user_documents->cmm));
                \File::delete(public_path("storage/".$user_documents->grad_provisional));
                \File::delete(public_path("storage/".$user_documents->grad_transcripts));
                \File::delete(public_path("storage/".$user_documents->pg_all_sem));
                \File::delete(public_path("storage/".$user_documents->pg_degree));
                \File::delete(public_path("storage/".$user_documents->pg_provisional));
                \File::delete(public_path("storage/".$user_documents->pg_transcripts));
                \File::delete(public_path("storage/".$user_documents->lang_ielts));
                \File::delete(public_path("storage/".$user_documents->lang_pte));
                \File::delete(public_path("storage/".$user_documents->gre));
                \File::delete(public_path("storage/".$user_documents->gmat));
                \File::delete(public_path("storage/".$user_documents->toefl));
                \File::delete(public_path("storage/".$user_documents->duolingo));
                $user_documents = DB::table('user_documents')->where('userid', $id)->delete();
            }

            $user_experience = DB::table('user_experience')->where('userid', $id)->delete();
            $user_folder_permission = DB::table('user_folder_permission')->where('userid', $id)->delete();
            $user_gre_gmat = DB::table('user_gre_gmat')->where('userid', $id)->delete();
            $user_internship = DB::table('user_internship')->where('userid', $id)->delete();
            $user_notification = DB::table('user_notification')->where('user_id', $id)->delete();
            $user_shipping_addresses = DB::table('user_shipping_addresses')->where('user_id', $id)->delete();
            //$user_tags = DB::table('user_tags')->where('userid', $id)->delete();
            // $visa_preference = DB::table('visa_preference')->where('userid', $id)->delete();

            $lead = User::where('id', $id)->first();
            \File::delete(public_path("storage/".$lead->avatar_location));

            try {
                // Send Push App Notification
                if(\Auth::user()->isAgent()){
                    // $message = "Lead Deleted by Agent: " . get_user_full_name_by_id(\Auth::user()->id);
                    // $email_message = "Lead Deleted by Agent: " . get_user_full_name_by_id(\Auth::user()->id);
                } else{
                    $message = "Lead DELETED by " . get_user_full_name_by_id(\Auth::user()->id);
                    $email_message = "Hi, <br><br>Lead Deleted by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
                }
                
                //Sending email Notification
                $subject = "Lead: " . $lead->full_name . " (".$lead->id.") Deleted by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
                $email_message .= "<br/><strong>Lead Details:</strong><br/>" . $lead->first_name ." ".$lead->last_name. "<br/>Mob: " . $lead->mobile . "<br/>Email: " . $lead->email;
                send_mail_notification($lead->id,"","LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE",$subject,$email_message);
                
                $message .= ", Lead: <strong>" . $lead->full_name."</strong> (". $lead->id. ")";
                $subject = "";
                send_in_app_notification(
                    $lead->id, 
                    $lead->id,
                    "LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE", 
                    $subject, 
                    $message,
                    "lead"
                );

            } catch (\Exception $e) {
                \Log::debug("Sent Notifications Error: " . $e->getMessage());
            }

            //Delete from users table
            $users = DB::table('users')->where('id', $id)->delete();

            return redirect()->route('admin.leadmanagementdetails')->withFlashSuccess('Lead Deleted Successfully');
        }else{
            return redirect()->route('admin.leadmanagementdetails')->withFlashDanger('Lead Not Found');
        }
    }

    public function bulkDeleteLead(Request $request){
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('delete-lead-student-application'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $id_arr = explode(',', $request->input('id_arr'));
        if (is_array($id_arr)) {
            foreach ($id_arr as $id) {
                if(DB::table('users')->where('id', $id)->exists()){
                    // $batch_students = DB::table('batch_students')->where('student', $id)->delete();

                    $course_preference = DB::table('course_preference')->where('userid', $id)->delete();
                    $course_recommendation = DB::table('course_recommendation')->where('userid', $id)->delete();
                    $course_shortlisted = DB::table('course_shortlisted')->where('student_id', $id)->delete();

                    $invoice = DB::table('invoice')->where('student_id', $id)->delete();

                    $orders = DB::table('orders')->where('user_id', $id)->delete();

                    $password_histories = DB::table('password_histories')->where('user_id', $id)->delete();

                    $payment_gateway_trans = DB::table('payment_gateway_trans')->where('user_id', $id)->delete();

                    $service_applications = DB::table('service_applications')->where('user_id', $id)->delete();
                    $service_application_messages = DB::table('service_application_messages')->where('user_id', $id)->get();
                    if(count($service_application_messages)){
                        foreach($service_application_messages as $application_message){
                            \File::delete(public_path("storage/".$application_message->attachment_1));
                            \File::delete(public_path("storage/".$application_message->attachment_2));
                            \File::delete(public_path("storage/".$application_message->attachment_3));
                            \File::delete(public_path("storage/".$application_message->attachment_4));
                        }
                        $service_application_messages = DB::table('service_application_messages')->where('user_id', $id)->delete();
                    }
                    $social_accounts = DB::table('social_accounts')->where('user_id', $id)->delete();

                    $student_course_certificate = DB::table('student_course_certificate')->where('student_id', $id)->delete();
                    $student_exams = DB::table('student_exams')->where('student_id', $id)->delete();
                    $student_exam_result = DB::table('student_exam_result')->where('student_id', $id)->delete();
                    $student_marks = DB::table('student_marks')->where('student_id', $id)->delete();
                    $student_online_course = DB::table('student_online_course')->where('student_id', $id)->delete();
                    $student_quiz_answer = DB::table('student_quiz_answer')->where('student_id', $id)->delete();
                    $student_quiz_result = DB::table('student_quiz_result')->where('student_id', $id)->delete();
                    $student_webinar = DB::table('student_webinar')->where('student_id', $id)->delete();

                    $tickets = DB::table('tickets')->where('userid', $id)->delete();
                    
                    $application_messages = DB::table('application_messages')->where('user_id', $id)->get();
                    if(count($application_messages)){
                        foreach($application_messages as $application_message){
                            \File::delete(public_path("storage/".$application_message->attachment_1));
                            \File::delete(public_path("storage/".$application_message->attachment_2));
                            \File::delete(public_path("storage/".$application_message->attachment_3));
                            \File::delete(public_path("storage/".$application_message->attachment_4));
                        }
                        $application_messages = DB::table('application_messages')->where('user_id', $id)->delete();;
                    }
                    $university_application = DB::table('university_application')->where('userid', $id)->delete();
                    $user_academics = DB::table('user_academics')->where('userid', $id)->delete();
                    $user_activity = DB::table('user_activity')->where('user_id', $id)->delete();
                    $user_certification_eng = DB::table('user_certification_eng')->where('userid', $id)->delete();
                    $user_certification_lang = DB::table('user_certification_lang')->where('userid', $id)->delete();
                    $user_courses = DB::table('user_courses')->where('userid', $id)->delete();
                    // $user_course_preference = DB::table('user_course_preference')->where('userid', $id)->delete();
                    $user_democlass_permission = DB::table('user_democlass_permission')->where('userid', $id)->delete();
                    $user_details = DB::table('user_details')->where('userid', $id)->delete();

                    $user_docs_other = DB::table('user_docs_other')->where('userid', $id)->get();;
                    if(count($user_docs_other)){
                        foreach($user_docs_other as $user_docs){
                            \File::delete(public_path("storage/".$user_docs->file));
                        }
                        $user_docs_other = DB::table('user_docs_other')->where('userid', $id)->delete();;
                    }

                    $user_documents = DB::table('user_documents')->where('userid', $id)->first();
                    if($user_documents){
                        \File::delete(public_path("storage/".$user_documents->class10));
                        \File::delete(public_path("storage/".$user_documents->class10_marks_sheet));
                        \File::delete(public_path("storage/".$user_documents->class12));
                        \File::delete(public_path("storage/".$user_documents->class12_marks_sheet));
                        \File::delete(public_path("storage/".$user_documents->diploma));
                        \File::delete(public_path("storage/".$user_documents->diploma_marks_sheet));
                        \File::delete(public_path("storage/".$user_documents->grad_all_sem));
                        \File::delete(public_path("storage/".$user_documents->grad_degree));
                        \File::delete(public_path("storage/".$user_documents->cmm));
                        \File::delete(public_path("storage/".$user_documents->grad_provisional));
                        \File::delete(public_path("storage/".$user_documents->grad_transcripts));
                        \File::delete(public_path("storage/".$user_documents->pg_all_sem));
                        \File::delete(public_path("storage/".$user_documents->pg_degree));
                        \File::delete(public_path("storage/".$user_documents->pg_provisional));
                        \File::delete(public_path("storage/".$user_documents->pg_transcripts));
                        \File::delete(public_path("storage/".$user_documents->lang_ielts));
                        \File::delete(public_path("storage/".$user_documents->lang_pte));
                        \File::delete(public_path("storage/".$user_documents->gre));
                        \File::delete(public_path("storage/".$user_documents->gmat));
                        \File::delete(public_path("storage/".$user_documents->toefl));
                        \File::delete(public_path("storage/".$user_documents->duolingo));
                        $user_documents = DB::table('user_documents')->where('userid', $id)->delete();
                    }

                    $user_experience = DB::table('user_experience')->where('userid', $id)->delete();
                    $user_folder_permission = DB::table('user_folder_permission')->where('userid', $id)->delete();
                    $user_gre_gmat = DB::table('user_gre_gmat')->where('userid', $id)->delete();
                    $user_internship = DB::table('user_internship')->where('userid', $id)->delete();
                    $user_notification = DB::table('user_notification')->where('user_id', $id)->delete();
                    $user_shipping_addresses = DB::table('user_shipping_addresses')->where('user_id', $id)->delete();
                    //$user_tags = DB::table('user_tags')->where('userid', $id)->delete();
                    // $visa_preference = DB::table('visa_preference')->where('userid', $id)->delete();

                    $lead = User::where('id', $id)->first();
                    \File::delete(public_path("storage/".$lead->avatar_location));

                    // Send Push App Notification
                    if(\Auth::user()->isAgent()){
                        $message = "Lead Deleted by Agent: " . get_user_full_name_by_id(\Auth::user()->id);
                    } else{
                        $message = "Lead Deleted by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
                        $email_message = "Hi, <br><br>Lead Deleted by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
                    }
                    
                    //Sending email Notification
                    $subject = "Lead: " . $lead->full_name . " (".$lead->id.") Deleted by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
                    $email_message .= "<br/><strong>Lead Details:</strong><br/>" . $lead->first_name ." ".$lead->last_name. "<br/>Mob: " . $lead->mobile . "<br/>Email: " . $lead->email;
                    send_mail_notification($lead->id,"","LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE",$subject,$email_message);
                    
                    $message .= "<br>Lead: " . $lead->full_name." (". $lead->id. ")";
                    $subject = "";
                    send_in_app_notification(
                        $lead->id, 
                        $lead->id,
                        "LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE", 
                        $subject, 
                        $message,
                        "lead"
                    );

                    // $users = User::where('id', $id)->delete();
                    $users = DB::table('users')->where('id', $id)->delete();
                }
            }
        }
        return redirect()->route('admin.leadmanagementdetails')->withFlashSuccess('All Selected Leads Deleted Successfully');
    }

    public function assignCounseller(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('lead create-update'))) {
            return response()->json([
                'success' => 0, 
                'message' => 'You do not have access permission to this feature.'
            ]);
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        \Log::debug("assignCounseller:");
        \Log::debug($request->all());
        $request->validate([
            'counsellor' => 'required',
            'date_time' => 'required',
            'lead_id' => 'required',
        ]);
        $staffid = $request->counsellor;
        $leadid = $request->lead_id;
        $date_time = $request->date_time;
        $newDt = date('Y-m-d H:i:s', strtotime($date_time));

        //check if this staff is already assigned to any lead as counsellernext_followup
        $checkCounseller = User::where("assigned_to", $staffid)->where("next_followup", $newDt)->first();
        $user = User::find($staffid);

        if (!$checkCounseller) {
            \Log::debug("Consellor assigning");
            DB::table('users')->where("id", $leadid)->update(['lead_status' => get_counselling_lead_status(), 'assigned_to' => $staffid, 'next_followup' => $newDt]);
            $lead = User::find($leadid);
            $old_status = $lead->lead_status;
            //Adding activity
            $followup = new UserActivity;
            $followup->user_id = $leadid;
            $followup->type = 'others';
            $followup->lead_status_changed_to = get_counselling_lead_status();
            $followup->staff = \Auth::user()->id;
            $followup->detail = "Lead status changed to Counselling. Counseller: " . $user->name . ", Previous Status: " . $old_status;
            $followup->save();

            $subject = "New Counselling Meeting Fixed";
            $email_message = "Hi $user->name, New Counselling Meeting is assigned to you.<br /><br />Lead Name: $lead->first_name $lead->last_name<br /><br />Mobile:$lead->mobile<br /><br />Email: $lead->email <br/><br/><a href=\"" . url("admin/counselling/" . $leadid . "/followups") . "\">View Lead Details</a>";
            try {
                //Mail::to($user->email)->send(new MailSend($subject, $email_message));
                user_notify($user->email,$subject, $email_message);
            } catch (\Exception $e) {
                $message = $e->getMessage();
                \Log::debug("Mail Error: (New Counselling Meeting Fixed) " . $message);
            }
            //Sending email to admin
            // $msg_details = "<p>New Counselling Meeting Fixed with counsellor: $user->name<br /><br />Lead Name: $lead->first_name $lead->last_name<br /><br />Mobile:$lead->mobile<br /><br />Email: $lead->email <br/><br/><a href=\"" . url("admin/counselling/" . $leadid . "/followups") . "\">View Lead Details</a>";
            // if ($msg_details) {
            //     $email_message = "Dear Admin,<br><br>" . $msg_details;
            //     $recipient = new AdminRecipient();
            //     try {
            //         $recipient->notify(new AdminAlert("New Counselling Meeting Fixed", $email_message));
            //     } catch (\Exception $e) {
            //         $message = $e->getMessage();
            //         \Log::debug("Mail Error: (New Counselling Meeting Fixed) " . $message);
            //     }
            // }

            // Send Whatsapp 
            if (get_site_config('whatsapp_enabled')) {
                $numbers = [$user->whatsapp_dialcode.$user->whatsapp];

                $hook = 'counselling_meet_scheduled';

                send_whatsapp_message($numbers, $hook, $user->id);
            }


            $notify_sms = get_sms_template('COUNSELLING_MEET_SCHEDULED');
            if ($notify_sms && $notify_sms->status) {
                $notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
                $notify_sms->message = str_replace("#siteurl#", url('/'), $notify_sms->message);
                $notify_sms->message = str_replace("#first_name#", $user->first_name, $notify_sms->message);
                $notify_sms->message = str_replace("#full_name#", $user->full_name, $notify_sms->message);
                $user->sms($notify_sms->message, $notify_sms->template_id);
            }
            //return "Staff Assigned!";
            // return redirect()->route('admin.leadmanagementdetails')->withFlashSuccess('Counsellor Assigned!');
            return response()->json([
                'success' => 1, 
                'message' => 'Counsellor Assigned!'
            ]);
        } else {
            \Log::debug("Consellor slot not available!");
            // return redirect()->back()->withFlashDanger('Selected Counsellor is already booked for selected date and time!');
            return response()->json([
                'success' => 0, 
                'message' => 'Selected Counsellor is already booked for selected date and time!'
            ]);
        }
    }

    public function getDeleted(ManageUserRequest $request){
        // if (!(\Auth::user()->isAdmin() || \Auth::user()->can('delete-lead-student-application'))) {
        //     return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        // }
        return view('backend.lead.deleted',['staff_mgmt' => 0])
            ->withUsers($this->getDeletedPaginated(25, 'id', 'asc'));
    }

    public function getDeletedPaginated($paged = 25, $orderBy = 'created_at', $sort = 'desc'): LengthAwarePaginator{
        return $this->model
            // ->with('roles', 'permissions', 'providers')
            ->onlyTrashed()
            ->where('removed', "0")
            ->where('is_lead', "1")
            // ->whereHas('roles', function ($q) {
            //     $q->whereIn('name', ['user']);
            // })
            ->when(\Auth::user()->isAgent(), function ($q) {
                $q->where('agent_id', \Auth::user()->id);
            })
            ->orderBy($orderBy, $sort)
            ->paginate($paged);
    }

    public function restoreLead($id){
        // \Log::debug('Lead restore:'.$id);
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('delete-lead-student-application'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $user = User::onlyTrashed()->find($id);
        if (is_null($user->deleted_at) && $user->removed != 0) {
            throw new GeneralException(__('exceptions.backend.access.users.cant_restore_lead'));
        }

        if ($user->restore()) {
            event(new UserRestored($user));
            // return $user;
        } else{
            throw new GeneralException(__('exceptions.backend.access.users.restore_error_lead'));
        }        
        return redirect()->route('admin.leadmanagementdetails')->withFlashSuccess(__('alerts.backend.users.restoredlead'));
    }
    
    public function delete(ManageUserRequest $request, $deletedUser){
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('delete-lead-student-application'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $User = User::onlyTrashed()->find($deletedUser);
        $this->eductrlDeleteLead($User);        
        return redirect()->route('admin.leads.deleted')->withFlashSuccess(__('alerts.backend.users.deleted_permanently_leads'));
    }

    public function eductrlDeleteLead(User $user): User{
        if (is_null($user->deleted_at) && $user->removed != 0) {
            throw new GeneralException(__('exceptions.backend.access.users.delete_first_lead'));
        }
        return DB::transaction(function () use ($user) {
            // Delete associated relationships
            $user->passwordHistories()->delete();
            $user->providers()->delete();
            $user->sessions()->delete();

            $user->removed = 1;
            $user->email = 'deleted_' . time() . '_' . $user->email;
            $user->first_name = 'DELETED';
            $user->middle_name = '';
            $user->last_name = '';
            $user->mobile = '';

            if ($user->save()) {
                event(new UserPermanentlyDeleted($user));
                return $user;
            }

            throw new GeneralException(__('exceptions.backend.access.users.delete_error_lead'));
        });
    }

    // public function leadImportOpen($currentPage){
    //     $userRepo = new UserRepository();
    //     $staff = $userRepo->getNonStudentsTrainers();
    //     $courseCategory = DB::table('university_course_categories')->get();
    //     return view('backend.import_export.index', compact('staff','courseCategory','currentPage'));
    // }

    // public function storeDocumentSignature(Request $request) {
    //     $user_detail = UserDetails::where('userid', $request->user_id)->first();
    //     $user_detail->student_signature = $request->image_data;
    //     $user_detail->save();

    //     return response()->json([
    //         'success' => 1, 
    //         'message' => 'Signature Saved Successfully!'
    //     ]);
    // }

}
