<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\MailTemplates;
use Illuminate\Http\Request;
use App\Models\Auth\UserDetails;


class MailTemplatesController extends Controller
{

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('mail templates'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }
            return $next($request);
        });
    }

    public function index()
    {
        // $templates = MailTemplates::orderByDesc('created_at')->get();
        $templates = MailTemplates::orderBy('created_at', 'DESC')->get();
        return view('backend.email_templates.index', compact('templates'));
    }


    public function create()
    {
        $variables = "sitename,siteurl,first_name,full_name";
        return view('backend.email_templates.create', compact('variables'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  Page $template
     * @return view
     */
    public function edit($id)
    {
        $template = MailTemplates::where('hook', '=', $id)->first();
        return view('backend.email_templates.edit', compact('template'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'hook' => 'required|max:50|unique:mail_templates',
            'subject' => 'required|max:100',
            'message' => 'required',
        ]);

        $mail_tpl = MailTemplates::create([
            'hook' => $request->get('hook'),
            'subject' => $request->get('subject'),
            'message' => $request->get('message'), 
            'status' => 1, 
            'variables' => 'sitename,siteurl,first_name,full_name'
        ]);
        return redirect()->route('admin.mailtemplates')->withFlashSuccess('Email Template Created Successfully!');
    }


    public function update(Request $request, $id)
    {
        $request->validate([
            'subject' => 'required',
            'message' => 'required',
        ]);

        $mail_tpl = MailTemplates::findOrFail($id);
        $mail_tpl->subject = $request->get('subject');
        $mail_tpl->message = $request->get('message');
        $mail_tpl->save();
        return redirect()->route('admin.mailtemplates')->withFlashSuccess('Email Template Updated!');
    }

    public function destroy($id)
    {
        $mail_tpl = MailTemplates::findOrFail($id);
        if ($mail_tpl->system_tpl) {
            return redirect()->back()->withFlashDanger('This template cannot be deleted');
        }
        $mail_tpl->delete();
        return redirect()->back()->withFlashSuccess('Template deleted successfully');
    }

    public function changeStatus($hook, $status) {
        $whtsp_tpl = MailTemplates::findOrFail($hook);
        $whtsp_tpl->status = $status;
        $whtsp_tpl->save();
        return redirect()->route('admin.mailtemplates')->withFlashSuccess('Email Template Updated!');
    }
}
