<?php

namespace App\Http\Controllers\Backend;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use File;
use ImageResize;

class MediaLibrary extends Controller{
    public function galleryIndex(){
        $folderPath = public_path('storage/media-upload');

        // Get all image files from the folder (jpg, jpeg, png, gif)
        $images = File::files($folderPath);
        $imageFiles = [];
        
        foreach ($images as $image) {
            // Get only image files (filter by extension)
            if (in_array($image->getExtension(), ['jpg', 'jpeg', 'png', 'gif','mp4','mov'])) {
                $imageFiles[] = 'storage/media-upload/thumbnail/' . $image->getFilename(); // Save relative path to the image
            }
        }
        
        return view("backend.gallery.gallery", compact('imageFiles'));
    }

    public function galleryEdit(Request $request)
    {
        // dd($request->all());
        $image = $request->file;
        return view("backend.gallery.edit", compact('image'));
    }

    public function store(Request $request)
    {
        // Validate the uploaded file
        // 1600w * 1200h max
        // Thumb 400w * 400h max

        // On url show original image
        $request->validate([
            'file' => 'required|file|mimes:jpg,jpeg,mp4,mov,png,gif|max:16384', // Max 5MB, and specify allowed image types
        ]);

        // Define the upload path
        $uploadPath = storage_path('app/public/media-upload');
        $uploadThumbnailPath = storage_path('app/public/media-upload/thumbnail');
        
        // Check if the directory exists, if not, create it
        if (!File::exists($uploadPath)) {
            File::makeDirectory($uploadPath, 0755, true);
        }

        // Retrieve the uploaded file
        $file = $request->file('file');

        // Generate a unique filename to avoid overwriting files
        $filename = uniqid() . '_' . $file->getClientOriginalName();

        // Move the file to the specified path
        $file->move($uploadPath, $filename);

        $originalFile = $uploadPath."/".$filename;

        // Thumbnail Start
        // Load the image
        $img = Image::make($originalFile);

        // Resize the image while maintaining aspect ratio
        $img->fit(150, 150);
        Storage::disk('public')->put("media-upload/thumbnail/".$filename, (string)$img->encode());

        // Return a success response
        return back()->with('success', 'File uploaded successfully!');
    }

    public function deleteImage(Request $request){
        // Dump and die to inspect the request data
        
        $imagePath = $request->image;
        $originalImage = str_replace("thumbnail/", "", $request->image);
        
        // Make sure to check if the file exists before trying to delete it
        if (file_exists(public_path($imagePath))) {
            unlink(public_path($imagePath)); // Use unlink to delete the Thumbnail file
            unlink(public_path($originalImage)); // Use unlink to delete the Original file
        }
    
        return redirect()->route('admin.gallery')->withFlashSuccess('Image Deleted Successfully');
    }
}