<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Models\Auth\Course;
use Illuminate\Support\Str;
use App\Models\Auth\Webinar;
use App\Mail\MailSend;
use App\Notifications\Backend\UserAlert;
use App\Http\Requests\Backend\Auth\User\MeetingRoomRequest;
use App\Repositories\Backend\Auth\UserRepository;
use App\Models\MailTemplates;
use App\Models\Auth\MeetingRoom;



class MeetingRoomController extends Controller
{

  public function __construct()
  {
    $this->middleware(function ($request, $next) {
      $user = \Auth::user();
      if (!(\Auth::user()->isAdmin() || \Auth::user()->can('trainings configs'))) {
        return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
      }
      return $next($request);
    });
  }

  public function index()
  {
    $meeting = MeetingRoom::all();
    return view('backend.meeting_room.meetingroom', ['meeting' => $meeting]);
  }
  public function create()
  {
    return view('backend.meeting_room.meetingcreate');
  }

  public function store(MeetingRoomRequest $request)
  {
    $data = new MeetingRoom([
      'room_name' => $request->get('room_name'),
      'zoom_id' => $request->get('zoom_id')
    ]);
    $data->save();
    return redirect()->route('admin.meetingroom.index')->withFlashSuccess('Meeting Room Added Successfully');
  }
  public function destroyed($id)
  {

    if (DB::table('batch')->where('batch.meeting_room', $id)->first()) {
      return redirect()->route('admin.meetingroom.index')->withFlashDanger('Meeting Room Already Registered');
    } else {
      DB::table('meeting_rooms')->where('room_name', $id)->delete();
      return redirect()->route('admin.meetingroom.index')->withFlashSuccess('Meeting Room Deleted Successfully');
    }
  }

  public function bookinglist($value)
  {
    $pages = DB::table('batch')
      ->join('meeting_rooms', 'meeting_rooms.room_name', '=', 'batch.meeting_room')
      ->where('batch.meeting_room', $value)
      ->get();

    return view('backend.meeting_room.meetingroomlist', ['pages' => $pages]);
  }
}
