<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\DB;
use App\Models\Auth\Posts;
use App\Models\Auth\Course;
use App\Models\Auth\OnlineCourse;
use App\Models\Auth\CountryInfo;
use App\Models\Auth\User;
use App\Models\Auth\Batch;
use App\Models\Auth\UserNotification;
use App\Models\Banners;
use Illuminate\Http\Request;
use App\Helpers\General\Time;
use Carbon\Carbon;
use Illuminate\Support\Str;

/**
 * Class HomeController.
 */
class NotificationController extends Controller
{
    public function unread_noti()
    {
        $userid = \Auth::user()->id;
        $noti = DB::table('user_notification')
            ->where('user_id', $userid)
            ->where('read', '0')
            ->count();
        return json_encode($noti);
    }

    public function noti_list()
    {
        //\Log::debug("noti_list()");
        $userid = \Auth::user()->id;
        $noti_list = DB::table('user_notification')
            ->where('user_id', $userid)
            ->orderBy('id', 'desc')
            ->take(10)
            ->get();
        $cont = "";
        if (count($noti_list)) {
            foreach ($noti_list as $noti) {
                if ($noti->read == 0) {
                    $unseen = "unseen";
                } else {
                    $unseen = "";
                }

                if ($noti->application_type == "visa") {
                    $app_url = 'admin.service-visa.view';
                } elseif ($noti->application_type == "university") {
                    $app_url = 'admin.applicationdetail';
                } elseif ($noti->application_type == "lead" || $noti->application_type == "student" || $noti->application_type == "whatsapp_incoming") {
                    $app_url = 'admin.auth.user.show';
                } elseif ($noti->application_type == "ticket") {
                    $app_url = 'admin.viewticket';
                } elseif ($noti->application_type == "agent") {
                    $app_url = 'admin.agents.index';
                } elseif ($noti->application_type == "webinar") {
                    $app_url = 'admin.webinar.view';
                } elseif ($noti->application_type == "invoice") {
                    $app_url = 'admin.invoice.view-student-invoice';
                } elseif ($noti->application_type == "staff_leaves") {
                    $app_url = 'admin.staff-leaves';
                } else{
                    $app_url = '';
                }
                $url_route = "";
                if($noti->application_type == "agent"){
                    $url_route = route("$app_url");
                }else{
                    $url_route = route("$app_url", [$noti->application_id]);
                }
                $cont .= '<a href="' . $url_route . '" class="list-group-i clearfix ' . $unseen . '" data-id="' . $noti->id . '" onClick="noti_seen($(this))">
                    <li class="" style="margin-top: 5px; margin-bottom: 5px;">
                                    
                <div class="about d-flex justify-content-center align-items-center" style="margin-top: 3px; margin-bottom: 3px;"> ';
                    if ($noti->application_type == "visa") {
                        // $cont .= '<div class="name ' . $unseen . '"><b>Additional Services #:</b> ' . get_services_appl_id($noti->application_id) . '
                        //             </div>';
                        $cont .= '<span class="notif-img" style="max-height: 37px !important;"><img class="notification-icon " src="'.asset('assets/backend/img/visa.png').'"></span>';   
                    } elseif ($noti->application_type == "university") {
                        // $cont .= '<div class="name ' . $unseen . '"><b>Student:</b> ' . get_user_full_name_by_application_id($noti->application_id) . ' ('.get_user_id_by_application_id($noti->application_id).') Appl #' . get_application_id($noti->application_id) . '
                        //             </div>';
                        $cont .= '<span class="notif-img" style="max-height: 37px !important;"><img class="notification-icon " src="'.asset('assets/backend/img/mortarboard.png').'"></span>'; 
                    }elseif($noti->application_type == "whatsapp_incoming"){
                        $cont .= '<span class="notif-img" style="max-height: 37px !important;"><img class="notification-icon " class="notification-icon" src="'.asset('assets/backend/img/whatsapp.webp').'"></span>'; 
                    }
                    elseif ($noti->application_type == "lead") {
                        // $cont .= '<div class="name ' . $unseen . '"><b>Lead:</b> ' . get_user_full_name_by_id($noti->application_id) . ' ('.$noti->application_id.')
                        //             </div>';
                        $cont .= '<span class="notif-img d-inline-block" style="max-height: 37px !important;"><img class="notification-icon " src="'.asset('assets/backend/img/userleads.png').'" alt="User Leads">
                      </span>';   
                    } elseif ($noti->application_type == "student") {
                            // $cont .= '<div class="name ' . $unseen . '"><b>Lead:</b> ' . get_user_full_name_by_id($noti->application_id) . ' ('.$noti->application_id.')
                            //             </div>';
                        $cont .= '<span class="notif-img" style="max-height: 37px !important;"><img class="notification-icon " class="notification-icon" src="'.asset('assets/backend/img/userleads.png').'"></span>';   
                    } elseif($noti->application_type == "agent") {
                        // $cont .= '<div class="name ' . $unseen . '"><b>Agent:</b> ' . get_user_full_name_by_id($noti->application_id) . ' ('.$noti->application_id.')
                        //             </div>';
                        $cont .= '<span class="notif-img" style="max-height: 37px !important;"><img class="notification-icon " src="'.asset('assets/backend/img/customer-service.png').'"></span>';   
                    } elseif($noti->application_type == "ticket") {
                        // $cont .= '<div class="name ' . $unseen . '"><b>Ticket: #</b> ' . $noti->application_id . ", " . get_ticket_name($noti->application_id) . ' 
                        //             </div>';
                        $cont .= '<span class="notif-img" style="max-height: 37px !important;"><img class="notification-icon " src="'.asset('assets/backend/img/ticket.png').'"></span>';   
                    } elseif($noti->application_type == "webinar") {
                        // $cont .= '<div class="name ' . $unseen . '"><b>Webinar:</b> ' . get_webinar_name($noti->application_id) . '
                        //             </div>';
                        $cont .= '<span class="notif-img" style="max-height: 37px !important;"><img class="notification-icon " src="'.asset('assets/backend/img/webinar.png').'"></span>';   
                    } elseif($noti->application_type == "invoice") {
                        // $cont .= '<div class="name ' . $unseen . '"><b>Invoice:</b> ' . get_invoice_num($noti->application_id) . '
                        //             </div>';
                        $cont .= '<span class="notif-img" style="max-height: 37px !important;"><img class="notification-icon " src="'.asset('assets/backend/img/invoice.png').'"></span>';   
                    } elseif($noti->application_type == "staff_leaves") {
                        // $cont .= '<div class="name ' . $unseen . '"><b>Staff Leaves:</b> ' . get_staff_leaves($noti->application_id) . '
                        //             </div>';
                        $cont .= '<span class="notif-img border" style="max-height: 37px !important;"><img class="notification-icon " src="'.asset('assets/backend/img/leave.png').'"></span>';   
                    }
                    if(strlen($noti->message) > 250){
                        $noti->message = substr(str_replace(["<br>", "<a>", "</a>"], ", ", $noti->message), 0, 250) . "...";
                    } else{
                        $noti->message = str_replace(["<br>", "<a>", "</a>"], ", ", $noti->message);
                    }
                    $cont .= '  <span style="font-weight: normal; float: right; line-height: 1.75;" "class="mb-2 note ' . $unseen . '">
                                    <span class="notification-message">' . $noti->message . '</span>
                                    <br>
                                    <span class="time my-2 ' . $unseen . '" style="color: rgb(140, 144, 151) !important;">
                                        <span class="dot d-none"></span>
                                        <i class="bi bi-clock" style="padding: 5px;"></i>' . \Carbon\Carbon::parse($noti->created_at)->diffForHumans() . '
                                    </span> &nbsp;
                                    <span class="name ' . $unseen . '"><i class="fa fa-user" style="color: #4E93F4;"></i><span class="mx-1"></span>' . get_user_full_name_by_id($noti->from_user) . '
                                </span>
                            </li>
                        </a>';
                    }
        } else {
            // $cont = "<li class='text-center'><h4 class='text-center p-4'>No new notification!</h4></li>";
            $cont = "";
        }

        return json_encode($cont);
    }

    public function view_all_noti()
    {
        $user = \Auth::user()->id;
        $notifications = DB::table('user_notification')->where('user_id', $user)->orderBy('id', 'desc')->paginate(10);
        return view('backend.all_notifications', compact('notifications', 'user'));
    }

    public function noti_seen(Request $request)
    {
        $noti = UserNotification::find($request->noti_id);
        $noti->read = 1;
        $noti->save();
        //$notifications = DB::table('user_notifications')->where('id',$request->noti_id)->update(['seen'=>1]);
        return "Noti Seen!";
    }

    public function mark_all_noti_seen($user_id)
    {
        
        $noti = UserNotification::where('user_id',$user_id)->get();
        if(!$noti){
            return redirect()->route('admin.view-all-noti')->withFlashDanger('Invalid Request!');
        }
        $notifications = DB::table('user_notification')->where('user_id',$user_id)->update(['read'=>1]);

        return redirect()->route('admin.view-all-noti')->withFlashSuccess('All Notifications marked as Read!');
    }
}
