<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Auth\User;
use App\Models\Auth\OnlineCourse;
use App\Models\Auth\StudentOnlineCourse;
use Illuminate\Support\Facades\Input;

class OnlineCourseEnrollmentController extends Controller
{

    public function index()
    {
        $online_courses = OnlineCourse::orderBy('title')->get();
        return view('backend.online_course_enrollment.enrollment_list', compact('online_courses'));
    }

    public function create()
    {
        $online_courses = OnlineCourse::orderBy('title')->get();
        return view('backend.online_course_enrollment.enrollment_create', compact('online_courses'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'student_id' => 'required',
            'online_course_id' => 'required'
        ]);

        if (StudentOnlineCourse::where(['student_id' => $request->input('student_id'), 'online_course_id' => $request->input('online_course_id')])->exists()) {
            return redirect()->back()->withFlashDanger('Student already enrolled for this course!');
        }
        $enrollment = StudentOnlineCourse::create([
            'student_id' => $request->input('student_id'),
            'online_course_id' => $request->input('online_course_id'),
            'staff_id' => auth()->user()->id
        ]);
        return redirect()->route('admin.online-course-enrollment.index')->withFlashSuccess('Student enrolled successfully');
    }

    public function ajaxonlinecourseenrollmentlist(Request $request)
    {

        if (!$request->ajax()) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this page.');
        }
        echo $this->getDatatableEnrollmentList($request);
    }


    public function getDatatableEnrollmentList($request)
    {
        $columns = array(
            0 => 'created_at',
            1 => 'student',
            2 => 'course',
            3 => 'actions',
        );

        $totalData = DB::table('student_online_course')->count();
        $totalFiltered = $totalData;
        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');
        $online_course = $request->input('online_course');

        if (empty($request->input('search.value')) && empty($online_course)) {
            $enrollments = DB::table('student_online_course')
                ->join('users', 'users.id', '=', 'student_online_course.student_id')
                ->join('online_course', 'online_course.id', '=', 'student_online_course.online_course_id')
                ->select('student_online_course.*', 'users.first_name', 'users.last_name', 'online_course.title')
                ->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                ->get();
        } else {
            $get_search = $request->input('search.value');
            $enrollments = DB::table('student_online_course')
                ->join('users', 'users.id', '=', 'student_online_course.student_id')
                ->join('online_course', 'online_course.id', '=', 'student_online_course.online_course_id')
                ->select('student_online_course.*', 'users.first_name', 'users.last_name', 'online_course.title')
                ->where(function ($query) use ($get_search) {
                    $query->Where('first_name', 'like', "%$get_search%")
                        ->orWhere('last_name', 'like', "%$get_search%")
                        ->orWhereRaw("CONCAT(`first_name`, ' ', `last_name`) LIKE ?", ['%'.$get_search.'%'])
                        ->orWhere('mobile', '=', "%$get_search%");
                })
                ->when(!empty($online_course), function ($query) use ($online_course) {
                    return  $query->Where('online_course_id', '=', "$online_course");
                })
                ->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                ->get();

            $totalFiltered = $enrollments->count();
        }

        $data = $customResult = array();
        if (!empty($enrollments)) {
            $count = 1;
            foreach ($enrollments as $enrollment) {
                $customResult['student'] = "<a target='_blank' href='" . route('admin.auth.user.show', $enrollment->id) . "'><strong><span style='white-space:nowrap;'>".$enrollment->first_name . " " . $enrollment->last_name."</a>";
                $customResult['course'] = $enrollment->title;
                $customResult['created_at'] = get_date_time_formated($enrollment->created_at);

                $customResult['actions'] = '<a href="' .  route('admin.online-course-enrollment.destroy', $enrollment->id) . '"data-method="delete" class="btn btn-outline-danger" title="Delete"><i class="fas fa-trash-alt" style="font-size:17px"></i></a>';

                $data[] = $customResult;
            }
        }

        $json_data = array(
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $data
        );

        return json_encode($json_data);
    }

    public function destroy($id)
    {
        $enrollment = StudentOnlineCourse::find($id);
        $enrollment->delete();
        return redirect()->route('admin.online-course-enrollment.index')->withFlashSuccess('Enrollment Deleted Successfully');
    }
}
