<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Auth\User;
use App\Models\Auth\LeadStatus;
use App\Models\Banners;
use App\Models\Configs;
use App\Models\Auth\Posts;
use App\Models\Auth\AdditionalDocsConfigs;
use App\Models\ContentBlocks;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\Auth\CountryStudy;
use App\Repositories\Backend\Auth\UserRepository;
use App\Services\OpenAIService;
use Auth;
use Illuminate\Support\Arr;

use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Response;
use Spatie\Activitylog\Models\Activity;
use ZipArchive;

/**
 * Class OpenAiApiController.
 */

class OpenAiApiController extends Controller
{






    protected $openAIService;

    public function __construct(OpenAIService $openAIService)
    {

        $this->openAIService = $openAIService;
    }

    public function rephrase(Request $request)
    {
        $request->validate([
            'message' => 'required|string|max:1000',
        ]);
        $apiKey = env('OPENAI_API_KEY');
        
        if (!$apiKey) {
            return response()->json([
                'status' => "failed",
                'message' => "API Key Missing",
            ]);
        }
        if (Activity::where('event', 'openai_api_call')->where('created_at', 'like', date("Y-m-") . '%')->count() >= env('MONTHLY_OPENAI_API_LIMIT')) {
            \Log::error("ERROR!!!!! MONTHLY API LIMIT Reached!");
            return response()->json([
                'status' => "failed",
                'message' => 'ERROR!!!!! MONTHLY API LIMIT Reached!',
            ]);
        }
        $originalMessage = $request->input('message');
        $tone = $request->input('tone');
        $template = $request->input('template');
        // dd($originalMessage);
        $rephrasedMessage = $this->openAIService->rephraseMessage($originalMessage, $tone, $template);
        activity()->event('openai_api_call')->log('Api Call Sent From: ' . Auth::user()->name);

        return response()->json([
            'status' => "success",
            'original_message' => $originalMessage,
            'rephrased_message' => trim($rephrasedMessage),
        ]);
    }
}
