<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Models\Auth\Posts;
use App\Models\Auth\Products;
use App\Models\Auth\ProductCategories;
use App\Models\Auth\Categories;
use App\Models\Auth\ProductImages;
use App\Models\Auth\CurrencyRate;
use App\Models\Auth\ProductDownloads;
use App\Models\Auth\UserShippingAddress;
use App\Models\Auth\Orders;
use App\Models\Auth\OnlineCourse;
use App\Models\Auth\Course;
use App\Models\Auth\OrderItems;
use App\Models\Auth\OrderStatus;
use App\Helpers\OrderHelper;
use App\Models\Auth\PaymentGatewayTrans;
use App\Models\Auth\StudentOnlineCourse;
use App\Models\Auth\User;
use App\Models\Auth\Country;
use App\Models\Auth\Shipping;
use App\Models\Auth\State;
use App\Models\Auth\City;
use Illuminate\Http\Request;
use File;
use Log;
use Carbon\Carbon;
use Yajra\DataTables\DataTables;

class OrdersController extends Controller
{

  public function orders()
  {
    return view("backend.orders.index");
  }

  public function orders_list()
  {
    $my_branch = get_staff_branch_ids(\Auth::user()->id);
    $data = Orders::join('users', 'users.id', '=', 'orders.user_id')
            ->where(function ($query) use ($my_branch) {
                return $query->whereIn('users.branch', $my_branch);
            })
            ->latest('orders.created_at')->get('orders.*');
    return Datatables::of($data)
      ->addIndexColumn()
      ->editColumn('date', function ($data) {
        //  $date = strtotime($data->created_at); 
        //  $new_date = date('d-m-Y H:i:s', $date);
        return get_date_time_formated($data->created_at);
      })
      ->editColumn('order_id', function ($data) {
        return $data->id;
      })
      ->editColumn('order_type', function ($data) {
        return ucfirst(str_replace('_', ' ', $data->order_type));
      })
      ->editColumn('num_products', function ($data) {
        $items = OrderItems::where('order_id', '=', $data->id)->get();
        $count = count($items);

        return $count;
      })
      ->editColumn('seller', function ($data) {
        $items = OrderItems::where('order_id', '=', $data->id)->get();
        $seller = array();
        for ($i = 0; $i < count($items); $i++) {
          if ($items[$i]->product_id != 0) {
            $product_det = Products::where('id', '=', $items[$i]->product_id)->first();
            $s = User::where('id', '=', $product_det->seller)->first();
            $seller[] = $s->name;
          } else {
            $seller[] = 1;
          }
        }
        $sel = implode(",", $seller);


        return ucfirst($sel);
      })
      ->editColumn('customer', function ($data) {
        $user = User::where('id', '=', $data->user_id)->first();
        if($user){
          $name = $user->first_name . " " . $user->last_name;
          return "<a target='_blank' href='" . route('admin.auth.user.show', $user->id) . "'><strong><span style='white-space:nowrap;'>".$name."</a>";
        }else{
          $name = "--";
          return "<strong><span style='white-space:nowrap;'>".$name."</a>";
        }
      })
      ->editColumn('amount', function ($data) {
        $cur = CurrencyRate::where('code', '=', $data->currency)->first();
        return config('app.currency_symbol') . $data->total;
      })
      ->editColumn('delivery_status', function ($data) {
        $sta = OrderItems::where('order_id', '=', $data->id)->first();
        if ($sta) {
          return ucfirst($sta->status);
        } else {
          return "";
        }
      })
      ->editColumn('payment_status', function ($data) {
        return ucfirst($data->status);
      })
      ->addColumn('action', function ($data) {
        $type = "all-orders";
        return view("backend.orders.btn", compact('data', 'type'));
      })
      ->rawColumns(['action','customer'])
      ->make(true);
  }

  public function inhouse_orders()
  {
    $module_title = "Inhouse Orders";
    $module_name = "orders";
    $module_path = "orders";
    $module_icon = "fas fa-cart";
    $module_model = "App\Models\Orders";
    $module_name_singular = "";
    $module_action = "";

    return view(
      "backend.orders.inhouse-orders",
      compact('module_title', 'module_name', 'module_path', 'module_icon', 'module_action', 'module_name_singular')
    );
  }


  public function inhouse_orders_list()
  {

    $data = Orders::join('order_items', function ($join) {
      $join->on('orders.id', '=', 'order_items.order_id');
    })->where('order_items.seller_id', '=', 1)->groupBy('order_items.order_id')->orderBy('orders.created_at', 'desc')->get('orders.*');

    return Datatables::of($data)
      ->addIndexColumn()
      ->editColumn('date', function ($data) {
        $date = strtotime($data->created_at);
        $new_date = date('d-m-Y', $date);
        return $new_date;
      })
      ->editColumn('order_id', function ($data) {
        return $data->order_num;
      })
      ->editColumn('num_products', function ($data) {
        $items = OrderItems::where('order_id', '=', $data->id)->get();
        $count = count($items);

        return $count;
      })
      ->editColumn('customer', function ($data) {
        $user = User::where('id', '=', $data->user_id)->first();

        if ($user->name) {
          $name = $user->name;
        } else {
          $name = $user->first_name . " " . $user->last_name;
        }
        return $name;
      })
      ->editColumn('amount', function ($data) {
        $cur = CurrencyRate::where('code', '=', $data->currency)->first();
        return $cur->symbol . $data->order_total_base;
      })
      ->editColumn('delivery_status', function ($data) {
        $sta = OrderItems::where('order_id', '=', $data->id)->first();
        if ($sta->status == "customer_recieved") {
          $st = "Customer Recieved";
        } else {
          $st = $sta->status;
        }
        return ucfirst($st);
        return ucfirst($sta->status);
      })
      ->editColumn('payment_status', function ($data) {
        return ucfirst($data->status);
      })
      ->addColumn('action', function ($data) {
        $type = "inhouse-orders";
        return view("backend.orders.btn", compact('data', 'type'));
      })
      ->rawColumns(['action'])
      ->make(true);
  }


  public function view_order($id)
  {

    $order_det = Orders::where('id', '=', $id)->first();

    $user_det = User::where('id', '=', $order_det->user_id)->first();
    $country = Country::where('id', '=', $user_det->country)->first();
    $state = State::where('id', '=', $user_det->state)->first();
    $city = City::where('id', '=', $user_det->city)->first();
    $currency = CurrencyRate::where('code', '=', $order_det->currency)->first();
    $items = OrderItems::where('order_id', '=', $id)->get();
    $items_det = array();
    $img = array();
    for ($i = 0; $i < count($items); $i++) {
      if ($items[$i]->product_id != 0) {
        $item_id = $items[$i]->product_id;
        $items_det[] = Products::where('id', '=', $item_id)->first();
        $img[] = ProductImages::where('product_id', '=', $item_id)->where('is_default', '=', 1)->first();
        $prod_type = Products::where('id', '=', $item_id)->first(['type']);
      } else if ($items[$i]->coaching_id != 0) {
        $item_id = $items[$i]->coaching_id;
        $items_det[] = Course::where('id', '=', $item_id)->first();
        $img[] = Course::where('id', '=', $item_id)->first(['image']);
        $prod_type = 'coaching';
      } else if ($items[$i]->online_course_id != 0) {
        $item_id = $items[$i]->online_course_id;
        $items_det[] = OnlineCourse::where('id', '=', $item_id)->first();
        $img[] = OnlineCourse::where('id', '=', $item_id)->first(['image']);
        $prod_type = 'online_course';
      }
    }
    $activities = OrderStatus::where('orderid', '=', $id)->get();
    return view(
      "backend.orders.view-order",
      compact('user_det', 'country', 'state', 'city', 'order_det', 'currency', 'items_det', 'items', 'img', 'activities')
    );
  }

  public function view_inhouse_orders($id)
  {

    $module_name = "orders";
    $module_path = "orders";
    $module_icon = "fas fa-cart";
    $module_model = "App\Models\Orders";
    $module_name_singular = "";
    $module_action = "";

    $order_det = Orders::where('id', '=', $id)->first();
    $module_title = "Order #" . $order_det->order_num;

    $user_det = User::where('id', '=', $order_det->user_id)->first();
    $country = Country::where('id', '=', $user_det->country)->first();
    $state = State::where('id', '=', $user_det->state)->first();
    $city = City::where('id', '=', $user_det->city)->first();
    $currency = CurrencyRate::where('code', '=', $order_det->currency)->first();

    $items = OrderItems::where('order_id', '=', $id)->get();
    $items_det = array();

    for ($i = 0; $i < count($items); $i++) {
      $item_id = $items[$i]->product_id;
      $items_det[] = Products::where('id', '=', $item_id)->first();
      $img[] = ProductImages::where('product_id', '=', $item_id)->where('is_default', '=', 1)->first();
    }
    $activities = OrderStatus::where('orderid', '=', $id)->get();

    return view(
      "backend.orders.view_inhouse_orders",
      compact('module_title', 'module_name', 'module_path', 'module_icon', 'module_action', 'module_name_singular', 'user_det', 'country', 'state', 'city', 'order_det', 'currency', 'items_det', 'items', 'img', 'activities')
    );
  }


	public function change_payment_status(Request $request){
		$id = $request->order_id;
		$status = $request->paymentstatus;
		$from = $request->from;

		// Orders::where('id','=',$id)->update([
		//   'status'=>$status
		// ]);
		$order = Orders::find($id);
		if($order->status == $status){
			return redirect()->route('admin.orders.view-order', [$id])->withFlashDanger("Order already in selected status!");
		}

		if ($order) {
		$order->status = $status;
		$order->save();

		if ($status == 'paid') {
			OrderHelper::paid($id);
		}

		//$seller_id = auth()->user()->id;
		//$adsData = OrderItems::where('order_id','=', $id)->where('seller_id','=',$seller_id)->get();
		// $adsData = OrderItems::where('order_id', '=', $id)->get();
		// foreach ($adsData as $data) {
		//   $activity = new OrderStatus;
		//   $activity->orderid = $request->order_id;


		//   //Adding student to student_online_course table
		//   if ($order->order_type == "online_course") {
		//     $activity->p_id = $data->online_course_id;
		//     if ($status == 'paid') {
		//       if (StudentOnlineCourse::where(['student_id' => $order->user_id, 'online_course_id' => $data->online_course_id])->exists()) {
		//         Log::debug('Change payment status :: Student already enrolled for this course!');
		//       } else {
		//         $enrollment = StudentOnlineCourse::create([
		//           'student_id' => $order->user_id,
		//           'online_course_id' => $data->online_course_id,
		//           'staff_id' => auth()->user()->id
		//         ]);
		//       }
		//     }
		//   } elseif ($order->order_type == "coaching") {
		//     $activity->p_id = $data->coaching_id;
		//   } else {
		//     $activity->p_id = $data->product_id;
		//   }

		//   $activity->trans_date = date("Y-m-d H:s:i");
		//   $activity->type = "payment";
		//   $activity->status = $request->paymentstatus;
		//   $activity->notes = $request->notes;
		//   $activity->save();
		// }
		return redirect()->route('admin.orders.view-order', [$id])->withFlashSuccess("Payment Status Updated!");
		} else {
		return redirect()->route('admin.orders.view-order', [$id])->withFlashDanger("Invalid Order!");
		}
	}


  public function change_delivery_status(Request $request)
  {
    $id = $request->order_id;
    $status = $request->deliverystatus;
    $from = $request->from;
    OrderItems::where('order_id', '=', $id)->update([
      'status' => $status
    ]);
    $seller_id = auth()->user()->id;
    $adsData = OrderItems::where('order_id', '=', $id)->where('seller_id', '=', $seller_id)->get();
    foreach ($adsData as $data) {
      $activity = new OrderStatus;
      $activity->orderid = $request->order_id;
      $activity->p_id = $data->product_id;
      $activity->trans_date = date("Y-m-d H:s:i");
      $activity->type = "delivery";
      $activity->status = $request->deliverystatus;
      $activity->notes = $request->notes;
      $activity->save();
    }
    return redirect()->route('admin.orders.view-order', [$id])->withFlashSuccess("Delivery Status Updated!");
  }

  public function generate_order()
  {
    $products = Products::where('type','digital')->where('status','enabled')->get(['id','title','seller','offer_price','price']);
    return view('backend.orders.generate_order',compact('products'));
  }

  public function generate_order_save(Request $request)
  {
      $request->validate([
          'student_id' => 'required',
          'item1' => 'required',
      ]);

      // echo "<pre>";
      // print_r($request->all());
      // exit();

      
      $order = new Orders([
          'user_id' => $request->student_id,
          'create_date' => now(),
          'order_type' => "digital",
          'shipping_to' => "",
          'total' => $request->sub_total,
          'total_base' => $request->sub_total,
          'payment_type' => "bank",
          'currency' => config('app.currency'),
          'status' => "pending",
      ]);
      if($order->save()){
        if(isset($request->item1) && !empty($request->item1)){
          $product = Products::where('id', $request->item1)->first();
          $order_detail = new OrderItems;
          $order_detail->order_id  = $order->id;
          $order_detail->seller_id = $product->seller;
          $order_detail->product_id = $product->id;
          $order_detail->qty = $request->item1qty;
          $order_detail->price = $request->item1amt * $request->item1qty;
          $order_detail->price_base = $request->item1amt * $request->item1qty;
          $order_detail->currency = config('app.currency');
          $order_detail->status = "pending";
          $order_detail->details = "";
          $order_detail->shipping_cost = "";
          $order_detail->save();
        }
        if(isset($request->item2) && !empty($request->item2)){
          $product2 = Products::where('id', $request->item2)->first();
          $order2_detail = new OrderItems;
          $order2_detail->order_id  = $order->id;
          $order2_detail->seller_id = $product2->seller;
          $order2_detail->product_id = $product2->id;
          $order2_detail->qty = $request->item2qty;
          $order2_detail->price = $request->item2amt * $request->item2qty;
          $order2_detail->price_base = $request->item2amt * $request->item2qty;
          $order2_detail->currency = config('app.currency');
          $order2_detail->status = "pending";
          $order2_detail->details = "";
          $order2_detail->shipping_cost = "";
          $order2_detail->save();
        }
        if(isset($request->item3) && !empty($request->item3)){
          $product3 = Products::where('id', $request->item3)->first();
          $order3_detail = new OrderItems;
          $order3_detail->order_id  = $order->id;
          $order3_detail->seller_id = $product3->seller;
          $order3_detail->product_id = $product3->id;
          $order3_detail->qty = $request->item3qty;
          $order3_detail->price = $request->item3amt * $request->item3qty;
          $order3_detail->price_base = $request->item3amt * $request->item3qty;
          $order3_detail->currency = config('app.currency');
          $order3_detail->status = "pending";
          $order3_detail->details = "";
          $order3_detail->shipping_cost = "";
          $order3_detail->save();
        }
      }
      return redirect()->route('admin.orders')->withFlashSuccess('Order Generated!');
  }



}
