<?php

namespace App\Http\Controllers\Backend;


use App\Http\Controllers\Controller;
use App\Models\Auth\Products;
use App\Models\Auth\ProductCategories;
use App\Models\Auth\Categories;
use App\Models\Auth\ProductImages;
use App\Models\Auth\CurrencyRate;
use App\Models\Auth\ProductDownloads;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Log;
use File;
use Response;
use Yajra\DataTables\DataTables;


class ProductController extends Controller
{

  public function __construct()
  {
      $this->middleware(function ($request, $next) {
          if (!(\Auth::user()->isAdmin() || \Auth::user()->can('shop-management'))) {
              return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
          }
          return $next($request);
      });
  }


  public function index()
  {
    $values = Products::all();
    return view('backend.products.index', ['products' => $values]);
  }

  public function products_list()
  {
    $data = Products::where('seller', '=', 1)->latest()->get();
    return Datatables::of($data)
      ->addIndexColumn()
      ->editColumn('title', function ($data) {
        $img_det = ProductImages::where('product_id', '=', $data->id)->where('type', '=', 'image')->where('is_default', '=', 1)->first();
        return view('backend.products.title', compact('data', 'img_det'));
      })
      ->editColumn('type', function ($data) {
        return ucfirst($data->type);
      })
      ->editColumn('price', function ($data) {
        $cur = $data->currency;
        if ($cur == "USD") {
          $code = "$";
        } else if ($cur == "EUR") {
          $code = "€";
        } elseif ($cur == "GBP") {
          $code = "£";
        } else {
          $code = '?';
        }
        return $code . $data->price;
      })
      ->editColumn('offer_price', function ($data) {
        if ($data->offer_price == 0) {
          return "-";
        }
        $cur = $data->currency;
        if ($cur == "USD") {
          $code = "$";
        } else if ($cur == "EUR") {
          $code = "€";
        } elseif ($cur == "GBP") {
          $code = "£";
        } else {
          $code = '?';
        }

        return $code . $data->offer_price;
      })
      ->editColumn('category', function ($data) {
        $cat = ProductCategories::where('product_id', '=', $data->id)->get();
        $category = array();
        for ($i = 0; $i < count($cat); $i++) {
          $category[] = Categories::where('id', '=', $cat[$i]->category_id)->first();
        }
        return  view('backend.products.category', compact('category'));
      })
      ->addColumn('action', function ($data) {
        return view('backend.products.btn', compact('data'));
      })
      ->rawColumns(['action'])
      ->make(true);
  }

  public function create_product()
  {

    $currency = CurrencyRate::get();
    $categories = Categories::where('parent', '=', 0)->get();
    $subcategories = Categories::where('parent', '!=', 0)->get();
    return view(
      "backend.products.create",
      compact('categories', 'currency', 'subcategories')
    );
  }


  public function save_product(Request $request)
  {
    $this->validate(
      $request,
      [
        'title' => 'required|max:100',
        'type' => 'required',
        //'currency'=>'required',
        'category' => 'required',
        'price' => 'required|numeric',
        'offer_price' => 'nullable|numeric',
        'has_downloads' => 'required',
        'short_desc' => 'required|max:500',
        'status' => 'required',
        'file' => 'image|mimes:jpeg,jpg,gif,png,svg|max:8192',
        'display_order' => 'required|numeric',
        'video'  => 'max:102400',
      ]
    );

    if ($request->hasFile('file')) {
      $filenameWithExt = $request->file('file')->getClientOriginalName();
      // Get Filename
      $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
      // Get just Extension
      $extension = $request->file('file')->getClientOriginalExtension();
      // Filename To store
      $fileNameToStore = $filename . '_' . time() . '.' . $extension;
      $request->file->move('storage/products', $fileNameToStore);
    }

    if ($request->hasFile('video')) {
      $filenameWithExt = $request->file('video')->getClientOriginalName();
      // Get Filename
      $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
      // Get just Extension
      $extension = $request->file('video')->getClientOriginalExtension();
      // Filename To store
      $videoNameToStore = $filename . '_' . time() . '.' . $extension;
      $request->video->move('storage/products', $videoNameToStore);
    }
    $newslug = explode(' ', $request->title);
    if (count($newslug) > 0) {
      $slug_val = Str::slug($request->title, '-');
      $Gslug = $this->setSlugAttribute($slug_val);
    } else {
      $Cslug = $request->title;
      $Gslug = $this->setSlugAttribute($Cslug);
    }

    $product = new Products();
    $product->title = $request->title;
    $product->type = $request->type;
    $product->currency = config('app.currency');
    $product->price = $request->price;
    if ($request->offer_price == "") {
      $product->offer_price = 0;
    } else {
      $product->offer_price = $request->offer_price;
    }



    $product->has_downloads = $request->has_downloads;
    $product->short_desc = $request->short_desc;
    $product->slug = $Gslug;
    $product->details = $request->details;
    $product->meta_title = $request->title;
    $product->meta_desc = $request->short_desc;
    $product->dimension = $request->dimension;
    $product->color = $request->color;
    $product->brand = $request->brand;
    $product->weight = $request->weight;
    $product->stock = $request->stock;
    $product->stock = $request->stock;
    $product->status = $request->status;
    $product->order = $request->display_order;
    $product->save();

    $product_id = $product->id;
    $categories = $request->category;
    for ($i = 0; $i < count($categories); $i++) {
      $cat = new ProductCategories;
      $cat->product_id = $product_id;
      $cat->category_id = $categories[$i];
      $cat->save();
    }

    if ($request->hasFile('file')) {
      $img = new ProductImages;
      $img->product_id = $product_id;
      $img->type = "image";
      $img->filename = $fileNameToStore;
      $img->is_default = 1;
      $img->order = 99;
      $img->save();
    }

    if ($request->hasFile('video') && $request->video_url) {
      $img = new ProductImages;
      $img->product_id = $product_id;
      $img->type = "video";
      $img->filename = $videoNameToStore;
      $img->order = 99;
      $img->save();

      $img = new ProductImages;
      $img->product_id = $product_id;
      $img->type = "video";
      $img->filename = $request->video_url;
      $img->order = 99;
      $img->save();
    } else if ($request->hasFile('video')) {

      $img = new ProductImages;
      $img->product_id = $product_id;
      $img->type = "video";
      $img->filename = $videoNameToStore;
      $img->order = 99;
      $img->save();
    } else if ($request->video_url) {
      $img = new ProductImages;
      $img->product_id = $product_id;
      $img->type = "video";
      $img->filename = $request->video_url;
      $img->order = 99;
      $img->save();
    }
    return redirect()->route('admin.products')->withFlashSuccess("New Product Added!");
  }


  public function edit_product($slug)
  {

    $currency = CurrencyRate::get();
    $categories = Categories::where('parent', '=', 0)->get();
    $subcategories = Categories::where('parent', '!=', 0)->get();
    $product_det = Products::where('slug', '=', $slug)->first();
    $product_cat = ProductCategories::where('product_id', '=', $product_det->id)->get();
    $featured_img = ProductImages::where('product_id', '=', $product_det->id)->where('type', '=', 'image')->where('is_default', '=', 1)->first();
    $addtional_imgs = ProductImages::where('product_id', '=', $product_det->id)->where('type', '=', 'image')->where('is_default', '=', 0)->get();
    $videourl = ProductImages::where('product_id', '=', $product_det->id)->where('type', '=', 'video')->where('filename', 'like', '%' . 'http' . '%')->first();
    $video = ProductImages::where('product_id', '=', $product_det->id)->where('type', '=', 'video')->where('filename', 'not like', "%http%")->first();

    return view(
      "backend.products.edit",
      compact('categories', 'product_det', 'currency', 'product_cat', 'featured_img', 'videourl', 'video', 'subcategories', 'addtional_imgs')
    );
  }

  public function update_product(Request $request)
  {
    $slug = $request->slug;

    $this->validate(
      $request,
      [
        'title' => 'required|max:100',
        'type' => 'required',
        //'currency'=>'required',
        'category' => 'required',
        'price' => 'required|numeric',
        'offer_price' => 'nullable|numeric',
        'has_downloads' => 'required',
        'short_desc' => 'required|max:500',
        'status' => 'required',
        'display_order' => 'required|numeric',
      ]
    );

    $product_details = Products::where('slug', '=', $slug)->first();

    Products::where('slug', '=', $slug)->update([
      'title' => $request->title,
      'type' => $request->type,
      //'currency'=>$request->currency,
      'price' => $request->price,
      'offer_price' => $request->offer_price,
      'has_downloads' => $request->has_downloads,
      'short_desc' => $request->short_desc,
      'details' => $request->details,
      'dimension' => $request->dimension,
      'color' => $request->color,
      'brand' => $request->brand,
      'weight' => $request->weight,
      'stock' => $request->stock,
      'status' => $request->status,
      'order' => $request->display_order,
    ]);

    $pid = $product_details->id;

    ProductCategories::where('product_id', '=', $pid)->delete();

    $categories = $request->category;

    for ($i = 0; $i < count($categories); $i++) {
      $cat = new ProductCategories;
      $cat->product_id = $pid;
      $cat->category_id = $categories[$i];
      $cat->save();
    }
    return redirect()->route('admin.products')->withFlashSuccess("Product Updated Successfully!");
  }


  public function upload_products_images(Request $request)
  {

    $id = $request->id;
    if ($request->file('files')) {
      $images = $request->file('files');
      $subimg = count($images);
      $aimg = ProductImages::where('product_id', '=', $id)
        ->where('type', '=', 'photo')
        ->where('is_default', '=', 0)
        ->get();
      $acc = count($aimg);
      $timg = $subimg + $acc;
      if ($timg > 20) {
        return Redirect::back()->withErrors(['Additional images limit is 20.']);
      }
    }

    if ($request->hasFile('featured_img')) {
      $img = ProductImages::where('product_id', '=', $id)->where('type', '=', 'image')->where('is_default', '=', 1)->first();
      File::delete("storage/products/" . $img->filename);
      $filenameWithExt = $request->file('featured_img')->getClientOriginalName();
      // Get Filename
      $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
      // Get just Extension
      $extension = $request->file('featured_img')->getClientOriginalExtension();
      // Filename To store
      $fileNameToStore = $filename . '_' . time() . '.' . $extension;
      $request->featured_img->move('storage/products', $fileNameToStore);
      ProductImages::where('type', '=', 'image')->where('product_id', '=', $id)->where('is_default', '=', 1)->update([
        'filename' => $fileNameToStore
      ]);
    }

    if ($request->file('files')) {
      $files = $request->file('files');
      for ($i = 0; $i < count($files); $i++) {
        $filenameWithExt = $files[$i]->getClientOriginalName();
        $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        $extension = $files[$i]->getClientOriginalExtension();
        $fileNameToStore = $filename . '_' . time() . '.' . $extension;
        $files[$i]->move('storage/aditional_images', $fileNameToStore);
        $pimg = new ProductImages;
        $pimg->product_id = $id;
        $pimg->type = "image";
        $pimg->filename = $fileNameToStore;
        $pimg->save();
      }
    }
    ProductImages::where('product_id', '=', $id)->where('type', '=', 'video')->where('filename', 'like', '%' . 'http' . '%')->update(['filename' => $request->video_url]);

    if ($request->hasFile('video')) {
      $video = ProductImages::where('product_id', '=', $id)->where('type', '=', 'video')->where('filename', 'like', '%' . 'not like' . '%')->first();
      if ($video) {
        File::delete("storage/products/" . $video->filename);

        $filenameWithExt = $request->file('video')->getClientOriginalName();
        // Get Filename
        $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        // Get just Extension
        $extension = $request->file('video')->getClientOriginalExtension();
        // Filename To store
        $videoNameToStore = $filename . '_' . time() . '.' . $extension;
        $request->video->move('storage/products', $videoNameToStore);
        // echo  $id.$videoNameToStore;exit;
        ProductImages::where('product_id', '=', $id)->where('type', '=', 'video')->where('filename', 'like', '%' . 'not like' . '%')->update([
          'filename' => $videoNameToStore
        ]);
      } else {
        $filenameWithExt = $request->file('video')->getClientOriginalName();
        // Get Filename
        $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        // Get just Extension
        $extension = $request->file('video')->getClientOriginalExtension();
        // Filename To store
        $videoNameToStore = $filename . '_' . time() . '.' . $extension;
        $request->video->move('storage/products', $videoNameToStore);

        $video = new ProductImages;
        $video->filename = $videoNameToStore;
        $video->type = "video";
        $video->product_id = $id;
        $video->save();
      }
    }
    return redirect()->route('admin.products')->withFlashSuccess("Product Updated!");
  }

  public function delete_product($slug)
  {
    $product_det = Products::where('slug', '=', $slug)->first();
    $id = $product_det->id;
    ProductImages::where('product_id', '=', $id)->delete();
    ProductCategories::where('product_id', '=', $id)->delete();
    Products::where('slug', '=', $slug)->delete();
    return redirect()->route('admin.products')->withFlashSuccess("Product Removed!");
  }

  public function removeimg($filename, $slug)
  {
    $product_det = Products::where('slug', '=', $slug)->first();
    File::delete("storage/products/" . $filename);
    ProductImages::where('filename', '=', $filename)->where('product_id', '=', $product_det->id)
      ->where('type', '=', 'image')->where('is_default', '=', 0)->delete();
    return redirect()->route('admin.products.edit-product', [$slug])->withFlashSuccess("Additional Image Removed!");
  }


  public function setSlugAttribute($value)
  {
    if (Products::where('slug', '=', $value)->exists()) {
      $slug = $this->incrementSlug($value);
    } else {
      $delimiter = '-';
      $slug = strtolower(trim(preg_replace('/[\s-]+/', $delimiter, preg_replace('/[^A-Za-z0-9-]+/', $delimiter, preg_replace('/[&]/', 'and', preg_replace('/[\']/', '', iconv('UTF-8', 'ASCII//TRANSLIT', $value))))), $delimiter));
    }
    return $this->attributes['slug'] = $slug;
  }

  public function incrementSlug($slug)
  {
    $original = $slug;
    $count = 2;
    while (Products::where('slug', '=', $slug)->exists()) {
      $slug = "{$original}-" . $count++;
    }
    return $slug;
  }

  public function product_downloads($slug)
  {
    $product_det = Products::where('slug', '=', $slug)->first();
    $products = ProductDownloads::where('product_id', '=', Null)->get();

    return view(
      "backend.products.product-downloads",
      compact('product_det', 'products')
    );
  }

  public function associate_downloads(Request $request)
  {
    $product_id = $request->product_id;
    $id = $request->download;
    $product_det = Products::where('id', '=', $product_id)->first();
    $det = ProductDownloads::where('product_id', '=', $product_id)->first();
    if ($det) {
      return redirect()->route('admin.products.product-downloads', [$product_det->slug])->withFlashError("Download is Already Associated to this Product!");
    }
    ProductDownloads::where('id', '=', $id)->update(['product_id' => $product_id]);
    return redirect()->route('admin.products.product-downloads', [$product_det->slug])->withFlashSuccess("Download Associated Successfully!");
  }


  public function download_list($slug)
  {
    $product_det = Products::where('slug', '=', $slug)->first();
    $data = ProductDownloads::where('product_id', '=', $product_det->id)->latest()->get();
    return Datatables::of($data)
      ->addColumn('action', function ($data) {
        $product_det = Products::where('id', '=', $data->product_id)->first();
        return view('backend.products.download-btn', compact('data', 'product_det'));
      })
      ->rawColumns(['action'])
      ->make(true);
  }

    public function download_file($id){
      $fil  = ProductDownloads::where('id','=',$id)->first();
        $filename = $fil->file;
        $file_path = 'storage/downloads/'. $filename;
        return Response::download($file_path, $filename, [
          'Content-Length: '. filesize($file_path)
      ]);
  }

  public function remove_product_download($id){
    $fil = ProductDownloads::where('id','=',$id)->first();
    $product_det = Products::where('id', '=', $fil->product_id)->first();

    if ($fil->product_id == '') {
      File::delete("storage/downloads/".$fil->file);
      ProductDownloads::where('id','=',$id)->delete();
        return redirect()->route('admin.products.product-downloads', [$product_det->slug])->withFlashSuccess("Download Removed!");
    }else{
        return redirect()->route('admin.products.product-downloads', [$product_det->slug])->withFlashDanger("You Cant remove this, While Associated with others!!");
    }
  }

}
