<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Auth\Course;
use App\Models\Auth\QuestionsAnswers;
use App\Models\Auth\QuestionAnswerComprehension;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class QuestionsAnswersController extends Controller{
    public function __construct(){
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('trainings configs'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }            
            return $next($request);
        });
    }
        
    public function index(){
        $courseId = (int)\Request::get('course_id', 0);
        $page = (int)\Request::get('page', 1);
        if ($courseId > 0) {
            $courseObj = Course::where('id','=',$courseId)->first();
            if (!empty($courseObj)) {
                $questionsAnswers = QuestionsAnswers::with('course')->where('course_id','=',$courseId)->orderBy("id", 'ASC')->paginate(10);
                return view('backend.courses.q_a.lists', ['qa' => $questionsAnswers, 'course_id' => $courseId,'page'=>$page]);
            }
        }
        return redirect()->route('admin.courses')->withFlashDanger('Course id is invalid!#2');
    }

    public function create(){
        $courseId= (int)\Request::get('course_id', 0);
        if($courseId > 0){
            $courseObj = Course::where('id', '=', $courseId)->first();
            if (!empty($courseObj)) {
                $comprehension = array();
                $comprehension = QuestionAnswerComprehension::where('status', '=' , '1')->where("course_id",'=',$courseId)->orderBy("updated_at", 'DESC')->get();                
                return view('backend.courses.q_a.add',['courseObj' => $courseObj, 'comprehension'=>$comprehension]);
            }
        }
        return redirect()->route('admin.courses')->withFlashDanger('Course id is invalid!#3');

    }

    public function store(Request $request){        
        $questionType = $request->get('question_type');
        $questionModel = $request->get('question_model');
        
        if($questionModel == 'comprehension'){
            $request->validate([
                'comprehension_list' => 'required|numeric'
            ]);
            
            if($questionType == 'objective'){
                $request->validate([
                    'course_id' => 'required|numeric',
                    'qa_category' => 'required',
                    'qa_question' => 'required',
                    'answer_type' => 'required',
                    'answers_options' => 'required|array',
                    'correct_answers' => 'required|array',
                    'question_type' => 'required',
                ]);
            }
            else{
                $request->validate([
                    'course_id' => 'required|numeric',
                    'qa_category' => 'required',
                    'qa_question' => 'required',
                    'question_type' => 'required',
                ]);
            } 
        }
        else{
            if($questionType == 'objective'){
                $request->validate([
                    'course_id' => 'required|numeric',
                    'qa_category' => 'required',
                    'qa_question' => 'required',
                    'answer_type' => 'required',
                    'answers_options' => 'required|array',
                    'correct_answers' => 'required|array',
                    'question_type' => 'required',
                    'chapter_no' => 'required'
                ]);
            }
            else{
                $request->validate([
                    'course_id' => 'required|numeric',
                    'qa_category' => 'required',
                    'qa_question' => 'required',
                    'question_type' => 'required',
                    'chapter_no' => 'required'
                ]);
            }
        }

        $courseId = $request->get('course_id');
        $courseObj = Course::where('id', '=', $courseId)->first();
        if(empty($courseObj)){
            return redirect()->route('admin.courses')->withFlashDanger('Course id is invalid!#4');
        }
        $questionFile = '';
        if ($request->hasFile('qa_attachment')) {
            $file = $request->qa_attachment->getClientOriginalName();
            $filename = pathinfo($file, PATHINFO_FILENAME);
            if (strlen($filename) > 125)
                $filename = substr($filename, 0, 125);

            $filename = $filename . Str::random(20) . "." . $request->qa_attachment->getClientOriginalExtension();
            $questionFile = $request->file('qa_attachment')->storeAs('/q_a', $filename, 'public');
        }
        
        if($request->get('comprehension_list') > 0){
            $comprehension_id = (int)$request->get('comprehension_list');
            $comprehension_data = QuestionAnswerComprehension::where('id', '=' , $comprehension_id)->first();                
            $chapter = $comprehension_data->chapter;
            $chapter_notes = $comprehension_data->chapter_notes;
        }
        else{
            $comprehension_id = NULL;
            $chapter = $request->get('chapter_no');
            $chapter_notes = $request->get('chapter_notes');
        }
        
        $data = array(
            'course_id' => $request->get('course_id'),
            'chapter' => $chapter,
            'chapter_notes' => $chapter_notes,
            'question_model' => $request->get('question_model'),
            'comprehension_id' => $comprehension_id,
            'category' => $request->get('qa_category'),
            'question_type' => $request->get('question_type'),
            'question' => $request->get('qa_question'),
            'question_file' => $questionFile,
            'question_file_type' => ($request->has('qa_attachment_type')) ? $request->get('qa_attachment_type') : 'none',
            'answer_type' => $request->get('answer_type'),
            'answer_options' => $request->get('answers_options'),
            'answers' => $request->get('correct_answers'),
            'status' => $request->get('status')
        );
        
        QuestionsAnswers::addOrUpdateQuestionsAndAnswers($data);
        return redirect()->route('admin.q_a.index',['course_id'=>$request->get('course_id')])->withFlashSuccess('Q&A Added Successfully!');
    }

    public function edit($id){
        $courseId = \Request::get('course_id');
        $page = \Request::get('page',1);
        $courseObj = Course::where('id', '=', $courseId)->first();
        $qaObj = QuestionsAnswers::where('id','=',$id)->where("course_id",'=',$courseId)->first();
        if(empty($qaObj) || empty($courseObj)){
            return redirect()->route('admin.courses')->withFlashDanger('Course id is invalid!#5');
        }
        $quiz = QuestionsAnswers::with('course')->where('id','=',$id)->first();
        $comprehension = QuestionAnswerComprehension::where('status', '=' , '1')->where("course_id",'=',$courseId)->orderBy("updated_at", 'DESC')->get();                
        
        $correctAnswers = !empty($quiz['answers']) ? explode(',',$quiz['answers']) : array();
        return view('backend.courses.q_a.edit', ['quiz' => $quiz,'correct_answers'=>$correctAnswers,'comprehension'=>$comprehension,'page'=>$page]);
    }

    public function update(Request $request, $id){
        $questionType = $request->get('question_type');
        $questionModel = $request->get('question_model');
        
        if($questionModel == 'comprehension'){
            $request->validate([
                'comprehension_list' => 'required|numeric'
            ]);
            
            if($questionType == 'objective'){
                $request->validate([
                    'course_id' => 'required|numeric',
                    'qa_category' => 'required',
                    'qa_question' => 'required',
                    'answer_type' => 'required',
                    'answers_options' => 'required|array',
                    'correct_answers' => 'required|array',
                    'question_type' => 'required'
                ]);
            }
            else{
                $request->validate([
                    'course_id' => 'required|numeric',
                    'qa_category' => 'required',
                    'qa_question' => 'required',
                    'question_type' => 'required'
                ]);
            }
            
        }
        else{
            if($questionType == 'objective'){
                $request->validate([
                    'course_id' => 'required|numeric',
                    'qa_category' => 'required',
                    'qa_question' => 'required',
                    'answer_type' => 'required',
                    'answers_options' => 'required|array',
                    'correct_answers' => 'required|array',
                    'question_type' => 'required',
                    'chapter_no' => 'required'
                ]);
            }
            else{
                $request->validate([
                    'course_id' => 'required|numeric',
                    'qa_category' => 'required',
                    'qa_question' => 'required',
                    'question_type' => 'required',
                    'chapter_no' => 'required'
                ]);
            }
        }
        
         
        $courseId = (int)\Request::get('course_id');
        $page = (int)\Request::get('page',1);
        $qaObj = QuestionsAnswers::where('id','=',$id)->where("course_id",'=',$courseId)->first();
        if(empty($qaObj)){
             return redirect()->route('admin.coures')->withFlashDanger('Course id is invalid!');
        }

        $questionFile = '';
        if ($request->hasFile('qa_attachment')) {
             $oldImagePath = $qaObj->question_file;
            if(!empty($oldImagePath)){
                 $oldFilePath = storage_path('app/public').'/'.$oldImagePath;
                 if(file_exists($oldFilePath)){
                     unlink($oldFilePath);
                }
            }
             $file = $request->qa_attachment->getClientOriginalName();
             $filename = pathinfo($file, PATHINFO_FILENAME);
             if (strlen($filename) > 125)
                 $filename = substr($filename, 0, 125);

             $filename = $filename . Str::random(20) . "." . $request->qa_attachment->getClientOriginalExtension();
             $questionFile = $request->file('qa_attachment')->storeAs('/q_a', $filename, 'public');
        }
         
         
        if($request->get('comprehension_list') > 0){
            $comprehension_id = (int)$request->get('comprehension_list');
            $comprehension_data = QuestionAnswerComprehension::where('id', '=' , $comprehension_id)->first();                
            $chapter = $comprehension_data->chapter;
            $chapter_notes = $comprehension_data->chapter_notes;
        }
        else{
            $comprehension_id = NULL;
            $chapter = $request->get('chapter_no');
            $chapter_notes = $request->get('chapter_notes');
        }         
        
        $data = array(
            'course_id' => $request->get('course_id'),
            'chapter' => $chapter,
            'chapter_notes' => $chapter_notes,
            'question_model' => $request->get('question_model'),
            'comprehension_id' => $comprehension_id,
            'category' => $request->get('qa_category'),
             'question_type' => $request->get('question_type'),
             'question' => $request->get('qa_question'),
             'question_file' => $questionFile,
             'question_file_type' => ($request->has('qa_attachment_type')) ? $request->get('qa_attachment_type') : 'none',
             'answer_type' => $request->get('answer_type'),
             'answer_options' => $request->get('answers_options'),
             'answers' => $request->get('correct_answers'),
             //'display_order' => $request->get('display_order'),
             'status' => $request->get('status')
        );
        QuestionsAnswers::addOrUpdateQuestionsAndAnswers($data,$id);
        return redirect()->route('admin.q_a.index',['course_id'=>$request->get('course_id'),'page'=>$page])->withFlashSuccess('Q&A Information saved!');
    }

    public function destroy($id){
        $courseId = (int)\Request::get('course_id');
        $page = (int)\Request::get('page',1);
        $qaObj = QuestionsAnswers::where('id','=',$id)->where("course_id",'=',$courseId)->first();
        if(!empty($qaObj)){
            $qaObj->status = 0;
            // $qaObj->save();
            $qaObj->delete();
            return redirect()->route('admin.q_a.index',['course_id'=>$courseId,'page'=>$page])->withFlashSuccess('Q&A Deleted Successfully');
        }
        return redirect()->route('admin.courses')->withFlashDanger('Course Id is Invalid#1');
    }
    
}
