<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Auth\User;
use App\Models\Auth\ReferralCommission;
use App\Models\MailTemplates;
use App\Notifications\Backend\UserAlert;
use App\Repositories\Backend\Auth\UserRepository;
use Log;

class ReferralController extends Controller
{

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('student referral'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }
            return $next($request);
        });
    }

    // public function referral_rewards()
    // {
    //     $reffs = DB::select("select * from referral_commission order by created_at desc");
    //     return view('backend.referrals.referral-rewards', ["reffs" => $reffs]);
    // }

    public function referral_payout(){
        if(!env('STUDENT_REFERRAL_ENABLE')){
            return redirect()->route('admin.dashboard.message')->withFlashDanger('Student Referral is disabled.');
        }
        
        $reffs = DB::select("select * from referral_commission where paid=0 AND debit>0 order by created_at desc");
        return view('backend.referrals.referral-payout', ["reffs" => $reffs]);
    }

    public function getReferrals(Request $request)
    {
        $columns = array(
            0 => 'id',
            1 => 'created_at',
            2 => 'first_name',
        );
        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');
        $month = $request->input('month');
    
        $get_search = $request->input('search.value');

            $referrals = DB::table('referral_commission')
                ->join('users as referer_info', 'referer_info.id', '=', 'referral_commission.user_id')
                ->select(DB::raw("concat(referer_info.first_name,' ',referer_info.last_name) as ref_full_name, referer_info.id as rid, sum(credit) as total_reward"), 'referral_commission.*')
                ->when(!empty($month), function ($query) use ($month) {
                    $month = explode("-", $month);
                    $year = $month[0];
                    $month = $month[1];
                    $query->whereYear('referral_commission.created_at', '=', $year)
                    ->whereMonth('referral_commission.created_at', '=', $month);
                    return  $query;
                })
                ->where('referral_commission.paid',0)
                //->distinct('referral_commission.student_id')
                ->offset($start)
                ->limit($limit)
                ->groupBy('referral_commission.user_id')
                ->orderBy($order, $dir)
                ->get();

            $totalData = $totalFiltered = count($referrals);
            
        $payment_count = DB::table('referral_commission')
            ->when(!empty($month), function ($query) use ($month) {
                // $month = explode("-", $month);
                // $year = $month[0];
                // $month = $month[1];
                // $query->whereYear('referral_commission.created_at', '=', $year)
                // ->whereMonth('referral_commission.created_at', '=', $month);
                $query->where('referral_commission.payout_month',$month);
                return  $query;
            })
            ->where('paid',1)
            ->count();
        if($payment_count > 0){
            $payment_status = true;
        }else{
            $payment_status = false;
        }

        $data = $customResult = array();
        if (!empty($referrals)) {
            $count = 1;
            foreach ($referrals as $reffs) {
                $customResult['id'] = $reffs->id;
                $customResult['referer'] = "<b>".$reffs->ref_full_name."</b><p>ID: ".$reffs->rid."</p>";
                $customResult['payment_mode'] = get_user_payment_mode($reffs->rid);
                $customResult['payment_details'] = nl2br(get_user_payment_details($reffs->rid));
                $customResult['no_of_reffs'] = get_referrals_count($reffs->rid,$month);
                $customResult['reward'] = config('app.currency_symbol')." ".$reffs->total_reward;
                $data[] = $customResult;
            }
        }
        $json_data = array(
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $data,
            'payment_status' => $payment_status
        );
        return json_encode($json_data);
    }

    public function referral_signups(){
        if(!env('STUDENT_REFERRAL_ENABLE')){
            return redirect()->route('admin.dashboard.message')->withFlashDanger('Student Referral is disabled.');
        }
        // $users = DB::select("select u.id as uid, concat(u.first_name,' ',u.last_name) as full_name, u.email, u.mobile, u.ref_status, u.created_at, concat(r.first_name,' ',r.last_name) as refered_by, r.id as rid from users u inner join users r on r.id=u.ref_by, u left join referral_commission c on c.user_id=u.ref_by order by u.created_at desc");

        $users = User::join('users as referer_info', 'referer_info.id', '=', 'users.ref_by')
        ->select("users.id as uid", DB::raw("concat(users.first_name,' ',users.last_name) as user_full_name"),"users.ref_status","users.created_at", DB::raw("concat(referer_info.first_name,' ',referer_info.last_name) as referred_by"), "referer_info.id as rid" , "referral_commission.credit as commission")
        //->leftjoin('referral_commission', 'referral_commission.student_id','=','users.id')
        ->leftJoin('referral_commission',function ($join) {
            $join->on('referral_commission.student_id', '=' , 'users.id') ;
            $join->where('referral_commission.paid',0);
        })
        ->orderBy('users.created_at','desc')
        ->get();

        return view('backend.referrals.referral-signups', ["users" => $users]);
    }

    public function confirmedAmountModel($id){
        return view('backend.referrals.confirmed_modal', compact('id'));
    }

    public function referral_status_update(Request $request){
        $request->all([
            'amount' => 'required|numeric'
        ]);

        $id = $request->user_id;
        $user = User::where('id', $id)->first();
        $reffRwd = $request->amount;

        $chk_comm = ReferralCommission::where('user_id',$user->ref_by)->where('student_id', $user->id)->first();
        if($chk_comm){
            $chk_comm->credit = $reffRwd;
            $chk_comm->save();
        }else{
            $commission = new ReferralCommission;
            $commission->user_id = $user->ref_by;
            $commission->student_id = $user->id;
            $commission->credit = $reffRwd;
            $commission->notes = "Referral Reward Credited";
            $commission->save();
        }
        
        return redirect()->route('admin.referral-signups')->withFlashSuccess("Commission Amount updated!");
       
    }

    public function referral_make_payout(Request $request)
    {
        $request->all([
            'month' => 'required'
        ]);
        
        $month_input = $request->input('month');
        $month_exploded = explode("-", $month_input);
        $year = $month_exploded[0];
        $month = $month_exploded[1];
        $payment_count = DB::table('referral_commission')
            // ->whereYear('referral_commission.created_at', '=', $year)
            // ->whereMonth('referral_commission.created_at', '=', $month)
            ->where('referral_commission.payout_month',$month_input)
            ->where('paid',1)
            ->count();
        if($payment_count > 0){
            return redirect()->route('admin.referral-payout')->withFlashDanger("Payout already processed for this month.!");
        }

        $commissions = ReferralCommission::whereYear('referral_commission.created_at', '=', $year)
        ->whereMonth('referral_commission.created_at', '=', $month)
        ->get();
        if(count($commissions)){
            foreach($commissions as $comms){
                $payout = new ReferralCommission;
                $payout->user_id = $comms->user_id;
                $payout->debit = $comms->credit;
                $payout->student_id = $comms->student_id;
                $payout->paid = 1;
                $payout->payout_month = $month_input;
                $payout->paid_at = now();
                $payout->payment_notes = "Payment for ".date("F", mktime(0, 0, 0, $month, 10)).' '.$year;
                $payout->save();

                //Notify referer
                $user = (new UserRepository())->where('id', $comms->user_id)->first();
                $mail_tpl = MailTemplates::find("STUDENT_REFERRAL_PAYOUT");
                $email_message = $mail_tpl->message;                     
                $email_message = str_ireplace("#sitename#", app_name(), $email_message);
                $email_message = str_ireplace("#siteurl#", url(''), $email_message);
                $email_message = str_ireplace("#first_name#", $user->first_name, $email_message);
                $email_message = str_ireplace("#full_name#", $user->full_name, $email_message);
                $email_message = str_ireplace("#month_year#", date("F", mktime(0, 0, 0, $month, 10)).' '.$year, $email_message);
                if ($mail_tpl && $mail_tpl->status) {
                    try{
                        user_notify($user,$mail_tpl->subject, $email_message);
                    }catch (\Exception $e) {
                        $message = $e->getMessage();
                        \Log::debug("Mail Error: (Commission make payout - Notify User) ".$message);   
                    }
                }
            }
        }
        // $Referer = User::find($rwrd->user_id);
        // //send email to referer
        // \Log::debug("Rewards: sending mail to referer (debit transaction is marked as paid)");
        // $mail_tpl = MailTemplates::find("STUDENT_REFERRAL_PAYOUT");
        // if ($mail_tpl && $mail_tpl->status) {
        //     $email_message = $mail_tpl->message;
        //     $email_message = str_ireplace("#sitename#", app_name(), $email_message);
        //     $email_message = str_ireplace("#siteurl#", url(''), $email_message);
        //     $email_message = str_ireplace("#first_name#", $Referer->first_name, $email_message);
        //     $email_message = str_ireplace("#full_name#", $Referer->full_name, $email_message);
        //     $email_message = str_ireplace("#referer#", $Referer->first_name, $email_message);
        //     $email_message = str_ireplace("#refamt#", $rwrd->credit, $email_message);
        //     $email_message = str_ireplace("#notes#", $rwrd->payment_notes, $email_message);
        //     try {
        //         $Referer->notify(new UserAlert($mail_tpl->subject, $email_message));
        //     } catch (\Exception $e) {
        //         $message = $e->getMessage();
        //         \Log::debug("Mail Error: (STUDENT_REFERRAL_PAYOUT)" . $message);
        //     }
        // }
        return redirect()->route('admin.referral-payout')->withFlashSuccess("Payout Added Successfully!");
    }

    // public function referral_payout_report()
    // {
    //     $pages = DB::select("select * from referral_reward where paid=1 AND debit!=0 order by created_at desc");

    //     return view('backend.referrals.referral-payout-report', ['pages' => $pages]);
    // }
}
