<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\SMSTemplates;
use Illuminate\Http\Request;


class SMSTemplatesController extends Controller
{

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('mail templates'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }
            return $next($request);
        });
    }

    public function index()
    {
        // $templates = SMSTemplates::orderByDesc('created_at')->get();
        $templates = SMSTemplates::orderByDesc('created_at')->get();
        return view('backend.sms_templates.index', compact('templates'));
    }


    public function create()
    {
        $variables = "sitename,siteurl,first_name,full_name";
        return view('backend.sms_templates.create', compact('variables'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  Page $template
     * @return view
     */
    public function edit($id)
    {
        $template = SMSTemplates::where('hook', '=', $id)->first();
        return view('backend.sms_templates.edit', compact('template'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'hook' => 'required|max:50|unique:sms_templates',
            'message' => 'required|max:320',
        ]);

        $sms_tpl = SMSTemplates::create([
            'hook' => $request->get('hook'),
            'template_id' => $request->get('template_id'),
            'message' => $request->get('message'),
            'status' => 1,
            'variables' => 'sitename,siteurl,first_name,full_name'
        ]);
        return redirect()->route('admin.smstemplates')->withFlashSuccess('SMS Template Created Successfully!');
    }


    public function update(Request $request, $id)
    {
        $request->validate([
            'message' => 'required|max:320',
        ]);

        $sms_tpl = SMSTemplates::findOrFail($id);
        $sms_tpl->template_id = $request->get('template_id');
        $sms_tpl->message = $request->get('message');
        $sms_tpl->save();
        return redirect()->route('admin.smstemplates')->withFlashSuccess('SMS Template Updated!');
    }

    public function changeStatus($hook, $status) {
        $sms_tpl = SMSTemplates::findOrFail($hook);
        $sms_tpl->status = $status;
        $sms_tpl->save();
        return redirect()->route('admin.smstemplates')->withFlashSuccess('SMS Template Updated!');
    }

    public function destroy($id)
    {
        $sms_tpl = SMSTemplates::findOrFail($id);
        if ($sms_tpl->system_tpl) {
            return redirect()->back()->withFlashDanger('This template cannot be deleted');
        }
        $sms_tpl->delete();
        return redirect()->back()->withFlashSuccess('Template deleted successfully');
    }

    public function ajaxgetsmstpl(Request $request) {
        if (!$request->ajax()) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this page.');
        }
        $sms_tpl = SMSTemplates::findOrFail($request->hook);
        echo json_encode($sms_tpl);
    }
}
