<?php

namespace App\Http\Controllers\Backend;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Auth\User;
use App\Models\Auth\ApplicationStages;
use App\Models\Auth\ServiceStages;
use Illuminate\Http\Request;
use Log;

class ServiceStagesController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $stages = DB::table('service_stages')->OrderBy('stage_order','asc')->OrderBy('service_id','asc')->get();
        $services = DB::table('services')->OrderBy('service_name')->get();
        return view('backend.settings.service_stages', compact('stages','services'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'service' => 'required',
            'name' => 'required',
            'color' => 'required',
        ]);

        $status_name = $request->name;
        $service = $request->service;
        $stage_type = $request->stage_type;
        
        if($stage_type && $stage_type == "default"){
            //check for default status
            $chk_def = ServiceStages::where('service_id',$service)->where('default_stage',1)->first();
            if($chk_def){
                return redirect()->route('admin.settings.service-stages')->withFlashDanger('Default stage is already present for the service "'.get_services($service).'"');
            }
            $default = 1;
            $case_close = 0;
        }
        else if($stage_type && $stage_type == "case_close"){
            //check for case close status
            $chk_ccs = ServiceStages::where('service_id',$service)->where('case_close_stage',1)->first();
            if($chk_ccs){
                return redirect()->route('admin.settings.service-stages')->withFlashDanger('Case Close stage is already present for the service "'.get_services($service).'"');
            }
            $default = 0;
            $case_close = 1;
        }else{
            $default = 0;
            $case_close = 0;
        }
        $stage_order = $request->stage_order;
        $color = $request->color;

        DB::table('service_stages')->insert(["status_name" => $status_name, "service_id" => $service, "default_stage"=> $default, "case_close_stage"=> $case_close, "stage_order" => $stage_order, "color" => $color] );

        return redirect()->route("admin.settings.service-stages")->withFlashSuccess("Service Stage Added!");
    }

    public function update(Request $request, $id)
    {
        $stage = ServiceStages::findOrFail($id);
        $request->validate([
            'service' => 'required',
            'name' => 'required',
            'color' => 'required',
        ]);
       
        $stage->status_name = $request->name;
        $stage->service_id = $request->service;

        $stage_type = $request->stage_type;
        if($stage_type && $stage_type == "default"){
            //check for default status
            $chk_def = ServiceStages::where('service_id',$request->service)->where('default_stage',1)->first();
            if($chk_def){
                return redirect()->route('admin.settings.service-stages')->withFlashDanger('Default stage is already present for the service "'.get_services($request->service).'"');
            }
            $default = 1;
            $case_close = 0;
        }
        else if($stage_type && $stage_type == "case_close"){
             //check for case close status
             $chk_ccs = ServiceStages::where('service_id',$request->service)->where('case_close_stage',1)->first();
             if($chk_ccs){
                 return redirect()->route('admin.settings.service-stages')->withFlashDanger('Case Close stage is already present for the service "'.get_services($request->service).'"');
             }
            $default = 0;
            $case_close = 1;
        }else{
            $default = 0;
            $case_close = 0;
        }
        $stage->default_stage = $default;
        $stage->case_close_stage = $case_close;

        $stage->stage_order = $request->stage_order;
        $stage->color = $request->color;
        $stage->save();

        return redirect()->route("admin.settings.service-stages")->withFlashSuccess("Service Stage Updated!");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $stage = ServiceStages::findOrFail($id);
        if ($stage->default_stage) {
            return redirect()->route("admin.settings.service-stages")->withFlashDanger("Default stage cannot be deleted!");
        }
        else if ($stage->case_close_stage) {
            return redirect()->route("admin.settings.service-stages")->withFlashDanger("Case Close stage cannot be deleted!");
        }
        $stage->delete();
        return redirect()->route("admin.settings.service-stages")->withFlashSuccess("Service Stage Deleted!");
    }
}
