<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Auth\User;
use App\Models\Auth\LeadStatus;
use App\Models\Banners;
use App\Models\Configs;
use App\Models\Auth\Posts;
use App\Models\ContentBlocks;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\Auth\CountryStudy;
use App\Models\Auth\UniApplyAgents;
use App\Repositories\Backend\Auth\UserRepository;
use Illuminate\Support\Arr;
use App\Models\MailTemplates;
use App\Mail\MailSend;
use Illuminate\Support\Facades\Mail;
use App\Models\Auth\City;
use App\Models\Auth\State;
use Illuminate\Support\Facades\File;

/**
 * Class SettingsController.
 */
class SettingsController extends Controller
{

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('settings'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }
            return $next($request);
        });
    }

    public function index()
    {
        $content_pages = Posts::where('type', 'content_page')->where('status', 1)->select('id', 'title')->get();
        $branches = DB::table('branch')->get();
        return view('backend.settings', compact('content_pages','branches'));
    }

    public function saveGeneral(Request $request)
    {

        $request->validate([
            'app_name' => 'required',
            'website_logo_file' => 'mimes:jpg,jpeg,gif,png,svg|max:500',
            'website_sticky_logo_file' => 'mimes:jpg,jpeg,gif,png,svg|max:500',
            'backend_logo_file' => 'mimes:jpg,jpeg,gif,png,svg|max:500',
            'email_logo_file' => 'mimes:jpg,jpeg,gif,png,svg|max:500',
            'favicon_file' => 'mimes:png,svg|max:200',
            'website_logo_ht' => 'required|numeric',
            'website_sticky_logo_ht' => 'required|numeric',
            'backend_logo_ht' => 'required|numeric',
            'email_logo_ht' => 'required|numeric',
        ]);

        set_site_config('app_name', $request->input('app_name'));
        set_site_config('website_logo_ht', $request->input('website_logo_ht'));
        set_site_config('website_sticky_logo_ht', $request->input('website_sticky_logo_ht'));
        set_site_config('backend_logo_ht', $request->input('backend_logo_ht'));
        set_site_config('email_logo_ht', $request->input('email_logo_ht'));

        set_site_config('contact_phone', $request->input('contact_phone'));
        set_site_config('contact_email', $request->input('contact_email'));

        set_site_config('frontend_theme', $request->input('frontend_theme'));

        if ($request->hasFile('website_logo_file')) {
            $file = $request->website_logo_file->getClientOriginalName();
            $filename = pathinfo($file, PATHINFO_FILENAME);
            if (strlen($filename) > 125)
                $filename = substr($filename, 0, 125);

            $filename = str_replace(' ','_',$filename) . '_' . rand(10000, 99999) . "." . $request->website_logo_file->getClientOriginalExtension();
            $website_logo = $request->file('website_logo_file')->storeAs('/logo', $filename, 'public');
            set_site_config('website_logo', $website_logo);
        }

        if ($request->hasFile('website_sticky_logo_file')) {
            $file = $request->website_sticky_logo_file->getClientOriginalName();
            $filename = pathinfo($file, PATHINFO_FILENAME);
            if (strlen($filename) > 125)
                $filename = substr($filename, 0, 125);

            $filename = str_replace(' ','_',$filename) . '_sticky_' . rand(10000, 99999) . "." . $request->website_sticky_logo_file->getClientOriginalExtension();
            $website_sticky_logo = $request->file('website_sticky_logo_file')->storeAs('/logo', $filename, 'public');
            set_site_config('website_sticky_logo', $website_sticky_logo);
        }

        if ($request->hasFile('backend_logo_file')) {
            $file = $request->backend_logo_file->getClientOriginalName();
            $filename = pathinfo($file, PATHINFO_FILENAME);
            if (strlen($filename) > 125)
                $filename = substr($filename, 0, 125);

            $filename = str_replace(' ','_',$filename) . '_backend_' . rand(10000, 99999) . "." . $request->backend_logo_file->getClientOriginalExtension();
            $backend_logo = $request->file('backend_logo_file')->storeAs('/logo', $filename, 'public');
            set_site_config('backend_logo', $backend_logo);
        }

        if ($request->hasFile('email_logo_file')) {
            $file = $request->email_logo_file->getClientOriginalName();
            $filename = pathinfo($file, PATHINFO_FILENAME);
            if (strlen($filename) > 125)
                $filename = substr($filename, 0, 125);

            $filename = str_replace(' ','_',$filename) . '_email_' . rand(10000, 99999) . "." . $request->email_logo_file->getClientOriginalExtension();
            $email_logo = $request->file('email_logo_file')->storeAs('/logo', $filename, 'public');
            set_site_config('email_logo', $email_logo);
        }

        if ($request->hasFile('favicon_file')) {
            $filename = 'favicon_' . rand(10000, 99999) . "." . $request->favicon_file->getClientOriginalExtension();
            $favicon = $request->file('favicon_file')->storeAs('/logo', $filename, 'public');
            set_site_config('favicon', $favicon);
        }

        return redirect()->route('admin.settings')->withFlashSuccess('Settings saved successfully');
    }


    public function saveHome(Request $request)
    {
        if ($request->input('home_page_slider_enabled'))
            set_site_config('home_page_slider_enabled', 1);
        else
            set_site_config('home_page_slider_enabled', 0);

        if ($request->input('home_page_coaching_courses_enabled'))
            set_site_config('home_page_coaching_courses_enabled', 1);
        else
            set_site_config('home_page_coaching_courses_enabled', 0);

        if ($request->input('home_page_online_courses_enabled'))
            set_site_config('home_page_online_courses_enabled', 1);
        else
            set_site_config('home_page_online_courses_enabled', 0);

        if ($request->input('home_page_countryinfo_enabled'))
            set_site_config('home_page_countryinfo_enabled', 1);
        else
            set_site_config('home_page_countryinfo_enabled', 0);



        if ($request->input('home_page_student_signup'))
            set_site_config('home_page_student_signup', 1);
        else
            set_site_config('home_page_student_signup', 0);


        if ($request->input('home_page_agent_signup'))
            set_site_config('home_page_agent_signup', 1);
        else
            set_site_config('home_page_agent_signup', 0);


        if ($request->input('home_page_staff_login'))
            set_site_config('home_page_staff_login', 1);
        else
            set_site_config('home_page_staff_login', 0);

        return redirect()->route('admin.settings')->withFlashSuccess('Settings saved successfully');
    }

    public function saveModules(Request $request)
    {

        if ($request->input('module_coaching_classes'))
            set_site_config('module_coaching_classes', 1);
        else
            set_site_config('module_coaching_classes', 0);

        if ($request->input('module_online_courses'))
            set_site_config('module_online_courses', 1);
        else
            set_site_config('module_online_courses', 0);

        if ($request->input('module_shop'))
            set_site_config('module_shop', 1);
        else
            set_site_config('module_shop', 0);

        if ($request->input('module_course_purchase'))
            set_site_config('module_course_purchase', 1);
        else
            set_site_config('module_course_purchase', 0);

        if ($request->input('module_helpdesk'))
            set_site_config('module_helpdesk', 1);
        else
            set_site_config('module_helpdesk', 0);

        if ($request->input('module_resources'))
            set_site_config('module_resources', 1);
        else
            set_site_config('module_resources', 0);

        if ($request->input('module_webinar'))
            set_site_config('module_webinar', 1);
        else
            set_site_config('module_webinar', 0);

        if ($request->input('agent_module_webinar'))
            set_site_config('agent_module_webinar', 1);
        else
            set_site_config('agent_module_webinar', 0);

        if ($request->input('module_student_referral'))
            set_site_config('module_student_referral', 1);
        else
            set_site_config('module_student_referral', 0);

        if ($request->input('module_sop'))
            set_site_config('module_sop', 1);
        else
            set_site_config('module_sop', 0);

        if ($request->input('module_membermenu_allcoaching'))
            set_site_config('module_membermenu_allcoaching', 1);
        else
            set_site_config('module_membermenu_allcoaching', 0);

        if ($request->input('module_membermenu_allonlinecourses'))
            set_site_config('module_membermenu_allonlinecourses', 1);
        else
            set_site_config('module_membermenu_allonlinecourses', 0);

        if ($request->input('module_mycertificate'))
            set_site_config('module_mycertificate', 1);
        else
            set_site_config('module_mycertificate', 0);

        if ($request->input('module_democlasses'))
            set_site_config('module_democlasses', 1);
        else
            set_site_config('module_democlasses', 0);

        if ($request->input('module_country_info'))
            set_site_config('module_country_info', 1);
        else
            set_site_config('module_country_info', 0);

        if ($request->input('module_course_suggestion'))
            set_site_config('module_course_suggestion', 1);
        else
            set_site_config('module_course_suggestion', 0);

        if ($request->input('academic_details_in_profile'))
            set_site_config('academic_details_in_profile', 1);
        else
            set_site_config('academic_details_in_profile', 0);

        if ($request->input('university_course_finder'))
            set_site_config('university_course_finder', 1);
        else
            set_site_config('university_course_finder', 0);

        if ($request->input('payment_stripe'))
            set_site_config('payment_stripe', 1);
        else
            set_site_config('payment_stripe', 0);

        if ($request->input('payment_paypal'))
            set_site_config('payment_paypal', 1);
        else
            set_site_config('payment_paypal', 0);

        if ($request->input('payment_razorpay'))
            set_site_config('payment_razorpay', 1);
        else
            set_site_config('payment_razorpay', 0);

        if ($request->input('payment_bank'))
            set_site_config('payment_bank', 1);
        else
            set_site_config('payment_bank', 0);

        if ($request->input('lang_en'))
            set_site_config('lang_en', 1);
        else
            set_site_config('lang_en', 0);

        if ($request->input('lang_fr'))
            set_site_config('lang_fr', 1);
        else
            set_site_config('lang_fr', 0);

        if ($request->input('lang_it'))
            set_site_config('lang_it', 1);
        else
            set_site_config('lang_it', 0);

        if ($request->input('lang_es'))
            set_site_config('lang_es', 1);
        else
            set_site_config('lang_es', 0);

        if ($request->input('cookie_consent_banner'))
            set_site_config('cookie_consent_banner', 1);
        else
            set_site_config('cookie_consent_banner', 0);

        if ($request->input('student_agent_terminate_account'))
            set_site_config('student_agent_terminate_account', 1);
        else
            set_site_config('student_agent_terminate_account', 0);

        if ($request->input('privacy_policy'))
            set_site_config('privacy_policy', 1);
        else
            set_site_config('privacy_policy', 0);

        if ($request->input('term_of_service'))
            set_site_config('term_of_service', 1);
        else
            set_site_config('term_of_service', 0);

        if (!($request->input('lang_es') && $request->input('lang_fr') && $request->input('lang_it') && $request->input('lang_es')))
            set_site_config('lang_en', 1);

        return redirect()->route('admin.settings')->withFlashSuccess('Settings saved successfully');
    }

    public function integrations(Request $request){
        $credentialsPath = base_path('storage/app/google-sheet/credentials.json');
        $fileExists = File::exists($credentialsPath);

        return view('backend.settings.integrations', ['fileExists' => $fileExists]);
    }

    public function course_certificate_configuration(Request $request)
    {
        return view('backend.settings.course-certificate-configuration');
    }

    public function save_course_certificate_configuration(Request $request)
    {

        $request->validate([
            'certificate_business_name' => 'required',
            'certificate_logo_file' => 'mimes:jpg,jpeg,gif,png,svg|max:200',
            'certificate_sign_file' => 'mimes:jpg,jpeg,gif,png,svg|max:200',
            'certificate_logo_ht' => 'required|numeric',
            'certificate_sign_ht' => 'required|numeric',
        ]);

        set_site_config('certificate_business_name', $request->input('certificate_business_name'));
        set_site_config('certificate_logo_ht', $request->input('certificate_logo_ht'));
        set_site_config('certificate_sign_ht', $request->input('certificate_sign_ht'));
    
        if ($request->hasFile('certificate_logo_file')) {
            $file = $request->certificate_logo_file->getClientOriginalName();
            $filename = pathinfo($file, PATHINFO_FILENAME);
            if (strlen($filename) > 125)
                $filename = substr($filename, 0, 125);

            $filename = $filename . 'company_logo_' . rand(10000, 99999) . "." . $request->certificate_logo_file->getClientOriginalExtension();
            $certificate_logo = $request->file('certificate_logo_file')->storeAs('/cert_template', $filename, 'public');
            set_site_config('certificate_logo', $certificate_logo);
        }

        if ($request->hasFile('certificate_sign_file')) {
            $file = $request->certificate_sign_file->getClientOriginalName();
            $filename = pathinfo($file, PATHINFO_FILENAME);
            if (strlen($filename) > 125)
                $filename = substr($filename, 0, 125);

            $filename = $filename . '_certi_' . rand(10000, 99999) . "." . $request->certificate_sign_file->getClientOriginalExtension();
            $certificate_sign = $request->file('certificate_sign_file')->storeAs('/cert_template', $filename, 'public');
            set_site_config('certificate_sign', $certificate_sign);
        }
        return redirect()->route('admin.settings')->withFlashSuccess('Settings saved successfully');
    }

    public function outbound_call(Request $request)
    {
        return view('backend.settings.outbound_call');
    }

    public function save_outbound_call(Request $request)
    {
        if ($request->input('outbound_call_enabled'))
            set_site_config('outbound_call_enabled', 1);
        else
            set_site_config('outbound_call_enabled', 0);

        if ($request->input('outbound_call_provider'))
            set_site_config('outbound_call_provider', $request->input('outbound_call_provider'));
        else
            set_site_config('outbound_call_provider', '');

    //Zadarma
        if ($request->input('zadarma_api_key'))
            set_site_config('zadarma_api_key', $request->input('zadarma_api_key'));
        else
            set_site_config('zadarma_api_key', '');

        if ($request->input('zadarma_api_secret'))
            set_site_config('zadarma_api_secret', $request->input('zadarma_api_secret'));
        else
            set_site_config('zadarma_api_secret', '');

        if ($request->input('zadarma_agent_number'))
            set_site_config('zadarma_agent_number', $request->input('zadarma_agent_number'));
        else
            set_site_config('zadarma_agent_number', '');
    //Zadarma
    //Exotel
        if ($request->input('exotel_api_key'))
            set_site_config('exotel_api_key', $request->input('exotel_api_key'));
        else
            set_site_config('exotel_api_key', '');

        if ($request->input('exotel_api_secret'))
            set_site_config('exotel_api_secret', $request->input('exotel_api_secret'));
        else
            set_site_config('exotel_api_secret', '');

        if ($request->input('exotel_agent_number'))
            set_site_config('exotel_agent_number', $request->input('exotel_agent_number'));
        else
            set_site_config('exotel_agent_number', '');
        
        if ($request->input('exotel_sid'))
            set_site_config('exotel_sid', $request->input('exotel_sid'));
        else
            set_site_config('exotel_sid', '');
    //Exotel
        return redirect()->route('admin.settings.outbound-call')->withFlashSuccess('Outbound Call Settings saved successfully');
    }



    public function whatsapp(Request $request)
    {
        return view('backend.settings.whatsapp');
    }

    public function save_whatsapp(Request $request)
    {
        if ($request->input('whatsapp_enabled')) {
            $provider = $request->input('whatsapp_provider');

            if ($provider === 'wati' &&
                (empty($request->input('wati_api_endpoint')) || empty($request->input('wati_token')))) {
                return redirect()->route('admin.settings.whatsapp')->withFlashDanger('Please fill Wati settings');
            }

            if ($provider === 'aisensy' &&
                empty($request->input('aisensy_api_key'))) {
                return redirect()->route('admin.settings.whatsapp')->withFlashDanger('Please fill Aisensy API Key');
            }

            if ($provider === 'whatsapp_cloud_api' &&
                (empty($request->input('whatsapp_phone_number_id')) || empty($request->input('whatsapp_cloud_access_token')))) {
                return redirect()->route('admin.settings.whatsapp')->withFlashDanger('Please fill WhatsApp Cloud API settings');
            }
        }


        if ($request->input('whatsapp_enabled'))
            set_site_config('whatsapp_enabled', 1);
        else
            set_site_config('whatsapp_enabled', 0);

        if ($request->input('whatsapp_provider'))
            set_site_config('whatsapp_provider', $request->input('whatsapp_provider'));
        else
            set_site_config('whatsapp_provider', '');

        // Wati
        if ($request->input('wati_api_endpoint'))
            set_site_config('wati_api_endpoint', $request->input('wati_api_endpoint'));
        else
            set_site_config('wati_api_endpoint', '');
        
        if ($request->input('wati_token'))
            set_site_config('wati_token', $request->input('wati_token'));
        else
            set_site_config('wati_token', '');

        // Aisensy
        if ($request->input('aisensy_api_key'))
            set_site_config('aisensy_api_key', $request->input('aisensy_api_key'));
        else
            set_site_config('aisensy_api_key', '');

        // WhatsApp Cloud API
        if ($request->input('whatsapp_phone_number_id'))
            set_site_config('whatsapp_phone_number_id', $request->input('whatsapp_phone_number_id'));
        else
            set_site_config('whatsapp_phone_number_id', '');
        
        if ($request->input('whatsapp_cloud_access_token'))
            set_site_config('whatsapp_cloud_access_token', $request->input('whatsapp_cloud_access_token'));
        else
            set_site_config('whatsapp_cloud_access_token', '');

        return redirect()->route('admin.settings.whatsapp')->withFlashSuccess('Whatsapp Settings saved successfully');
    }






    public function sms(Request $request)
    {
        return view('backend.settings.sms_gateway');
    }

    public function emailSmtp(Request $request)
    {
        return view('backend.settings.email_smtp');
    }


    public function saveSms(Request $request)
    {
        // dd($request->all());

        if ($request->input('sms_enabled'))
            set_site_config('sms_enabled', 1);
        else
            set_site_config('sms_enabled', 0);

        if (
            empty($request->input('twilio_sms_senderid')) &&
            empty($request->input('twilio_sms_auth_token')) &&
            empty($request->input('sms_from_phone')) &&
            empty($request->input('textlocal_sms_senderid')) &&
            empty($request->input('textlocal_sms_auth_token')) &&
            empty($request->input('msg91_sms_senderid')) &&
            empty($request->input('msg91_sms_auth_token')) &&
            empty($request->input('sms_flow_id')) &&
            empty($request->input('gupshup_sms_senderid')) &&
            empty($request->input('voodoo_sms_senderid')) &&
            empty($request->input('voodoo_sms_auth_token')) &&
            empty($request->input('fast2sms_sms_senderid')) &&
            empty($request->input('fast2sms_sms_auth_token')) &&
            empty($request->input('sms_api_url'))
        ) {
            return redirect()->route('admin.settings.sms');
        }
    

        if ($request->input('sms_provider'))
            set_site_config('sms_provider', $request->input('sms_provider'));
        else
            set_site_config('sms_provider', '');


        //sender Id
        if ($request->input('sms_provider') == "Twilio" && $request->input('twilio_sms_senderid')){
            set_site_config('sms_senderid', $request->input('twilio_sms_senderid'));
        }
        else if($request->input('sms_provider') == "Textlocal" && $request->input('textlocal_sms_senderid')){
            set_site_config('sms_senderid', $request->input('textlocal_sms_senderid'));
        }
        else if($request->input('sms_provider') == "Msg91" && $request->input('msg91_sms_senderid')){
            set_site_config('sms_senderid', $request->input('msg91_sms_senderid'));
        }

        else if($request->input('sms_provider') == "Gupshup" && $request->input('gupshup_sms_senderid')){
            set_site_config('sms_senderid', $request->input('gupshup_sms_senderid'));
        }
        else if($request->input('sms_provider') == "Voodoo" && $request->input('voodoo_sms_senderid')){
            set_site_config('sms_senderid', $request->input('voodoo_sms_senderid'));
        }
        else if($request->input('sms_provider') == "Fast2sms" && $request->input('fast2sms_sms_senderid')){
            set_site_config('sms_senderid', $request->input('fast2sms_sms_senderid'));
        }
        else{
            set_site_config('sms_senderid', '');
        }
        //sender Id


        if ($request->input('sms_provider') == "Twilio" && $request->input('twilio_sms_auth_token')){
            set_site_config('sms_auth_token', $request->input('twilio_sms_auth_token'));
        }
        else if ($request->input('sms_provider') == "Textlocal" && $request->input('textlocal_sms_auth_token')){
            set_site_config('sms_auth_token', $request->input('textlocal_sms_auth_token'));
        }
        else if ($request->input('sms_provider') == "Msg91" && $request->input('msg91_sms_auth_token')){
            set_site_config('sms_auth_token', $request->input('msg91_sms_auth_token'));
        }
        else if ($request->input('sms_provider') == "Gupshup" && $request->input('gupshup_sms_auth_token')){
            set_site_config('sms_auth_token', $request->input('gupshup_sms_auth_token'));
        }
        else if ($request->input('sms_provider') == "Voodoo" && $request->input('voodoo_sms_auth_token')){
            set_site_config('sms_auth_token', $request->input('voodoo_sms_auth_token'));
        }
        else if ($request->input('sms_provider') == "Fast2sms" && $request->input('fast2sms_sms_auth_token')){
            set_site_config('sms_auth_token', $request->input('fast2sms_sms_auth_token'));
        }
        else{
            set_site_config('sms_auth_token', '');
        }



        if ($request->input('sms_from_phone'))
            set_site_config('sms_from_phone', $request->input('sms_from_phone'));
        else
            set_site_config('sms_from_phone', '');

        if ($request->input('sms_flow_id'))
            set_site_config('sms_flow_id', $request->input('sms_flow_id'));
        else
            set_site_config('sms_flow_id', '');

        if ($request->input('sms_api_url'))
            set_site_config('sms_api_url', $request->input('sms_api_url'));
        else
            set_site_config('sms_api_url', '');

        return redirect()->route('admin.settings.sms')->withFlashSuccess('SMS Settings saved successfully');
    }


    public function saveGoogle(Request $request)
    {
        if ($request->input('google_lead_webhook_key'))
            set_site_config('google_lead_webhook_key', $request->input('google_lead_webhook_key'));
        else
            set_site_config('google_lead_webhook_key', '');
   
        return redirect()->route('admin.integrations')->withFlashSuccess('Google Leads Webhook Key saved successfully');
    }

    public function webToLead(Request $request)
    {
        $web_lead_enabled = get_site_config('web_lead_enabled');
        $web_lead_form_name = get_site_config('web_lead_form_name');
        $web_lead_redirect_url = get_site_config('web_lead_redirect_url');
        $web_lead_assign_to = get_site_config('web_lead_assign_to');

        $web_lead_assign_to_branch = get_site_config('web_lead_assign_to_branch');

        $web_lead_first_name_enabled = get_site_config('web_lead_first_name_enabled');
        $web_lead_last_name_enabled = get_site_config('web_lead_last_name_enabled');

        $web_lead_gender_enabled = get_site_config('web_lead_gender_enabled');
        $web_lead_alternate_contact_enabled = get_site_config('web_lead_alternate_contact_enabled');
        $web_lead_country_of_citizenship_enabled = get_site_config('web_lead_country_of_citizenship_enabled');
        $web_lead_country_pref_enabled = get_site_config('web_lead_country_pref_enabled');
        $web_lead_dob_enabled = get_site_config('web_lead_dob_enabled');
        $web_lead_accommodation_enabled = get_site_config('web_lead_accommodation_enabled');
        $web_lead_study_permit_enabled = get_site_config('web_lead_study_permit_enabled');
        $web_lead_course_interested_enabled = get_site_config('web_lead_course_interested_enabled');
        $web_lead_qualification_enabled = get_site_config('web_lead_qualification_enabled');
        $web_lead_intake_enabled = get_site_config('web_lead_intake_enabled');
        $web_lead_study_level_enabled = get_site_config('web_lead_study_level_enabled');

        $web_lead_passout_year_enabled = get_site_config('web_lead_passout_year_enabled');
        $web_lead_score_enabled = get_site_config('web_lead_score_enabled');

        $web_lead_current_course_enabled = get_site_config('web_lead_current_course_enabled');
        $web_lead_email_enabled = get_site_config('web_lead_email_enabled');
        $web_lead_mobile_enabled = get_site_config('web_lead_mobile_enabled');
        $web_lead_whatsapp_enabled = get_site_config('web_lead_whatsapp_enabled');
        $web_lead_city_enabled = get_site_config('web_lead_city_enabled');
        $userRepo = new UserRepository();
        $staff = $userRepo->getNonStudentsTrainers();
        $branches = DB::table('branch')->get();

        $html_code = '';
        if ($web_lead_enabled == 1) {

            $html_code .= "\n<form name='web_lead_client' action='" . route('web-to-lead-tracking') . "' method='POST'>";
            $html_code .= "\n<input type='hidden' name='wl_staff' value='$web_lead_assign_to'>";
            $html_code .= "\n<input type='hidden' name='wl_redirect_url' value='$web_lead_redirect_url'>";
            $html_code .= "\n<input type='hidden' name='wl_staff_branch' value='$web_lead_assign_to_branch'>";
            $html_code .= "\n<input type='hidden' name='wl_form_name' value='$web_lead_form_name'>";
            $html_code .= "\n<table cellspacing='1' cellpadding='5'>";
            if (!$web_lead_last_name_enabled) {
                $html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label for='wl_first_name' class='form-label'>Name*</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n<input type='text' name='wl_first_name' id='wl_first_name' class='form-control' placeholder='Your name' required>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
            } else {
                $html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label for='wl_first_name' class='form-label'>Firstname*</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n<input type='text' name='wl_first_name' id='wl_first_name' class='form-control' placeholder='First name' required>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
            }
            // $html_code .= "\n</div>";

            if ($web_lead_last_name_enabled) {
                $html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label for='wl_last_name' class='form-label'>Lastname</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n<input type='text' name='wl_last_name' id='wl_last_name' class='form-control' placeholder='Last name'>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
            }

            if ($web_lead_gender_enabled) {
                $html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label for='wl_gender' class='form-label'>Gender</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n<select name='wl_gender' id='wl_gender' class='form-control'>";
                $html_code .= "\n<option value=''>Select</option>";
                $html_code .= "\n<option value='Male'>Male</option>";
                $html_code .= "\n<option value='Female'>Female</option>";
                $html_code .= "\n</select>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
            }

            if($web_lead_email_enabled=='1' ){
            $req_email= $req_email_star = "";
            if(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email' || get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_and_mobile') {
                $req_email="required"; 
                $req_email_star = "*";
            }
            $html_code .= "\n<tr>";
            $html_code .= "\n<td>";
            $html_code .= "\n<label for='wl_email' class='form-label'>Email$req_email_star</label>";
            $html_code .= "\n</td>";
            $html_code .= "\n<td>";
            $html_code .= "\n<input type='email' name='wl_email' id='wl_email' class='form-control' placeholder='Your email' $req_email>";
            $html_code .= "\n</td>";
            $html_code .= "\n</tr>";
            }

            if ($web_lead_mobile_enabled) {
                $req_mob= $req_mob_star = "";
                if(get_site_config('lead_create_web2lead_api_import_mandatory') == 'mobile' || get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_and_mobile') {
                    $req_mob="required"; 
                    $req_mob_star = "*";
                }
                $html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label for='wl_dialcode' class='form-label'>Mobile No.$req_mob_star</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n" . '<select class="form-select form-control" name="wl_dialcode" id="wl_dialcode" '.$req_mob.'>
                            <option value="">Dialcode</option>
                            <option value="1">1</option>
                            <option value="7">7</option>
                            <option value="20">20</option>
                            <option value="27">27</option>
                            <option value="30">30</option>
                            <option value="31">31</option>
                            <option value="32">32</option>
                            <option value="33">33</option>
                            <option value="34">34</option>
                            <option value="36">36</option>
                            <option value="38">38</option>
                            <option value="39">39</option>
                            <option value="40">40</option>
                            <option value="41">41</option>
                            <option value="43">43</option>
                            <option value="44">44</option>
                            <option value="45">45</option>
                            <option value="46">46</option>
                            <option value="47">47</option>
                            <option value="48">48</option>
                            <option value="49">49</option>
                            <option value="51">51</option>
                            <option value="52">52</option>
                            <option value="53">53</option>
                            <option value="54">54</option>
                            <option value="55">55</option>
                            <option value="56">56</option>
                            <option value="57">57</option>
                            <option value="58">58</option>
                            <option value="60">60</option>
                            <option value="61">61</option>
                            <option value="62">62</option>
                            <option value="63">63</option>
                            <option value="64">64</option>
                            <option value="65">65</option>
                            <option value="66">66</option>
                            <option value="70">70</option>
                            <option value="81">81</option>
                            <option value="82">82</option>
                            <option value="84">84</option>
                            <option value="86">86</option>
                            <option value="90">90</option>
                            <option value="91">91</option>
                            <option value="92">92</option>
                            <option value="93">93</option>
                            <option value="94">94</option>
                            <option value="95">95</option>
                            <option value="98">98</option>
                            <option value="211">211</option>
                            <option value="212">212</option>
                            <option value="213">213</option>
                            <option value="216">216</option>
                            <option value="218">218</option>
                            <option value="220">220</option>
                            <option value="221">221</option>
                            <option value="222">222</option>
                            <option value="223">223</option>
                            <option value="224">224</option>
                            <option value="225">225</option>
                            <option value="226">226</option>
                            <option value="227">227</option>
                            <option value="228">228</option>
                            <option value="229">229</option>
                            <option value="230">230</option>
                            <option value="231">231</option>
                            <option value="232">232</option>
                            <option value="233">233</option>
                            <option value="234">234</option>
                            <option value="235">235</option>
                            <option value="236">236</option>
                            <option value="237">237</option>
                            <option value="238">238</option>
                            <option value="239">239</option>
                            <option value="240">240</option>
                            <option value="241">241</option>
                            <option value="242">242</option>
                            <option value="244">244</option>
                            <option value="245">245</option>
                            <option value="246">246</option>
                            <option value="248">248</option>
                            <option value="249">249</option>
                            <option value="250">250</option>
                            <option value="251">251</option>
                            <option value="252">252</option>
                            <option value="253">253</option>
                            <option value="254">254</option>
                            <option value="255">255</option>
                            <option value="256">256</option>
                            <option value="257">257</option>
                            <option value="258">258</option>
                            <option value="260">260</option>
                            <option value="261">261</option>
                            <option value="262">262</option>
                            <option value="263">263</option>
                            <option value="264">264</option>
                            <option value="265">265</option>
                            <option value="266">266</option>
                            <option value="267">267</option>
                            <option value="268">268</option>
                            <option value="269">269</option>
                            <option value="290">290</option>
                            <option value="291">291</option>
                            <option value="297">297</option>
                            <option value="298">298</option>
                            <option value="299">299</option>
                            <option value="350">350</option>
                            <option value="351">351</option>
                            <option value="352">352</option>
                            <option value="353">353</option>
                            <option value="354">354</option>
                            <option value="355">355</option>
                            <option value="356">356</option>
                            <option value="357">357</option>
                            <option value="358">358</option>
                            <option value="359">359</option>
                            <option value="370">370</option>
                            <option value="371">371</option>
                            <option value="372">372</option>
                            <option value="373">373</option>
                            <option value="374">374</option>
                            <option value="375">375</option>
                            <option value="376">376</option>
                            <option value="377">377</option>
                            <option value="378">378</option>
                            <option value="380">380</option>
                            <option value="381">381</option>
                            <option value="385">385</option>
                            <option value="386">386</option>
                            <option value="387">387</option>
                            <option value="389">389</option>
                            <option value="420">420</option>
                            <option value="421">421</option>
                            <option value="423">423</option>
                            <option value="500">500</option>
                            <option value="501">501</option>
                            <option value="502">502</option>
                            <option value="503">503</option>
                            <option value="504">504</option>
                            <option value="505">505</option>
                            <option value="506">506</option>
                            <option value="507">507</option>
                            <option value="508">508</option>
                            <option value="509">509</option>
                            <option value="590">590</option>
                            <option value="591">591</option>
                            <option value="592">592</option>
                            <option value="593">593</option>
                            <option value="594">594</option>
                            <option value="595">595</option>
                            <option value="596">596</option>
                            <option value="597">597</option>
                            <option value="598">598</option>
                            <option value="599">599</option>
                            <option value="670">670</option>
                            <option value="672">672</option>
                            <option value="673">673</option>
                            <option value="674">674</option>
                            <option value="675">675</option>
                            <option value="676">676</option>
                            <option value="677">677</option>
                            <option value="678">678</option>
                            <option value="679">679</option>
                            <option value="680">680</option>
                            <option value="681">681</option>
                            <option value="682">682</option>
                            <option value="683">683</option>
                            <option value="684">684</option>
                            <option value="686">686</option>
                            <option value="687">687</option>
                            <option value="688">688</option>
                            <option value="689">689</option>
                            <option value="690">690</option>
                            <option value="691">691</option>
                            <option value="692">692</option>
                            <option value="850">850</option>
                            <option value="852">852</option>
                            <option value="853">853</option>
                            <option value="855">855</option>
                            <option value="856">856</option>
                            <option value="880">880</option>
                            <option value="886">886</option>
                            <option value="960">960</option>
                            <option value="961">961</option>
                            <option value="962">962</option>
                            <option value="963">963</option>
                            <option value="964">964</option>
                            <option value="965">965</option>
                            <option value="966">966</option>
                            <option value="967">967</option>
                            <option value="968">968</option>
                            <option value="970">970</option>
                            <option value="971">971</option>
                            <option value="972">972</option>
                            <option value="973">973</option>
                            <option value="974">974</option>
                            <option value="975">975</option>
                            <option value="976">976</option>
                            <option value="977">977</option>
                            <option value="992">992</option>
                            <option value="994">994</option>
                            <option value="995">995</option>
                            <option value="996">996</option>
                            <option value="998">998</option>
                            <option value="1242">1242</option>
                            <option value="1246">1246</option>
                            <option value="1264">1264</option>
                            <option value="1268">1268</option>
                            <option value="1284">1284</option>
                            <option value="1340">1340</option>
                            <option value="1345">1345</option>
                            <option value="1441">1441</option>
                            <option value="1473">1473</option>
                            <option value="1649">1649</option>
                            <option value="1664">1664</option>
                            <option value="1670">1670</option>
                            <option value="1671">1671</option>
                            <option value="1684">1684</option>
                            <option value="1758">1758</option>
                            <option value="1767">1767</option>
                            <option value="1784">1784</option>
                            <option value="1787">1787</option>
                            <option value="1809">1809</option>
                            <option value="1868">1868</option>
                            <option value="1869">1869</option>
                            <option value="1876">1876</option>
                            <option value="7370">7370</option>
                            </select>';
                // $html_code .= "\n</td>";
                // $html_code .= "\n</tr >";
                // $html_code .= "\n<tr >";
                // $html_code .= "\n<td>";
                // $html_code .= "\n<label for='wl_mobile' class='form-label'>Mobile No.</label>";
                // $html_code .= "\n</td>";
                // $html_code .= "\n<td >";
                $mobMinLength= "minlength='".config('app.USER_MOBILE_MIN_LENGTH')."'";
                $mobMaxLength= "maxlength='".config('app.USER_MOBILE_MAX_LENGTH')."'";
                $html_code .= "\n<input type='text' onkeypress='return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))' $mobMinLength $mobMaxLength name='wl_mobile' id='wl_mobile' class='form-control' placeholder='Mobile Number'>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
            }
            if ($web_lead_whatsapp_enabled) {
                $html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label for='wl_whatsapp_dialcode' class='form-label'>Whatsapp No.</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n" . '<select class="form-select form-control" name="wl_whatsapp_dialcode" id="wl_whatsapp_dialcode">
                            <option value="">Dialcode</option>
                            <option value="1">1</option>
                            <option value="7">7</option>
                            <option value="20">20</option>
                            <option value="27">27</option>
                            <option value="30">30</option>
                            <option value="31">31</option>
                            <option value="32">32</option>
                            <option value="33">33</option>
                            <option value="34">34</option>
                            <option value="36">36</option>
                            <option value="38">38</option>
                            <option value="39">39</option>
                            <option value="40">40</option>
                            <option value="41">41</option>
                            <option value="43">43</option>
                            <option value="44">44</option>
                            <option value="45">45</option>
                            <option value="46">46</option>
                            <option value="47">47</option>
                            <option value="48">48</option>
                            <option value="49">49</option>
                            <option value="51">51</option>
                            <option value="52">52</option>
                            <option value="53">53</option>
                            <option value="54">54</option>
                            <option value="55">55</option>
                            <option value="56">56</option>
                            <option value="57">57</option>
                            <option value="58">58</option>
                            <option value="60">60</option>
                            <option value="61">61</option>
                            <option value="62">62</option>
                            <option value="63">63</option>
                            <option value="64">64</option>
                            <option value="65">65</option>
                            <option value="66">66</option>
                            <option value="70">70</option>
                            <option value="81">81</option>
                            <option value="82">82</option>
                            <option value="84">84</option>
                            <option value="86">86</option>
                            <option value="90">90</option>
                            <option value="91">91</option>
                            <option value="92">92</option>
                            <option value="93">93</option>
                            <option value="94">94</option>
                            <option value="95">95</option>
                            <option value="98">98</option>
                            <option value="211">211</option>
                            <option value="212">212</option>
                            <option value="213">213</option>
                            <option value="216">216</option>
                            <option value="218">218</option>
                            <option value="220">220</option>
                            <option value="221">221</option>
                            <option value="222">222</option>
                            <option value="223">223</option>
                            <option value="224">224</option>
                            <option value="225">225</option>
                            <option value="226">226</option>
                            <option value="227">227</option>
                            <option value="228">228</option>
                            <option value="229">229</option>
                            <option value="230">230</option>
                            <option value="231">231</option>
                            <option value="232">232</option>
                            <option value="233">233</option>
                            <option value="234">234</option>
                            <option value="235">235</option>
                            <option value="236">236</option>
                            <option value="237">237</option>
                            <option value="238">238</option>
                            <option value="239">239</option>
                            <option value="240">240</option>
                            <option value="241">241</option>
                            <option value="242">242</option>
                            <option value="244">244</option>
                            <option value="245">245</option>
                            <option value="246">246</option>
                            <option value="248">248</option>
                            <option value="249">249</option>
                            <option value="250">250</option>
                            <option value="251">251</option>
                            <option value="252">252</option>
                            <option value="253">253</option>
                            <option value="254">254</option>
                            <option value="255">255</option>
                            <option value="256">256</option>
                            <option value="257">257</option>
                            <option value="258">258</option>
                            <option value="260">260</option>
                            <option value="261">261</option>
                            <option value="262">262</option>
                            <option value="263">263</option>
                            <option value="264">264</option>
                            <option value="265">265</option>
                            <option value="266">266</option>
                            <option value="267">267</option>
                            <option value="268">268</option>
                            <option value="269">269</option>
                            <option value="290">290</option>
                            <option value="291">291</option>
                            <option value="297">297</option>
                            <option value="298">298</option>
                            <option value="299">299</option>
                            <option value="350">350</option>
                            <option value="351">351</option>
                            <option value="352">352</option>
                            <option value="353">353</option>
                            <option value="354">354</option>
                            <option value="355">355</option>
                            <option value="356">356</option>
                            <option value="357">357</option>
                            <option value="358">358</option>
                            <option value="359">359</option>
                            <option value="370">370</option>
                            <option value="371">371</option>
                            <option value="372">372</option>
                            <option value="373">373</option>
                            <option value="374">374</option>
                            <option value="375">375</option>
                            <option value="376">376</option>
                            <option value="377">377</option>
                            <option value="378">378</option>
                            <option value="380">380</option>
                            <option value="381">381</option>
                            <option value="385">385</option>
                            <option value="386">386</option>
                            <option value="387">387</option>
                            <option value="389">389</option>
                            <option value="420">420</option>
                            <option value="421">421</option>
                            <option value="423">423</option>
                            <option value="500">500</option>
                            <option value="501">501</option>
                            <option value="502">502</option>
                            <option value="503">503</option>
                            <option value="504">504</option>
                            <option value="505">505</option>
                            <option value="506">506</option>
                            <option value="507">507</option>
                            <option value="508">508</option>
                            <option value="509">509</option>
                            <option value="590">590</option>
                            <option value="591">591</option>
                            <option value="592">592</option>
                            <option value="593">593</option>
                            <option value="594">594</option>
                            <option value="595">595</option>
                            <option value="596">596</option>
                            <option value="597">597</option>
                            <option value="598">598</option>
                            <option value="599">599</option>
                            <option value="670">670</option>
                            <option value="672">672</option>
                            <option value="673">673</option>
                            <option value="674">674</option>
                            <option value="675">675</option>
                            <option value="676">676</option>
                            <option value="677">677</option>
                            <option value="678">678</option>
                            <option value="679">679</option>
                            <option value="680">680</option>
                            <option value="681">681</option>
                            <option value="682">682</option>
                            <option value="683">683</option>
                            <option value="684">684</option>
                            <option value="686">686</option>
                            <option value="687">687</option>
                            <option value="688">688</option>
                            <option value="689">689</option>
                            <option value="690">690</option>
                            <option value="691">691</option>
                            <option value="692">692</option>
                            <option value="850">850</option>
                            <option value="852">852</option>
                            <option value="853">853</option>
                            <option value="855">855</option>
                            <option value="856">856</option>
                            <option value="880">880</option>
                            <option value="886">886</option>
                            <option value="960">960</option>
                            <option value="961">961</option>
                            <option value="962">962</option>
                            <option value="963">963</option>
                            <option value="964">964</option>
                            <option value="965">965</option>
                            <option value="966">966</option>
                            <option value="967">967</option>
                            <option value="968">968</option>
                            <option value="970">970</option>
                            <option value="971">971</option>
                            <option value="972">972</option>
                            <option value="973">973</option>
                            <option value="974">974</option>
                            <option value="975">975</option>
                            <option value="976">976</option>
                            <option value="977">977</option>
                            <option value="992">992</option>
                            <option value="994">994</option>
                            <option value="995">995</option>
                            <option value="996">996</option>
                            <option value="998">998</option>
                            <option value="1242">1242</option>
                            <option value="1246">1246</option>
                            <option value="1264">1264</option>
                            <option value="1268">1268</option>
                            <option value="1284">1284</option>
                            <option value="1340">1340</option>
                            <option value="1345">1345</option>
                            <option value="1441">1441</option>
                            <option value="1473">1473</option>
                            <option value="1649">1649</option>
                            <option value="1664">1664</option>
                            <option value="1670">1670</option>
                            <option value="1671">1671</option>
                            <option value="1684">1684</option>
                            <option value="1758">1758</option>
                            <option value="1767">1767</option>
                            <option value="1784">1784</option>
                            <option value="1787">1787</option>
                            <option value="1809">1809</option>
                            <option value="1868">1868</option>
                            <option value="1869">1869</option>
                            <option value="1876">1876</option>
                            <option value="7370">7370</option>
                            </select>';
                $mobMinLength= "minlength='".config('app.USER_MOBILE_MIN_LENGTH')."'";
                $mobMaxLength= "maxlength='".config('app.USER_MOBILE_MAX_LENGTH')."'";
                $html_code .= "\n<input type='text' onkeypress='return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))' $mobMinLength $mobMaxLength name='wl_whatsapp' id='wl_whatsapp' class='form-control' placeholder='Whatsapp Number'>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
            }
            if ($web_lead_alternate_contact_enabled) {
                $html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label for='wl_alt_contact' class='form-label'>Alternate Contact</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $mobMinLength= "minlength='".config('app.USER_MOBILE_MIN_LENGTH')."'";
                $mobMaxLength= "maxlength='".config('app.USER_MOBILE_MAX_LENGTH')."'";
                $html_code .= "\n<input type='text' name='wl_alt_contact' onkeypress='return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))' $mobMinLength $mobMaxLength id='wl_alt_contact' class='form-control' placeholder='Alternate Contact'>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
            }
            if ($web_lead_city_enabled) {
                $html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label for='wl_city' class='form-label'>City</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n<input type='text' name='wl_city' id='wl_city' class='form-control' placeholder='Enter City'>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
            }
            // if ($web_lead_location_enabled) {
            //     $html_code .= "\n<tr >";
            //     $html_code .= "\n<td>";
            //     $html_code .= "\n<label for='wl_location' class='form-label'>Present Location*</label>";
            //     $html_code .= "\n</td>";
            //     $html_code .= "\n<td >";
            //     $html_code .= "\n<select name='wl_location' id='wl_location' class='form-control' required>";
            //     $html_code .= "\n<option value=''>Select</option>";
            //     $html_code .= "\n<option value='Canada'>Canada</option>";
            //     $html_code .= "\n<option value='Outside Canada'>Outside Canada</option>";
            //     $html_code .= "\n</select>";
            //     $html_code .= "\n</td>";
            //     $html_code .= "\n</tr >";
            // }

            if ($web_lead_country_of_citizenship_enabled) {
                $html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label for='wl_country_of_citizenship' class='form-label'>Country of Citizenship</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n" . '<select class="form-select form-control" id="wl_country_of_citizenship" name="wl_country_of_citizenship">
                                    <option value="">Select</option>
                                    <option value="Afghanistan">Afghanistan</option>
                                    <option value="Albania">Albania</option>
                                    <option value="Algeria">Algeria</option>
                                    <option value="American Samoa">American Samoa</option>
                                    <option value="Andorra">Andorra</option>
                                    <option value="Angola">Angola</option>
                                    <option value="Anguilla">Anguilla</option>
                                    <option value="Antigua And Barbuda">Antigua And Barbuda</option>
                                    <option value="Argentina">Argentina</option>
                                    <option value="Armenia">Armenia</option>
                                    <option value="Aruba">Aruba</option>
                                    <option value="Australia">Australia</option>
                                    <option value="Austria">Austria</option>
                                    <option value="Azerbaijan">Azerbaijan</option>
                                    <option value="Bahamas The">Bahamas The</option>
                                    <option value="Bahrain">Bahrain</option>
                                    <option value="Bangladesh">Bangladesh</option>
                                    <option value="Barbados">Barbados</option>
                                    <option value="Belarus">Belarus</option>
                                    <option value="Belgium">Belgium</option>
                                    <option value="Belize">Belize</option>
                                    <option value="Benin">Benin</option>
                                    <option value="Bermuda">Bermuda</option>
                                    <option value="Bhutan">Bhutan</option>
                                    <option value="Bolivia">Bolivia</option>
                                    <option value="Bosnia and Herzegovina">Bosnia and Herzegovina</option>
                                    <option value="Botswana">Botswana</option>
                                    <option value="Brazil">Brazil</option>
                                    <option value="British Indian Ocean Territory">British Indian Ocean Territory</option>
                                    <option value="Brunei">Brunei</option>
                                    <option value="Bulgaria">Bulgaria</option>
                                    <option value="Burkina Faso">Burkina Faso</option>
                                    <option value="Burundi">Burundi</option>
                                    <option value="Cambodia">Cambodia</option>
                                    <option value="Cameroon">Cameroon</option>
                                    <option value="Canada">Canada</option>
                                    <option value="Cape Verde">Cape Verde</option>
                                    <option value="Cayman Islands">Cayman Islands</option>
                                    <option value="Central African Republic">Central African Republic</option>
                                    <option value="Chad">Chad</option>
                                    <option value="Chile">Chile</option>
                                    <option value="China">China</option>
                                    <option value="Christmas Island">Christmas Island</option>
                                    <option value="Cocos (Keeling) Islands">Cocos (Keeling) Islands</option>
                                    <option value="Colombia">Colombia</option>
                                    <option value="Comoros">Comoros</option>
                                    <option value="Republic Of The Congo">Republic Of The Congo</option>
                                    <option value="Democratic Republic Of The Congo">Democratic Republic Of The Congo</option>
                                    <option value="Cook Islands">Cook Islands</option>
                                    <option value="Costa Rica">Costa Rica</option>
                                    <option value="Cote D\'Ivoire (Ivory Coast)">Cote D\'Ivoire (Ivory Coast)</option>
                                    <option value="Croatia (Hrvatska)">Croatia (Hrvatska)</option>
                                    <option value="Cuba">Cuba</option>
                                    <option value="Cyprus">Cyprus</option>
                                    <option value="Czech Republic">Czech Republic</option>
                                    <option value="Denmark">Denmark</option>
                                    <option value="Djibouti">Djibouti</option>
                                    <option value="Dominica">Dominica</option>
                                    <option value="Dominican Republic">Dominican Republic</option>
                                    <option value="East Timor">East Timor</option>
                                    <option value="Ecuador">Ecuador</option>
                                    <option value="Egypt">Egypt</option>
                                    <option value="El Salvador">El Salvador</option>
                                    <option value="Equatorial Guinea">Equatorial Guinea</option>
                                    <option value="Eritrea">Eritrea</option>
                                    <option value="Estonia">Estonia</option>
                                    <option value="Ethiopia">Ethiopia</option>
                                    <option value="External Territories of Australia">External Territories of Australia</option>
                            <option value="Falkland Islands">Falkland Islands</option>
                            <option value="Faroe Islands">Faroe Islands</option>
                            <option value="Fiji Islands">Fiji Islands</option>
                            <option value="Finland">Finland</option>
                            <option value="France">France</option>
                            <option value="French Guiana">French Guiana</option>
                            <option value="French Polynesia">French Polynesia</option>
                            <option value="Gabon">Gabon</option>
                            <option value="Gambia The">Gambia The</option>
                            <option value="Georgia">Georgia</option>
                            <option value="Germany">Germany</option>
                            <option value="Ghana">Ghana</option>
                            <option value="Gibraltar">Gibraltar</option>
                            <option value="Greece">Greece</option>
                            <option value="Greenland">Greenland</option>
                            <option value="Grenada">Grenada</option>
                            <option value="Guadeloupe">Guadeloupe</option>
                            <option value="Guam">Guam</option>
                            <option value="Guatemala">Guatemala</option>
                            <option value="Guernsey and Alderney">Guernsey and Alderney</option>
                            <option value="Guinea">Guinea</option>
                            <option value="Guinea-Bissau">Guinea-Bissau</option>
                            <option value="Guyana">Guyana</option>
                            <option value="Haiti">Haiti</option>
                            <option value="Honduras">Honduras</option>
                            <option value="Hong Kong S.A.R.">Hong Kong S.A.R.</option>
                            <option value="Hungary">Hungary</option>
                            <option value="Iceland">Iceland</option>
                            <option value="India">India</option>
                            <option value="Indonesia">Indonesia</option>
                            <option value="Iran">Iran</option>
                            <option value="Iraq">Iraq</option>
                            <option value="Ireland">Ireland</option>
                            <option value="Israel">Israel</option>
                            <option value="Italy">Italy</option>
                            <option value="Jamaica">Jamaica</option>
                            <option value="Japan">Japan</option>
                            <option value="Jersey">Jersey</option>
                            <option value="Jordan">Jordan</option>
                            <option value="Kazakhstan">Kazakhstan</option>
                            <option value="Kenya">Kenya</option>
                            <option value="Kiribati">Kiribati</option>
                            <option value="Korea North">Korea North</option>
                            <option value="Korea South">Korea South</option>
                            <option value="Kuwait">Kuwait</option>
                            <option value="Kyrgyzstan">Kyrgyzstan</option>
                            <option value="Laos">Laos</option>
                            <option value="Latvia">Latvia</option>
                            <option value="Lebanon">Lebanon</option>
                            <option value="Lesotho">Lesotho</option>
                            <option value="Liberia">Liberia</option>
                            <option value="Libya">Libya</option>
                            <option value="Liechtenstein">Liechtenstein</option>
                            <option value="Lithuania">Lithuania</option>
                            <option value="Luxembourg">Luxembourg</option>
                            <option value="Macau S.A.R.">Macau S.A.R.</option>
                            <option value="Macedonia">Macedonia</option>
                            <option value="Madagascar">Madagascar</option>
                            <option value="Malawi">Malawi</option>
                            <option value="Malaysia">Malaysia</option>
                            <option value="Maldives">Maldives</option>
                            <option value="Mali">Mali</option>
                            <option value="Malta">Malta</option>
                            <option value="Man (Isle of)">Man (Isle of)</option>
                            <option value="Marshall Islands">Marshall Islands</option>
                            <option value="Martinique">Martinique</option>
                            <option value="Mauritania">Mauritania</option>
                            <option value="Mauritius">Mauritius</option>
                            <option value="Mayotte">Mayotte</option>
                            <option value="Mexico">Mexico</option>
                            <option value="Micronesia">Micronesia</option>
                            <option value="Moldova">Moldova</option>
                            <option value="Monaco">Monaco</option>
                            <option value="Mongolia">Mongolia</option>
                            <option value="Montserrat">Montserrat</option>
                            <option value="Morocco">Morocco</option>
                            <option value="Mozambique">Mozambique</option>
                            <option value="Myanmar">Myanmar</option>
                            <option value="Namibia">Namibia</option>
                            <option value="Nauru">Nauru</option>
                            <option value="Nepal">Nepal</option>
                            <option value="Netherlands Antilles">Netherlands Antilles</option>
                            <option value="Netherlands The">Netherlands The</option>
                            <option value="New Caledonia">New Caledonia</option>
                            <option value="New Zealand">New Zealand</option>
                            <option value="Nicaragua">Nicaragua</option>
                            <option value="Niger">Niger</option>
                            <option value="Nigeria">Nigeria</option>
                            <option value="Niue">Niue</option>
                            <option value="Norfolk Island">Norfolk Island</option>
                            <option value="Northern Mariana Islands">Northern Mariana Islands</option>
                            <option value="Norway">Norway</option>
                            <option value="Oman">Oman</option>
                            <option value="Pakistan">Pakistan</option>
                            <option value="Palau">Palau</option>
                            <option value="Palestinian Territory Occupied">Palestinian Territory Occupied</option>
                            <option value="Panama">Panama</option>
                            <option value="Papua new Guinea">Papua new Guinea</option>
                            <option value="Paraguay">Paraguay</option>
                            <option value="Peru">Peru</option>
                            <option value="Philippines">Philippines</option>
                            <option value="Poland">Poland</option>
                            <option value="Portugal">Portugal</option>
                            <option value="Puerto Rico">Puerto Rico</option>
                            <option value="Qatar">Qatar</option>
                            <option value="Reunion">Reunion</option>
                            <option value="Romania">Romania</option>
                            <option value="Russia">Russia</option>
                            <option value="Rwanda">Rwanda</option>
                            <option value="Saint Helena">Saint Helena</option>
                            <option value="Saint Kitts And Nevis">Saint Kitts And Nevis</option>
                            <option value="Saint Lucia">Saint Lucia</option>
                            <option value="Saint Pierre and Miquelon">Saint Pierre and Miquelon</option>
                            <option value="Saint Vincent And The Grenadines">Saint Vincent And The Grenadines</option>
                            <option value="Samoa">Samoa</option>
                            <option value="San Marino">San Marino</option>
                            <option value="Sao Tome and Principe">Sao Tome and Principe</option>
                            <option value="Saudi Arabia">Saudi Arabia</option>
                            <option value="Senegal">Senegal</option>
                            <option value="Serbia">Serbia</option>
                            <option value="Seychelles">Seychelles</option>
                            <option value="Sierra Leone">Sierra Leone</option>
                            <option value="Singapore">Singapore</option>
                            <option value="Slovakia">Slovakia</option>
                            <option value="Slovenia">Slovenia</option>
                            <option value="Smaller Territories of the UK">Smaller Territories of the UK</option>
                            <option value="Solomon Islands">Solomon Islands</option>
                            <option value="Somalia">Somalia</option>
                            <option value="South Africa">South Africa</option>
                            <option value="South Sudan">South Sudan</option>
                            <option value="Spain">Spain</option>
                            <option value="Sri Lanka">Sri Lanka</option>
                            <option value="Sudan">Sudan</option>
                            <option value="Suriname">Suriname</option>
                            <option value="Svalbard And Jan Mayen Islands">Svalbard And Jan Mayen Islands</option>
                            <option value="Swaziland">Swaziland</option>
                            <option value="Sweden">Sweden</option>
                            <option value="Switzerland">Switzerland</option>
                            <option value="Syria">Syria</option>
                            <option value="Taiwan">Taiwan</option>
                            <option value="Tajikistan">Tajikistan</option>
                            <option value="Tanzania">Tanzania</option>
                            <option value="Thailand">Thailand</option>
                            <option value="Togo">Togo</option>
                            <option value="Tokelau">Tokelau</option>
                            <option value="Tonga">Tonga</option>
                            <option value="Trinidad And Tobago">Trinidad And Tobago</option>
                            <option value="Tunisia">Tunisia</option>
                            <option value="Turkey">Turkey</option>
                            <option value="Turkmenistan">Turkmenistan</option>
                            <option value="Turks And Caicos Islands">Turks And Caicos Islands</option>
                            <option value="Tuvalu">Tuvalu</option>
                            <option value="Uganda">Uganda</option>
                            <option value="Ukraine">Ukraine</option>
                            <option value="United Arab Emirates">United Arab Emirates</option>
                            <option value="United Kingdom">United Kingdom</option>
                            <option value="United States">United States</option>
                            <option value="Uruguay">Uruguay</option>
                            <option value="Uzbekistan">Uzbekistan</option>
                            <option value="Vanuatu">Vanuatu</option>
                            <option value="Venezuela">Venezuela</option>
                            <option value="Vietnam">Vietnam</option>
                            <option value="Virgin Islands (British)">Virgin Islands (British)</option>
                            <option value="Virgin Islands (US)">Virgin Islands (US)</option>
                            <option value="Wallis And Futuna Islands">Wallis And Futuna Islands</option>
                            <option value="Western Sahara">Western Sahara</option>
                            <option value="Yemen">Yemen</option>
                            <option value="Yugoslavia">Yugoslavia</option>
                            <option value="Zambia">Zambia</option>
                            <option value="Zimbabwe">Zimbabwe</option>
                        </select>';
                        $html_code .= "\n</td>";
                        $html_code .= "\n</tr >";
            }
            
            
            if ($web_lead_dob_enabled) {
                $html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label for='wl_dob' class='form-label'>Date of Birth</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n<input type='date' name='wl_dob' id='wl_dob' class='form-control' placeholder='dd-mm-yyyy'>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
            }

            if ($web_lead_current_course_enabled) {
                $html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label for='wl_current_course' class='form-label'>Currently Studying Course</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n<input type='text' name='wl_current_course' id='wl_current_course' class='form-control' placeholder='Currently Studying Course'>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
            }

            if ($web_lead_study_level_enabled) {
                $html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label for='wl_study_level' class='form-label'>Interested Study Level</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n" . "<select class='form-select form-control' id='wl_study_level' name='wl_study_level'>";
                $html_code .= "\n" . "<option value=''>Select Study Level</option>";
                foreach (get_study_levels() as $key => $value) {
                    $html_code .= "\n" . "<option value='$key'>" . $value . "</option>";
                }
                $html_code .= "\n</select>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
            }
            if ($web_lead_course_interested_enabled) {
                $html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label for='wl_course_interested' class='form-label'>Course Interested to Study</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n<input type='text' name='wl_course_interested' id='wl_course_interested' class='form-control' placeholder='Course Interested to Study'>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
            }
            if ($web_lead_intake_enabled) {
                $html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label for='wl_intake' class='form-label'>Intake</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n<select name='wl_intake' class='form-select form-control'>
                        <option value=''>Intake</option>";
                        $month = date('n');
                        for ($x = 0; $x < 24; $x++) {
                            $intk_val=date('m Y', mktime(0, 0, 0, $month + $x, 1));
                            $html_code .= "<option value='$intk_val'>";
                            $html_code .= date('F Y', mktime(0, 0, 0, $month + $x, 1));
                             }
                $html_code .= "</option></select>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
            }
            if ($web_lead_country_pref_enabled) {
                $countries = CountryStudy::where('status', 1)->orderBy('country', 'ASC')->get();
                $html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label for='wl_country_pref' class='form-label'>Country Interested to Study In</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n" . "<select class='form-select from-control' id='wl_country_pref' name='wl_country_pref'>";
                $html_code .= "\n" . "<option value=''>Select Country</option>";
                foreach ($countries as $country) {
                    $html_code .= "\n" . "<option  value='$country->country'>" . $country->country . "</option>";
                }
                $html_code .= "\n</select>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
            }
            if ($web_lead_qualification_enabled) {
                $html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label for='wl_qualification' class='form-label'>Qualification</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n" . "<select class='form-select from-control' id='wl_qualification' name='wl_qualification'>";
                $html_code .= "\n" . "<option value=''>Select Qualification</option>
                <option value='9th'>9th</option>
                <option value='10th'>10th</option>
                <option value='11th'>11th</option>
                <option value='12th'>12th</option>
                <option value='Bachelors'>Bachelors</option>
                <option value='Masters'>Masters</option>
                <option value='Ph.D'>Ph.D</option>";
                $html_code .= "\n</select>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
            }
            if ($web_lead_passout_year_enabled) {
                $html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label for='wl_lead_passout_year' class='form-label'>Passout Year</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n<input type='number' name='wl_lead_passout_year' id='wl_lead_passout_year' class='form-control' placeholder='Passout Year'>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
            }
            if ($web_lead_score_enabled) {
                $html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label for='wl_score' class='form-label'>Score/Grade</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n<input type='text' name='wl_score' id='wl_score' class='form-control' placeholder='Score/Grade'>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
            }
            if ($web_lead_accommodation_enabled) {
                $html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label for='wl_accommodation' class='form-label'>Require Accommodation</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n" . "<select class='form-select form-control' id='wl_accommodation' name='wl_accommodation'>";
                $html_code .= "\n" . "<option value=''>Select</option>";
                $html_code .= "\n" . "<option value='1'>Yes</option>";
                $html_code .= "\n" . "<option value='0'>No</option>";
                $html_code .= "\n</select>";
            }
            if ($web_lead_study_permit_enabled) {
                $html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label for='wl_study_permit' class='form-label'>Require Study Permit</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n" . "<select class='form-select form-control' id='wl_study_permit' name='wl_study_permit'>";
                $html_code .= "\n" . "<option value=''>Select</option>";
                $html_code .= "\n" . "<option value='1'>Yes</option>";
                $html_code .= "\n" . "<option value='0'>No</option>";
                $html_code .= "\n</select>";
            }
            //Checking custom attributes
            $custom_attributes = DB::table('custom_attributes')->where('web_to_lead',1)->orderBy('display_order','asc')->get(["custom_attributes.*"]);
            if(count($custom_attributes)){
                foreach($custom_attributes as $custom_attribute){
                    if($custom_attribute->for_lead_mandatory){
                        $red = "*";
                        $mandate = "required";
                    }else{
                        $red="";
                        $mandate = "";
                    }

                    if($custom_attribute->type == 'input'){
                        $datePicker = $min = $max = $yearValidation = $minLength = $maxLength = $phoneValidation = '';
                        if($custom_attribute->input_datatype == 'number' || $custom_attribute->input_datatype == 'decimal')
                        {
                            $inputType='number';
                        }
                        elseif($custom_attribute->input_datatype == 'date' || $custom_attribute->input_datatype == 'year' || $custom_attribute->input_datatype == 'phone'){
                            $inputType='text';
                        }else{
                            $inputType = $custom_attribute->input_datatype;
                        }
                        if($custom_attribute->input_datatype == 'decimal')
                        {
                            $step = 'any';
                        }
                        else{
                            $step = '';
                        }
                        if($custom_attribute->input_datatype == 'number' || $custom_attribute->input_datatype == 'decimal'){
                            $min= $custom_attribute->input_min;
                            $max=$custom_attribute->input_max;
                        }
                        elseif($custom_attribute->input_datatype == 'date'){
                            $datePicker ='mydatepicker';
                        }
                        elseif($custom_attribute->input_datatype == 'year'){
                            $yearValidation = "onkeypress='return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))'"; 
                            $minLength='4'; 
                            $maxLength='4';
                        }
                        elseif($custom_attribute->input_datatype == 'phone'){
                            $phoneValidation = "onkeypress='return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 58) || event.charCode==32 || event.charCode==44 || event.charCode==43 || event.charCode==45 || event.charCode==40 || event.charCode==41)'";
                            $minLength='10'; 
                            $maxLength='18';
                        }
                        else{
                            $minLength=$custom_attribute->input_min;
                            $maxLength=$custom_attribute->input_max;
                        }
                        if(isset($attrData[$custom_attribute->attr_name])){
                            $val = $attrData[$custom_attribute->attr_name];
                        }else{
                            $val = old('$custom_attribute->attr_name');
                        }
            
                        $html_code .= "\n<tr >";
                        $html_code .= "\n<td>";
                        $html_code .= "\n<label for='$custom_attribute->attr_name' class='form-label'>$custom_attribute->label $red</label>";
                        $html_code .= "\n</td>";
                        $html_code .= "\n<td >";
                        $html_code .= "<input type='$inputType' $step $min $max $yearValidation $phoneValidation $minLength $maxLength placeholder='$custom_attribute->placeholder' id='$custom_attribute->attr_name' autocomplete='off' class='form-control $datePicker' name='$custom_attribute->attr_name' value='$val' $mandate>";
                        $html_code .= "\n</td>";
                        $html_code .= "\n</tr >";
                    }
                    if($custom_attribute->type == 'textarea'){
                        $html_code .= "\n<tr >";
                        $html_code .= "\n<td>";
                        $html_code .= "\n<label for='$custom_attribute->attr_name' class='form-label'>$custom_attribute->label $red</label>";
                        $html_code .= "\n</td>";
                        $html_code .= "\n<td >";
                        $html_code .= "<textarea placeholder='$custom_attribute->placeholder' minLength='$custom_attribute->input_min' maxLength='$custom_attribute->input_max' class='form-control' name='$custom_attribute->attr_name' $mandate></textarea>";
                        $html_code .= "\n</td>";
                        $html_code .= "\n</tr >";
                    }
                    if($custom_attribute->type == 'select'){
                        $is_multi = $select2 = "";
                        $select_vals = explode('|',$custom_attribute->selection_values);
                        if($custom_attribute->select_multiple){
                            $is_multi = "multiple";
                            $select2 = "select2";
                        }
                        $html_code .= "\n<tr >";
                        $html_code .= "\n<td>";
                        $html_code .= "\n<label for='$custom_attribute->attr_name' class='form-label'>$custom_attribute->label $red</label>";
                        $html_code .= "\n</td>";
                        $html_code .= "\n<td >";
                        $html_code .= "<select placeholder='$custom_attribute->placeholder' class='form-select $select2' name='$custom_attribute->attr_name' $mandate $is_multi>";
                                        if(!$is_multi && $custom_attribute->placeholder){
                                            $html_code .= "<option value=''>$custom_attribute->placeholder</option>";
                                        }
                                        foreach($select_vals as $sel_val){
                                            $html_code .= "<option value='$sel_val'>$sel_val</option>";
                                        }
                        $html_code .= "</select>";
                        $html_code .= "\n</td>";
                        $html_code .= "\n</tr >";
                    }
                    if($custom_attribute->type == 'checkbox'){
                        $select_vals = explode('|',$custom_attribute->selection_values);
                        $html_code .= "\n<tr >";
                        $html_code .= "\n<td>";
                        $html_code .= "\n<label for='$custom_attribute->attr_name' class='form-label'>$custom_attribute->label $red</label>";
                        $html_code .= "\n<br><small>$custom_attribute->placeholder</small>";
                        $html_code .= "\n</td>";
                        $html_code .= "\n<td >";
                            foreach($select_vals as $sel_val){
                                $html_code .= "<label><input class='form-check-input ms-2 dyna_chkbx $custom_attribute->attr_name'";
                                if($mandate){
                                    $html_code .= " onclick='chk_mend(\"$custom_attribute->attr_name\")'";
                                } 
                                $html_code .= "type='checkbox' name='$custom_attribute->attr_name' value='$sel_val' $mandate> $sel_val</label>";
                        }
                        $html_code .= "\n</td>";
                        $html_code .= "\n</tr >";
                    }
                    if($custom_attribute->type == 'radio'){
                        $select_vals = explode('|',$custom_attribute->selection_values);
                        $html_code .= "\n<tr >";
                        $html_code .= "\n<td>";
                        $html_code .= "\n<label for='$custom_attribute->attr_name' class='form-label'>$custom_attribute->label $red</label>";
                        $html_code .= "\n<br><small>$custom_attribute->placeholder</small>";
                        $html_code .= "\n</td>";
                        $html_code .= "\n<td >";
                            foreach($select_vals as $sel_val){
                                $html_code .= "<label><input class='form-check-input ms-2 $custom_attribute->attr_name'";
                                if($mandate){
                                    $html_code .= " onclick='chk_mend(\"$custom_attribute->attr_name\")'";
                                } 
                                $html_code .= "type='radio' name='$custom_attribute->attr_name' value='$sel_val' $mandate> $sel_val</label>";
                        }
                        $html_code .= "\n</td>";
                        $html_code .= "\n</tr >";
                    }
                }
                $html_code .= "<script>
                        function chk_mend(elClass) {
                            el = document.getElementsByClassName(elClass);
                            var atLeastOneChecked = false;
                            for (i = 0; i < el.length; i++) {
                              if (el[i].checked === true) {
                                atLeastOneChecked = true;
                              }
                            }
                          
                            if (atLeastOneChecked === true) {
                              for (i = 0; i < el.length; i++) {
                                el[i].required = false;
                              }
                            } else {
                              for (i = 0; i < el.length; i++) {
                                el[i].required = true;
                              }
                            }
                          }
                        </script>";
            }
            //Checking custom attributes
            if(get_site_config('recaptcha_site_key')!="" && get_site_config('recaptcha_secret_key')!="" && get_site_config('web_to_lead_captcha')==1){
                $captchakey = get_site_config('recaptcha_site_key');
                $html_code .= "\n<tr >";
                $html_code .= "\n<td colspan='2'>";
                $html_code .= "\n<div class='g-recaptcha' data-sitekey='$captchakey'></div>";
                        if(isset($errors)){
                            if ($errors->has('g-recaptcha-response')){
                                $html_code .= "<span class='text-danger'>$errors->first(\"g-recaptcha-response\")</span>";
                            }
                        }
                $html_code .= "\n</td>";
                $html_code .= "\n</tr >";
            
            $html_code .= "\n<style>
                            #g-recaptcha-response {
                            display: block !important;
                            position: absolute;
                            margin: -78px 0 0 0 !important;
                            width: 302px !important;
                            height: 76px !important;
                            z-index: -999999;
                            opacity: 0;
                            }
                            </style>";
            $html_code .= "<script src='https://www.google.com/recaptcha/api.js' async defer></script>";
            $html_code .= "<script>
                window.addEventListener('load', () => {
                    const recaptcha = document.querySelector('#g-recaptcha-response');
                    if (recaptcha) {
                        recaptcha.setAttribute('required', 'required');
                    }
                })
            </script>";
            }

            $html_code .= "\n<tr >";
            $html_code .= "\n<td>";
            $html_code .= "\n<input type='submit' name='submit' class='btn btn-primary' value='Submit'>";
            $html_code .= "\n</td>";
            $html_code .= "\n</tr >";
            $html_code .= "\n</table>";
            $html_code .= "\n</form>";
        }



        // $html_code = '';
        // if ($web_lead_enabled == 1) {

        //     $html_code .= "\n<div class='p-5'>";
        //     $html_code .= "\n<form name='web_lead_client' action='" . route('web-to-lead-tracking') . "' method='POST'>";
        //     $html_code .= "\n<div class='mt-3'>";
        //     if (!$web_lead_last_name_enabled) {
        //         $html_code .= "\n<label for='wl_first_name' class='form-label'>Name*</label>";
        //         $html_code .= "\n<input type='text' name='wl_first_name' id='wl_first_name' class='form-control' placeholder='Your name' required>";
        //     } else {
        //         $html_code .= "\n<label for='wl_first_name' class='form-label'>Firstname*</label>";
        //         $html_code .= "\n<input type='text' name='wl_first_name' id='wl_first_name' class='form-control' placeholder='First name' required>";
        //     }
        //     $html_code .= "\n</div>";

        //     if ($web_lead_last_name_enabled) {
        //         $html_code .= "\n<div class='mt-3'>";
        //         $html_code .= "\n<label for='wl_last_name' class='form-label'>Lastname</label>";
        //         $html_code .= "\n<input type='text' name='wl_last_name' id='wl_last_name' class='form-control' placeholder='Last name'>";
        //         $html_code .= "\n</div>";
        //     }

        //     if ($web_lead_gender_enabled) {
        //         $html_code .= "\n<div class='mt-3'>";
        //         $html_code .= "\n<label for='wl_gender' class='form-label'>Gender</label>";
        //         $html_code .= "\n<select name='wl_gender' id='wl_gender' class='form-control'>";
        //         $html_code .= "\n<option value=''>Select</option>";
        //         $html_code .= "\n<option value='Male'>Male</option>";
        //         $html_code .= "\n<option value='Female'>Female</option>";
        //         $html_code .= "\n</select></div>";
        //     }

        //     $html_code .= "\n<div class='mt-3'>";
        //     $html_code .= "\n<label for='wl_email' class='form-label'>Email*</label>";
        //     $html_code .= "\n<input type='email' name='wl_email' id='wl_email' class='form-control' placeholder='Your email' required>";
        //     $html_code .= "\n</div>";

        //     if ($web_lead_mobile_enabled) {
        //         $html_code .= "\n<div class='row'>";
        //         $html_code .= "\n<div class='col-md-4 mt-3'>";
        //         $html_code .= "\n<label for='wl_dialcode' class='form-label'>Dialcode</label>";
        //         $html_code .= "\n" . '<select class="form-select form-control" name="wl_dialcode" id="wl_dialcode">
        //                     <option value="">Dialcode</option>
        //                     <option value="1">1</option>
        //                     <option value="7">7</option>
        //                     <option value="20">20</option>
        //                     <option value="27">27</option>
        //                     <option value="30">30</option>
        //                     <option value="31">31</option>
        //                     <option value="32">32</option>
        //                     <option value="33">33</option>
        //                     <option value="34">34</option>
        //                     <option value="36">36</option>
        //                     <option value="38">38</option>
        //                     <option value="39">39</option>
        //                     <option value="40">40</option>
        //                     <option value="41">41</option>
        //                     <option value="43">43</option>
        //                     <option value="44">44</option>
        //                     <option value="45">45</option>
        //                     <option value="46">46</option>
        //                     <option value="47">47</option>
        //                     <option value="48">48</option>
        //                     <option value="49">49</option>
        //                     <option value="51">51</option>
        //                     <option value="52">52</option>
        //                     <option value="53">53</option>
        //                     <option value="54">54</option>
        //                     <option value="55">55</option>
        //                     <option value="56">56</option>
        //                     <option value="57">57</option>
        //                     <option value="58">58</option>
        //                     <option value="60">60</option>
        //                     <option value="61">61</option>
        //                     <option value="62">62</option>
        //                     <option value="63">63</option>
        //                     <option value="64">64</option>
        //                     <option value="65">65</option>
        //                     <option value="66">66</option>
        //                     <option value="70">70</option>
        //                     <option value="81">81</option>
        //                     <option value="82">82</option>
        //                     <option value="84">84</option>
        //                     <option value="86">86</option>
        //                     <option value="90">90</option>
        //                     <option value="91">91</option>
        //                     <option value="92">92</option>
        //                     <option value="93">93</option>
        //                     <option value="94">94</option>
        //                     <option value="95">95</option>
        //                     <option value="98">98</option>
        //                     <option value="211">211</option>
        //                     <option value="212">212</option>
        //                     <option value="213">213</option>
        //                     <option value="216">216</option>
        //                     <option value="218">218</option>
        //                     <option value="220">220</option>
        //                     <option value="221">221</option>
        //                     <option value="222">222</option>
        //                     <option value="223">223</option>
        //                     <option value="224">224</option>
        //                     <option value="225">225</option>
        //                     <option value="226">226</option>
        //                     <option value="227">227</option>
        //                     <option value="228">228</option>
        //                     <option value="229">229</option>
        //                     <option value="230">230</option>
        //                     <option value="231">231</option>
        //                     <option value="232">232</option>
        //                     <option value="233">233</option>
        //                     <option value="234">234</option>
        //                     <option value="235">235</option>
        //                     <option value="236">236</option>
        //                     <option value="237">237</option>
        //                     <option value="238">238</option>
        //                     <option value="239">239</option>
        //                     <option value="240">240</option>
        //                     <option value="241">241</option>
        //                     <option value="242">242</option>
        //                     <option value="244">244</option>
        //                     <option value="245">245</option>
        //                     <option value="246">246</option>
        //                     <option value="248">248</option>
        //                     <option value="249">249</option>
        //                     <option value="250">250</option>
        //                     <option value="251">251</option>
        //                     <option value="252">252</option>
        //                     <option value="253">253</option>
        //                     <option value="254">254</option>
        //                     <option value="255">255</option>
        //                     <option value="256">256</option>
        //                     <option value="257">257</option>
        //                     <option value="258">258</option>
        //                     <option value="260">260</option>
        //                     <option value="261">261</option>
        //                     <option value="262">262</option>
        //                     <option value="263">263</option>
        //                     <option value="264">264</option>
        //                     <option value="265">265</option>
        //                     <option value="266">266</option>
        //                     <option value="267">267</option>
        //                     <option value="268">268</option>
        //                     <option value="269">269</option>
        //                     <option value="290">290</option>
        //                     <option value="291">291</option>
        //                     <option value="297">297</option>
        //                     <option value="298">298</option>
        //                     <option value="299">299</option>
        //                     <option value="350">350</option>
        //                     <option value="351">351</option>
        //                     <option value="352">352</option>
        //                     <option value="353">353</option>
        //                     <option value="354">354</option>
        //                     <option value="355">355</option>
        //                     <option value="356">356</option>
        //                     <option value="357">357</option>
        //                     <option value="358">358</option>
        //                     <option value="359">359</option>
        //                     <option value="370">370</option>
        //                     <option value="371">371</option>
        //                     <option value="372">372</option>
        //                     <option value="373">373</option>
        //                     <option value="374">374</option>
        //                     <option value="375">375</option>
        //                     <option value="376">376</option>
        //                     <option value="377">377</option>
        //                     <option value="378">378</option>
        //                     <option value="380">380</option>
        //                     <option value="381">381</option>
        //                     <option value="385">385</option>
        //                     <option value="386">386</option>
        //                     <option value="387">387</option>
        //                     <option value="389">389</option>
        //                     <option value="420">420</option>
        //                     <option value="421">421</option>
        //                     <option value="423">423</option>
        //                     <option value="500">500</option>
        //                     <option value="501">501</option>
        //                     <option value="502">502</option>
        //                     <option value="503">503</option>
        //                     <option value="504">504</option>
        //                     <option value="505">505</option>
        //                     <option value="506">506</option>
        //                     <option value="507">507</option>
        //                     <option value="508">508</option>
        //                     <option value="509">509</option>
        //                     <option value="590">590</option>
        //                     <option value="591">591</option>
        //                     <option value="592">592</option>
        //                     <option value="593">593</option>
        //                     <option value="594">594</option>
        //                     <option value="595">595</option>
        //                     <option value="596">596</option>
        //                     <option value="597">597</option>
        //                     <option value="598">598</option>
        //                     <option value="599">599</option>
        //                     <option value="670">670</option>
        //                     <option value="672">672</option>
        //                     <option value="673">673</option>
        //                     <option value="674">674</option>
        //                     <option value="675">675</option>
        //                     <option value="676">676</option>
        //                     <option value="677">677</option>
        //                     <option value="678">678</option>
        //                     <option value="679">679</option>
        //                     <option value="680">680</option>
        //                     <option value="681">681</option>
        //                     <option value="682">682</option>
        //                     <option value="683">683</option>
        //                     <option value="684">684</option>
        //                     <option value="686">686</option>
        //                     <option value="687">687</option>
        //                     <option value="688">688</option>
        //                     <option value="689">689</option>
        //                     <option value="690">690</option>
        //                     <option value="691">691</option>
        //                     <option value="692">692</option>
        //                     <option value="850">850</option>
        //                     <option value="852">852</option>
        //                     <option value="853">853</option>
        //                     <option value="855">855</option>
        //                     <option value="856">856</option>
        //                     <option value="880">880</option>
        //                     <option value="886">886</option>
        //                     <option value="960">960</option>
        //                     <option value="961">961</option>
        //                     <option value="962">962</option>
        //                     <option value="963">963</option>
        //                     <option value="964">964</option>
        //                     <option value="965">965</option>
        //                     <option value="966">966</option>
        //                     <option value="967">967</option>
        //                     <option value="968">968</option>
        //                     <option value="970">970</option>
        //                     <option value="971">971</option>
        //                     <option value="972">972</option>
        //                     <option value="973">973</option>
        //                     <option value="974">974</option>
        //                     <option value="975">975</option>
        //                     <option value="976">976</option>
        //                     <option value="977">977</option>
        //                     <option value="992">992</option>
        //                     <option value="994">994</option>
        //                     <option value="995">995</option>
        //                     <option value="996">996</option>
        //                     <option value="998">998</option>
        //                     <option value="1242">1242</option>
        //                     <option value="1246">1246</option>
        //                     <option value="1264">1264</option>
        //                     <option value="1268">1268</option>
        //                     <option value="1284">1284</option>
        //                     <option value="1340">1340</option>
        //                     <option value="1345">1345</option>
        //                     <option value="1441">1441</option>
        //                     <option value="1473">1473</option>
        //                     <option value="1649">1649</option>
        //                     <option value="1664">1664</option>
        //                     <option value="1670">1670</option>
        //                     <option value="1671">1671</option>
        //                     <option value="1684">1684</option>
        //                     <option value="1758">1758</option>
        //                     <option value="1767">1767</option>
        //                     <option value="1784">1784</option>
        //                     <option value="1787">1787</option>
        //                     <option value="1809">1809</option>
        //                     <option value="1868">1868</option>
        //                     <option value="1869">1869</option>
        //                     <option value="1876">1876</option>
        //                     <option value="7370">7370</option>
        //                     </select>';
        //         $html_code .= "\n</div>";
        //         $html_code .= "\n<div col-md-8>";
        //         $html_code .= "\n<label for='wl_mobile' class='form-label'>Mobile No.</label>";
        //         $html_code .= "\n<input type='text' name='wl_mobile' id='wl_mobile' class='form-control' placeholder='Mobile Number'>";
        //         $html_code .= "\n</div>";
        //         $html_code .= "\n</div>";
        //     }
        //     if ($web_lead_alternate_contact_enabled) {
        //         $html_code .= "\n<div class='mt-3'>";
        //         $html_code .= "\n<label for='wl_alt_contact' class='form-label'>Alternate Contact</label>";
        //         $html_code .= "\n<input type='text' name='wl_alt_contact' id='wl_alt_contact' class='form-control' placeholder='Alternate Contact'>";
        //         $html_code .= "\n</div>";
        //     }
        //     if ($web_lead_city_enabled) {
        //         $html_code .= "\n<div class='mt-3'>";
        //         $html_code .= "\n<label for='wl_city' class='form-label'>City</label>";
        //         $html_code .= "\n<input type='text' name='wl_city' id='wl_city' class='form-control' placeholder='Enter City'>";
        //         $html_code .= "\n</div>";
        //     }

        //     if ($web_lead_country_of_citizenship_enabled) {
        //         $html_code .= "\n<div class='mt-3'>";
        //         $html_code .= "\n<label for='wl_country_of_citizenship' class='form-label'>Country of Citizenship</label>";
        //         $html_code .= "\n" . '<select class="form-select form-control" id="wl_country_of_citizenship" name="wl_country_of_citizenship">
        //                             <option value="">Select</option>
        //                             <option value="Afghanistan">Afghanistan</option>
        //                             <option value="Albania">Albania</option>
        //                             <option value="Algeria">Algeria</option>
        //                             <option value="American Samoa">American Samoa</option>
        //                             <option value="Andorra">Andorra</option>
        //                             <option value="Angola">Angola</option>
        //                             <option value="Anguilla">Anguilla</option>
        //                             <option value="Antigua And Barbuda">Antigua And Barbuda</option>
        //                             <option value="Argentina">Argentina</option>
        //                             <option value="Armenia">Armenia</option>
        //                             <option value="Aruba">Aruba</option>
        //                             <option value="Australia">Australia</option>
        //                             <option value="Austria">Austria</option>
        //                             <option value="Azerbaijan">Azerbaijan</option>
        //                             <option value="Bahamas The">Bahamas The</option>
        //                             <option value="Bahrain">Bahrain</option>
        //                             <option value="Bangladesh">Bangladesh</option>
        //                             <option value="Barbados">Barbados</option>
        //                             <option value="Belarus">Belarus</option>
        //                             <option value="Belgium">Belgium</option>
        //                             <option value="Belize">Belize</option>
        //                             <option value="Benin">Benin</option>
        //                             <option value="Bermuda">Bermuda</option>
        //                             <option value="Bhutan">Bhutan</option>
        //                             <option value="Bolivia">Bolivia</option>
        //                             <option value="Bosnia and Herzegovina">Bosnia and Herzegovina</option>
        //                             <option value="Botswana">Botswana</option>
        //                             <option value="Brazil">Brazil</option>
        //                             <option value="British Indian Ocean Territory">British Indian Ocean Territory</option>
        //                             <option value="Brunei">Brunei</option>
        //                             <option value="Bulgaria">Bulgaria</option>
        //                             <option value="Burkina Faso">Burkina Faso</option>
        //                             <option value="Burundi">Burundi</option>
        //                             <option value="Cambodia">Cambodia</option>
        //                             <option value="Cameroon">Cameroon</option>
        //                             <option value="Canada">Canada</option>
        //                             <option value="Cape Verde">Cape Verde</option>
        //                             <option value="Cayman Islands">Cayman Islands</option>
        //                             <option value="Central African Republic">Central African Republic</option>
        //                             <option value="Chad">Chad</option>
        //                             <option value="Chile">Chile</option>
        //                             <option value="China">China</option>
        //                             <option value="Christmas Island">Christmas Island</option>
        //                             <option value="Cocos (Keeling) Islands">Cocos (Keeling) Islands</option>
        //                             <option value="Colombia">Colombia</option>
        //                             <option value="Comoros">Comoros</option>
        //                             <option value="Republic Of The Congo">Republic Of The Congo</option>
        //                             <option value="Democratic Republic Of The Congo">Democratic Republic Of The Congo</option>
        //                             <option value="Cook Islands">Cook Islands</option>
        //                             <option value="Costa Rica">Costa Rica</option>
        //                             <option value="Cote D\'Ivoire (Ivory Coast)">Cote D\'Ivoire (Ivory Coast)</option>
        //                             <option value="Croatia (Hrvatska)">Croatia (Hrvatska)</option>
        //                             <option value="Cuba">Cuba</option>
        //                             <option value="Cyprus">Cyprus</option>
        //                             <option value="Czech Republic">Czech Republic</option>
        //                             <option value="Denmark">Denmark</option>
        //                             <option value="Djibouti">Djibouti</option>
        //                             <option value="Dominica">Dominica</option>
        //                             <option value="Dominican Republic">Dominican Republic</option>
        //                             <option value="East Timor">East Timor</option>
        //                             <option value="Ecuador">Ecuador</option>
        //                             <option value="Egypt">Egypt</option>
        //                             <option value="El Salvador">El Salvador</option>
        //                             <option value="Equatorial Guinea">Equatorial Guinea</option>
        //                             <option value="Eritrea">Eritrea</option>
        //                             <option value="Estonia">Estonia</option>
        //                             <option value="Ethiopia">Ethiopia</option>
        //                             <option value="External Territories of Australia">External Territories of Australia</option>
        //                     <option value="Falkland Islands">Falkland Islands</option>
        //                     <option value="Faroe Islands">Faroe Islands</option>
        //                     <option value="Fiji Islands">Fiji Islands</option>
        //                     <option value="Finland">Finland</option>
        //                     <option value="France">France</option>
        //                     <option value="French Guiana">French Guiana</option>
        //                     <option value="French Polynesia">French Polynesia</option>
        //                     <option value="Gabon">Gabon</option>
        //                     <option value="Gambia The">Gambia The</option>
        //                     <option value="Georgia">Georgia</option>
        //                     <option value="Germany">Germany</option>
        //                     <option value="Ghana">Ghana</option>
        //                     <option value="Gibraltar">Gibraltar</option>
        //                     <option value="Greece">Greece</option>
        //                     <option value="Greenland">Greenland</option>
        //                     <option value="Grenada">Grenada</option>
        //                     <option value="Guadeloupe">Guadeloupe</option>
        //                     <option value="Guam">Guam</option>
        //                     <option value="Guatemala">Guatemala</option>
        //                     <option value="Guernsey and Alderney">Guernsey and Alderney</option>
        //                     <option value="Guinea">Guinea</option>
        //                     <option value="Guinea-Bissau">Guinea-Bissau</option>
        //                     <option value="Guyana">Guyana</option>
        //                     <option value="Haiti">Haiti</option>
        //                     <option value="Honduras">Honduras</option>
        //                     <option value="Hong Kong S.A.R.">Hong Kong S.A.R.</option>
        //                     <option value="Hungary">Hungary</option>
        //                     <option value="Iceland">Iceland</option>
        //                     <option value="India">India</option>
        //                     <option value="Indonesia">Indonesia</option>
        //                     <option value="Iran">Iran</option>
        //                     <option value="Iraq">Iraq</option>
        //                     <option value="Ireland">Ireland</option>
        //                     <option value="Israel">Israel</option>
        //                     <option value="Italy">Italy</option>
        //                     <option value="Jamaica">Jamaica</option>
        //                     <option value="Japan">Japan</option>
        //                     <option value="Jersey">Jersey</option>
        //                     <option value="Jordan">Jordan</option>
        //                     <option value="Kazakhstan">Kazakhstan</option>
        //                     <option value="Kenya">Kenya</option>
        //                     <option value="Kiribati">Kiribati</option>
        //                     <option value="Korea North">Korea North</option>
        //                     <option value="Korea South">Korea South</option>
        //                     <option value="Kuwait">Kuwait</option>
        //                     <option value="Kyrgyzstan">Kyrgyzstan</option>
        //                     <option value="Laos">Laos</option>
        //                     <option value="Latvia">Latvia</option>
        //                     <option value="Lebanon">Lebanon</option>
        //                     <option value="Lesotho">Lesotho</option>
        //                     <option value="Liberia">Liberia</option>
        //                     <option value="Libya">Libya</option>
        //                     <option value="Liechtenstein">Liechtenstein</option>
        //                     <option value="Lithuania">Lithuania</option>
        //                     <option value="Luxembourg">Luxembourg</option>
        //                     <option value="Macau S.A.R.">Macau S.A.R.</option>
        //                     <option value="Macedonia">Macedonia</option>
        //                     <option value="Madagascar">Madagascar</option>
        //                     <option value="Malawi">Malawi</option>
        //                     <option value="Malaysia">Malaysia</option>
        //                     <option value="Maldives">Maldives</option>
        //                     <option value="Mali">Mali</option>
        //                     <option value="Malta">Malta</option>
        //                     <option value="Man (Isle of)">Man (Isle of)</option>
        //                     <option value="Marshall Islands">Marshall Islands</option>
        //                     <option value="Martinique">Martinique</option>
        //                     <option value="Mauritania">Mauritania</option>
        //                     <option value="Mauritius">Mauritius</option>
        //                     <option value="Mayotte">Mayotte</option>
        //                     <option value="Mexico">Mexico</option>
        //                     <option value="Micronesia">Micronesia</option>
        //                     <option value="Moldova">Moldova</option>
        //                     <option value="Monaco">Monaco</option>
        //                     <option value="Mongolia">Mongolia</option>
        //                     <option value="Montserrat">Montserrat</option>
        //                     <option value="Morocco">Morocco</option>
        //                     <option value="Mozambique">Mozambique</option>
        //                     <option value="Myanmar">Myanmar</option>
        //                     <option value="Namibia">Namibia</option>
        //                     <option value="Nauru">Nauru</option>
        //                     <option value="Nepal">Nepal</option>
        //                     <option value="Netherlands Antilles">Netherlands Antilles</option>
        //                     <option value="Netherlands The">Netherlands The</option>
        //                     <option value="New Caledonia">New Caledonia</option>
        //                     <option value="New Zealand">New Zealand</option>
        //                     <option value="Nicaragua">Nicaragua</option>
        //                     <option value="Niger">Niger</option>
        //                     <option value="Nigeria">Nigeria</option>
        //                     <option value="Niue">Niue</option>
        //                     <option value="Norfolk Island">Norfolk Island</option>
        //                     <option value="Northern Mariana Islands">Northern Mariana Islands</option>
        //                     <option value="Norway">Norway</option>
        //                     <option value="Oman">Oman</option>
        //                     <option value="Pakistan">Pakistan</option>
        //                     <option value="Palau">Palau</option>
        //                     <option value="Palestinian Territory Occupied">Palestinian Territory Occupied</option>
        //                     <option value="Panama">Panama</option>
        //                     <option value="Papua new Guinea">Papua new Guinea</option>
        //                     <option value="Paraguay">Paraguay</option>
        //                     <option value="Peru">Peru</option>
        //                     <option value="Philippines">Philippines</option>
        //                     <option value="Poland">Poland</option>
        //                     <option value="Portugal">Portugal</option>
        //                     <option value="Puerto Rico">Puerto Rico</option>
        //                     <option value="Qatar">Qatar</option>
        //                     <option value="Reunion">Reunion</option>
        //                     <option value="Romania">Romania</option>
        //                     <option value="Russia">Russia</option>
        //                     <option value="Rwanda">Rwanda</option>
        //                     <option value="Saint Helena">Saint Helena</option>
        //                     <option value="Saint Kitts And Nevis">Saint Kitts And Nevis</option>
        //                     <option value="Saint Lucia">Saint Lucia</option>
        //                     <option value="Saint Pierre and Miquelon">Saint Pierre and Miquelon</option>
        //                     <option value="Saint Vincent And The Grenadines">Saint Vincent And The Grenadines</option>
        //                     <option value="Samoa">Samoa</option>
        //                     <option value="San Marino">San Marino</option>
        //                     <option value="Sao Tome and Principe">Sao Tome and Principe</option>
        //                     <option value="Saudi Arabia">Saudi Arabia</option>
        //                     <option value="Senegal">Senegal</option>
        //                     <option value="Serbia">Serbia</option>
        //                     <option value="Seychelles">Seychelles</option>
        //                     <option value="Sierra Leone">Sierra Leone</option>
        //                     <option value="Singapore">Singapore</option>
        //                     <option value="Slovakia">Slovakia</option>
        //                     <option value="Slovenia">Slovenia</option>
        //                     <option value="Smaller Territories of the UK">Smaller Territories of the UK</option>
        //                     <option value="Solomon Islands">Solomon Islands</option>
        //                     <option value="Somalia">Somalia</option>
        //                     <option value="South Africa">South Africa</option>
        //                     <option value="South Sudan">South Sudan</option>
        //                     <option value="Spain">Spain</option>
        //                     <option value="Sri Lanka">Sri Lanka</option>
        //                     <option value="Sudan">Sudan</option>
        //                     <option value="Suriname">Suriname</option>
        //                     <option value="Svalbard And Jan Mayen Islands">Svalbard And Jan Mayen Islands</option>
        //                     <option value="Swaziland">Swaziland</option>
        //                     <option value="Sweden">Sweden</option>
        //                     <option value="Switzerland">Switzerland</option>
        //                     <option value="Syria">Syria</option>
        //                     <option value="Taiwan">Taiwan</option>
        //                     <option value="Tajikistan">Tajikistan</option>
        //                     <option value="Tanzania">Tanzania</option>
        //                     <option value="Thailand">Thailand</option>
        //                     <option value="Togo">Togo</option>
        //                     <option value="Tokelau">Tokelau</option>
        //                     <option value="Tonga">Tonga</option>
        //                     <option value="Trinidad And Tobago">Trinidad And Tobago</option>
        //                     <option value="Tunisia">Tunisia</option>
        //                     <option value="Turkey">Turkey</option>
        //                     <option value="Turkmenistan">Turkmenistan</option>
        //                     <option value="Turks And Caicos Islands">Turks And Caicos Islands</option>
        //                     <option value="Tuvalu">Tuvalu</option>
        //                     <option value="Uganda">Uganda</option>
        //                     <option value="Ukraine">Ukraine</option>
        //                     <option value="United Arab Emirates">United Arab Emirates</option>
        //                     <option value="United Kingdom">United Kingdom</option>
        //                     <option value="United States">United States</option>
        //                     <option value="Uruguay">Uruguay</option>
        //                     <option value="Uzbekistan">Uzbekistan</option>
        //                     <option value="Vanuatu">Vanuatu</option>
        //                     <option value="Venezuela">Venezuela</option>
        //                     <option value="Vietnam">Vietnam</option>
        //                     <option value="Virgin Islands (British)">Virgin Islands (British)</option>
        //                     <option value="Virgin Islands (US)">Virgin Islands (US)</option>
        //                     <option value="Wallis And Futuna Islands">Wallis And Futuna Islands</option>
        //                     <option value="Western Sahara">Western Sahara</option>
        //                     <option value="Yemen">Yemen</option>
        //                     <option value="Yugoslavia">Yugoslavia</option>
        //                     <option value="Zambia">Zambia</option>
        //                     <option value="Zimbabwe">Zimbabwe</option>
        //                 </select>';
        //         $html_code .= "\n</div>";
        //     }


        //     if ($web_lead_dob_enabled) {
        //         $html_code .= "\n<div class='mt-3'>";
        //         $html_code .= "\n<label for='wl_dob' class='form-label'>Date of Birth</label>";
        //         $html_code .= "\n<input type='date' name='wl_dob' id='wl_dob' class='form-control' placeholder='dd-mm-yyyy'>";
        //         $html_code .= "\n</div>";
        //     }

        //     if ($web_lead_current_course_enabled) {
        //         $html_code .= "\n<div class='mt-3'>";
        //         $html_code .= "\n<label for='wl_current_course' class='form-label'>Currently Studying Course</label>";
        //         $html_code .= "\n<input type='text' name='wl_current_course' id='wl_current_course' class='form-control' placeholder='Currently Studying Course'>";
        //         $html_code .= "\n</div>";
        //     }

        //     if ($web_lead_study_level_enabled) {
        //         $html_code .= "\n<div class='mt-3'>";
        //         $html_code .= "\n<label for='wl_study_level' class='form-label'>Interested Study Level</label>";
        //         $html_code .= "\n" . "<select class='form-select form-control' id='wl_study_level' name='wl_study_level'>";
        //         $html_code .= "\n" . "<option value=''>Select Study Level</option>";
        //         foreach (get_study_levels() as $key => $value) {
        //             $html_code .= "\n" . "<option value='$key'>" . $value . "</option>";
        //         }
        //         $html_code .= "\n</select></div>";
        //     }
        //     if ($web_lead_course_interested_enabled) {
        //         $html_code .= "\n<div class='mt-3'>";
        //         $html_code .= "\n<label for='wl_course_interested' class='form-label'>Course Interested to Study</label>";
        //         $html_code .= "\n<input type='text' name='wl_course_interested' id='wl_course_interested' class='form-control' placeholder='Course Interested to Study'>";
        //         $html_code .= "\n</div>";
        //     }
        //     if ($web_lead_country_pref_enabled) {
        //         $countries = CountryStudy::where('status', 1)->orderBy('country', 'ASC')->get();
        //         $html_code .= "\n<div class='mt-3'>";
        //         $html_code .= "\n<label for='wl_country_pref' class='form-label'>Country Interested to Study In</label>";
        //         $html_code .= "\n" . "<select class='form-select from-control' id='wl_country_pref' name='wl_country_pref'>";
        //         $html_code .= "\n" . "<option value=''>Select Country</option>";
        //         foreach ($countries as $country) {
        //             $html_code .= "\n" . "<option  value='$country->country'>" . $country->country . "</option>";
        //         }
        //         $html_code .= "\n</select></div>";
        //     }

        //     if ($web_lead_accommodation_enabled) {
        //         $html_code .= "\n<div class='mt-3'>";
        //         $html_code .= "\n<label for='wl_accommodation' class='form-label'>Require Accommodation</label>";
        //         $html_code .= "\n" . "<select class='form-select form-control' id='wl_accommodation' name='wl_accommodation'>";
        //         $html_code .= "\n" . "<option value=''>Select</option>";
        //         $html_code .= "\n" . "<option value='Yes'>Yes</option>";
        //         $html_code .= "\n" . "<option value='No'>No</option>";
        //         $html_code .= "\n</select></div>";
        //     }
        //     if ($web_lead_study_permit_enabled) {
        //         $html_code .= "\n<div class='mt-3'>";
        //         $html_code .= "\n<label for='wl_study_permit' class='form-label'>Require Study Permit</label>";
        //         $html_code .= "\n" . "<select class='form-select form-control' id='wl_study_permit' name='wl_study_permit'>";
        //         $html_code .= "\n" . "<option value=''>Select</option>";
        //         $html_code .= "\n" . "<option value='Yes'>Yes</option>";
        //         $html_code .= "\n" . "<option value='No'>No</option>";
        //         $html_code .= "\n</select></div>";
        //     }

        //     $html_code .= "\n<div style='padding-top:5px;' class='mt-3'>";
        //     $html_code .= "\n<input type='submit' name='submit' class='btn btn-primary' value='Submit'>";
        //     $html_code .= "\n</div>";
        //     $html_code .= "\n</form>";
        //     $html_code .= "\n</div>";
        // }
        $custom_attributes = DB::table('custom_attributes')->orderBy('display_order','asc')->get(["custom_attributes.*"]);
        
        return view(
            'backend.settings.web_to_lead',
            [
                'web_lead_enabled' => $web_lead_enabled,
                'web_lead_form_name' => $web_lead_form_name,
                'web_lead_redirect_url' => $web_lead_redirect_url,
                'web_lead_assign_to' => $web_lead_assign_to,
                'web_lead_assign_to_branch' => $web_lead_assign_to_branch,
                'web_lead_first_name_enabled' => $web_lead_first_name_enabled,
                'web_lead_last_name_enabled' => $web_lead_last_name_enabled,
                'web_lead_alternate_contact_enabled' => $web_lead_alternate_contact_enabled,
                'web_lead_gender_enabled' => $web_lead_gender_enabled,
                'web_lead_country_of_citizenship_enabled' => $web_lead_country_of_citizenship_enabled,
                'web_lead_study_level_enabled' => $web_lead_study_level_enabled,
                'web_lead_dob_enabled' => $web_lead_dob_enabled,
                'web_lead_course_interested_enabled' => $web_lead_course_interested_enabled,
                'web_lead_intake_enabled' => $web_lead_intake_enabled,
                'web_lead_country_pref_enabled' => $web_lead_country_pref_enabled,
                'web_lead_qualification_enabled' => $web_lead_qualification_enabled,
                'web_lead_accommodation_enabled' => $web_lead_accommodation_enabled,
                'web_lead_study_permit_enabled' => $web_lead_study_permit_enabled,
                'web_lead_current_course_enabled' => $web_lead_current_course_enabled,
                'web_lead_passout_year_enabled' => $web_lead_passout_year_enabled,
                'web_lead_score_enabled' => $web_lead_score_enabled,
                'web_lead_email_enabled' => $web_lead_email_enabled,
                'web_lead_mobile_enabled' => $web_lead_mobile_enabled,
                'web_lead_whatsapp_enabled' => $web_lead_whatsapp_enabled,
                'web_lead_city_enabled' => $web_lead_city_enabled,
                'staff' => $staff,
                'branches' => $branches,
                'html_code' => $html_code,
                'custom_attributes' => $custom_attributes
            ]
        );
    }



    public function webToLeadSave(Request $request)
    {   
        if ($request->input('web_lead_enabled') == 1) {
            $request->validate([
                'web_lead_redirect_url' => 'required|url',
                'web_lead_form_name' => 'required',
                //'web_lead_assign_to' => 'required|numeric',
                'web_lead_assign_to_branch' => 'required|numeric',
            ]);
            set_site_config('web_lead_enabled', 1);

            if ($request->input('web_lead_mobile_enabled')) {
                set_site_config('web_lead_mobile_enabled', 1);
            } else {
                set_site_config('web_lead_mobile_enabled', 0);
            }
            if ($request->input('web_lead_whatsapp_enabled')) {
                set_site_config('web_lead_whatsapp_enabled', 1);
            } else {
                set_site_config('web_lead_whatsapp_enabled', 0);
            }
            if ($request->input('web_lead_email_enabled')) {
                set_site_config('web_lead_email_enabled', 1);
            } else {
                set_site_config('web_lead_email_enabled', 0);
            }
            
            if(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email' || get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_and_mobile'){
                set_site_config('web_lead_email_enabled', 1);
            } 
            if(get_site_config('lead_create_web2lead_api_import_mandatory') == 'mobile' || get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_and_mobile'){
                set_site_config('web_lead_mobile_enabled', 1);
            } 

            if ($request->input('web_lead_redirect_url')) {
                set_site_config('web_lead_redirect_url', $request->input('web_lead_redirect_url'));
            }
            if ($request->input('web_lead_form_name')) {
                set_site_config('web_lead_form_name', $request->input('web_lead_form_name'));
            }
            if ($request->input('web_lead_assign_to')) {
                set_site_config('web_lead_assign_to', $request->input('web_lead_assign_to'));
            }else{
                set_site_config('web_lead_assign_to', 0);
            }
            if ($request->input('web_lead_assign_to_branch')) {
                set_site_config('web_lead_assign_to_branch', $request->input('web_lead_assign_to_branch'));
            }

            if ($request->input('web_lead_last_name_enabled')) {
                set_site_config('web_lead_last_name_enabled', 1);
            } else {
                set_site_config('web_lead_last_name_enabled', 0);
            }
            
            if ($request->input('web_lead_course_interested_enabled')) {
                set_site_config('web_lead_course_interested_enabled', 1);
            } else {
                set_site_config('web_lead_course_interested_enabled', 0);
            }
            if ($request->input('web_lead_intake_enabled')) {
                set_site_config('web_lead_intake_enabled', 1);
            } else {
                set_site_config('web_lead_intake_enabled', 0);
            }
            if ($request->input('web_lead_city_enabled')) {
                set_site_config('web_lead_city_enabled', 1);
            } else {
                set_site_config('web_lead_city_enabled', 0);
            }
            if ($request->input('web_lead_country_pref_enabled')) {
                set_site_config('web_lead_country_pref_enabled', 1);
            } else {
                set_site_config('web_lead_country_pref_enabled', 0);
            }

            if ($request->input('web_lead_gender_enabled')) {
                set_site_config('web_lead_gender_enabled', 1);
            } else {
                set_site_config('web_lead_gender_enabled', 0);
            }
            if ($request->input('web_lead_alternate_contact_enabled')) {
                set_site_config('web_lead_alternate_contact_enabled', 1);
            } else {
                set_site_config('web_lead_alternate_contact_enabled', 0);
            }
            if ($request->input('web_lead_country_of_citizenship_enabled')) {
                set_site_config('web_lead_country_of_citizenship_enabled', 1);
            } else {
                set_site_config('web_lead_country_of_citizenship_enabled', 0);
            }
            if ($request->input('web_lead_current_course_enabled')) {
                set_site_config('web_lead_current_course_enabled', 1);
            } else {
                set_site_config('web_lead_current_course_enabled', 0);
            }
            if ($request->input('web_lead_qualification_enabled')) {
                set_site_config('web_lead_qualification_enabled', 1);
            } else {
                set_site_config('web_lead_qualification_enabled', 0);
            }
            if ($request->input('web_lead_score_enabled')) {
                set_site_config('web_lead_score_enabled', 1);
            } else {
                set_site_config('web_lead_score_enabled', 0);
            }
            if ($request->input('web_lead_passout_year_enabled')) {
                set_site_config('web_lead_passout_year_enabled', 1);
            } else {
                set_site_config('web_lead_passout_year_enabled', 0);
            }
            if ($request->input('web_lead_study_level_enabled')) {
                set_site_config('web_lead_study_level_enabled', 1);
            } else {
                set_site_config('web_lead_study_level_enabled', 0);
            }
            if ($request->input('web_lead_accommodation_enabled')) {
                set_site_config('web_lead_accommodation_enabled', 1);
            } else {
                set_site_config('web_lead_accommodation_enabled', 0);
            }
            if ($request->input('web_lead_study_permit_enabled')) {
                set_site_config('web_lead_study_permit_enabled', 1);
            } else {
                set_site_config('web_lead_study_permit_enabled', 0);
            }
            if ($request->input('web_lead_dob_enabled')) {
                set_site_config('web_lead_dob_enabled', 1);
            } else {
                set_site_config('web_lead_dob_enabled', 0);
            }

            //Checking custom attributes
            $custom_attributes = DB::table('custom_attributes')->get(["custom_attributes.*"]);
            if(count($custom_attributes)){
                foreach($custom_attributes as $attrs){
                
                    $name = $attrs->attr_name;
                    if($request->$name){
                        
                        DB::table('custom_attributes')->where("attr_name",$name)->update(["web_to_lead"=>'1']);
                    }else{
                        DB::table('custom_attributes')->where("attr_name",$name)->update(["web_to_lead"=>'0']);
                    }
                }
            }
            //Checking custom attributes
        } else {
            set_site_config('web_lead_enabled', '0');
            set_site_config('web_lead_redirect_url', '');
            set_site_config('web_lead_assign_to', '');
            set_site_config('web_lead_assign_to_branch', '');
            set_site_config('web_lead_last_name_enabled', '0');
            set_site_config('web_lead_mobile_enabled', '0');
            set_site_config('web_lead_city_enabled', '0');

            set_site_config('web_lead_gender_enabled', '0');
            set_site_config('web_lead_study_permit_enabled', '0');
            set_site_config('web_lead_accommodation_enabled', '0');
            set_site_config('web_lead_study_level_enabled', '0');
            set_site_config('web_lead_current_course_enabled', '0');
            set_site_config('web_lead_country_of_citizenship_enabled', '0');
            set_site_config('web_lead_alternate_contact_enabled', '0');
            set_site_config('web_lead_dob_enabled', '0');
        }

        return redirect()->route('admin.web-to-lead')->withFlashSuccess('Settings saved successfully');
    }


    public function changeCountrySatus(Request $request, $country){
        DB::statement("UPDATE countries SET `overseas_status` = CASE `overseas_status` WHEN 1 THEN 0 WHEN 0 THEN 1 END WHERE title_en ='" . $country . "'");
        return "Status Updated";
    }

    public function country(Request $request)
    {
        return view('backend.countryinfo.country_settings');
    }


    public function ajaxcountrylist(Request $request)
    {

        if (!$request->ajax()) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this page.');
        }
        echo $this->getDatatableCountrylist($request);
    }


    public function getDatatableCountrylist($request){
        $columns = array(
            0 => 'title_en',
            1 => 'overseas_status',
            2 => 'actions',
        );

        $totalData = DB::table('countries')->count();
        $totalFiltered = $totalData;
        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');


        if (empty($request->input('search.value'))) {
            $users = DB::table('countries')
                ->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                ->get();
        } else {
            $get_search = $request->input('search.value');
            $users = DB::table('countries')
                ->where(function ($query) use ($get_search) {
                    $query->Where('title_en', 'like', "%$get_search%");
                })
                ->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                ->get();

            $totalFiltered = DB::table('countries')
                ->where(function ($query) use ($get_search) {
                    $query->Where('title_en', 'like', "%$get_search%");
                })
                ->count();
        }

        $data = $customResult = array();
        if (!empty($users)) {
            $count = 1;
            foreach ($users as $page) {
                $customResult['country'] = "<strong>" . $page->title_en . '</strong>';
                if ($page->overseas_status == 1) {
                    $customResult['status'] = '<span class="badge" style="background-color: #16b4d4 !important">Enabled</span>';
                    $customResult['actions'] = "<a href='javascript:void(0);' onclick=\"changeStatus('{$page->title_en}');\" class='btn btn-danger btn-sm'>Disable</a>";
                    $customResult['actions'] .= "<a href='".route('admin.view-country.state', $page->id)."' class='btn btn-primary btn-sm ms-3'><i class='fa fa-eye'></i> Manage States</a>";
                } else {
                    $customResult['status'] = '<span class="badge" style="background-color: #dc3545 !important">Disabled</span>';
                    $customResult['actions'] = "<a href='javascript:void(0);' onclick=\"changeStatus('{$page->title_en}');\" class='btn btn-success btn-sm'>Enable</a>";
                    $customResult['actions'] .= "<a href='".route('admin.view-country.state', $page->id)."' class='btn btn-primary btn-sm ms-3'><i class='fa fa-eye'></i> Manage States</a>";
                }
                $data[] = $customResult;
            }
        }

        $json_data = array(
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $data
        );

        return json_encode($json_data);
    }

    public function viewCountryState($country_id){
        $country = get_country_name($country_id);
        return view('backend.countryinfo.state_settings', compact('country_id', 'country'));
    }

    public function ajaxstatelist(Request $request){
        if (!$request->ajax()) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this page.');
        }
        echo $this->getDatatableStatelist($request);
    }

    public function getDatatableStatelist($request){
        $columns = array(
            1 => 'state',
            // 2 => 'actions',
        );

        $totalData = State::where("country_id", $request->country_id)->count();
        $totalFiltered = $totalData;
        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');
        
        if (empty($request->input('search.value'))) {
            $users = DB::table('states')
                ->where("country_id", $request->country_id)
                ->offset($start)
                ->limit($limit)
                ->orderBy("name")
                ->get();
        } else {
            $get_search = $request->input('search.value');
            $users = DB::table('states')
                ->where(function ($query) use ($get_search) {
                    $query->Where('name', 'like', "%$get_search%");
                })
                ->where("country_id", $request->country_id)
                ->offset($start)
                ->limit($limit)
                ->orderBy("name")
                ->get();

            $totalFiltered = DB::table('states')
                ->where(function ($query) use ($get_search) {
                    $query->Where('name', 'like', "%$get_search%");
                })
                ->where("country_id", $request->country_id)
                ->count();
        }

        $data = $customResult = array();
        if (!empty($users)) {
            $count = 1;
            foreach ($users as $page) {
                $customResult['id'] = $page->id;
                $customResult['state'] = "<strong>" . $page->name . '</strong>';
                $customResult['status'] = $page->status ? '<span class="badge" style="background-color: #16b4d4 !important">Enabled</span>' : '<span class="badge" style="background-color: #dc3545 !important">Disabled</span>';
                $customResult['actions'] = "<a href='".route('admin.view-state.city', $page->id)."' class='btn btn-primary btn-sm ms-3'><i class='fa fa-eye'></i> Manage Cities</a>";
                $customResult['actions'] .= "<button class='btn btn-warning btn-sm ms-3 edit-state' data-bs-toggle='modal' data-bs-target='#edit_state_modal' data-state='".$page->name."' data-state_id='".$page->id."' data-country_id='".$page->country_id."' title='Edit State'><i class='fa fa-pen'></i> Edit</button>";
                $customResult['actions'] .= "<a href='".route('admin.view-country.state.delete', [$page->id, $page->country_id])."' data-html='true' data-trans-title='Are you sure want to delete this State? <br><br><label style=&quot;color: red; font-size: 15px;&quot;>This action cannot be Undone!</label>' data-method='delete' class='btn btn-danger btn-sm ms-3'><i class='fa fa-trash'></i> Delete</a>";
                $data[] = $customResult;
            }
        }

        $json_data = array(
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $data
        );

        return json_encode($json_data);
    }

    public function bulkStateEnableDisable(Request $request){
        // dd($request->all());       
        $states_arr = array();
        $id_arr = explode(',', $request->input('id_arr'));
        if (is_array($id_arr)) {
            foreach ($id_arr as $states) {
                $states_arr[] = DB::table('states')
                    ->where("id", $states)
                    ->where("country_id", $request->country_id)
                    ->update(["status" => $request->states_status ? 1 : 0]);
            }
        }

        return redirect()->route('admin.view-country.state', $request->country_id)->withFlashSuccess('State status updates successfully');
    }

    public function addCountryState(Request $request){
        $request->validate([
            'state' => 'required'
        ]);

        if(DB::table('states')->where("name", $request->state)->where("country_id", $request->add_country_id)->first()){
            $state = DB::table('states')->where("name", $request->state)->where("country_id", $request->add_country_id)->update(["name" => $request->state]);

            return redirect()->route('admin.view-country.state', $request->add_country_id)->withFlashSuccess('State updated successfully');
        } else{
            $state = DB::table('states')->insertGetId(["name" => $request->state, "country_id" => $request->add_country_id]);
            return redirect()->route('admin.view-country.state', $request->add_country_id)->withFlashSuccess('State added successfully');
        }
    }

    public function editCountryState(Request $request){
        $request->validate([
            'state' => 'required'
        ]);

        if(DB::table('states')->where("id", $request->state_id)->where("country_id", $request->country_id)->count()){
            $state = DB::table('states')->where("id", $request->state_id)->where("country_id", $request->country_id)->update(["name" => $request->state]);

            return redirect()->route('admin.view-country.state', $request->country_id)->withFlashSuccess('State updated successfully');
        }
        return redirect()->route('admin.view-country.state', $request->country_id)->withFlashDanger('State not found');
    }

    public function deleteCountryState($state_id, $country_id){
        $state = State::where("id", $state_id)->where("country_id", $country_id)->first();
        if($state){
            if(User::where("state", $state->id)->count()){
                User::where("state", $state->id)->update(["state" => NULL]);
            }
            $state->delete();
            return redirect()->route('admin.view-country.state', $country_id)->withFlashSuccess('State deleted successfully');
        }
        return redirect()->route('admin.view-country.state', $country_id)->withFlashDanger('State not found');
    }

    // STATE MANAGEMENT
    public function viewStateCity($state_id){
        $state = get_state_name($state_id);
        return view('backend.countryinfo.city_settings', compact('state_id', 'state'));
    }

    public function ajaxcitylist(Request $request){
        if (!$request->ajax()) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this page.');
        }
        echo $this->getDatatableCitylist($request);
    }

    public function getDatatableCitylist($request){
        $columns = array(
            1 => 'state',
        );

        $totalData = City::where("state_id", $request->state_id)->count();
        $totalFiltered = $totalData;
        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');
        
        if (empty($request->input('search.value'))) {
            $users = DB::table('cities')
                ->where("state_id", $request->state_id)
                ->offset($start)
                ->limit($limit)
                ->orderBy("name")
                ->get();
        } else {
            $get_search = $request->input('search.value');
            $users = DB::table('cities')
                ->where(function ($query) use ($get_search) {
                    $query->Where('name', 'like', "%$get_search%");
                })
                ->where("state_id", $request->state_id)
                ->offset($start)
                ->limit($limit)
                ->orderBy("name")
                ->get();

            $totalFiltered = DB::table('cities')
                ->where(function ($query) use ($get_search) {
                    $query->Where('name', 'like', "%$get_search%");
                })
                ->where("state_id", $request->state_id)
                ->count();
        }

        $data = $customResult = array();
        if (!empty($users)) {
            $count = 1;
            foreach ($users as $page) {
                $customResult['id'] = $page->id;
                $customResult['city'] = "<strong>" . $page->name . '</strong>';
                $customResult['status'] = $page->status ? '<span class="badge" style="background-color: #16b4d4 !important">Enabled</span>' : '<span class="badge" style="background-color: #dc3545 !important">Disabled</span>';
                // $customResult['actions'] = "<a href='".route('admin.view-state.city', $page->id)."' class='btn btn-primary btn-sm ms-3'><i class='fa fa-eye'></i> View City</a>";
                $customResult['actions'] = "<button class='btn btn-warning btn-sm ms-3 edit-city' data-bs-toggle='modal' data-bs-target='#edit_state_modal' data-city='".$page->name."' data-city_id='".$page->id."' data-state_id='".$page->state_id."' title='Edit City'><i class='fa fa-pen'></i> Edit</button>";
                $customResult['actions'] .= "<a href='".route('admin.view-state.city.delete', [$page->id, $page->state_id])."' data-html='true' data-trans-title='Are you sure want to delete this City? <br><br><label style=&quot;color: red; font-size: 15px;&quot;>This action cannot be Undone!</label>' data-method='delete' class='btn btn-danger btn-sm ms-3'><i class='fa fa-trash'></i> Delete</a>";
                $data[] = $customResult;
            }
        }

        $json_data = array(
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $data
        );

        return json_encode($json_data);
    }

    public function bulkCitiesEnableDisable(Request $request){
        // dd($request->all());       
        $cities_arr = array();
        $id_arr = explode(',', $request->input('id_arr'));
        if (is_array($id_arr)) {
            foreach ($id_arr as $cities) {
                $states_arr[] = DB::table('cities')
                    ->where("id", $cities)
                    ->where("state_id", $request->state_id)
                    ->update(["status" => $request->states_status ? 1 : 0]);
            }
        }

        return redirect()->route('admin.view-state.city', $request->state_id)->withFlashSuccess('Cities status updates successfully');
    }

    public function addStateCity(Request $request){
        $request->validate([
            'city' => 'required'
        ]);

        if(DB::table('cities')->where("name", $request->city)->where("state_id", $request->add_state_id)->first()){
            $city = DB::table('cities')->where("name", $request->city)->where("state_id", $request->add_state_id)->update(["name" => $request->city]);

            return redirect()->route('admin.view-state.city', $request->add_state_id)->withFlashSuccess('City updated successfully');
        } else{
            $city = DB::table('cities')->insertGetId(["name" => $request->city, "state_id" => $request->add_state_id]);
            return redirect()->route('admin.view-state.city', $request->add_state_id)->withFlashSuccess('City added successfully');
        }
    }

    public function editStateCity(Request $request){
        $request->validate([
            'city' => 'required'
        ]);

        if(DB::table('cities')->where("id", $request->city_id)->where("state_id", $request->state_id)->count()){
            $state = DB::table('cities')->where("id", $request->city_id)->where("state_id", $request->state_id)->update(["name" => $request->city]);

            return redirect()->route('admin.view-state.city', $request->state_id)->withFlashSuccess('City updated successfully');
        }
        return redirect()->route('admin.view-state.city', $request->state_id)->withFlashDanger('City not found');
    }

    public function deleteStateCity($city_id, $state_id){
        $city = City::where("id", $city_id)->where("state_id", $state_id)->first();
        if($city){
            if(User::where("city", $city->name)->count()){
                User::where("city", $city->name)->update(["city" => NULL]);
            }
            $city->delete();
            return redirect()->route('admin.view-state.city', $state_id)->withFlashSuccess('City deleted successfully');
        }
        return redirect()->route('admin.view-state.city', $state_id)->withFlashDanger('City not found');
    }

    public function saveSMTP(Request $request)
    {
        if($request->conf_type == "single_smtp"){
            if(!env('DEMO_MODE') && $request->input('smtp_type') == 'smtp_server') {
                set_site_config('smtp_type', $request->input('smtp_type'));
                set_site_config('smtp_host', $request->input('hostname'));
                set_site_config('smtp_port', $request->input('port'));
                set_site_config('smtp_connection', $request->input('connection_type'));
                set_site_config('smtp_email', $request->input('username'));
                set_site_config('smtp_password', $request->input('password'));
                set_site_config('smtp_from_email', $request->input('from_email'));
                set_site_config('smtp_reply_to', $request->input('reply_to_email'));
            }
            if(!env('DEMO_MODE') && $request->input('smtp_type') == 'google') {
                set_site_config('smtp_type', $request->input('smtp_type'));
                set_site_config('google_project_id', $request->input('google_project_id'));
                set_site_config('google_email_id', $request->input('google_email_id'));
                set_site_config('google_email_from_name', $request->input('google_email_from_name'));
                set_site_config('google_client_id', $request->input('google_client_id'));
                set_site_config('google_client_secret', $request->input('google_client_secret'));
                set_site_config('google_email_reply_to', $request->input('google_email_reply_to'));
                //disabling all staff's SMTP
                DB::table('staff_details')->where('email_integration',1)->update(['email_integration' => 0]);
            }
            return redirect()->route('admin.email-smtp')->withFlashSuccess('Email SMTP Configuration saved successfully');
        }
        if($request->conf_type == "bulk_smtp"){
            if(!env('DEMO_MODE') && $request->input('bulk_smtp_type') == 'smtp_server') {
                set_site_config('bulk_smtp_type', $request->input('bulk_smtp_type'));
                set_site_config('bulk_smtp_host', $request->input('bulk_hostname'));
                set_site_config('bulk_smtp_port', $request->input('bulk_port'));
                set_site_config('bulk_smtp_connection', $request->input('bulk_connection_type'));
                set_site_config('bulk_smtp_email', $request->input('bulk_username'));
                set_site_config('bulk_smtp_password', $request->input('bulk_password'));
                set_site_config('bulk_smtp_from_email', $request->input('bulk_from_email'));
                set_site_config('bulk_smtp_limit_hourly', $request->input('bulk_smtp_limit_hourly'));
            }
            if(!env('DEMO_MODE') && $request->input('bulk_smtp_type') == 'google') {
                set_site_config('bulk_smtp_type', $request->input('bulk_smtp_type'));
            }
            return redirect()->route('admin.email-smtp')->withFlashSuccess('Bulk Email SMTP Configuration saved successfully');
        }
    }

    public function saveAdvanced(Request $request)
    {
        $request->validate([
            'sample_cv' => 'nullable|mimes:pdf,doc,docx|max:2048',
            'sample_sop' => 'nullable|mimes:pdf,doc,docx|max:2048',
            'sample_professional_lor' => 'nullable|mimes:pdf,doc,docx|max:2048',
            'sample_academic_lor' => 'nullable|mimes:pdf,doc,docx|max:2048',
        ]);

        if ($request->input('student_signup_terms_page')) {
            set_site_config('student_signup_terms_page', $request->input('student_signup_terms_page'));
        }
        if ($request->input('student_application_terms_page')) {
            set_site_config('student_application_terms_page', $request->input('student_application_terms_page'));
        }

        set_site_config('invoice_terms_text', $request->input('invoice_terms_text'));
        set_site_config('invoice_footer_text', $request->input('invoice_footer_text'));

        set_site_config('invoice_business_name', $request->input('invoice_business_name'));
        set_site_config('invoice_business_phone', $request->input('invoice_business_phone'));
        set_site_config('invoice_business_email', $request->input('invoice_business_email'));
        set_site_config('invoice_business_address', $request->input('invoice_business_address'));
        set_site_config('invoice_business_taxid', $request->input('invoice_business_taxid'));
        set_site_config('payment_bank_details', $request->input('payment_bank_details'));
        \Log::info($request->input('docusign_api_url'));
        \Log::info($request->input('docusign_api_token'));
        set_site_config('docusign_api_url', $request->input('docusign_api_url'));
        set_site_config('docusign_api_token', $request->input('docusign_api_token'));

        set_site_config('js_frontend', $request->input('js_frontend'));
        set_site_config('js_backend', $request->input('js_backend'));

        set_site_config('lead_create_next_followup_mandate', $request->input('lead_create_next_followup_mandate'));

        if ($request->hasFile('sample_cv')) {
            $file = $request->sample_cv->getClientOriginalName();
            $filename = pathinfo($file, PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 50) {
                $filename = substr($filename, 0, 50);
            }
            $filename = $filename . '_' . rand(10000, 99999) . "." . $request->sample_cv->getClientOriginalExtension();
            $sample_cv = $request->file('sample_cv')->storeAs('/sample', $filename, 'public');
            set_site_config('sample_cv', $sample_cv);
        }
        if ($request->hasFile('sample_sop')) {
            $file = $request->sample_sop->getClientOriginalName();
            $filename = pathinfo($file, PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 50) {
                $filename = substr($filename, 0, 50);
            }
            $filename = $filename . '_' . rand(10000, 99999) . "." . $request->sample_sop->getClientOriginalExtension();
            $sample_sop = $request->file('sample_sop')->storeAs('/sample', $filename, 'public');
            set_site_config('sample_sop', $sample_sop);
        }
        if ($request->hasFile('sample_professional_lor')) {
            $file = $request->sample_professional_lor->getClientOriginalName();
            $filename = pathinfo($file, PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 50) {
                $filename = substr($filename, 0, 50);
            }
            $filename = $filename . '_' . rand(10000, 99999) . "." . $request->sample_professional_lor->getClientOriginalExtension();
            $sample_professional_lor = $request->file('sample_professional_lor')->storeAs('/uploads', $filename, 'public');
            set_site_config('sample_professional_lor', $sample_professional_lor);
        }
        if ($request->hasFile('sample_academic_lor')) {
            $file = $request->sample_academic_lor->getClientOriginalName();
            $filename = pathinfo($file, PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 50) {
                $filename = substr($filename, 0, 50);
            }
            $filename = $filename . '_' . rand(10000, 99999) . "." . $request->sample_academic_lor->getClientOriginalExtension();
            $sample_academic_lor = $request->file('sample_academic_lor')->storeAs('/uploads', $filename, 'public');
            set_site_config('sample_academic_lor', $sample_academic_lor);
        }
        if ($request->hasFile('sample_mou')) {
            $file = $request->sample_mou->getClientOriginalName();
            $filename = pathinfo($file, PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 50) {
                $filename = substr($filename, 0, 50);
            }
            $filename = $filename . '_' . rand(10000, 99999) . "." . $request->sample_mou->getClientOriginalExtension();
            $sample_mou = $request->file('sample_mou')->storeAs('/uploads', $filename, 'public');
            set_site_config('sample_mou', $sample_mou);
        }

        //employment configuration
         if($request->input('employee_department')){
            $department = explode("|" ,trim($request->input('employee_department')) );
            set_site_config('employee_department', $request->input('employee_department')); 

        }
        if($request->input('employee_designation')){
            $designation = explode("|" ,trim($request->input('employee_designation')) );
            set_site_config('employee_designation', $request->input('employee_designation')); 

        }
        if($request->input('employee_type')){
            $empType = explode("|" ,trim($request->input('employee_type')) );
            set_site_config('employee_type', $request->input('employee_type')); 

        }
        if($request->input('employee_status')){
            $empStatus = explode("|" ,trim($request->input('employee_status')) );
            set_site_config('employee_status', $request->input('employee_status')); 

        }
        if($request->input('onboarding_status')){
            $onboardingStatus = explode("|" ,trim($request->input('onboarding_status')) );
            set_site_config('onboarding_status', $request->input('onboarding_status')); 

        }
        
        //Event notification emails
        if($request->input('event_notification_email')) {
            $event_emails = explode(",", trim($request->input('event_notification_email')));
            if(count($event_emails)) {
                if(count($event_emails) > 3) {
                    return redirect('admin/settings#advanced')->withFlashDanger('Event notification emails cannot be more than 3');                    
                }
                $event_notification_email = "";
                foreach($event_emails as $email) {
                    $email = trim($email);
                    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                        return redirect('admin/settings#advanced')->withFlashDanger('Invalid event notification email:'.$email);            
                    }
                    $event_notification_email .= ",".$email;
                }
                $event_notification_email = substr($event_notification_email, 1);
                set_site_config('event_notification_email', $event_notification_email);
            } else {
                set_site_config('event_notification_email', "");    
            }
        } else {
            set_site_config('event_notification_email', "");
        }

        //Ticket notification emails
        if($request->input('support_ticket_notification_email')) {
            $ticket_emails = explode(",", trim($request->input('support_ticket_notification_email')));
            if(count($ticket_emails)) {
                if(count($ticket_emails) > 3) {
                    return redirect('admin/settings#advanced')->withFlashDanger('Support Ticket notification emails cannot be more than 3');                    
                }
                $support_ticket_notification_email = "";
                foreach($ticket_emails as $email) {
                    $email = trim($email);
                    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                        return redirect('admin/settings#advanced')->withFlashDanger('Invalid Support Ticket notification email:'.$email);            
                    }
                    $support_ticket_notification_email .= ",".$email;
                }
                $support_ticket_notification_email = substr($support_ticket_notification_email, 1);
                set_site_config('support_ticket_notification_email', $support_ticket_notification_email);
            } else {
                set_site_config('support_ticket_notification_email', "");    
            }
        } else {
            set_site_config('support_ticket_notification_email', "");
        } 
        set_site_config('student_referral_payout_modes', $request->input('student_referral_payout_modes'));      
        set_site_config('student_qualification_levels', $request->input('student_qualification_levels'));       
        set_site_config('student_disqualified_reason', $request->input('student_disqualified_reason'));
        set_site_config('application_apply_through', $request->input('application_apply_through'));
        set_site_config('lead_create_admin_mandatory', $request->input('lead_email_and_mobile'));
        set_site_config('lead_create_web2lead_api_import_mandatory', $request->input('web_api_import_email_and_mobile'));
        set_site_config('student_create_admin_mandatory', $request->input('student_email_and_mobile'));

        set_site_config('recaptcha_site_key', $request->input('recaptcha_site_key'));
        set_site_config('recaptcha_secret_key', $request->input('recaptcha_secret_key'));
        set_site_config('student_signup_captcha', $request->input('student_signup_captcha'));
        set_site_config('agent_signup_captcha', $request->input('agent_signup_captcha'));
        set_site_config('web_to_lead_captcha', $request->input('web_to_lead_captcha'));
        set_site_config('form_builder_captcha', $request->input('form_builder_captcha'));

        set_site_config('essential_js_frontend', $request->input('essential_js_frontend'));
        set_site_config('analytics_performance_js_frontend', $request->input('analytics_performance_js_frontend'));
        set_site_config('marketing_advertising_retargeting_js_frontend', $request->input('marketing_advertising_retargeting_js_frontend'));
        set_site_config('functional_preferences_js_frontend', $request->input('functional_preferences_js_frontend'));

        return redirect('admin/settings#advanced')->withFlashSuccess('Settings saved successfully');
    }

    public function banners()
    {
        $banners = Banners::orderBy('display_order')->get();
        return view('backend.banners.banners_list', compact('banners'));
    }

    public function saveBanner(Request $request)
    {
        $request->validate([
            'banner_file' => 'required_without:id|mimes:jpg,jpeg,gif,png,svg,mp4',
            'display_order' => 'required|numeric',
        ]);

        $banner_file = '';
        if ($request->hasFile('banner_file')) {
            $file = $request->banner_file->getClientOriginalName();
            $filename = pathinfo($file, PATHINFO_FILENAME);
            if (strlen($filename) > 125)
                $filename = substr($filename, 0, 125);

            $filename = $filename . '_' . rand(10000, 99999) . "." . $request->banner_file->getClientOriginalExtension();
            $banner_file = $request->file('banner_file')->storeAs('/banners', $filename, 'public');
        }

        if ($request->input('id')) {
            $banner = Banners::find($request->input('id'));
            $banner->display_order = $request->input('display_order');
            $banner->banner_text = $request->input('banner_text');
            $banner->button_text = $request->input('button_text');
            $banner->banner_link = $request->input('banner_link');
            if ($banner_file) {
                $banner->banner_file = $banner_file;
            }
            $banner->save();
            return redirect()->route('admin.banners')->withFlashSuccess('Banner updated successfully');
        } else {
            $banner = Banners::create([
                'banner_file' => $banner_file,
                'display_order' => $request->input('display_order')
            ]);
            if ($request->input('banner_text')) {
                $banner->banner_text = $request->input('banner_text');
            }
            if ($request->input('button_text')) {
                $banner->button_text = $request->input('button_text');
            }
            if ($request->input('banner_link')) {
                $banner->banner_link = $request->input('banner_link');
            }
            $banner->save();
            return redirect()->route('admin.banners')->withFlashSuccess('Banner added successfully');
        }
    }

    public function editBanner($id)
    {
        $banner = Banners::find($id);
        return view('backend.banners.edit_banner', compact('banner'));
    }

    public function deleteBanner($id)
    {
        $banner = Banners::find($id);
        $banner->delete();
        return redirect()->route('admin.banners')->withFlashSuccess('Banner deleted successfully');
    }

    public function contentBlocks()
    {
        $content_blocks = ContentBlocks::orderBy('id')->get();
        return view('backend.content_blocks.content_blocks_list', compact('content_blocks'));
    }

    public function saveContentBlock(Request $request)
    {
        $request->validate([
            'section' => 'required|unique:content_blocks,section,' . $request->input('id'),
            'content' => 'required',
        ]);

        if ($request->input('id')) {
            $content_block = ContentBlocks::find($request->input('id'));
            $content_block->content = $request->input('content');
            $content_block->save();
            return redirect()->route('admin.content-blocks')->withFlashSuccess('Content updated successfully');
        } else {
            $content_block = ContentBlocks::create([
                'section' => $request->input('section'),
                'content' => $request->input('content')
            ]);
            return redirect()->route('admin.content-blocks')->withFlashSuccess('Content added successfully');
        }
    }

    public function editContentBlock($id)
    {
        $content_block = ContentBlocks::find($id);
        return view('backend.content_blocks.edit_content_block', compact('content_block'));
    }

    public function deleteContentBlock($id)
    {
        $content_block = ContentBlocks::find($id);
        $content_block->delete();
        return redirect()->route('admin.content-blocks')->withFlashSuccess('Content deleted successfully');
    }

    //This function is no longer used
    public function student(Request $request)
    {
        // $cv_mandatory_in_profile = get_site_config('student_cv_mandatory_in_profile');
        $allow_add_new_university_application = get_site_config('student_allow_add_new_university_application');
        $tenth_certificate = get_site_config('student_tenth_certificate');
        $tenth_certificate_mandatory = get_site_config('student_tenth_certificate_mandatory');
        $twelth_certificate = get_site_config('student_twelth_certificate');
        $twelth_certificate_mandatory = get_site_config('student_twelth_certificate_mandatory');
        $diploma = get_site_config('student_diploma');
        $diploma_mandatory = get_site_config('student_diploma_mandatory');

        $bachelors_provisional = get_site_config('student_bachelors_provisional');
        $bachelors_provisional_mandatory = get_site_config('student_bachelors_provisional_mandatory');

        $masters_provisional = get_site_config('student_masters_provisional');
        $masters_provisional_mandatory = get_site_config('student_masters_provisional_mandatory');
        
        $cmm = get_site_config('student_cmm');
        $cmm_mandatory = get_site_config('student_cmm_mandatory');

        $bachelors = get_site_config('student_bachelors');
        $bachelors_mandatory = get_site_config('student_bachelors_mandatory');
        $degree_completion = get_site_config('student_degree_completion');
        $degree_completion_mandatory = get_site_config('student_degree_completion_mandatory');
        $masters_all_semesters = get_site_config('student_masters_all_semesters');
        $masters_all_semesters_mandatory = get_site_config('student_masters_all_semesters_mandatory');
        $masters_completion = get_site_config('student_masters_completion');
        $masters_completion_mandatory = get_site_config('student_masters_completion_mandatory');

        $passport = get_site_config('student_passport');
        $passport_mandatory = get_site_config('student_passport_mandatory');

        $sop = get_site_config('student_sop');
        $sop_mandatory = get_site_config('student_sop_mandatory');

        $lor = get_site_config('student_lor');
        $lor_mandatory = get_site_config('student_lor_mandatory');

        $other_certificate = get_site_config('student_other_certificate');
        $other_certificate_mandatory = get_site_config('student_other_certificate_mandatory');

        $cv = get_site_config('student_cv');
        $cv_mandatory = get_site_config('student_cv_mandatory');

        return view(
            'backend.settings.student',
            [
                // 'cv_mandatory_in_profile' => $cv_mandatory_in_profile,
                'allow_add_new_university_application' => $allow_add_new_university_application,
                'tenth_certificate' => $tenth_certificate,
                'tenth_certificate_mandatory' => $tenth_certificate_mandatory,
                'twelth_certificate' => $twelth_certificate,
                'twelth_certificate_mandatory' => $twelth_certificate_mandatory,
                'diploma' => $diploma,
                'diploma_mandatory' => $diploma_mandatory,
                'bachelors' => $bachelors,
                'passport' => $passport,
                'sop' => $sop,
                'sop_mandatory' => $sop_mandatory,
                'lor' => $lor,
                'cv' => $cv,
                'cv_mandatory' => $cv_mandatory,
                'lor_mandatory' => $lor_mandatory,
                'other_certificate' => $other_certificate,
                'other_certificate_mandatory' => $other_certificate_mandatory,
                'passport_mandatory' => $passport_mandatory,
                'bachelors_mandatory' => $bachelors_mandatory,
                'degree_completion' => $degree_completion,
                'degree_completion_mandatory' => $degree_completion_mandatory,
                'masters_all_semesters' => $masters_all_semesters,
                'masters_all_semesters_mandatory' => $masters_all_semesters_mandatory,
                'masters_completion' => $masters_completion,
                'masters_completion_mandatory' => $masters_completion_mandatory,
                'bachelors_provisional' => $bachelors_provisional,
                'bachelors_provisional_mandatory' => $bachelors_provisional_mandatory,
                'masters_provisional' => $masters_provisional,
                'masters_provisional_mandatory' => $masters_provisional_mandatory,
                'cmm_mandatory' => $cmm_mandatory,
                'cmm' => $cmm

            ]
        );
    }

    //This function is no longer used
    public function saveStudent(Request $request)
    {

        if ($request->input('cv_mandatory_in_profile')) {
            set_site_config('cv_mandatory_in_profile', 1);
        } else {
            set_site_config('cv_mandatory_in_profile', 0);
        }

        if ($request->input('allow_add_new_university_application')) {
            set_site_config('student_allow_add_new_university_application', 1);
        } else {
            set_site_config('student_allow_add_new_university_application', 0);
        }

        // if ($request->input('create_lead_on_student_signup')) {
        //     set_site_config('create_lead_on_student_signup', 1);
        // } else {
        //     set_site_config('create_lead_on_student_signup', 0);
        // }

        if ($request->input('tenth_certificate')) {
            set_site_config('student_tenth_certificate', 1);
        } else {
            set_site_config('student_tenth_certificate', 0);
        }

        if ($request->input('tenth_certificate') && $request->input('tenth_certificate_mandatory')) {
            set_site_config('student_tenth_certificate_mandatory', 1);
        } else {
            set_site_config('student_tenth_certificate_mandatory', 0);
        }

        if ($request->input('twelth_certificate')) {
            set_site_config('student_twelth_certificate', 1);
        } else {
            set_site_config('student_twelth_certificate', 0);
        }

        if ($request->input('twelth_certificate') && $request->input('twelth_certificate_mandatory')) {
            set_site_config('student_twelth_certificate_mandatory', 1);
        } else {
            set_site_config('student_twelth_certificate_mandatory', 0);
        }

        if ($request->input('diploma')) {
            set_site_config('student_diploma', 1);
        } else {
            set_site_config('student_diploma', 0);
        }

        if ($request->input('diploma') && $request->input('diploma_mandatory')) {
            set_site_config('student_diploma_mandatory', 1);
        } else {
            set_site_config('student_diploma_mandatory', 0);
        }

        if ($request->input('passport')) {
            set_site_config('student_passport', 1);
        } else {
            set_site_config('student_passport', 0);
        }

        if ($request->input('passport') && $request->input('passport_mandatory')) {
            set_site_config('student_passport_mandatory', 1);
        } else {
            set_site_config('student_passport_mandatory', 0);
        }

        if ($request->input('other_certificate')) {
            set_site_config('student_other_certificate', 1);
        } else {
            set_site_config('student_other_certificate', 0);
        }

        if ($request->input('other_certificate') && $request->input('other_certificate_mandatory')) {
            set_site_config('student_other_certificate_mandatory', 1);
        } else {
            set_site_config('student_other_certificate_mandatory', 0);
        }

        if ($request->input('sop')) {
            set_site_config('student_sop', 1);
        } else {
            set_site_config('student_sop', 0);
        }

        if ($request->input('sop') && $request->input('sop_mandatory')) {
            set_site_config('student_sop_mandatory', 1);
        } else {
            set_site_config('student_sop_mandatory', 0);
        }

        if ($request->input('cv')) {
            set_site_config('student_cv', 1);
        } else {
            set_site_config('student_cv', 0);
        }

        if ($request->input('cv') && $request->input('cv_mandatory')) {
            set_site_config('student_cv_mandatory', 1);
        } else {
            set_site_config('student_cv_mandatory', 0);
        }

        if ($request->input('lor')) {
            set_site_config('student_lor', 1);
        } else {
            set_site_config('student_lor', 0);
        }

        if ($request->input('lor') && $request->input('lor_mandatory')) {
            set_site_config('student_lor_mandatory', 1);
        } else {
            set_site_config('student_lor_mandatory', 0);
        }

        if ($request->input('bachelors')) {
            set_site_config('student_bachelors', 1);
        } else {
            set_site_config('student_bachelors', 0);
        }

        if ($request->input('bachelors') && $request->input('bachelors_mandatory')) {
            set_site_config('student_bachelors_mandatory', 1);
        } else {
            set_site_config('student_bachelors_mandatory', 0);
        }

        if ($request->input('cmm')) {
            set_site_config('student_cmm', 1);
        } else {
            set_site_config('student_cmm', 0);
        }

        if ($request->input('cmm') && $request->input('cmm_mandatory')) {
            set_site_config('student_cmm_mandatory', 1);
        } else {
            set_site_config('student_cmm_mandatory', 0);
        }


        if ($request->input('bachelors_provisional')) {
            set_site_config('student_bachelors_provisional', 1);
        } else {
            set_site_config('student_bachelors_provisional', 0);
        }

        if ($request->input('bachelors_provisional') && $request->input('bachelors_provisional_mandatory')) {
            set_site_config('student_bachelors_provisional_mandatory', 1);
        } else {
            set_site_config('student_bachelors_provisional_mandatory', 0);
        }

        if ($request->input('masters_provisional')) {
            set_site_config('student_masters_provisional', 1);
        } else {
            set_site_config('student_masters_provisional', 0);
        }

        if ($request->input('masters_provisional') && $request->input('masters_provisional_mandatory')) {
            set_site_config('student_masters_provisional_mandatory', 1);
        } else {
            set_site_config('student_masters_provisional_mandatory', 0);
        }

        if ($request->input('degree_completion')) {
            set_site_config('student_degree_completion', 1);
        } else {
            set_site_config('student_degree_completion', 0);
        }

        if ($request->input('degree_completion') && $request->input('degree_completion_mandatory')) {
            set_site_config('student_degree_completion_mandatory', 1);
        } else {
            set_site_config('student_degree_completion_mandatory', 0);
        }

        if ($request->input('masters_all_semesters')) {
            set_site_config('student_masters_all_semesters', 1);
        } else {
            set_site_config('student_masters_all_semesters', 0);
        }

        if ($request->input('masters_all_semesters') && $request->input('masters_all_semesters_mandatory')) {
            set_site_config('student_masters_all_semesters_mandatory', 1);
        } else {
            set_site_config('student_masters_all_semesters_mandatory', 0);
        }

        if ($request->input('masters_completion')) {
            set_site_config('student_masters_completion', 1);
        } else {
            set_site_config('student_masters_completion', 0);
        }

        if ($request->input('masters_completion') && $request->input('masters_completion_mandatory')) {
            set_site_config('student_masters_completion_mandatory', 1);
        } else {
            set_site_config('student_masters_completion_mandatory', 0);
        }

        return redirect()->route('admin.settings.student')->withFlashSuccess('Student settings saved successfully');
    }

    public function leads(Request $request)
    {
        $status = DB::table('lead_status')
            ->orderBy('display_order', 'asc')
            ->get();
        return view('backend.lead.leads_settings', compact('status'));
    }

    public function removeLeadStatus(Request $request, $status)
    {
        $status = leadStatus::find($status);
        $status->delete();
        DB::table('users')->where('lead_status', $status->status)->update(['lead_status' => ""]);
        
        return redirect()->route('admin.leads-settings')->withFlashSuccess('Status deleted successfully');
    }

    public function saveLeadStatus(Request $request)
    {
        $request->validate([
            'status_name' => 'required',
            'type' => 'required',
            'display_order' => 'required|numeric',
        ]);

        if ($request->input('type') == 'default') {
            $chkType = LeadStatus::where('default', 1)->first();
            if ($chkType) {
                return redirect()->route('admin.leads-settings')->withFlashDanger('Default Lead Status already exists!');
            }
        }
        if ($request->input('type') == 'counselling') {
            $chkType = LeadStatus::where('counselling_status', 1)->first();
            if ($chkType) {
                return redirect()->route('admin.leads-settings')->withFlashDanger('Counselling Lead Status already exists!');
            }
        }
        if ($request->input('type') == 'converted') {
            $chkType = LeadStatus::where('converted_status', 1)->first();
            if ($chkType) {
                return redirect()->route('admin.leads-settings')->withFlashDanger('Converted Lead Status already exists!');
            }
        }
        if ($request->input('type') == 'disqualified') {
            $chkType = LeadStatus::where('disqualified_status', 1)->first();
            if ($chkType) {
                return redirect()->route('admin.leads-settings')->withFlashDanger('Disqualified Lead Status already exists!');
            }
        }

        $stat = LeadStatus::create([
            'status' => $request->input('status_name'),
            'display_order' => $request->input('display_order')
        ]);
        if ($request->input('type') == 'none') {
        }
        if ($request->input('type') == 'default') {
            $stat->default = 1;
        }
        if ($request->input('type') == 'counselling') {
            $stat->counselling_status = 1;
        }
        if ($request->input('type') == 'converted') {
            $stat->converted_status = 1;
        }
        if ($request->input('type') == 'disqualified') {
            $stat->disqualified_status = 1;
        }
        $stat->colorcode = $request->input('color');
        $stat->deadline = ($request->input('deadline'))? $request->input('deadline') : NULL;
        $stat->save();
        return redirect()->route('admin.leads-settings')->withFlashSuccess('Lead Status added successfully');
    }

    public function updateLeadStatus(Request $request){
        $request->validate([
            'color' => 'required',
            'display_order' => 'required|numeric',
        ]);

        if ($request->input('status_id') == '') {
            return redirect()->route('admin.leads-settings')->withFlashDanger('Something went wrong!');
        }

        $stat = LeadStatus::find($request->input('status_id'));
        $stat->deadline = ($request->input('deadline'))? $request->input('deadline') : NULL;
        if($request->input('edit_status') == $stat->status){
            // $stat->status = $request->input('edit_status');
            $stat->display_order = $request->input('display_order');
            $stat->colorcode = $request->input('color');
            $stat->save();
        }else{
            $status = $stat->status;
            $stat->status = $request->input('edit_status');

            $stat->display_order = $request->input('display_order');
            $stat->colorcode = $request->input('color');
            $stat->save();

            DB::table('users')->where('lead_status', $status)->update(['lead_status' => $request->input('edit_status')]);
        }

        return redirect()->route('admin.leads-settings')->withFlashSuccess('Lead Status updated successfully');
    }

    public function updateLeadSettings(Request $request)
    {
        $request->validate([
            'lead_sources' => 'required',
            'lead_disqualified_reason' => 'required',
        ]);
        set_site_config('lead_sources', $request->input('lead_sources'));

        if ($request->input('lead_welcome_email_web2lead')) {
            set_site_config('lead_welcome_email_web2lead', 1);
        } else {
            set_site_config('lead_welcome_email_web2lead', 0);
        }
        if ($request->input('lead_welcome_email_lead_create')) {
            set_site_config('lead_welcome_email_lead_create', 1);
        } else {
            set_site_config('lead_welcome_email_lead_create', 0);
        }
        if ($request->input('lead_status_change_restriction')) {
            set_site_config('lead_followup_mandatory', 1);
        } else {
            set_site_config('lead_followup_mandatory', 0);
        }

        if ($request->input('lead_stage_deadline_missed_notification')) {
            set_site_config('lead_stage_deadline_missed_notification', 1);
        } else {
            set_site_config('lead_stage_deadline_missed_notification', 0);
        }


        if ($request->input('lead_followup_reminder_notification')) {
            set_site_config('lead_followup_reminder_notification', 1);
        } else {
            set_site_config('lead_followup_reminder_notification', 0);
        }
        
        if ($request->input('lead_followup_missed_notification')) {
            set_site_config('lead_followup_missed_notification', 1);
        } else {
            set_site_config('lead_followup_missed_notification', 0);
        }

        if ($request->input('unassigned_lead_notification_lead_age')) {
            set_site_config('unassigned_lead_notification_lead_age', $request->input('unassigned_lead_notification_lead_age'));
        }

        set_site_config('lead_disqualified_reason', $request->input('lead_disqualified_reason'));
        set_site_config('communication_mode', $request->input('communication_mode'));

        return redirect()->route('admin.leads-settings')->withFlashSuccess('Lead Sources updated successfully');
    }

    public function updateDisqualifiedStatus(Request $request){
        $request->validate([
            'lead_disqualified_reason' => 'required',
        ]);
        set_site_config('lead_disqualified_reason', $request->input('lead_disqualified_reason'));

        return redirect()->route('admin.leads-settings')->withFlashSuccess('Lead Disqualified Reason Updated successfully');
    }

    public function masterSetup() {
        $check = DB::table('configs_site')->where('key','like','%setup%')->get();
        return view('backend.settings.master-setup');
    }
    public function masterSetupCheck(Request $req) {
        $res = Arr::exists($req, $req->key);
        if($res){
            DB::table('configs_site')->where('key',$req->key)->update(['value' => 1]);
        }
        else{
            DB::table('configs_site')->where('key',$req->key)->update(['value' => 0]);
        }
        return redirect()->back();
    }
    
    public function emailTestIndividual(Request $request){
        $request->validate([
            'test_email' => "required|email"
        ]);
        
        $test_email = $request->test_email;
        if ($test_email) {
            $subject = "Test";
            $email_message = "Test Message";
            try {
                user_notify($test_email, $subject, $email_message);
                //Mail::to($test_email)->send(new MailSend($subject, $email_message));
                \Log::debug("Mail Successfully Sent. ".$test_email);   
                return redirect()->route("admin.email-smtp")->withFlashSuccess("Email Sent Successfully!");
            } catch (\Exception $e) {
                $err_message = $e->getMessage();
                \Log::debug("Mail Error: (Test Individual Email) ".$err_message);   
                return redirect()->route("admin.email-smtp")->withFlashDanger($err_message);
            }
        }else{
            return redirect()->route("admin.email-smtp")->withFlashDanger("Email Not Found!");
        }
    }

    public function emailTestBulk(Request $request){
        $request->validate([
            'test_email' => "required|email"
        ]);
        
        $test_email = $request->test_email;
        if ($test_email) {
            $subject = "Test";
            $email_message = "Test Message";
            
            if(get_site_config('bulk_smtp_host') && get_site_config('bulk_smtp_port') && get_site_config('bulk_smtp_email') && get_site_config('bulk_smtp_password') && get_site_config('bulk_smtp_connection')){
                try {
                    Mail::mailer('broadcast_smtp')->to($test_email, new MailSend($subject, $email_message));
                    \Log::debug("Queue Mail: (BULK EMAIL TESTING) sending through- BROADCAST_SMTP2");
                    return redirect()->route("admin.settings")->withFlashSuccess("Email Sent Successfully!");
                } catch (\Exception $e) {
                    $err_message = $e->getMessage();
                    \Log::debug("Mail Error: (BULK EMAIL TESTING FAILED) ".$err_message);   
                    return redirect()->route("admin.settings")->withFlashDanger($err_message);
                }
            }else{
                try {
                    //Mail::to($test_email)->send(new MailSend($subject, $email_message));
                    user_notify($test_email, $subject, $email_message);
                    \Log::debug("Mail Successfully Sent. ".$test_email);   
                    return redirect()->route("admin.settings")->withFlashSuccess("Email Sent Successfully!");
                } catch (\Exception $e) {
                    $err_message = $e->getMessage();
                    \Log::debug("Mail Error: (Lead to follow-up) ".$err_message);   
                    return redirect()->route("admin.settings")->withFlashDanger($err_message);
                }
            } 
        }else{
            return redirect()->route("admin.settings")->withFlashDanger("Email Not Found!");
        }
    }

    public function holidays()
    {
        $holidays = DB::table('holidays')->where('date', 'like', date("Y-") . "%")->orderBy('date')->get();
        return view('backend.settings.holidays', compact('holidays'));
    }

    public function holidaysSave(Request $request)
    {
        $dates = $request->input('holidays.date');
        $i = 0;
        if (count($dates)) {
            DB::table('holidays')->where('date', 'like', date("Y-") . "%")->delete();
            foreach ($dates as $date) {
                $event = $request->input('holidays.event.' . $i);
                $i++;
                if ($date && strtotime($date)) {
                    $dt = date("Y-m-d",strtotime($date));
                    DB::table('holidays')->insert(['date' => $dt, 'event' => $event]);
                }
            }
        }
        return redirect()->route('admin.settings.holidays')->withFlashSuccess("Holidays list updated!");
    }

//uni apply agents
    public function uniApplyAgents()
    {
        $agents = UniApplyAgents::orderBy('id')->get();
        return view('backend.settings.uni_apply_agents_list', compact('agents'));
    }

    public function saveuniApplyAgent(Request $request)
    {
        // dd($request->all());
        $request->validate([
            'name' => 'required|unique:uni_apply_agents,name,' . $request->input('id'),
        ]);

        if ($request->input('id')) {
            $agent = UniApplyAgents::find($request->input('id'));
            $agent->name = $request->input('name');
            $agent->phone = $request->input('phone');
            $agent->email = $request->input('email');
            $agent->address = $request->input('address');
            $agent->tax_id = $request->input('tax_id');
            $agent->tax_type = $request->input('tax_type');
            $agent->tax_percent = $request->input('tax_percent');
            $agent->commission_count = $request->input('commission_count');
            $agent->save();
            return redirect()->route('admin.uni-apply-agents')->withFlashSuccess('Agent updated successfully');
        } else {
            $agent = UniApplyAgents::create([
                'name' => $request->input('name'),
                'phone' => $request->input('phone'),
                'email' => $request->input('email'),
                'address' => $request->input('address'),
                'tax_id' => $request->input('tax_id'),
                'tax_type' => $request->input('tax_type'),
                'tax_percent' => $request->input('tax_percent'),
                'commission_count' => $request->input('commission_count'),
            ]);
            return redirect()->route('admin.uni-apply-agents')->withFlashSuccess('Agent added successfully');
        }
    }

    public function edituniApplyAgent($id)
    {
        $agent = UniApplyAgents::find($id);
        return view('backend.settings.edit_uni_apply_agent', compact('agent'));
    }

    public function deleteuniApplyAgent($id)
    {
        $agent = UniApplyAgents::find($id);
        $agent->delete();
        return redirect()->route('admin.uni-apply-agents')->withFlashSuccess('Agent deleted successfully');
    }

    public function metaLead(){
        $meta_lead_assign_to = get_site_config('meta_lead_assign_to');
        $meta_lead_assign_to_branch = get_site_config('meta_lead_assign_to_branch');
        // dd($meta_lead_assign_to);
        $userRepo = new UserRepository();
        $staff = $userRepo->getNonStudentsTrainers();
        $branches = DB::table('branch')->get();
        return view('backend.settings.meta_lead', compact('staff','meta_lead_assign_to','meta_lead_assign_to_branch','branches'));
    }

    public function metaLeadSave(Request $request){
        if ($request->input('meta_lead_assign_to')) {
            set_site_config('meta_lead_assign_to', $request->input('meta_lead_assign_to'));
        }else{
            set_site_config('meta_lead_assign_to', 0);
        }

        if ($request->input('meta_lead_assign_to_branch')) {
            set_site_config('meta_lead_assign_to_branch', $request->input('meta_lead_assign_to_branch'));
        }else{
            set_site_config('meta_lead_assign_to_branch', 0);
        }

        return redirect()->route('admin.meta-lead')->withFlashSuccess('Settings saved successfully');
    }
//uni apply agents
}
