<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Auth\User;
use App\Models\Auth\LeadStatus;
use App\Models\Banners;
use App\Models\Configs;
use App\Models\Auth\NotificationConfigs;
use App\Models\Auth\Posts;
use App\Models\ContentBlocks;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\Auth\CountryStudy;
use App\Repositories\Backend\Auth\UserRepository;
use Illuminate\Support\Arr;

/**
 * Class SettingsNotificationsController.
 */
class SettingsNotificationsController extends Controller
{

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!\Auth::user()->isAdmin()) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }
            return $next($request);
        });
    }

    public function notifications(Request $request)
    {
        // $student_doc_configs = get_site_config('student_doc_configs');
        // $student_doc_configs = json_decode($student_doc_configs, true);

        $notiDatas = NotificationConfigs::get();
        $notiData = array();
        foreach($notiDatas as $data){
            $notiData[$data->event]['email_appl_assignee'] = $data->email_appl_assignee;
            $notiData[$data->event]['email_staff'] = $data->email_staff;
            $notiData[$data->event]['email_staff_manager'] = $data->email_staff_manager;
            $notiData[$data->event]['email_superadmin'] = $data->email_superadmin;
            $notiData[$data->event]['email_agent'] = $data->email_agent;

            $notiData[$data->event]['app_appl_assignee'] = $data->app_appl_assignee;
            $notiData[$data->event]['app_staff'] = $data->app_staff;
            $notiData[$data->event]['app_staff_manager'] = $data->app_staff_manager;
            $notiData[$data->event]['app_superadmin'] = $data->app_superadmin;
            $notiData[$data->event]['app_agent'] = $data->app_agent;
        }

        return view('backend.settings.notifications', compact('notiData'));
    }

    public function saveNotifications(Request $request)
    {
        // dd($request->all());

        // EMAIL NOTIFICATION

        // STUDENT_SIGNUP
        if (isset($request->STUDENT_SIGNUP['email_staff'])) {
            NotificationConfigs::where('event', '=', "STUDENT_SIGNUP")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_SIGNUP")->update(['email_staff' => 0]);
        }
        if (isset($request->STUDENT_SIGNUP['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "STUDENT_SIGNUP")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_SIGNUP")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->STUDENT_SIGNUP['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "STUDENT_SIGNUP")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_SIGNUP")->update(['email_superadmin' => 0]);
        }
        if (isset($request->STUDENT_SIGNUP['email_agent'])) {
            NotificationConfigs::where('event', '=', "STUDENT_SIGNUP")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_SIGNUP")->update(['email_agent' => 0]);
        }

        // LEAD_STUDENT_CREATED
        if (isset($request->LEAD_STUDENT_CREATED['email_staff'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_CREATED")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_CREATED")->update(['email_staff' => 0]);
        }
        if (isset($request->LEAD_STUDENT_CREATED['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_CREATED")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_CREATED")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->LEAD_STUDENT_CREATED['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_CREATED")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_CREATED")->update(['email_superadmin' => 0]);
        }
        if (isset($request->LEAD_STUDENT_CREATED['email_agent'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_CREATED")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_CREATED")->update(['email_agent' => 0]);
        }

        // LEAD_STUDENT_CREATED
        if (isset($request->AGENT_SIGNUP['email_staff'])) {
            NotificationConfigs::where('event', '=', "AGENT_SIGNUP")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "AGENT_SIGNUP")->update(['email_staff' => 0]);
        }
        if (isset($request->AGENT_SIGNUP['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "AGENT_SIGNUP")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "AGENT_SIGNUP")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->AGENT_SIGNUP['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "AGENT_SIGNUP")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "AGENT_SIGNUP")->update(['email_superadmin' => 0]);
        }
        if (isset($request->AGENT_SIGNUP['email_agent'])) {
            NotificationConfigs::where('event', '=', "AGENT_SIGNUP")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "AGENT_SIGNUP")->update(['email_agent' => 0]);
        }

        // LEAD_STUDENT_ASSIGMENT_STAFF
        if (isset($request->LEAD_STUDENT_ASSIGMENT_STAFF['email_staff'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_ASSIGMENT_STAFF")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_ASSIGMENT_STAFF")->update(['email_staff' => 0]);
        }
        if (isset($request->LEAD_STUDENT_ASSIGMENT_STAFF['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_ASSIGMENT_STAFF")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_ASSIGMENT_STAFF")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->LEAD_STUDENT_ASSIGMENT_STAFF['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_ASSIGMENT_STAFF")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_ASSIGMENT_STAFF")->update(['email_superadmin' => 0]);
        }
        if (isset($request->LEAD_STUDENT_ASSIGMENT_STAFF['email_agent'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_ASSIGMENT_STAFF")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_ASSIGMENT_STAFF")->update(['email_agent' => 0]);
        }

        // LEAD_STUDENT_LINK_AGENT
        if (isset($request->LEAD_STUDENT_LINK_AGENT['email_staff'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_LINK_AGENT")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_LINK_AGENT")->update(['email_staff' => 0]);
        }
        if (isset($request->LEAD_STUDENT_LINK_AGENT['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_LINK_AGENT")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_LINK_AGENT")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->LEAD_STUDENT_LINK_AGENT['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_LINK_AGENT")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_LINK_AGENT")->update(['email_superadmin' => 0]);
        }
        if (isset($request->LEAD_STUDENT_LINK_AGENT['email_agent'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_LINK_AGENT")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_LINK_AGENT")->update(['email_agent' => 0]);
        }

        // UNIVERSITY_APPLICATION_CREATED
        if (isset($request->UNIVERSITY_APPLICATION_CREATED['email_staff'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_CREATED")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_CREATED")->update(['email_staff' => 0]);
        }
        if (isset($request->UNIVERSITY_APPLICATION_CREATED['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_CREATED")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_CREATED")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->UNIVERSITY_APPLICATION_CREATED['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_CREATED")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_CREATED")->update(['email_superadmin' => 0]);
        }
        if (isset($request->UNIVERSITY_APPLICATION_CREATED['email_agent'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_CREATED")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_CREATED")->update(['email_agent' => 0]);
        }

        // VISA_AND_SERVICES_APPLICATION_CREATED
        if (isset($request->VISA_AND_SERVICES_APPLICATION_CREATED['email_staff'])) {
            NotificationConfigs::where('event', '=', "VISA_AND_SERVICES_APPLICATION_CREATED")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_AND_SERVICES_APPLICATION_CREATED")->update(['email_staff' => 0]);
        }
        if (isset($request->VISA_AND_SERVICES_APPLICATION_CREATED['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "VISA_AND_SERVICES_APPLICATION_CREATED")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_AND_SERVICES_APPLICATION_CREATED")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->VISA_AND_SERVICES_APPLICATION_CREATED['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "VISA_AND_SERVICES_APPLICATION_CREATED")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_AND_SERVICES_APPLICATION_CREATED")->update(['email_superadmin' => 0]);
        }
        if (isset($request->VISA_AND_SERVICES_APPLICATION_CREATED['email_agent'])) {
            NotificationConfigs::where('event', '=', "VISA_AND_SERVICES_APPLICATION_CREATED")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_AND_SERVICES_APPLICATION_CREATED")->update(['email_agent' => 0]);
        }

        // STUDENT_SUBMIT_APPLICATION
        if (isset($request->STUDENT_SUBMIT_APPLICATION['email_staff'])) {
            NotificationConfigs::where('event', '=', "STUDENT_SUBMIT_APPLICATION")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_SUBMIT_APPLICATION")->update(['email_staff' => 0]);
        }
        if (isset($request->STUDENT_SUBMIT_APPLICATION['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "STUDENT_SUBMIT_APPLICATION")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_SUBMIT_APPLICATION")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->STUDENT_SUBMIT_APPLICATION['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "STUDENT_SUBMIT_APPLICATION")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_SUBMIT_APPLICATION")->update(['email_superadmin' => 0]);
        }
        if (isset($request->STUDENT_SUBMIT_APPLICATION['email_agent'])) {
            NotificationConfigs::where('event', '=', "STUDENT_SUBMIT_APPLICATION")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_SUBMIT_APPLICATION")->update(['email_agent' => 0]);
        }

        // AGENT_COMMISSION_ONLY
        if (isset($request->AGENT_COMMISSION_ONLY['email_staff'])) {
            NotificationConfigs::where('event', '=', "AGENT_COMMISSION_ONLY")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "AGENT_COMMISSION_ONLY")->update(['email_staff' => 0]);
        }
        if (isset($request->AGENT_COMMISSION_ONLY['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "AGENT_COMMISSION_ONLY")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "AGENT_COMMISSION_ONLY")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->AGENT_COMMISSION_ONLY['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "AGENT_COMMISSION_ONLY")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "AGENT_COMMISSION_ONLY")->update(['email_superadmin' => 0]);
        }
        if (isset($request->AGENT_COMMISSION_ONLY['email_agent'])) {
            NotificationConfigs::where('event', '=', "AGENT_COMMISSION_ONLY")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "AGENT_COMMISSION_ONLY")->update(['email_agent' => 0]);
        }

        // SUPPORT_TICKET_CREATION
        if (isset($request->SUPPORT_TICKET_CREATION['email_staff'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_CREATION")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_CREATION")->update(['email_staff' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_CREATION['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_CREATION")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_CREATION")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_CREATION['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_CREATION")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_CREATION")->update(['email_superadmin' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_CREATION['email_agent'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_CREATION")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_CREATION")->update(['email_agent' => 0]);
        }

        // STUDENT_ENROLL_WEBINAR
        if (isset($request->STUDENT_ENROLL_WEBINAR['email_staff'])) {
            NotificationConfigs::where('event', '=', "STUDENT_ENROLL_WEBINAR")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_ENROLL_WEBINAR")->update(['email_staff' => 0]);
        }
        if (isset($request->STUDENT_ENROLL_WEBINAR['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "STUDENT_ENROLL_WEBINAR")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_ENROLL_WEBINAR")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->STUDENT_ENROLL_WEBINAR['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "STUDENT_ENROLL_WEBINAR")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_ENROLL_WEBINAR")->update(['email_superadmin' => 0]);
        }
        if (isset($request->STUDENT_ENROLL_WEBINAR['email_agent'])) {
            NotificationConfigs::where('event', '=', "STUDENT_ENROLL_WEBINAR")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_ENROLL_WEBINAR")->update(['email_agent' => 0]);
        }

        // INVOICE_CREATE_AND_INVOICE_PAYMENT
        if (isset($request->INVOICE_CREATE_AND_INVOICE_PAYMENT['email_staff'])) {
            NotificationConfigs::where('event', '=', "INVOICE_CREATE_AND_INVOICE_PAYMENT")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "INVOICE_CREATE_AND_INVOICE_PAYMENT")->update(['email_staff' => 0]);
        }
        if (isset($request->INVOICE_CREATE_AND_INVOICE_PAYMENT['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "INVOICE_CREATE_AND_INVOICE_PAYMENT")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "INVOICE_CREATE_AND_INVOICE_PAYMENT")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->INVOICE_CREATE_AND_INVOICE_PAYMENT['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "INVOICE_CREATE_AND_INVOICE_PAYMENT")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "INVOICE_CREATE_AND_INVOICE_PAYMENT")->update(['email_superadmin' => 0]);
        }
        if (isset($request->INVOICE_CREATE_AND_INVOICE_PAYMENT['email_agent'])) {
            NotificationConfigs::where('event', '=', "INVOICE_CREATE_AND_INVOICE_PAYMENT")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "INVOICE_CREATE_AND_INVOICE_PAYMENT")->update(['email_agent' => 0]);
        }

        // INVOICE_CREATE_AND_INVOICE_PAYMENT
        if (isset($request->STAFF_LEAVES_APPLY['email_staff'])) {
            NotificationConfigs::where('event', '=', "STAFF_LEAVES_APPLY")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STAFF_LEAVES_APPLY")->update(['email_staff' => 0]);
        }
        if (isset($request->STAFF_LEAVES_APPLY['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "STAFF_LEAVES_APPLY")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STAFF_LEAVES_APPLY")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->STAFF_LEAVES_APPLY['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "STAFF_LEAVES_APPLY")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STAFF_LEAVES_APPLY")->update(['email_superadmin' => 0]);
        }
        if (isset($request->STAFF_LEAVES_APPLY['email_agent'])) {
            NotificationConfigs::where('event', '=', "STAFF_LEAVES_APPLY")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STAFF_LEAVES_APPLY")->update(['email_agent' => 0]);
        }

        // INVOICE_CREATE_AND_INVOICE_PAYMENT
        if (isset($request->STUDENT_STATUS_CHANGE['email_staff'])) {
            NotificationConfigs::where('event', '=', "STUDENT_STATUS_CHANGE")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_STATUS_CHANGE")->update(['email_staff' => 0]);
        }
        if (isset($request->STUDENT_STATUS_CHANGE['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "STUDENT_STATUS_CHANGE")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_STATUS_CHANGE")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->STUDENT_STATUS_CHANGE['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "STUDENT_STATUS_CHANGE")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_STATUS_CHANGE")->update(['email_superadmin' => 0]);
        }
        if (isset($request->STUDENT_STATUS_CHANGE['email_agent'])) {
            NotificationConfigs::where('event', '=', "STUDENT_STATUS_CHANGE")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_STATUS_CHANGE")->update(['email_agent' => 0]);
        }

        // LEAD_STATUS_CHANGE
        if (isset($request->LEAD_STATUS_CHANGE['email_staff'])) {
            NotificationConfigs::where('event', '=', "LEAD_STATUS_CHANGE")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STATUS_CHANGE")->update(['email_staff' => 0]);
        }
        if (isset($request->LEAD_STATUS_CHANGE['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "LEAD_STATUS_CHANGE")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STATUS_CHANGE")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->LEAD_STATUS_CHANGE['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "LEAD_STATUS_CHANGE")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STATUS_CHANGE")->update(['email_superadmin' => 0]);
        }
        if (isset($request->LEAD_STATUS_CHANGE['email_agent'])) {
            NotificationConfigs::where('event', '=', "LEAD_STATUS_CHANGE")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STATUS_CHANGE")->update(['email_agent' => 0]);
        }

        // LEAD_PROFILE_UPDATED_BY_STAFF
        // if (isset($request->LEAD_PROFILE_UPDATED_BY_STAFF['email_staff'])) {
        //     NotificationConfigs::where('event', '=', "LEAD_PROFILE_UPDATED_BY_STAFF")->update(['email_staff' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "LEAD_PROFILE_UPDATED_BY_STAFF")->update(['email_staff' => 0]);
        // }
        // if (isset($request->LEAD_PROFILE_UPDATED_BY_STAFF['email_staff_manager'])) {
        //     NotificationConfigs::where('event', '=', "LEAD_PROFILE_UPDATED_BY_STAFF")->update(['email_staff_manager' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "LEAD_PROFILE_UPDATED_BY_STAFF")->update(['email_staff_manager' => 0]);
        // }
        // if (isset($request->LEAD_PROFILE_UPDATED_BY_STAFF['email_superadmin'])) {
        //     NotificationConfigs::where('event', '=', "LEAD_PROFILE_UPDATED_BY_STAFF")->update(['email_superadmin' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "LEAD_PROFILE_UPDATED_BY_STAFF")->update(['email_superadmin' => 0]);
        // }
        // if (isset($request->LEAD_PROFILE_UPDATED_BY_STAFF['email_agent'])) {
        //     NotificationConfigs::where('event', '=', "LEAD_PROFILE_UPDATED_BY_STAFF")->update(['email_agent' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "LEAD_PROFILE_UPDATED_BY_STAFF")->update(['email_agent' => 0]);
        // }

        //STUDENT_PROFILE_UPDATED
        if (isset($request->STUDENT_PROFILE_UPDATED['email_staff'])) {
            NotificationConfigs::where('event', '=', "STUDENT_PROFILE_UPDATED")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_PROFILE_UPDATED")->update(['email_staff' => 0]);
        }
        if (isset($request->STUDENT_PROFILE_UPDATED['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "STUDENT_PROFILE_UPDATED")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_PROFILE_UPDATED")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->STUDENT_PROFILE_UPDATED['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "STUDENT_PROFILE_UPDATED")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_PROFILE_UPDATED")->update(['email_superadmin' => 0]);
        }
        if (isset($request->STUDENT_PROFILE_UPDATED['email_agent'])) {
            NotificationConfigs::where('event', '=', "STUDENT_PROFILE_UPDATED")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_PROFILE_UPDATED")->update(['email_agent' => 0]);
        }

        // COURSE_SUGGESTED_BY_STAFF
        if (isset($request->COURSE_SUGGESTED_BY_STAFF['email_staff'])) {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_BY_STAFF")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_BY_STAFF")->update(['email_staff' => 0]);
        }
        if (isset($request->COURSE_SUGGESTED_BY_STAFF['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_BY_STAFF")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_BY_STAFF")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->COURSE_SUGGESTED_BY_STAFF['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_BY_STAFF")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_BY_STAFF")->update(['email_superadmin' => 0]);
        }
        if (isset($request->COURSE_SUGGESTED_BY_STAFF['email_agent'])) {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_BY_STAFF")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_BY_STAFF")->update(['email_agent' => 0]);
        }


        //COURSE_PREFERENCE_ADDED_BY_STUDENT
        if (isset($request->COURSE_PREFERENCE_ADDED_BY_STUDENT['email_staff'])) {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STUDENT")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STUDENT")->update(['email_staff' => 0]);
        }
        if (isset($request->COURSE_PREFERENCE_ADDED_BY_STUDENT['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STUDENT")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STUDENT")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->COURSE_PREFERENCE_ADDED_BY_STUDENT['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STUDENT")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STUDENT")->update(['email_superadmin' => 0]);
        }
        if (isset($request->COURSE_PREFERENCE_ADDED_BY_STUDENT['email_agent'])) {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STUDENT")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STUDENT")->update(['email_agent' => 0]);
        }


        //COURSE_PREFERENCE_ADDED_BY_STAFF
        if (isset($request->COURSE_PREFERENCE_ADDED_BY_STAFF['email_staff'])) {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STAFF")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STAFF")->update(['email_staff' => 0]);
        }

        if (isset($request->COURSE_PREFERENCE_ADDED_BY_STAFF['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STAFF")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STAFF")->update(['email_staff_manager' => 0]);
        }

        if (isset($request->COURSE_PREFERENCE_ADDED_BY_STAFF['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STAFF")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STAFF")->update(['email_superadmin' => 0]);
        }
        if (isset($request->COURSE_PREFERENCE_ADDED_BY_STAFF['email_agent'])) {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STAFF")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STAFF")->update(['email_agent' => 0]);
        }

        //COURSE_BOOKMARKED_BY_STUDENT
        if (isset($request->COURSE_BOOKMARKED_BY_STUDENT['email_staff'])) {
            NotificationConfigs::where('event', '=', "COURSE_BOOKMARKED_BY_STUDENT")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_BOOKMARKED_BY_STUDENT")->update(['email_staff' => 0]);
        }
        if (isset($request->COURSE_BOOKMARKED_BY_STUDENT['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "COURSE_BOOKMARKED_BY_STUDENT")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_BOOKMARKED_BY_STUDENT")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->COURSE_BOOKMARKED_BY_STUDENT['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "COURSE_BOOKMARKED_BY_STUDENT")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_BOOKMARKED_BY_STUDENT")->update(['email_superadmin' => 0]);
        }
        if (isset($request->COURSE_BOOKMARKED_BY_STUDENT['email_agent'])) {
            NotificationConfigs::where('event', '=', "COURSE_BOOKMARKED_BY_STUDENT")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_BOOKMARKED_BY_STUDENT")->update(['email_agent' => 0]);
        }

        //DOCUMENT_UPLOAD_BY_STUDENT
        if (isset($request->DOCUMENT_UPLOAD_BY_STUDENT['email_staff'])) {
            NotificationConfigs::where('event', '=', "DOCUMENT_UPLOAD_BY_STUDENT")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "DOCUMENT_UPLOAD_BY_STUDENT")->update(['email_staff' => 0]);
        }
        if (isset($request->DOCUMENT_UPLOAD_BY_STUDENT['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "DOCUMENT_UPLOAD_BY_STUDENT")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "DOCUMENT_UPLOAD_BY_STUDENT")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->DOCUMENT_UPLOAD_BY_STUDENT['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "DOCUMENT_UPLOAD_BY_STUDENT")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "DOCUMENT_UPLOAD_BY_STUDENT")->update(['email_superadmin' => 0]);
        }
        if (isset($request->DOCUMENT_UPLOAD_BY_STUDENT['email_agent'])) {
            NotificationConfigs::where('event', '=', "DOCUMENT_UPLOAD_BY_STUDENT")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "DOCUMENT_UPLOAD_BY_STUDENT")->update(['email_agent' => 0]);
        }

        //COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT
        if (isset($request->COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT['email_staff'])) {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT")->update(['email_staff' => 0]);
        }
        if (isset($request->COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT")->update(['email_superadmin' => 0]);
        }
        if (isset($request->COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT['email_agent'])) {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT")->update(['email_agent' => 0]);
        }

        //UNIVERSITY_APPLICATION_STATUS_CHANGE
        if (isset($request->UNIVERSITY_APPLICATION_STATUS_CHANGE['email_appl_assignee'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_STATUS_CHANGE")->update(['email_appl_assignee' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_STATUS_CHANGE")->update(['email_appl_assignee' => 0]);
        }
        if (isset($request->UNIVERSITY_APPLICATION_STATUS_CHANGE['email_staff'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_STATUS_CHANGE")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_STATUS_CHANGE")->update(['email_staff' => 0]);
        }
        if (isset($request->UNIVERSITY_APPLICATION_STATUS_CHANGE['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_STATUS_CHANGE")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_STATUS_CHANGE")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->UNIVERSITY_APPLICATION_STATUS_CHANGE['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_STATUS_CHANGE")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_STATUS_CHANGE")->update(['email_superadmin' => 0]);
        }
        if (isset($request->UNIVERSITY_APPLICATION_STATUS_CHANGE['email_agent'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_STATUS_CHANGE")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_STATUS_CHANGE")->update(['email_agent' => 0]);
        }

        //UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT
        if (isset($request->UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT['email_appl_assignee'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT")->update(['email_appl_assignee' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT")->update(['email_appl_assignee' => 0]);
        }
        if (isset($request->UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT['email_staff'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT")->update(['email_staff' => 0]);
        }
        if (isset($request->UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT")->update(['email_superadmin' => 0]);
        }
        if (isset($request->UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT['email_agent'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT")->update(['email_agent' => 0]);
        }

        //APPLICATION_ASSIGNED_STAFF
        if (isset($request->APPLICATION_ASSIGNED_STAFF['email_appl_assignee'])) {
            NotificationConfigs::where('event', '=', "APPLICATION_ASSIGNED_STAFF")->update(['email_appl_assignee' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "APPLICATION_ASSIGNED_STAFF")->update(['email_appl_assignee' => 0]);
        }
        if (isset($request->APPLICATION_ASSIGNED_STAFF['email_staff'])) {
            NotificationConfigs::where('event', '=', "APPLICATION_ASSIGNED_STAFF")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "APPLICATION_ASSIGNED_STAFF")->update(['email_staff' => 0]);
        }
        if (isset($request->APPLICATION_ASSIGNED_STAFF['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "APPLICATION_ASSIGNED_STAFF")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "APPLICATION_ASSIGNED_STAFF")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->APPLICATION_ASSIGNED_STAFF['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "APPLICATION_ASSIGNED_STAFF")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "APPLICATION_ASSIGNED_STAFF")->update(['email_superadmin' => 0]);
        }
        if (isset($request->APPLICATION_ASSIGNED_STAFF['email_agent'])) {
            NotificationConfigs::where('event', '=', "APPLICATION_ASSIGNED_STAFF")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "APPLICATION_ASSIGNED_STAFF")->update(['email_agent' => 0]);
        }

        //VISA_OTHER_APPLICATION_STATUS_CHANGE
        if (isset($request->VISA_OTHER_APPLICATION_STATUS_CHANGE['email_appl_assignee'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_STATUS_CHANGE")->update(['email_appl_assignee' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_STATUS_CHANGE")->update(['email_appl_assignee' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_STATUS_CHANGE['email_staff'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_STATUS_CHANGE")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_STATUS_CHANGE")->update(['email_staff' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_STATUS_CHANGE['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_STATUS_CHANGE")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_STATUS_CHANGE")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_STATUS_CHANGE['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_STATUS_CHANGE")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_STATUS_CHANGE")->update(['email_superadmin' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_STATUS_CHANGE['email_agent'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_STATUS_CHANGE")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_STATUS_CHANGE")->update(['email_agent' => 0]);
        }
    
        //VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT
        if (isset($request->VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT['email_appl_assignee'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT")->update(['email_appl_assignee' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT")->update(['email_appl_assignee' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT['email_staff'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT")->update(['email_staff' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT")->update(['email_superadmin' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT['email_agent'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT")->update(['email_agent' => 0]);
        }

        //VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT
        if (isset($request->VISA_OTHER_APPLICATION_ASSIGNED_STAFF['email_appl_assignee'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_ASSIGNED_STAFF")->update(['email_appl_assignee' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_ASSIGNED_STAFF")->update(['email_appl_assignee' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_ASSIGNED_STAFF['email_staff'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_ASSIGNED_STAFF")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_ASSIGNED_STAFF")->update(['email_staff' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_ASSIGNED_STAFF['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_ASSIGNED_STAFF")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_ASSIGNED_STAFF")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_ASSIGNED_STAFF['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_ASSIGNED_STAFF")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_ASSIGNED_STAFF")->update(['email_superadmin' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_ASSIGNED_STAFF['email_agent'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_ASSIGNED_STAFF")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_ASSIGNED_STAFF")->update(['email_agent' => 0]);
        }


        //SUPPORT_TICKET_ASSIGNED_TO_STAFF
        if (isset($request->SUPPORT_TICKET_ASSIGNED_TO_STAFF['email_staff'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_ASSIGNED_TO_STAFF")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_ASSIGNED_TO_STAFF")->update(['email_staff' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_ASSIGNED_TO_STAFF['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_ASSIGNED_TO_STAFF")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_ASSIGNED_TO_STAFF")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_ASSIGNED_TO_STAFF['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_ASSIGNED_TO_STAFF")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_ASSIGNED_TO_STAFF")->update(['email_superadmin' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_ASSIGNED_TO_STAFF['email_agent'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_ASSIGNED_TO_STAFF")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_ASSIGNED_TO_STAFF")->update(['email_agent' => 0]);
        }

        //SUPPORT_TICKET_REPLY_RECEIVED
        if (isset($request->SUPPORT_TICKET_REPLY_RECEIVED['email_staff'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_REPLY_RECEIVED")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_REPLY_RECEIVED")->update(['email_staff' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_REPLY_RECEIVED['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_REPLY_RECEIVED")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_REPLY_RECEIVED")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_REPLY_RECEIVED['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_REPLY_RECEIVED")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_REPLY_RECEIVED")->update(['email_superadmin' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_REPLY_RECEIVED['email_agent'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_REPLY_RECEIVED")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_REPLY_RECEIVED")->update(['email_agent' => 0]);
        }

        //SUPPORT_TICKET_STATUS_CHANGE
        if (isset($request->SUPPORT_TICKET_STATUS_CHANGE['email_staff'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_STATUS_CHANGE")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_STATUS_CHANGE")->update(['email_staff' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_STATUS_CHANGE['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_STATUS_CHANGE")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_STATUS_CHANGE")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_STATUS_CHANGE['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_STATUS_CHANGE")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_STATUS_CHANGE")->update(['email_superadmin' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_STATUS_CHANGE['email_agent'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_STATUS_CHANGE")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_STATUS_CHANGE")->update(['email_agent' => 0]);
        }

        //LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE
        if (isset($request->LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE['email_staff'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE")->update(['email_staff' => 0]);
        }
        if (isset($request->LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE")->update(['email_superadmin' => 0]);
        }
        if (isset($request->LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE['email_agent'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE")->update(['email_agent' => 0]);
        }

        //LEAD_STUDENT_ARCHIVED
        // if (isset($request->LEAD_STUDENT_ARCHIVED['email_staff'])) {
        //     NotificationConfigs::where('event', '=', "LEAD_STUDENT_ARCHIVED")->update(['email_staff' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "LEAD_STUDENT_ARCHIVED")->update(['email_staff' => 0]);
        // }
        // if (isset($request->LEAD_STUDENT_ARCHIVED['email_staff_manager'])) {
        //     NotificationConfigs::where('event', '=', "LEAD_STUDENT_ARCHIVED")->update(['email_staff_manager' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "LEAD_STUDENT_ARCHIVED")->update(['email_staff_manager' => 0]);
        // }
        // if (isset($request->LEAD_STUDENT_ARCHIVED['email_superadmin'])) {
        //     NotificationConfigs::where('event', '=', "LEAD_STUDENT_ARCHIVED")->update(['email_superadmin' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "LEAD_STUDENT_ARCHIVED")->update(['email_superadmin' => 0]);
        // }
        // if (isset($request->LEAD_STUDENT_ARCHIVED['email_agent'])) {
        //     NotificationConfigs::where('event', '=', "LEAD_STUDENT_ARCHIVED")->update(['email_agent' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "LEAD_STUDENT_ARCHIVED")->update(['email_agent' => 0]);
        // }

        //APPLICATION_AND_OTHER_DELETE
        // if (isset($request->APPLICATION_AND_OTHER_DELETE['email_staff'])) {
        //     NotificationConfigs::where('event', '=', "APPLICATION_AND_OTHER_DELETE")->update(['email_staff' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "APPLICATION_AND_OTHER_DELETE")->update(['email_staff' => 0]);
        // }
        // if (isset($request->APPLICATION_AND_OTHER_DELETE['email_staff_manager'])) {
        //     NotificationConfigs::where('event', '=', "APPLICATION_AND_OTHER_DELETE")->update(['email_staff_manager' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "APPLICATION_AND_OTHER_DELETE")->update(['email_staff_manager' => 0]);
        // }
        // if (isset($request->APPLICATION_AND_OTHER_DELETE['email_superadmin'])) {
        //     NotificationConfigs::where('event', '=', "APPLICATION_AND_OTHER_DELETE")->update(['email_superadmin' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "APPLICATION_AND_OTHER_DELETE")->update(['email_superadmin' => 0]);
        // }
        // if (isset($request->APPLICATION_AND_OTHER_DELETE['email_agent'])) {
        //     NotificationConfigs::where('event', '=', "APPLICATION_AND_OTHER_DELETE")->update(['email_agent' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "APPLICATION_AND_OTHER_DELETE")->update(['email_agent' => 0]);
        // }

        //INVOICE_DELETE
        if (isset($request->INVOICE_DELETE['email_staff'])) {
            NotificationConfigs::where('event', '=', "INVOICE_DELETE")->update(['email_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "INVOICE_DELETE")->update(['email_staff' => 0]);
        }
        if (isset($request->INVOICE_DELETE['email_staff_manager'])) {
            NotificationConfigs::where('event', '=', "INVOICE_DELETE")->update(['email_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "INVOICE_DELETE")->update(['email_staff_manager' => 0]);
        }
        if (isset($request->INVOICE_DELETE['email_superadmin'])) {
            NotificationConfigs::where('event', '=', "INVOICE_DELETE")->update(['email_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "INVOICE_DELETE")->update(['email_superadmin' => 0]);
        }
        if (isset($request->INVOICE_DELETE['email_agent'])) {
            NotificationConfigs::where('event', '=', "INVOICE_DELETE")->update(['email_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "INVOICE_DELETE")->update(['email_agent' => 0]);
        }

        // -----------------------------------------------------------------------------------------------------------------

        // IN APP NOTIFICATION

        // STUDENT_SIGNUP
        if (isset($request->STUDENT_SIGNUP['app_staff'])) {
            NotificationConfigs::where('event', '=', "STUDENT_SIGNUP")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_SIGNUP")->update(['app_staff' => 0]);
        }
        if (isset($request->STUDENT_SIGNUP['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "STUDENT_SIGNUP")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_SIGNUP")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->STUDENT_SIGNUP['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "STUDENT_SIGNUP")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_SIGNUP")->update(['app_superadmin' => 0]);
        }
        if (isset($request->STUDENT_SIGNUP['app_agent'])) {
            NotificationConfigs::where('event', '=', "STUDENT_SIGNUP")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_SIGNUP")->update(['app_agent' => 0]);
        }

        // LEAD_STUDENT_CREATED
        if (isset($request->LEAD_STUDENT_CREATED['app_staff'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_CREATED")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_CREATED")->update(['app_staff' => 0]);
        }
        if (isset($request->LEAD_STUDENT_CREATED['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_CREATED")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_CREATED")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->LEAD_STUDENT_CREATED['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_CREATED")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_CREATED")->update(['app_superadmin' => 0]);
        }
        if (isset($request->LEAD_STUDENT_CREATED['app_agent'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_CREATED")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_CREATED")->update(['app_agent' => 0]);
        }

        // LEAD_STUDENT_CREATED
        if (isset($request->AGENT_SIGNUP['app_staff'])) {
            NotificationConfigs::where('event', '=', "AGENT_SIGNUP")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "AGENT_SIGNUP")->update(['app_staff' => 0]);
        }
        if (isset($request->AGENT_SIGNUP['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "AGENT_SIGNUP")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "AGENT_SIGNUP")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->AGENT_SIGNUP['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "AGENT_SIGNUP")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "AGENT_SIGNUP")->update(['app_superadmin' => 0]);
        }
        if (isset($request->AGENT_SIGNUP['app_agent'])) {
            NotificationConfigs::where('event', '=', "AGENT_SIGNUP")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "AGENT_SIGNUP")->update(['app_agent' => 0]);
        }

        // LEAD_STUDENT_ASSIGMENT_STAFF
        if (isset($request->LEAD_STUDENT_ASSIGMENT_STAFF['app_staff'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_ASSIGMENT_STAFF")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_ASSIGMENT_STAFF")->update(['app_staff' => 0]);
        }
        if (isset($request->LEAD_STUDENT_ASSIGMENT_STAFF['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_ASSIGMENT_STAFF")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_ASSIGMENT_STAFF")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->LEAD_STUDENT_ASSIGMENT_STAFF['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_ASSIGMENT_STAFF")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_ASSIGMENT_STAFF")->update(['app_superadmin' => 0]);
        }
        if (isset($request->LEAD_STUDENT_ASSIGMENT_STAFF['app_agent'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_ASSIGMENT_STAFF")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_ASSIGMENT_STAFF")->update(['app_agent' => 0]);
        }

        // LEAD_STUDENT_LINK_AGENT
        if (isset($request->LEAD_STUDENT_LINK_AGENT['app_staff'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_LINK_AGENT")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_LINK_AGENT")->update(['app_staff' => 0]);
        }
        if (isset($request->LEAD_STUDENT_LINK_AGENT['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_LINK_AGENT")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_LINK_AGENT")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->LEAD_STUDENT_LINK_AGENT['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_LINK_AGENT")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_LINK_AGENT")->update(['app_superadmin' => 0]);
        }
        if (isset($request->LEAD_STUDENT_LINK_AGENT['app_agent'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_LINK_AGENT")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_LINK_AGENT")->update(['app_agent' => 0]);
        }

        // UNIVERSITY_APPLICATION_CREATED
        if (isset($request->UNIVERSITY_APPLICATION_CREATED['app_staff'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_CREATED")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_CREATED")->update(['app_staff' => 0]);
        }
        if (isset($request->UNIVERSITY_APPLICATION_CREATED['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_CREATED")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_CREATED")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->UNIVERSITY_APPLICATION_CREATED['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_CREATED")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_CREATED")->update(['app_superadmin' => 0]);
        }
        if (isset($request->UNIVERSITY_APPLICATION_CREATED['app_agent'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_CREATED")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_CREATED")->update(['app_agent' => 0]);
        }

        // VISA_AND_SERVICES_APPLICATION_CREATED
        if (isset($request->VISA_AND_SERVICES_APPLICATION_CREATED['app_staff'])) {
            NotificationConfigs::where('event', '=', "VISA_AND_SERVICES_APPLICATION_CREATED")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_AND_SERVICES_APPLICATION_CREATED")->update(['app_staff' => 0]);
        }
        if (isset($request->VISA_AND_SERVICES_APPLICATION_CREATED['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "VISA_AND_SERVICES_APPLICATION_CREATED")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_AND_SERVICES_APPLICATION_CREATED")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->VISA_AND_SERVICES_APPLICATION_CREATED['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "VISA_AND_SERVICES_APPLICATION_CREATED")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_AND_SERVICES_APPLICATION_CREATED")->update(['app_superadmin' => 0]);
        }
        if (isset($request->VISA_AND_SERVICES_APPLICATION_CREATED['app_agent'])) {
            NotificationConfigs::where('event', '=', "VISA_AND_SERVICES_APPLICATION_CREATED")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_AND_SERVICES_APPLICATION_CREATED")->update(['app_agent' => 0]);
        }

        // STUDENT_SUBMIT_APPLICATION
        if (isset($request->STUDENT_SUBMIT_APPLICATION['app_staff'])) {
            NotificationConfigs::where('event', '=', "STUDENT_SUBMIT_APPLICATION")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_SUBMIT_APPLICATION")->update(['app_staff' => 0]);
        }
        if (isset($request->STUDENT_SUBMIT_APPLICATION['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "STUDENT_SUBMIT_APPLICATION")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_SUBMIT_APPLICATION")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->STUDENT_SUBMIT_APPLICATION['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "STUDENT_SUBMIT_APPLICATION")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_SUBMIT_APPLICATION")->update(['app_superadmin' => 0]);
        }
        if (isset($request->STUDENT_SUBMIT_APPLICATION['app_agent'])) {
            NotificationConfigs::where('event', '=', "STUDENT_SUBMIT_APPLICATION")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_SUBMIT_APPLICATION")->update(['app_agent' => 0]);
        }

        // AGENT_COMMISSION_ONLY
        if (isset($request->AGENT_COMMISSION_ONLY['app_staff'])) {
            NotificationConfigs::where('event', '=', "AGENT_COMMISSION_ONLY")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "AGENT_COMMISSION_ONLY")->update(['app_staff' => 0]);
        }
        if (isset($request->AGENT_COMMISSION_ONLY['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "AGENT_COMMISSION_ONLY")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "AGENT_COMMISSION_ONLY")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->AGENT_COMMISSION_ONLY['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "AGENT_COMMISSION_ONLY")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "AGENT_COMMISSION_ONLY")->update(['app_superadmin' => 0]);
        }
        if (isset($request->AGENT_COMMISSION_ONLY['app_agent'])) {
            NotificationConfigs::where('event', '=', "AGENT_COMMISSION_ONLY")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "AGENT_COMMISSION_ONLY")->update(['app_agent' => 0]);
        }

        // SUPPORT_TICKET_CREATION
        if (isset($request->SUPPORT_TICKET_CREATION['app_staff'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_CREATION")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_CREATION")->update(['app_staff' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_CREATION['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_CREATION")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_CREATION")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_CREATION['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_CREATION")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_CREATION")->update(['app_superadmin' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_CREATION['app_agent'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_CREATION")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_CREATION")->update(['app_agent' => 0]);
        }

        // STUDENT_ENROLL_WEBINAR
        if (isset($request->STUDENT_ENROLL_WEBINAR['app_staff'])) {
            NotificationConfigs::where('event', '=', "STUDENT_ENROLL_WEBINAR")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_ENROLL_WEBINAR")->update(['app_staff' => 0]);
        }
        if (isset($request->STUDENT_ENROLL_WEBINAR['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "STUDENT_ENROLL_WEBINAR")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_ENROLL_WEBINAR")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->STUDENT_ENROLL_WEBINAR['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "STUDENT_ENROLL_WEBINAR")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_ENROLL_WEBINAR")->update(['app_superadmin' => 0]);
        }
        if (isset($request->STUDENT_ENROLL_WEBINAR['app_agent'])) {
            NotificationConfigs::where('event', '=', "STUDENT_ENROLL_WEBINAR")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_ENROLL_WEBINAR")->update(['app_agent' => 0]);
        }

        // INVOICE_CREATE_AND_INVOICE_PAYMENT
        if (isset($request->INVOICE_CREATE_AND_INVOICE_PAYMENT['app_staff'])) {
            NotificationConfigs::where('event', '=', "INVOICE_CREATE_AND_INVOICE_PAYMENT")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "INVOICE_CREATE_AND_INVOICE_PAYMENT")->update(['app_staff' => 0]);
        }
        if (isset($request->INVOICE_CREATE_AND_INVOICE_PAYMENT['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "INVOICE_CREATE_AND_INVOICE_PAYMENT")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "INVOICE_CREATE_AND_INVOICE_PAYMENT")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->INVOICE_CREATE_AND_INVOICE_PAYMENT['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "INVOICE_CREATE_AND_INVOICE_PAYMENT")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "INVOICE_CREATE_AND_INVOICE_PAYMENT")->update(['app_superadmin' => 0]);
        }
        if (isset($request->INVOICE_CREATE_AND_INVOICE_PAYMENT['app_agent'])) {
            NotificationConfigs::where('event', '=', "INVOICE_CREATE_AND_INVOICE_PAYMENT")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "INVOICE_CREATE_AND_INVOICE_PAYMENT")->update(['app_agent' => 0]);
        }

        // INVOICE_CREATE_AND_INVOICE_PAYMENT
        if (isset($request->STAFF_LEAVES_APPLY['app_staff'])) {
            NotificationConfigs::where('event', '=', "STAFF_LEAVES_APPLY")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STAFF_LEAVES_APPLY")->update(['app_staff' => 0]);
        }
        if (isset($request->STAFF_LEAVES_APPLY['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "STAFF_LEAVES_APPLY")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STAFF_LEAVES_APPLY")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->STAFF_LEAVES_APPLY['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "STAFF_LEAVES_APPLY")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STAFF_LEAVES_APPLY")->update(['app_superadmin' => 0]);
        }
        if (isset($request->STAFF_LEAVES_APPLY['app_agent'])) {
            NotificationConfigs::where('event', '=', "STAFF_LEAVES_APPLY")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STAFF_LEAVES_APPLY")->update(['app_agent' => 0]);
        }

        // INVOICE_CREATE_AND_INVOICE_PAYMENT
        if (isset($request->STUDENT_STATUS_CHANGE['app_staff'])) {
            NotificationConfigs::where('event', '=', "STUDENT_STATUS_CHANGE")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_STATUS_CHANGE")->update(['app_staff' => 0]);
        }
        if (isset($request->STUDENT_STATUS_CHANGE['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "STUDENT_STATUS_CHANGE")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_STATUS_CHANGE")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->STUDENT_STATUS_CHANGE['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "STUDENT_STATUS_CHANGE")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_STATUS_CHANGE")->update(['app_superadmin' => 0]);
        }
        if (isset($request->STUDENT_STATUS_CHANGE['app_agent'])) {
            NotificationConfigs::where('event', '=', "STUDENT_STATUS_CHANGE")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_STATUS_CHANGE")->update(['app_agent' => 0]);
        }

        // LEAD_STATUS_CHANGE
        if (isset($request->LEAD_STATUS_CHANGE['app_staff'])) {
            NotificationConfigs::where('event', '=', "LEAD_STATUS_CHANGE")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STATUS_CHANGE")->update(['app_staff' => 0]);
        }
        if (isset($request->LEAD_STATUS_CHANGE['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "LEAD_STATUS_CHANGE")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STATUS_CHANGE")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->LEAD_STATUS_CHANGE['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "LEAD_STATUS_CHANGE")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STATUS_CHANGE")->update(['app_superadmin' => 0]);
        }
        if (isset($request->LEAD_STATUS_CHANGE['app_agent'])) {
            NotificationConfigs::where('event', '=', "LEAD_STATUS_CHANGE")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STATUS_CHANGE")->update(['app_agent' => 0]);
        }

        // LEAD_PROFILE_UPDATED_BY_STAFF
        // if (isset($request->LEAD_PROFILE_UPDATED_BY_STAFF['app_staff'])) {
        //     NotificationConfigs::where('event', '=', "LEAD_PROFILE_UPDATED_BY_STAFF")->update(['app_staff' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "LEAD_PROFILE_UPDATED_BY_STAFF")->update(['app_staff' => 0]);
        // }
        // if (isset($request->LEAD_PROFILE_UPDATED_BY_STAFF['app_staff_manager'])) {
        //     NotificationConfigs::where('event', '=', "LEAD_PROFILE_UPDATED_BY_STAFF")->update(['app_staff_manager' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "LEAD_PROFILE_UPDATED_BY_STAFF")->update(['app_staff_manager' => 0]);
        // }
        // if (isset($request->LEAD_PROFILE_UPDATED_BY_STAFF['app_superadmin'])) {
        //     NotificationConfigs::where('event', '=', "LEAD_PROFILE_UPDATED_BY_STAFF")->update(['app_superadmin' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "LEAD_PROFILE_UPDATED_BY_STAFF")->update(['app_superadmin' => 0]);
        // }
        // if (isset($request->LEAD_PROFILE_UPDATED_BY_STAFF['app_agent'])) {
        //     NotificationConfigs::where('event', '=', "LEAD_PROFILE_UPDATED_BY_STAFF")->update(['app_agent' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "LEAD_PROFILE_UPDATED_BY_STAFF")->update(['app_agent' => 0]);
        // }

        //STUDENT_PROFILE_UPDATED
        if (isset($request->STUDENT_PROFILE_UPDATED['app_staff'])) {
            NotificationConfigs::where('event', '=', "STUDENT_PROFILE_UPDATED")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_PROFILE_UPDATED")->update(['app_staff' => 0]);
        }
        if (isset($request->STUDENT_PROFILE_UPDATED['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "STUDENT_PROFILE_UPDATED")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_PROFILE_UPDATED")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->STUDENT_PROFILE_UPDATED['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "STUDENT_PROFILE_UPDATED")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_PROFILE_UPDATED")->update(['app_superadmin' => 0]);
        }
        if (isset($request->STUDENT_PROFILE_UPDATED['app_agent'])) {
            NotificationConfigs::where('event', '=', "STUDENT_PROFILE_UPDATED")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "STUDENT_PROFILE_UPDATED")->update(['app_agent' => 0]);
        }

        // COURSE_SUGGESTED_BY_STAFF
        if (isset($request->COURSE_SUGGESTED_BY_STAFF['app_staff'])) {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_BY_STAFF")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_BY_STAFF")->update(['app_staff' => 0]);
        }
        if (isset($request->COURSE_SUGGESTED_BY_STAFF['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_BY_STAFF")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_BY_STAFF")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->COURSE_SUGGESTED_BY_STAFF['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_BY_STAFF")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_BY_STAFF")->update(['app_superadmin' => 0]);
        }
        if (isset($request->COURSE_SUGGESTED_BY_STAFF['app_agent'])) {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_BY_STAFF")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_BY_STAFF")->update(['app_agent' => 0]);
        }


        //COURSE_PREFERENCE_ADDED_BY_STUDENT
        if (isset($request->COURSE_PREFERENCE_ADDED_BY_STUDENT['app_staff'])) {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STUDENT")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STUDENT")->update(['app_staff' => 0]);
        }
        if (isset($request->COURSE_PREFERENCE_ADDED_BY_STUDENT['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STUDENT")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STUDENT")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->COURSE_PREFERENCE_ADDED_BY_STUDENT['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STUDENT")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STUDENT")->update(['app_superadmin' => 0]);
        }
        if (isset($request->COURSE_PREFERENCE_ADDED_BY_STUDENT['app_agent'])) {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STUDENT")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STUDENT")->update(['app_agent' => 0]);
        }


        //COURSE_PREFERENCE_ADDED_BY_STAFF
        if (isset($request->COURSE_PREFERENCE_ADDED_BY_STAFF['app_staff'])) {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STAFF")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STAFF")->update(['app_staff' => 0]);
        }

        if (isset($request->COURSE_PREFERENCE_ADDED_BY_STAFF['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STAFF")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STAFF")->update(['app_staff_manager' => 0]);
        }

        if (isset($request->COURSE_PREFERENCE_ADDED_BY_STAFF['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STAFF")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STAFF")->update(['app_superadmin' => 0]);
        }
        if (isset($request->COURSE_PREFERENCE_ADDED_BY_STAFF['app_agent'])) {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STAFF")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_PREFERENCE_ADDED_BY_STAFF")->update(['app_agent' => 0]);
        }

        //COURSE_BOOKMARKED_BY_STUDENT
        if (isset($request->COURSE_BOOKMARKED_BY_STUDENT['app_staff'])) {
            NotificationConfigs::where('event', '=', "COURSE_BOOKMARKED_BY_STUDENT")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_BOOKMARKED_BY_STUDENT")->update(['app_staff' => 0]);
        }
        if (isset($request->COURSE_BOOKMARKED_BY_STUDENT['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "COURSE_BOOKMARKED_BY_STUDENT")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_BOOKMARKED_BY_STUDENT")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->COURSE_BOOKMARKED_BY_STUDENT['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "COURSE_BOOKMARKED_BY_STUDENT")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_BOOKMARKED_BY_STUDENT")->update(['app_superadmin' => 0]);
        }
        if (isset($request->COURSE_BOOKMARKED_BY_STUDENT['app_agent'])) {
            NotificationConfigs::where('event', '=', "COURSE_BOOKMARKED_BY_STUDENT")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_BOOKMARKED_BY_STUDENT")->update(['app_agent' => 0]);
        }

        //DOCUMENT_UPLOAD_BY_STUDENT
        if (isset($request->DOCUMENT_UPLOAD_BY_STUDENT['app_staff'])) {
            NotificationConfigs::where('event', '=', "DOCUMENT_UPLOAD_BY_STUDENT")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "DOCUMENT_UPLOAD_BY_STUDENT")->update(['app_staff' => 0]);
        }
        if (isset($request->DOCUMENT_UPLOAD_BY_STUDENT['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "DOCUMENT_UPLOAD_BY_STUDENT")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "DOCUMENT_UPLOAD_BY_STUDENT")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->DOCUMENT_UPLOAD_BY_STUDENT['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "DOCUMENT_UPLOAD_BY_STUDENT")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "DOCUMENT_UPLOAD_BY_STUDENT")->update(['app_superadmin' => 0]);
        }
        if (isset($request->DOCUMENT_UPLOAD_BY_STUDENT['app_agent'])) {
            NotificationConfigs::where('event', '=', "DOCUMENT_UPLOAD_BY_STUDENT")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "DOCUMENT_UPLOAD_BY_STUDENT")->update(['app_agent' => 0]);
        }

        //COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT
        if (isset($request->COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT['app_staff'])) {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT")->update(['app_staff' => 0]);
        }
        if (isset($request->COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT")->update(['app_superadmin' => 0]);
        }
        if (isset($request->COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT['app_agent'])) {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT")->update(['app_agent' => 0]);
        }

        //UNIVERSITY_APPLICATION_STATUS_CHANGE
        if (isset($request->UNIVERSITY_APPLICATION_STATUS_CHANGE['app_appl_assignee'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_STATUS_CHANGE")->update(['app_appl_assignee' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_STATUS_CHANGE")->update(['app_appl_assignee' => 0]);
        }
        if (isset($request->UNIVERSITY_APPLICATION_STATUS_CHANGE['app_staff'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_STATUS_CHANGE")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_STATUS_CHANGE")->update(['app_staff' => 0]);
        }
        if (isset($request->UNIVERSITY_APPLICATION_STATUS_CHANGE['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_STATUS_CHANGE")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_STATUS_CHANGE")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->UNIVERSITY_APPLICATION_STATUS_CHANGE['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_STATUS_CHANGE")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_STATUS_CHANGE")->update(['app_superadmin' => 0]);
        }
        if (isset($request->UNIVERSITY_APPLICATION_STATUS_CHANGE['app_agent'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_STATUS_CHANGE")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_STATUS_CHANGE")->update(['app_agent' => 0]);
        }

        //APPLICATION_ASSIGNED_STAFF
        if (isset($request->APPLICATION_ASSIGNED_STAFF['app_appl_assignee'])) {
            NotificationConfigs::where('event', '=', "APPLICATION_ASSIGNED_STAFF")->update(['app_appl_assignee' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "APPLICATION_ASSIGNED_STAFF")->update(['app_appl_assignee' => 0]);
        }
        if (isset($request->APPLICATION_ASSIGNED_STAFF['app_staff'])) {
            NotificationConfigs::where('event', '=', "APPLICATION_ASSIGNED_STAFF")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "APPLICATION_ASSIGNED_STAFF")->update(['app_staff' => 0]);
        }
        if (isset($request->APPLICATION_ASSIGNED_STAFF['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "APPLICATION_ASSIGNED_STAFF")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "APPLICATION_ASSIGNED_STAFF")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->APPLICATION_ASSIGNED_STAFF['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "APPLICATION_ASSIGNED_STAFF")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "APPLICATION_ASSIGNED_STAFF")->update(['app_superadmin' => 0]);
        }
        if (isset($request->APPLICATION_ASSIGNED_STAFF['app_agent'])) {
            NotificationConfigs::where('event', '=', "APPLICATION_ASSIGNED_STAFF")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "APPLICATION_ASSIGNED_STAFF")->update(['app_agent' => 0]);
        }

        //UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT
        if (isset($request->UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT['app_appl_assignee'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT")->update(['app_appl_assignee' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT")->update(['app_appl_assignee' => 0]);
        }
        if (isset($request->UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT['app_staff'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT")->update(['app_staff' => 0]);
        }
        if (isset($request->UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT")->update(['app_superadmin' => 0]);
        }
        if (isset($request->UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT['app_agent'])) {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT")->update(['app_agent' => 0]);
        }

        //VISA_OTHER_APPLICATION_STATUS_CHANGE
        if (isset($request->VISA_OTHER_APPLICATION_STATUS_CHANGE['app_appl_assignee'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_STATUS_CHANGE")->update(['app_appl_assignee' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_STATUS_CHANGE")->update(['app_appl_assignee' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_STATUS_CHANGE['app_staff'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_STATUS_CHANGE")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_STATUS_CHANGE")->update(['app_staff' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_STATUS_CHANGE['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_STATUS_CHANGE")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_STATUS_CHANGE")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_STATUS_CHANGE['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_STATUS_CHANGE")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_STATUS_CHANGE")->update(['app_superadmin' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_STATUS_CHANGE['app_agent'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_STATUS_CHANGE")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_STATUS_CHANGE")->update(['app_agent' => 0]);
        }
    
        //VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT
        if (isset($request->VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT['app_appl_assignee'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT")->update(['app_appl_assignee' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT")->update(['app_appl_assignee' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT['app_staff'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT")->update(['app_staff' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT")->update(['app_superadmin' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT['app_agent'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT")->update(['app_agent' => 0]);
        }

        // VISA_AND_SERVICES_APPLICATION_CREATED
        if (isset($request->VISA_OTHER_APPLICATION_ASSIGNED_STAFF['app_appl_assignee'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_ASSIGNED_STAFF")->update(['app_appl_assignee' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_ASSIGNED_STAFF")->update(['app_appl_assignee' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_ASSIGNED_STAFF['app_staff'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_ASSIGNED_STAFF")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_ASSIGNED_STAFF")->update(['app_staff' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_ASSIGNED_STAFF['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_ASSIGNED_STAFF")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_ASSIGNED_STAFF")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_ASSIGNED_STAFF['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_ASSIGNED_STAFF")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_ASSIGNED_STAFF")->update(['app_superadmin' => 0]);
        }
        if (isset($request->VISA_OTHER_APPLICATION_ASSIGNED_STAFF['app_agent'])) {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_ASSIGNED_STAFF")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "VISA_OTHER_APPLICATION_ASSIGNED_STAFF")->update(['app_agent' => 0]);
        }


        //SUPPORT_TICKET_ASSIGNED_TO_STAFF
        if (isset($request->SUPPORT_TICKET_ASSIGNED_TO_STAFF['app_staff'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_ASSIGNED_TO_STAFF")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_ASSIGNED_TO_STAFF")->update(['app_staff' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_ASSIGNED_TO_STAFF['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_ASSIGNED_TO_STAFF")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_ASSIGNED_TO_STAFF")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_ASSIGNED_TO_STAFF['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_ASSIGNED_TO_STAFF")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_ASSIGNED_TO_STAFF")->update(['app_superadmin' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_ASSIGNED_TO_STAFF['app_agent'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_ASSIGNED_TO_STAFF")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_ASSIGNED_TO_STAFF")->update(['app_agent' => 0]);
        }

        //SUPPORT_TICKET_REPLY_RECEIVED
        if (isset($request->SUPPORT_TICKET_REPLY_RECEIVED['app_staff'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_REPLY_RECEIVED")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_REPLY_RECEIVED")->update(['app_staff' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_REPLY_RECEIVED['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_REPLY_RECEIVED")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_REPLY_RECEIVED")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_REPLY_RECEIVED['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_REPLY_RECEIVED")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_REPLY_RECEIVED")->update(['app_superadmin' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_REPLY_RECEIVED['app_agent'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_REPLY_RECEIVED")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_REPLY_RECEIVED")->update(['app_agent' => 0]);
        }

        //SUPPORT_TICKET_STATUS_CHANGE
        if (isset($request->SUPPORT_TICKET_STATUS_CHANGE['app_staff'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_STATUS_CHANGE")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_STATUS_CHANGE")->update(['app_staff' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_STATUS_CHANGE['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_STATUS_CHANGE")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_STATUS_CHANGE")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_STATUS_CHANGE['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_STATUS_CHANGE")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_STATUS_CHANGE")->update(['app_superadmin' => 0]);
        }
        if (isset($request->SUPPORT_TICKET_STATUS_CHANGE['app_agent'])) {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_STATUS_CHANGE")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "SUPPORT_TICKET_STATUS_CHANGE")->update(['app_agent' => 0]);
        }

        //LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE
        if (isset($request->LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE['app_staff'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE")->update(['app_staff' => 0]);
        }
        if (isset($request->LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE")->update(['app_superadmin' => 0]);
        }
        if (isset($request->LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE['app_agent'])) {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE")->update(['app_agent' => 0]);
        }

        //LEAD_STUDENT_ARCHIVED
        // if (isset($request->LEAD_STUDENT_ARCHIVED['app_staff'])) {
        //     NotificationConfigs::where('event', '=', "LEAD_STUDENT_ARCHIVED")->update(['email_staff' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "LEAD_STUDENT_ARCHIVED")->update(['email_staff' => 0]);
        // }
        // if (isset($request->LEAD_STUDENT_ARCHIVED['app_staff_manager'])) {
        //     NotificationConfigs::where('event', '=', "LEAD_STUDENT_ARCHIVED")->update(['email_staff_manager' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "LEAD_STUDENT_ARCHIVED")->update(['email_staff_manager' => 0]);
        // }
        // if (isset($request->LEAD_STUDENT_ARCHIVED['app_superadmin'])) {
        //     NotificationConfigs::where('event', '=', "LEAD_STUDENT_ARCHIVED")->update(['email_superadmin' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "LEAD_STUDENT_ARCHIVED")->update(['email_superadmin' => 0]);
        // }
        // if (isset($request->LEAD_STUDENT_ARCHIVED['app_agent'])) {
        //     NotificationConfigs::where('event', '=', "LEAD_STUDENT_ARCHIVED")->update(['email_agent' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "LEAD_STUDENT_ARCHIVED")->update(['email_agent' => 0]);
        // }

        //APPLICATION_AND_OTHER_DELETE
        // if (isset($request->APPLICATION_AND_OTHER_DELETE['app_staff'])) {
        //     NotificationConfigs::where('event', '=', "APPLICATION_AND_OTHER_DELETE")->update(['email_staff' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "APPLICATION_AND_OTHER_DELETE")->update(['email_staff' => 0]);
        // }
        // if (isset($request->APPLICATION_AND_OTHER_DELETE['app_staff_manager'])) {
        //     NotificationConfigs::where('event', '=', "APPLICATION_AND_OTHER_DELETE")->update(['email_staff_manager' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "APPLICATION_AND_OTHER_DELETE")->update(['email_staff_manager' => 0]);
        // }
        // if (isset($request->APPLICATION_AND_OTHER_DELETE['app_superadmin'])) {
        //     NotificationConfigs::where('event', '=', "APPLICATION_AND_OTHER_DELETE")->update(['email_superadmin' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "APPLICATION_AND_OTHER_DELETE")->update(['email_superadmin' => 0]);
        // }
        // if (isset($request->APPLICATION_AND_OTHER_DELETE['app_agent'])) {
        //     NotificationConfigs::where('event', '=', "APPLICATION_AND_OTHER_DELETE")->update(['email_agent' => 1]);
        // } else {
        //     NotificationConfigs::where('event', '=', "APPLICATION_AND_OTHER_DELETE")->update(['email_agent' => 0]);
        // }

        //INVOICE_DELETE
        if (isset($request->INVOICE_DELETE['app_staff'])) {
            NotificationConfigs::where('event', '=', "INVOICE_DELETE")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "INVOICE_DELETE")->update(['app_staff' => 0]);
        }
        if (isset($request->INVOICE_DELETE['app_staff_manager'])) {
            NotificationConfigs::where('event', '=', "INVOICE_DELETE")->update(['app_staff_manager' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "INVOICE_DELETE")->update(['app_staff_manager' => 0]);
        }
        if (isset($request->INVOICE_DELETE['app_superadmin'])) {
            NotificationConfigs::where('event', '=', "INVOICE_DELETE")->update(['app_superadmin' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "INVOICE_DELETE")->update(['app_superadmin' => 0]);
        }
        if (isset($request->INVOICE_DELETE['app_agent'])) {
            NotificationConfigs::where('event', '=', "INVOICE_DELETE")->update(['app_agent' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "INVOICE_DELETE")->update(['app_agent' => 0]);
        }

        // Whatsapp Incoming Message Notification
        if (isset($request->INCOMING_MESSAGES_FROM_WHATSAPP_WEBHOOK['app_staff'])) {
            NotificationConfigs::where('event', '=', "INCOMING_MESSAGES_FROM_WHATSAPP_WEBHOOK")->update(['app_staff' => 1]);
        } else {
            NotificationConfigs::where('event', '=', "INCOMING_MESSAGES_FROM_WHATSAPP_WEBHOOK")->update(['app_staff' => 0]);
        }

        return redirect()->route('admin.settings.notifications')->withFlashSuccess('Notification settings saved successfully');
    }
}
