<?php

namespace App\Http\Controllers\Backend;
use App\Http\Controllers\Controller;
use App\Http\Requests;

use Illuminate\Support\Facades\File;

use App\Models\Auth\Country;
use App\Models\Auth\User;
use App\Models\Auth\Weight;
use App\Models\Auth\ZoneConfig;
use App\Models\Auth\CurrencyRate;
use App\Models\Auth\Zone;
use App\Models\Auth\State;
use App\Models\Auth\ShippingConfigsWeight;
use App\Models\Auth\Shipping;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Mail;
use Redirect;
use Auth;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Validator;

class ShippingConfigurationController extends Controller
{
    public function __construct()
    {
      $this->middleware(function ($request, $next) {
        $user = \Auth::user();
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('training batches'))) {
          return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        return $next($request);
      });
    }


    public function index()
    { 
      
       $module_model = "App\Models\Auth\Shipping";
       $module_name = $module_model::paginate();
       
       return view("backend.shipping.index",compact("module_name"));
    }

    public function shipping_list(){
        $user_id = auth()->user()->id;

        $data = Shipping::latest()->get();
        return Datatables::of($data)
        ->addIndexColumn()
        ->editColumn('name',function($data) {
            return ucfirst($data->name);
        })
        ->addColumn('action', function($data){
          return view('backend.shipping.btn',compact('data'));
        })
        ->rawColumns(['action'])
        ->make(true);

    }


    public function add_shipping(){
      
       $module_model = "App\Models\Auth\Shipping";
      
       $user_id = auth()->user()->id;
       $module_name = $module_model::paginate();
       $zones = Zone::groupBy('zone_name')->pluck('zone_name');
       $currencies = CurrencyRate::get();
       return view(
           "backend.shipping.create",
           compact("module_name",'zones','currencies')
       );
    }

    public function save_shipping(Request $request){
        $validator = Validator::make($request->all(), [
            'ratetype' => 'required',
        ]);

    if ($validator->fails()) {
        $messages = $validator->errors();

        if ($messages->first('ratetype')) {
            return Redirect::back()->withErrors($validator)->withInput()->withFlashDanger('Rate Type is required.');
        }
    }
    
    $type = $request->ratetype;

    if($type == "weight"){
        
    }else{
        // print_r($_POST);exit;
            $validator = Validator::make($request->all(), [
                'name' => 'required',
                'zone' => 'required',
                'amount' => 'required'
        ]);
        
        if ($validator->fails()) {
            $messages = $validator->errors();
            //print_r($messages);exit;
            if ($messages->first('name')) {
                return Redirect::back()->withErrors($validator)->withInput()->withFlashDanger('Configration Name is required.');
            }
        
            if ($messages->first('zone')) {
                return Redirect::back()->withErrors($validator)->withInput()->withFlashDanger('Zone Feild is required.');
            }

            if ($messages->first('amount')) {
                return Redirect::back()->withErrors($validator)->withInput()->withFlashDanger('Amount Feild is required.');
            }
        
        }

        $user_id = auth()->user()->id;
        $previouszones = Shipping::where('seller_id','=',$user_id)->pluck('name');
        $zonename = $request->name;
        //print_r($previouszones);exit;
        if(count($previouszones)>0){
            for($i=0;$i<count($previouszones);$i++){
                if($previouszones[$i] == $zonename){
                    $stat = "overlaped";
                    break;
                }else{
                    $stat = "not";
                }
            }
        }else{
            $stat = "not";
        }
        if ($stat == "overlaped") {
            // echo "overlaped".$stat;exit;
            return Redirect::back()->withErrors($validator)->withInput()->withFlashDanger('Configuraation Sholud not Overlap.');
        }
        //echo  $stat;exit;
        $user_id = auth()->user()->id;
        $zonename = $request->zone;
        $zide = Zone::where('zone_name','=',$zonename)->where('seller_id','=',$user_id)->first();
        //print_r($zide);exit;
        $zoneid = $zide->id;
        $previouszones = Shipping::where('seller_id','=',$user_id)->pluck('zone_id');
        //$zonename = $request->name;
        //print_r($previouszones);exit;
        if(count($previouszones)>0){
            for($i=0;$i<count($previouszones);$i++){
                if($previouszones[$i] == $zoneid){
                    $stat = "overlaped";
                    break;
                }else{
                    $stat = "not";
                }
            }
        }else{
            $stat = "not";
        }

        if ($stat == "overlaped") {
            // echo "overlaped".$stat;exit;
            return Redirect::back()->withErrors($validator)->withInput()->withFlashDanger('Configuraation Sholud not Overlap.');
        }


        $user_id = auth()->user()->id;
        $zonename = $request->zone;
        $zide = Zone::where('zone_name','=',$zonename)->where('seller_id','=',$user_id)->first();
        //print_r($zide);exit;
        $zoneid = $zide->id;
        $previouszones = Shipping::where('seller_id','=',$user_id)->pluck('zone_id');
        //$zonename = $request->name;
        //print_r($previouszones);exit;
        if(count($previouszones)>0){
            for($i=0;$i<count($previouszones);$i++){
                if($previouszones[$i] == $zoneid){
                    $stat = "overlaped";
                    break;
                }else{
                    $stat = "not";
                }
            }
        }else{
            $stat = "not";
        }
        //echo  $stat;exit;
        if ($stat == "overlaped") {
            // echo "overlaped".$stat;exit;
            return Redirect::back()->withErrors($validator)->withInput()->withFlashDanger('Configuraation Sholud not Overlap.');
        }

            $user_id = auth()->user()->id;
            $name = $request->name;
            $zonename = $request->zone;
            $type = $request->ratetype;
            $amount = $request->amount;
            $currency = $request->currency;
            $zide = Zone::where('zone_name','=',$zonename)->where('seller_id','=',$user_id)->first();
            $zoneid = $zide->id;

            $shippingconfig = new Shipping;
            $shippingconfig->name = $name;
            $shippingconfig->seller_id = $user_id;
            $shippingconfig->zone_id = $zoneid;
            $shippingconfig->rate_type = "flat_rate";
            $shippingconfig->flat_rate_value = $amount;
            $shippingconfig->currency = $currency;
            if($request->forfree){
                $forfree = $request->forfree;
                $shippingconfig->has_free_shipping = '1';
                $shippingconfig->free_from = $forfree;
            }
            $shippingconfig->save();

            return redirect()->route("admin.shipping-configuration")->withFlashSuccess('Shipping Configuration Added Successfuly.'); 
            
    }
    }




    public function edit_shipping($id){
             
             $module_model = "App\Models\Auth\Shipping";
             
             $user_id = auth()->user()->id;
             $module_name = $module_model::paginate();
             $zones = Zone::where('seller_id','=',$user_id)->groupBy('zone_name')->get();
             $currencies = CurrencyRate::get();
             $shippingconfigs = Shipping::where('id','=',$id)->where('seller_id','=',$user_id)->first();

             return view(
                 "backend.shipping.edit",
                 compact("module_name",'zones','currencies','shippingconfigs')
             );
    }


    public function update_shipping(Request $request){
      $validator = Validator::make($request->all(), [
        'ratetype' => 'required',
    ]);

    if ($validator->fails()) {
        $messages = $validator->errors();

        if ($messages->first('ratetype')) {
            return Redirect::back()->withErrors($validator)->withInput()->withFlashDanger('Rate Type is required.');
        }
    }
    
    $type = $request->ratetype;

    if($type == "weight"){
 
    }else{
        // print_r($_POST);exit;
        $id = $request->id;
            $validator = Validator::make($request->all(), [
                'name' => 'required',
                'zone' => 'required',
                'amount' => 'required'
        ]);
        
        if ($validator->fails()) {
            $messages = $validator->errors();
            //print_r($messages);exit;
            if ($messages->first('name')) {
                return Redirect::back()->withErrors($validator)->withInput()->withFlashDanger('Configration Name is required.');
            }
        
            if ($messages->first('zone')) {
                return Redirect::back()->withErrors($validator)->withInput()->withFlashDanger('Zone Feild is required.');
            }

            if ($messages->first('amount')) {
                return Redirect::back()->withErrors($validator)->withInput()->withFlashDanger('Amount Feild is required.');
            }
        
        }

        $user_id = auth()->user()->id;
        $previouszones = Shipping::where('seller_id','=',$user_id)->where('id','!=',$id)->pluck('name');
        $zonename = $request->name;
        //print_r($previouszones);exit;
        if(count($previouszones)>0){
            for($i=0;$i<count($previouszones);$i++){
                if($previouszones[$i] == $zonename){
                    $stat = "overlaped";
                    break;
                }else{
                    $stat = "not";
                }
            }
        }else{
            $stat = "not";
        }
        //echo  $stat;exit;
        if ($stat == "overlaped") {
            // echo "overlaped".$stat;exit;
            return Redirect::back()->withErrors($validator)->withInput()->withFlashDanger('Configuraation Sholud not Overlap.');
        }

        $user_id = auth()->user()->id;
        $zonename = $request->zone;
        $zide = Zone::where('zone_name','=',$zonename)->where('seller_id','=',$user_id)->first();
        //print_r($zide);exit;
        $zoneid = $zide->id;
        $previouszones = Shipping::where('seller_id','=',$user_id)->where('id','!=',$id)->pluck('zone_id');
        //$zonename = $request->name;
        //print_r($previouszones);exit;
        if(count($previouszones)>0){
            for($i=0;$i<count($previouszones);$i++){
                if($previouszones[$i] == $zoneid){
                    $stat = "overlaped";
                    break;
                }else{
                    $stat = "not";
                }
            }
        }else{
            $stat = "not";
        }
        //echo  $stat;exit;
        if ($stat == "overlaped") {
            // echo "overlaped".$stat;exit;
            return Redirect::back()->withErrors($validator)->withInput()->withFlashDanger('Configuraation Sholud not Overlap.');
        }

            $user_id = auth()->user()->id;
            $name = $request->name;
            $zonename = $request->zone;
            $type = $request->ratetype;
            $amount = $request->amount;
            $currency = $request->currency;
            $zide = Zone::where('zone_name','=',$zonename)->first();
            $zoneid = $zide->id;

        

            Shipping::where('id','=', $id)
            ->update(['name' => $name ,'seller_id' => $user_id, 'zone_id' => $zoneid,'currency'=>$currency, 'rate_type' => 'flat_rate',
        'flat_rate_value'=>$amount]);
        
        return redirect()->route("admin.shipping-configuration")->withFlashSuccess('Shipping Configuration Updated Successfuly.');    
        }
    }

    public function delete_shipping($id){
        $res = Shipping::where('id','=',$id)->delete();
        return redirect()->route("admin.shipping-configuration")->withFlashSuccess('Shipping Configuration Deleted Successfuly.');
    }

}
