<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Auth\StaffAttendance;
use App\Repositories\Backend\Auth\UserRepository;
use Illuminate\Support\Facades\DB;
use App\Models\StaffBranch;
use App\Repositories\Backend\Auth\StaffRepository;
use Log;

class StaffAttendanceController extends Controller {

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('staff attendance'))) {
                    return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }

            return $next($request);
        });
    }

    public function index() {
        if(!env('STAFF_LEAVES_AND_ATTENDANCE_ENABLE')){
            return redirect()->route('admin.dashboard.message')->withFlashDanger('Staff Attendance is disabled.');
        }

        $userRepo = new StaffRepository();
        $staff = $userRepo->getStaffUsers(get_staff_branch_ids(\Auth::user()->id));
        return view('backend.staff_attendance', ['staff' => $staff]);
    }

    public function ajaxstaffattendance(Request $request)
    {

        if (!$request->ajax()) {
            return redirect()->route('admin.dashboard')->withFlashDanger('You do not have access permission to this page.');
        }
        echo $this->getDatatableStaffAttendanceList($request);
    }

    public function getDatatableStaffAttendanceList($request)
    {
        $columns = array(
            0 => 'date',
            1 => 'first_name',            
            2 => 'details',
            3 => 'work_hours',            
        );

        $select_staff_id = $request->input('assigned_to');
        $date_from = "";
        $date_to = "";
        if (!empty($request->input('daterange'))) {
            $followup_dts_str = $request->input('daterange');
            $followup_dts = explode(" to ", $followup_dts_str);
            $date_from = date("Y-m-d", strtotime($followup_dts[0]));
            $date_to = date("Y-m-d", strtotime($followup_dts[1]));
        }
        \Log::debug('Lead follow dt: ' . $date_from . ' to ' . $date_to);

        $date_range_sql = "AND a.date >= '$date_from' AND a.date <= '$date_to'";

        // $res = DB::select('select c.* from (select a.staff_id, a.date, timediff(b.clock_out,a.clock_in) as work_hrs,a.ip,a.lat,a.`long`,a.location,a.details from staff_attendance a left join staff_attendance b on a.staff_id=b.staff_id and a.date=b.date and b.clock_out IS NOT NULL) as c where c.work_hrs IS NOT NULL');
        if(empty($select_staff_id) && empty($date_from)){
            $res = DB::select('select u.first_name, u.last_name, c.* from (select a.staff_id, a.date, timediff(b.clock_out,a.clock_in) as work_hrs,a.ip,a.lat,a.`long`,a.location,a.details from staff_attendance a left join staff_attendance b on a.staff_id=b.staff_id and a.date=b.date and b.clock_out IS NOT NULL ) as c join users u on u.id=c.staff_id where c.work_hrs IS NOT NULL order by c.date desc, c.staff_id asc');
        } else if(!empty($select_staff_id) && !empty($date_from)){
            $res = DB::select("select u.first_name, u.last_name, c.* from (select a.staff_id, a.date, timediff(b.clock_out,a.clock_in) as work_hrs,a.ip,a.lat,a.`long`,a.location,a.details from staff_attendance a left join staff_attendance b on a.staff_id=b.staff_id and a.date=b.date and b.clock_out IS NOT NULL $date_range_sql WHERE a.staff_id = $select_staff_id) as c join users u on u.id=c.staff_id where c.work_hrs IS NOT NULL order by c.date desc, c.staff_id asc");
        }  else if(!empty($select_staff_id)){
            $res = DB::select('select u.first_name, u.last_name, c.* from (select a.staff_id, a.date, timediff(b.clock_out,a.clock_in) as work_hrs,a.ip,a.lat,a.`long`,a.location,a.details from staff_attendance a left join staff_attendance b on a.staff_id=b.staff_id and a.date=b.date and b.clock_out IS NOT NULL WHERE a.staff_id = '.$select_staff_id.') as c join users u on u.id=c.staff_id where c.work_hrs IS NOT NULL order by c.date desc, c.staff_id asc');
        }else if(!empty($date_from)){
            $res = DB::select("select u.first_name, u.last_name, c.* from (select a.staff_id, a.date, timediff(b.clock_out,a.clock_in) as work_hrs,a.ip,a.lat,a.`long`,a.location,a.details from staff_attendance a left join staff_attendance b on a.staff_id=b.staff_id and a.date=b.date and b.clock_out IS NOT NULL $date_range_sql) as c join users u on u.id=c.staff_id where c.work_hrs IS NOT NULL order by c.date desc, c.staff_id asc");
        }

        $totalData = count($res);
        $totalFiltered = $totalData;
        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');
        //$staff_id = $request->input('staff_id');

        $select_staff_id = $request->input('assigned_to');
        $date_from = "";
        $date_to = "";
        if (!empty($request->input('daterange'))) {
            $followup_dts_str = $request->input('daterange');
            $followup_dts = explode(" to ", $followup_dts_str);
            $date_from = date("Y-m-d", strtotime($followup_dts[0]));
            $date_to = date("Y-m-d", strtotime($followup_dts[1]));
        }
        \Log::debug('Lead follow dt: ' . $date_from . ' to ' . $date_to);

        $date_range_sql = "AND a.date >= '$date_from' AND a.date <= '$date_to'";

        if(empty($select_staff_id) && empty($date_from)){
            $result_rows = DB::select('select u.first_name, u.last_name, c.* from (select a.staff_id, a.date, timediff(b.clock_out,a.clock_in) as work_hrs,a.ip,a.lat,a.`long`,a.location,a.details from staff_attendance a left join staff_attendance b on a.staff_id=b.staff_id and a.date=b.date and b.clock_out IS NOT NULL ) as c join users u on u.id=c.staff_id where c.work_hrs IS NOT NULL order by c.date desc, c.staff_id asc');
        } else if(!empty($select_staff_id) && !empty($date_from)){
            $result_rows = DB::select("select u.first_name, u.last_name, c.* from (select a.staff_id, a.date, timediff(b.clock_out,a.clock_in) as work_hrs,a.ip,a.lat,a.`long`,a.location,a.details from staff_attendance a left join staff_attendance b on a.staff_id=b.staff_id and a.date=b.date and b.clock_out IS NOT NULL $date_range_sql WHERE a.staff_id = $select_staff_id) as c join users u on u.id=c.staff_id where c.work_hrs IS NOT NULL order by c.date desc, c.staff_id asc");
        } else if(!empty($select_staff_id)){
            $result_rows = DB::select('select u.first_name, u.last_name, c.* from (select a.staff_id, a.date, timediff(b.clock_out,a.clock_in) as work_hrs,a.ip,a.lat,a.`long`,a.location,a.details from staff_attendance a left join staff_attendance b on a.staff_id=b.staff_id and a.date=b.date and b.clock_out IS NOT NULL WHERE a.staff_id = '.$select_staff_id.') as c join users u on u.id=c.staff_id where c.work_hrs IS NOT NULL order by c.date desc, c.staff_id asc');
        }else if(!empty($date_from)){
            $result_rows = DB::select("select u.first_name, u.last_name, c.* from (select a.staff_id, a.date, timediff(b.clock_out,a.clock_in) as work_hrs,a.ip,a.lat,a.`long`,a.location,a.details from staff_attendance a left join staff_attendance b on a.staff_id=b.staff_id and a.date=b.date and b.clock_out IS NOT NULL $date_range_sql) as c join users u on u.id=c.staff_id where c.work_hrs IS NOT NULL order by c.date desc, c.staff_id asc");
        }

        // if (empty($request->input('search.value')) && empty($staff_id)) {
        //     Log::debug('TaskActivity:getdata: No search values');
        //     $activity = DB::table('staff_task_activity')
        //         ->join('staff_tasks', 'staff_tasks.id', '=', 'staff_task_activity.task_id')
        //         ->join('users', 'users.id', '=', 'staff_task_activity.staff_id')
        //         ->select('staff_task_activity.created_at','staff_task_activity.comments','staff_task_activity.status','staff_tasks.title','users.first_name','users.last_name')
        //         ->offset($start)
        //         ->limit($limit)
        //         ->orderBy($order, $dir)
        //         ->get();
        // } else {
        //     $get_search = $request->input('search.value');
        //     Log::debug('TaskActivity:getdata: search:' . $get_search);

        //     $activity = DB::table('staff_task_activity')
        //         ->join('staff_tasks', 'staff_tasks.id', '=', 'staff_task_activity.task_id')
        //         ->join('users', 'users.id', '=', 'staff_task_activity.staff_id')
        //         ->select('staff_task_activity.created_at','staff_task_activity.comments','staff_task_activity.status','staff_tasks.title','users.first_name','users.last_name')
        //         ->where(function ($query) use ($get_search) {
        //             $query->Where('staff_task_activity.comments', 'like', "%$get_search%")
        //                 ->orWhere('staff_tasks.title', 'like', "%$get_search%")
        //                 ->orWhere('users.first_name', 'like', "$get_search%")
        //                 ->orWhere('users.last_name', 'like', "$get_search%");
        //         })
        //         ->when(!empty($staff_id), function ($query) use ($staff_id) {
        //             return  $query->Where('staff_task_activity.staff_id', '=', "$staff_id");
        //         })
        //         ->offset($start)
        //         ->limit($limit)
        //         ->orderBy($order, $dir)
        //         ->get();

        //     $totalFiltered = DB::table('staff_task_activity')
        //         ->join('staff_tasks', 'staff_tasks.id', '=', 'staff_task_activity.task_id')
        //         ->join('users', 'users.id', '=', 'staff_task_activity.staff_id')
        //         ->select('staff_task_activity.created_at','staff_task_activity.comments','staff_task_activity.status','staff_tasks.title','users.first_name','users.last_name')
        //         ->where(function ($query) use ($get_search) {
        //             $query->Where('staff_task_activity.comments', 'like', "%$get_search%")
        //                 ->orWhere('staff_tasks.title', 'like', "%$get_search%")
        //                 ->orWhere('users.first_name', 'like', "$get_search%")
        //                 ->orWhere('users.last_name', 'like', "$get_search%");
        //         })
        //         ->when(!empty($staff_id), function ($query) use ($staff_id) {
        //             return  $query->Where('staff_task_activity.staff_id', '=', "$staff_id");
        //         })
        //         ->count();
        // }
            // dd($result_rows);
        $data = $customResult = array();
        if (!empty($result_rows)) {
            $count = 1;
            foreach ($result_rows as $item) {
                // $customResult['id'] = $count++;
                $customResult['staff'] = $item->first_name." ".$item->last_name;
                $customResult['date'] = date("d-M-Y",strtotime($item->date));

                $details = "";
                $clock_in = StaffAttendance::where('staff_id', $item->staff_id)
                ->where('date', $item->date)
                ->whereNotNull('clock_in')->first();
                if($clock_in) {
                    $details .= "<b>In: ".date("d M h:i a",strtotime($clock_in->clock_in))."</b><br> (".$clock_in->details.")";
                }
                $clock_out = StaffAttendance::where('staff_id', $item->staff_id)
                ->where('date', $item->date)
                ->whereNotNull('clock_out')->first();
                if($clock_out) {
                    $details .= "<br><b>Out: ".date("d M h:i a",strtotime($clock_out->clock_out))."</b><br> (".$clock_out->details.")";
                }
                
                $customResult['details'] = $details;
                $customResult['work_hours'] = $item->work_hrs;

                $data[] = $customResult;
            }
        }

        $json_data = array(
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $data
        );

        return json_encode($json_data);
    }


}