<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Auth\Course;
use App\Models\Auth\BatchStudents;
use Illuminate\Foundation\Http\FormRequest;
use App\Repositories\Backend\Auth\RoleRepository;
use App\Repositories\Backend\Auth\PermissionRepository;
use App\Models\Auth\User;
use App\Models\Auth\Branch;
use App\Models\Auth\Batch;
use Illuminate\Support\Facades\Input;
use App\Models\Auth\Trainers;
use App\Http\Requests\Backend\Auth\User\BatchRequest;
use App\Http\Requests\Backend\Auth\User\ManageUserRequest;
use App\Repositories\Backend\Auth\UserRepository;
use App\Models\Auth\TrainerStudentAttendance;

class StudentAttendanceController extends Controller {

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('training classes'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }            
            return $next($request);
        });
    }
        
    public function index() {
        $batch_data = DB::table('trainer_student_attendance')
                ->select('batch.code')
                ->join('users', 'users.id', '=', 'trainer_student_attendance.student_id')
                ->join('batch', 'batch.id', '=', 'trainer_student_attendance.batch_id')
                ->join('courses', 'courses.id', '=', 'batch.course')
                ->get();
        
        return view('backend.student_attendance.student_attendance', ['batch_data'=> $batch_data]);
    }

    public function student_approved($id) {
        $verified = 1;
        $leadupdate = TrainerStudentAttendance::find($id);
        
        $leadupdate->verified = $verified;
        $leadupdate->save();
        return redirect()->route('admin.studentattendance.index')->withFlashSuccess('Attendance Verified Successfully');
        $pages = DB::table('trainer_student_attendance')
                ->select('trainer_student_attendance.date','users.first_name', 'users.last_name', 'batch.code', 'users.mobile', 'courses.title', 'batch.trainer', 'trainer_student_attendance.verified', 'trainer_student_attendance.student_id', 'trainer_student_attendance.id')
                ->join('users', 'users.id', '=', 'trainer_student_attendance.student_id')
                ->join('batch', 'batch.id', '=', 'trainer_student_attendance.batch_id')
                ->join('courses', 'courses.id', '=', 'batch.course')
                ->orderBy('trainer_student_attendance.created_at', "DESC")
                ->get();
        return view('backend.student_attendance.student_attendance', ['pages' => $pages]);
    }
    
    
    public function multiple_student_approved(ManageUserRequest $request) {
        $verified = 1;
        $id_arr = $request->input('id_arr');
        foreach($id_arr as $id){
            if($id > 0){
                $leadupdate = TrainerStudentAttendance::find($id);
                $leadupdate->verified = $verified;
                $leadupdate->save();
            }
        }
        echo '1';
    }
    
    
    public function ajaxattendancedata(ManageUserRequest $request) {
        if (!$request->ajax()) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this page.');
        }
        echo $this->getDatatableAttendance($request);
    }

    
    
    public function getDatatableAttendance($request){
    
        //$columns = array(
        //                    0 =>'id', 
        //                    1 =>'date', 
        //                    2 =>'student_name',
        //                    3=> 'mobile',
        //                    4=> 'code',
        //                    5=> 'title',
        //                    6=> 'trainer',
        //                    7=> 'verified',
        //                    8=> 'action'
        //                );
                
                
        $columns = array(
                            0 =>'id', 
                            1 =>'date', 
                            2 =>'student_name',
                            3=> 'mobile',
                            4=> 'code',
                            5=> 'title',
                            6=> 'trainer',
                            7=> 'verified',
                            8=> 'action'
                        );
                
                
                
        $totalData = DB::table('trainer_student_attendance')
                ->join('users', 'users.id', '=', 'trainer_student_attendance.student_id')
                ->join('batch', 'batch.id', '=', 'trainer_student_attendance.batch_id')
                ->join('courses', 'courses.id', '=', 'batch.course')
                ->count();
                
                
        
        $totalFiltered = $totalData; 
    
        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');
        $batch_code = $request->input('batch_code');
        $status = $request->input('status');
        
        
        
            
        if(empty($request->input('search.value')) && empty($batch_code) && empty($status))
        {                                
            $users = DB::table('trainer_student_attendance')
                    ->select('trainer_student_attendance.date', 'users.id as userid', 'users.first_name', 'users.last_name', 'batch.code', 'users.mobile', 'courses.title', 'batch.trainer', 'trainer_student_attendance.verified', 'trainer_student_attendance.student_id', 'trainer_student_attendance.id')
                    ->join('users', 'users.id', '=', 'trainer_student_attendance.student_id')
                    ->join('batch', 'batch.id', '=', 'trainer_student_attendance.batch_id')
                    ->join('courses', 'courses.id', '=', 'batch.course')
                    ->offset($start)
                    ->limit($limit)
                    ->orderBy($order, $dir)
                    ->get();
                    
        }
        else {
            $get_search = $request->input('search.value');
            
            
            $users = DB::table('trainer_student_attendance')
                    ->select('trainer_student_attendance.date', 'users.id as userid', 'users.first_name', 'users.last_name', 'batch.code', 'users.mobile', 'courses.title', 'batch.trainer', 'trainer_student_attendance.verified', 'trainer_student_attendance.student_id', 'trainer_student_attendance.id')
                    ->join('users', 'users.id', '=', 'trainer_student_attendance.student_id')
                    ->join('batch', 'batch.id', '=', 'trainer_student_attendance.batch_id')
                    ->join('courses', 'courses.id', '=', 'batch.course')
                    ->when(!empty($get_search) , function ($query) use($get_search){
                      return  $query->Where('trainer_student_attendance.date', 'like', "%$get_search%")
                            ->orWhere('users.first_name', 'like', "%$get_search%")
                            ->orWhere('users.last_name', 'like', "%$get_search%")
                            ->orWhere('users.mobile', 'like', "%$get_search%")
                            ->orWhere('batch.code', 'like', "%$get_search%")
                            ->orWhere('courses.title', 'like', "%$get_search%")
                            ->orWhere('batch.trainer', 'like', "%$get_search%");
                    })
                    ->when(!empty($batch_code) , function ($query) use($batch_code){
                      return  $query->Where('batch.code', 'like', "%$batch_code%");
                    })
                    ->when(!empty($status) , function ($query) use($status){
                        $status_val = $status == 1 ? 1 : 0;
                      return  $query->Where('trainer_student_attendance.verified', '=', "$status_val");
                    })                    
                    ->offset($start)
                    ->limit($limit)
                    ->orderBy($order, $dir)
                    ->get();
            
            
                $totalFiltered = DB::table('trainer_student_attendance')
                    ->join('users', 'users.id', '=', 'trainer_student_attendance.student_id')
                    ->join('batch', 'batch.id', '=', 'trainer_student_attendance.batch_id')
                    ->join('courses', 'courses.id', '=', 'batch.course')
                    ->when(!empty($get_search) , function ($query) use($get_search){
                      return  $query->Where('trainer_student_attendance.date', 'like', "%$get_search%")
                            ->orWhere('users.first_name', 'like', "%$get_search%")
                            ->orWhere('users.last_name', 'like', "%$get_search%")
                            ->orWhere('users.mobile', 'like', "%$get_search%")
                            ->orWhere('batch.code', 'like', "%$get_search%")
                            ->orWhere('courses.title', 'like', "%$get_search%")
                            ->orWhere('batch.trainer', 'like', "%$get_search%");
                    })
                    ->when(!empty($batch_code) , function ($query) use($batch_code){
                        return  $query->Where('batch.code', 'like', "%$batch_code%");
                    })
                    ->when(!empty($status) , function ($query) use($status){
                        $status_val = $status == 1 ? 1 : 0;
                        return  $query->Where('trainer_student_attendance.verified', '=', "$status_val");
                    })                    
                    ->count();
            
            
            
            //$users = DB::table('trainer_student_attendance')
            //        ->select('trainer_student_attendance.date', 'users.first_name', 'users.last_name', 'batch.code', 'users.mobile', 'courses.title', 'batch.trainer', 'trainer_student_attendance.verified', 'trainer_student_attendance.student_id', 'trainer_student_attendance.id')
            //        ->join('users', 'users.id', '=', 'trainer_student_attendance.student_id')
            //        ->join('batch', 'batch.id', '=', 'trainer_student_attendance.batch_id')
            //        ->join('courses', 'courses.id', '=', 'batch.course')
            //        ->where(function($query) use ($get_search){
            //            $query->Where('trainer_student_attendance.date', 'like', "%$get_search%")
            //            ->orWhere('users.first_name', 'like', "%$get_search%")
            //            ->orWhere('users.last_name', 'like', "%$get_search%")
            //            ->orWhere('users.mobile', 'like', "%$get_search%")
            //            ->orWhere('batch.code', 'like', "%$get_search%")
            //            ->orWhere('courses.title', 'like', "%$get_search%")
            //            ->orWhere('batch.trainer', 'like', "%$get_search%");
            //        })
            //        ->offset($start)
            //        ->limit($limit)
            //        ->orderBy($order, $dir)
            //        ->get();
                    
                    
            //$totalFiltered = DB::table('trainer_student_attendance')
            //        ->join('users', 'users.id', '=', 'trainer_student_attendance.student_id')
            //        ->join('batch', 'batch.id', '=', 'trainer_student_attendance.batch_id')
            //        ->join('courses', 'courses.id', '=', 'batch.course')
            //        ->where(function($query) use ($get_search){
            //            $query->Where('trainer_student_attendance.date', 'like', "%$get_search%")
            //            ->orWhere('users.first_name', 'like', "%$get_search%")
            //            ->orWhere('users.last_name', 'like', "%$get_search%")
            //            ->orWhere('users.mobile', 'like', "%$get_search%")
            //            ->orWhere('batch.code', 'like', "%$get_search%")
            //            ->orWhere('courses.title', 'like', "%$get_search%")
            //            ->orWhere('batch.trainer', 'like', "%$get_search%");
            //        })
            //        ->count();
        }
        
        $data = array();
        if(!empty($users))
        {
            foreach ($users as $page)
            {
                $customResult['date'] = get_date_formated($page->date);
                $customResult['student_name'] = "<a target='_blank' href='" . route('admin.auth.user.show', $page->id) . "'><strong><span style='white-space:nowrap;'>".$page->first_name.' '.$page->last_name."</a>";
                $customResult['mobile'] = $page->mobile;
                $customResult['code'] = $page->code;
                $customResult['title'] = $page->title;
                $customResult['trainer'] = get_user_full_name_by_id($page->trainer);
                
                $verified_action = '';
                if($page->verified == 0){
                    $verified_action = '<a href="'.route("admin.studentattendance.student_approved",$page->id).'" class="btn btn-primary btn-sm" >Approve</a>';
                    $v_label = 'Not Yet Verified';
                    $customResult['id'] = $page->id;
                }
                else{
                    $verified_action = '<a href="'.route("admin.studentattendance.student_approved",$page->id).'" class="btn btn-secondary btn-sm disabled" onclick="return false;">Approve</a>';
                    $v_label = 'Attendance Verified';
                    $customResult['id'] = '';
                }
                
                $customResult['verified'] = $v_label;
                $customResult['action'] = $verified_action;
                
                $data[] = $customResult;
            }
        }
          
        $json_data = array(
                    "draw"            => intval($request->input('draw')),  
                    "recordsTotal"    => intval($totalData),  
                    "recordsFiltered" => intval($totalFiltered), 
                    "data"            => $data   
                    );
            
        return json_encode($json_data); 
    }    
    
    
    
    
    
}