<?php

namespace App\Http\Controllers\Backend;

use File;
use App\Mail\MailSend;
use App\Models\Auth\User;
use App\Models\UserNotes;
use App\Models\Auth\Batch;
use App\Models\Auth\Branch;
use App\Models\Auth\Course;
use Illuminate\Support\Str;
use App\Models\Auth\Country;
use App\Models\UserActivity;
use Illuminate\Http\Request;
use App\Models\Auth\Trainers;
use App\Models\MailTemplates;
use App\Models\UserDocuEsign;
use Illuminate\Validation\Rule;
use App\Models\Auth\UserDetails;
use App\Models\Auth\Universities;
use App\Models\Auth\BatchStudents;
use App\Recipients\AdminRecipient;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Auth\AgentCommission;
use App\Models\ProfileTravelHistory;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Input;
use App\Models\Auth\UniversityCourses;
use App\Models\Auth\ApplicationActivity;
use App\Notifications\Backend\UserAlert;
use App\Notifications\Frontend\AdminAlert;
use Illuminate\Foundation\Http\FormRequest;
use App\Models\Auth\TrainerStudentAttendance;
use App\Models\ProfileVisaApplicationHistory;
use App\Repositories\Backend\Auth\RoleRepository;
use App\Repositories\Backend\Auth\UserRepository;
use App\Http\Requests\Backend\Auth\User\BatchRequest;
use App\Repositories\Backend\Auth\PermissionRepository;
use App\Http\Requests\Backend\Auth\User\ManageUserRequest;

class StudentProfileController extends Controller
{

    public function __construct(UserRepository $userRepository)
    {
        $this->userRepository = $userRepository;
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('view students'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }
            return $next($request);
        });
    }

    public function appNotification($doc_type, $user_id)
    {
        $user = User::find($user_id);
        if (\Auth::user()->isAgent()) {
            $email_message = "Hi, <br><br>Doc (" . $doc_type . ") uploaded by Agent: " . get_user_full_name_by_id(\Auth::user()->id) .
                "<br>" . _label('backend_student') . ": " . $user->full_name . " (" . $user->id . ")";
            $message = $doc_type . " Doc uploaded by Agent: " . get_user_full_name_by_id(\Auth::user()->id) .
                "<br>" . _label('backend_student') . ": " . $user->full_name . " (" . $user->id . ")";
            $subject = $doc_type . " Doc uploaded by Agent: " . get_user_full_name_by_id(\Auth::user()->id);
        } else {
            $email_message = "Hi, <br><br>Doc (" . $doc_type . ") uploaded by Staff: " . get_user_full_name_by_id(\Auth::user()->id) .
                "<br>" . _label('backend_student') . ": " . $user->full_name . " (" . $user->id . ")";
            $message = $doc_type . " Doc uploaded by staff, " . _label('backend_student') . ": <strong>" . $user->full_name . "</strong> (" . $user->id . ")";
            $subject = $doc_type . " Doc uploaded by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
        }

        // Email Notification
        send_mail_notification($user->id, "", "DOCUMENT_UPLOAD_BY_STUDENT", $subject, $email_message);

        //Sending In App Notification
        $subject = "";
        send_in_app_notification(
            $user->id,
            $user->id,
            "DOCUMENT_UPLOAD_BY_STUDENT",
            $subject,
            $message,
            "student"
        );
    }

    public function edit_student($id)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $user = User::find($id);
        $countries = Country::orderBy('title_en')->select('id', 'title_en as name')->get();
        $profile_academics = DB::table('user_academics')->where('userid', $id)->get();
        $profile_family = DB::table('user_family')->where('userid', $id)->get();
        $profile_employment_details = DB::table('employment_detail')->where('userid', $id)->get();
        $profile_travel_historys = DB::table('travel_history')->where('userid', $id)->get();
        $visa_application_history = DB::table('visa_application_history')->where('user_id', $id)->get();


        $study_countries = Country::where('overseas_status', 1)->orderBy('title_en', 'ASC')->get();

        $academic_years = array();
        $s_yr = date("Y") + 3;
        $e_yr = $s_yr - 60;
        for ($i = $s_yr; $i >= $e_yr; $i--) {
            $academic_years[] = $i;
        }

        $academics = array();
        $rows = DB::table('user_academics')->where('userid', $id)->get();
        foreach ($rows as $row) {
            $academics[$row->education_level]['percent_cgpa'] = $row->percent_cgpa;
            $academics[$row->education_level]['pass_year'] = $row->pass_year;
            $academics[$row->education_level]['specialization'] = $row->specialization;
            $academics[$row->education_level]['school_college'] = $row->school_college;
            $academics[$row->education_level]['university'] = $row->university;
            $academics[$row->education_level]['backlogs'] = $row->backlogs;
        }

        $eng = array();
        $rows = DB::table('user_certification_eng')->where('userid', $id)->get();
        foreach ($rows as $row) {
            $eng[$row->exam]['overall_score'] = $row->overall_score;
            $eng[$row->exam]['speaking'] = $row->speaking;
            $eng[$row->exam]['reading'] = $row->reading;
            $eng[$row->exam]['writing'] = $row->writing;
            $eng[$row->exam]['listening'] = $row->listening;
            $eng[$row->exam]['expiry_date'] = $row->expiry_date;
        }

        $lang = array();
        $rows = DB::table('user_certification_lang')->where('userid', $id)->get();
        foreach ($rows as $row) {
            $lang[$row->language]['level'] = $row->level;
            $lang[$row->language]['overall_score'] = $row->overall_score;
            $lang[$row->language]['speaking'] = $row->speaking;
            $lang[$row->language]['reading'] = $row->reading;
            $lang[$row->language]['writing'] = $row->writing;
            $lang[$row->language]['listening'] = $row->listening;
            $lang[$row->language]['institute'] = $row->institute;
        }

        $exam = array('gre' => array('total_score' => '', 'verbal' => '', 'quantitative' => '', 'analytical' => '', 'integrated' => '', 'expiry_date' => ''), 'gmat' => array('total_score' => '', 'verbal' => '', 'quantitative' => '', 'analytical' => '', 'integrated' => '', 'expiry_date' => ''));
        $rows = DB::table('user_gre_gmat')->where('userid', $id)->get();
        foreach ($rows as $row) {
            if ($row->exam == 'GRE') {
                $exam['gre']['total_score'] = $row->total_score;
                $exam['gre']['verbal'] = $row->verbal;
                $exam['gre']['quantitative'] = $row->quantitative;
                $exam['gre']['analytical'] = $row->analytical;
                $exam['gre']['integrated'] = $row->integrated;
                $exam['gre']['expiry_date'] = $row->expiry_date;
            } elseif ($row->exam == 'GMAT') {
                $exam['gmat']['total_score'] = $row->total_score;
                $exam['gmat']['verbal'] = $row->verbal;
                $exam['gmat']['quantitative'] = $row->quantitative;
                $exam['gmat']['analytical'] = $row->analytical;
                $exam['gmat']['integrated'] = $row->integrated;
                $exam['gmat']['expiry_date'] = $row->expiry_date;
            }
        }
        $internships = array();
        $rows = DB::table('user_internship')->where('userid', $id)->get();
        foreach ($rows as $row) {
            $internships[] = array('id' => $row->id, 'userid' => $row->userid, 'company' => $row->company, 'duration' => $row->duration, 'place' => $row->place);
        }

        $courses = array();
        $rows = DB::table('user_courses')->where('userid', $id)->get();
        foreach ($rows as $row) {
            $courses[] = array('id' => $row->id, 'userid' => $row->userid, 'course' => $row->course, 'duration' => $row->duration, 'hours' => $row->hours, 'institute' => $row->institute);
        }

        $experience = array();
        $rows = DB::table('user_experience')->where('userid', $id)->get();
        foreach ($rows as $row) {
            $experience[] = array('company' => $row->company, 'designation' => $row->designation, 'start_date' => $row->start_date, 'end_date' => $row->end_date);
        }

        $det = DB::table('user_certification_eng')->where('userid', $id)->where('exam', 'DET')->first();
        if ($det) {
            $det_overall_score = $det->overall_score;
            $det_expiry_date = $det->expiry_date;
        } else {
            $det_overall_score = "";
            $det_expiry_date = "";
        }

        $act = DB::table('user_certification_eng')->where('userid', $id)->where('exam', 'ACT')->first();
        if ($act) {
            $act_overall_score = $act->overall_score;
            $act_math = $act->math;
            $act_reading = $act->reading;
            $act_writing = $act->writing;
            $act_science = $act->science;
            $act_english = $act->english;
            $act_expiry_date = $act->expiry_date;
        } else {
            $act_overall_score = "";
            $act_math = "";
            $act_reading = "";
            $act_writing = "";
            $act_science = "";
            $act_english = "";
            $act_expiry_date = "";
        }

        $sat = DB::table('user_certification_eng')->where('userid', $id)->where('exam', 'SAT')->first();
        if ($sat) {
            $sat_overall_score = $sat->overall_score;
            $sat_math = $sat->math;
            $sat_reading = $sat->reading;
            $sat_writing = $sat->writing;
            $sat_essay = $sat->essay;
            $sat_expiry_date = $sat->expiry_date;
        } else {
            $sat_overall_score = "";
            $sat_math = "";
            $sat_reading = "";
            $sat_writing = "";
            $sat_essay = "";
            $sat_expiry_date = "";
        }
        // $dialcodes = Country::groupBy('tel')->orderBy('tel', 'asc')->get(['tel as code', 'title_en as name']);
        $dialcodes = Country::orderBy('country_code', 'asc')->get(['tel as code', 'code as country_code', 'title_en as name']);
        if ($user->is_lead) {
            $custom_attributes = DB::table('custom_attributes')->where('for_lead', 1)->orderBy('display_order', 'asc')->get(["custom_attributes.*"]);
        } else {
            $custom_attributes = DB::table('custom_attributes')->where('for_student', 1)->orderBy('display_order', 'asc')->get(["custom_attributes.*"]);
        }

        $userDetails = DB::table('user_details')->where('userid', $user->id)->first();
        return view('backend.auth.user.edit-student', compact(
            'countries',
            'profile_academics',
            'profile_family',
            'profile_employment_details',
            'academic_years',
            'academics',
            'eng',
            'lang',
            'exam',
            'internships',
            'courses',
            'profile_travel_historys',
            'visa_application_history',
            'experience',
            'user',
            'userDetails',
            'det_overall_score',
            'det_expiry_date',
            'study_countries',
            'act_overall_score',
            'act_math',
            'act_reading',
            'act_writing',
            'act_science',
            'act_english',
            'act_expiry_date',
            'sat_overall_score',
            'sat_math',
            'sat_writing',
            'sat_reading',
            'sat_essay',
            'sat_expiry_date',
            'dialcodes',
            'custom_attributes'
        ));
    }


    /** Profile */
    public function storeBasicProfile(Request $request)
    {
        // dd($request->all());
        $id = $request->get('user_id');
        $request->validate([
            'first_name' => ['required', 'max:50', 'regex:/^[\pL\s]+$/u'],
            'middle_name'  => ['nullable', 'max:50', 'regex:/^[\pL\s]+$/u'],
            'last_name'  => ['required', 'max:50', 'regex:/^[\pL\s]+$/u'],
            'study_level' => ['required'],
            'birthday' => 'nullable|before:' . now()->subYears(16)->toDateString(),
            'gender' => 'required',

            'emergency_name'  => ['nullable', 'max:50', 'regex:/^[\pL\s]+$/u'],
            'emergency_phone'  => 'nullable|numeric|digits_between:' . config('app.USER_MOBILE_MIN_LENGTH') . ',' . config('app.USER_MOBILE_MAX_LENGTH'),
            'emergency_email'  => 'nullable|email',
            'emergency_relation'  => 'nullable|regex:/^[\pL\s]+$/u',
            'emergency_address'  => 'nullable|max:100',
            'emergency_state'  => 'nullable|numeric',
            'emergency_city'  => 'nullable|max:100',
            'emergency_postalcode'  => 'nullable|alpha_num',
            'emergency_country'  => 'nullable|numeric',
            // 'whatsapp_dialcode'  => 'nullable|numeric|digits_between:' . config('app.USER_MOBILE_MIN_LENGTH') . ',' . config('app.USER_MOBILE_MAX_LENGTH'),

            'name_passport'  => ['nullable', 'max:150', 'regex:/^[\pL\s]+$/u'],

            'address' => 'nullable|max:200',
            'post_code' => 'nullable|max:20',
            'passport_num' => 'nullable|max:50',
            'date_of_marriage' => 'nullable|before:' . now(),
            'issue_date' => 'nullable|before_or_equal:' . now(),
            'passport_expiry_date' => 'nullable|after_or_equal:' . date('Y-m-d')
        ]);

        if (get_site_config('lead_create_admin_mandatory') == 'email') {
            $request->validate([
                'email' => 'required|email|unique:users,email,' . $id,
                'mobile' => ['nullable', 'numeric', 'digits_between:' . config('app.USER_MOBILE_MIN_LENGTH') . ',' . config('app.USER_MOBILE_MAX_LENGTH')],
            ]);
        } elseif (get_site_config('lead_create_admin_mandatory') == 'email_and_mobile') {
            $request->validate([
                'email' => 'required|email|unique:users,email,' . $id,
                'mobile' => ['required', 'numeric', 'digits_between:' . config('app.USER_MOBILE_MIN_LENGTH') . ',' . config('app.USER_MOBILE_MAX_LENGTH'), 'unique:users,mobile,' . $id],
            ]);
        } elseif (get_site_config('lead_create_admin_mandatory') == 'email_or_mobile') {
            if ($request->get('email') == "" && $request->get('mobile') == "") {
                return redirect()->back()->withFlashDanger('Email or Mobile is Required');
            } else {
                $request->validate([
                    'email' => 'nullable|email|unique:users,email,' . $id,
                    'mobile' => ['nullable', 'numeric', 'digits_between:' . config('app.USER_MOBILE_MIN_LENGTH') . ',' . config('app.USER_MOBILE_MAX_LENGTH'), 'unique:users,mobile,' . $id],
                ]);
            }
        } elseif (get_site_config('lead_create_admin_mandatory') == 'mobile') {
            $request->validate([
                'email' => 'nullable|email|unique:users,email,' . $id,
                'mobile' => ['required', 'numeric', 'digits_between:' . config('app.USER_MOBILE_MIN_LENGTH') . ',' . config('app.USER_MOBILE_MAX_LENGTH'), 'unique:users,mobile,' . $id],
            ]);
        }

        //Checking custom attributes
        if ($request->is_lead) {
            $for = "for_lead";
        } else {
            $for = "for_student";
        }
        $custom_attributes = DB::table('custom_attributes')->where($for, 1)->orderBy('display_order', 'asc')->get(["custom_attributes.*"]);
        $attributes_json = "";
        if (count($custom_attributes)) {
            $all_atts = array();
            foreach ($custom_attributes as $attrs) {
                $name = $attrs->attr_name;
                $all_atts[$attrs->attr_name] = $request->$name;
                if ($attrs->laravel_rules) {
                    $request->validate([
                        "$attrs->attr_name" => "$attrs->laravel_rules",
                    ]);
                }
            }
            $attributes_json = json_encode($all_atts);
        }
        //Checking custom attributes

        // $dob ="";
        // if(!empty($request->input('dob'))){
        //     $dob = date('Y-m-d',strtotime($request->input('dob')));
        // }

        $service_interested = "";
        $service_pref = $request->input('services');
        if (!empty($service_pref) && count($service_pref)) {
            $service_interested = implode(",", $request->get('services'));
        }

        $birthday = NULL;
        if (!empty($request->get('birthday'))) {
            $birthday = date('Y-m-d', strtotime($request->get('birthday')));
        }

        $date_of_marriage = NULL;
        if (!empty($request->get('date_of_marriage'))) {
            $date_of_marriage = date('Y-m-d', strtotime($request->get('date_of_marriage')));
        }

        $overseas_study_level = NULL;
        $study_level = $request->get('study_level');
        if (isset($study_level) && $study_level != "")
            $overseas_study_level = get_study_level_degree_level($study_level);
        else
            $overseas_study_level = NULL;


        $country_interested = NULL;
        if (!empty($request->get('country_interested')) && count($request->get('country_interested'))) {
            $country_interested = implode(",", $request->get('country_interested'));
        }

        $service_interested = NULL;
        if (!empty($request->get('services')) && count($request->get('services'))) {
            $service_interested = implode(",", $request->get('services'));
        }

        $intatake_arr = NULL;
        if (!empty($request->get('intake'))) {
            $intake = $request->get('intake');
            $intatake_arr =  explode(" ", $intake);
        } else {
            $intatake_arr = array(null, null);
        }

        $user = User::find($request->input('user_id'));
        $user->first_name = $request->input('first_name');
        $user->middle_name = $request->input('middle_name');
        $user->last_name = $request->input('last_name');
        $user->email = $request->input('email');
        $user->birthday = $birthday;
        $user->dialcode = $request->input('dialcode');
        $user->mobile = $request->input('mobile');
        $user->whatsapp_dialcode = $request->get('whatsapp_dialcode');
        $user->whatsapp = $request->get('whatsapp_number');
        $user->alternate_contact = $request->get('alternate_contact');
        $user->overseas_study_level = $overseas_study_level;
        $user->overseas_study_level_selection = $study_level;
        $user->country_interested = $country_interested;
        $user->overseas_course_intersted = $request->get('course_interested');
        $user->services = $service_interested;
        $user->services = $intatake_arr;
        $user->gender = $request->input('gender');

        $user->country = $request->input('country');
        $user->address_1 = $request->input('address');
        $user->state = $request->input('state');
        $user->city = $request->input('city');
        $user->post_code = $request->input('post_code');
        $user->profile_complete = 'personal';
        $user->services = $service_interested;

        $image = $request->file('avatar_location');
        
        if ($image) {
            $extension = $image->extension();
            if (in_array($extension, array('jpg', 'jpeg', 'png'))) {
                if ($image->getSize() < 2048000) { //max size 2MB
                    $filename = pathinfo($image->getClientOriginalName(), PATHINFO_FILENAME);
                    if (strlen($filename) > 100) {
                        $filename = substr($filename, 0, 100);
                    }
                    $filename = $filename . Str::random(10) . "." . $image->getClientOriginalExtension();
                    $user->avatar_location = $image->storeAs('/avatars', $filename, 'public');
                } else {
                    throw new GeneralException('Profile pic size must not exceed 2MB');
                }
            } else {
                throw new GeneralException('You must upload a valid profile pic (jpg/png).');
            }
        }

        $user->save();

        //Saving User Details
        $details = UserDetails::firstOrNew(array('userid' => $user->id));
        $details->marital_status = $request->input('marital_status');
        $details->date_of_marriage = $date_of_marriage;
        $details->intake_year = $intatake_arr[1];
        $details->intake_month = $intatake_arr[0];
        $details->highest_level_education = $request->input('qualification');
        $details->passout_year = $request->input('passout_year');
        $details->qualification_score = $request->input('qualification_score');
        $details->current_course = $request->input('currently_studying_course');
        $details->work_experience = $request->input('work_experience');

        $details->nationality = $request->input('nationality');
        $details->citizenship = $request->input('citizenship');
        $details->country_of_education = $request->input('country_of_education');
        // $details->highest_level_education = $request->input('highest_level_education');

        $details->name_passport = $request->input('name_passport');
        $details->user_data_js = $attributes_json;
        $details->passport_num = $request->input('passport_num');
        if (!empty($request->input('passport_issue_date'))) {
            $details->passport_issue_date = substr($request->input('passport_issue_date'), 6, 4) . "-" . substr($request->input('passport_issue_date'), 3, 2) . "-" . substr($request->input('passport_issue_date'), 0, 2);
        }
        if (!empty($request->input('passport_expiry_date'))) {
            $details->passport_expiry_date = substr($request->input('passport_expiry_date'), 6, 4) . "-" . substr($request->input('passport_expiry_date'), 3, 2) . "-" . substr($request->input('passport_expiry_date'), 0, 2);
        }
        $details->passport_country = $request->input('passport_country');
        $details->city_of_birth = $request->input('city_of_birth');
        $details->country_of_birth = $request->input('country_of_birth');

        $details->dual_citizenship = $request->input('dual_citizenship');
        if ($request->input('dual_citizenship') == '1') {
            $details->dual_citizenship_country = implode(",", $request->input('dual_citizenship_country'));
        } else {
            $details->dual_citizenship_country = '';
        }

        $details->studying_abroad = $request->input('studying_abroad');
        if ($request->input('studying_abroad') == '1') {
            $details->studying_abroad_country = $request->input('studying_abroad_country');
        } else {
            $details->studying_abroad_country = '';
        }

        $details->immigration = $request->input('immigration');
        if ($request->input('immigration') == '1') {
            $details->immigration_country = implode(",", $request->input('immigration_country'));
        } else {
            $details->immigration_country = '';
        }

        $details->medical_condition = $request->input('medical_condition');
        $details->visa_refusal = $request->input('visa_refusal');
        if ($request->input('visa_refusal') == '1') {
            $details->visa_refusal_country = implode(",", $request->input('visa_refusal_country'));
        } else {
            $details->visa_refusal_country = '';
        }

        $details->criminal_offence = $request->input('criminal_offence');

        if ($request->input('same_as_current') == 1) {
            // $details->same_address = $request->input('same_as_current');
            $details->permanent_address = $request->input('address');
            $details->permanent_city = $request->input('city');
            $details->permanent_state = $request->input('state');
            $details->permanent_country = $request->input('country');
            $details->permanent_post_code = $request->input('post_code');
        } else {
            // $details->same_address = $request->input('same_as_current');
            $details->permanent_address = $request->input('permanent_address');
            $details->permanent_city = $request->input('permanent_city');
            $details->permanent_state = $request->input('permanent_state');
            $details->permanent_country = $request->input('permanent_country');
            $details->permanent_post_code = $request->input('permanent_post_code');
        }

        $details->emergency_name = $request->input('emergency_name');
        $details->emergency_phone = $request->input('emergency_phone');
        $details->emergency_email = $request->input('emergency_email');
        $details->emergency_relation = $request->input('emergency_relation');
        $details->emergency_address = $request->input('emergency_address');
        $details->emergency_country = $request->input('emergency_country');
        $details->emergency_state = $request->input('emergency_state');
        $details->emergency_city = $request->input('emergency_city');
        $details->emergency_postalcode = $request->input('emergency_postalcode');

        $details->save();

        if ($request->is_lead) {
            //Sending email Notification
            $subject = "Lead Profile Updated";
            $email_message = "Lead Profile Updated.<br /><strong>Lead Details:</strong><br/>" . $user->first_name . " " . $user->last_name . "<br/>Mob: " . $user->mobile . "<br/>Email: " . $user->email;
            send_mail_notification($user->id, "", "STUDENT_PROFILE_UPDATED", $subject, $email_message);

            // Send Push App Notification
            if (\Auth::user()->isAgent()) {
                $message = "Lead <strong>" . $user->full_name . "</strong> (" . $user->id . ") profile updated by Agent: " . get_user_full_name_by_id(\Auth::user()->id);
            } else {
                $message = "Lead <strong>" . $user->full_name . "</strong> (" . $user->id . ") profile updated by staff";
            }
            $subject = "";
            send_in_app_notification(
                $user->id,
                $user->id,
                "STUDENT_PROFILE_UPDATED",
                $subject,
                $message,
                "lead",
            );
        } else {
            //Sending email Notification
            $subject = "Student Profile Updated";
            $email_message = "Student Profile Updated.<br /><strong>Student Details:</strong><br/>" . $user->first_name . " " . $user->last_name . "<br/>Mob: " . $user->mobile . "<br/>Email: " . $user->email;
            send_mail_notification($user->id, "", "STUDENT_PROFILE_UPDATED", $subject, $email_message);

            // Send Push App Notification
            if (\Auth::user()->isAgent()) {
                $message = _label('backend_student') . " <strong>" . $user->full_name . "</strong> (" . $user->id . ") profile updated by Agent: " . get_user_full_name_by_id(\Auth::user()->id);
            } else {
                $message = _label('backend_student') . " <strong>" . $user->full_name . "</strong> (" . $user->id . ") profile updated by staff";
            }
            $subject = "";
            send_in_app_notification(
                $user->id,
                $user->id,
                "STUDENT_PROFILE_UPDATED",
                $subject,
                $message,
                "student",
            );
        }

        if ($user->overseas_status == get_default_student_status()) {
            update_student_overseas_status($user->id);
        }

        return redirect()->route('admin.student.edit', $user)->withFlashSuccess("Profile updated successfully");
    }





    public function storeLanguagesProfile(Request $request)
    {
        $userid = $request->input('user_id');
        $data = $request->all();

        $eng_exam = array('IELTS', 'TOEFL', 'PTE');
        for ($i = 0; $i < count($eng_exam); $i++) {
            $exam_name = $eng_exam[$i];
            $overall_score = $data['eng'][$exam_name]['overall_score'];
            $speaking = $data['eng'][$exam_name]['speaking'];
            $reading = $data['eng'][$exam_name]['reading'];
            $listening = $data['eng'][$exam_name]['listening'];
            $writing = $data['eng'][$exam_name]['writing'];
            $expiry_date = $data['eng'][$exam_name]['expiry_date'];
            if ($expiry_date) {
                $expiry_date_db = date("Y-m-d", strtotime(substr($expiry_date, 6, 4) . "-" . substr($expiry_date, 3, 2) . "-" . substr($expiry_date, 0, 2)));
            } else {
                $expiry_date_db = NULL;
            }

            DB::table('user_certification_eng')
                ->updateOrInsert(
                    ['userid' => $userid, 'exam' => $exam_name],
                    [
                        'overall_score' => $overall_score,
                        'speaking' => $speaking,
                        'reading' => $reading,
                        'listening' => $listening,
                        'writing' => $writing,
                        'expiry_date' => $expiry_date_db
                    ]
                );
        }
        //DET
        if (!empty($request->input('det_overall_score'))) {
            $det_expiry_date = $request->input('det_expiry_date');
            if ($det_expiry_date) {
                $det_expiry_date_db = date("Y-m-d", strtotime(substr($det_expiry_date, 6, 4) . "-" . substr($det_expiry_date, 3, 2) . "-" . substr($det_expiry_date, 0, 2)));
            } else {
                $det_expiry_date_db = NULL;
            }
            DB::table('user_certification_eng')
                ->updateOrInsert(
                    ['userid' => $userid, 'exam' => 'DET'],
                    [
                        'overall_score' => $request->input('det_overall_score'),
                        'expiry_date' => $det_expiry_date_db
                    ]
                );
        }

        //ACT
        if (!empty($request->input('act_overall_score'))) {
            $act_expiry_date = $request->input('act_expiry_date');
            if ($act_expiry_date) {
                $act_expiry_date_db = date("Y-m-d", strtotime(substr($act_expiry_date, 6, 4) . "-" . substr($act_expiry_date, 3, 2) . "-" . substr($act_expiry_date, 0, 2)));
            } else {
                $act_expiry_date_db = NULL;
            }
            DB::table('user_certification_eng')
                ->updateOrInsert(
                    ['userid' => $userid, 'exam' => 'ACT'],
                    [
                        'overall_score' => $request->input('act_overall_score'),
                        'math' => $request->input('act_math'),
                        'reading' => $request->input('act_reading'),
                        'writing' => $request->input('act_writing'),
                        'science' => $request->input('act_science'),
                        'english' => $request->input('act_english'),
                        'expiry_date' => $act_expiry_date_db
                    ]
                );
        }

        //SAT
        if (!empty($request->input('sat_overall_score'))) {
            $sat_expiry_date = $request->input('sat_expiry_date');
            if ($sat_expiry_date) {
                $sat_expiry_date_db = date("Y-m-d", strtotime(substr($sat_expiry_date, 6, 4) . "-" . substr($sat_expiry_date, 3, 2) . "-" . substr($sat_expiry_date, 0, 2)));
            } else {
                $sat_expiry_date_db = NULL;
            }
            DB::table('user_certification_eng')
                ->updateOrInsert(
                    ['userid' => $userid, 'exam' => 'SAT'],
                    [
                        'overall_score' => $request->input('sat_overall_score'),
                        'math' => $request->input('sat_math'),
                        'reading' => $request->input('sat_reading'),
                        'writing' => $request->input('sat_writing'),
                        'essay' => $request->input('sat_essay'),
                        'expiry_date' => $sat_expiry_date_db
                    ]
                );
        }

        $lang_exam = array('German', 'French', 'Spanish', 'Japanese');
        for ($i = 0; $i < count($lang_exam); $i++) {
            $exam_name = $lang_exam[$i];
            $level = $data['lang'][$exam_name]['level'];
            $overall_score = $data['lang'][$exam_name]['overall_score'];
            $speaking = $data['lang'][$exam_name]['speaking'];
            $reading = $data['lang'][$exam_name]['reading'];
            $listening = $data['lang'][$exam_name]['listening'];
            $writing = $data['lang'][$exam_name]['writing'];
            $institute = $data['lang'][$exam_name]['institute'];

            if (!empty($level)) {
                DB::table('user_certification_lang')
                    ->updateOrInsert(
                        ['userid' => $userid, 'language' => $exam_name, 'level' => $level],
                        [
                            'overall_score' => $overall_score,
                            'speaking' => $speaking,
                            'reading' => $reading,
                            'listening' => $listening,
                            'writing' => $writing,
                            'institute' => $institute
                        ]
                    );
            }
        }

        // $userid = $request->input('user_id');
        // $data = $request->all();

        if ($data['exam']['gre']['expiry_date']) {
            $gre_exp_dt = $data['exam']['gre']['expiry_date'];
            $gre_exp_dt_db = date("Y-m-d", strtotime(substr($gre_exp_dt, 6, 4) . "-" . substr($gre_exp_dt, 3, 2) . "-" . substr($gre_exp_dt, 0, 2)));
        } else {
            $gre_exp_dt_db = NULL;
        }

        if ($data['exam']['gmat']['expiry_date']) {
            $gmat_exp_dt = $data['exam']['gmat']['expiry_date'];
            $gmat_exp_dt_db = date("Y-m-d", strtotime(substr($gmat_exp_dt, 6, 4) . "-" . substr($gmat_exp_dt, 3, 2) . "-" . substr($gmat_exp_dt, 0, 2)));
        } else {
            $gmat_exp_dt_db = NULL;
        }

        DB::table('user_gre_gmat')
            ->updateOrInsert(
                ['userid' => $userid, 'exam' => 'GRE'],
                [
                    'total_score' => $data['exam']['gre']['total_score'],
                    'verbal' => $data['exam']['gre']['verbal'],
                    'quantitative' => $data['exam']['gre']['quantitative'],
                    'analytical' => $data['exam']['gre']['analytical'],
                    'integrated' => $data['exam']['gre']['integrated'],
                    'expiry_date' => $gre_exp_dt_db
                ]
            );

        DB::table('user_gre_gmat')
            ->updateOrInsert(
                ['userid' => $userid, 'exam' => 'GMAT'],
                [
                    'total_score' => $data['exam']['gmat']['total_score'],
                    'verbal' => $data['exam']['gmat']['verbal'],
                    'quantitative' => $data['exam']['gmat']['quantitative'],
                    'analytical' => $data['exam']['gmat']['analytical'],
                    'integrated' => $data['exam']['gmat']['integrated'],
                    'expiry_date' => $gmat_exp_dt_db
                ]
            );

        return redirect()->route('admin.student.edit', $userid)->withFlashSuccess("Language certification details updated successfully");
    }

    public function storeInternshipsProfile(Request $request)
    {
        $userid = $request->input('user_id');
        $data = $request->all();

        for ($i = 0; $i < count($data['internship']); $i++) {
            $internship = $data['internship'][$i];
            $company = $internship['company'];
            $duration = $internship['duration'];
            $place = $internship['place'];

            if (!empty($company) && !empty($duration)) {
                DB::table('user_internship')
                    ->updateOrInsert(
                        ['userid' => $userid, 'company' => $company],
                        [
                            'duration' => $duration,
                            'place' => $place
                        ]
                    );
            }
        }
        for ($i = 0; $i < count($data['course']); $i++) {
            $course = $data['course'][$i];
            $course_name = $course['course'];
            $duration = $course['duration'];
            $institute = $course['institute'];

            if (!empty($course_name)) {
                DB::table('user_courses')
                    ->updateOrInsert(
                        ['userid' => $userid, 'course' => $course_name],
                        [
                            'duration' => $duration,
                            'institute' => $institute
                        ]
                    );
            }
        }
        return redirect()->route('admin.student.edit', $userid)->withFlashSuccess("Internship details updated successfully");
    }


    public function storeStudyLevel(Request $request)
    {
        $request->validate([
            'overseas_study_level' => 'required',
        ]);

        $user = User::find($request->input('user_id'));
        $userid = $user->id;

        // $s_level =  $request->input('overseas_study_level');
        // if($s_level == "UG Diploma/ Certificate/ Associate Degree"
        // || $s_level == "UG" 
        // || $s_level == "UG+PG (Accelerated) Degree" 
        // || $s_level == "Twinning Programmes (UG)"){
        //     $s_level = "Bachelors";
        // }
        // elseif($s_level == "PG Diploma/Certificate"  
        // || $s_level == "PG"
        // || $s_level == "Twinning Programmes (PG)"){
        //     $s_level = "Masters";
        // }
        // elseif($s_level == "PhD"){
        //     $s_level = "Ph.D";
        // }
        // else{
        //     $s_level = "Others";
        // }

        if ($request->input('overseas_study_level')) {
            $s_level = get_study_level_degree_level($request->input('overseas_study_level'));
        } else {
            $s_level = NULL;
        }

        $user->overseas_study_level = $s_level;
        $user->overseas_study_level_selection = $request->input('overseas_study_level');

        $user->save();
        $user->profile_complete = 'course';
        $user->save();

        //update_student_overseas_status($user->id);

        //return redirect()->route('admin.auth.user.show', $userid)->withFlashSuccess("Study Level updated successfully");
        return redirect('admin/auth/user/' . $userid . '#coursepreference')->withFlashSuccess("Study Level updated successfully");
    }

    // public function addApplication($id){
    public function addApplication(Request $request)
    {
        // dd($request->all());
        if (\Auth::user()->isAgent()) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $pref =  DB::table('course_preference')->where('id', $request->pref_id)->first();
        $userid = $pref->userid;

        $leadUser = user::where('id', $userid)->first();
        if ($leadUser->is_lead) {
            return redirect('admin/auth/user/' . $leadUser->id . '#coursepreference')->withFlashDanger("You must first convert the lead to student, to create University Applications.");
        }

        if (!($pref->university_other || $pref->university_id)) {
            return redirect('admin/auth/user/' . $userid . '#coursepreference')->withFlashDanger("University Name Required For University Applications Creation!");
        }
        if (!($pref->intake_year) || !($pref->intake)) {
            return redirect('admin/auth/user/' . $userid . '#coursepreference')->withFlashDanger("Intake is Required For University Applications Creation!");
        }

        if ($pref->course_id && get_university_course_data($pref->course_id) == "") {
            return redirect('admin/auth/user/' . $userid . '#coursepreference')->withFlashDanger("Course is Required For University Applications Creation!");
        }

        $prefid = $pref->id;
        $country = get_country_name($pref->country_id);

        $agent_commission_percent = $agent_commission = $my_commission_percent = $my_commission = $currency = $tuition_fee = NULL;

        if ($pref->course_id) {
            $get_university_course_data = get_university_course_data($pref->course_id);
            $course = $get_university_course_data->course_name;
            $currency = $get_university_course_data->currency;
            $yearly_tuition_fee = $get_university_course_data->yearly_tuition_fee;
            // $discounted_fee = $get_university_course_data->discounted_fee;
            $commission_percentage = $get_university_course_data->commission_percentage ?? 0;

            //calculate commission
            // if($commission_percentage && $discounted_fee){
            //     $tuition_fee = $discounted_fee;
            //     $my_commission = $discounted_fee * $commission_percentage/100;
            //     $my_commission_percent = $commission_percentage;
            //     if($leadUser->agent_id){
            //         $comm = $discounted_fee * $commission_percentage/100;
            //         $agent_commission = $comm * get_agent_commission_percentage($leadUser->agent_id)/100;
            //         $agent_commission_percent = get_agent_commission_percentage($leadUser->agent_id);
            //     }
            // }
            // else 
            if($commission_percentage && $yearly_tuition_fee){
                $tuition_fee = $yearly_tuition_fee;
                $my_commission = $yearly_tuition_fee * $commission_percentage/100;
                $my_commission_percent = $commission_percentage;
                if($leadUser->agent_id){
                    $comm = $yearly_tuition_fee * $commission_percentage/100;
                    $agent_commission = $comm * get_agent_commission_percentage($leadUser->agent_id)/100;
                    $agent_commission_percent = get_agent_commission_percentage($leadUser->agent_id);
                }
            }else{
                $agent_commission_percent = $agent_commission = $my_commission_percent = $my_commission = NULL;
            }
        } else {
            $course = $pref->course_other;
        }

        // if ($pref->course_id) {
        //     $course = get_university_course_data($pref->course_id)->course_name;
        // } else {
        //     $course = $pref->course_other;
        // }

        if ($pref->university_id) {
            $university = get_university_data($pref->university_id)->university_name;
        } else {
            $university = $pref->university_other;
        }

        $intake_year = $pref->intake_year;
        $intake = $pref->intake;

        $appl_id = "";
        do {
            $appl_id = random_int(100000, 999999);
        } while (
            DB::table('university_application')->where('appl_id', $appl_id)->exists()
        );

        if (isset($request->staff) && $request->staff != "") {
            $assign_to = $request->staff;
            $assign_to_msg = " Assigned to: " . get_user_full_name_by_id($request->staff);
        } else {
            $assign_to = NULL;
            $assign_to_msg = "";
        }
        if ((isset($request->asign_student_also) && $request->asign_student_also != "") && (isset($request->staff) && $request->staff != "")) {
            $stu_assign_to = $request->staff;
            DB::table('users')->where("id", $userid)->update(['assigned_to' => $stu_assign_to]);
            $stu_assign_to_msg = " Student Re-assigned to: " . get_user_full_name_by_id($request->staff);
        } else {
            $stu_assign_to_msg = "";
        }

        $university_application = DB::table('university_application')->insert([
                    'appl_id' => $appl_id, 'userid' => $userid, 
                    'course_pref_id' => $prefid, 
                    'university' => $university, 'course' => $course, 'country' => $country, 
                    'year' => $intake_year, 'intake' => $intake, 'assign_to' => $assign_to, 
                    'fees_currency' => $currency, 'tuition_fees' => $tuition_fee, 
                    'my_commission_percent' => $my_commission_percent, 'my_commission' => $my_commission, 
                    'agent_commission_percent' => $agent_commission_percent, 'agent_commission' => $agent_commission,
                    'created_at' => date('Y-m-d H:i:s')
                ]);

        //store event in user activity
        UserActivity::create(['user_id' => $userid, 'type' => 'admin_event', 'title' => "Application Added", 'detail' => "Country: $country University: $university Course: $course Intake: $intake, $intake_year $assign_to_msg $stu_assign_to_msg", 'staff' => \Auth::user()->id]);
        $university = DB::table('university_application')->where("appl_id", $appl_id)->first();

        ApplicationActivity::create([
                'application_id' => $university->id, 
                'type' => 'others', 
                'title' => "Application created", 
                'detail' => "Application #" . $university->appl_id." created successfully ", 
                'staff' => \Auth::user()->id,
                'application_status_changed_to' => $university->status,
                'application_assigned_to' => $assign_to,
            ]);
            
        //Notify Staff
        $subject = "University Application #" . $university->appl_id . " Created";
        $email_message = "Hi, <br>University Application Created by Staff: " . get_user_full_name_by_id(\Auth::user()->id) .
            "<br>Student: " . $leadUser->full_name . " (" . $leadUser->id . ")" .
            "<br><strong>Application Detail: </strong>" .
            "<br>Application #: " . $university->appl_id .
            "<br>University: " . $university->university .
            "<br>Course: " . $university->course .
            "<br>Country: " . $university->country;
        if ($assign_to_msg != '') {
            "<br>Assigned to: " . $stu_assign_to_msg;
        }
        if ($assign_to_msg != '') {
            "<br>Student Re-assigned to: " . $assign_to_msg;
        }
        send_mail_notification($university->userid, "", "UNIVERSITY_APPLICATION_CREATED", $subject, $email_message);

        // Send Push App Notification
        $message = "Application #" . $university->appl_id . " Created by Staff: " . get_user_full_name_by_id(\Auth::user()->id) .
            "<br>Student: " . $leadUser->full_name . " (" . $leadUser->id . ")";
        $subject = "";
        send_in_app_notification(
            $university->userid,
            $university->appl_id,
            "UNIVERSITY_APPLICATION_CREATED",
            $subject,
            $message,
            "university"
        );

        //`````````````````Adding commission````````````````````````
        if($agent_commission != NULL){
            $commission_paid_date = now();
            if($university){
                $agentCommission = new AgentCommission([
                    'appl_id' => $university->id,
                    'agent_id' => $leadUser->agent_id,
                    'currency' => $currency,
                    'created_at' => $commission_paid_date,
                    'amount' => $agent_commission,
                    'net_pay' => $agent_commission,
                    'agent_commission_notes' => "AutoGenerated Commission for Application #".$university->appl_id,
                    'created_by' => \Auth::user()->id,
                ]);
                $agentCommission->save();

                // Send Push App Notification
                //Notify Staff
                $subject = "Application #".$university->appl_id." Commission added by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
                $email_message = "Hi, <br>Application #".$university->appl_id." Commission added by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
                $email_message .= "<br><b>Application Details:</b><br>University Application #".$university->appl_id ."<br>Course: ".$university->course . "<br>University: " . $university->university . "<br>Country: " .$university->country;
                $email_message .= "<br>"._label('backend_student').": " . $leadUser->full_name." (". $leadUser->id. ")";
                send_mail_notification($leadUser->id, $university->id, "AGENT_COMMISSION_ONLY", $subject, $email_message);

                $subject = "";
                $message = "Application Commission added by Staff: " . get_user_full_name_by_id(\Auth::user()->id) . " Application #: " . $university->appl_id;
                $message .= "<br>Application #: ".$university->appl_id.
                "<br>"._label('backend_student').": " . $leadUser->full_name." (". $leadUser->id. ")";
                send_in_app_notification(
                    $university->userid, 
                    $university->appl_id, 
                    "AGENT_COMMISSION_ONLY", 
                    $subject, 
                    $message,
                    "university"
                );
            }
        }
        //``````````````````Adding commission```````````````````````

        return redirect()->route('admin.applicationdetail', $university->id)->withFlashSuccess("Application Added Successfully");
    }

    public function addVisaApplication($id)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return response()->json([
                'success' => 0,
                'message' => 'You do not have access permission to this feature.'
            ]);
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $pref =  DB::table('visa_preference')->where('id', $id)->first();
        $userid = $pref->userid;
        $prefid = $pref->id;
        $country = $pref->country;

        $appl_id = generate_application_id();
        DB::table('university_application')
            ->insert(
                ['appl_id' => $appl_id, 'type' => 'visa', 'userid' => $userid, 'visa_pref_id' => $prefid, 'created_at' => date('Y-m-d H:i:s'), 'country' => $country]
            );

        update_visa_user_status($userid);

        //store event in user activity
        UserActivity::create(['user_id' => $userid, 'type' => 'admin_event', 'title' => "Application Added", 'detail' => "Country: $country", 'staff' => \Auth::user()->id]);

        return redirect()->route('admin.auth.user.show', $userid)->withFlashSuccess("Visa Application Added Successfully");
    }


    public function viewApplicationByCoursePref($id)
    {
        $row = DB::table('university_application')->where('course_pref_id', $id)->first();
        if (!$row) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger("University Applications Not Found");
        }
        return redirect()->route('admin.applicationdetail', $row->id);
    }

    public function viewApplicationByVisaPref($id)
    {
        $row = DB::table('university_application')->where('visa_pref_id', $id)->first();
        if (!$row) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger("University Applications Not Found");
        }
        return redirect()->route('admin.applicationdetail', $row->id);
    }

    /** Course Preferences */
    public function storeCoursePreference(Request $request)
    {
        $request->validate([
            'country'  => 'required',
            'university'  => 'required',
            'course'  => 'required',
            'intake'  => 'required',
        ]);
        //echo $request->input('course');
        if (filter_var($request->input('course'), FILTER_VALIDATE_INT) !== false) {
            $course = $request->input('course');
            $course_other = null;
        } else {
            $course = 0;
            $course_other = $request->input('course');
        }

        if (filter_var($request->input('university'), FILTER_VALIDATE_INT) !== false) {
            $university = $request->input('university');
            $university_other = null;
        } else {
            $university = 0;
            $university_other = $request->input('university');
        }


        $userid = $request->input('user_id');
        $intake = $request->input('intake');
        $inta =  explode(" ", $intake);
        $country = $request->input('country');
        // $course = $request->input('course');
        // $university = $request->input('university');

        $chk_pref = DB::table('course_preference')
            ->where('userid', $userid)
            ->where('intake', $inta[0])
            ->where('intake_year', $inta[1])
            ->where('country', $country)
            ->where('course', $course)
            ->where('university', $university)
            ->first();

        if ($chk_pref) {
            return redirect('admin/auth/user/' . $userid . '#coursepreference')->withFlashDanger("Course preferences already exists!");
        } else {
            DB::table('course_preference')
                ->insert([
                    'userid' => $userid,
                    'country_id' => $country,
                    'course_id' => $course,
                    'course_other' => $course_other,
                    'university_other' => $university_other,
                    'university_id' => $university,
                    'intake_year' => $inta[1],
                    'intake' => $inta[0],
                    'created_by' => \Auth::user()->id,
                    'created_at' => now()
                ]);

            $user = User::find($userid);
            $user->profile_complete = 'course';
            $user->save();
            update_student_overseas_status($user->id);

            //store event in user activity
            UserActivity::create(['user_id' => $user->id, 'type' => 'admin_event', 'title' => get_user_full_name_by_id(\Auth::user()->id) . " Added Course Preferences", 'detail' => ""]);

            //email to student
            $mail_tpl = MailTemplates::find("COURSE_PREFERENCE_ADDED_BY_STAFF");
            if ($mail_tpl && $mail_tpl->status) {
                $email_message = $mail_tpl->message;
                //\Log::debug("MAIL BEFORE:".$email_message);
                $email_message = str_ireplace("#sitename#", app_name(), $email_message);
                $email_message = str_ireplace("#first_name#", $user->first_name, $email_message);
                $email_message = str_ireplace("#siteurl#", url('/'), $email_message);
                if ($course != 0) {
                    $msg_course = get_course_title_by_id($course);
                } else {
                    $msg_course = $course_other;
                }
                if ($university != 0) {
                    $msg_uni = get_university_name($university);
                } else {
                    $msg_uni = $university_other;
                }

                $email_message .= "<p>Course: " . $msg_course . ", University: " . $msg_uni . "</p>";
                $user = (new UserRepository())->where('id', $user->id)->first();
                try {
                    if ($user->agent_id == 0) {
                        //$user->notify(new UserAlert($mail_tpl->subject, $email_message));
                        user_notify($user, $mail_tpl->subject, $email_message);
                        \Log::debug("Mail Sent to Student: (COURSE_PREFERENCE_ADDED_BY_STAFF) " . $email_message);
                    }
                    // else{
                    //     // Now we are using send_mail_notification email function that will send the email to agent if student is belongs to Agent
                    //     // If we still use the below code than it will send the email to agent twice.

                    //     // $agent = User::find($user->agent_id);
                    //     // $agent->notify(new UserAlert($mail_tpl->subject, $email_message));
                    //     // \Log::debug("Mail Sent to Agent: (COURSE_PREFERENCE_ADDED_BY_STAFF) ".$email_message);   
                    // }
                } catch (\Exception $e) {
                    $message = $e->getMessage();
                    \Log::debug("Mail Error: (COURSE_PREFERENCE_ADDED_BY_STAFF) " . $message);
                }
            }

            //sms
            $notify_sms = get_sms_template('COURSE_PREFERENCE_ADDED_BY_STAFF');
            if ($notify_sms && $notify_sms->status) {
                $notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
                $notify_sms->message = str_replace("#siteurl#", url('/'), $notify_sms->message);
                $notify_sms->message = str_replace("#first_name#", $user->first_name, $notify_sms->message);
                $user->sms($notify_sms->message, $notify_sms->template_id);
                \Log::debug("SMS Sent to Student: (COURSE_PREFERENCE_ADDED_BY_STAFF) " . $notify_sms->message);
            }


            // Send Push App Notification
            if (\Auth::user()->isAgent()) {
                $message = "Course Preference Added by Agent: " . get_user_full_name_by_id(\Auth::user()->id) .
                    "<br>" . _label('backend_student') . ": " . $user->full_name . " (" . $user->id . ")";

                $email_message = "Course Preference Added by Agent: " . get_user_full_name_by_id(\Auth::user()->id) .
                    "<br><br><strong>" . _label('backend_student') . " Details:</strong>: <br />" . $user->full_name . " (" . $user->id . ")";
            } else {
                $message = "Course Preference Added by Staff: " . get_user_full_name_by_id(\Auth::user()->id) .
                    "<br>" . _label('backend_student') . ": " . $user->full_name . " (" . $user->id . ")";

                $email_message = "Course Preference Added by Staff: " . get_user_full_name_by_id(\Auth::user()->id) .
                    "<br><br><strong>" . _label('backend_student') . " Details:</strong>: <br />" . $user->full_name . " (" . $user->id . ")";
            }

            //Sending email Notification [staff]
            $subject = "Course Preference Added by Staff for " . _label('backend_student') . ": " . $user->full_name . " (" . $user->id . ")";
            $email_message .= "<br />Mob: " . $user->mobile . "<br />Email: " . $user->email;
            send_mail_notification($userid, "", "COURSE_PREFERENCE_ADDED_BY_STAFF", $subject, $email_message);

            $subject = "";
            send_in_app_notification(
                $user->id,
                $user->id,
                "COURSE_PREFERENCE_ADDED_BY_STAFF",
                $subject,
                $message,
                "student",
            );

            if ($request->input('from_course_preference')) {
                return response()->json(['success' => 'Course preference added successfully!']);
            }

            return redirect('admin/auth/user/' . $userid . '#coursepreference')->withFlashSuccess("Course preferences added successfully");
        }
    }

    public function storeVisaPreference(Request $request)
    {
        $request->validate([
            'country'  => 'required',
            'service_type'  => 'required',
            'letter_type'  => 'required',
        ]);

        $userid = $request->input('user_id');
        DB::table('visa_preference')
            ->insert(
                [
                    'userid' => $userid,
                    'country' => $request->input('country'),
                    'service_type' => $request->input('service_type'),
                    'letter_type' => $request->input('letter_type'),
                    'created_at' => date("Y-m-d H:i:s"),
                ]
            );

        $user = User::find($userid);
        $user->profile_complete = 'course';
        $user->save();
        update_student_overseas_status($user->id);

        return redirect()->route('admin.auth.user.show', $userid)->withFlashSuccess("Visa preferences added successfully");
    }


    public function storeDocumentsSop(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return response()->json([
                'success' => 0,
                'message' => 'You do not have access permission to this feature.'
            ]);
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $single_file_max = config('app.doc_single_max_size') * 1024;
        $size_msg = $single_file_max / pow(1024, 1);
        $request->validate([
            'file' => 'required',
            'file' => 'mimes:doc,docx,pdf|max:' . $single_file_max,
        ], [
            'max' => 'The files may not be greater than ' . $size_msg . ' MB.',
        ]);

        $userid = $request->user_id;
        $course_pref_id = $request->course_pref_id;
        $file = $request->file('file');
        $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
        $filename = str_replace(" ", "-", $filename);
        $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
        if (strlen($filename) > 20) {
            $filename = substr($filename, 0, 20);
        }
        $filename .= "-" . round(microtime(true) * 1000);
        $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
        DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "sop", "course_pref_id" => $course_pref_id, "file" => $path]);
        $this->appNotification("SOP", $userid);
        return "success";
    }

    public function storeDocumentsEssay(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return response()->json([
                'success' => 0,
                'message' => 'You do not have access permission to this feature.'
            ]);
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $single_file_max = config('app.doc_single_max_size') * 1024;

        $size_msg = $single_file_max / pow(1024, 1);
        $request->validate(
            [
                'files' => 'required',
                'files.*' => 'mimes:pdf,doc,docx|max:' . $single_file_max,
            ],
            [
                'max' => 'The files may not be greater than ' . $size_msg . ' MB.',
            ]
        );

        $userid = $request->user_id;
        $course_pref_id = $request->course_pref_id;
        $chk_essay = DB::table('user_docs_other')->where('userid', $userid)->where("course_pref_id", $request->course_pref_id)->where("doc_type", 'essay')->count();
        if ($chk_essay >= env("MAX_ESSAY_FILES")) {
            return "error_max_files";
        } elseif ($request->totalFiles > env("MAX_ESSAY_FILES")) {
            return "error_max_files";
        } else {
            if ($request->hasFile('files')) {
                foreach ($request->file('files') as $file) {
                    $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);

                    $filename = str_replace(" ", "-", $filename);
                    $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
                    if (strlen($filename) > 20) {
                        $filename = substr($filename, 0, 20);
                    }
                    $filename .= "-" . round(microtime(true) * 1000);
                    $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
                    DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "essay", "course_pref_id" => $course_pref_id, "file" => $path]);
                }
                $this->appNotification("Essay", $userid);
                return 'success';
            } else {
                return "error";
            }
        }
    }

    public function storeDocumentsAdditional(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return response()->json([
                'success' => 0,
                'message' => 'You do not have access permission to this feature.'
            ]);
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $single_file_max = config('app.doc_single_max_size') * 1024;
        $allowed_types = str_replace(".", "", $request->file_types);
        $allowed_types = str_replace(" ", "", $allowed_types);

        $size_msg = $single_file_max / pow(1024, 1);
        $request->validate(
            [
                'files' => 'required',
                'files.*' => 'mimes:' . $allowed_types . '|max:' . $single_file_max,
            ],
            [
                'max' => 'The files may not be greater than ' . $size_msg . ' MB.',
            ]
        );

        //return $request->doc_type."<br>".$request->file_types;

        $userid = $request->user_id;

        if ($request->hasFile('files')) {
            foreach ($request->file('files') as $file) {
                $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);

                $filename = str_replace(" ", "-", $filename);
                $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
                if (strlen($filename) > 20) {
                    $filename = substr($filename, 0, 20);
                }
                $filename .= "-" . round(microtime(true) * 1000);
                $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
                DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => $request->doc_type, "file" => $path]);
            }
            $this->appNotification(str_replace("_", " ", $request->doc_type), $userid);
            return 'success';
        } else {
            return "error";
        }
    }

    public function deleteDocumentsAdditional(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return response()->json([
                'success' => 0,
                'message' => 'You do not have access permission to this feature.'
            ]);
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $other = DB::table('user_docs_other')->where('id', $request->additional_id)->first();
        File::delete("storage/" . $other->file);

        DB::table('user_docs_other')->where('id', $request->additional_id)->delete();
        return response()->json(['message' => 'Document Deleted']);
    }


    public function storeExperienceProfile(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return response()->json([
                'success' => 0,
                'message' => 'You do not have access permission to this feature.'
            ]);
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $userid = $request->input('user_id');
        $data = $request->all();

        for ($i = 0; $i < count($data['experience']); $i++) {
            $experience = $data['experience'][$i];
            $company = $experience['company'];
            $designation = $experience['designation'];
            $start_date = $experience['start_date'];
            $end_date = $experience['end_date'];
            if ($start_date) {
                $start_date_db = date("Y-m-d", strtotime(substr($start_date, 6, 4) . "-" . substr($start_date, 3, 2) . "-" . substr($start_date, 0, 2)));
            } else {
                $start_date_db = NULL;
            }
            if ($end_date) {
                $end_date_db = date("Y-m-d", strtotime(substr($end_date, 6, 4) . "-" . substr($end_date, 3, 2) . "-" . substr($end_date, 0, 2)));
            } else {
                $end_date_db = NULL;
            }

            if (!empty($company)) {
                DB::table('user_experience')
                    ->updateOrInsert(
                        ['userid' => $userid, 'company' => $company],
                        [
                            'designation' => $designation,
                            'start_date' => $start_date_db,
                            'end_date' => $end_date_db
                        ]
                    );
            }
        }
        return redirect()->route('admin.student.edit', $userid)->withFlashSuccess("Experience details updated successfully");
    }


    /** Documents */
    public function storeDocuments(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return response()->json([
                'success' => 0,
                'message' => 'You do not have access permission to this feature.'
            ]);
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $message = "";
        $userid = $request->input('user_id');
        \Log::debug("----- StoreDocuments(UID:$userid) START");

        if (!DB::table('user_documents')->where('userid', $userid)->exists()) {
            DB::table('user_documents')->insert(['userid' => $userid]);
        }

        if ($request->file('grad_all_sem') || $request->file('pg_all_sem')) {
            $max_size = config('app.doc_allsem_max_size') * 1024;
            $size_msg = $max_size / pow(1024, 1);
        } else {
            $max_size = config('app.doc_single_max_size') * 1024;
            $size_msg = $max_size / pow(1024, 1);
        }

        $request->validate(
            [
                'class10' => 'nullable|mimes:pdf,jpeg,jpg|max:' . $max_size,
                'class10_marks_sheet' => 'nullable|mimes:pdf,jpeg,jpg|max:' . $max_size,
                'class12' => 'nullable|mimes:pdf,jpeg,jpg|max:' . $max_size,
                'class12_marks_sheet' => 'nullable|mimes:pdf,jpeg,jpg|max:' . $max_size,
                'diploma' => 'nullable|mimes:pdf,jpeg,jpg|max:' . $max_size,
                'diploma_marks_sheet' => 'nullable|mimes:pdf,jpeg,jpg|max:' . $max_size,
                'grad_all_sem' => 'nullable|mimes:pdf,jpeg,jpg|max:' . $max_size,
                'grad_degree' => 'nullable|mimes:pdf,jpeg,jpg|max:' . $max_size,
                'grad_transcripts' => 'nullable|mimes:pdf,jpeg,jpg|max:' . $max_size,
                'pg_all_sem' => 'nullable|mimes:pdf,jpeg,jpg|max:' . $max_size,
                'pg_degree' => 'nullable|mimes:pdf,jpeg,jpg|max:' . $max_size,
                'pg_transcripts' => 'nullable|mimes:pdf,jpeg,jpg|max:' . $max_size,
                'lang_ielts' => 'nullable|mimes:pdf,jpeg,jpg|max:' . $max_size,
                'lang_pte' => 'nullable|mimes:pdf,jpeg,jpg|max:' . $max_size,
                'gre' => 'nullable|mimes:pdf,jpeg,jpg|max:' . $max_size,
                'gmat' => 'nullable|mimes:pdf,jpeg,jpg|max:' . $max_size,
                'toefl' => 'nullable|mimes:pdf,jpeg,jpg|max:' . $max_size,
                'duolingo' => 'nullable|mimes:pdf,jpeg,jpg|max:' . $max_size,
            ],
            [
                'max' => 'The files may not be greater than ' . $size_msg . ' MB.',
            ]
        );

        if ($request->input('type') == 'class10') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $fullPath = storage_path("app/public/" . $path);

            if (file_exists($fullPath)) {
                \Log::info("File successfully saved at: " . $fullPath);
            } else {
                \Log::error("File not found after upload: " . $fullPath);
            }

            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['class10' => $path]);
            $message .= "10th Document Uploaded Successfully.";

            $this->appNotification("10th", $userid);

            return response()->json(['res' => 'success', 'message' => '10th Document Uploaded Successfully']);
        }
        if ($request->input('type') == 'class10_marks_sheet') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['class10_marks_sheet' => $path]);
            $message .= "10th Marksheet Uploaded Successfully.";

            $this->appNotification("10th Marksheet", $userid);

            return response()->json(['res' => 'success', 'message' => '10th Marksheet Uploaded Successfully.']);
        }

        if ($request->input('type') == 'class12') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['class12' => $path]);
            $message .= " 12th Document Uploaded Successfully.";

            $this->appNotification("12th", $userid);

            return response()->json(['res' => 'success', 'message' => '12th Document Uploaded Successfully.']);
        }
        if ($request->input('type') == 'class12_marks_sheet') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['class12_marks_sheet' => $path]);
            $message .= " 12th Marks Sheet Uploaded Successfully.";

            $this->appNotification("12th Marks Sheet", $userid);

            return response()->json(['res' => 'success', 'message' => '12th Marks Sheet Uploaded Successfully.']);
        }
        if ($request->input('type') == 'diploma') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['diploma' => $path]);
            $message .= " Diploma Document Uploaded Successfully.";

            $this->appNotification("Diploma", $userid);

            return response()->json(['res' => 'success', 'message' => 'Diploma Document Uploaded Successfully.']);
        }
        if ($request->input('type') == 'diploma_marks_sheet') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['diploma_marks_sheet' => $path]);
            $message .= " Diploma Marks Sheet Uploaded Successfully.";

            $this->appNotification("Diploma Marks Sheet", $userid);

            return response()->json(['res' => 'success', 'message' => 'Diploma Marks Sheet Uploaded Successfully.']);
        }

        if ($request->input('type') == 'grad_all_sem') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['grad_all_sem' => $path]);
            $message .= " Bachelors (All Sem) Document Uploaded Successfully.";

            $this->appNotification("Bachelors (All Sem)", $userid);

            return response()->json(['res' => 'success', 'message' => 'Bachelors (All Sem) Document Uploaded Successfully.']);
        }

        if ($request->input('type') == 'grad_provisional') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);
            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['grad_provisional' => $path]);
            $message .= " Bachelors Provisional Document Uploaded Successfully.";

            $this->appNotification("Bachelors Provisional", $userid);

            return response()->json(['res' => 'success', 'message' => 'Bachelors Provisional Document Uploaded Successfully.']);
        }

        if ($request->input('type') == 'cmm') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);
            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['cmm' => $path]);
            $message .= " Consolidated Marks Memo Document Uploaded Successfully.";

            $this->appNotification("Consolidated Marks Memo", $userid);

            return response()->json(['res' => 'success', 'message' => 'Consolidated Marks Memo Document Uploaded Successfully.']);
        }

        if ($request->input('type') == 'grad_degree') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['grad_degree' => $path]);
            $message .= " Bachelors Degree Document Uploaded Successfully.";

            $this->appNotification("Bachelors Degree", $userid);

            return response()->json(['res' => 'success', 'message' => 'Bachelors Degree Document Uploaded Successfully.']);
        }

        if ($request->input('type') == 'pg_provisional') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);
            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['pg_provisional' => $path]);
            $message .= " Masters Provisional Document Uploaded Successfully.";

            $this->appNotification("Masters Provisional", $userid);

            return response()->json(['res' => 'success', 'message' => 'Masters Provisional Document Uploaded Successfully.']);
        }

        if ($request->input('type') == 'grad_transcripts') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['grad_transcripts' => $path]);
            $message .= " Granduation Transcripts Uploaded Successfully.";

            $this->appNotification("Granduation Transcripts", $userid);

            return response()->json(['res' => 'success', 'message' => 'Granduation Transcripts Uploaded Successfully.']);
        }

        if ($request->input('type') == 'pg_all_sem') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['pg_all_sem' => $path]);
            $message .= " Masters (All Sem) Document Uploaded Successfully.";

            $this->appNotification("Masters (All Sem)", $userid);

            return response()->json(['res' => 'success', 'message' => 'Masters (All Sem) Document Uploaded Successfully.']);
        }

        if ($request->input('type') == 'pg_degree') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['pg_degree' => $path]);
            $message .= " Masters Degree Document Uploaded Successfully.";

            $this->appNotification("Masters Degree", $userid);

            return response()->json(['res' => 'success', 'message' => 'Masters Degree Document Uploaded Successfully.']);
        }

        if ($request->input('type') == 'pg_transcripts') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['pg_transcripts' => $path]);
            $message .= " Masters Transcripts Uploaded Successfully.";

            $this->appNotification("Masters Transcripts", $userid);

            return response()->json(['res' => 'success', 'message' => 'Masters Transcripts Uploaded Successfully.']);
        }

        if ($request->input('type') == 'lang_ielts') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['lang_ielts' => $path]);
            $message .= " IELTS Document Uploaded Successfully.";

            $this->appNotification("IELTS", $userid);

            return response()->json(['res' => 'success', 'message' => 'IELTS Document Uploaded Successfully.']);
        }

        if ($request->input('type') == 'lang_pte') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['lang_pte' => $path]);
            $message .= " PTE Document Uploaded Successfully.";

            $this->appNotification("PTE", $userid);

            return response()->json(['res' => 'success', 'message' => 'PTE Document Uploaded Successfully.']);
        }

        if ($request->input('type') == 'gre') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['gre' => $path]);
            $message .= " GRE Document Uploaded Successfully.";

            $this->appNotification("GRE", $userid);

            return response()->json(['res' => 'success', 'message' => 'GRE Document Uploaded Successfully.']);
        }

        if ($request->input('type') == 'gmat') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['gmat' => $path]);
            $message .= " GMAT Document Uploaded Successfully.";

            $this->appNotification("GMAT", $userid);

            return response()->json(['res' => 'success', 'message' => 'GMAT Document Uploaded Successfully.']);
        }

        if ($request->input('type') == 'toefl') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['toefl' => $path]);
            $message .= " TOEFL Document Uploaded Successfully.";

            $this->appNotification("TOEFL", $userid);

            return response()->json(['res' => 'success', 'message' => 'TOEFL Document Uploaded Successfully.']);
        }

        if ($request->input('type') == 'duolingo') {
            $file = $request->file('file');
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= "-" . round(microtime(true) * 1000);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $message .= "| savedpath:(UID:$userid): $path";
            DB::table('user_documents')->where('userid', $userid)->update(['duolingo' => $path]);
            $message .= " Duolingo Document Uploaded Successfully.";

            $this->appNotification("Duolingo", $userid);

            return response()->json(['res' => 'success', 'message' => 'Duolingo Document Uploaded Successfully.']);
        }

        \Log::debug("------StoreDocuments: END : " . $message);
        return redirect('admin/auth/user/' . $userid . '#docs')->withFlashSuccess("Documents uploaded successfully");
    }

    public function storeDocumentsPassport(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return response()->json([
                'success' => 0,
                'message' => 'You do not have access permission to this feature.'
            ]);
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $userid = $request->input('user_id');
        $single_file_max = config('app.doc_single_max_size') * 1024;
        $size_msg = $single_file_max / pow(1024, 1);
        $request->validate(
            [
                'files' => 'required',
                'files.*' => 'mimes:pdf,jpeg|max:' . $single_file_max,
            ],
            [
                'max' => 'The files may not be greater than ' . $size_msg . ' MB.',
            ]
        );

        if ($request->hasFile('files')) {
            foreach ($request->file('files') as $file) {
                $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
                $filename = str_replace(" ", "-", $filename);
                $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
                if (strlen($filename) > 20) {
                    $filename = substr($filename, 0, 20);
                }
                $filename .= "-" . round(microtime(true) * 1000);
                $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
                DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "passport", "file" => $path]);
            }
            $this->appNotification("Passport", $userid);
            return 'success';
        } else {
            return "error";
        }
    }

    public function storeDocumentsCv(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return response()->json([
                'success' => 0,
                'message' => 'You do not have access permission to this feature.'
            ]);
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $single_file_max = config('app.doc_single_max_size') * 1024;

        $size_msg = $single_file_max / pow(1024, 1);
        $request->validate(
            [
                'file' => 'required',
                'file' => 'mimes:doc,docx,pdf|max:' . $single_file_max,
            ],
            [
                'max' => 'The file may not be greater than ' . $size_msg . ' MB.',
            ]
        );

        $userid = $request->input('user_id');

        $file = $request->file('file');
        $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
        $filename = str_replace(" ", "-", $filename);
        $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
        if (strlen($filename) > 20) {
            $filename = substr($filename, 0, 20);
        }
        $filename .= "-" . round(microtime(true) * 1000);
        $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
        if (DB::table('user_docs_other')->where(["userid" => $userid, "doc_type" => "cv"])->exists()) {
            DB::table('user_docs_other')->where(["userid" => $userid, "doc_type" => "cv"])->update(["file" => $path]);
        } else {
            DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "cv", "file" => $path]);
        }
        $this->appNotification("CV", $userid);
        return "success";
    }

    public function storeDocumentsStuPhoto(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return response()->json([
                'success' => 0,
                'message' => 'You do not have access permission to this feature.'
            ]);
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $single_file_max = config('app.doc_single_max_size') * 1024;

        $size_msg = $single_file_max / pow(1024, 1);
        $request->validate(
            [
                'file' => 'required',
                'file' => 'mimes:jpg,jpeg,pdf|max:' . $single_file_max,
            ],
            [
                'max' => 'The file may not be greater than ' . $size_msg . ' MB.',
            ]
        );

        $userid = $request->input('user_id');

        $file = $request->file('file');
        $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
        $filename = str_replace(" ", "-", $filename);
        $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
        if (strlen($filename) > 20) {
            $filename = substr($filename, 0, 20);
        }
        $filename .= "-" . round(microtime(true) * 1000);
        $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
        if (DB::table('user_docs_other')->where(["userid" => $userid, "doc_type" => "stu_photo"])->exists()) {
            DB::table('user_docs_other')->where(["userid" => $userid, "doc_type" => "stu_photo"])->update(["file" => $path]);
        } else {
            DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "stu_photo", "file" => $path]);
        }
        $this->appNotification("Student Photograph", $userid);
        return "success";
    }

    public function storeDocumentsLor(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return response()->json([
                'success' => 0,
                'message' => 'You do not have access permission to this feature.'
            ]);
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $single_file_max = config('app.doc_single_max_size') * 1024;
        $size_msg = $single_file_max / pow(1024, 1);
        $request->validate(
            [
                'files' => 'required',
                'files.*' => 'mimes:pdf,jpeg|max:' . $single_file_max,
            ],
            [
                'max' => 'The files may not be greater than ' . $size_msg . ' MB.',
            ]
        );
        $userid = $request->input('user_id');
        if ($request->hasFile('files')) {
            foreach ($request->file('files') as $file) {
                $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
                $filename = str_replace(" ", "-", $filename);
                $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
                if (strlen($filename) > 20) {
                    $filename = substr($filename, 0, 20);
                }
                $filename .= "-" . round(microtime(true) * 1000);
                $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
                DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "letter_of_recommendation", "file" => $path]);
            }

            $this->appNotification("Lor", $userid);
            return 'success';
        } else {
            return "error";
        }
    }

    public function storeDocumentsExp(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return response()->json([
                'success' => 0,
                'message' => 'You do not have access permission to this feature.'
            ]);
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $single_file_max = config('app.doc_single_max_size') * 1024;
        $size_msg = $single_file_max / pow(1024, 1);
        $request->validate(
            [
                'files' => 'required',
                'files.*' => 'mimes:pdf,jpeg|max:' . $single_file_max,
            ],
            [
                'max' => 'The files may not be greater than ' . $size_msg . ' MB.',
            ]
        );
        $userid = $request->input('user_id');
        if ($request->hasFile('files')) {
            foreach ($request->file('files') as $file) {
                $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);

                $filename = str_replace(" ", "-", $filename);
                $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
                if (strlen($filename) > 20) {
                    $filename = substr($filename, 0, 20);
                }
                $filename .= "-" . round(microtime(true) * 1000);
                $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
                DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "experience", "file" => $path]);
            }

            $this->appNotification("Experience", $userid);
            return 'success';
        } else {
            return "error";
        }
    }

    public function storeDocumentsOther(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return response()->json([
                'success' => 0,
                'message' => 'You do not have access permission to this feature.'
            ]);
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $single_file_max = config('app.doc_single_max_size') * 1024;

        $size_msg = $single_file_max / pow(1024, 1);
        $request->validate(
            [
                'files' => 'required',
                'files.*' => 'mimes:pdf,jpeg|max:' . $single_file_max,
            ],
            [
                'max' => 'The files may not be greater than ' . $size_msg . ' MB.',
            ]
        );
        $userid = $request->input('user_id');
        if ($request->hasFile('files')) {
            foreach ($request->file('files') as $file) {
                $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);

                $filename = str_replace(" ", "-", $filename);
                $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
                if (strlen($filename) > 20) {
                    $filename = substr($filename, 0, 20);
                }
                $filename .= "-" . round(microtime(true) * 1000);
                $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
                DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "other", "file" => $path]);
            }
            $this->appNotification("Other", $userid);
            return 'success';
        } else {
            return "error";
        }
    }

    public function markDocumentsUploadDone(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return response()->json([
                'success' => 0,
                'message' => 'You do not have access permission to this feature.'
            ]);
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $userid = $request->input('user_id');
        $status = $request->input('docs_upload_completed');
        $user = User::find($userid);
        if ($status) {
            //No need to check current status
            // if($user->overseas_status == get_student_course_pref_status()) {
            $user->profile_complete = 'documents';
            $user->overseas_status = get_student_doc_upload_status();
            $user->save();

            $subject = _label('backend_student') . ": "  . $user->full_name . " (" . $user->id . ")" . ", Marked all documents upload completed";
            if (\Auth::user()->isAgent()) {
                $message = "Agent: " . get_user_full_name_by_id(\Auth::user()->id) . "Marked all documents upload completed for " .
                    "<br>" . _label('backend_student') . ": " . $user->full_name . " (" . $user->id . ")";
                $email_message = "Hi, <br>Agent: " . get_user_full_name_by_id(\Auth::user()->id) . "Marked all documents upload completed for " .
                    "<br>" . _label('backend_student') . ": " . $user->full_name . " (" . $user->id . ")";
            } else {
                $message = "Staff: " . get_user_full_name_by_id(\Auth::user()->id) . "Marked all documents upload completed for " .
                    "<br>" . _label('backend_student') . ": " . $user->full_name . " (" . $user->id . ")";
                $email_message = "Hi, <br>Staff: " . get_user_full_name_by_id(\Auth::user()->id) . "Marked all documents upload completed for " .
                    "<br>" . _label('backend_student') . ": " . $user->full_name . " (" . $user->id . ")";
            }

            //Sending email Notification
            send_mail_notification($user->id, "", "DOCUMENT_UPLOAD_BY_STUDENT", $subject, $email_message);

            //Sending In App Notification
            $subject = "";
            send_in_app_notification(
                $user->id,
                $user->id,
                "DOCUMENT_UPLOAD_BY_STUDENT",
                $subject,
                $message,
                "lead",
            );

            return redirect('admin/auth/user/' . $userid . '#docs')->withFlashSuccess("Documents status updated successfully");
            // }
        }


        return redirect('admin/auth/user/' . $userid . '#docs')->withFlashDanger("User Course Preferences not available, could not mark document upload Completed.");
    }

    public function coursePreferenceEdit($id)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return response()->json([
                'success' => 0,
                'message' => 'You do not have access permission to this feature.'
            ]);
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $pref = DB::table('course_preference')->where('id', $id)->first();

        $chkApp = DB::table('university_application')->where('course_pref_id', $id)->first();
        if ($chkApp && $chkApp->status != 'Pending') {
            return redirect()->back()->withFlashDanger("This cannot be edited, an University Applications exists.");
        }
        return view('backend.auth.user.edit-course-preference', compact('pref'));
    }

    public function updateCoursePreference(Request $request)
    {
        $request->validate([
            // 'country'  => 'required',
            // 'course'  => 'required',
            // 'intake_year'  => 'required',
            'intake'  => 'required',
        ]);

        $user = User::find($request->input('user_id'));
        $userid = $user->id;

        $intake = $request->input('intake');
        $inta =  explode(" ", $intake);

        if ($request->input('course') == '') {
            $course_preference_current = DB::table('course_preference')->where('id', $request->pref_id)->first();
            $course = $course_preference_current->course_id;
            $course_other = $course_preference_current->course_other;
        } else {
            if (filter_var($request->input('course'), FILTER_VALIDATE_INT) !== false) {
                $course = $request->input('course');
                $course_other = null;
            } else {
                $course = 0;
                $course_other = $request->input('course');
            }
        }

        if ($request->input('university') == '') {
            $course_preference_current = DB::table('course_preference')->where('id', $request->pref_id)->first();
            $university = $course_preference_current->university_id;
            $university_other = $course_preference_current->university_other;
        } else {
            if (filter_var($request->input('university'), FILTER_VALIDATE_INT) !== false) {
                $university = $request->input('university');
                $university_other = null;
            } else {
                $university = 0;
                $university_other = $request->input('university');
            }
        }

        DB::table('course_preference')->where('id', $request->pref_id)
            ->update(
                [
                    'intake_year' => $inta[1],
                    'intake' => $inta[0],
                    'course_other' => $course_other,
                    'course_id' => $course,
                    'university_other' => $university_other,
                    'university_id' => $university,
                ]
            );
        // DB::table('university_application')->where('course_pref_id', $request->pref_id)
        //     ->update(
        //         [
        //             'year' => $inta[1],
        //             'intake' => $inta[0]
        //         ]
        //     );

        // $intake = $request->input('intake');
        // if (count($intake)) {
        //     $intake_csv = implode(",", $intake);
        // }
        // DB::table('course_preference')->where('id', $request->pref_id)
        //             ->update(
        //                 [
        //                     'country' => $request->input('country'),
        //                     'course' => $request->input('course'),
        //                     'university' => $request->input('university'),
        //                     'intake_year' => $request->input('intake_year'),
        //                     'intake' => $intake_csv
        //                 ]
        //             );
        //return redirect()->route('admin.auth.user.show',$userid)->withFlashSuccess("Course preferences updated successfully");

        //store event in user activity
        UserActivity::create(['user_id' => $user->id, 'type' => 'admin_event', 'title' => get_user_full_name_by_id(\Auth::user()->id) . " Updated Course Preferences", 'detail' => ""]);

        return redirect('admin/auth/user/' . $userid . '#coursepreference')->withFlashSuccess("Course preferences updated successfully");
    }

    public function deleteCoursePref(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return response()->json([
                'success' => 0,
                'message' => 'You do not have access permission to this feature.'
            ]);
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $chkApp = DB::table('university_application')->where('course_pref_id', $request->id)->first();
        if ($chkApp && $chkApp->status != 'Pending') {
            return redirect()->back()->withFlashDanger("You cannot delete this course preference!");
        }
        $course_preference = DB::table('course_preference')->where('id', $request->id)->first();
        if (DB::table('course_preference')->where('id', $request->id)->delete()) {
            if (DB::table('university_application')->where('course_pref_id', $request->id)->exists()) {
                DB::table('university_application')->where('course_pref_id', $request->id)->delete();
            }
            //store event in user activity
            UserActivity::create(['user_id' => $course_preference->userid, 'type' => 'admin_event', 'title' => get_user_full_name_by_id(\Auth::user()->id) . " Deleted Course Preferences", 'detail' => ""]);

            // Send Push App Notification
            $user = User::where("id", $course_preference->userid)->first();
            $course = "";
            $university = "";
            $country = "";
            if ($course_preference->course_id) {
                $course = get_university_course_data($course_preference->course_id)->course_name;
            } elseif ($course_preference->course_other) {
                $course = $course_preference->course_other;
            }
            if ($course_preference->university_id) {
                $university = get_university_data($course_preference->university_id)->university_name;
            } elseif ($course_preference->university_other) {
                $university = $course_preference->university_other;
            }
            if ($course_preference->country_id) {
                $country = get_country_name($course_preference->country_id);
            }

            if (\Auth::user()->isAgent()) {
                $message = "Course Preference Deleted by Agent: " . get_user_full_name_by_id(\Auth::user()->id) .
                    "<br>Course: " . $course .
                    "<br>University: " . $university .
                    "<br>Country: " . $country .
                    "<br>" . _label('backend_student') . ": " . $user->full_name . " (" . $user->id . ")";

                $email_message = "Course Preference Deleted by Agent: " . get_user_full_name_by_id(\Auth::user()->id) .
                    "<br>Course: " . $course .
                    "<br>University: " . $university .
                    "<br>Country: " . $country .
                    "<br>" . _label('backend_student') . ": " . $user->full_name . " (" . $user->id . ")";
            } else {
                $message = "Course Preference Deleted by Staff: " . get_user_full_name_by_id(\Auth::user()->id) .
                    "<br>Course: " . $course .
                    "<br>University: " . $university .
                    "<br>Country: " . $country .
                    "<br>" . _label('backend_student') . ": " . $user->full_name . " (" . $user->id . ")";

                $email_message = "Course Preference Deleted by Staff: " . get_user_full_name_by_id(\Auth::user()->id) .
                    "<br>Course: " . $course .
                    "<br>University: " . $university .
                    "<br>Country: " . $country .
                    "<br>" . _label('backend_student') . ": " . $user->full_name . " (" . $user->id . ")";
            }

            $subject = "Course Preference Deleted for " . _label('backend_student') . ": " . $user->full_name . " (" . $user->id . ")";
            send_mail_notification($user->id, "", "LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE", $subject, $email_message);

            $subject = "";
            send_in_app_notification(
                $user->id,
                $user->id,
                "LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE",
                $subject,
                $message,
                "student",
            );

            return redirect('admin/auth/user/' . $course_preference->userid . '#coursepreference')->withFlashSuccess("Course Preferences Deleted Successfully");
        } else {
            return redirect('admin/auth/user/' . $course_preference->userid . '#coursepreference')->withFlashDanger("Something went wrong!");
        }
    }

    public function deleteVisaPref(Request $request)
    {
        $chkApp = DB::table('university_application')->where('course_pref_id', $request->id)->first();
        if ($chkApp && $chkApp->status != 'Payment Pending') {
            return redirect()->back()->withFlashDanger("You cannot delete this visa preference!");
        }
        $pref = DB::table('visa_preference')->where('id', $request->id)->delete();
        DB::table('university_application')->where('course_pref_id', $request->id)->delete();
        if ($pref) {
            return redirect()->back()->withFlashSuccess("Visa preferences deleted successfully.");
        } else {
            return redirect()->back()->withFlashDanger("Something went wrong!");
        }
    }


    public function deleteDocumentEdu(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return response()->json([
                'success' => 0,
                'message' => 'You do not have access permission to this feature.'
            ]);
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $doc = DB::table('user_documents')->where('userid', $request->id)->first();

        if ($request->type == "10th Certificate") {
            File::delete("storage/" . $doc->class10);
            DB::table('user_documents')->where('userid', $request->id)->update(['class10' => NULL]);
            return response()->json(['message' => '10th Certificate Deleted']);
        }
        if ($request->type == "10th Marks Sheet") {
            File::delete("storage/" . $doc->class10_marks_sheet);
            DB::table('user_documents')->where('userid', $request->id)->update(['class10_marks_sheet' => NULL]);
            return response()->json(['message' => '10th Marks Sheet Deleted']);
        }
        if ($request->type == "12th Certificate") {
            File::delete("storage/" . $doc->class12);
            DB::table('user_documents')->where('userid', $request->id)->update(['class12' => NULL]);
            return response()->json(['message' => '12th Certificate Deleted']);
        }
        if ($request->type == "12th Marks Sheet") {
            File::delete("storage/" . $doc->class12_marks_sheet);
            DB::table('user_documents')->where('userid', $request->id)->update(['class12_marks_sheet' => NULL]);
            return response()->json(['message' => '12th Marks Sheet Deleted']);
        }

        if ($request->type == "Diploma Certificate") {
            File::delete("storage/" . $doc->diploma);
            DB::table('user_documents')->where('userid', $request->id)->update(['diploma' => NULL]);
            return response()->json(['message' => 'Diploma Deleted']);
        }

        if ($request->type == "Diploma Marks Sheet") {
            File::delete("storage/" . $doc->diploma_marks_sheet);
            DB::table('user_documents')->where('userid', $request->id)->update(['diploma_marks_sheet' => NULL]);
            return response()->json(['message' => 'Diploma Marks Sheet Deleted']);
        }

        if ($request->type == "Bachelors Certificate") {
            File::delete("storage/" . $doc->grad_degree);
            DB::table('user_documents')->where('userid', $request->id)->update(['grad_degree' => NULL]);
            return response()->json(['message' => 'Bachelors Certificate Deleted']);
        }

        if ($request->type == "Bachelors Transcripts") {
            File::delete("storage/" . $doc->grad_transcripts);
            DB::table('user_documents')->where('userid', $request->id)->update(['grad_transcripts' => NULL]);
            return response()->json(['message' => 'Bachelors Transcripts Deleted']);
        }

        if ($request->type == "Bachelors All Sem Marks Sheet") {
            File::delete("storage/" . $doc->grad_all_sem);
            DB::table('user_documents')->where('userid', $request->id)->update(['grad_all_sem' => NULL]);
            return response()->json(['message' => 'Bachelors All Sem Marks Sheet Deleted']);
        }

        if ($request->type == "Masters Certificate") {
            File::delete("storage/" . $doc->pg_degree);
            DB::table('user_documents')->where('userid', $request->id)->update(['pg_degree' => NULL]);
            return response()->json(['message' => 'Masters Certificate Deleted']);
        }

        if ($request->type == "Masters Transcripts") {
            File::delete("storage/" . $doc->pg_transcripts);
            DB::table('user_documents')->where('userid', $request->id)->update(['pg_transcripts' => NULL]);
            return response()->json(['message' => 'Masters Transcripts Deleted']);
        }

        if ($request->type == "Masters All Sem Marks Sheet") {
            File::delete("storage/" . $doc->pg_all_sem);
            DB::table('user_documents')->where('userid', $request->id)->update(['pg_all_sem' => NULL]);
            return response()->json(['message' => 'Masters All Sem Marks Sheet Deleted']);
        }

        if ($request->type == "IELTS") {
            File::delete("storage/" . $doc->lang_ielts);
            DB::table('user_documents')->where('userid', $request->id)->update(['lang_ielts' => NULL]);
            return response()->json(['message' => 'IELTS Certificate Deleted']);
        }
        if ($request->type == "PTE") {
            File::delete("storage/" . $doc->lang_pte);
            DB::table('user_documents')->where('userid', $request->id)->update(['lang_pte' => NULL]);
            return response()->json(['message' => 'PTE Certificate Deleted']);
        }
        if ($request->type == "GRE") {
            File::delete("storage/" . $doc->gre);
            DB::table('user_documents')->where('userid', $request->id)->update(['gre' => NULL]);
            return response()->json(['message' => 'GRE Certificate Deleted']);
        }
        if ($request->type == "GMAT") {
            File::delete("storage/" . $doc->gmat);
            DB::table('user_documents')->where('userid', $request->id)->update(['gmat' => NULL]);
            return response()->json(['message' => 'GMAT Certificate Deleted']);
        }
        if ($request->type == "TOEFL") {
            File::delete("storage/" . $doc->toefl);
            DB::table('user_documents')->where('userid', $request->id)->update(['toefl' => NULL]);
            return response()->json(['message' => 'TOEFL Certificate Deleted']);
        }
        if ($request->type == "DUOLINGO") {
            File::delete("storage/" . $doc->duolingo);
            DB::table('user_documents')->where('userid', $request->id)->update(['duolingo' => NULL]);
            return response()->json(['message' => 'Duolingo Certificate Deleted']);
        }
    }

    public function deleteDocumentPro(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return response()->json([
                'success' => 0,
                'message' => 'You do not have access permission to this feature.'
            ]);
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        if ($request->type == "EXP") {
            $exp = DB::table('user_docs_other')->where('id', $request->id)->first();
            File::delete("storage/" . $exp->file);
            DB::table('user_docs_other')->where('id', $request->id)->delete();
            return response()->json(['message' => 'Experience Document Deleted']);
        }

        if ($request->type == "Internship") {
            $exp = DB::table('user_docs_other')->where('id', $request->id)->first();
            File::delete("storage/" . $exp->file);
            DB::table('user_docs_other')->where('id', $request->id)->delete();
            return response()->json(['message' => 'Internship Document Deleted']);
        }

        if ($request->type == "Offer Letter") {
            $exp = DB::table('user_docs_other')->where('id', $request->id)->first();
            File::delete("storage/" . $exp->file);
            DB::table('user_docs_other')->where('id', $request->id)->delete();
            return response()->json(['message' => 'Offer Letter Deleted']);
        }

        if ($request->type == "Payslip") {
            $exp = DB::table('user_docs_other')->where('id', $request->id)->first();
            File::delete("storage/" . $exp->file);
            DB::table('user_docs_other')->where('id', $request->id)->delete();
            return response()->json(['message' => 'Payslip Deleted']);
        }

        if ($request->type == "Others") {
            $exp = DB::table('user_docs_other')->where('id', $request->id)->first();
            File::delete("storage/" . $exp->file);
            DB::table('user_docs_other')->where('id', $request->id)->delete();
            return response()->json(['message' => 'Other Document Deleted']);
        }

        if ($request->type == "SOP") {
            $exp = DB::table('user_docs_other')->where('id', $request->id)->first();
            File::delete("storage/" . $exp->file);
            DB::table('user_docs_other')->where('id', $request->id)->delete();
            return response()->json(['message' => 'SOP Document Deleted']);
        }

        if ($request->type == "LOR") {
            $exp = DB::table('user_docs_other')->where('id', $request->id)->first();
            File::delete("storage/" . $exp->file);
            DB::table('user_docs_other')->where('id', $request->id)->delete();
            return response()->json(['message' => 'LOR Document Deleted']);
        }

        if ($request->type == "CV") {
            $exp = DB::table('user_docs_other')->where(['userid' => $request->id, 'doc_type' => 'cv'])->first();
            File::delete("storage/" . $exp->file);
            DB::table('user_docs_other')->where('id', $exp->id)->delete();
            return response()->json(['message' => 'CV Document Deleted']);
        }

        if ($request->type == "STU_PHOTO") {
            $exp = DB::table('user_docs_other')->where(['userid' => $request->id, 'doc_type' => 'stu_photo'])->first();
            File::delete("storage/" . $exp->file);
            DB::table('user_docs_other')->where('id', $exp->id)->delete();
            return response()->json(['message' => 'Student Photograph Deleted']);
        }

        if ($request->type == "Passport") {
            $exp = DB::table('user_docs_other')->where(['id' => $request->id, 'doc_type' => 'passport'])->first();
            File::delete("storage/" . $exp->file);
            DB::table('user_docs_other')->where('id', $exp->id)->delete();
            return response()->json(['message' => 'Passport Document Deleted']);
        }

        if ($request->type == "Essay") {
            $exp = DB::table('user_docs_other')->where(['id' => $request->id, 'doc_type' => 'essay'])->first();
            File::delete("storage/" . $exp->file);
            DB::table('user_docs_other')->where('id', $exp->id)->delete();
            return response()->json(['message' => 'Essay Document Deleted']);
        }
    }

    public function update_followup(Request $request, $id)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $request->validate([
            'followup_details' => 'required',
            'communication_mode' => 'required',
            'application_status' => 'required',
            'next_followup' => 'nullable|after:' . date('Y-m-d H:i:s')
        ]);
        $user = User::find($id);
        $comm_mode = $appl_status = "";

        if ($request->communication_mode) {
            $comm_mode = "<br><br><b>Mode of communication:</b> " . $request->communication_mode;
        }
        if ($request->application_status) {
            $appl_status = "<br><b>Application Status:</b> " . $request->application_status;
        }
        if ($user) {
            //Adding activity
            $followup = new UserActivity;
            $followup->user_id = $user->id;
            $followup->title = "New Followup Added";
            $followup->type = 'followup';
            $followup->staff = \Auth::user()->id;
            $followup->communication_mode = $request->communication_mode;
            $followup->application_status = $request->application_status;
            $followup->detail = nl2br($request->get('followup_details')) . $comm_mode . $appl_status;
            $followup->save();

            if ($request->input('next_followup')) {
                $user->next_followup = date("Y-m-d H:i", strtotime($request->get('next_followup')));
            } else {
                $user->next_followup = NULL;
            }
            $user->save();
            return redirect()->route('admin.auth.user.show', $id)->withFlashSuccess('Follow-up saved!');
        } else {
            return redirect()->route('admin.auth.user.show', $id)->withFlashDanger('Invalid User!');
        }
    }

    public function add_notes(Request $request, $id)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $request->validate([
            'confidential_notes' => 'required'
        ]);
        $user = User::find($id);

        if ($user) {
            //Adding note
            $note = new UserNotes;
            $note->user_id = $user->id;
            $note->notes =  $request->confidential_notes;
            $note->staff_id = \Auth::user()->id;
            $note->save();

            $user->save();
            return redirect()->route('admin.auth.user.show', $id)->withFlashSuccess('Note saved!');
        } else {
            return redirect()->route('admin.auth.user.show', $id)->withFlashDanger('Invalid User!');
        }
    }

    public function convertStudentLead($id)
    {
        $users = User::findOrFail($id);
        // if (!$this->hasAccessPermission($users)) {
        //     return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        // }
        return view('backend.auth.user.show.tabs.student-lead-convert-modal', compact('users'));
    }

    public function updateConvertStudentLead(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        // dd($request->all());
        $users = User::findOrFail($request->users_id);
        $users->is_lead = 1;
        $users->lead_status = $request->user_status;
        $users->lead_converted_date = NULL;
        $users->student_created_at = NULL;
        $users->save();

        $student = new UserActivity;
        $student->user_id = $users->id;
        $student->title = "Student Converted Back To Lead";
        $student->type = 'admin_event';
        $student->staff = \Auth::user()->id;
        $student->detail = "Student Converted Back To Lead. Lead Status: " . $request->user_status;
        $student->save();

        // Send Push App Notification
        if (\Auth::user()->isAgent()) {
            $message = "Student <strong>" . $users->full_name . "</strong> (" . $users->id . ") Converted Back To Lead by Agent: " . get_user_full_name_by_id(\Auth::user()->id) . " <br />Lead Status: " . $request->user_status;;
            $email_message = "Hi, <br><br>Student Converted Back To Lead by Agent: " . get_user_full_name_by_id(\Auth::user()->id) . " <br />Lead Status: " . $request->user_status;;
        } else {
            $message = "Student <strong>" . $users->full_name . "</strong> (" . $users->id . ") Converted Back To Lead by " . get_user_full_name_by_id(\Auth::user()->id) . " <br />Lead Status: " . $request->user_status;;
            $email_message = "Hi, <br><br>Student Converted Back To Lead by Staff: " . get_user_full_name_by_id(\Auth::user()->id) . " <br />Lead Status: " . $request->user_status;;
        }

        // New way to send email
        //Sending email Notification
        $subject = "Student: " . $users->full_name . " (" . $users->id . ") Converted Back To Lead by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
        $email_message_part = "<br />Mobile:$users->mobile<br /><br />Email: $users->email <br/><br/><a href=\"" . url("admin/leads/" . $users->id) . "\">View Lead Details</a>";
        $email_message .= "<br><br>Lead: " . $users->full_name . " (" . $users->id . ") Converted Back To Lead by Staff: " . get_user_full_name_by_id(\Auth::user()->id) . "<br />" . $email_message_part;
        send_mail_notification($users->id, "", "STUDENT_PROFILE_UPDATED", $subject, $email_message);

        $subject = "";
        send_in_app_notification(
            $users->id,
            $users->id,
            "STUDENT_PROFILE_UPDATED",
            $subject,
            $message,
            "lead"
        );

        return redirect()->route('admin.auth.user.show', $users->id)->withFlashSuccess('Student Converted To Lead Successfully!');
    }

    public function searchCourseById(Request $request)
    {
        $data = DB::table('university_courses')
            ->join('universities', 'university_courses.university', '=', 'universities.id')
            ->join('countries', 'universities.country', '=', 'countries.id')
            ->select('university_courses.id as course_id', 'university_courses.course_name', 'universities.id as university_id', 'universities.university_name', 'universities.country as country_id', 'countries.title_en')
            ->where("university_courses.id", $request->search_course_id)
            ->where('university_courses.study_level', $request->s_level)
            ->get();
        // dd($data);
        return response()->json($data);
    }

    // Academics Details add_enrollment_history_model
    public function addAcademicsInformation()
    {
        $countries = Country::orderBy('title_en')->select('id', 'title_en as name')->get();
        return view('backend.auth.user.student-details-add-edit-modal.add_academics_detail_modal', ['countries' => $countries]);
    }

    // delete Basic academic details from user_academics table
    public function academicsInformationDelete(Request $request)
    {
        $userAcademicsDetail = DB::table('user_academics')->where('id', $request->id)->first();
        if ($userAcademicsDetail) {
            DB::table('user_academics')->where('id', $request->id)->delete();
            return redirect()->route('admin.student.edit', $userAcademicsDetail->userid)->withFlashSuccess("Academics Details Deleted Successfully");
        } else {
            return redirect()->route('admin.student.edit', ['id' => $request->userid])->withFlashDanger("Academics Details Not Found!");
        }
    }
    //for get edit information on the modal of the editacademics
    public function editAcademicsInformation($id)
    {
        $countries = Country::orderBy('title_en')->select('id', 'title_en as name')->get();
        $profile_academic = DB::table('user_academics')->where('id', $id)->first();

        return view('backend.auth.user.student-details-add-edit-modal.edit_academics_detail_modal', compact('profile_academic'), ['countries' => $countries]);
    }



    //add acedemic details
    public function storeAcademicProfile(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $request->validate([
            'education_level' => 'required|max:100',
            'course_name' => 'max:100',
            'institute' => 'required|max:100',
            'university' => 'required|max:100',
            'institute_country' => 'required|numeric',
            'campus_city' => 'max:100',
            'postal_code' => 'max:45',
            'start_year' => 'nullable|numeric|before_or_equal:' . now()->year,
            'pass_year' => 'required|numeric|before_or_equal:' . now()->year,
            'percent_cgpa' => 'required|numeric',
            'course_name' => 'required|max:100',
            'course_status' => 'required|max:50',
        ]);
        if ($request->start_year) {

            $request->validate(['pass_year' => 'after_or_equal:' . $request->start_year]);
        }
        // dd($request->start_year);
        if ($request->academics_id) {
            $userAcademicsDetail = DB::table('user_academics')->where('id', $request->academics_id)->update([
                'userid'    => $request->get('userid'),
                'education_level' => $request->get('education_level'),
                'course_name' => $request->get('course_name'),
                'institute' => $request->get('institute'),
                'university' => $request->get('university'),
                'institute_country' => $request->get('institute_country'),
                'campus_city' => $request->get('campus_city'),
                'postal_code' => $request->get('postal_code'),
                'start_year' => $request->get('start_year'),
                'pass_year' => $request->get('pass_year'),
                'course_status' => $request->get('course_status'),
                'percent_cgpa' => $request->get('percent_cgpa'),
            ]);
            return redirect()->route('admin.student.edit', $request->get('userid'))->withFlashSuccess("Academics Details Updated Successfully");
        } else {
            $userAcademicsDetail = DB::table('user_academics')->insert([
                'userid'    => $request->get('user_id'),
                'education_level' => $request->get('education_level'),
                'course_name' => $request->get('course_name'),
                'institute' => $request->get('institute'),
                'university' => $request->get('university'),
                'institute_country' => $request->get('institute_country'),
                'campus_city' => $request->get('campus_city'),
                'postal_code' => $request->get('postal_code'),
                'start_year' => $request->get('start_year'),
                'pass_year' => $request->get('pass_year'),
                'course_status' => $request->get('course_status'),
                'percent_cgpa' => $request->get('percent_cgpa'),
            ]);
            return redirect()->route('admin.student.edit', $request->get('user_id'))->withFlashSuccess("Academics Details Added Successfully");
        }
    }
    //for get edit information on the modal of the editinternship
    public function editInternshipInformation($id)
    {
        $profile_internship = DB::table('user_internship')->where('id', $id)->first();

        return view('backend.auth.user.student-details-add-edit-modal.edit_internship_modal', compact('profile_internship'));
    }

    //for get add information on the modal of the editinternship
    public function addInternshipInformation()
    {
        return view('backend.auth.user.student-details-add-edit-modal.add_internship_modal');
    }
    //add internship profile
    public function storeInternshipProfile(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $request->validate([
            'company' => 'required|max:100',
            'duration' => 'required|max:100',
            'place' => 'required|max:100',

        ]);
        if ($request->internship_id) {
            $userAcademicsDetail = DB::table('user_internship')->where('id', $request->internship_id)->update([
                'userid'    => $request->get('userid'),
                'company' => $request->get('company'),
                'duration' => $request->get('duration'),
                'place' => $request->get('place'),

            ]);
            return redirect()->route('admin.student.edit', $request->get('userid'))->withFlashSuccess("Internship Details Updated Successfully");
        } else {
            $userAcademicsDetail = DB::table('user_internship')->insert([
                'userid'    => $request->get('userid'),
                'company' => $request->get('company'),
                'duration' => $request->get('duration'),
                'place' => $request->get('place'),

            ]);
            return redirect()->route('admin.student.edit', $request->get('userid'))->withFlashSuccess("Academics Details Added Successfully");
        }
    }

    // delete internship details from user_internship  table
    public function InternshipProfileDelete(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $userInternshipDetail = DB::table('user_internship')->where('id', $request->id)->first();
        if ($userInternshipDetail) {
            DB::table('user_internship')->where('id', $request->id)->delete();
            return redirect()->route('admin.student.edit', $userInternshipDetail->userid)->withFlashSuccess("Internship Details Deleted Successfully");
        } else {
            return redirect()->route('admin.student.edit', ['id' => $request->userid])->withFlashDanger("Internship Details Not Found!");
        }
    }
    //for get add Course on the modal of the editinternship
    public function addCourseInformation()
    {
        return view('backend.auth.user.student-details-add-edit-modal.add_course_modal');
    }
    //for get edit information on the modal of the editcourse
    public function editCourseInformation($id)
    {
        $profile_course = DB::table('user_courses')->where('id', $id)->first();

        return view('backend.auth.user.student-details-add-edit-modal.edit_course_modal', compact('profile_course'));
    }
    // add courses
    public function storeCourseProfile(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $request->validate([
            'course' => 'required|max:100',
            'duration' => 'required|max:100',
            'institute' => 'required|max:100',

        ]);
        if ($request->course_id) {
            $userAcademicsDetail = DB::table('user_courses')->where('id', $request->course_id)->update([
                'userid'    => $request->get('userid'),
                'course' => $request->get('course'),
                'duration' => $request->get('duration'),
                'institute' => $request->get('institute'),

            ]);
            return redirect()->route('admin.student.edit', $request->get('userid'))->withFlashSuccess("Course Details Updated Successfully");
        } else {
            $userAcademicsDetail = DB::table('user_courses')->insert([
                'userid'    => $request->get('userid'),
                'course' => $request->get('course'),
                'duration' => $request->get('duration'),
                'institute' => $request->get('institute'),

            ]);
            return redirect()->route('admin.student.edit', $request->get('userid'))->withFlashSuccess("Course Details Added Successfully");
        }
    }

    // delete other course details from user_courses  table
    public function CourseProfileDelete(Request $request)
    {
        $userCourseDetail = DB::table('user_courses')->where('id', $request->id)->first();
        if ($userCourseDetail) {
            DB::table('user_courses')->where('id', $request->id)->delete();
            return redirect()->route('admin.student.edit', $userCourseDetail->userid)->withFlashSuccess("Other Courses Details Deleted Successfully");
        } else {
            return redirect()->route('admin.student.edit', ['id' => $request->userid])->withFlashDanger("Other Courses Details Not Found!");
        }
    }

    // Academics Details add_enrollment_history_model
    public function addFamilyInformation()
    {
        $dialcodes = Country::groupBy('tel')->orderBy('tel', 'asc')->get(['tel as code', 'title_en as name']);
        $countries = Country::orderBy('title_en')->select('id', 'title_en as name')->get();
        return view('backend.auth.user.student-details-add-edit-modal.add_family_detail_modal', ['countries' => $countries, 'dialcodes' => $dialcodes]);
    }
    //for get edit information on the modal of the editinternship
    public function editFamilyInformation($id)
    {
        $profile_family = DB::table('user_family')->where('id', $id)->first();
        $dialcodes = Country::groupBy('tel')->orderBy('tel', 'asc')->get(['tel as code', 'title_en as name']);
        $countries = Country::orderBy('title_en')->select('id', 'title_en as name')->get();
        return view('backend.auth.user.student-details-add-edit-modal.edit_family_detail_modal', compact('profile_family', 'countries', 'dialcodes'));
    }
    //add family details
    public function storeFamilyProfile(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $request->validate([
            'first_name' => 'required|max:100|regex:/^[\pL\s]+$/u',
            'last_name' => 'required|max:100|regex:/^[\pL\s]+$/u',
            'gender' => 'required|max:10',
            'email' => 'nullable|max:100',
            'dial_code' => 'nullable|numeric',
            'mobile' => 'nullable',
            'birth_date' => 'nullable|before:' . now(),
            'birth_country' => 'nullable|max:100',
            'residence_country' => 'nullable',
            'relationship' => 'required|max:100',
        ]);
        if ($request->family_id) {
            $userFamilyDetail = DB::table('user_family')->where('id', $request->family_id)->update([
                'userid'    => $request->get('userid'),
                'first_name' => $request->get('first_name'),
                'last_name' => $request->get('last_name'),
                'relationship' => $request->get('relationship'),
                'gender' => $request->get('gender'),
                'email' => $request->get('email'),
                'dial_code' => $request->get('dial_code'),
                'mobile' => $request->get('mobile'),
                'birth_date' => $request->get('birth_date'),
                'birth_country' => $request->get('birth_country'),
                'residence_country' => $request->get('residence_country'),
            ]);
            return redirect()->route('admin.student.edit', $request->get('userid'))->withFlashSuccess("Family Details Updated Successfully");
        } else {
            $birthDate = $request->get('birth_date');
            if ($birthDate) {
                $birthDate=  substr($birthDate, 6, 4) . "-" . substr($birthDate, 3, 2) . "-" . substr($birthDate, 0, 2);
            }
            $userFamilyDetail = DB::table('user_family')->insert([
                'userid'    => $request->get('userid'),
                'first_name' => $request->get('first_name'),
                'last_name' => $request->get('last_name'),
                'relationship' => $request->get('relationship'),
                'gender' => $request->get('gender'),
                'email' => $request->get('email'),
                'dial_code' => $request->get('dial_code'),
                'mobile' => $request->get('mobile'),
                'birth_date' =>  $birthDate,
                'birth_country' => $request->get('birth_country'),
                'residence_country' => $request->get('residence_country'),
            ]);
            return redirect()->route('admin.student.edit', $request->get('userid'))->withFlashSuccess("Family Details Added Successfully");
        }
    }
 // delete family  details from user_family  table
 public function FamilyProfileDelete(Request $request)
 {
    $userFamilyDetail = DB::table('user_family')->where('id', $request->id)->first();
    if ($userFamilyDetail) {
        DB::table('user_family')->where('id', $request->id)->delete();
        return redirect()->route('admin.student.edit', $userFamilyDetail->userid)->withFlashSuccess("Family Details Deleted Successfully");
    } else {
        return redirect()->route('admin.student.edit', ['id' => $request->userid])->withFlashDanger("Family Details Not Found!");
    }
 }
    // Employment History
    public function addEmployment()
    {
        $countries = Country::orderBy('title_en')->select('id', 'title_en as name')->get();
        return view('backend.auth.user.student-details-add-edit-modal.add_employment_history_modal', ['countries' => $countries]);
    }
    //edit employment
    public function editEmployment($id)
    {
        $countries = Country::orderBy('title_en')->select('id', 'title_en as name')->get();
        $profile_employment_detail = DB::table('employment_detail')->where('id', $id)->first();
        return view('backend.auth.user.student-details-add-edit-modal.edit_employment_history_modal', ['profile_employment_detail' => $profile_employment_detail, 'countries' => $countries]);
    }
    //store employment details
    public function employmentSave(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $request->validate([
            "employment_histroy_type" => "required",
            "employment_history_currently_working" => "required",
            "employment_history_industry_type" => "required|max:100",
            "employment_history_organisation_name" => "required|max:100",
            "employment_history_employer_phone" => "nullable",
            "employment_history_address" => "required|max:100",
            "employment_history_country" => "required|max:100",
            "employment_history_state" => "required|max:100",
            "employment_history_city" => "required|max:100",
            "employment_history_postcode" => "nullable|max:10",
            "employment_history_contact_person_name" => "required|max:100|regex:/^[\pL\s]+$/u",
            "employment_history_contact_person_mobile_number" => "nullable",
            "employment_history_contact_person_business_phone" => "nullable",
            "employment_history_working_position_occupation" => "required|max:100",
            "employment_history_start_date" => "required|before:" . now(),
            "employment_history_working_ended" => "nullable|before:" . now()
        ]);
        if ($request->employment_history_start_date) {
            $request->validate(["employment_history_working_ended" => "nullable|after:" . $request->employment_history_start_date]);
        }
        if (!empty($request->input('employment_history_start_date'))) {
            $employment_history_start_date = substr($request->input('employment_history_start_date'), 6, 4) . "-" . substr($request->input('employment_history_start_date'), 3, 2) . "-" . substr($request->input('employment_history_start_date'), 0, 2);
        } else {
            $employment_history_start_date = NULL;
        }

        if (!empty($request->input('employment_history_working_ended'))) {
            $employment_history_working_ended = substr($request->input('employment_history_working_ended'), 6, 4) . "-" . substr($request->input('employment_history_working_ended'), 3, 2) . "-" . substr($request->input('employment_history_working_ended'), 0, 2);
        } else {
            $employment_history_working_ended = NULL;
        }

        if ($request->employment_id) {
            $employmentHistory = DB::table('employment_detail')->where('id', $request->employment_id)->update([
                'userid' => $request->get('userid'),
                'employment_histroy_type' => $request->get('employment_histroy_type'),
                'employment_history_currently_working' => $request->get('employment_history_currently_working'),
                'employment_history_organisation_name' => $request->get('employment_history_organisation_name'),
                'employment_history_industry_type' => $request->get('employment_history_industry_type'),
                'employment_history_employer_phone' => $request->get('employment_history_employer_phone'),
                'employment_history_address' => $request->get('employment_history_address'),
                'employment_history_postcode' => $request->get('employment_history_postcode'),
                'employment_history_country' => $request->get('employment_history_country'),
                'employment_history_state' => $request->get('employment_history_state'),
                'employment_history_city' => $request->get('employment_history_city'),
                'employment_history_contact_person_name' => $request->get('employment_history_contact_person_name'),
                'employment_history_contact_person_family_name' => $request->get('employment_history_contact_person_family_name'),
                'employment_history_contact_person_mobile_number' => $request->get('employment_history_contact_person_mobile_number'),
                'employment_history_contact_person_business_phone' => $request->get('employment_history_contact_person_business_phone'),
                'employment_history_working_position_occupation' => $request->get('employment_history_working_position_occupation'),
                'employment_history_start_date' => $employment_history_start_date,
                'employment_history_working_ended' => $employment_history_working_ended,
            ]);
            return redirect()->route('admin.student.edit', $request->get('userid'))->withFlashSuccess("Employment History Updated Successfully");
        } else {
            $employmentHistory = DB::table('employment_detail')->insert([
                'userid' => $request->get('userid'),
                'employment_histroy_type' => $request->get('employment_histroy_type'),
                'employment_history_currently_working' => $request->get('employment_history_currently_working'),
                'employment_history_organisation_name' => $request->get('employment_history_organisation_name'),
                'employment_history_industry_type' => $request->get('employment_history_industry_type'),
                'employment_history_employer_phone' => $request->get('employment_history_employer_phone'),
                'employment_history_address' => $request->get('employment_history_address'),
                'employment_history_postcode' => $request->get('employment_history_postcode'),
                'employment_history_country' => $request->get('employment_history_country'),
                'employment_history_state' => $request->get('employment_history_state'),
                'employment_history_city' => $request->get('employment_history_city'),
                'employment_history_contact_person_name' => $request->get('employment_history_contact_person_name'),
                'employment_history_contact_person_family_name' => $request->get('employment_history_contact_person_family_name'),
                'employment_history_contact_person_mobile_number' => $request->get('employment_history_contact_person_mobile_number'),
                'employment_history_contact_person_business_phone' => $request->get('employment_history_contact_person_business_phone'),
                'employment_history_working_position_occupation' => $request->get('employment_history_working_position_occupation'),
                'employment_history_start_date' => $employment_history_start_date,
                'employment_history_working_ended' => $employment_history_working_ended,
            ]);
            return redirect()->route('admin.student.edit', $request->get('userid'))->withFlashSuccess("Employment History Added Successfully");
        }
    }

    // delete Employment  details from employment_detail  table
    public function EmploymentDelete(Request $request)
    {
        $userEmploymentDetail = DB::table('employment_detail')->where('id', $request->id)->first();
        if ($userEmploymentDetail) {
            DB::table('employment_detail')->where('id', $request->id)->delete();
            return redirect()->route('admin.student.edit', $userEmploymentDetail->userid)->withFlashSuccess("Employment Details Deleted Successfully");
        } else {
            return redirect()->route('admin.student.edit', ['id' => $request->userid])->withFlashDanger("Employment Details Not Found!");
        }
    }

    // Travel History
    public function addTravelHistory()
    {
        $countries = Country::orderBy('title_en')->select('id', 'title_en as name')->get();
        return view('backend.auth.user.student-details-add-edit-modal.add_travel_history_modal', ['countries' => $countries]);
    }

    public function editTravelHistory($id)
    {
        $countries = Country::orderBy('title_en')->select('id', 'title_en as name')->get();
        $profile_travel_history = DB::table('travel_history')->where('id', $id)->first();
        return view('backend.auth.user.student-details-add-edit-modal.edit_travel_history_modal', ['profile_travel_history' => $profile_travel_history, 'countries' => $countries]);
    }

    public function travelHistorySave(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
           
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $request->validate([
            "country_visited" => "required",
            "name_used_on_country" => "required|regex:/^[\pL\s]+$/u",
            "visa_type" => "required|max:100",
            "visa_issue_at" => "required|max:100",
            "date_from" => "required|before:" . now(),
            "date_up_to" => "required|before:" . now() . '|after:' . $request->date_from,
        ]);
        if (!empty($request->input('date_from'))) {
            $date_from = substr($request->input('date_from'), 6, 4) . "-" . substr($request->input('date_from'), 3, 2) . "-" . substr($request->input('date_from'), 0, 2);
        } else {
            $date_from = NULL;
        }

        if (!empty($request->input('date_up_to'))) {
            $date_up_to = substr($request->input('date_up_to'), 6, 4) . "-" . substr($request->input('date_up_to'), 3, 2) . "-" . substr($request->input('date_up_to'), 0, 2);
        } else {
            $date_up_to = NULL;
        }

        if ($request->travel_id) {
            $userTravelHistory = ProfileTravelHistory::where('id', $request->travel_id)->first();
            $userTravelHistory->userid = $request->get('userid');
            $userTravelHistory->country_visited = $request->get('country_visited');
            $userTravelHistory->name_used_on_country = $request->get('name_used_on_country');
            $userTravelHistory->visa_type = $request->get('visa_type');
            $userTravelHistory->visa_issue_at = $request->get('visa_issue_at');
            $userTravelHistory->date_from = $date_from;
            $userTravelHistory->date_up_to = $date_up_to;
            $userTravelHistory->reason_of_visit = $request->get('reason_of_visit');
            $userTravelHistory->save();
            return redirect()->route('admin.student.edit', $request->get('userid'))->withFlashSuccess("Travel History Updated Successfully");
        } else {
            $userTravelHistory = new ProfileTravelHistory([
                'userid'    => $request->get('user_id'),
                'country_visited' => $request->get('country_visited'),
                'name_used_on_country' => $request->get('name_used_on_country'),
                'visa_type' => $request->get('visa_type'),
                'visa_issue_at' => $request->get('visa_issue_at'),
                'date_from' => $date_from,
                'date_up_to' => $date_up_to,
                'reason_of_visit' => $request->get('reason_of_visit'),
            ]);
            $userTravelHistory->save();
            return redirect()->route('admin.student.edit', $request->get('user_id'))->withFlashSuccess("Travel History Added Successfully");
        }
    }


     // delete Travel history  details from ProfileTravelHistory  table
     public function travelHistoryDelete(Request $request)
     {
         $userTravelDetail = ProfileTravelHistory::where('id', $request->id)->first();
         if ($userTravelDetail) {
             ProfileTravelHistory::where('id', $request->id)->delete();
             return redirect()->route('admin.student.edit', $userTravelDetail->userid)->withFlashSuccess("Travel History Deleted Successfully");
         } else {
             return redirect()->route('admin.student.edit', ['id' => $request->userid])->withFlashDanger("Travel History Not Found!");
         }
     }



    // Visa history
    public function addVisaHistory()
    {
        $countries = Country::orderBy('title_en')->select('id', 'title_en as name')->get();
        return view('backend.auth.user.student-details-add-edit-modal.add_visa_history_modal', ['countries' => $countries]);
    }

    public function editVisaHistory($id)
    {
        $countries = Country::orderBy('title_en')->select('id', 'title_en as name')->get();
        $visa_application_history = DB::table('visa_application_history')->where('id', $id)->first();
        return view('backend.auth.user.student-details-add-edit-modal.edit_visa_history_modal', ['visa_application_history' => $visa_application_history, 'countries' => $countries]);
    }

    public function visaHistorySave(Request $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('manage students'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $request->validate([
            'country_applied_for_visa' => 'required',
            'name_used_for_visa_apply' => 'required|max:100|regex:/^[\pL\s]+$/u',
            'visa_apply_visa_type' => 'required|max:100',
            'visa_apply_application_date' => 'required|before:' . now(),
            'visa_apply_application_number' => 'required|max:100',
            'visa_apply_outcome' => 'required|max:100'
        ]);
        if (!empty($request->input('visa_apply_application_date'))) {
            $visa_apply_application_date = substr($request->input('visa_apply_application_date'), 6, 4) . "-" . substr($request->input('visa_apply_application_date'), 3, 2) . "-" . substr($request->input('visa_apply_application_date'), 0, 2);
        } else {
            $visa_apply_application_date = NULL;
        }

        if ($request->visa_id) {
            $userVisaHistory = ProfileVisaApplicationHistory::where('id', $request->visa_id)->first();
            $userVisaHistory->user_id = $request->get('user_id');
            $userVisaHistory->country_applied_for_visa = $request->get('country_applied_for_visa');
            $userVisaHistory->name_used_for_visa_apply = $request->get('name_used_for_visa_apply');
            $userVisaHistory->visa_apply_visa_type = $request->get('visa_apply_visa_type');
            $userVisaHistory->visa_apply_application_date = $visa_apply_application_date;
            $userVisaHistory->visa_apply_application_number = $request->get('visa_apply_application_number');
            $userVisaHistory->visa_apply_outcome = $request->get('visa_apply_outcome');
            $userVisaHistory->save();
            return redirect()->route('admin.student.edit', $request->get('user_id'))->withFlashSuccess("Visa History Updated Successfully");
        } else {
            $userVisaHistory = new ProfileVisaApplicationHistory([
                'user_id'    => $request->get('user_id'),
                'country_applied_for_visa' => $request->get('country_applied_for_visa'),
                'name_used_for_visa_apply' => $request->get('name_used_for_visa_apply'),
                'visa_apply_visa_type' => $request->get('visa_apply_visa_type'),
                'visa_apply_application_date' => $visa_apply_application_date,
                'visa_apply_application_number' => $request->get('visa_apply_application_number'),
                'visa_apply_outcome' => $request->get('visa_apply_outcome'),
            ]);
            $userVisaHistory->save();
            return redirect()->route('admin.student.edit', $request->get('user_id'))->withFlashSuccess("Visa History Added Successfully");
        }
    }
    // delete Visa  details from ProfileVisaApplicationHistory  table
    public function VisaDelete(Request $request)
    {
        $userVisaDetail = ProfileVisaApplicationHistory::where('id', $request->id)->first();
        if ($userVisaDetail) {
            ProfileVisaApplicationHistory::where('id', $request->id)->delete();
            return redirect()->route('admin.student.edit', $userVisaDetail->user_id)->withFlashSuccess("Visa Details Deleted Successfully");
        } else {
            return redirect()->route('admin.student.edit', ['id' => $request->userid])->withFlashDanger("Visa Details Not Found!");
        }
    }

    public function showEsignatureForm($id){
        $user = User::findOrFail($id);
        $docusignSentDocs = UserDocuEsign::where('user_id', $id)->get();
        $token = get_site_config('docusign_api_token');
        $baseUrl = rtrim(get_site_config('docusign_api_url'), '/');
        $templates = [];
        if( !empty($token) && !empty($baseUrl)) {
            $url = "{$baseUrl}/api/get-templates";
            $response = Http::post($url, ['token' => $token]);
            // Log the response for debugging
            \Log::debug('DocuSign API response: ' . $response->body());
            $data = $response->json();
                $templates = $data['template'];
        }
        // backend.auth.user.student-details-add-edit-modal.edit_visa_history_modal
        return view('backend.auth.user.esignature_modal-form', compact('user','docusignSentDocs','templates'));
    }

    public function getsignaturestatus(Request $request){
        $request->validate([
            'send_request_id' => 'required|string'
        ]);

        \Log::info('getsignaturestatus request', $request->all());

        $token   = get_site_config('docusign_api_token');
        $baseUrl = rtrim(get_site_config('docusign_api_url'), '/');
        $url     = "{$baseUrl}/api/get-signature-status";

        try {
            $response = Http::timeout(15)
                ->asJson()
                ->post($url, [
                    'token'            => $token,
                    'send_request_id'  => $request->send_request_id
                ]);

            if ($response->successful()) {
                $data = $response->json();
                \Log::info('getsignaturestatus API response', $data);

                UserDocuEsign::where('send_request_id', $request->send_request_id)
                    ->update([
                        'status'        => $data['status'] ?? null,
                        'signed_date'   => $data['signed_date'] ?? null,
                        'file_path'     => $data['signed_doc'] ?? null,
                        'response_data' => json_encode($data),
                    ]);

                $doc = UserDocuEsign::where('send_request_id', $request->send_request_id)->first();

                $sentDateForPending = null;
                if ($doc && $doc->status && strtolower($doc->status) === 'pending' && $doc->created_at) {
                    $sentDateForPending = $doc->created_at->format('j M Y h:i A');
                }
                $data['sent_date_for_pending'] = $sentDateForPending;

                return response()->json($data);
            }else{

                // API returned an error response
                \Log::error('getsignaturestatus API error', [
                    'status' => $response->status(),
                    'error'  => $response->json()
                ]);

                return response()->json([
                    'status'  => 'error',
                    'message' => 'Failed to get signature status.'
                ], $response->status());
            }

        } catch (\Exception $e) {
            // Any unexpected exception (connection issue, timeout, etc.)
            \Log::error('getsignaturestatus exception', [
                'error' => $e->getMessage(), 
                'trace' => $e->getTraceAsString()
            ]);

            return response()->json([
                'status'  => 'error',
                'message' => 'Unexpected error occurred while fetching status.'
            ], 500);
        }
    }

    public function sendDocumentForSignature(Request $request){
        $request->validate([
            'template_id' => 'required|string',
            'user_name'     => 'required|string',
            'user_email'    => 'required|email',
            'user_id'       => 'required|integer',
        ]);

        $token   = get_site_config('docusign_api_token');
        $baseUrl = rtrim(get_site_config('docusign_api_url'), '/');
        $url     = "{$baseUrl}/api/send-document/";

        $payload = [
            'document_id' => $request->input('template_id'),
            'userName'    => $request->input('user_name'),
            'userEmail'   => $request->input('user_email'),
            'token'       => $token,
        ];

        \Log::info("Sending DocuSign Request", [
            'url'     => $url,
            'payload' => $payload
        ]);

        try {
            // Send as JSON instead of form params
            $response = Http::timeout(15)->asJson()->post($url, $payload);

            \Log::info("DocuSign API Raw Response", [
                'status'   => $response->status(),
                'body'     => $response->body(),
                'json'     => $response->json(),
            ]);

            if ($response->successful()) {
                $resData = $response->json();

                UserDocuEsign::create([
                    'user_id'         => $request->user_id,
                    'document_id'     => $request->template_id,
                    'user_name'       => $request->user_name,
                    'user_email'      => $request->user_email,
                    'file_path'       => $request->file_path,
                    'title'           => $request->title,
                    'send_request_id' => $resData['send_request_id'] ?? null,
                    'status'          => 'Pending',
                    'response_data'   => json_encode($resData),
                ]);

                return back()->withFlashSuccess('Document sent for signature.');
            }

            // Handle API failure
            \Log::error("DocuSign API Failed", [
                'status' => $response->status(),
                'error'  => $response->json()['error'] ?? null,
                'message'=> $response->json()['message'] ?? null,
                'body'   => $response->body(),
            ]);

            return back()->withFlashDanger('Failed to send document for signature. Please try again.');
        

        } catch (\Exception $e) {
            // Handle exceptions (timeouts, connection errors, etc.)
            \Log::error("DocuSign API Exception", [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);

            return back()->withFlashDanger('Unexpected error while sending document. Please contact support.');
        }
    }
}
