<?php

namespace App\Http\Controllers\Backend;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Auth\User;
use App\Models\Auth\StudentStatus;
use Illuminate\Http\Request;
use Log;

class StudentStatusController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $statusData = DB::table('overseas_status')->OrderBy('display_order')->get();
        return view('backend.settings.student_status', compact('statusData'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|unique:overseas_status,overseas_status_name',
            'color' => 'required',
        ]);

        $status_name = $request->name;
        $display_order = $request->display_order;
        $color = $request->color;
        $auto_assign = $request->assign_to_status;

        $status = new StudentStatus;
        if($auto_assign == 'assign_on_create') {
            $status->assign_on_create = '1';
        }
        if($auto_assign == 'assign_on_course_pref') {
            $status->assign_on_course_pref = '1';
        }
        if($auto_assign == 'assign_on_doc_upload') {
            $status->assign_on_doc_upload = '1';
        }
        if($auto_assign == 'assign_on_appl_create') {
            $status->assign_on_appl_create = '1';
        }
        $status_stage = $request->status_stage;
        if($status_stage == 'is_completed_success') {
            $status->is_completed_success = '1';
        }
        if($status_stage == 'is_dropout') {
            $status->is_dropout = '1';
        }
        $status->overseas_status_name = $status_name;
        $status->display_order = $display_order;
        $status->color = $color;
        $status->save();
        return redirect()->route("admin.settings.student-status")->withFlashSuccess(" Student Status Added!");
    }

    public function update(Request $request, $id)
    {
        $status = StudentStatus::findOrFail($id);
        $request->validate([
            'edit_name' => 'required|unique:overseas_status,overseas_status_name,'.$id,
            'edit_color' => 'required',
        ]);
        $status_name = $request->edit_name;
        $display_order = $request->edit_display_order;
        $color = $request->edit_color;

        $auto_assign = $request->edit_assign_to_status;

        if($auto_assign == 'assign_on_create') {
            $status->assign_on_create = '1';
            $status->assign_on_course_pref = '0';
            $status->assign_on_doc_upload = '0';
            $status->assign_on_appl_create = '0';
        }
        else if($auto_assign == 'assign_on_course_pref') {
            $status->assign_on_course_pref = '1';
            $status->assign_on_create = '0';
            $status->assign_on_doc_upload = '0';
            $status->assign_on_appl_create = '0';
        }
        else if($auto_assign == 'assign_on_doc_upload') {
            $status->assign_on_doc_upload = '1';
            $status->assign_on_create = '0';
            $status->assign_on_course_pref = '0';
            $status->assign_on_appl_create = '0';
        }
        else if($auto_assign == 'assign_on_appl_create') {
            $status->assign_on_appl_create = '1';
            $status->assign_on_create = '0';
            $status->assign_on_course_pref = '0';
            $status->assign_on_doc_upload = '0';
        }
        else{
            $status->assign_on_create = '0';
            $status->assign_on_course_pref = '0';
            $status->assign_on_doc_upload = '0';
            $status->assign_on_appl_create = '0';
        }

        $status_stage = $request->edit_status_stage;

        if($status_stage == 'is_completed_success') {
            $status->is_completed_success = '1';
            $status->is_dropout = '0';
        }
        else if($status_stage == 'is_dropout') {
            $status->is_dropout = '1';
            $status->is_completed_success = '0';
        }
        else{
            $status->is_completed_success = '0';
            $status->is_dropout = '0';
        }

        if($request->edit_name != $status->overseas_status_name){
            $old_status = $status->overseas_status_name;
            DB::table('users')->where('overseas_status', $old_status)->update(['overseas_status' => $request->edit_name]);
        }
        $status->overseas_status_name = $status_name;
        $status->display_order = $display_order;
        $status->color = $color;
        $status->save();

        return redirect()->route("admin.settings.student-status")->withFlashSuccess("Student Status Updated!");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $status = StudentStatus::findOrFail($id);
        if (User::where('overseas_status', $status->overseas_status_name)->exists()) {
            return redirect()->route("admin.settings.student-status")->withFlashDanger("Students with this Status exist! Cannot delete!");
        }
        $status->delete();
        // DB::table('users')->where('overseas_status', $status->overseas_status_name)->update(['overseas_status' => ""]);

        return redirect()->route("admin.settings.student-status")->withFlashSuccess("Student Status Deleted!");
    }
}
