<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\StudyLevels;
use App\Models\Auth\User;
use App\Models\Auth\UniversityCourses;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Log;

class StudyLevelsController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $levels = StudyLevels::OrderBy('display_order')->get();
        return view('backend.settings.study_levels', compact('levels'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'study_level' => 'required|max:100|unique:study_levels,study_level',
            'degree' => 'required',
            'display_order' => 'required|numeric',
        ]);

        StudyLevels::create([
            "study_level" => $request->input('study_level'),
            "degree" => $request->input("degree"),
            "display_order" => $request->input("display_order"),
        ]);

        return redirect()->route("admin.settings.study-levels")->withFlashSuccess("Study Level Added!");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $study_level = StudyLevels::findOrFail($id);
        $request->validate([
            'study_level' => 'required|max:100|unique:study_levels,study_level,' . $id,
            'degree' => 'required',
            'display_order' => 'required|numeric',
        ]);

        //Update any existing students and courses with old study level        
        if($request->input('study_level') != $study_level->study_level) {
            User::where('overseas_study_level_selection', $study_level->study_level)->update(['overseas_study_level_selection' => $request->input('study_level')]);

            UniversityCourses::where('study_level', $study_level->study_level)->update(['study_level' => $request->input('study_level')]);

            $study_level->study_level = $request->input("study_level");
        }
        if($request->input('degree') != $study_level->degree) {
            User::where('overseas_study_level_selection', $study_level->study_level)->update(['overseas_study_level' => $request->input('degree')]);
            $study_level->degree = $request->input("degree");
        }
        
        $study_level->display_order = $request->input("display_order");
        $study_level->save();

        return redirect()->route("admin.settings.study-levels")->withFlashSuccess("Study Level Updated!");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $study_level = StudyLevels::findOrFail($id);
        
        if (User::where('overseas_study_level_selection', $study_level->study_level)->exists()) {
            return redirect()->route("admin.settings.study-levels")->withFlashDanger("Students with this Study Level exist! Cannot delete!");
        }
        UniversityCourses::where('study_level', $study_level->study_level)->update(['study_level' => ""]);
        $study_level->delete();
        return redirect()->route("admin.settings.study-levels")->withFlashSuccess("Study Level Deleted!");
    }
}
