<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\SupportTicket\AddTicketRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Str;
use App\Repositories\Backend\Auth\UserRepository;
use App\Notifications\Backend\UserAlert;
use App\Models\Auth\Ticket;
use App\Models\MailTemplates;
use App\Models\Auth\User;
use App\Mail\MailSend;
use Illuminate\Support\Facades\Mail;
use Log;

/**
 * Class SupportTicketController.
 */
class SupportTicketController extends Controller
{

    private $itemsPerPage = 15;

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('support tickets'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }
            return $next($request);
        });
    }

    /**
     * @return \Illuminate\View\View
     */
    public function index(Request $request)
    {
        $search_status = $search = $my_data = '';
        $status_list = array('new_customer_reply' => 'New/User Replied', 'new' => 'New', 'customer_reply' => 'User Replied', 'staff_reply' => 'Answered', 'inprogress' => 'Inprogress', 'closed' => 'Closed', 'all' => 'All');
        $userRepo = new UserRepository();
        $staff = $userRepo->getNonStudentsTrainers();

        if ($request->has('q')) {

            $search_type = $request->input('q') != '' ? $request->input('q') : '';
            if ($search_type != '') {
                $search_status_arr = explode('allstatus::', $search_type);
                $search_mystatus_arr = explode('mystatus::', $search_type);

                if (isset($search_status_arr[1]) && $search_status_arr[1] != '') {
                    $search_status = $search_status_arr[1];
                } elseif (isset($search_mystatus_arr[1]) && $search_mystatus_arr[1] != '') {
                    $search_status = $search_mystatus_arr[1];
                    $my_data = 1;
                } else {
                    $search = $search_type;
                }
            }
        }
        $branch = get_staff_branch(\Auth::user()->id);
        $current_branch = $request->input('branch');
        $filters = array("status" => $search_status, "search" => "", "assigned_to" => $request->input('logged_in_user'), "daterange" => "", "my_data" => $my_data);
        return view('backend.tickets.supporttickets', compact('search', 'filters', 'status_list', 'staff','branch','current_branch'));
    }

    public function ajaxticketlist(Request $request)
    {

        if (!$request->ajax()) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this page.');
        }
        echo $this->getDatatableSupporttickets($request);
    }

    public function getDatatableSupporttickets($request)
    {
        $columns = array(
            0 => 'subject',
            1 => 'assigned_to',            
            2 => 'branch',            
            3 => 'status',
            4 => 'username',            
            5 => 'updated_at',
            6 => 'created_at'
        );

        $my_branch = "";
        if(\Auth::user()->can('view assigned data only')) {
            \Log::debug('view assigned data only. User: '.\Auth::user()->id);
            $my_user_id = \Auth::user()->id;
        } else {
            $my_user_id = $request->input('myleads') == 1 ? \Auth::user()->id : '';        
            //$my_branch = get_staff_branch_ids(\Auth::user()->id);
        }
        if($request->input('branch') == "all"){
            $my_branch = get_staff_branch_ids(\Auth::user()->id);
        }else{
            $my_branch = array($request->input('branch'));
        }

        $totalData = DB::table('tickets')
            ->join('users', 'users.id', '=', 'tickets.userid')
            ->when(!empty($my_branch), function ($query) use ($my_branch) {
                return $query->whereIn('users.branch', $my_branch);
            })
            ->when(!empty($my_user_id), function ($query) use ($my_user_id) {
                return  $query->Where('tickets.assigned_to', '=', "$my_user_id");
            })
        ->whereNull('users.deleted_at') 
        ->count();
        $totalFiltered = $totalData;
        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');
        $status = $request->input('status');
        $assigned_to = $request->input('assigned_to');
        //$my_user_id = $request->input('mytickets') == 1 ? \Auth::user()->id : '';


        if (empty($request->input('search.value')) && empty($status) && empty($assigned_to) && empty($my_user_id)) {
            Log::debug('Tickets:getdata: No search values');
            $tickets = DB::table('tickets')
                ->select('tickets.*','users.id','users.branch')
                ->join('users','users.id','=','tickets.userid')
                ->when(!empty($my_branch), function ($query) use ($my_branch) {
                    return $query->whereIn('users.branch', $my_branch);
                })
                ->when(!empty($my_user_id), function ($query) use ($my_user_id) {
                    return  $query->Where('tickets.assigned_to', '=', "$my_user_id");
                }) 
                ->whereNull('users.deleted_at')
                ->Where('status', 'new')
                ->orWhere('status', 'customer_reply')
                ->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                ->get();
        } else {
            $get_search = $request->input('search.value');
            Log::debug('Tickets:getdata: search:' . $get_search);
            $tickets = DB::table('tickets')
                ->select('tickets.*','users.id','users.branch')
                ->join('users', 'users.id', '=', 'tickets.userid')
                ->whereNull('users.deleted_at')
                ->when(!empty($my_branch), function ($query) use ($my_branch) {
                    return $query->whereIn('users.branch', $my_branch);
                })
                ->when(!empty($get_search), function ($query) use ($get_search) {
                    return $query->Where('ticket_id', '=', "$get_search")
                        ->orWhere('subject', 'like', "%$get_search%")
                        ->orWhere('status', '=', "$get_search")
                        ->orWhere('userid', '=', "$get_search");
                })
                ->when(!empty($status), function ($query) use ($status) {
                    if ($status == 'new_customer_reply') {
                        $query->where(function ($query) {
                            $query->Where('status', '=', "new")
                                ->orWhere('status', '=', "customer_reply");
                        });
                    } elseif($status != 'all') {
                        return  $query->Where('status', '=', "$status");
                    }
                })
                ->when(!empty($assigned_to), function ($query) use ($assigned_to) {
                    return  $query->Where('tickets.assigned_to', '=', "$assigned_to");
                })
                ->when(!empty($my_user_id), function ($query) use ($my_user_id) {
                    return  $query->Where('tickets.assigned_to', '=', "$my_user_id");
                })
                ->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                ->get();

            $totalFiltered = DB::table('tickets')
            ->join('users', 'users.id', '=', 'tickets.userid')
                ->when(!empty($my_branch), function ($query) use ($my_branch) {
                    return $query->whereIn('users.branch', $my_branch);
                })
            ->whereNull('users.deleted_at')
            ->where(function ($query) use ($get_search) {
                $query->Where('ticket_id', '=', "$get_search")
                    ->orWhere('subject', 'like', "%$get_search%")
                    ->orWhere('status', '=', "$get_search")
                    ->orWhere('userid', '=', "$get_search");
            })
            ->when(!empty($status), function ($query) use ($status) {
                if ($status == 'new_customer_reply') {
                    $query->where(function ($query) {
                        $query->Where('status', '=', "new")
                            ->orWhere('status', '=', "customer_reply");
                    });
                } else {
                    return  $query->Where('status', '=', "$status");
                }
            })
            ->when(!empty($assigned_to), function ($query) use ($assigned_to) {
                return  $query->Where('tickets.assigned_to', '=', "$assigned_to");
            })
            ->when(!empty($my_user_id), function ($query) use ($my_user_id) {
                return  $query->Where('tickets.assigned_to', '=', "$my_user_id");
            })
            ->count();
        }

        $data = $customResult = array();
        if (!empty($tickets)) {
            $count = 1;
            foreach ($tickets as $ticket) {
                // $customResult['id'] = $count++;
                $customResult['subject'] = '<a style="color:#006de1;';
                if ($ticket->status == 'new') {
                    $customResult['subject'] .= 'font-weight:700;';
                }
                $customResult['subject'] .= '" href="' . route('admin.viewticket', $ticket->ticket_id) . '">#' . $ticket->ticket_id . ' ' . $ticket->subject . '</a>';

                $customResult['username'] = '<a href="' . route('admin.auth.user.show', $ticket->userid) . '">' . get_user_full_name_by_id($ticket->userid) . '</a>';


                if ($ticket->status == 'new')
                    $customResult['status'] = '<span class="badge badge-danger">New</span>';
                elseif ($ticket->status == 'customer_reply')
                    $customResult['status'] = '<span class="badge badge-warning">User Replied</span>';
                elseif ($ticket->status == 'staff_reply')
                    $customResult['status'] = '<span class="badge badge-success">Answered</span>';
                elseif ($ticket->status == 'inprogress')
                    $customResult['status'] = '<span class="badge badge-default">In Progress</span>';
                else
                    $customResult['status'] = '<span class="badge badge-disabled">Closed</span>';


                $customResult['updated_at'] = get_date_time_formated($ticket->updated_at);
                $customResult['created_at'] = \Carbon\Carbon::parse($ticket->created_at)->diffForHumans();

                $userRepo = new UserRepository();
                $staff = $userRepo->getNonStudentsTrainers();
                $disabled = 'disabled';
                if (\Auth::user()->isAdmin() || \Auth::user()->can('ticket-assignment')) {
                    $disabled = '';
                }
                $customResult['branch'] = $ticket->branch ? branch_name($ticket->branch) : "";
                $customResult['assigned_to_name'] = '';                
                $customResult['assigned_to'] = '<select id="staff_id" style="min-width:120px;" class="form-select staffs" ' . $disabled . ' onChange="changeStaff(this.value, \'' . $ticket->ticket_id . '\')">
                                                    <option value="">Select</option>';
                foreach ($staff as $stf) {
                    $selected = '';
                    if ($stf->id == $ticket->assigned_to) {
                        $selected = 'selected';
                        $customResult['assigned_to_name'] = $stf->first_name . ' ' . $stf->last_name;
                    }
                    $customResult['assigned_to'] .= '<option ' . $selected . ' value="' . $stf->id . '">' . $stf->first_name . ' ' . $stf->last_name . '</option>';
                }
                $customResult['assigned_to'] .= '</select><input type="hidden" class="ticket_id" value="' . $ticket->id . '>';

                $data[] = $customResult;
            }
        }

        $json_data = array(
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $data,
            "user_id" => $my_user_id,
            "branch" => $my_branch,
            "Search" => $request->input('search.value'),
            "status" => $status,
            "assigned_to" => $assigned_to,
            "my_user_id" => $my_user_id
        );

        return json_encode($json_data);
    }

    public function search(Request $request)
    {
        $data = $request->all();
        $filters = array("status" => "");
        //var_dump($data);
        if (isset($data['search']) && strlen($data['search']) && $data['status']) {
            $filters['search'] = $data['search'];
            $filters['status'] = $data['status'];
            $subject = "%" . $data['search'] . "%";
            $tickets = DB::table('tickets')->where('status', '=', $data['status'])->where('ticket_id', '=', $data['search'])->orWhere('subject', 'like', $subject)->orderBy('status', "ASC")->orderBy('updated_at', "DESC")->paginate($this->itemsPerPage)->appends(Input::except('page'));
        } elseif (isset($data['search']) && strlen($data['search'])) {
            $filters['search'] = $data['search'];
            $subject = "%" . $data['search'] . "%";
            $tickets = DB::table('tickets')->where('ticket_id', '=', $data['search'])->orWhere('subject', 'like', $subject)->orderBy('status', "ASC")->orderBy('updated_at', "DESC")->paginate($this->itemsPerPage)->appends(Input::except('page'));
        } elseif ($data['status']) {
            $filters['status'] = $data['status'];
            $tickets = DB::table('tickets')->where('status', '=', $data['status'])->orderBy('status', "ASC")->orderBy('updated_at', "DESC")->paginate($this->itemsPerPage)->appends(Input::except('page'));
        } else {
            $tickets = DB::table('tickets')->orderBy('status', "ASC")->orderBy('updated_at', "DESC")->paginate($this->itemsPerPage)->appends(Input::except('page'));
        }
        return view('backend.tickets.supporttickets', ['tickets' => $tickets, 'filters' => $filters]);
    }

    public function ticketsbyuser($userid)
    {
        $filters = array("status" => "");
        $tickets = DB::table('tickets')->where('userid', '=', $userid)->orderBy('status', "ASC")->orderBy('updated_at', "DESC")->paginate($this->itemsPerPage);

        return view('backend.tickets.supporttickets', ['tickets' => $tickets, 'filters' => $filters]);
    }

    public function view($ticket_id)
    {
        $messages = array();
        $ticket = DB::table('tickets')->where('ticket_id', $ticket_id)->first();
        if ($ticket) {
            $rows = DB::table('ticket_reply')->where('ticket_id', $ticket_id)->orderBy('reply_timestamp', 'DESC')->get();
            if ($rows) {
                foreach ($rows as $row) {
                    $msg = html_entity_decode($row->message);
                    $messages[] = array('staff_name' => $row->staff_name, 'reply_by' => $row->reply_by, 'timestamp' => $row->reply_timestamp, 'message' => $msg, 'all_attachment' => $row->all_attachment);
                }
            }
        } else {
            return redirect()->route('admin.ticketlist')->withFlashDanger("Ticket #" . $ticket_id . " not found!");
        }

        $user_name = "";
        $user_info = get_user_by_id($ticket->userid);
        if ($user_info)
            $user_name = $user_info->first_name;

        // $all_attachments = [];    
        // if(isset($messages[0]['all_attachment'])){
        //     $all_attachments = explode("|", $messages[0]['all_attachment']);
        // }

        return view('backend.tickets.viewticket', ['ticket' => $ticket, 'user_name' => $user_name, 'messages' => $messages]);
    }

    public function reply(AddTicketRequest $request)
    {
        $data = $request->all();

        if (!empty($data['ticket_id'])) {
            $ticket_id = $data['ticket_id'];
            $ticket = DB::table('tickets')->where('ticket_id', $ticket_id)->first();
            if ($ticket) {
                $message = $data['message'];
                if (!empty($message)) {
                    $message = nl2br($message);
                    $message = str_replace(array("\n", "\r"), '', $message);
                    $message = htmlentities($message);
                    if ($ticket->status != 'closed') {
                        $my_name = \Auth::user()->first_name;
                        $id = DB::table('ticket_reply')->insertGetId(["ticket_id" => $ticket_id, "reply_timestamp" => date("Y-m-d H:i:s"), "reply_by" => "staff", "staff_name" => $my_name, "message" => $message]);

                        $update_data = array();
                        $update_data['status'] = 'staff_reply';
                        $update_data['updated_at'] = date("Y-m-d H:i:s");
                        if($ticket->assigned_to == 0) {
                            $update_data['assigned_to'] = \Auth::user()->id;
                        }
                        DB::table('tickets')->where("ticket_id", $ticket_id)->update($update_data);

                        //attachments
                        // if ($request->file('file1')) {
                        //     $file = $request->file1->getClientOriginalName();
                        //     $filename = pathinfo($file, PATHINFO_FILENAME);
                        //     if (strlen($filename) > 125)
                        //         $filename = substr($filename, 0, 125);

                        //     $filename = $filename . Str::random(20) . "." . $request->file1->getClientOriginalExtension();
                        //     $path = $request->file('file1')->storeAs('/tickets', $filename, 'public');
                        //     //\Log::debug("::ticket attachment savedpath::$path");
                        //     DB::table('ticket_reply')->where("id", $id)->update(['attachment_1' => $path]);
                        // }
                        // if ($request->file('file2')) {
                        //     $file = $request->file2->getClientOriginalName();
                        //     $filename = pathinfo($file, PATHINFO_FILENAME);
                        //     if (strlen($filename) > 125)
                        //         $filename = substr($filename, 0, 125);

                        //     $filename = $filename . Str::random(20) . "." . $request->file2->getClientOriginalExtension();
                        //     $path = $request->file('file2')->storeAs('/tickets', $filename, 'public');
                        //     //\Log::debug("::ticket attachment savedpath::$path");
                        //     DB::table('ticket_reply')->where("id", $id)->update(['attachment_2' => $path]);
                        // }
                        // if ($request->file('file3')) {
                        //     $file = $request->file3->getClientOriginalName();
                        //     $filename = pathinfo($file, PATHINFO_FILENAME);
                        //     if (strlen($filename) > 125)
                        //         $filename = substr($filename, 0, 125);

                        //     $filename = $filename . Str::random(20) . "." . $request->file3->getClientOriginalExtension();
                        //     $path = $request->file('file3')->storeAs('/tickets', $filename, 'public');
                        //     //\Log::debug("::ticket attachment savedpath::$path");
                        //     DB::table('ticket_reply')->where("id", $id)->update(['attachment_3' => $path]);
                        // }
                        // if ($request->file('file4')) {
                        //     $file = $request->file4->getClientOriginalName();
                        //     $filename = pathinfo($file, PATHINFO_FILENAME);
                        //     if (strlen($filename) > 125)
                        //         $filename = substr($filename, 0, 125);

                        //     $filename = $filename . Str::random(20) . "." . $request->file4->getClientOriginalExtension();
                        //     $path = $request->file('file4')->storeAs('/tickets', $filename, 'public');
                        //     //\Log::debug("::ticket attachment savedpath::$path");
                        //     DB::table('ticket_reply')->where("id", $id)->update(['attachment_4' => $path]);
                        // }

                        //attachments
                        $file_upload = $request['files'];
                        $allFiles = "";
                        $email_files = Array();
                        if($file_upload){
                            foreach($file_upload as $file){
                                $filename = $file->getClientOriginalName();
                                $filename = str_replace(" ", "-", $filename);
                                $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
                                if (strlen($filename) > 125) {
                                    $filename = substr($filename, 0, 125);
                                }
                                $filename .= Str::random(20);

                                $path = $file->storeAs('/tickets', $filename . "." . $file->getClientOriginalExtension(), 'public');
                                $filename = $filename.".".$file->getClientOriginalExtension();
                                $email_files[] = $filename;
                                $allFiles .= $filename."|";
                            }
                            DB::table('ticket_reply')->where("id", $id)->update(['all_attachment' => $allFiles]);
                        }

                        //Notify user
                        $first_name = get_user_name_by_id($ticket->userid);
                        $full_name = get_user_full_name_by_id($ticket->userid);
                        //email
                        $mail_tpl = MailTemplates::find("TICKET_REPLY");
                        $user = User::where("id", $ticket->userid)->first();
                        if ($mail_tpl && $mail_tpl->status && (!$user->agent_id)) {
                            $email_message = $mail_tpl->message;
                            //\Log::debug("MAIL BEFORE:".$email_message);                       
                            $email_message = str_ireplace("#sitename#", app_name(), $email_message);
                            $email_message = str_ireplace("#siteurl#", url(''), $email_message);
                            $email_message = str_ireplace("#first_name#", $first_name, $email_message);
                            $email_message = str_ireplace("#full_name#", $full_name, $email_message);
                            $email_message = str_ireplace("#ticket_id#", "#" . $ticket_id, $email_message);
                            $email_message = str_ireplace("#reply_message#", $message, $email_message);
                            $ticket_url = "<a href=\"" . url("ticketdetail/" . $ticket_id) . "\">" . url("ticketdetail/" . $ticket_id) . "</a>";
                            $email_message = str_ireplace("#ticket_url#", $ticket_url, $email_message);
                            //\Log::debug("MAIL TPL FINAL:".$email_message);
                            //$email_message = "Dear $student,<br />Ticket #$ticket_id has a new reply posted by support staff.<br /><br /><hr>$message<hr><br /><br />View Ticket Details: <br /><a href=\"" . url("ticketdetail/" . $ticket_id) . "\">" . url("ticketdetail/" . $ticket_id) . "</a>";
                            $user = (new UserRepository())->where('id', $ticket->userid)->first();
                            try{
                                //$user->notify(new UserAlert("Reply: [Ticket ID: $ticket_id] " . $ticket->subject, $email_message));
                                user_notify($user, "Reply: [Ticket ID: $ticket_id] " . $ticket->subject, $email_message); 
                            }catch (\Exception $e) {
                                $message = $e->getMessage();
                                \Log::debug("Mail Error: (Ticket Reply) ".$message);   
                            }
                        }
                        //sms
                        $notify_sms = get_sms_template('TICKET_REPLY');
                        if ($notify_sms && $notify_sms->status && (!$user->agent_id)) {
                            $notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
                            $notify_sms->message = str_replace("#siteurl#", url('/'), $notify_sms->message);
                            $notify_sms->message = str_replace("#first_name#", $user->first_name, $notify_sms->message);
                            $notify_sms->message = str_replace("#full_name#", $user->full_name, $notify_sms->message);
                            $notify_sms->message = str_replace("#id#", "#".$ticket_id, $notify_sms->message);
                            $user->sms($notify_sms->message, $notify_sms->template_id);
                        }

                        // Send Push App Notification
                        if(\Auth::user()->isAgent()){
                            $email_message = "Hi, <br><br>Ticket #$ticket_id has a new reply posted by Agent: " . get_user_full_name_by_id(\Auth::user()->id) . "<br /><br /><hr>Message: $message<hr><br /><br />View Ticket Details: <br /><a href=\"" . url("admin/ticket/" . $ticket_id) . "\">" . url("admin/ticket/" . $ticket_id) . "</a>";
                            $message = "Ticket #$ticket_id has a new reply posted by Agent: " . get_user_full_name_by_id(\Auth::user()->id) . ", Subject: ".$ticket->subject;
                            $subject =  "Reply: [Ticket ID: $ticket_id] ".$ticket->subject;
                        } else{
                            $email_message = "Hi, <br><br>Ticket #$ticket_id has a new reply posted by Staff: " . get_user_full_name_by_id(\Auth::user()->id) . "<br /><br /><hr>Message: $message<hr><br /><br />View Ticket Details: <br /><a href=\"" . url("admin/ticket/" . $ticket_id) . "\">" . url("admin/ticket/" . $ticket_id) . "</a>";
                            $message = "Ticket #$ticket_id has a new reply posted by Staff: " . get_user_full_name_by_id(\Auth::user()->id) . ", Subject: ".$ticket->subject;
                            $subject =  "Reply: [Ticket ID: $ticket_id] ".$ticket->subject;
                        }

                        // Send Push Email Notification
                        send_mail_notification($ticket->assigned_to,"","SUPPORT_TICKET_REPLY_RECEIVED",$subject,$email_message);

                        // Send Push App Notification
                        $message .= "<br>"._label('backend_student').": " . get_user_full_name_by_id($user->id) . " (" . $user->id . ")";
                        $subject = "";
                        send_in_app_notification(
                            $ticket->assigned_to, 
                            $ticket->ticket_id, 
                            "SUPPORT_TICKET_REPLY_RECEIVED", 
                            $subject, 
                            $message,
                            "ticket", 
                        );

                        return redirect()->route('admin.ticketlist')->withFlashSuccess("Ticket Replied Successfully");
                    } else {
                        return redirect()->route('admin.ticketlist')->withFlashDanger("This ticket is closed!");
                    }
                } else {
                    return redirect()->route('admin.ticketlist')->withFlashDanger("Message is required!");
                }
            } else {
                return redirect()->route('admin.ticketlist')->withFlashDanger("Ticket #" . $ticket_id . " not found!");
            }
        } else {
            return redirect()->route('admin.ticketlist')->withFlashDanger("Ticket ID required!");
        }
    }

    public function new_ticket($user_id=null){
        $user = "";
        if($user_id){
            $user = User::find($user_id);
        }
        return view('backend.tickets.createticket', ['user' => $user]);
    }

    public function create(AddTicketRequest $request)
    {
        $data = $request->all();
        
        if (!empty($data['user'])) {
            if (!empty($data['subject'])) {
                $message = $data['message'];
                if (!empty($message)) {
                    $message = nl2br($message);
                    $message = str_replace(array("\n", "\r"), '', $message);
                    $message = htmlentities($message);

                    $my_name = \Auth::user()->first_name;
                    $ticket_id = generate_ticket_id();
                    $now = date("Y-m-d H:i:s");
                    DB::table('tickets')->insert(["ticket_id" => $ticket_id, "userid" => $data['user'], "created_at" => $now, "subject" => $data['subject'], "updated_at" => $now]);
                    $id = DB::table('ticket_reply')->insertGetId(["ticket_id" => $ticket_id, "reply_timestamp" => $now, "reply_by" => "user", "staff_name" => $my_name, "message" => $message]);

                    //attachments
                    // if ($request->file('file1')) {
                    //     $file = $request->file1->getClientOriginalName();
                    //     $filename = pathinfo($file, PATHINFO_FILENAME);
                    //     if (strlen($filename) > 125)
                    //         $filename = substr($filename, 0, 125);

                    //     $filename = $filename . Str::random(20) . "." . $request->file1->getClientOriginalExtension();
                    //     $path = $request->file('file1')->storeAs('/tickets', $filename, 'public');
                    //     //\Log::debug("::ticket attachment savedpath::$path");
                    //     DB::table('ticket_reply')->where("id", $id)->update(['attachment_1' => $path]);
                    // }
                    // if ($request->file('file2')) {
                    //     $file = $request->file2->getClientOriginalName();
                    //     $filename = pathinfo($file, PATHINFO_FILENAME);
                    //     if (strlen($filename) > 125)
                    //         $filename = substr($filename, 0, 125);

                    //     $filename = $filename . Str::random(20) . "." . $request->file2->getClientOriginalExtension();
                    //     $path = $request->file('file2')->storeAs('/tickets', $filename, 'public');
                    //     //\Log::debug("::ticket attachment savedpath::$path");
                    //     DB::table('ticket_reply')->where("id", $id)->update(['attachment_2' => $path]);
                    // }
                    // if ($request->file('file3')) {
                    //     $file = $request->file3->getClientOriginalName();
                    //     $filename = pathinfo($file, PATHINFO_FILENAME);
                    //     if (strlen($filename) > 125)
                    //         $filename = substr($filename, 0, 125);

                    //     $filename = $filename . Str::random(20) . "." . $request->file3->getClientOriginalExtension();
                    //     $path = $request->file('file3')->storeAs('/tickets', $filename, 'public');
                    //     //\Log::debug("::ticket attachment savedpath::$path");
                    //     DB::table('ticket_reply')->where("id", $id)->update(['attachment_3' => $path]);
                    // }

                    //attachments
                    $file_upload = $request['files'];
                    $allFiles = "";
                    $email_files = Array();
                    if($file_upload){
                        foreach($file_upload as $file){
                            $filename = $file->getClientOriginalName();
                            $filename = str_replace(" ", "-", $filename);
                            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
                            if (strlen($filename) > 125) {
                                $filename = substr($filename, 0, 125);
                            }
                            $filename .= Str::random(20);

                            $path = $file->storeAs('/tickets', $filename . "." . $file->getClientOriginalExtension(), 'public');
                            $filename = $filename.".".$file->getClientOriginalExtension();
                            $email_files[] = $filename;
                            $allFiles .= $filename."|";
                        }
                        DB::table('ticket_reply')->where("id", $id)->update(['all_attachment' => $allFiles]);
                    }

                    // Send Push App Notification
                    $leaddetails = User::where("id", $request->user)->first();
                    $ticket = Ticket::where('ticket_id',$ticket_id)->first();
                    if(\Auth::user()->isAgent()){
                        $message = "Support Ticket Created by Agent: " . get_user_full_name_by_id(\Auth::user()->id);
                        $email_message = "Hi, <br>Support Ticket Created by Agent: " . get_user_full_name_by_id(\Auth::user()->id);
                        $subject = "Support Ticket(#".$ticket_id.") Created by Agent";
                    } else{
                        $message = "Support Ticket Created by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
                        $email_message = "Hi, <br>Support Ticket Created by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
                        $subject = "Support Ticket(#".$ticket_id.") Created by Staff";
                    }

                    //Notify Staff
                    $email_message .= "<br /><br/>Ticket #".$ticket->ticket_id." : ".$ticket->subject."<br/><br/><a href=\"" . url("admin/tickets/" . $ticket_id) . "\">View Ticket Details</a>";
                    send_mail_notification($ticket->assigned_to,"","SUPPORT_TICKET_CREATION",$subject,$email_message);

                    $message .= "<br>Subject: " . $ticket->subject .
                    "<br>"._label('backend_student').": " . $leaddetails->full_name." (". $leaddetails->id. ")";
                    $subject = "";
                    send_in_app_notification(
                        $leaddetails->id, 
                        $leaddetails->id,
                        "SUPPORT_TICKET_CREATION", 
                        $subject, 
                        $message,
                        "student"
                    );


                    // Send Whatsapp 
                    if (get_site_config('whatsapp_enabled')) {
                        $numbers = [$leaddetails->whatsapp_dialcode.$leaddetails->whatsapp];
                        $hook = 'ticket_reply';

                        $customMessage = [
                            'id'  => $ticket_id,
                        ];

                        send_whatsapp_message($numbers, $hook, $leaddetails->id, $customMessage);
                    }

                    return redirect()->route('admin.ticketlist')->withFlashSuccess("Ticket Created Successfully");
                } else {
                    return redirect()->route('admin.ticketlist')->withFlashDanger("Message is required!");
                }
            } else {
                return redirect()->route('admin.ticketlist')->withFlashDanger("Subject is required!");
            }
        } else {
            return redirect()->route('admin.ticketlist')->withFlashDanger("User ID required!");
        }
    }

    public function close($ticket_id)
    {
        DB::table('tickets')->where("ticket_id", $ticket_id)->update(['status' => 'closed']);
        $ticket = Ticket::where('ticket_id',$ticket_id)->first();

        //Notify Staff
        $subject = "Support Ticket(#".$ticket_id.") status changed";
        $email_message = "Hi, <br>Support Ticket status change to: Closed<br /><br/>Ticket #".$ticket->ticket_id." : ".$ticket->subject."<br/><br/><a href=\"" . url("admin/tickets/" . $ticket_id) . "\">View Ticket Details</a>";
        send_mail_notification($ticket->assigned_to,"","SUPPORT_TICKET_STATUS_CHANGE",$subject,$email_message);
        
        // Send Push App Notification
        $user = User::where('id',$ticket->userid)->first();
        if(\Auth::user()->isAgent()){
            $message = "Support Ticket(#".$ticket_id.") status changed by Agent: " . get_user_full_name_by_id(\Auth::user()->id);
        } else{
            $message = "Support Ticket(#".$ticket_id.") status changed by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
        }
        $message .= "<br>Subject: " . $ticket->subject .
        "<br>"._label('backend_student').": " . $user->full_name." (". $user->id. ")";
        $subject = "";
        send_in_app_notification(
            $ticket->assigned_to, 
            $ticket->ticket_id, 
            "SUPPORT_TICKET_STATUS_CHANGE", 
            $subject, 
            $message,
            "ticket", 
        );

        return redirect()->route('admin.ticketlist')->withFlashSuccess("Ticket Closed");
    }

    public function inprogress($ticket_id)
    {
        DB::table('tickets')->where("ticket_id", $ticket_id)->update(['status' => 'inprogress']);
        $ticket = Ticket::where('ticket_id',$ticket_id)->first();

        //Notify Staff
        $subject = "Support Ticket(#".$ticket_id.") status changed";
        $email_message = "Hi, <br>Support Ticket status change to: Inprogress<br /><br/>Ticket #".$ticket->ticket_id." : ".$ticket->subject."<br/><br/><a href=\"" . url("admin/tickets/" . $ticket_id) . "\">View Ticket Details</a>";
        send_mail_notification($ticket->assigned_to,"","SUPPORT_TICKET_STATUS_CHANGE",$subject,$email_message);

        // Send Push App Notification
        $user = User::where('id',$ticket->userid)->first();
        if(\Auth::user()->isAgent()){
            $message = "Support Ticket(#".$ticket_id.") status change to: Inprogress by Agent: " . get_user_full_name_by_id(\Auth::user()->id);
        } else{
            $message = "Support Ticket(#".$ticket_id.") status change to: Inprogress by Staff: " . get_user_full_name_by_id(\Auth::user()->id);
        }
        $message .= "<br>Subject: " . $ticket->subject .
            "<br>"._label('backend_student').": " . $user->full_name." (". $user->id. ")";
        $subject = "";
        send_in_app_notification(
            $ticket->assigned_to, 
            $ticket->ticket_id, 
            "SUPPORT_TICKET_STATUS_CHANGE", 
            $subject, 
            $message,
            "ticket", 
        );

        return redirect()->route('admin.ticketlist')->withFlashSuccess("Ticket Status changed to Inprogress");
    }

    public function assignStaff($staffid, $ticketid)
    {
       // return $staffid.", ".$ticketid;
        if (DB::table('tickets')->where("ticket_id", $ticketid)->update(['assigned_to' => $staffid])) {

            $user = User::find($staffid);
            $ticket = Ticket::where('ticket_id',$ticketid)->first();

            // $email_message = "Hi ".$user->name.", New Ticket is assigned to you.<br /><br />#".$ticket->ticket_id." : ".$ticket->subject."<br/><br/><a href=\"" . url("admin/tickets/" . $ticketid) . "\">View Ticket Details</a>";
            // try{
            //     Mail::to($user->email)->send(new MailSend($subject, $email_message));
            // }catch (\Exception $e) {
            //         $message = $e->getMessage();
            //         \Log::debug("Mail Error: (New Ticket Assigned) ".$message);   
            // }

            //Notify Staff
            $subject = "New Ticket(#".$ticket->ticket_id.") Assigned";
            $email_message = "Hi ".$user->name.",<br> New Ticket is assigned to you.<br /><br />#".$ticket->ticket_id." : ".$ticket->subject."<br/><br/><a href=\"" . url("admin/tickets/" . $ticketid) . "\">View Ticket Details</a>";
            send_mail_notification($staffid,"","SUPPORT_TICKET_ASSIGNED_TO_STAFF",$subject,$email_message);

            // Send Push App Notification
            $user = User::where('id',$ticket->userid)->first();
            if(\Auth::user()->isAgent()){
                $message = "New Ticket(#".$ticket->ticket_id.") Assigned by Agent: " . get_user_full_name_by_id(\Auth::user()->id) . "to " . $user->full_name;
            } else{
                $message = "New Ticket(#".$ticket->ticket_id.") Assigned by Staff: " . get_user_full_name_by_id(\Auth::user()->id) . "to " . $user->full_name;
            }
            $message .= "<br>Subject: " . $ticket->subject .
            "<br>"._label('backend_student').": " . $user->full_name." (". $user->id. ")";
            $subject = "";
            send_in_app_notification(
                $ticket->assigned_to, 
                $ticket->ticket_id, 
                "SUPPORT_TICKET_ASSIGNED_TO_STAFF", 
                $subject, 
                $message,
                "ticket", 
            );

            return "Staff Assigned!";
        } else {
            return "Error";
        }
    }

}
