<?php

namespace App\Http\Controllers\Backend;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;

use App\Models\Auth\TaxRates;
use App\Models\Auth\Country;

use Illuminate\Http\Request;

class TaxController extends Controller{

    public function settingsTaxIndex() {
        $tax_rates = TaxRates::orderBy('id', 'asc')
            ->get();

        $country_list = Country::pluck('title_en', 'id');

        return view('backend.tax.tax-setting', ['country_list' => $country_list, 'tax_rates' => $tax_rates]);
    }

    public function settingTaxRatesSave(Request $request){
        $request->all([
            'name' => 'required|max:100',
            'display_name' => 'required|max:50',
            'tax_rates' => 'required|numeric|min:0|max:100',
        ]);
        
        $tax_country = TaxRates::where('country', $request->country)->get();
        if(count($tax_country) >= 2){
            return redirect()->route('admin.settings.tax-index')->withFlashDanger('Cannot add more than two Tax Rates for a Country.');
        }

        $tax_rates = new TaxRates([
            'name' => $request->name,
            'display_name' => $request->display_name,
            'country' => $request->country,
            'state' => $request->state,
            'tax_rate' => $request->tax_rates,
        ]);
        $tax_rates->save();

        return redirect()->route('admin.settings.tax-index')->withFlashSuccess('Tax rates added.');
    }

    public function settingTaxRatesEditSave(Request $request){
        $request->all([
            'name' => 'required|max:100',
            'display_name' => 'required|max:50',
            'tax_rates' => 'required|numeric|min:0|max:100',
        ]);

        $tax_country = TaxRates::where('country', $request->country)->get();
        $tax_rates = TaxRates::where('id', $request->tax_id)->first();
        if(count($tax_country) >= 2 && ($request->country != $tax_rates->country)){
            return redirect()->route('admin.settings.tax-index')->withFlashDanger('Cannot add more than two Tax Rates for a Country.');
        }

        $tax_rates->name = $request->name;
        $tax_rates->display_name = $request->display_name;
        $tax_rates->country = $request->country;
        $tax_rates->state = $request->state;
        $tax_rates->tax_rate = $request->tax_rates;
        $tax_rates->save();

        return redirect()->route('admin.settings.tax-index')->withFlashSuccess('Tax rates updated.');
    }
    
    public function settingTaxRatesDelete($id){
        $tax_rates = TaxRates::where('id', $id)->first();
        if($tax_rates){
            $tax_rates->delete();
            return redirect()->route('admin.settings.tax-index')->withFlashSuccess('Tax rates deleted.');
        } else{
            return redirect()->route('admin.settings.tax-index')->withFlashDanger('Tax rates not found.');
        }
    }

    public function settingTaxInfoSave(Request $request){
        // dd($request->input('enabled_taxes'));
        if($request->input('enabled_taxes') != null && $request->input('enabled_taxes') == 1){
            set_site_config('enabled_taxes', 1);
        } elseif($request->input('enabled_taxes') != null && $request->input('enabled_taxes') == 0){
            set_site_config('enabled_taxes', 0);
        }
        if($request->input('exclusive') != null && $request->input('exclusive') == 1){
            set_site_config('tax_exclusive', 1);
        } elseif($request->input('exclusive') != null && $request->input('exclusive') == 0){
            set_site_config('tax_exclusive', 0);
        }
        if($request->input('inclusive') != null && $request->input('inclusive') == 1){
            set_site_config('tax_inclusive', 1);
        } elseif($request->input('inclusive') != null && $request->input('inclusive') == 0){
            set_site_config('tax_inclusive', 0);
        }

        return response()->json([
            'success' => 1, 
            'message' => 'Tax Info Saved!'
        ]);
    }
}
