<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Auth\Course;
use App\Models\Auth\BatchStudents;
use Illuminate\Foundation\Http\FormRequest;
use App\Repositories\Backend\Auth\RoleRepository;
use App\Repositories\Backend\Auth\PermissionRepository;
use App\Models\Auth\User;
use App\Models\Auth\Branch;
use App\Models\Auth\Batch;
use Illuminate\Support\Facades\Input;
use App\Models\Auth\Trainers;
use App\Http\Requests\Backend\Auth\User\BatchRequest;
use App\Http\Requests\Backend\Auth\User\ManageUserRequest;
use App\Repositories\Backend\Auth\UserRepository;
use App\Models\Auth\Attendance;

class TrainerAttendanceController extends Controller
{

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('training classes'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }            
            return $next($request);
        });
    }

    public function index()
    {
        return view('backend.trainerattendance.trainerattendance');
    }


    public function ajaxattendancedata(ManageUserRequest $request)
    {
        if (!$request->ajax()) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this page.');
        }
        echo $this->getDatatableAttendance($request);
    }


    public function getDatatableAttendance($request)
    {
        $my_branch = get_staff_branch_ids(\Auth::user()->id);

        $columns = array(
            0 => 'date',
            1 => 'code',
            2 => 'branch_name',
            3 => 'title',
            4 => 'name',
            5 => 'topics',
        );

        $totalData = count(DB::table('trainer_attendance')
            ->join('users', 'users.id', '=', 'trainer_attendance.trainer_id')
            ->join('batch', 'batch.id', '=', 'trainer_attendance.batch_id')
            ->join('branch', 'branch.id', '=', 'batch.branch')
            ->join('courses', 'courses.id', '=', 'batch.course')
            ->when(!empty($my_branch), function ($query) use ($my_branch) {
                return $query->whereIn('batch.branch', $my_branch);
            })
            ->get());


        $totalFiltered = $totalData;

        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');



        if (empty($request->input('search.value'))) {
            $users = DB::table('trainer_attendance')
                ->select('trainer_attendance.date', 'batch.code', 'branch.branch_name', 'courses.title', 'users.first_name', 'users.last_name', 'trainer_attendance.topics')
                ->join('users', 'users.id', '=', 'trainer_attendance.trainer_id')
                ->join('batch', 'batch.id', '=', 'trainer_attendance.batch_id')
                ->join('branch', 'branch.id', '=', 'batch.branch')
                ->join('courses', 'courses.id', '=', 'batch.course')
                ->when(!empty($my_branch), function ($query) use ($my_branch) {
                    return $query->whereIn('batch.branch', $my_branch);
                })
                ->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                ->get();
        } else {
            $get_search = $request->input('search.value');
            $users = DB::table('trainer_attendance')
                ->select('trainer_attendance.date', 'batch.code', 'branch.branch_name', 'courses.title', 'users.first_name', 'users.last_name', 'trainer_attendance.topics')
                ->join('users', 'users.id', '=', 'trainer_attendance.trainer_id')
                ->join('batch', 'batch.id', '=', 'trainer_attendance.batch_id')
                ->join('branch', 'branch.id', '=', 'batch.branch')
                ->join('courses', 'courses.id', '=', 'batch.course')
                ->where(function ($query) use ($get_search) {
                    $query->Where('users.first_name', 'like', "%$get_search%")
                        ->orWhere('trainer_attendance.date', 'like', "%$get_search%")
                        ->orWhere('batch.code', 'like', "%$get_search%")
                        ->orWhere('branch.branch_name', 'like', "%$get_search%")
                        ->orWhere('courses.title', 'like', "%$get_search%")
                        ->orWhere('trainer_attendance.topics', 'like', "%$get_search%")
                        ->orWhere('users.first_name', 'like', "%$get_search%")
                        ->orWhere('users.last_name', 'like', "%$get_search%");
                })
                ->when(!empty($my_branch), function ($query) use ($my_branch) {
                    return $query->whereIn('batch.branch', $my_branch);
                })
                ->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                ->get();


            $totalFiltered = count(DB::table('trainer_attendance')
                ->select('trainer_attendance.date', 'batch.code', 'branch.branch_name', 'courses.title', 'users.first_name', 'users.last_name', 'trainer_attendance.topics')
                ->join('users', 'users.id', '=', 'trainer_attendance.trainer_id')
                ->join('batch', 'batch.id', '=', 'trainer_attendance.batch_id')
                ->join('branch', 'branch.id', '=', 'batch.branch')
                ->join('courses', 'courses.id', '=', 'batch.course')
                ->where(function ($query) use ($get_search) {
                    $query->Where('users.first_name', 'like', "%$get_search%")
                        ->orWhere('trainer_attendance.date', 'like', "%$get_search%")
                        ->orWhere('batch.code', 'like', "%$get_search%")
                        ->orWhere('branch.branch_name', 'like', "%$get_search%")
                        ->orWhere('courses.title', 'like', "%$get_search%")
                        ->orWhere('trainer_attendance.topics', 'like', "%$get_search%")
                        ->orWhere('users.last_name', 'like', "%$get_search%");
                })
                ->when(!empty($my_branch), function ($query) use ($my_branch) {
                    return $query->whereIn('batch.branch', $my_branch);
                })
                ->get());
        }

        $data = array();
        if (!empty($users)) {
            foreach ($users as $page) {
                $customResult['name'] = $page->first_name . ' ' . $page->last_name;
                $customResult['code'] = $page->code;
                $customResult['branch_name'] = $page->branch_name;
                $customResult['title'] = $page->title;
                $customResult['date'] = get_date_formated($page->date);
                $customResult['topics'] = $page->topics;
                $data[] = $customResult;
            }
        }

        $json_data = array(
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $data
        );

        return json_encode($json_data);
    }
}
