<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Auth\FileUpload;
use App\Models\Auth\Category;
use App\Models\Gallery;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use Image;


use File;

class UploadDocumentController extends Controller
{

    

    protected $model;
    private $max_width;
    private $max_height;
    private $thumb_width;
    private $thumb_height;

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('file uploads'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }
            return $next($request);
        });
        $this->max_width = 1600;
        $this->max_height = 1200;
        $this->thumb_width = 600;
        $this->thumb_height = 450;
    }

    public function index()
    {
        $pages = DB::table('file_upload')
            ->select('category.category', 'file_upload.title', 'file_upload.filename', 'file_upload.id')
            ->join('category', 'category.id', '=', 'file_upload.category')
            ->get();
        $categorys = Category::all();
        return view('backend.upload.upload_documents', ['pages' => $pages, 'categorys' => $categorys]);
    }



    public function uploaddoc(Request $request)
    {
        $max_allowed = get_php_max_upload_size_kb();
        $request->validate([
            'file' => 'required|mimes:jpg,jpeg,png,docx,pdf,doc,mp4,mov,ogg,mp3,3gp,mpeg,zip|max:' . $max_allowed
        ], [
            'file.required' => 'Please select a file',
            'file.mimes' => 'Only jpg, jpeg, png, docx, pdf, doc, mp4, mov, ogg, mp3, 3gp, zip mpeg files are allowed',
        ]);
        // if (!$request->file('file')) {
        //     return redirect()->route('admin.upload')->withFlashDanger("Please select a file");
        // }

        $file = $request->file->getClientOriginalName();
        $filename = pathinfo($file, PATHINFO_FILENAME);
        if (strlen($filename) > 125)
            $filename = substr($filename, 0, 125);

        $filename = $filename . Str::random(20) . "." . $request->file->getClientOriginalExtension();

        $path = $request->file('file')->storeAs('/uploads', $filename, 'public');
        //Log::debug("::countryinfo doc savedpath::$path");
        DB::table('file_upload')
            ->insert(
                ['title' => $request->input('title'), 'category' => $request->input('category'), 'filename' => $path]
            );
        return redirect()->back()->withFlashSuccess("File Uploaded successfully");
    }

    public function deletedoc($id)
    {
        if (DB::table('file_upload')->where('id', $id)->exists()) {
            $row = DB::table('file_upload')->where('id', $id)->first();
            $file_path = storage_path() . '/app/public/' . $row->filename;
            DB::table('file_upload')->where('id', $id)->delete();
            //Storage::delete($file);
            unlink($file_path);

            return redirect()->back()->withFlashSuccess("File removed successfully");
        }
    }

    public function create()
    {
        return view('backend.upload.category');
    }

    public function category(Request $request)
    {
        $request->validate([
            'category' => 'required'
        ]);
        $category = new Category([
            'category' => $request->get('category'),
        ]);
        $category->save();
        return redirect()->route('admin.show.category')->withFlashSuccess('Category Added Successfully');
    }

    public function showCategory()
    {
        $categories = Category::all();
        return view('backend.upload.show_category', ["categories" => $categories]);
    }

    public function editCategory($id)
    {
        $category = Category::where("id", $id)->first();
        return view('backend.upload.edit_category', ["category" => $category]);
    }

    public function editCategoryStore(Request $request)
    {
        $request->validate([
            'category' => 'required'
        ]);

        $category = Category::where("id", $request->category_id)->first();
        $category->category = $request->get('category');
        $category->save();

        return redirect()->route('admin.show.category')->withFlashSuccess('Category Updated Successfully');
    }

    public function delete(Request $request)
    {
        $id = $request->get('application_id');
        $uploadCategory = Category::where('id', $id)->first();
        if ($uploadCategory) {
            $uploadCategory->delete();
            return redirect()->route('admin.show.category')->withFlashSuccess('Category Deleted Successfully');
        } else {
            return redirect()->route('admin.show.category')->withFlashDanger('Category Deleted Successfully');
        }
    }
}
