<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\VisaServiceType;
use App\Models\VisaLetterType;
use Illuminate\Http\Request;
use Log;

class VisaLetterTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $types = VisaLetterType::join('visa_service_types', 'visa_service_types.id', '=', 'visa_letter_types.service_type')
        ->select('visa_letter_types.*','visa_service_types.title as service_type', 'visa_service_types.id as service_type_id')
        ->orderBy('display_order')
        ->get();

        $categories = VisaServiceType::OrderBy('display_order')->get();

        return view('backend.visa.visa_letter_types', compact('types', 'categories'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|max:100|unique:visa_letter_types,title',
            'service_type' => 'required|numeric',
            'fees' => 'required|numeric',
            'display_order' => 'required|numeric',
            'status' => 'in:0,1',
        ]);

        VisaLetterType::create([
            "title" => $request->input("title"),
            "service_type" => $request->input("service_type"),
            "fees" => $request->input("fees"),
            "status" => $request->input("status"),
            "display_order" => $request->input("display_order"),
        ]);

        return redirect()->route("admin.visa-letter-type.index")->withFlashSuccess("Visa Letter Type Added!");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $type = VisaLetterType::findOrFail($id);
        $request->validate([
            'title' => 'required|max:100|unique:visa_letter_types,title,'.$id,
            'service_type' => 'required|numeric',
            'fees' => 'required|numeric',
            'display_order' => 'required|numeric',
            'status' => 'in:0,1',
        ]);

        $type->title = $request->input("title");
        $type->service_type = $request->input("service_type");
        $type->fees = $request->input("fees");
        $type->status = $request->input("status");
        $type->display_order = $request->input("display_order");
        $type->save();

        return redirect()->route("admin.visa-letter-type.index")->withFlashSuccess("Visa Letter Type Updated!");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $type = VisaLetterType::findOrFail($id);
        $type->delete();
        return redirect()->route("admin.visa-letter-type.index")->withFlashSuccess("Visa Letter Type Deleted!");
    }
}
