<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\VisaServiceType;
use App\Models\VisaLetterType;
use Illuminate\Http\Request;
use Log;

class VisaServiceTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $types = VisaServiceType::OrderBy('display_order')->get();
        return view('backend.visa.visa_service_types', compact('types'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|max:100|unique:visa_service_types,title',
            'display_order' => 'required|numeric',
            'status' => 'in:0,1',
        ]);

        VisaServiceType::create([
            "title" => $request->input("title"),
            "status" => $request->input("status"),
            "display_order" => $request->input("display_order"),
        ]);

        return redirect()->route("admin.visa-service-type.index")->withFlashSuccess("Visa Service Type Added!");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $type = VisaServiceType::findOrFail($id);
        $request->validate([
            'title' => 'required|max:100|unique:visa_service_types,title,'.$id,
            'display_order' => 'required|numeric',
            'status' => 'in:0,1',
        ]);

        $type->title = $request->input("title");
        $type->status = $request->input("status");
        $type->display_order = $request->input("display_order");
        $type->save();

        return redirect()->route("admin.visa-service-type.index")->withFlashSuccess("Visa Service Type Updated!");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $type = VisaServiceType::findOrFail($id);
        if(VisaLetterType::where('service_type', $id)->exists()) {
            return redirect()->route("admin.visa-service-type.index")->withFlashDanger("Visa Letter Type with this service type exists! Cannot delete!");
        }
        $type->delete();
        return redirect()->route("admin.visa-service-type.index")->withFlashSuccess("Visa Service Type Deleted!");
    }
}
