<?php

//Run this cron every hour

namespace App\Http\Controllers\Backend;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\MailSend;
use App\Models\Auth\User;
use App\Notifications\Backend\UserAlert;
use App\Repositories\Backend\Auth\UserRepository;
use App\Models\MailTemplates;

class WebinarNotifyController extends Controller {

  public function notify() {
    echo "\n\n<br><br>-------------- WEBINAR NOTIFY START. NOW: " . date("Y-m-d H:i") . " --------------";
    $datas = DB::table('webinar')
            ->select('topic', 'date', 'id')
            ->where('date', '>=', date("Y-m-d 00:00:00"))
            ->get();
    foreach ($datas as $data) {

      echo "\n\n<br><br>------Checking " . $data->id . ", " . $data->topic . ", " . $data->date;

      $notify_for_tomorrow = $notify_for_today = false;

      //Notify 24hrs before the webinar
      $webinar_date_hr = substr($data->date, 0, 13);
      $webinar_display_date = date("d M Y h:i a", strtotime($data->date));
      $webinar_display_date_short = date("j M h:i a", strtotime($data->date));      
      echo "\n<br>Webinar date hr:" . $webinar_date_hr;
      if (date("Y-m-d H", strtotime("+1 day")) == $webinar_date_hr) {
        echo "\n<br>-Notifying for Tomorrow webinar";
        $notify_for_tomorrow = true;
      }

      //Notify 2hrs before the webinar
      $two_hr_after = date("Y-m-d H", strtotime("+2 hour"));
      //echo "\n<br>2hrs after:".$two_hr_after;
      if ($webinar_date_hr == $two_hr_after) {
        echo "\n<br>-Notifying for webinar in next 2 hrs";
        $notify_for_today = true;
      }

      if ($notify_for_today || $notify_for_tomorrow) {
        $students = DB::table('student_webinar')->where('webinar_id', '=', $data->id)->get();
        foreach ($students as $student) {
          $user = User::find($student->student_id);

          $notify_sms = get_sms_template('WEBINAR_REMINDER');
          if($notify_sms && $notify_sms->status) {
            $notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
            $notify_sms->message = str_replace("#siteurl#", url('/'), $notify_sms->message);
            $notify_sms->message = str_replace("#first_name#", $user->first_name, $notify_sms->message);
            $notify_sms->message = str_replace("#full_name#", $user->full_name, $notify_sms->message);
            $notify_sms->message = str_replace("#webinar#", $data->topic, $notify_sms->message);
            $notify_sms->message = str_replace("#time#", $webinar_display_date_short, $notify_sms->message);
            $user->sms($notify_sms->message,$notify_sms->template_id);
          }


          //send email
          $email_message = "Dear %s, <br />This is a gentle reminder for the webinar/event.<br /><br />Webinar/Event: %s<br>Date: %s<br /><br />";
          $email_message = sprintf($email_message, $user->first_name, $data->topic, $webinar_display_date);
          echo "\n<br>***** Send EMail";
          try{
            //$user->notify(new UserAlert("Webinar/Event Reminder", $email_message));
            user_notify($user,"Webinar/Event Reminder", $email_message);
          }catch (\Exception $e) {
                $message = $e->getMessage();
                \Log::debug("Mail Error: (Webinar/Event Reminder) ".$message);   
          }
        }
      }
    }
    echo "\n\n<br><br>-------------- WEBINAR NOTIFY END --------------";
  }

}
