<?php

namespace App\Http\Controllers\Backend;
use App\Http\Controllers\Controller;
use App\Http\Requests;

use Illuminate\Support\Facades\File;

use App\Models\Auth\Country;
use App\Models\Auth\User;
use App\Models\Auth\Weight;
use App\Models\Auth\ZoneConfig;
use App\Models\Auth\CurrencyRate;
use App\Models\Auth\Zone;
use App\Models\Auth\State;
use App\Models\Auth\ShippingConfigsWeight;
use App\Models\Auth\Shipping;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Mail;
use Redirect;
use Auth;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Validator;

class ZoneController extends Controller
{

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('shop-management'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }
            return $next($request);
        });

    }
    
    public function index()
    { 
       $module_model = "App\Models\Auth\Zone";
       $module_name = $module_model::paginate();
       return view(
           "backend.zone.index",
           compact("module_name")
       );
    }

    public function zonelist(){
        $user_id = auth()->user()->id;

        $data = Zone::where('seller_id','=',$user_id)->groupBy('zone_name')->latest()->get();

        return Datatables::of($data)
        ->addIndexColumn()
        ->editColumn('name',function($data) {
            return ucfirst($data->zone_name);
        })
        ->addColumn('action', function($data){
          return view('backend.zone.btn',compact('data'));
        })
        ->rawColumns(['action'])
        ->make(true);

    }


    public function addzone(){
       
       $module_model = "App\Models\Auth\Zone";
       $module_name = $module_model::paginate();

      $items = Country::pluck('title_en', 'id');
      $userData = User::find(auth()->user()->id);

       return view(
           "backend.zone.create",
           compact("module_name",'items','userData')
       );
    }

    public function save_zone(Request $request){
          $validator = Validator::make($request->all(), [
        'zonename' => 'required',
        'country-type' => 'required',
]);

if ($validator->fails()) {
    $messages = $validator->errors();
    //print_r($messages);exit;
    if ($messages->first('from')) {
        return Redirect::back()->withErrors($validator)->withInput()->withFlashDanger('Zone Name is required.');
    }

    if ($messages->first('to')) {
        return Redirect::back()->withErrors($validator)->withInput()->withFlashDanger('Country Type is required.');
    }

}
$user_id = auth()->user()->id;
$previouszones = Zone::where('seller_id','=',$user_id)->groupBy('zone_name')->pluck('zone_name');
$zonename = $request->zonename;
// print_r($previouszones);exit;
if(count($previouszones)>0){ //echo '1';exit;
    for($i=0;$i<count($previouszones);$i++){
        if($previouszones[$i] == $zonename){
            $stat = "overlaped";
            break;
        }else{
            $stat = "not";
        }
    }
}else{ //echo '2';exit;
    $stat = "not";
}

if ($stat == "overlaped") {
    // echo "overlaped".$stat;exit;
    return Redirect::back()->withErrors($validator)->withInput()->withFlashDanger('Zone Name is already used.');
}
// echo $stat;exit;

// [zonename] => Indian Zone [country-type] => single [single_country] => 6 [state] => 179 [country] =>
if($request->single_country == '' && $request->state == ''){
    $count = $request->country;
    $user_id = auth()->user()->id;
    $zonename = $request->zonename;
    //print_r($count);exit;
    for($i=0;$i<count($count);$i++){
        $zone  = new Zone;
        $zone->seller_id = $user_id;
        $zone->zone_name = $zonename;
        $zone->country_id = $count[$i];
        $zone->save();
    }
}else{
    $country = $request->single_country;
    $user_id = auth()->user()->id;
    $zonename = $request->zonename;
    $states = $request->states;
    //print_r($states);exit;
    $state_count = count($states);
    for($i=0;$i<$state_count;$i++){
        $zone  = new Zone;
        $zone->seller_id = $user_id;
        $zone->zone_name = $zonename;
        $zone->country_id = $country;
        $zone->state_id = $states[$i];
        $zone->save();
    }
    
} 

return redirect()->route("admin.zones")->withFlashSuccess('Zone is Added Successfully.');

    }


    public function view_zone($id){

       $module_model = "App\Models\Auth\Zone";
       $module_name = $module_model::paginate();

    $user_id = auth()->user()->id;
    $details = Zone::where('id','=',$id)->first();
    if($details->state_id == ''){
        // echo $details->zone_name;exit;
        $zonename = $details->zone_name;
        $country_det = Zone::where('seller_id','=',$user_id)->where('zone_name','=',$zonename)->get();
        // print_r($country_det);exit;
        for($i=0;$i<count($country_det);$i++){
            $countryid = $country_det[$i]->country_id;
            $counts[] = Country::where('id','=',$countryid)->first();
        }
        // print_r($countries);exit;
        $type= "multiple";
        $items = Country::pluck('title_en', 'id');
        $countries = explode(",",$details->country_id);
        $countrycount = count($countries);
        $states = '';
        $cun_name = '';
        return view('backend.zone.edit',compact(
            "details",
            "items",
            "type",
            "countries",
            "countrycount",
            "states",
            "cun_name",
            "counts"
           ));
    }else{
        
        $cun = $details->country_id;
        $cun_name =Country::where('id','=',$cun)->first();
        $state_det = Zone::where('zone_name',$details->zone_name)->where('seller_id','=',$user_id)->where('country_id','=',$cun)->get();
        $items = Country::pluck('title_en', 'id');
        // echo $details->state_id;
        // print_r($state_det);exit;
        for($i=0;$i<count($state_det);$i++){
            $statesid = $state_det[$i]->state_id;
            $states[] = State::where('id','=',$statesid)->pluck('name');
        //    print_r($states);exit;
        }
        // $sat = 
        //echo count($states);
        // echo $states['2']['0'];exit;
        // print_r($states);
        // exit;
        // for($i=0;$i<count($states);$i++){
        //     $sta[$i]= $states[$i]['0'];
        // }

        $sta = array();
        for( $i = 0; $i < count($states); $i++ ){
            if(isset($states[$i]['0'])){
                $sta[$i] = $states[$i]['0'];
            }
        }
        //print_r($sta);exit;
        $states = $sta;
        // print_r($sta);exit;
        $type= "single";
        $countries = '';
        $countrycount = '';
        $counts = '';
        return view('backend.zone.edit',compact("module_name",
                "details",
                "items",
                "type",
                "countries",
                "countrycount",
                "states",
                "cun_name",
                "counts"
            ));
        }
    }


    public function delete_zone($id){
          $user_id = auth()->user()->id;
          $user = Zone::where('zone_name','=',$id)->where('seller_id','=',$user_id);
          $user->delete();
          return redirect()->route("admin.zones")->withFlashSuccess('Zone Deleted Successfully.');
    }


}
