<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\Auth\User;
use App\Models\UserActivity;
use Illuminate\Support\Carbon;
use Carbon\CarbonInterval;
use Log;
use Illuminate\Support\Facades\Mail;

class CallyzerWebhookController extends Controller
{

  
    public function calls_webhook(Request $request)
    {
    Log::debug("--------------CALLYZER CALL WEBHOOK START DateTime: ".now()."---------------");
     Log::debug("\n[CALLYZER CALL WEBHOOK]: Response: ".print_r($request->all(), true));
      $data = json_decode(file_get_contents('php://input'),true);

        //Loop though all the employee's records
        foreach($data as $key => $val) {
            //get Employee Name
            $employeeName =$val['employeeName'];
            
            //get Employee Number
            $employeeNumber =$val['employeeNumber'];
            $employeeCode =$val['countryCode'];
            
            //get call logs of an employee using the loop
            foreach ($val['logs'] as $lk => $lv) {
                 //get unique call log id
                $callLogId = $lv['id'];
                $chkentry = DB::table('user_activity')->where('callyzer_call_id',$callLogId)->first();
                if(!$chkentry){
                    $clientName = $lv['name'];
                    $clientNumber = $lv['number'];
                    $note = $lv['note'];
                    $dialcode = $lv['countryCode'];
                    $type = $lv['callType'];
                    $duration = $lv['duration'];
                    $callTime = $lv['callTime'];

                    if($type == "Incoming"){
                        $callType = "inbound_call";
                        $icn = "<i class='ri-arrow-left-down-line' style='color:#EC6613;font-size: 20px;vertical-align: middle;'></i>";
                        $call_from = $clientName." (+".$dialcode."-".$clientNumber.")";
                        $call_to = $employeeName." (+".$employeeCode."-".$employeeNumber.")";
                    }
                    else{
                        $callType = "outbound_call";
                        $icn = "<i class='ri-arrow-right-up-line' style='color:#03B74B;font-size: 20px;vertical-align: middle;'></i>";
                        $call_from = $employeeName." (+".$employeeCode."-".$employeeNumber.")";
                        $call_to = $clientName." (+".$dialcode."-".$clientNumber.")";
                    }
                    //check user
                    $user = User::where('mobile', $clientNumber)->where('dialcode',$dialcode)->first();
                    //store event in user activity
                    $message = "<b>From:</b> ".$call_from." <b>To:</b> ".$call_to."<br><b>Duration:</b> ".CarbonInterval::seconds($duration)->cascade()->forHumans()."<br><b>Call Time:</b> ".date('d/m/Y g:i A', strtotime($callTime));
                    if($user){
                        UserActivity::create(['callyzer_call_id' => $callLogId,'user_id' => $user->id, 'type' => $callType, 'title' => $icn.' '.$callType, 'detail' => $message]);
                        Log::debug("[CALLYZER CALL WEBHOOK]: User Activity added for User: ".$user->id." - ".$user->mobile);
                    }
                    
                }
            }
        }
        Log::debug("--------------CALLYZER CALL WEBHOOK END DateTime: ".now()."---------------");
    }
}
