<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Mail\MailSend;
use Illuminate\Support\Facades\Mail;
use App\Models\Auth\countries;


/**
 * Class DiagnosisController.
 */
class CurrencyRatesChangerController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */

    public function __construct(){}

    public function sendCurrencyRatesChangeRequest() {
        // set API Endpoint and API key
        $endpoint = 'latest';
        $access_key = '641b6f5d4fa203416670267e805757a6';

        // Initialize CURL:
        $ch = curl_init('http://api.exchangeratesapi.io/v1/'.$endpoint.'?access_key='.$access_key.'');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        // Store the data:
        $json = curl_exec($ch);
        curl_close($ch);

        // Decode JSON response:
        $exchangeRates = json_decode($json, true);
        
        // Storing rates data in country table
        if($exchangeRates){
            $currency_rates = $exchangeRates['rates'];
            foreach($currency_rates as $key => $rates){
                $update_rates = round($rates/env('ONE_EURO_IN_BASE_CURRENCY'), 7);
                if($update_rates > 0.999 && $update_rates < 1){
                    $update_rates = 1;
                }
                DB::table('countries')->where('currency', $key)->update(['rate' => $update_rates]);
            }
    
            echo "All Currency Rates are Updated!!";
        } else{
            echo "Returned Data is Empty!!";
        }

        // Access the exchange rate values, e.g. GBP:
        // echo $exchangeRates['rates']['GBP'];
    }
}
