<?php

namespace App\Http\Controllers;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\Auth\Universities;
use App\Models\Auth\UniversityCourses;
use Validator;
use Response;
use Redirect;
use Helper;
use App\Models\Auth\{
    User,
    Country,
    State,
    City
};

class DependantDropdownController extends Controller {

    public function fetchState(Request $request) {
        $data['states'] = State::where("country_id", $request->country_id)->get(["name", "id"]);
        return response()->json($data);
    }

    public function fetchCity(Request $request) {
        $data['cities'] = City::where("state_id", $request->state_id)->get(["name", "id"]);
        return response()->json($data);
    }


    public function fetchCitiesByCountry(Request $request) {
        // getting states by country
        $states = State::where("country_id", $request->country_id)->get(["id"]);
        $all_states = array();
        foreach($states as $state){
            $all_states[] = $state->id;
        }
        $data['cities'] = City::whereIn("state_id", $all_states)->get(["name", "id"]);
        return response()->json($data);
    }

    public function fetchUniversity(Request $request) {
        $data['university'] = Universities::where("country", $request->country_id)->orderBy('university_name')->get(["university_name", "id"]);
        return response()->json($data);
    }

    public function fetchCourse(Request $request) {
        $data['course'] = UniversityCourses::where("university", $request->university_id)
            ->where('study_level', $request->s_level)
            ->where('university_courses.status', 1)   
            ->orderBy('course_name')
            ->get(["course_name", "id"]);
            
        return response()->json($data);
    }

    public function fetchArea(Request $request) {
        $data = array();
            $getAreas = RegionArea::join('areas', 'areas.id', '=', 'region_areas.area_id')
            ->where("region_id", $request->region_id)
            ->get(["areas.name","areas.id"]);

            $data['areas'] = $getAreas;
            /*foreach($getAreas as $areas){
                $nestedData = @Helper::getAreaName($areas->area_id);
                $data[] =  $nestedData;
            }*/
            
        //$data['areas'] = Area::where("id", $request->region_id)->get(["name", "id"]);
        return response()->json($data);
    }

    public function searchUser(Request $request) {
        $users = User::where('name', 'LIKE', '%'.$request->input('q', '').'%')
        ->orWhere('username', 'LIKE', '%'.$request->input('q', '').'%')
        ->orWhere('email', 'LIKE', '%'.$request->input('q', '').'%')
        ->select('id', DB::raw("concat_ws(' | ', name, email) as text"))
        ->get();
        return ['results' => $users];        
    }

    public function fetchVisaLetterType(Request $request) {
        $data['lettertypes'] = DB::table('visa_letter_types')
            ->where("service_type", $request->service_id)
            ->where("status", 1)
            ->orderBy("display_order")
            ->get(["id", "title", "fees"]);
        return response()->json($data);
    }   


}
