<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Http;
use App\Recipients\AdminRecipient;
use App\Models\Auth\User;
use App\Models\Auth\Lead;
use App\Notifications\Backend\UserAlert;
use App\Notifications\Frontend\AdminAlert;
use App\Mail\MailSend;
use Illuminate\Support\Facades\Mail;
use App\Models\Auth\LeadActivity;
use App\Models\SMSTemplates;
use App\Models\MailTemplates;
use DB;
class FacebookLeadWebhookController extends Controller
{
    /**
     * GET facebook/webhook (verification)
     * Meta (Facebook) will call this once when you set up the webhook.
     */
    public function verifyWebhook(Request $request)
    {
 
        $verifyToken = env('FACEBOOK_WEBHOOK_TOKEN', '');

        if (
            $request->get('hub_mode') === 'subscribe' &&
            $request->get('hub_verify_token') === $verifyToken
        ) {
            return response($request->get('hub_challenge'), 200);
        }

        return response('Forbidden', 403);
    }

     /**
     * POST facebook/webhook (events)
     */
    public function handleWebhook(Request $request)
    {
        Log::info('---------FB Lead webhook payload:------', $request->all());
        $payload = $request->all();

        if (!isset($payload['entry'][0]['changes'][0]['value']['leadgen_id'])) {
            return response('NO_LEAD', 200);
        }

        $leadId = $payload['entry'][0]['changes'][0]['value']['leadgen_id'];
        $pageId = $payload['entry'][0]['id'];

        $response = Http::get("https://graph.facebook.com/v18.0/{$leadId}", [
            'access_token' => env('FACEBOOK_PAGE_ACCESS_TOKEN'),
            'fields'       => 'id,created_time,field_data'
        ]);

        if (!$response->ok()) {
            Log::error("FB Lead fetch failed: " . $response->body());
            return response('ERROR', 500);
        }

        $leadData = $response->json();
        Log::info('-------------FB Lead Data:----------', $leadData);

        $fieldData = collect($leadData['field_data'] ?? [])
            ->mapWithKeys(function ($item) {
                return [$item['name'] => $item['values'] ?? []];
            });

        $fullName = $fieldData['full_name'][0] ?? null;
        $firstName = null;
        $lastName  = null;

        if ($fullName) {
            $nameParts = explode(' ', $fullName, 2);
            $firstName = $nameParts[0] ?? null;
            $lastName  = $nameParts[1] ?? null;
        }

        $email = $fieldData['email'][0] ?? null;
        $phone = $fieldData['phone_number'][0] ?? null;
        $city  = $fieldData['city'][0] ?? null;

        $dialCode = null;
        $mobile   = null;


        if ($phone) {
            $cleanPhone = preg_replace('/[^0-9+]/', '', $phone);
            if (str_starts_with($cleanPhone, '+')) {
                $withoutPlus = substr($cleanPhone, 1);
                $dialCode = substr($withoutPlus, 0, 2);
                $mobile = substr($withoutPlus, strlen($dialCode));
            } else {
                $dialCode = '91';
                $mobile   = $cleanPhone;
            }
        }

        $leadStatus = get_default_lead_status();
        $meta_lead_assign_to = get_site_config('meta_lead_assign_to');
        $meta_lead_assign_to_branch = get_site_config('meta_lead_assign_to_branch');
        $refcode    = generate_refcode($firstName ?? 'Lead');

        $userId = DB::table('users')->insertGetId([
            'first_name'   => $firstName,
            'last_name'    => $lastName,
            'email'        => $email,
            'dialcode'       => $dialCode,
            'mobile'       => $mobile,
            'city'         => $city,
            'assigned_to' => $meta_lead_assign_to,
            'branch'      => $meta_lead_assign_to_branch,
            'lead_status'  => $leadStatus,
            'refcode'      => $refcode,
            'lead_source'  => 'Facebook',
            'is_lead'      => 1,
            'created_mode' => 'facebook_webhook',
            'created_at'   => now(),
        ]);

        $notes = collect($fieldData)->map(function ($values, $key) {
            $label = ucfirst(str_replace('_', ' ', $key));
            return "{$label}: " . implode(", ", $values);
        })->implode("\n");


        DB::table('user_details')->insert([
            'userid'             => $userId,
            
            'lead_notes'         => $notes,
            'user_data_js'       => collect($fieldData)->map(fn($v) => $v[0] ?? null)
                                    ->toJson(JSON_UNESCAPED_UNICODE),
            'created_at'         => now(),
        ]);

        $notify_emails = get_site_config('event_notification_email');
        if($notify_emails) {
            send_event_notification_email(explode(",", $notify_emails), "New Facebook Lead", $notes);
        }


        //send welcome email
        \Log::debug("Lead: sending Facebook Lead generated mail to user");
        $mail_tpl = MailTemplates::find("LEAD_WELCOME_FACEBOOKLEAD");
        if ($mail_tpl && $mail_tpl->status) {
            $email_message = $mail_tpl->message;
            $full_name = $firstName . ' ' . $lastName;
            $email_message = str_ireplace("#sitename#", app_name(), $email_message);
            $email_message = str_ireplace("#siteurl#", url(''), $email_message);
            $email_message = str_ireplace("#first_name#", $firstName, $email_message);
            $email_message = str_ireplace("#full_name#", $full_name, $email_message);
            $email_message = str_ireplace("#email#", $email, $email_message);
            $email_message = str_ireplace("#mobile#", $dialcode . ' ' . $mobile, $email_message);
            try {
                // $leaddetails = Lead::find($leadid);
                $leaddetails = User::find($userId);
                //$leaddetails->notify(new UserAlert($mail_tpl->subject, $email_message));
                user_notify($leaddetails, $mail_tpl->subject, $email_message);
                \Log::debug("Facebook Lead: mail sent to user- " . $email_message);
                LeadActivity::create(['lead_id' => $userId, 'date' => date("Y-m-d H:i:s"), 'detail' => "Email Sent: Subject:" . $mail_tpl->subject . "<br>Message:" . $email_message]);
            } catch (\Exception $e) {
                $message = $e->getMessage();
                \Log::debug("Mail Error: (NEW FACEBOOK LEAD) " . $message);
            }
        }

        if (get_site_config('whatsapp_enabled')) {
            $numbers = [$dialcode.$mobile];

            $hook = 'lead_welcome_facebooklead';

            send_whatsapp_message($numbers, $hook, $userId);
        }

        $sms_tpl = SMSTemplates::find("LEAD_WELCOME_FACEBOOKLEAD");
        if ($sms_tpl && $sms_tpl->status) {
            $sms_message = $sms_tpl->message;
            $sms_message = str_ireplace("#sitename#", app_name(), $sms_message);
            $sms_message = str_ireplace("#siteurl#", url(''), $sms_message);
            $sms_message = str_ireplace("#first_name#", $firstName, $sms_message);
            $sms_message = str_ireplace("#full_name#", $fullName, $sms_message);
            $sms_message = str_ireplace("#email#", $email, $sms_message);
            try {
                $leaddetails = User::find($userId);
                $leaddetails->notify(new UserAlert($sms_tpl->message, $sms_message));
            } catch (\Exception $e) {
                $message = $e->getMessage();
                \Log::debug("SMS Error: (CONVERT LEAD)" . $message);
            }
        }

        Log::info("-----------Stored new Facebook lead with User ID {$userId}-----------"); 

        return response('EVENT_RECEIVED', 200);
    }

}
