<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\MailTemplates;
use App\Recipients\AdminRecipient;
use App\Models\Auth\User;
use App\Models\Auth\Posts;
use App\Models\Forms;
use App\Models\FormItem;
use App\Models\Auth\Country;
use App\Repositories\Backend\Auth\UserRepository;
use App\Notifications\Backend\UserAlert;
use App\Notifications\Frontend\AdminAlert;
use App\Mail\MailSend;
use Illuminate\Support\Facades\Mail;
use App\Models\Auth\LeadActivity;
use App\Models\SMSTemplates;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Validator;
use Log;

class FormsController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */

     public function __construct()
     {
         $this->menu_details = array();
         
 
         if(config('app.product_code') == 'TRAINING') {
             $main_menus = Posts::Select('id', 'title', 'menu_title', 'slug')
             ->where('status', '=', 1)
             ->where('show_in_main_menu', '=', 1)
             ->where(function ($query) {
                 $query->Where('module_type', '<>', "home")
                     ->Where('module_type', '<>', "country")
                     ->orWhere('module_type', NULL);
             })
             ->orderBy('order')
             ->get();
         } else if(config('app.product_code') == 'OVERSEAS') {
             $main_menus = Posts::Select('id', 'title', 'menu_title', 'slug')
             ->where('status', '=', 1)
             ->where('show_in_main_menu', '=', 1)
             ->where(function ($query) {
                 $query->Where('module_type', '<>', "home")
                     ->Where('module_type', '<>', "coaching")
                     ->Where('module_type', '<>', "courses")
                     ->orWhere('module_type', NULL);
             })
             ->orderBy('order')
             ->get();
 
         } else {
             $main_menus = Posts::Select('id', 'title', 'menu_title', 'slug')
             ->where('status', '=', 1)
             ->where('show_in_main_menu', '=', 1)
             ->where(function ($query) {
                 $query->Where('module_type', '<>', "home")
                     ->orWhere('module_type', NULL);
             })
             ->orderBy('order')
             ->get();
         }
 
         foreach ($main_menus as $main_menu) {
             $menu_title = $main_menu['menu_title'] != '' ? $main_menu['menu_title'] : $main_menu['title'];
             $this->menu_details[$menu_title] =  route('frontend.view-article', [$main_menu['slug']]);
         }
     }

    public function view_form($form_id)
    {
        $list_det = array();
        $cms_page = "1";
        $main_menu_arr = $this->menu_details;

        if (!isset($form_id)) {
            return redirect()->route('index');
        }

        $form_data = Forms::Where('id',$form_id)->first();
        $formItems = "";
        if($form_data->content){
            $formItems = json_decode($form_data->content);
            $formItems = $formItems[0]; 
            foreach($formItems as $form){
            $form->title = formItem::where('id',$form->id)->value('title');
            $form->label = formItem::where('id',$form->id)->value('label');
            $form->placeholder = formItem::where('id',$form->id)->value('placeholder');
            $form->unique = formItem::where('id',$form->id)->value('unique');
            $form->hint = formItem::where('id',$form->id)->value('hint');
            $form->mandatory = formItem::where('id',$form->id)->value('mandatory');
            $form->input_name = formItem::where('id',$form->id)->value('input_name');
            $form->type = formItem::where('id',$form->id)->value('type');
            }
        }
        $country_list = Country::pluck('title_en', 'id');
        $study_countries = Country::where('overseas_status', 1)->orderBy('title_en', 'ASC')->get();
        $dialcodes = Country::groupBy('tel')->orderBy('tel','asc')->get(['tel as dialcode','code', 'title_en as name']);
        return view("frontend.form_view", compact("form_data","formItems", "cms_page", "main_menu_arr", "list_det","dialcodes","country_list","study_countries"));
    }


    public function view_form_embed($form_id)
    {
        $list_det = array();
        $cms_page = "1";
        $main_menu_arr = $this->menu_details;

        if (!isset($form_id)) {
            return redirect()->route('index');
        }

        $form_data = Forms::Where('id',$form_id)->first();
        $formItems = "";
        if($form_data->content){
            $formItems = json_decode($form_data->content);
            $formItems = $formItems[0]; 
            foreach($formItems as $form){
            $form->title = formItem::where('id',$form->id)->value('title');
            $form->label = formItem::where('id',$form->id)->value('label');
            $form->placeholder = formItem::where('id',$form->id)->value('placeholder');
            $form->unique = formItem::where('id',$form->id)->value('unique');
            $form->hint = formItem::where('id',$form->id)->value('hint');
            $form->mandatory = formItem::where('id',$form->id)->value('mandatory');
            $form->input_name = formItem::where('id',$form->id)->value('input_name');
            $form->type = formItem::where('id',$form->id)->value('type');
            }
        }
        $country_list = Country::pluck('title_en', 'id');
        $study_countries = Country::where('overseas_status', 1)->orderBy('title_en', 'ASC')->get();
        $dialcodes = Country::groupBy('tel')->orderBy('tel','asc')->get(['tel as dialcode','code', 'title_en as name']);
        return view("frontend.form_view_embed", compact("form_data","formItems", "cms_page", "main_menu_arr", "list_det","dialcodes","country_list","study_countries"));
    }

    public function formBuilderLeadTracking(Request $request)
    {
        if($request->input('email_unique') && $request->input('mobile_unique')){
            $validator =  \Validator::make($request->all(), [
                'first_name' => 'max:50',
                'last_name' => 'max:50',
                'name' => 'max:50',
                'current_course' => 'max:100',
                'course_interested' => 'max:100',
                'score' => 'max:50',
                'email' => 'email:filter,filter_unicode|nullable|sometimes|unique:users',
                'mobile' => ['nullable', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH'), 'unique:users,mobile'],
                'whatsapp_number' => ['nullable', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH')],

            ],
            [
                'first_name.max' => 'The first name may not be greater than 50 characters.',
                'last_name.max' => 'The last name may not be greater than 50 characters.',
                'name.max' => 'The name may not be greater than 50 characters.',
                'email.email' => 'The email must be valid email address',
                'email.unique' => 'The email has already been taken.',
                'mobile.unique' => 'The mobile number has already been taken.',
                'mobile.max' => 'The mobile number may not be greater than 11 characters.',
                'mobile.digits_between' => 'The mobile number should be between '.config('app.USER_MOBILE_MIN_LENGTH').' and '.config('app.USER_MOBILE_MAX_LENGTH').' digits.',
                'city.max' => 'The city may not be greater than 50 characters.',
                'current_course.max' => 'The Currently Studying Course may not be greater than 100 characters.',
                'course_interested.max' => 'The Course Interested to Study may not be greater than 100 characters.',
            ]);
        }
        else if($request->input('email_unique') && !$request->input('mobile_unique')){
            $validator =  \Validator::make($request->all(), [
                'first_name' => 'max:50',
                'last_name' => 'max:50',
                'name' => 'max:50',
                'current_course' => 'max:100',
                'course_interested' => 'max:100',
                'score' => 'max:50',
                'email' => 'email:filter,filter_unicode|nullable|sometimes|unique:users',
                'mobile' => ['nullable', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH')],
                'whatsapp_number' => ['nullable', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH')],

            ],
            [
                'first_name.max' => 'The first name may not be greater than 50 characters.',
                'last_name.max' => 'The last name may not be greater than 50 characters.',
                'name.max' => 'The name may not be greater than 50 characters.',
                'email.email' => 'The email must be valid email address',
                'email.unique' => 'The email has already been taken.',
                'mobile.unique' => 'The mobile number has already been taken.',
                'mobile.max' => 'The mobile number may not be greater than 11 characters.',
                'mobile.digits_between' => 'The mobile number should be between '.config('app.USER_MOBILE_MIN_LENGTH').' and '.config('app.USER_MOBILE_MAX_LENGTH').' digits.',
                'city.max' => 'The city may not be greater than 50 characters.',
                'current_course.max' => 'The Currently Studying Course may not be greater than 100 characters.',
                'course_interested.max' => 'The Course Interested to Study may not be greater than 100 characters.',
            ]);
        }
        else if(!$request->input('email_unique') && $request->input('mobile_unique')){
            $validator =  \Validator::make($request->all(), [
                'first_name' => 'max:50',
                'last_name' => 'max:50',
                'name' => 'max:50',
                'current_course' => 'max:100',
                'course_interested' => 'max:100',
                'score' => 'max:50',
                'email' => 'email:filter,filter_unicode|nullable',
                'mobile' => ['nullable', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH'), 'unique:users,mobile'],
                'whatsapp_number' => ['nullable', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH')],

            ],
            [
                'first_name.max' => 'The first name may not be greater than 50 characters.',
                'last_name.max' => 'The last name may not be greater than 50 characters.',
                'name.max' => 'The name may not be greater than 50 characters.',
                'email.email' => 'The email must be valid email address',
                'email.unique' => 'The email has already been taken.',
                'mobile.unique' => 'The mobile number has already been taken.',
                'mobile.max' => 'The mobile number may not be greater than 11 characters.',
                'mobile.digits_between' => 'The mobile number should be between '.config('app.USER_MOBILE_MIN_LENGTH').' and '.config('app.USER_MOBILE_MAX_LENGTH').' digits.',
                'city.max' => 'The city may not be greater than 50 characters.',
                'current_course.max' => 'The Currently Studying Course may not be greater than 100 characters.',
                'course_interested.max' => 'The Course Interested to Study may not be greater than 100 characters.',
            ]);
        }else{
            $validator =  \Validator::make($request->all(), [
                'first_name' => 'max:50',
                'last_name' => 'max:50',
                'name' => 'max:50',
                'current_course' => 'max:100',
                'course_interested' => 'max:100',
                'score' => 'max:50',
                'email' => 'email:filter,filter_unicode|nullable',
                'mobile' => ['nullable', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH')],
                'whatsapp_number' => ['nullable', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH')],

            ],
            [
                'first_name.max' => 'The first name may not be greater than 50 characters.',
                'last_name.max' => 'The last name may not be greater than 50 characters.',
                'name.max' => 'The name may not be greater than 50 characters.',
                'email.email' => 'The email must be valid email address',
                'email.unique' => 'The email has already been taken.',
                'mobile.unique' => 'The mobile number has already been taken.',
                'mobile.max' => 'The mobile number may not be greater than 11 characters.',
                'mobile.digits_between' => 'The mobile number should be between '.config('app.USER_MOBILE_MIN_LENGTH').' and '.config('app.USER_MOBILE_MAX_LENGTH').' digits.',
                'city.max' => 'The city may not be greater than 50 characters.',
                'current_course.max' => 'The Currently Studying Course may not be greater than 100 characters.',
                'course_interested.max' => 'The Course Interested to Study may not be greater than 100 characters.',
            ]);
        }

        //Google Recaptcha Validation
        if(get_site_config('recaptcha_site_key')!="" && get_site_config('recaptcha_secret_key')!="" && get_site_config('form_builder_captcha')==1){
            $request->validate([
                'g-recaptcha-response' => 'required',
            ], [
                'g-recaptcha-response.required' => 'Please complete the reCAPTCHA verification.',
            ]);
        
            $response = \Http::asForm()->post('https://www.google.com/recaptcha/api/siteverify', [
                'secret' => env('GOOGLE_RECAPTCHA_SECRET'),
                'response' => $request->input('g-recaptcha-response'),
            ]);
        
            $responseBody = $response->json();
            if (!$responseBody['success']) {
                $errorCodes = $responseBody['error-codes'] ?? [];
                $errorMessage = 'reCAPTCHA validation failed.';
                if (in_array('timeout-or-duplicate', $errorCodes)) {
                    $errorMessage = 'The reCAPTCHA has timed out or is a duplicate. Please try again.';
                } elseif (in_array('invalid-input-response', $errorCodes)) {
                    $errorMessage = 'The reCAPTCHA response is invalid. Please try again.';
                }
                //return redirect()->route('frontend.web-lead-error-page')->withErrors($validator)->withInput();
                return back()->withErrors(['g-recaptcha-response' => $errorMessage])->withInput();
            }
        }
        //Google Recaptcha Validation
   

        if ($validator->fails()) {
            return redirect()->route('frontend.web-lead-error-page')->withErrors($validator)->withInput();
        }

        $client_ip = $_SERVER['REMOTE_ADDR'] ?? $_SERVER['REMOTE_ADDR'];
        \Log::debug("FORMBUILDER DATA RECEIVED From: $client_ip WITH DATA: " . var_export($_POST, true));
        $form_id = $request->form_id;
        $insert_qry = $insert__details_qry = $notes = $first_name = $last_name = $name = $email = $mobile = $city = $gender = $marital_status = $dialcode =  $country_of_citizenship = $country_interested = $date_of_birth = $current_course = $study_level = $accommodation = $study_permit = $course_interested = $whatsapp_dialcode = $whatsapp= $intake= $qualification= $passout_year = $score = $visa_refusal = $experience = '';
        $visa_refusal_country =array();
        if ($form_id != "") {
            $formData = Forms::find($form_id);
            $redirect_url = $formData->redirect_url;
            $form_name = $formData->title;
            $assign_to = $request->staff;
            $form_type = $request->form_type;
            $assign_to_branch = $request->staff_branch;
            $lead_status = get_default_lead_status();

    
            $insert_qry = "INSERT INTO users SET assigned_to='{$assign_to}',lead_form_type='{$form_type}',branch='{$assign_to_branch}',lead_status='{$lead_status}', created_at='" . date('Y-m-d H:i:s') . "', lead_source='WebForm2Lead', is_lead='1', ";
            $insert__details_qry = "INSERT INTO user_details SET lead_source_detail='{$form_name}',created_at='" . date('Y-m-d H:i:s') . "', ";
            $data = $request->except(['_token', 'submit']);
            $params = $details_params = array();
            foreach ($data as $key => $value) {
                if ($key == 'first_name' && $first_name == '') {
                    $first_name = $value; //$request->input('first_name');
                    $insert_qry .= " first_name =? ,";
                    $params[] = $first_name;
                } else if ($key == 'last_name' && $last_name == '') {
                    $last_name = $value; //$request->input('last_name');
                    $insert_qry .= " last_name =? ,";
                    $params[] = $last_name;
                } 
                else if ($key == 'name' && $name == '') {
                    if($first_name == "" && $last_name == ""){
                        $name = $value; //$request->input('last_name');
                        $insert_qry .= " first_name =? ,";
                        $params[] = $name;
                    }
                }
                else if ($key == 'email' && $email == '') {
                    $email = $value; //$request->input('email');
                    $insert_qry .= " email =? ,";
                    $params[] = $email;
                } else if ($key == 'mobile' && $mobile == '') {
                    $mobile = $value; //$request->input('mobile');
                    $insert_qry .= " mobile =? ,";
                    $params[] = $mobile;
                } else if ($key == 'city' && $city == '') {
                    $city = $value; //$request->input('city');
                    //$insert_qry .= " address =? ,";
                    $insert_qry .= " city =? ,";
                    $params[] = $city;
                }

                //Added newly added fields
                else if ($key == 'gender' && $gender == '') {
                    if($value){
                        $gender = $value;
                    }else{
                         $gender = "male";
                    }
                    $insert_qry .= " gender =? ,";
                    $params[] = $gender;
                }
                 else if ($key == 'dialcode' && $dialcode == '') {
                    $dialcode = $value;
                    $insert_qry .= " dialcode =? ,";
                    $params[] = $dialcode;
                }
                else if ($key == 'whatsapp_dialcode' && $whatsapp_dialcode == '') {
                    $whatsapp_dialcode = $value;
                    $insert_qry .= " whatsapp_dialcode =? ,";
                    $params[] = $whatsapp_dialcode;
                }
                else if ($key == 'whatsapp' && $whatsapp == '') {
                    $whatsapp = $value;
                    $insert_qry .= " whatsapp =? ,";
                    $params[] = $whatsapp;
                }
                else if ($key == 'country_of_citizenship' && $country_of_citizenship == '') {
                    $country_of_citizenship = $value;
                    if($country_of_citizenship !=""){
                        $insert_qry .= " country =? ,";
                        $params[] = $country_of_citizenship;
                    }else{
                        $insert_qry .= " country =? ,";
                        $params[] = config('app.USER_DEFAULT_COUNTRY');
                    }
                } else if ($key == 'country_interested' && $country_interested == '') {
                    $country_interested = $value;
                    $insert_qry .= " country_interested =? ,";
                    $params[] = $country_interested;
                } else if ($key == 'date_of_birth' && $date_of_birth == '') {
                    $date_of_birth = $value;
                    $insert_qry .= " birthday =? ,";
                    $params[] = $date_of_birth;
                } else if ($key == 'current_course' && $current_course == '') {
                    $current_course = $value;
                    $insert__details_qry .= " current_course =? ,";
                    $details_params[] = $current_course;
                }
                else if ($key == 'marital_status' && $marital_status == '') {
                    $marital_status = $value;
                    $insert__details_qry .= " marital_status =? ,";
                    $details_params[] = $marital_status;
                }
                 else if ($key == 'study_level' && $study_level == '') {
                    $study_level = $value;
                    $insert_qry .= " overseas_study_level_selection =? ,";
                    $params[] = $study_level;

                    if($study_level !=""){
                        $study_degree = get_study_level_degree_level($value);
                    }else{
                        $study_degree = NULL;
                    }
                    $insert_qry .= " overseas_study_level =? ,";
                    $params[] = $study_degree;
                } else if ($key == 'course_interested' && $course_interested == '') {
                    $course_interested = $value;
                    $insert_qry .= " overseas_course_intersted =? ,";
                    $params[] = $course_interested;
                }
                else if ($key == 'intake' && $intake == '') {
                    if (!empty($value)) {
                        $intake = $value;
                        $intatake_arr =  explode(" ", $intake);
                    } else {
                        $intatake_arr = array(null, null);
                    }
                    $insert__details_qry .= " intake_year =? ,";
                    $details_params[] = $intatake_arr[1];
                    $insert__details_qry .= " intake_month =? ,";
                    $details_params[] = $intatake_arr[0];
                }
                else if ($key == 'qualification' && $qualification == '') {
                    $qualification = $value;
                    $insert__details_qry .= " highest_level_education =? ,";
                    $details_params[] = $qualification;
                }
                else if ($key == 'passout_year' && $passout_year == '') {
                    $passout_year = $value;
                    $insert__details_qry .= " passout_year =? ,";
                    $details_params[] = $passout_year;
                }
                else if ($key == 'score' && $score == '') {
                    $score = $value;
                    $insert__details_qry .= " qualification_score =? ,";
                    $details_params[] = $score;
                }
                 else if ($key == 'accommodation' && $accommodation == '') {
                    $accommodation = $value;
                    $insert__details_qry .= " accommodation =? ,";
                    $details_params[] = $accommodation;
                } else if ($key == 'study_permit' && $study_permit == '') {
                    $study_permit = $value;
                    $insert__details_qry .= " study_permit =? ,";
                    $details_params[] = $study_permit;
                }
                else if ($key == 'experience' && $experience == '') {
                    $experience = $value;
                    $insert__details_qry .= " work_experience =? ,";
                    $details_params[] = $experience;
                }
                else if ($key == 'notes' && $notes == '') {
                    $notes = $value;
                    $insert__details_qry .= " lead_notes =? ,";
                    $details_params[] = $notes;
                }
                else if ($key == 'visa_refusal' && $visa_refusal == '') {
                    $visa_refusal = $value;
                    if($visa_refusal == '1'){
                        $visa_refusal_country = implode(",", $visa_refusal_country);
                    }else{
                        $visa_refusal_country = NULL;
                    }
                    $insert__details_qry .= " visa_refusal =? ,";
                    $details_params[] = $visa_refusal;

                    $insert__details_qry .= " visa_refusal_country =? ,";
                    $details_params[] = $visa_refusal_country;
                }
                //Added newly added fields
            }
       
            //Checking custom attributes
                $attributes_json = "";
                $all_atts = array();
                foreach ($data as $key => $value) {
                    if (get_attr_data($key)) {
                        $all_atts[$key] = $request->$key;
                        $attributes_json = json_encode($all_atts);
                    }
                }
                if ($attributes_json != '') {
                    $insert__details_qry .= " user_data_js =? ,";
                    $details_params[] = $attributes_json;
                }
            //Checking custom attributes
           

            // if ($notes != '') {
            //     $insert__details_qry .= " lead_notes =? ,";
            //     $details_params[] = $notes;
            // }
            $insert_qry = rtrim($insert_qry, ', ');
            \Log::debug("FORMBUILDER Query:" . $insert_qry);
            \Log::debug("FORMBUILDER Params:" . implode(" , ", $params));
            DB::insert($insert_qry, $params);
            $leadid = DB::getPdo()->lastInsertId();

            //adding to details table
            if($leadid){
                $insert__details_qry .= " userid =? ,";
                $details_params[] = $leadid;
                $insert__details_qry = rtrim($insert__details_qry, ', ');
                \Log::debug("FORMBUILDER Query:" . $insert__details_qry);
                \Log::debug("FORMBUILDER Params:" . implode(" , ", $details_params));
                DB::insert($insert__details_qry, $details_params);

                if (isset($request->aca) && $request->aca != '') {
                    $data = $request->all();
                    $aca_level = array('10', '12', 'Diploma', 'Bachelors', 'Masters', 'Other');
                    for ($i = 0; $i < count($aca_level); $i++) {
                        $exam_name = $aca_level[$i];
                        $percent_cgpa = $data['aca'][$exam_name]['percent_cgpa'];
                        $pass_year = $data['aca'][$exam_name]['pass_year'];
                        $specialization = $data['aca'][$exam_name]['specialization'];
                        $school_college = $data['aca'][$exam_name]['school_college'];
                        $university = $data['aca'][$exam_name]['university'];
                        //$backlogs = $data['aca'][$exam_name]['backlogs'];

                        DB::table('user_academics')
                            ->updateOrInsert(
                                ['userid' => $leadid, 'education_level' => $exam_name],
                                [
                                    'percent_cgpa' => $percent_cgpa,
                                    'pass_year' => $pass_year,
                                    'specialization' => $specialization,
                                    'school_college' => $school_college,
                                    'university' => $university,
                                    //'backlogs' => $backlogs
                                ]
                            );
                    }
                }
                if (isset($request->eng) && $request->eng != '') {
                    $data = $request->all();
                    $eng_exam = array('IELTS', 'TOEFL', 'PTE');
                    for ($i = 0; $i < count($eng_exam); $i++) {
                        $exam_name = $eng_exam[$i];
                        $overall_score = $data['eng'][$exam_name]['overall_score'];
                        $speaking = $data['eng'][$exam_name]['speaking'];
                        $reading = $data['eng'][$exam_name]['reading'];
                        $listening = $data['eng'][$exam_name]['listening'];
                        $writing = $data['eng'][$exam_name]['writing'];
                        $expiry_date = $data['eng'][$exam_name]['expiry_date'];
                        if ($expiry_date) {
                            $expiry_date_db = date("Y-m-d", strtotime(substr($expiry_date, 6, 4) . "-" . substr($expiry_date, 3, 2) . "-" . substr($expiry_date, 0, 2)));
                        } else {
                            $expiry_date_db = NULL;
                        }
                        DB::table('user_certification_eng')
                            ->updateOrInsert(
                                ['userid' =>  $leadid, 'exam' => $exam_name],
                                [
                                    'overall_score' => $overall_score,
                                    'speaking' => $speaking,
                                    'reading' => $reading,
                                    'listening' => $listening,
                                    'writing' => $writing,
                                    'expiry_date' => $expiry_date_db
                                ]
                            );
                    }
                }
                //DET
                    if(!empty($request->input('det_overall_score'))){
                        $det_expiry_date = $request->input('det_expiry_date');
                        if ($det_expiry_date) {
                            $det_expiry_date_db = date("Y-m-d", strtotime(substr($det_expiry_date, 6, 4) . "-" . substr($det_expiry_date, 3, 2) . "-" . substr($det_expiry_date, 0, 2)));
                        } else {
                            $det_expiry_date_db = NULL;
                        }
                        DB::table('user_certification_eng')
                            ->updateOrInsert(
                                ['userid' => $leadid, 'exam' => 'DET'],
                                [
                                    'overall_score' => $request->input('det_overall_score'),
                                    'expiry_date' => $det_expiry_date_db
                                ]
                            );
                    }

            //ACT
                    if(!empty($request->input('act_overall_score'))){
                        $act_expiry_date = $request->input('act_expiry_date');
                        if ($act_expiry_date) {
                            $act_expiry_date_db = date("Y-m-d", strtotime(substr($act_expiry_date, 6, 4) . "-" . substr($act_expiry_date, 3, 2) . "-" . substr($act_expiry_date, 0, 2)));
                        } else {
                            $act_expiry_date_db = NULL;
                        }
                        DB::table('user_certification_eng')
                            ->updateOrInsert(
                                ['userid' => $leadid, 'exam' => 'ACT'],
                                [
                                    'overall_score' => $request->input('act_overall_score'),
                                    'math' => $request->input('act_math'),
                                    'reading' => $request->input('act_reading'),
                                    'writing' => $request->input('act_writing'),
                                    'science' => $request->input('act_science'),
                                    'english' => $request->input('act_english'),
                                    'expiry_date' => $act_expiry_date_db
                                ]
                            );
                    }

            //SAT
                    if(!empty($request->input('sat_overall_score'))){
                        $sat_expiry_date = $request->input('sat_expiry_date');
                        if ($sat_expiry_date) {
                            $sat_expiry_date_db = date("Y-m-d", strtotime(substr($sat_expiry_date, 6, 4) . "-" . substr($sat_expiry_date, 3, 2) . "-" . substr($sat_expiry_date, 0, 2)));
                        } else {
                            $sat_expiry_date_db = NULL;
                        }
                        DB::table('user_certification_eng')
                            ->updateOrInsert(
                                ['userid' => $leadid, 'exam' => 'SAT'],
                                [
                                    'overall_score' => $request->input('sat_overall_score'),
                                    'math' => $request->input('sat_math'),
                                    'reading' => $request->input('sat_reading'),
                                    'writing' => $request->input('sat_writing'),
                                    'essay' => $request->input('sat_essay'),
                                    'expiry_date' => $sat_expiry_date_db
                                ]
                            );
                    }


                if (isset($request->exam) && $request->exam != '') { 
                    $data = $request->all();
                    if ($data['exam']['gre']['expiry_date']) {
                        $gre_exp_dt = $data['exam']['gre']['expiry_date'];
                        $gre_exp_dt_db = date("Y-m-d", strtotime(substr($gre_exp_dt, 6, 4) . "-" . substr($gre_exp_dt, 3, 2) . "-" . substr($gre_exp_dt, 0, 2)));
                    } else {
                        $gre_exp_dt_db = NULL;
                    }
                    if ($data['exam']['gmat']['expiry_date']) {
                        $gmat_exp_dt = $data['exam']['gmat']['expiry_date'];
                        $gmat_exp_dt_db = date("Y-m-d", strtotime(substr($gmat_exp_dt, 6, 4) . "-" . substr($gmat_exp_dt, 3, 2) . "-" . substr($gmat_exp_dt, 0, 2)));
                    } else {
                        $gmat_exp_dt_db = NULL;
                    }
                    DB::table('user_gre_gmat')
                        ->updateOrInsert(
                            ['userid' => $leadid, 'exam' => 'GRE'],
                            [
                                'total_score' => $data['exam']['gre']['total_score'],
                                'verbal' => $data['exam']['gre']['verbal'],
                                'quantitative' => $data['exam']['gre']['quantitative'],
                                'analytical' => $data['exam']['gre']['analytical'],
                                'integrated' => $data['exam']['gre']['integrated'],
                                'expiry_date' => $gre_exp_dt_db
                            ]
                        );
            
                    DB::table('user_gre_gmat')
                        ->updateOrInsert(
                            ['userid' => $leadid, 'exam' => 'GMAT'],
                            [
                                'total_score' => $data['exam']['gmat']['total_score'],
                                'verbal' => $data['exam']['gmat']['verbal'],
                                'quantitative' => $data['exam']['gmat']['quantitative'],
                                'analytical' => $data['exam']['gmat']['analytical'],
                                'integrated' => $data['exam']['gmat']['integrated'],
                                'expiry_date' => $gmat_exp_dt_db
                            ]
                        );
                }

            }

            $lead = User::find($leadid);
            
            //Notify admin
            $msg_details = "New FormBuilder Form Submitted.<br /><br />Name: " . $first_name . ' ' . $last_name . "<br />email: " . $email . "<br />Mobile: " . $dialcode . ' ' . $mobile . "<br />Gender: " . $gender;

            $notify_emails = get_site_config('event_notification_email');
            if($notify_emails) {
                send_event_notification_email(explode(",", $notify_emails), "New FormBuilder Form Lead", $msg_details);
            } 

            //Email to lead
            if (get_site_config('lead_welcome_email_web2lead')) {
                //send welcome email
                \Log::debug("Lead: sending FormBuilder Lead generated mail to user");
                $mail_tpl = MailTemplates::find("LEAD_WELCOME_WEB2LEAD");
                if ($mail_tpl && $mail_tpl->status) {
                    $email_message = $mail_tpl->message;
                    $full_name = $first_name . ' ' . $last_name;
                    $email_message = str_ireplace("#sitename#", app_name(), $email_message);
                    $email_message = str_ireplace("#siteurl#", url(''), $email_message);
                    $email_message = str_ireplace("#first_name#", $first_name, $email_message);
                    $email_message = str_ireplace("#full_name#", $full_name, $email_message);
                    $email_message = str_ireplace("#email#", $email, $email_message);
                    $email_message = str_ireplace("#mobile#", $dialcode . ' ' . $mobile, $email_message);
                    try {
                        // $leaddetails = Lead::find($leadid);
                        $leaddetails = User::find($leadid);
                        //$leaddetails->notify(new UserAlert($mail_tpl->subject, $email_message));
                        user_notify($leaddetails, $mail_tpl->subject, $email_message);
                        \Log::debug("FormBuilder: mail sent to user- " . $email_message);
                        LeadActivity::create(['lead_id' => $leaddetails->id, 'date' => date("Y-m-d H:i:s"), 'detail' => "Email Sent: Subject:" . $mail_tpl->subject . "<br>Message:" . $email_message]);
                    } catch (\Exception $e) {
                        $message = $e->getMessage();
                        \Log::debug("Mail Error: (NEW FormBuilder LEAD) " . $message);
                    }
                }

                $sms_tpl = SMSTemplates::find("LEAD_WELCOME_WEB2LEAD");
                if ($sms_tpl && $sms_tpl->status) {
                    $sms_message = $sms_tpl->message;
                    $sms_message = str_ireplace("#sitename#", app_name(), $sms_message);
                    $sms_message = str_ireplace("#siteurl#", url(''), $sms_message);
                    $sms_message = str_ireplace("#first_name#", $request->get('first_name'), $sms_message);
                    $sms_message = str_ireplace("#full_name#", $request->get('first_name')." ".$request->get('last_name'), $sms_message);
                    $sms_message = str_ireplace("#email#", $request->get('email'), $sms_message);
                    $sms_message = str_ireplace("#password#", $request->get('password'), $sms_message);
                    try {
                        $leaddetails->notify(new UserAlert($sms_tpl->message, $sms_message));
                    } catch (\Exception $e) {
                        $message = $e->getMessage();
                        \Log::debug("Mail Error: (CONVERT LEAD)" . $message);
                    }
                }
            }
            ///////////

            return redirect()->to($redirect_url);
        }
        return redirect()->route('index');
    }

    public function validate_email_mobile(Request $request){
        
        $validator = Validator::make($request->all(), [
            'email' => 'email:filter,filter_unicode|nullable|sometimes|unique:users',
            'mobile' => ['nullable', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH'),'unique:users'],
        ]);
        if ($validator->fails()) {
            $data = [];
            $messages = $validator->errors();
            if ($messages->first('email')) {
                $data['email_err'] = $messages->first('email');
            }
            if ($messages->first('mobile')) {
                $data['mobile_err'] = $messages->first('mobile');
            }
            return json_encode($data);
        }
        return json_encode("Valid Email & Mobile");
    }

}
