<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Models\Auth\Posts;
use App\Models\Auth\Products;
use App\Models\Auth\ProductCategories;
use App\Models\Auth\Categories;
use App\Models\Auth\ProductImages;
use App\Models\Auth\CurrencyRate;
use App\Models\Auth\ProductDownloads;
use App\Models\Auth\UserShippingAddress;
use App\Models\Auth\Orders;
use App\Models\Auth\OrderItems;
use App\Models\Auth\PaymentGatewayTrans;
use App\Models\Auth\User;
use App\Models\Auth\Country;
use App\Models\Auth\Shipping;
use App\Models\Auth\Course;
use App\Models\Auth\OnlineCourse;
use App\Models\Auth\State;
use App\Models\Auth\City;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Log;
use Carbon\Carbon;

/**
 * 
 * Class ShopController.
 */
class ShopController extends Controller
{
  public function __construct()
  {
    $this->menu_details = array();
    //$main_menus = Posts::Select('id','title','menu_title','slug')->where('status', '=', 1)->where('show_in_main_menu', '=', 1)->where('module_type', '!=', 'home')->orderBy('order')->get();

    $main_menus = Posts::Select('id', 'title', 'menu_title', 'slug')
      ->where('status', '=', 1)
      ->where('show_in_main_menu', '=', 1)
      ->where(function ($query) {
        $query->Where('module_type', '<>', "home")
          ->orWhere('module_type', NULL);
      })
      ->orderBy('order')
      ->get();

    foreach ($main_menus as $main_menu) {
      $menu_title = $main_menu['menu_title'] != '' ? $main_menu['menu_title'] : $main_menu['title'];
      $this->menu_details[$menu_title] =  route('frontend.view-article', [$main_menu['slug']]);
    }
  }


  public function shop()
  {
    $categories = Categories::where('parent', '=', 0)->get();
    return view('frontend.shop', ['cms_page' => 1, 'main_menu_arr' => $this->menu_details, 'categories' => $categories]);
  }

  public function shop_products($slug)
  {
    $category = Categories::where('slug', '=', $slug)->first();
    $subcat = Categories::where('parent', '=', $category->id)->get();
    if (\Auth::user()) {
      $user_id = auth()->user()->id;
      $total_items = Products::join('product_categories', 'products.id', '=', 'product_categories.product_id')
        ->where('product_categories.category_id', '=', $category->id)->orWhere(function ($q) use ($subcat) {
          foreach ($subcat as $case) {
            $q->orWhere('category_id', $case->id);
          }
        })
        ->where('products.status', '=', 'enabled')
        ->get(['products.id', 'products.title', 'products.slug']);

      $prods = Products::join('product_categories', 'products.id', '=', 'product_categories.product_id')
        ->where('products.status', '=', 'enabled')
        ->where('product_categories.category_id', '=', $category->id)->orWhere(function ($q) use ($subcat) {
          foreach ($subcat as $case) {
            $q->orWhere('category_id', $case->id);
          }
        })
        ->paginate(6, ['products.id', 'products.title', 'products.slug', 'currency', 'price', 'offer_price']);
    } else {
      $total_items = Products::join('product_categories', 'products.id', '=', 'product_categories.product_id')
        ->where('product_categories.category_id', '=', $category->id)->orWhere(function ($q) use ($subcat) {
          foreach ($subcat as $case) {
            $q->orWhere('category_id', $case->id);
          }
        })
        ->where('products.status', '=', 'enabled')
        ->get(['products.id', 'products.title', 'products.slug']);

      $prods = Products::join('product_categories', 'products.id', '=', 'product_categories.product_id')
        ->where('product_categories.category_id', '=', $category->id)->orWhere(function ($q) use ($subcat) {
          foreach ($subcat as $case) {
            $q->orWhere('category_id', $case->id);
          }
        })
        ->where('products.status', '=', 'enabled')
        ->paginate(6, ['products.id', 'products.title', 'products.slug', 'currency', 'price', 'offer_price']);
    }
    $product_amounts = array();

    for ($i = 0; $i < count($prods); $i++) {
      $cur = $prods[$i]->currency;
      $price = $prods[$i]->price;
      $op = $prods[$i]->offer_price;
      $product_amounts[$i]['price'] = $price;
      $product_amounts[$i]['offer_price'] = $op;
      // $product_amounts[$i]['price'] = Helper::change_currency_gbp($cur, $price);
      // $product_amounts[$i]['offer_price'] = Helper::change_currency_gbp($cur, $op);
    }

    $imgs = array();
    for ($i = 0; $i < count($prods); $i++) {
      $imgs[] = ProductImages::where('product_id', '=', $prods[$i]->id)->where('is_default', '=', 1)->first();
    }
    $currency = array();
    for ($i = 0; $i < count($prods); $i++) {
      $currency[] = CurrencyRate::where('code', '=', $prods[$i]->currency)->first();
    }
    $cms_page = 1;
    $main_menu_arr = $this->menu_details;
    return view('frontend.shop-products', compact('cms_page', 'main_menu_arr', 'prods', 'imgs', 'total_items', 'currency', 'subcat', 'category', 'product_amounts'));
  }


  public function shop_product_details($slug)
  {
    $product_det = Products::where('slug', '=', $slug)->first();
    // $product_price = Helper::change_currency_gbp($product_det->currency, $product_det->price);
    // $product_offer_price = Helper::change_currency_gbp($product_det->currency, $product_det->offer_price);
    $product_price = $product_det->price;
    $product_offer_price = $product_det->offer_price;

    $img = ProductImages::where('product_id', '=', $product_det->id)->where('is_default', '=', 1)->first();

    $additionals = ProductImages::where('product_id', '=', $product_det->id)->where('is_default', '=', 0)->get();

    $currency = CurrencyRate::where('code', '=', $product_det->currency)->first();

    $categories = ProductCategories::where('product_id', '=', $product_det->id)->first();

    $cats = Categories::where('id', '=', $categories->category_id)->first();

    $seller = User::where('id', '=', $product_det->seller)->first();
    $cms_page = 1;
    $main_menu_arr = $this->menu_details;
    return view('frontend.shop-product-details', compact('cms_page', 'main_menu_arr', 'product_det', 'img', 'currency', 'additionals', 'cats', 'seller', 'product_price', 'product_offer_price'));
  }

  public function addToCart($id, $type = null)
  {
    if ($type == "coaching") {
      $product = Course::find($id);
      if (!$product) {
        abort(404);
      }
      $cart = session()->get('cart');
      if (!$cart) {
        $cart = [
          $id => [
            "product_id" => $product->id,
            "quantity" => 1,
            "type" => 'coaching',
            "shipping" => 0,
            "details" => '',
          ]
        ];
        session()->put('cart', $cart);
        //$url = "<a href=" . route('frontend.cart') . ">Go to Cart</a>";
        return redirect()->route('frontend.cart')->withFlashSuccess("Coaching course added to cart successfully!");
      } else {
        return redirect()->back()->withFlashDanger("Your cart has a item. Multiple items cannot be purchased together!");
      }
    } else if ($type != '' && $type == "online_course") {

      //type Online course
      $product = OnlineCourse::find($id);
      if (!$product) {
        abort(404);
      }
      $cart = session()->get('cart');
      if (!$cart) {
        $cart = [
          $id => [
            "product_id" => $product->id,
            "quantity" => 1,
            "type" => 'online_course',
            "shipping" => 0,
            "details" => '',
          ]
        ];
        session()->put('cart', $cart);
        //$url = "<a href=" . route('frontend.cart') . ">Go to Cart</a>";
        return redirect()->route('frontend.cart')->withFlashSuccess("Course added to cart successfully!");
      } else {
        return redirect()->back()->withFlashDanger("Your cart has a item. Multiple items cannot be purchased together!");
      }

    } else if ($type == "product") {

      //Type Product
      $product = Products::find($id);
      if (\Auth::user()) {
        $uid = \Auth::user()->id;
        if ($uid == $product->seller) {
          return redirect()->back()->withFlashDanger("You Can't Purchase Your Products!");
        }
      }

      if (!$product) {
        abort(404);
      }

      $cart = session()->get('cart');
      if (!$cart) {

        if ($product->type == "physical") {
          $cart = [
            $id => [
              "product_id" => $product->id,
              "quantity" => 1,
              "type" => $product->type,
              "shipping" => '',
              "details" => '',
            ]
          ];
          session()->put('cart', $cart);
        } else {
          $cart = [
            $id => [
              "product_id" => $product->id,
              "quantity" => 1,
              "type" => $product->type,
              "shipping" => 0,
              "details" => '',
            ]
          ];
          session()->put('cart', $cart);
        }
        //$url = "<a href=" . route('frontend.cart') . ">Go to Cart</a>";
        return redirect()->route('frontend.cart')->withFlashSuccess("Product added to cart successfully!");
      }

      if (isset($cart[$id])) {
        $cart[$id]['quantity']++;
        session()->put('cart', $cart);
        return redirect()->route('frontend.cart')->withFlashSuccess("Product quantity updated!");
      }

      $keys = array_keys($cart);
      $key = $keys[0];
      if (($cart[$key]['type'] == "physical" && $product->type == "physical") || ($cart[$key]['type'] == "digital" && $product->type == "digital")) {

        if ($product->type == "physical") {
          $cart[$id] = [
            "product_id" => $product->id,
            "quantity" => 1,
            "type" => $product->type,
            "shipping" => '',
            "details" => '',
          ];
        } else {
          $cart[$id] = [
            "product_id" => $product->id,
            "quantity" => 1,
            "type" => $product->type,
            "shipping" => 0,
            "details" => '',
          ];
        }
        session()->put('cart', $cart);
        //$url = "<a href=" . route('frontend.cart') . ">Go to Cart</a>";
        return redirect()->route('frontend.cart')->withFlashSuccess("Product added to cart successfully! <span class='float-right mr-4'>" . $url . "</span>");
      } else {
        return redirect()->back()->withFlashDanger("Different product types cannot be purchased together. Either checkout or remove the  existing product from the cart to purchase this product.");
      }
      //$url = "<a href=" . route('frontend.cart') . ">Go to Cart</a>";
      //return redirect()->back()->withFlashDanger("Product added to cart successfully!  <span class='float-right mr-4'>" . $url . "</span>");
    }
  }


  public function cart()
  {
    if (!empty(session('cart'))) {
      foreach (session('cart') as $id => $details) {
        //print_r($details);
        $nestedData['quantity'] = $details['quantity'];
        if ($details['type'] == 'physical' || $details['type'] == 'digital') {
          $nestedData['product_data'] = Products::where('id', '=', $id)->first();
        } else if ($details['type'] == 'coaching') {
          $nestedData['product_data'] = Course::where('id', '=', $id)->first();
        } else if ($details['type'] == 'online_course') {
          $nestedData['product_data'] = OnlineCourse::where('id', '=', $id)->first();
        }

        $data[] =  $nestedData;
      }

      //$cur = array();
      $toti = 0;
      $product_amount = array();
      for ($i = 0; $i < count($data); $i++) {
        //$curi = CurrencyRate::where('code','=',$data[$i]['product_data']->currency)->first();

        //$cur = $curi;
        if ($details['type'] == 'physical' || $details['type'] == 'digital') {
          $imgs[] = ProductImages::where('product_id', '=', $data[$i]['product_data']->id)->where('is_default', '=', 1)->first();

          $pri = $data[$i]['product_data']->price;
          $cu = $data[$i]['product_data']->currency;
          $op = $data[$i]['product_data']->offer_price;

          //  $product_amount[$i]['price'] = Helper::change_currency_gbp($cu,$pri);
          //  $product_amount[$i]['offer_price'] = Helper::change_currency_gbp($cu,$op);
          $product_amount[$i]['price'] = $pri;
          $product_amount[$i]['offer_price'] = $op;

          if ($product_amount[$i]['offer_price'] != 0) {
            $price = $product_amount[$i]['offer_price'];
          } else {
            $price = $product_amount[$i]['price'];
          }
          $total = $price * $data[$i]['quantity'];
          //\Log::debug("Product :".$data[$i]['product_data']->title." Price:".$total);
          $toti = $toti + $total;
        } else if ($details['type'] == 'coaching') {
          $imgs[] = Course::where('id', '=', $data[$i]['product_data']->id)->first(['image']);
          $pri = $data[$i]['product_data']->fees;
          $cu = config('app.currency');
          $op = $data[$i]['product_data']->offer_price;
          //  $product_amount[$i]['price'] = Helper::change_currency_gbp($cu,$pri);
          //  $product_amount[$i]['offer_price'] = Helper::change_currency_gbp($cu,$op);
          $product_amount[$i]['price'] = $pri;
          $product_amount[$i]['offer_price'] = $op;

          if ($product_amount[$i]['offer_price'] != 0) {
            $price = $product_amount[$i]['offer_price'];
          } else {
            $price = $product_amount[$i]['price'];
          }
          $total = $price * $data[$i]['quantity'];
          $toti = $toti + $total;
        } else if ($details['type'] == 'online_course') {

          $imgs[] = OnlineCourse::where('id', '=', $data[$i]['product_data']->id)->first(['image']);
          $pri = $data[$i]['product_data']->fees;
          $cu = config('app.currency');
          $op = $data[$i]['product_data']->offer_price;
          $product_amount[$i]['price'] = $pri;
          $product_amount[$i]['offer_price'] = $op;

          if ($product_amount[$i]['offer_price'] != 0) {
            $price = $product_amount[$i]['offer_price'];
          } else {
            $price = $product_amount[$i]['price'];
          }
          $total = $price * $data[$i]['quantity'];
          $toti = $toti + $total;
        }
      }
      $tax = 0;


      $cms_page = 1;
      $main_menu_arr = $this->menu_details;
      return view('frontend.cart', compact('cms_page', 'main_menu_arr', 'data', 'cu', 'toti', 'tax', 'imgs', 'product_amount'));
    } else {
      $cms_page = 1;
      $main_menu_arr = $this->menu_details;
      return view('frontend.cart', compact('cms_page', 'main_menu_arr'));
    }
  }

  public function removeFromCart($id)
  {
    if ($id) {
      $cart = session()->get('cart');
      if (isset($cart[$id])) {
        unset($cart[$id]);
        session()->put('cart', $cart);
      }
      return redirect()->back()->withFlashSuccess("Product removed successfully!");
    }
  }

  public function updateCart(Request $request)
  {
    if ($request->id && $request->quantity) {
      $cart = session()->get('cart');
      $cart[$request->id]["quantity"] = $request->quantity;
      session()->put('cart', $cart);
      session()->flash('success', 'Cart updated successfully');
    }
  }

  public function checkout(Request $request)
  {
    if (!empty(session('cart'))) {
      if (\Auth::user()) {
        $user_id = \Auth::user()->id;
        $userData = User::where('id', '=', $user_id)->first();
        $userShippingAddress = UserShippingAddress::where('user_id', '=', $user_id)->get();

        $country = Country::where('id', '=', $userData->country)->first();
        $state = State::where('id', '=', $userData->state)->first();
        $city = City::where('id', '=', $userData->city)->first();

        $countries = "";
        $dialcodes = "";
      } else {
        $userData = "";
        $country = "";
        $state = "";
        $city = "";
        $userShippingAddress = array();
        $countries = Country::get();
        $dialcodes = Country::get(['tel as code', 'title_en as name'])->sortBy('name');
      }

      $countries = Country::get(['id', 'title_en'])->sortBy('title_en');
      foreach (session('cart') as $id => $details) {
        $type = $details['type'];
        if ($type == 'physical' || $type == 'digital') {
          $nestedData['quantity'] = $details['quantity'];
          $nestedData['type'] = $details['type'];
          $nestedData['product_data'] = Products::where('id', '=', $id)->first();
        } else if ($type == 'coaching') {
          $nestedData['quantity'] = $details['quantity'];
          $nestedData['type'] = $details['type'];
          $nestedData['product_data'] = Course::where('id', '=', $id)->first();
        } else if ($type == 'online_course') {
          $nestedData['quantity'] = $details['quantity'];
          $nestedData['type'] = $details['type'];
          $nestedData['product_data'] = OnlineCourse::where('id', '=', $id)->first();
        } else {
          $nestedData['quantity'] = $details['quantity'];
          $nestedData['type'] = $details['type'];
          $nestedData['product_data'] = Products::where('id', '=', $id)->first();
        }

        $data[] =  $nestedData;
      }
      $toti = 0;
      $product_amount = array();
      for ($i = 0; $i < count($data); $i++) {
        if ($data[$i]['type'] == 'physical' ||  $data[$i]['type'] == 'digital') {
          $cu = $data[$i]['product_data']->currency;
          $pri = $data[$i]['product_data']->price;
          $op = $data[$i]['product_data']->offer_price;

          //  $product_amount[$i]['price'] = Helper::change_currency_gbp($cu,$pri);
          //  $product_amount[$i]['offer_price'] = Helper::change_currency_gbp($cu,$op);
          $product_amount[$i]['price'] = $pri;
          $product_amount[$i]['offer_price'] = $op;

          if ($product_amount[$i]['offer_price'] != 0) {
            $price = $product_amount[$i]['offer_price'];
          } else {
            $price = $product_amount[$i]['price'];
          }
          $total = $price * $data[$i]['quantity'];
          $toti = $toti + $total;
          $curi = CurrencyRate::where('code', '=', $data[$i]['product_data']->currency)->first();

          $cur[] = $curi;
          $imgs[] = ProductImages::where('product_id', '=', $data[$i]['product_data']->id)->where('is_default', '=', 1)->first();
        } else if ($data[$i]['type'] == 'coaching') {
          $cu = config('app.currency');
          $pri = $data[$i]['product_data']->fees;
          $op = $data[$i]['product_data']->offer_price;

          $product_amount[$i]['price'] = $pri;
          $product_amount[$i]['offer_price'] = $op;

          if ($product_amount[$i]['offer_price'] != 0) {
            $price = $product_amount[$i]['offer_price'];
          } else {
            $price = $product_amount[$i]['price'];
          }
          $total = $price * $data[$i]['quantity'];
          $toti = $toti + $total;
          $curi = CurrencyRate::where('code', '=', $data[$i]['product_data']->currency)->first();

          $cur[] = $curi;
          $imgs[] = Course::where('id', '=', $data[$i]['product_data']->id)->first(['image']);
        } else if ($data[$i]['type'] == 'online_course') {
          $cu = config('app.currency');
          $pri = $data[$i]['product_data']->fees;
          $op = $data[$i]['product_data']->offer_price;

          $product_amount[$i]['price'] = $pri;
          $product_amount[$i]['offer_price'] = $op;

          if ($product_amount[$i]['offer_price'] != 0) {
            $price = $product_amount[$i]['offer_price'];
          } else {
            $price = $product_amount[$i]['price'];
          }
          $total = $price * $data[$i]['quantity'];
          $toti = $toti + $total;
          $curi = CurrencyRate::where('code', '=', $data[$i]['product_data']->currency)->first();

          $cur[] = $curi;
          $imgs[] = OnlineCourse::where('id', '=', $data[$i]['product_data']->id)->first(['image']);
        }
      }

      $cities = array();
      $states = array();
      $couns = array();

      for ($i = 0; $i < count($userShippingAddress); $i++) {
        $cities[] = City::where('id', '=', $userShippingAddress[$i]->city)->first();
        $states[] = State::where('id', '=', $userShippingAddress[$i]->state)->first();
        $couns[] = Country::where('id', '=', $userShippingAddress[$i]->country)->first();
      }

      $tax = 0;
      $notes = "";
      $notes = $request->order_notes;

      $cms_page = 1;
      $main_menu_arr = $this->menu_details;
      return view('frontend.checkout', compact('cms_page', 'main_menu_arr', 'notes', 'data', 'userData', 'country', 'state', 'city', 'countries', 'toti', 'cur', 'tax', 'userShippingAddress', 'cities', 'states', 'couns', 'type', 'dialcodes'));
    } else {
      return redirect('/');
    }
  }


  public function getShippingCost(Request $request)
  {
    if (!empty(session('cart'))) {
      $cart = session()->get('cart');
      $buyer_country =  $request->country_id;
      if (isset($request->state_id) && $request->state_id != '') {
        $buyer_state =  $request->state_id;
      } else {
        $buyer_state = 0;
      }
      $ship = 0;
      $not_shipable = 1;
      $arr = array();

      foreach (session('cart') as $key => $cartItem) {
        $product = Products::where('id', '=', $key)->first();
        $seller_id = $product->seller;

        if ($buyer_state == 0) {
          $shippingData = Shipping::join('zone_configs', 'zone_configs.id', '=', 'shipping_configs.zone_id')
            ->where('shipping_configs.seller_id', $seller_id)
            ->where('country_id', $buyer_country)
            ->where('zone_configs.state_id', 0)
            ->first(['flat_rate_value', 'currency', 'free_from']);
        } else {
          $shippingData = Shipping::join('zone_configs', 'zone_configs.id', '=', 'shipping_configs.zone_id')
            ->where('shipping_configs.seller_id', $seller_id)
            ->where('zone_configs.country_id', $buyer_country)
            ->where('zone_configs.state_id', $buyer_state)
            ->first(['flat_rate_value', 'currency', 'free_from']);

          if (!$shippingData) {
            $shippingData = Shipping::join('zone_configs', 'zone_configs.id', '=', 'shipping_configs.zone_id')
              ->where('shipping_configs.seller_id', $seller_id)
              ->where('zone_configs.country_id', $buyer_country)
              ->where('zone_configs.state_id', 0)
              ->first(['flat_rate_value', 'currency', 'free_from']);
          }
        }
        if (isset($shippingData)) {
          // $ship+= Helper::change_currency_gbp($shippingData->currency,$shippingData->flat_rate_value);
          $ship += $shippingData->flat_rate_value;

          //  $cart[$cartItem['product_id']]["shipping"] = Helper::change_currency_gbp($shippingData->currency,$shippingData->flat_rate_value);
          $cart[$cartItem['product_id']]["shipping"] = $shippingData->flat_rate_value;
          session()->put('cart', $cart);

          $not_shipable = 1;
          $free_from = $shippingData->free_from;
          array_push($arr, ['id' => $cartItem['product_id'], 'shipable' => $not_shipable, 'free_from' => $free_from, 'crt' => $cart]);
        } else {
          $ship = 0;
          $not_shipable = 0;
          array_push($arr, ['id' => $cartItem['product_id'], 'shipable' => $not_shipable]);
          $cart[$cartItem['product_id']]["shipping"] = 0;
          session()->put('cart', $cart);
        }
      }
      return response()->json(['total_ship' => $ship, 'shipable' => $not_shipable, 'arr' => $arr]);
    }
  }


  public function place_order(Request $request)
  {

    if ($request->type == "yes") {
      if ($request->payment_type == "stripe") {
        $user_id = \Auth::user()->id;
        $re = $request->address_id;
        $users_det = User::where('id', '=', $user_id)->first();
//Invoice payment
        if ($request->product_type == "invoice") {
            $PaymentGatewayTrans = PaymentGatewayTrans::create([
              'user_id' =>  auth()->user()->id,
              'payer_email' =>  auth()->user()->email,
              'gateway'  => "stripe",
              'currency' => $request->currency,
              'amount' => $request->total_amount,
              'status' => "pending",
              'trans_detail' => "Invoice Payment"
            ]);
            $fee = $request->total_amount * 100;
            $mode = "payment";
            $data = ['user_id' => auth()->user()->id, 'name' => $users_det->name, 'country' => $users_det->country, 'state' => $users_det->state, 'city' => $users_det->city, 'email' => $users_det->email, 'fee' => $fee, 'mode' => $mode, 'itemname' => "Invoice Payment", 'currency' => $request->currency, 'booking_id' => $request->invoice_id, 'ref_id' => $PaymentGatewayTrans->id, 'qty' => 1, 'from' => 'invoice_payment'];
            return redirect()->route('frontend.stripe.get', $data);
        }
//Invoice payment
        do {
          $oder_num = mt_rand(10000000, 99999999);

          $order_det = Orders::get();

          if (count($order_det) > 0) {
            for ($i = 0; $i < count($order_det); $i++) {
              if ($order_det[$i]->order_num == $oder_num) {
                $check_order_num = "yes";
                break;
              } else {
                $check_order_num = "";
              }
            }
          } else {
            $check_order_num = "";
          }
        } while ($check_order_num == "yes");

        $cart_total = $request->cart_total;
        Log::debug("Cart Total is :" . $cart_total);

        $base = $request->total_amount / $request->currency_rate;
        $cart = session()->get('cart');
        // $order = new Orders;
        // $order->user_id = $user_id;
        // $order->order_num = $oder_num;
        // $order->cart_total = $cart_total;
        // $order->tax = $request->tax;
        // $order->order_total = $request->total_amount;
        // $order->currency = $request->currency;
        // $order->order_total_base = $base;
        // $order->notes = $request->notes;
        // $order->status = "pending";
        if ($request->product_type == "physical") {
          $shipping = UserShippingAddress::select('address', 'zip_code', 'country', 'state', 'city', 'phone')->where('id', $request->address_id)->get();

          $order = new Orders;
          $order->user_id = $user_id;
          $order->create_date = Carbon::now();
          $order->shipping_to = $request->shipping_to;
          $order->total = $request->total_amount;
          //   echo $request->payment_type;
          //   exit();
          $order->total_base = $request->total_amount;
          $order->payment_type = $request->payment_type;
          $order->shipping_address = $shipping[0]->address;
          $order->shipping_zip = $shipping[0]->zip_code;
          $order->shipping_country = $shipping[0]->country;
          $order->shipping_state = $shipping[0]->state;
          $order->shipping_city = $shipping[0]->city;
          $order->shipping_phone = $shipping[0]->phone;
          $order->currency = $request->currency;
          Log::debug("Executed Query is :" . $order);
        } else {
          $order = new Orders;
          $order->user_id = $user_id;
          $order->create_date = Carbon::now();
          $order->order_type = $request->product_type;
          $order->shipping_to = $request->shipping_to;
          $order->total = $request->total_amount;
          $order->total_base = $request->total_amount;
          $order->payment_type = $request->payment_type;
          $order->currency = $request->currency;
          $order->status = "pending";
        }

        if ($order->save()) {
          Log::debug(DB::enableQueryLog());
          $subtotal = 0;
          $tax = 0;
          $shipping = 0;

          $admin_products = array();
          $seller_products = array();
          foreach (session('cart') as $key => $cartItem) {
            if ($cartItem['type'] == 'physical' ||  $cartItem['type'] == 'digital') {
              $product = Products::where('id', '=', $key)->first();
              if ($product->offer_price != 0) {
                $price =  $product->offer_price;
              } else {
                $price =  $product->price;
              }
            } else if ($cartItem['type'] == 'coaching') {
              $product = Course::where('id', '=', $key)->first();
              if ($product->offer_price != 0) {
                $price =  $product->offer_price;
              } else {
                $price =  $product->fees;
              }
            } else if ($cartItem['type'] == 'online_course') {
              $product = OnlineCourse::where('id', '=', $key)->first();
              if ($product->offer_price != 0) {
                $price =  $product->offer_price;
              } else {
                $price =  $product->fees;
              }
            }

            $order_detail = new OrderItems;
            $order_detail->order_id  = $order->id;
            $order_detail->seller_id = $product->seller;
            if ($cartItem['type'] == 'physical' ||  $cartItem['type'] == 'digital') {
              $order_detail->product_id = $product->id;
            } else if ($cartItem['type'] == 'coaching') {
              $order_detail->coaching_id = $product->id;
            } else if ($cartItem['type'] == 'online_course') {
              $order_detail->online_course_id = $product->id;
            }
            $order_detail->qty = $cartItem['quantity'];
            $order_detail->price = $price * $cartItem['quantity'];
            $order_detail->price_base = $price * $cartItem['quantity'];
            $order_detail->currency = $request->currency;
            $order_detail->status = "pending";
            $order_detail->details = $cartItem['details'];
            $order_detail->shipping_cost = $cartItem['shipping'];
            $order_detail->save();
          }

          $PaymentGatewayTrans = PaymentGatewayTrans::create([
            'user_id' =>  auth()->user()->id,
            'payer_email' =>  auth()->user()->email,
            'gateway'  => "stripe",
            'currency' => $request->currency,
            'amount' => $request->total_amount,
            'status' => "pending",
            'trans_detail' => "Product Purchase"
          ]);
          $fee = $request->total_amount * 100;
          $mode = "payment";
          $data = ['user_id' => auth()->user()->id, 'name' => $users_det->name, 'country' => $users_det->country, 'state' => $users_det->state, 'city' => $users_det->city, 'email' => $users_det->email, 'fee' => $fee, 'mode' => $mode, 'itemname' => $product->title, 'currency' => $request->currency, 'booking_id' => $order->id, 'ref_id' => $PaymentGatewayTrans->id, 'qty' => $cartItem['quantity'], 'from' => 'product_purchase'];

          session()->forget('cart');
          return redirect()->route('frontend.stripe.get', $data);

          $order->save();
        }
      } elseif ($request->payment_type == "paypal") {

        $user_id = \Auth::user()->id;
        $re = $request->address_id;

        $users_det = User::where('id', '=', $user_id)->first();
//Invoice payment
        if ($request->product_type == "invoice") {
            $PaymentGatewayTrans = PaymentGatewayTrans::create([
              'user_id' =>  auth()->user()->id,
              'payer_email' =>  auth()->user()->email,
              'gateway'  => "paypal",
              'currency' => $request->currency,
              'amount' => $request->total_amount,
              'status' => "pending",
              'trans_detail' => "Invoice Payment"
            ]);
            $fee = $request->total_amount;
            $mode = "payment";
            $data = ['user_id' => auth()->user()->id, 'name' => $users_det->name, 'country' => $users_det->country, 'state' => $users_det->state, 'city' => $users_det->city, 'email' => $users_det->email, 'fee' => $fee, 'mode' => $mode, 'itemname' => "Invoice Payment", 'currency' => $request->currency, 'booking_id' => $request->invoice_id, 'ref_id' => $PaymentGatewayTrans->id, 'qty' => 1, 'from' => 'invoice_payment'];
            return redirect()->route('frontend.make.payment', $data);
        }
//Invoice payment
        //do {
        //  $oder_num = mt_rand(10000000, 99999999);

        //   $order_det = Orders::get();
        //   if (count($order_det) > 0) {
        //     for ($i = 0; $i < count($order_det); $i++) {
        //       if ($order_det[$i]->order_num == $oder_num) {
        //         $check_order_num = "yes";
        //         break;
        //       } else {
        //         $check_order_num = "";
        //       }
        //     }
        //   } else {
        //     $check_order_num = "";
        //   }
        // } while ($check_order_num == "yes");

        $cart_total = $request->cart_total;
        Log::debug("Cart Total is :" . $cart_total);

        $base = $request->total_amount / $request->currency_rate;
        $cart = session()->get('cart');
        $order = new Orders;
        $order->user_id = $user_id;
        $order->create_date = Carbon::now();
        $order->order_type = $request->product_type;
        $order->shipping_to = $request->shipping_to;
        $order->total = $request->total_amount;
        $order->total_base = $request->total_amount;
        $order->payment_type = $request->payment_type;
        $order->currency = $request->currency;
        $order->status = "pending";


        if ($order->save()) {
          Log::debug(DB::enableQueryLog());
          $subtotal = 0;
          $tax = 0;
          $shipping = 0;

          $admin_products = array();
          $seller_products = array();
          foreach (session('cart') as $key => $cartItem) {
            if ($cartItem['type'] == 'physical' ||  $cartItem['type'] == 'digital') {
              $product = Products::where('id', '=', $key)->first();
              if ($product->offer_price != 0) {
                $price =  $product->offer_price;
              } else {
                $price =  $product->price;
              }
            } else if ($cartItem['type'] == 'coaching') {
              $product = Course::where('id', '=', $key)->first();
              if ($product->offer_price != 0) {
                $price =  $product->offer_price;
              } else {
                $price =  $product->fees;
              }
            } else if ($cartItem['type'] == 'online_course') {
              $product = OnlineCourse::where('id', '=', $key)->first();
              if ($product->offer_price != 0) {
                $price =  $product->offer_price;
              } else {
                $price =  $product->fees;
              }
            }

            $order_detail = new OrderItems;
            $order_detail->order_id  = $order->id;
            $order_detail->seller_id = $product->seller;
            if ($cartItem['type'] == 'physical' ||  $cartItem['type'] == 'digital') {
              $order_detail->product_id = $product->id;
            } else if ($cartItem['type'] == 'coaching') {
              $order_detail->coaching_id = $product->id;
            } else if ($cartItem['type'] == 'online_course') {
              $order_detail->online_course_id = $product->id;
            }
            $order_detail->qty = $cartItem['quantity'];
            $order_detail->price = $price * $cartItem['quantity'];
            $order_detail->price_base = $price * $cartItem['quantity'];
            $order_detail->currency = $request->currency;
            $order_detail->status = "pending";
            $order_detail->details = $cartItem['details'];
            $order_detail->shipping_cost = $cartItem['shipping'];
            $order_detail->save();
          }

          $PaymentGatewayTrans = PaymentGatewayTrans::create([
            'user_id' =>  auth()->user()->id,
            'payer_email' =>  auth()->user()->email,
            'gateway'  => "paypal",
            'currency' => $request->currency,
            'amount' => $request->total_amount,
            'status' => "pending",
            'trans_detail' => "Product Purchase"
          ]);
          $fee = $request->total_amount;
          $mode = "payment";
          $data = ['user_id' => auth()->user()->id, 'name' => $users_det->name, 'country' => $users_det->country, 'state' => $users_det->state, 'city' => $users_det->city, 'email' => $users_det->email, 'fee' => $fee, 'mode' => $mode, 'itemname' => $product->title, 'currency' => $request->currency, 'booking_id' => $order->id, 'ref_id' => $PaymentGatewayTrans->id, 'qty' => $cartItem['quantity'], 'from' => 'product_purchase'];

          session()->forget('cart');
          return redirect()->route('frontend.make.payment', $data);

          $order->save();
        }
      } else {
        //Bank Transfer
        $user_id = \Auth::user()->id;
        $re = $request->address_id;
        $users_det = User::where('id', '=', $user_id)->first();
        do {
          $oder_num = mt_rand(10000000, 99999999);
          $order_det = Orders::get();
          if (count($order_det) > 0) {
            for ($i = 0; $i < count($order_det); $i++) {
              if ($order_det[$i]->order_num == $oder_num) {
                $check_order_num = "yes";
                break;
              } else {
                $check_order_num = "";
              }
            }
          } else {
            $check_order_num = "";
          }
        } while ($check_order_num == "yes");

        $cart_total = $request->cart_total;
        Log::debug("Cart Total is :" . $cart_total);

        $base = $request->total_amount;
        $cart = session()->get('cart');
        // $order = new Orders;
        // $order->user_id = $user_id;
        // $order->order_num = $oder_num;
        // $order->cart_total = $cart_total;
        // $order->tax = $request->tax;
        // $order->order_total = $request->total_amount;
        // $order->currency = config('app.currency');
        // $order->order_total_base = $base;
        // $order->notes = $request->notes;
        // $order->status = "pending";
        if ($request->product_type == "physical") {
          $shipping = UserShippingAddress::select('address', 'zip_code', 'country', 'state', 'city', 'phone')->where('id', $request->address_id)->get();
          $order = new Orders;
          $order->user_id = $user_id;
          $order->create_date = Carbon::now();
          $order->shipping_to = $request->shipping_to;
          $order->total = $request->total_amount;
          $order->total_base = $request->total_amount;
          $order->payment_type = $request->payment_type;
          $order->shipping_address = $shipping[0]->address;
          $order->shipping_zip = $shipping[0]->zip_code;
          $order->shipping_country = $shipping[0]->country;
          $order->shipping_state = $shipping[0]->state;
          $order->shipping_city = $shipping[0]->city;
          $order->shipping_phone = $shipping[0]->phone;
          $order->currency = $request->currency;
        } else {
          $order = new Orders;
          $order->user_id = $user_id;
          $order->create_date = Carbon::now();
          $order->order_type = $request->product_type;
          $order->shipping_to = $request->shipping_to;
          $order->total = $request->total_amount;
          $order->total_base = $request->total_amount;
          $order->payment_type = $request->payment_type;
          $order->currency = $request->currency;
          $order->status = "pending";
        }
        Log::debug("Executed Query is :" . $order);
        if ($order->save()) {
          Log::debug(DB::enableQueryLog());
          $subtotal = 0;
          $tax = 0;
          $shipping = 0;

          $admin_products = array();
          $seller_products = array();
          foreach (session('cart') as $key => $cartItem) {
            if ($cartItem['type'] == 'physical' ||  $cartItem['type'] == 'digital') {
              $product = Products::where('id', '=', $key)->first();
              if ($product->offer_price != 0) {
                $price =  $product->offer_price;
              } else {
                $price =  $product->price;
              }
            } else if ($cartItem['type'] == 'coaching') {
              $product = Course::where('id', '=', $key)->first();
              if ($product->offer_price != 0) {
                $price =  $product->offer_price;
              } else {
                $price =  $product->fees;
              }
            } else if ($cartItem['type'] == 'online_course') {
              $product = OnlineCourse::where('id', '=', $key)->first();
              if ($product->offer_price != 0) {
                $price =  $product->offer_price;
              } else {
                $price =  $product->fees;
              }
            }
            $order_detail = new OrderItems;
            $order_detail->order_id  = $order->id;
            $order_detail->seller_id = $product->seller;
            if ($cartItem['type'] == 'physical' ||  $cartItem['type'] == 'digital') {
              $order_detail->product_id = $product->id;
            } else if ($cartItem['type'] == 'coaching') {
              $order_detail->coaching_id = $product->id;
            } else if ($cartItem['type'] == 'online_course') {
              $order_detail->online_course_id = $product->id;
            }
            $order_detail->qty = $cartItem['quantity'];
            $order_detail->price = $price * $cartItem['quantity'];
            $order_detail->price_base = $price * $cartItem['quantity'];
            $order_detail->currency = config('app.currency');
            $order_detail->status = "pending";
            $order_detail->details = $cartItem['details'];
            $order_detail->shipping_cost = $cartItem['shipping'];
            $order_detail->save();
          }
          $PaymentGatewayTrans = PaymentGatewayTrans::create([
            'user_id' =>  auth()->user()->id,
            'payer_email' =>  auth()->user()->email,
            'gateway'  => "Bank",
            'currency' => config('app.currency'),
            'amount' => $request->total_amount,
            'status' => "pending",
            'trans_detail' => "Product Purchase"
          ]);

          session()->forget('cart');

          //$link = route("frontend.home") . "?order=" . $order->id . "&msg=bank_success";
          //return redirect($link);
          //$order->save();
          return redirect()->route("frontend.home")->withFlashSuccess("Your Order #".$order->id." is created successfully! <br>
          Please send the funds to the following account & share the transaction details to us.<br>
          <b>".get_site_config('payment_bank_details')."</b>");

        }
      }
    } else {
      //New user
      $request->validate([
        'first_name' => 'required|string|max:191',
        'last_name'  => 'required|string|max:191',
        'email'      => 'required|string|email|max:191|unique:users',
        'password'   => 'required|string|min:6',
        'mobile' => 'required|numeric|min:10',
        'country' => 'required',
        'address' => 'required',
        'state' => 'required',
        'city' => 'required',
        // 'dialcode' => 'required',
        'zipcode' => 'required|min:3'
      ]);

      $user = User::create([
        'first_name' => $request->first_name,
        'last_name'  => $request->last_name,
        'email'      => $request->email,
        'password'   => Hash::make($request->password),
        'mobile' => $request->mobile,
        'country' => $request->country,
        'address_1' => $request->address,
        'state' => $request->state,
        'city' => $request->city,
        'post_code' => $request->zipcode,
        // 'dialcode' => $request->dialcode,
      ]);

      $user->save();
      \Auth::login($user);
      UserShippingAddress::create([
        'user_id' => $user->id,
        'address_type' => "Home",
        'address' => trim($request->input('address')) . ', ' . trim($request->input('city')) . ', ' . trim($request->input('state')),
        'zip_code' => trim($request->input('zipcode')),
        'country' => trim($request->input('country')),
        'state' => trim($request->input('state')),
        'city' => trim($request->input('city')),
        'phone' => trim($request->input('mobile')),
      ]);

      $order = new Orders;
      $order->user_id = $user->id;
      $order->create_date = Carbon::now();
      $order->shipping_to = trim($request->input('firstname')) . ' ' . trim($request->input('lastname'));
      $order->total = $request->total_amount;
      $order->order_type = $request->product_type;
      $order->total_base = $request->total_amount;
      $order->payment_type = $request->payment_type;
      $order->shipping_address = trim($request->input('address'));
      $order->shipping_zip = trim($request->input('zipcode'));
      $order->shipping_country = trim($request->input('country'));
      $order->shipping_state = trim($request->input('state'));
      $order->shipping_city = trim($request->input('city'));
      $order->shipping_phone = trim($request->input('mobile'));
      $order->currency = $request->currency;

      if ($order->save()) {
        $subtotal = 0;
        $tax = 0;
        $shipping = 0;

        $admin_products = array();
        $seller_products = array();
        foreach (session('cart') as $key => $cartItem) {
          if ($cartItem['type'] == 'physical' ||  $cartItem['type'] == 'digital') {
            $product = Products::where('id', '=', $key)->first();
            if ($product->offer_price != 0) {
              $price =  $product->offer_price;
            } else {
              $price =  $product->price;
            }
          } else if ($cartItem['type'] == 'coaching') {
            $product = Course::where('id', '=', $key)->first();
            if ($product->offer_price != 0) {
              $price =  $product->offer_price;
            } else {
              $price =  $product->fees;
            }
          } else if ($cartItem['type'] == 'online_course') {
            $product = OnlineCourse::where('id', '=', $key)->first();
            if ($product->offer_price != 0) {
              $price =  $product->offer_price;
            } else {
              $price =  $product->fees;
            }
          }
          $order_detail = new OrderItems;
          $order_detail->order_id  = $order->id;
          $order_detail->seller_id = $product->seller;
          if ($cartItem['type'] == 'physical' ||  $cartItem['type'] == 'digital') {
            $order_detail->product_id = $product->id;
          } else if ($cartItem['type'] == 'coaching') {
            $order_detail->coaching_id = $product->id;
          } else if ($cartItem['type'] == 'online_course') {
            $order_detail->online_course_id = $product->id;
          }
          $order_detail->qty = $cartItem['quantity'];
          $order_detail->price = $price * $cartItem['quantity'];
          $order_detail->price_base = $price * $cartItem['quantity'];
          $order_detail->currency = $request->currency;
          $order_detail->details = $cartItem['details'];
          $order_detail->status = "pending";
          $order_detail->shipping_cost = $cartItem['shipping'];
          $order_detail->save();
        }
        if ($request->payment_type == "stripe") {
          $PaymentGatewayTrans = PaymentGatewayTrans::create([
            'user_id' =>  auth()->user()->id,
            'payer_email' =>  auth()->user()->email,
            'gateway'  => "stripe",
            'currency' => $request->currency,
            'amount' => $request->total_amount,
            'status' => "pending",
            'trans_detail' => "Product Purchase"
          ]);

          $name = $request->first_name . ' ' . $request->last_name;
          $fee = $request->total_amount * 100;
          $mode = "payment";
          // echo $order->id;exit;
          $data = ['user_id' => auth()->user()->id, 'name' => $name, 'country' => $request->country, 'state' => $request->state, 'city' => $request->city, 'email' => $request->email, 'fee' => $fee, 'currency' => $request->currency, 'mode' => $mode, 'qty' => $cartItem['quantity'], 'itemname' => $product->title, 'booking_id' => $order->id, 'ref_id' => $PaymentGatewayTrans->id, 'from' => 'product_purchase'];
          session()->forget('cart');
          return redirect()->route('frontend.stripe.get', $data);
          //$order->save();
        } elseif ($request->payment_type == "paypal") {
          $PaymentGatewayTrans = PaymentGatewayTrans::create([
            'user_id' =>  auth()->user()->id,
            'payer_email' =>  auth()->user()->email,
            'gateway'  => "paypal",
            'currency' => $request->currency,
            'amount' => $request->total_amount,
            'status' => "pending",
            'trans_detail' => "Product Purchase"
          ]);

          $name = $request->first_name . ' ' . $request->last_name;
          $fee = $request->total_amount * 100;
          $mode = "payment";
          // echo $order->id;exit;
          $data = ['user_id' => auth()->user()->id, 'name' => $name, 'country' => $request->country, 'state' => $request->state, 'city' => $request->city, 'email' => $request->email, 'fee' => $fee, 'currency' => $request->currency, 'mode' => $mode, 'qty' => $cartItem['quantity'], 'itemname' => $product->title, 'booking_id' => $order->id, 'ref_id' => $PaymentGatewayTrans->id, 'from' => 'product_purchase'];
          session()->forget('cart');
          return redirect()->route('frontend.make.payment', $data);
          //$order->save();
        } else {
          $PaymentGatewayTrans = PaymentGatewayTrans::create([
            'user_id' =>  auth()->user()->id,
            'payer_email' =>  auth()->user()->email,
            'gateway'  => "bank",
            'currency' => $request->currency,
            'amount' => $request->total_amount,
            'status' => "pending",
            'trans_detail' => "Product Purchase"
          ]);
          session()->forget('cart');

          return redirect()->route("frontend.home")->withFlashSuccess("Your Order #".$order->id." is created successfully! <br>
          Please send the funds to the following account & share the transaction details to us.<br>
          <b>".config('app.bank_details')."</b>");
          //$order->save();
        }
      }
    }
  }
}
