<?php

namespace App\Http\Controllers\Frontend\Trainer;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Repositories\Frontend\Auth\UserRepository;
use App\Recipients\AdminRecipient;
use App\Notifications\Frontend\AdminAlert;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;
use App\Mail\MailSend;
use App\Models\Auth\User;
use App\Models\Auth\ManageDetails;
//use App\Models\Auth\ChatGroup;
use App\Models\Auth\TrainerStudentAttendance;
use App\Models\MailTemplates;
use Illuminate\Support\Facades\Mail;

class TrainerController extends Controller
{

  public function index()
  {
    return view('frontend.trainer.trainerdashboard');
  }

  public function classes()
  {
    $userid = \Auth::user()->id;
    $batch_details = DB::table('batch')
      ->select('batch.start_date', 'batch.days', 'courses.title', 'branch.branch_name', 'batch.start_hour', 'batch.start_min', 'batch.end_hour', 'batch.end_min', 'batch.id', 'batch.status', 'meeting_rooms.zoom_id')
      ->join('courses', 'courses.id', '=', 'batch.course')
      ->join('branch', 'branch.id', '=', 'batch.branch')
      ->leftJoin('meeting_rooms', 'batch.meeting_room', '=', 'meeting_rooms.room_name')
      ->where('batch.trainer', $userid)
      ->get();
    return view('frontend.trainer.trainermyclasses', ['batch_details' => $batch_details]);
  }




  /*to download student exam answers
     *param passed - $essay_exam_id
    */
  public function download_exam_answers($student_exam_id)
  {
    $userid = \Auth::user()->id;
    if ($student_exam_id > 0) {
      $storage_path = storage_path() . '/app/public/';
      $documetObj = DB::table('student_exam_answers')
        ->where('student_exam_id', '=', $student_exam_id)
        ->where('order', '=', '999999')
        ->where('qa_id', '=', '0')
        ->get();

      $studentObj = DB::table('student_exams')
        ->select('u.first_name', 'u.id')
        ->join('users AS u', 'u.id', '=', 'student_exams.student_id')
        ->where('student_exams.id', '=', $student_exam_id)
        ->first();
      $student_name = strtolower(str_replace(' ', '_', $studentObj->first_name));

      $zip_file_name = 'exam_answers_' . $student_name . '_' . $studentObj->id . '_' . $student_exam_id . '_' . date('Ymdhi') . '.zip';

      $zip = new \ZipArchive();

      if ($zip->open($zip_file_name, \ZipArchive::CREATE) !== TRUE) {
        exit("Cannot Create Zip File $zip_file_name");
      }
      $zip->addEmptyDir("exams");

      foreach ($documetObj as $eachObj) {
        $filepath = $storage_path . $eachObj->documents;
        $zip->addFile($filepath, $eachObj->documents);
      }

      $zip->close();
      header('Content-Type: application/zip');
      header('Content-Disposition: attachment; filename="' . basename($zip_file_name) . '"');
      header('Content-Length: ' . filesize($zip_file_name));

      flush();
      readfile($zip_file_name);
      unlink($zip_file_name);
    } else {
      exit("Error on file download!");
    }
  }


  /*Handling student answers - updating answer is correct or not
     *param passed -  $student_id
    */
  public function student_correct_answers(Request $request, $type, $question_type, $student_id, $student_exam_id)
  {
    $userid = \Auth::user()->id;
    $correct_answer_chks = $request->get('is_correct_answer_chk');
    foreach ($correct_answer_chks as $exam_answer_id => $existing_value_rcvd) {
      is_array($existing_value_rcvd) ? $existing_value = $existing_value_rcvd[0] : $existing_value = $existing_value_rcvd;
      $correct_answer = $request->get('is_correct_answer_' . $exam_answer_id);

      if (isset($correct_answer) && $correct_answer == $existing_value) {
        //answer is passed(1) and trainer didn't update the value
      } else if (isset($correct_answer) && $correct_answer != $existing_value) {
        //answer is passed(1) and trainer has updated the value to true
        DB::table('student_exam_answers')->where('id', $exam_answer_id)->update(['correct' => 1, 'corrected_by' => $userid]);
      } else if (!isset($correct_answer) && $existing_value != 1) {
        //answer is passed(0 or NULL) and trainer didn't update the value
      } else if (!isset($correct_answer) && $existing_value == 1) {
        //answer is passed(0 or NULL) and trainer has updated the value to false
        DB::table('student_exam_answers')->where('id', $exam_answer_id)->update(['correct' => 0, 'corrected_by' => $userid]);
      }
    }

    //----------------- update exam results data------------------
    $exam_answer_details = DB::table('student_exam_answers')
      ->select(DB::raw('count(qa_id) as total_questions, count(case when correct = 1 then 1 else NULL end) as correct_answer_cnt'))
      ->where('student_exam_id', $student_exam_id)->first();

    $objective_answer = DB::table('student_exam_answers')
      ->select(DB::raw('count(id) as total_correct'))
      ->where('correct', '1')
      ->where('question_type', 'objective')
      ->where('question_model', 'obj_essay')
      ->where('student_exam_id', $student_exam_id)->first();

    $essay_answer = DB::table('student_exam_answers')
      ->select(DB::raw('count(id) as total_correct'))
      ->where('correct', '1')
      ->where('question_type', 'essay')
      ->where('question_model', 'obj_essay')
      ->where('student_exam_id', $student_exam_id)->first();

    $comprehension_answer = DB::table('student_exam_answers')
      ->select(DB::raw('count(id) as total_correct'))
      ->where('correct', '1')
      ->where('question_model', 'comprehension')
      ->where('student_exam_id', $student_exam_id)->first();

    $comprehension_qstn_details = DB::table('student_exam_answers')
      ->select(DB::raw('count(qa_id) as total_questions'))
      ->where('question_model', 'comprehension')
      ->where('student_exam_id', $student_exam_id)->first();


    $exam_details = DB::table('exam')
      ->select('exam.*', 'student_exams.attempt', 'student_exams.exam_started_at')
      ->join('student_exams', 'exam.id', '=', 'student_exams.exam_id')
      ->where('student_exams.id', $student_exam_id)
      ->where('student_exams.completed', '1')
      ->first();


    //------ getting marks for listening/reading/writing and update-------------------
    // Only Objective type question - data taking-----------
    $objective_ans_details = DB::table('q_a')
      ->select('student_exam_answers.id', 'student_exam_answers.qa_id', 'q_a.category')
      ->join('student_exam_answers', 'student_exam_answers.qa_id', '=', 'q_a.id')
      ->where('student_exam_answers.correct', '1')
      ->where('student_exam_answers.question_type', 'objective')
      ->where('student_exam_answers.question_model', 'obj_essay')
      ->where('student_exam_answers.student_exam_id', $student_exam_id)->get();

    $listening_correct = $reading_correct = $writing_correct = 0;
    foreach ($objective_ans_details as $objective_anwrs) {
      if ($objective_anwrs->category == 'listening') {
        $listening_correct++;
      } else if ($objective_anwrs->category == 'reading') {
        $reading_correct++;
      } else if ($objective_anwrs->category == 'writing') {
        $writing_correct++;
      }
    }
    //---------------------------------------------------------------------------------


    $total_marks = $exam_details->total_marks;
    $objective_mark_per_question = $exam_details->objective_question_mark;
    $essay_mark_per_question = $exam_details->essay_question_mark;
    $comprehension_mark_per_passage = $exam_details->comprehension_question_mark;
    $total_comprehension_passage = $exam_details->comprehension_question_count;
    $total_comprehension_question = $comprehension_qstn_details->total_questions;
    if ($total_comprehension_question >= 1)
      $comprehension_mark_per_question = ($comprehension_mark_per_passage * $total_comprehension_passage) / $total_comprehension_question;
    else
      $comprehension_mark_per_question = 0;



    $correct_answer_cnt = $exam_answer_details->correct_answer_cnt > 0 ?  $exam_answer_details->correct_answer_cnt : 0;
    $questions_count = $exam_answer_details->total_questions;
    $percentage = ($correct_answer_cnt / $questions_count) * 100;


    $objective_correct_cnt = $objective_answer->total_correct > 0 ?  $objective_answer->total_correct : 0;
    $essay_correct_cnt = $essay_answer->total_correct > 0 ?  $essay_answer->total_correct : 0;
    $comprehension_correct_cnt = $comprehension_answer->total_correct > 0 ?  $comprehension_answer->total_correct : 0;

    $objective_score = $objective_correct_cnt * $objective_mark_per_question;
    $essay_score = $essay_correct_cnt * $essay_mark_per_question;
    $comprehension_score = $comprehension_correct_cnt * $comprehension_mark_per_question;

    $listening_marks = $listening_correct * $objective_mark_per_question;
    $reading_marks = $reading_correct * $objective_mark_per_question;
    $writing_marks = $writing_correct * $objective_mark_per_question;

    $score = $objective_score + $essay_score + $comprehension_score;
    $pass_percentage = config('site_configs.exam.pass_percentage');
    $percentage >= $pass_percentage ? $passed = 1 : $passed = 0;


    $student_exam_result_details = DB::table('student_exam_result')
      ->select('id')
      ->where('exam_id', $exam_details->id)
      ->where('student_id', $student_id)
      ->where('attempt', $exam_details->attempt)
      ->first();
    if (isset($student_exam_result_details) && isset($student_exam_result_details->id) && $student_exam_result_details->id > 0) {
      DB::table('student_exam_result')->where('id', $student_exam_result_details->id)
        ->update(['score' => $score, 'passed' => $passed, 'attempt_date' => $exam_details->exam_started_at, 'total_exam_marks' => $total_marks, 'objective_marks' => $objective_score, 'essay_marks' => $essay_score, 'comprehension_marks' => $comprehension_score, 'listening_marks' => $listening_marks, 'reading_marks' => $reading_marks, 'writing_marks' => $writing_marks]);
    } else {
      $inserted_result_id = DB::table('student_exam_result')
        ->insertGetId(['student_id' => $student_id, 'exam_id' => $exam_details->id, 'attempt' => $exam_details->attempt, 'score' => $score, 'passed' => $passed, 'attempt_date' => $exam_details->exam_started_at, 'total_exam_marks' => $total_marks, 'objective_marks' => $objective_score, 'essay_marks' => $essay_score, 'comprehension_marks' => $comprehension_score, 'listening_marks' => $listening_marks, 'reading_marks' => $reading_marks, 'writing_marks' => $writing_marks]);
    }
    //-----------------------------------------------------------

    return redirect()->route('frontend.trainer.students_attended', [$type, $question_type, $exam_details->id])->withFlashSuccess('Correct answers updated successfully!');

    //return redirect()->route('frontend.trainer.student_exams_answers', [$type, $question_type, $student_id, $student_exam_id])->withFlashSuccess('Correct answers updated successfully!');
  }





  /*Handling student exam answers
     *param passed - $type, $question_type, $student_id, $student_exam_id
    */
  public function student_exams_answers($type, $question_type, $student_id, $student_exam_id)
  {
    $userid = \Auth::user()->id;
    if ($type == 'online') {
      $answersObj = DB::table('student_exams')
        ->select('student_exams.attempt', 'student_exam_answers.*', 'q_a.course_id', 'q_a.question_model', 'q_a.comprehension_id', 'q_a.question_type', 'q_a.category', 'q_a.question', 'q_a.question_file', 'q_a.question_file_type', 'q_a.option1', 'q_a.option2', 'q_a.option3', 'q_a.option4', 'q_a.option5', 'q_a.option6', 'q_a.option7', 'q_a.option8', 'q_a.answers as correct_answer', 'q_a.answer_type', 'users.first_name as trainer_name')
        ->join('student_exam_answers', 'student_exam_answers.student_exam_id', '=', 'student_exams.id')
        ->join('q_a', 'q_a.id', '=', 'student_exam_answers.qa_id')
        ->leftJoin('users', 'users.id', '=', 'student_exam_answers.corrected_by')
        ->where('student_exams.student_id', '=', $student_id)
        ->where('student_exams.id', '=', $student_exam_id)
        ->orderBy('student_exam_answers.order', 'ASC')
        ->get();

      $chkDownloads = DB::table('student_exam_answers')
        ->select(DB::raw('count(id) as total_downloads'))
        ->where('student_exam_id', $student_exam_id)
        ->where('qa_id', 0)
        ->where('documents', '<>', '')
        ->first();




      if ($chkDownloads->total_downloads > 0) {
        $has_downloads = 1;
      } else {
        $has_downloads = 0;
      }
    } else if ($type == 'offline') {
    }


    $suExamObj = DB::table('student_exams')
      ->select('exam_id')
      ->where('id', '=', $student_exam_id)
      ->first();

    return view('frontend.trainer.answers_students', ['type' => $type, 'question_type' => $question_type, 'answersObj' => $answersObj, 'student_exam_id' => $student_exam_id, 'student_id' => $student_id, 'exam_id' => $suExamObj->exam_id, 'has_downloads' => $has_downloads]);
  }



  /*Handling exam realted
   *param passed - $type, $term, $batch_id
  */
  public function exams_attended($type, $term, $exam_id)
  {
    $userid = \Auth::user()->id;

    if ($type == 'online') {
      $examObj = DB::table('exam')
        ->where('id', '=', $exam_id)
        ->where('exam_date', '<=', date('Y-m-d H:i:s'))
        ->first();

      if (isset($examObj) && $examObj->id > 0) {
        $resultsObj = DB::table('student_exams AS se')
          ->leftjoin('users AS u', 'u.id', '=', 'se.student_id')
          ->leftJoin('student_exam_result', function ($join) {
            $join->on('student_exam_result.exam_id', '=', 'se.exam_id');
            $join->on('student_exam_result.attempt', '=', 'se.attempt');
            $join->on('student_exam_result.student_id', '=', 'se.student_id');
          })
          ->where('se.exam_id', '=', $examObj->id)
          ->where('se.completed', '=', 1)
          ->select('se.*', 'u.first_name', 'u.middle_name', 'u.last_name', 'u.email', 'u.mobile', 'student_exam_result.score', 'student_exam_result.passed')
          ->get();
      } else {
        $resultsObj = '';
      }
    } else if ($type == 'offline') {
      // this is a offline written test using paper/pencil
    }
    return view('frontend.trainer.exams_students', ['type' => $type, 'term' => $term, 'examObj' => $examObj, 'resultsObj' => $resultsObj]);
  }




  /*Handling exam realted
   *param passed - $batch_id
  */
  public function exams($batch_id)
  {
    $userid = \Auth::user()->id;
    $online_exam_details = DB::table('batch')
      ->select('batch.id as batch_id', 'exam.total_marks', 'exam.batch_id as online_exam_batch_id', 'exam.type as online_exam_type', 'exam.exam_date as exam_date', 'exam.total_questions as question_count', 'exam.duration as exam_duration', 'exam.id as exam_id')
      ->join('exam', 'exam.batch_id', '=', 'batch.id')
      ->where('batch.id', $batch_id)
      ->where('batch.trainer', $userid)
      ->get();

    $offline_exam_details = array();
    //$offline_exam_details = DB::table('batch')
    //        ->select('batch.id as batch_id','batch.oral_mid_term_exam_marks as mid_term_marks','batch.oral_end_term_marks as end_term_marks','exam_offline.batch_id as offline_batch_id','exam_offline.type as offline_exam_type','exam_offline.exam_date as exam_date')
    //        ->join('exam_offline', 'exam_offline.batch_id', '=', 'batch.id')
    //        ->where('batch.id', $batch_id)
    //        ->where('batch.trainer', $userid)
    //        ->get();

    $exam_details =  $online_exam_details->merge($offline_exam_details)->sortByDesc('exam_date');

    //echo "<pre>";
    //print_r($exam_details);
    //exit();

    return view('frontend.trainer.trainerexams', ['exam_details' => $exam_details]);
  }



  public function manage($id)
  {
    $userid = \Auth::user()->id;
    $today = date("Y-m-d");
    $batchid = $id;
    $manages = DB::table('batch')
      ->select('courses.title', 'branch.branch_name', 'batch.id')
      ->join('courses', 'courses.id', '=', 'batch.course')
      ->join('branch', 'branch.id', '=', 'batch.branch')
      ->where('batch.id', $id)
      ->get();

    $student = DB::table('batch')
      ->select('users.first_name', 'users.id')
      ->join('courses', 'courses.id', '=', 'batch.course')
      ->join('branch', 'branch.id', '=', 'batch.branch')
      ->join('batch_students', 'batch_students.batch', '=', 'batch.id')
      ->join('users', 'users.id', '=', 'batch_students.student')
      ->where('batch.id', $id)
      ->get();

    $duration = DB::table('batch')
      ->select('batch.start_date', 'batch.end_date', 'trainer_attendance.date', 'trainer_attendance.topics', 'batch.totalduration', 'trainer_attendance.duration')
      ->join('trainer_attendance', 'trainer_attendance.batch_id', '=', 'batch.id')
      ->where('trainer_attendance.batch_id', $id)
      ->orderBy('trainer_attendance.date', "DESC")
      ->get();

    $calculate = DB::table('trainer_attendance')->select('duration')->where('trainer_id', $userid)->where('batch_id', $batchid)->sum('duration');

    $courseduration = DB::table('batch')->select('totalduration')->where('trainer', $userid)->where('id', $batchid)->first();

    if ($courseduration->totalduration == 0) {
      $finalcalc = 0;
    } else {
      $finalcalc = (($calculate / $courseduration->totalduration) * 100);
      if ($finalcalc < 1) {
        $finalcalc = round($finalcalc, 1);
      } elseif ($finalcalc > 100) {
        $finalcalc = 100;
      } else {
        $finalcalc = floor($finalcalc);
      }
    }

    $user = DB::table('trainer_attendance')->where('trainer_id', $userid)->where('batch_id', $batchid)->where('date', $today)->get();

    return view('frontend.trainer.trainerattendance', ['batchinfo' => $manages, 'student' => $student, 'user' => $user, 'duration' => $duration, 'finalcalc' => $finalcalc]);
  }

  public function messages($id)
  {
    $userid = \Auth::user()->id;

    $messages = DB::table('batch')
      ->select('courses.title', 'branch.branch_name', 'batch.id', 'batch.days', 'batch.start_hour', 'batch.start_min', 'batch.end_hour', 'end_min')
      ->join('courses', 'courses.id', '=', 'batch.course')
      ->join('branch', 'branch.id', '=', 'batch.branch')
      ->where('batch.id', $id)
      ->where('trainer', $userid)
      ->get();

    if (count($messages)) {

      $student = DB::table('batch')
        ->select('users.first_name', 'users.id')
        ->join('courses', 'courses.id', '=', 'batch.course')
        ->join('branch', 'branch.id', '=', 'batch.branch')
        ->join('batch_students', 'batch_students.batch', '=', 'batch.id')
        ->join('users', 'users.id', '=', 'batch_students.student')
        ->where('batch.id', $id)
        ->get();
      //return view('frontend.trainer.trainerattendance', ['batchinfo' => $manages,'student'=>$student]);       
      return view('frontend.trainerchat', ['messages' => $messages, 'student' => $student, 'userid' => $userid]);
    } else {
      return abort(404);
    }
  }

  public function store(Request $request, $id)
  {
    $student = $request->get('student');
    $today = date("Y-m-d");
    $userid = \Auth::user()->id;
    $batchid = $id;
    $user = DB::table('trainer_attendance')->where('trainer_id', $userid)->where('batch_id', $batchid)->where('date', $today)->first();
    $trainer_student_attendance = DB::table('trainer_student_attendance')->where('trainer_id', $userid)->where('batch_id', $batchid)->where('date', $today)->first();

    //  $trainerstudent = DB::table('trainer_student_attendance')->where('trainer_id', $userid)->where('batch_id', $batchid)->first(); 

    if (!$trainer_student_attendance) {
      foreach ($student as $students) {
        //  $verified=0;
        $userdata = DB::table('users')->where('id', $students)->first();
        $student_attendance = new TrainerStudentAttendance([
          'student_id' => $students,
          'batch_id' => $id,
          'trainer_id' => $userid,
          'student_name' => $userdata->first_name,
          'date' => $today
        ]);
        $student_attendance->save();
      }
    }
    if (!$user) {
      $details = new ManageDetails([
        'trainer_id' => $userid,
        'batch_id' => $id,
        'date' => $today,
        'topics' => $request->get('topics'),
        'duration' => $request->get('duration')
      ]);
      $details->save();
      $today = date("Y-m-d");
      $sendsms = DB::table('batch')
        ->select('users.id', 'users.first_name')
        ->join('batch_students', 'batch_students.batch', '=', 'batch.id')
        ->join('users', 'users.id', '=', 'batch_students.student')
        ->leftjoin('trainer_student_attendance', 'trainer_student_attendance.student_id', '=', 'batch_students.student')
        ->where('batch.id', $id)
        ->Where('trainer_student_attendance.date', $today)
        ->distinct()
        ->get();

      foreach ($sendsms as $finalsms) {
        $data[] = $finalsms->id;
      }
      $final = DB::table('batch_students')
        ->select('users.id', 'users.first_name', 'users.mobile')
        ->join('users', 'users.id', '=', 'batch_students.student')
        ->where('batch', $id)
        ->whereNotIn('student', $data)
        ->distinct()
        ->get();

      foreach ($final as $a_batch_student) {
        $a_student = User::find($a_batch_student->id);

        $notify_sms = get_sms_template('ATTENDANCE_ABSENT');
        if ($notify_sms && $notify_sms->status) {
            $notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
            $notify_sms->message = str_replace("#siteurl#", url('/'), $notify_sms->message);
            $notify_sms->message = str_replace("#first_name#", $a_student->first_name, $notify_sms->message);
            $notify_sms->message = str_replace("#full_name#", $a_student->full_name, $notify_sms->message);
            $a_student->sms($notify_sms->message,$notify_sms->template_id);
        }

        $email_message = "Dear " . $a_student->first_name . ",<br /><br />You have missed today's session, kindly be regular to be on par with syllabus. See you in the next session!";
        try{
        //Mail::to($a_student->email)->send(new MailSend("You Missed Todays Class", $email_message));
        user_notify($a_student->email,"You Missed Todays Class", $email_message);
        }catch (\Exception $e) {
            $message = $e->getMessage();
            \Log::debug("Mail Error: (Attendance - You Missed Todays Class) ".$message);   
        }
      }

      $yesterday = date("Y-m-d", strtotime('-1 days'));
      $today = date("Y-m-d");
      $userid = \Auth::user()->id;

      $test = DB::table('trainer_student_attendance')->select('student_id')
        ->where('batch_id', $id)
        ->where('trainer_id', $userid)
        ->where('trainer_student_attendance.date', $yesterday)
        ->orwhere('trainer_student_attendance.date', $today)
        ->distinct()
        ->get();


      foreach ($test as $user) {
        $datas[] = $user->student_id;
      }

      $finals = DB::table('batch_students')
        ->select('users.id', 'users.first_name', 'users.mobile', 'trainer_student_attendance.date')
        ->join('users', 'users.id', '=', 'batch_students.student')
        ->join('trainer_student_attendance', 'trainer_student_attendance.student_id', '=', 'users.id')
        ->where('batch', $id)
        ->where('trainer_student_attendance.date', $yesterday)
        ->whereNotIn('student', $datas)
        ->distinct()
        ->get();

      $msg_details = "";
      foreach ($finals as $mail) {
        $msg_details .= "<br />" . $mail->first_name . " (Mob: " . $mail->mobile . ")";
      }

      if ($msg_details) {
        $email_message = "Dear Admin,<br><br>Following Students are absent For 2 Consecutive Days:<br>" . $msg_details;
        $recipient = new AdminRecipient();
        try{
          //$recipient->notify(new AdminAlert("Absent Student List", $email_message));
          user_notify($recipient,"Absent Student List", $email_message);
        }catch (\Exception $e) {
            $message = $e->getMessage();
            \Log::debug("Mail Error: (Absent Student List) ".$message);   
        }
      }

      return redirect()->route('frontend.trainer.attendance', $id)->withFlashSuccess('Today\'s class details submitted successfully!');
    }
    if ($user) {
      return redirect()->route('frontend.trainer.attendance', $id)->withFlashDanger('Today\'s class details already exists!');
    }
  }
}
