<?php

namespace App\Http\Controllers\Frontend\User;
use App\Http\Controllers\Controller;
use App\Models\Auth\Country;
use App\Models\Auth\UserShippingAddress;
use Illuminate\Http\Request;
/**
 * Class AccountController.
 */
class AccountController extends Controller
{
    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        return view('frontend.user.account');
    }

    public function add_new_address()
    {
        $items = Country::pluck('title_en', 'id');
        return view('frontend.user.add-shipping-address', compact('items'));
    }

    public function store_shipping_address(Request $request)
    {

            $this->validate($request, [
                'address_type' => 'required',
                'address' => 'required',
                'country' => 'required',
                'state' => 'required',
                'city' => 'required',
                'zip_code' => 'required',
                'mobile' => 'required',
            ]);
            // create new Shipping Address
            $shippingAddr = new UserShippingAddress;
            $shippingAddr->user_id = auth()->user()->id;
            $shippingAddr->address_type = $request->address_type;
            $shippingAddr->address = $request->address;
            $shippingAddr->zip_code = $request->zip_code;
            $shippingAddr->country = $request->country;
            $shippingAddr->state = $request->state;
            $shippingAddr->city = $request->city;
            $shippingAddr->phone = $request->mobile;
            $shippingAddr->save();

            return redirect()->route('frontend.checkout')->withFlashSuccess(__('strings.frontend.general.shipping_address_added'));
    }
}
