<?php

namespace App\Http\Controllers\Frontend\User;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Repositories\Frontend\Auth\UserRepository;
use App\Recipients\AdminRecipient;
use App\Models\Auth\ApplicationActivity;
use App\Models\Auth\User;
use App\Models\Auth\UniversityApplication;
use App\Models\Auth\ApplicationMessages;
use App\Notifications\Frontend\AdminAlert;
use App\Mail\MailSend;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use App\Models\Auth\ApplicationDocRequest;
use App\Models\UserActivity;

/**
 * Class ApplicationsController.
 */
class ApplicationsController extends Controller
{

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {

        $data = array();
        $userid = \Auth::user()->id;

        $data = array();
        $rows = DB::table('university_application')->where('userid', $userid)->orderBy('id', 'desc')->get();
        if ($rows) {
            foreach ($rows as $row) {

                // if ($row->type == 'visa') {
                //     $visa_pref = DB::table("visa_preference")->where('id', $row->visa_pref_id)->first();
                //     $details = get_visa_service_type_name($visa_pref->service_type)."<br />".get_visa_letter_type_name($visa_pref->letter_type);
                //     $status = $row->visa_status;
                // } elseif ($row->type == 'abroad_job') {
                //     $abroad_job_pref = DB::table("abroad_job_preference")->where('id', $row->abroad_job_pref_id)->first();
                //     $details = "";
                //     $status = $row->abroad_job_status;
                // } else {

                    $intake_str = "";
                    $intake = $row->intake;
                    if ($intake) {
                        $str = date("Y") . "-" . $intake . "-01";
                        $intake_str = date("M", strtotime($str));
                    }
                    $details = "<span class='text-sub'>University:</span> ".$row->university."<br /><span class='text-sub'>Course:</span> ".$row->course."<br /><span class='text-sub'>Intake:</span> ".$intake_str;
                    $status = $row->status;
                // }
                //$status = "";
                // if ($row->offer_letter_ts) {
                //     $status = "Offer Letter Given on " . $row->offer_letter_ts;
                // } elseif ($row->result != 'none') {
                //     $status = "Application Result: " . ucfirst($row->result);
                // } elseif ($row->application_submitted == 'yes') {
                //     $status = "Application Submitted on: " . $row->application_submitted_ts;
                // } elseif ($row->application_fee_paid != 'none') {
                //     $status = "Application Fees Paid: " . ucfirst($row->application_fee_paid);
                //     if ($row->application_fee_paid == 'yes')
                //         $status .= " On " . $row->application_fee_paid_ts;
                // } elseif ($row->application_mode != 'none') {
                //     $status = "Application Mode: " . ucfirst($row->application_mode);
                // } elseif ($row->admission_criteria_met != 'none') {
                //     $status = "Admission Criteria: " . ucfirst($row->admission_criteria_met);
                // } elseif ($row->doc_ready != 'none') {
                //     $status = "Doc ready: " . ucfirst($row->doc_ready);
                // } else {
                //     $status = "None";
                // }

                array_push($data, array('id' => $row->id, 'country' => $row->country, 'details' => $details, 'open_date' => $row->application_open_date, 'close_date' => $row->application_close_date, 'status' => $status, 'appl_id' => $row->appl_id));
            }
        }
        return view('frontend.user.applications', ['data' => $data]);
    }

    public function detail($id)
    {
        $userid = \Auth::user()->id;

        $row = DB::table('university_application')->where('userid', $userid)->where('id', $id)->first();
        $msgs = DB::table('application_messages')->where('application_id', $id)->orderBy('id', 'ASC')->get();
        if ($row) {

            $visa_pref = "";
            // if($row->type == 'visa') {
            //     $visa_pref = DB::table('visa_preference')->where('id', $row->visa_pref_id)->first();
            // }
            $abroad_job_pref = "";
            // if($row->type == 'abroad_job') {
            //     $abroad_job_pref = DB::table('abroad_job_preference')->where('id', $row->abroad_job_pref_id)->first();
            // }

            $appActivity = ApplicationActivity::where('application_id',$id)->orderBy('created_at','asc')->get();
            $course_id = $uni_id = "";
            if($row->course_pref_id) {
                $course_pref = DB::table('course_preference')->where('id', $row->course_pref_id)->first(['course_id','university_id']);
                if($course_pref){
                    $course_id = $course_pref->course_id;
                    $uni_id = $course_pref->university_id;
                }
            }

            $applicationDocRequest = DB::table('application_doc_request')->where('application_id', $id)->orderBy('id', 'DESC')->get();
            
            return view('frontend.user.application_detail', [
                'applicationDocRequest' => $applicationDocRequest, 
                'course_id'=>$course_id, 
                'uni_id'=>$uni_id, 
                'course' => $row->course, 
                'university' => $row->university, 
                'country' => $row->country, 
                'data' => $row, 
                'visa_pref' => $visa_pref, 
                'abroad_job_pref' => $abroad_job_pref, 
                'app_messages' => $msgs, 
                'appActivity' => $appActivity
            ]);

        } else {
            return redirect()->route('frontend.user.applications')->withFlashDanger("Application ID Not Found");
        }
    }

    public function sendMessage(Request $request)
    {
        $request->validate(
            [
                'message' => 'required',
                'attachment.*' => 'mimes:jpg,jpeg,docx,pdf,doc,png|max:8000'
            ],
            [
                'attachment.*.mimes' => 'Only pdf, doc, docx, jpeg, png files are allowed',
                'image_file.*.max' => 'Sorry! Maximum allowed file size is 8MB',
            ]
        );

        $application = UniversityApplication::find($request->app_id);

        $data = $request->all();
        $msg = new ApplicationMessages;
        $msg->application_id = $request->app_id;
        $msg->user_id = \Auth::user()->id;
        $msg->message = $request->message;

        $user_activity = new UserActivity;
        $user_activity->type = "message_received_from_student";
        $user_activity->user_id = \Auth::user()->id;
        $user_activity->title = "Message Sent by Student";
        $user_activity->detail = "Application #".$application->appl_id.": Student:" . $request->message;
        $user_activity->attachment = "";

        if ($request->file('attachment')) {

            $cnt = 1;
            foreach ($request->file('attachment') as $file) {
                $filename = $file->getClientOriginalName();
                $filename = str_replace(" ", "-", $filename);
                $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
                if (strlen($filename) > 20) {
                    $filename = substr($filename, 0, 20);
                }
                $filename .= Str::random(10);
                $path = $file->storeAs('/app_messages', $filename . "." . $file->getClientOriginalExtension(), 'public');
                if ($cnt == 1) {
                    $msg->attachment_1 = $path;
                    $user_activity->attachment .= $path;
                } elseif ($cnt == 2) {
                    $msg->attachment_2 = $path;
                    $user_activity->attachment .= "," . $path;
                } elseif ($cnt == 3) {
                    $msg->attachment_3 = $path;
                    $user_activity->attachment .= "," . $path;
                } elseif ($cnt == 4) {
                    $msg->attachment_4 = $path;
                    $user_activity->attachment .= "," . $path;
                }
                $cnt++;
            }
        }
        $msg->save();
        $user_activity->save();

        //Notify Staff
        $subject = get_user_full_name_by_id($msg->user_id) . ": New Appl#".$application->appl_id." Message";
        $email_message = "Hi, <br><br>New Application Message by student.<br>Application: #".$application->appl_id."<br> Name: ".get_user_full_name_by_id($msg->user_id)."<br>Message: ".$msg->message;
        send_mail_notification($msg->user_id,$application->id,"UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT",$subject,$email_message);

        // Send Push App Notification
        $subject = "";
        $message = "New Appl Message by "._label('backend_student')." <strong>" . get_user_full_name_by_id(\Auth::user()->id) ."</strong> Appl #". $application->appl_id.", Message: ".$msg->message;

        send_in_app_notification(
            $application->userid, 
            $application->appl_id, 
            "UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT", 
            $subject, 
            $message,
            "university"
        );

        // $row = DB::table('users')->where('id', $msg->user_id)->first();
        // try{
        //     if($row->assigned_to){
        //         // User::find($row->assigned_to);
        //         $staff = DB::table('users')->where('id', $row->assigned_to)->first();
        //         Mail::to($staff->email)->send(new MailSend("New Application Message by student", $email_message));
        //     }else{
        //         //No need to send to admin
        //         //$recipient = new AdminRecipient();
        //         //$recipient->notify(new AdminAlert("New Application Message by student", $email_message));
        //     }         
        // }catch (\Exception $e) {
        //     $message = $e->getMessage();
        //     \Log::debug("Mail Error: (New Message by User) ".$message);   
        // }
       
        return redirect()->back()->withFlashSuccess(__('strings.frontend.student.message_sent_successfully'));
    }

    public function add(Request $request)
    {
        //Student adding a application isn not allowed now
        
        /*$data = $request->all();
        $user = \Auth::user();
        $userid = $user->id;

        $email_message = "Dear Admin, <br /><br />User: " . $user->name . " (Mob: " . $user->mobile . ") has added a COURSE to APPLICATIONS LIST.<br /><br />Details:";

        $course = $data['course'];
        $country = $data['country'];
        $university = $data['university'];
        $year = $data['year'];
        $intake = $data['intake'];

        $email_message .= "<br /><br />COUNTRY: " . $country . "<br />COURSE: " . $course . "<br />UNIVERSITY: " . $university . "<br />YEAR: " . $year . "<br />INTAKE MONTH: " . $intake;

        DB::table('university_application')
            ->insert(
                [
                    'userid' => $userid,
                    'created_at' => date('Y-m-d H:i:s'),
                    'university' => $university,
                    'course' => $course,
                    'country' => $country,
                    'year' => $year,
                    'intake' => $intake
                ]
            );

        $recipient = new AdminRecipient();
        try{
          $recipient->notify(new AdminAlert("Course Added by User", $email_message));
        }catch (\Exception $e) {
            $message = $e->getMessage();
            \Log::debug("Mail Error: (Course Added by User) ".$message);   
        }
        //Notify Staff
        $notify_ids = env('EVENT_NOTIFY_EMAILS');
        $tos = explode(",", $notify_ids);
        foreach ($tos as $to) {
            try{
                Mail::to($to)->send(new MailSend("Course Added by User", $email_message));
            }catch (\Exception $e) {
                $message = $e->getMessage();
                \Log::debug("Mail Error: (Course Added by User) ".$message);   
            }
        }

        return redirect()->route('frontend.user.applications')->withFlashSuccess("Course added Successfully & notified Support Team");
        */
    }

    public function uploadRequestedDocument(Request $request){
        $request->validate([
            // 'file_upload' => 'required|mimes:pdf,doc,docx,jpeg',
            'file_upload' => 'required',
        ]); 

        $file_upload = $request->file_upload;
        $allFiles = "";
        foreach($file_upload as $file){
            $filename = $file->getClientOriginalName();
            $filename = str_replace(" ", "-", $filename);
            $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
            if (strlen($filename) > 30) {
                $filename = substr($filename, 0, 30);
            }
            $filename .= Str::random(10);

            $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
            $filename = $filename.".".$file->getClientOriginalExtension();
            $allFiles .= $filename."|";
        }

        $application_doc_request = ApplicationDocRequest::where('id', $request->doc_request_id)->first();
        $application_doc_request->files = $allFiles;
        $application_doc_request->uploaded_at = now();
        $application_doc_request->save();

        $email_message = $allFiles;
        $application = UniversityApplication::where("id", $request->application_id)->first();

        // Send Push App Notification
        $message = "Requested Document (".$application_doc_request->title.") are uploaded by "._label('backend_student').": " . get_user_full_name_by_id(\Auth::user()->id) . "(" . \Auth::user()->id . ")";
        $email_message = "Hi, <br><br>Application #".$application->appl_id.", Requested Document (".$application_doc_request->title.") are uploaded by "._label('backend_student').": " . get_user_full_name_by_id(\Auth::user()->id);
        $subject = "Application #".$application->appl_id.", Requested Document are uploaded by "._label('backend_student').": " . get_user_full_name_by_id(\Auth::user()->id);

        //Notify Staff
        $email_message .= "<br><b>Application Details:</b><br>University Application #".$application->appl_id ."<br>Course: ".$application->course . "<br>University: " . $application->university . "<br>Country: " .$application->country;
        $email_message .= "<br>"._label('backend_student').": " . get_user_full_name_by_id(\Auth::user()->id) . "(" . \Auth::user()->id . ")";
        send_mail_notification(\Auth::user()->id,$application->id,"UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT",$subject,$email_message);

        $message .= "<br>Application #: ".$application->appl_id.
        "<br>"._label('backend_student').": " . get_user_full_name_by_id(\Auth::user()->id) . "(" . \Auth::user()->id . ")";
        $subject = "";
        send_in_app_notification(
            \Auth::user()->id, 
            $application->appl_id, 
            "UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT", 
            $subject, 
            $message,
            "university"
        );

        return redirect()->route('frontend.user.applications.detail', $request->application_id)->withFlashSuccess("Requested Document uploaded successfully");
    }
}
