<?php

namespace App\Http\Controllers\Frontend\User;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Repositories\Frontend\Auth\UserRepository;
use App\Recipients\AdminRecipient;
use App\Notifications\Frontend\AdminAlert;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;
use App\Http\Requests\Frontend\User\CertificateRequest;
use App\Models\Auth\Course;
use App\Models\Auth\Branch;

class CertificateController extends Controller {

    public function index() {
        $user = \Auth::user();
        $userid = $user->id;
        $courses = Course::orderBy('title')->get();
        $branches = Branch::orderBy('branch_name')->get();
        return view('frontend.user.certificate', ['courses' => $courses,'branches' => $branches, 'userid' => $userid]);
    }

    public function requests(CertificateRequest $request) {

        $user = \Auth::user();
        $userid = $user->id;
        DB::table('certificate_request')->insert(['userid' => $userid, 'date' => date("Y-m-d")]);

        $start_date = $end_date = "";
          if(!empty($request->input('start_date'))){
              $start_date = date('Y-m-d',strtotime($request->input('start_date')));
          }
          if(!empty($request->input('end_date'))){
              $end_date =date('Y-m-d',strtotime($request->input('end_date')));
          }

        $messages = "<br>Name: " . $request->input('name');
        $messages .= "<br>Course: " . $request->input('courses');
        $messages .= "<br>Branch: " . $request->input('branch');
        $messages .= "<br>Start_date:" . $start_date;
        $messages .= "<br>End_date:" . $end_date;
        $messages .= "<br>Trainer Name:" . $request->input('trainer_name');
        $messages .= "<br> Batch:" . $request->input('batch');
        $ticket_id = create_new_ticket($userid, "Certificate Request", $messages);
        return redirect()->route('frontend.user.certificate')->withFlashSuccess("Your Certification request is Submitted. Ticket #".$ticket_id);
    }

}
