<?php

namespace App\Http\Controllers\Frontend\User;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Repositories\Frontend\Auth\UserRepository;
use App\Recipients\AdminRecipient;
use App\Notifications\Frontend\AdminAlert;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;
use App\Models\Auth\ChatGroup;
use App\Models\Auth\Chat;

class ChatController extends Controller {

  public function studentchatget($id) {
    $studenid = \Auth::user()->id;
    $groupchat = DB::table('chat')
            //->select('chat.message','chat.created_at')
            ->select(DB::raw('DATE_FORMAT(chat.created_at, "%e %b %Y  %h:%i %p") as created_at'), 'chat.message', 'users.first_name', 'chat.id', 'chat.sender')
            ->join('batch', 'batch.id', '=', 'chat.batch')
            ->join('users', 'users.id', '=', 'chat.sender')
            ->where('chat.batch', $id)
            ->where('chat.sender', $studenid)
            ->orwhere('chat.receiver', $studenid)
            ->orderby('chat.created_at', "DESC")
            ->take(100)
            ->get();
    return json_encode($groupchat);
  }

  public function studentchatstore(Request $request) {
    $myid = \Auth::user()->id;
    if ($request->studentid == $myid) {
      $storedata = new Chat([
          'sender' => $request->studentid,
          'receiver' => $request->trainerids,
          'message' => $request->message,
          'batch' => $request->batchid,
          'send_sms' => 0,
      ]);
      $storedata->save();
      return response()->json(['success' => 'Form is successfully submitted!']);
    } else {
      return abort(404);
    }
  }

  public function privatemsgget($studentid) {
    $groupchat = DB::table('chat')
            ->select(DB::raw('DATE_FORMAT(chat.created_at, "%e %b %Y  %h:%i %p") as date'), 'chat.created_at', 'chat.message', 'users.first_name', 'chat.id', 'chat.sender')
            ->leftjoin('batch_students', 'batch_students.student', '=', 'chat.sender')
            ->join('users', 'users.id', '=', 'chat.sender')
            ->where('chat.sender', $studentid)
            ->orwhere('chat.receiver', $studentid)
            //->orwhere('batch_students.student',$studentid)
            ->orderby('chat.created_at', "DESC")
            ->distinct()
            ->take(100)
            ->get();
    return json_encode($groupchat);
  }

  public function privatemsgstore(Request $request, $studentid) {
    $sms = $request->sendsms;
    if ($sms != 0) {
      $message = $request->privatemessage;
      $userid = \Auth::user()->id;
      $id = $studentid;
      $storedata = new Chat([
          'sender' => $userid,
          'message' => $request->privatemessage,
          'batch' => $request->batchid,
          'receiver' => $id,
          'send_sms' => $request->sendsms,
      ]);
      $storedata->save();
      $functions = DB::table('users')->select('mobile', 'first_name')->where('id', $studentid)->first();
      $numbers = [$functions->mobile];
      //$notify_sms = get_sms_template('Notification');
      //send_sms($numbers, $notify_sms->message." ".$message,$notify_sms->template_id);

      return response()->json(['success' => 'Form is successfully submitted!']);
    } else {
      $userid = \Auth::user()->id;
      $id = $studentid;
      $storedata = new Chat([
          'sender' => $userid,
          'message' => $request->privatemessage,
          'batch' => $request->batchid,
          'receiver' => $id,
      ]);
      $storedata->save();
      return response()->json(['success' => 'Form is successfully submitted!']);
    }
  }

  public function classannouncement($id) {
    $groupchat = DB::table('chat_group')
            ->select(DB::raw('DATE_FORMAT(chat_group.created_at, "%e %b %Y  %h:%i %p") as created_at'), 'chat_group.message', 'users.first_name', 'chat_group.id')
            ->join('batch', 'batch.id', '=', 'chat_group.batch')
            ->join('users', 'users.id', '=', 'chat_group.trainer')
            ->where('chat_group.batch', $id)
            ->orderby('chat_group.created_at', "DESC")
            ->take(100)
            ->get();
    return json_encode($groupchat);
  }

  public function classannouncementstore(Request $request) {
    $sms = $request->sendsms;
    if ($sms != 0) {
      $messages = $request->message;
      $storedata = new ChatGroup([
          'trainer' => $request->trainerid,
          'batch' => $request->batchid,
          'message' => $request->message,
          'send_sms' => $request->sendsms,
      ]);
      $storedata->save();

      $data = DB::table('batch_students')
              ->select('student')
              ->where('batch', $request->batchid)
              ->get();
      foreach ($data as $tests) {
        $functions = DB::table('users')->select('mobile')->where('id', $tests->student)->first();
        $numbers = [$functions->mobile];
        //$notify_sms = get_sms_template('Notification');
        //send_sms($numbers, $notify_sms->message." ".$messages,$notify_sms->template_id);
      }
      return response()->json(['success' => 'Form is successfully submitted!']);
    } else {
      $storedata = new ChatGroup([
          'trainer' => $request->trainerid,
          'batch' => $request->batchid,
          'message' => $request->message,
      ]);
      $storedata->save();
      return response()->json(['success' => 'Form is successfully submitted!']);
    }
  }

}
