<?php

namespace App\Http\Controllers\Frontend\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Auth\User;
use App\Models\Auth\Country;
use App\Models\Auth\UniversityCourseCategories;
use App\Models\Auth\UniversityCourses;
use App\Models\Auth\Universities;
use App\Models\CourseShortlisted;
use App\Models\UserActivity;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use App\Models\Auth\Posts;
use Illuminate\Support\Facades\Mail;
use App\Mail\MailSend;
use App\Notifications\Backend\UserAlert;

/**
 * Class CourseFinderController.
 */
class CourseFinderController extends Controller
{

    public function __construct()
    {
        $this->menu_details = array();
        //$main_menus = Posts::Select('id','title','menu_title','slug')->where('status', '=', 1)->where('show_in_main_menu', '=', 1)->where('module_type', '!=', 'home')->orderBy('order')->get();

        if(config('app.product_code') == 'TRAINING') {
            $main_menus = Posts::Select('id', 'title', 'menu_title', 'slug')
            ->where('status', '=', 1)
            ->where('show_in_main_menu', '=', 1)
            ->where(function ($query) {
                $query->Where('module_type', '<>', "home")
                    ->Where('module_type', '<>', "country")
                    ->orWhere('module_type', NULL);
            })
            ->orderBy('order')
            ->get();
        } else if(config('app.product_code') == 'OVERSEAS') {
            $main_menus = Posts::Select('id', 'title', 'menu_title', 'slug')
            ->where('status', '=', 1)
            ->where('show_in_main_menu', '=', 1)
            ->where(function ($query) {
                $query->Where('module_type', '<>', "home")
                    ->Where('module_type', '<>', "coaching")
                    ->Where('module_type', '<>', "courses")
                    ->orWhere('module_type', NULL);
            })
            ->orderBy('order')
            ->get();

        } else {
            $main_menus = Posts::Select('id', 'title', 'menu_title', 'slug')
            ->where('status', '=', 1)
            ->where('show_in_main_menu', '=', 1)
            ->where(function ($query) {
                $query->Where('module_type', '<>', "home")
                    ->orWhere('module_type', NULL);
            })
            ->orderBy('order')
            ->get();
        }

        foreach ($main_menus as $main_menu) {
            $menu_title = $main_menu['menu_title'] != '' ? $main_menu['menu_title'] : $main_menu['title'];
            $this->menu_details[$menu_title] =  route('frontend.view-article', [$main_menu['slug']]);
        }
    }

    public function course_finder(Request $request)
    {
        $study_area = $discipline_area = NULL;
        if (!get_site_config('university_course_finder')) {
            return redirect()->back()->withFlashDanger('Action not allowed!');
        }
        $cat_name = "";
        // if(\Auth::check()){
        //     $cms_page = 0;
        //     $main_menu_arr = "";
        // }else{
        // }
        $cms_page = 1;
        $main_menu_arr = $this->menu_details;

        $countries = get_study_countries();
        $levels = get_study_levels();
        // $years = get_course_suggest_years();
        $durations = UniversityCourses::distinct('duration')->get(['duration']);
        $categories = UniversityCourseCategories::where('parent_id', '=', 0)->where('status', 1)->get();
        // return view("frontend.user.studyabroad_apply.course_finder", compact('countries', 'levels', 'categories','durations'));
        return view("frontend.user.studyabroad_apply.course_finder_result", compact('main_menu_arr','cms_page','countries', 'levels', 'categories','durations'));
    }

    public function course_finder_fetch_result(Request $request){
        if (!$request->ajax()) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this page.');
        }
        echo $this->getDatatableCourseFinderlist($request);
    }

    public function getDatatableCourseFinderlist($request){
        //Query debug
        DB::enableQueryLog();
        // dd($request->all());
        $columns = array(
            0 => 'course_name',
            1 => 'study_level',
            2 => 'university_name',
        );        
        //$courses = explode(',',$request->input('course_university_search'));
        // dd($courses);
        $course_university_search = $request->input('course');
        $country = $request->input('country');
        $universities = $request->input('universities');
        $study_level = $request->study_level;

        $yearly_tuition_fee = $request->input('yearly_tuition_fee');
        // $institution_turnaround_time = $request->input('institution_turnaround_time');
    
    
        $intake = $request->search_intake;
        $duration = $request->search_duration;
        $campus = $request->campus;
        $sort_by = $request->sort_by;
        //Score Filter
        $ielts = $request->ielts;
        $ielts_no_band = $request->ielts_no_band;
        $toefl = $request->toefl;
        $toefl_no_band = $request->toefl_no_band;
        $pte = $request->pte;
        $pte_no_band = $request->pte_no_band;
        $gre = $request->gre;
        $gmat = $request->gmat;
        $subcategory = $category = "";
        $subcategories = array();
        
        // if($request->category){
        //     if(!empty($request->sub_category)){
        //         $subcategory = $request->sub_category;
        //     }else{
        //         // $category = $request->category;
        //         $subcategories = UniversityCourseCategories::where('parent_id',$request->category)->where('status',1)->pluck('id')->toArray();
        //         $subcategories = array_values($subcategories);
        //         $subcategories[] = $request->category;
        //         // dd($subcategories);
        //     }
        // }

        if($request->filterstudyArea){
            if(!empty($request->filterdisciplineArea)){
                $subcategory = $request->filterdisciplineArea;
            }
            else{
                $subcategories = UniversityCourseCategories::where('parent_id',$request->filterstudyArea)->where('status',1)->pluck('id')->toArray();
                $subcategories = array_values($subcategories);
                $subcategories[] = $request->filterstudyArea;
            }
            
        }
    
        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');
    
        // $get_search = $request->input('search.value');
        $get_search = $request->input('course');
        // dd($universities);
        $totalData = DB::table('university_courses')
            ->join('universities', 'university_courses.university', '=', 'universities.id')
            ->select('universities.country','universities.university_name', 'university_courses.*')
            ->when(!empty($course_university_search), function ($query) use ($course_university_search) {
                return $query->Where(function ($query) use ($course_university_search) {
                    $query->where('university_courses.course_name', 'LIKE', "%$course_university_search%");
                    $query->orwhere('universities.university_name', 'LIKE', "%$course_university_search%");
                });
            })
            // ->when(!empty($courses), function ($query) use ($courses) {
            //     return $query->Where(function ($query) use ($courses) {
            //         for ($i = 0; $i < count($courses); $i++){
            //             $query->orwhere('universities.university_name', 'like',  '%' . $courses[$i] .'%');
            //             $query->orwhere('university_courses.course_name', 'like',  '%' . $courses[$i] .'%');
            //          } 
            //     });
            // })
            
            ->when(!empty($country), function ($query) use ($country) {
                return $query->where('universities.country', $country);
            })
            ->when(!empty($universities), function ($query) use ($universities) {
                return $query->where('universities.id',$universities);
            })
            // ->when(!empty($study_level), function ($query) use ($study_level) {
            //     return $query->where('university_courses.study_level',$study_level);
            // })
            ->when($study_level, function ($query) use ($study_level) {
                return $query->where('university_courses.study_level', $study_level);
            })
            // ->when(!empty($yearly_tuition_fee), function ($query) use ($yearly_tuition_fee) {
            //     return $query->where('university_courses.yearly_tuition_fee', '<', $yearly_tuition_fee);
            // })
    
            ->when(!empty($duration), function ($query) use ($duration) {
                if($duration==12){
                    return $query->whereBetween('university_courses.duration', [1, 12]); 
                }else if($duration == 24){
                   return $query->whereBetween('university_courses.duration', [12, 24]); 
                }else if($duration == 36){
                   return $query->whereBetween('university_courses.duration', [24, 36]); 
                }else if($duration == 48){
                   return $query->whereBetween('university_courses.duration', [36, 48]); 
                }
                else{
                   return $query->where('university_courses.duration','>',48); 
                }
            })
            ->when(!empty($subcategory), function ($query) use ($subcategory) {
               return $query->where('university_courses.category', $subcategory);
            })
            ->when(!empty($subcategories) && count($subcategories), function ($query) use ($subcategories) {
               return $query->whereIn('university_courses.category', $subcategories);
            })
            ->when(!empty($category), function ($query) use ($category) {
                return $query->where('university_courses.category', $category);
             })
            ->when(!empty($campus), function ($query) use ($campus) {
                return $query->where('university_courses.campus', $campus);
             })
            ->when($intake && count($intake), function ($query) use ($intake) {
                return $query->Where(function ($query) use ($intake) {
                    foreach($intake as $keyword) {
                        $query->orWhere('university_courses.intakes', 'LIKE', "%$keyword%");
                    }
                });
            })
            ->when(!empty($ielts), function ($query) use ($ielts) {
                return $query->where('university_courses.ielts_score', "=", $ielts);
            })
            ->when(!empty($ielts_no_band), function ($query) use ($ielts_no_band) {
                return $query->where('university_courses.ielts_no_band_less_than', "=", $ielts_no_band);
            })
            ->when(!empty($toefl), function ($query) use ($toefl) {
                return $query->where('university_courses.toefl_score', ">=", $toefl);
            })
            ->when(!empty($toefl_no_band), function ($query) use ($toefl_no_band) {
                return $query->where('university_courses.toefl_no_band_less_than', ">=", $toefl_no_band);
            })
            ->when(!empty($pte), function ($query) use ($pte) {
                return $query->where('university_courses.pte_score', ">=", $pte);
            })
            ->when(!empty($pte_no_band), function ($query) use ($pte_no_band) {
                return $query->where('university_courses.pte_no_band_less_than', ">=", $pte_no_band);
            })
            ->when(!empty($gre), function ($query) use ($gre) {
                return $query->where('university_courses.gre_score', ">=", $gre);
            })
            ->when(!empty($gmat), function ($query) use ($gmat) {
                return $query->where('university_courses.gmat_score', ">=", $gmat);
            })
            ->when(!empty($sort_by), function ($query) use ($sort_by) {
                if($sort_by == "course_name"){
                    return $query->orderBy('course_name', 'asc');
                }
                else if($sort_by == "ielts_lth"){
                    return $query->orderBy('ielts_score', 'asc');
                }
                else if($sort_by == "ielts_htl"){
                    return $query->orderBy('ielts_score', 'desc');
                }
                else if($sort_by == "fee_lth"){
                    return $query->orderBy('yearly_tuition_fee', 'asc');
                }
                else if($sort_by == "fee_htl"){
                    return $query->orderBy('yearly_tuition_fee', 'desc');
                }
            })
            ->when(!empty($get_search), function ($query) use ($get_search) {
                return $query->Where(function ($query) use ($get_search) {
                    $query->where('university_courses.course_name', 'LIKE', "%$get_search%");
                    $query->orwhere('universities.university_name', 'LIKE', "%$get_search%");
                });
                // return $query->Where(function ($query) use ($get_search) {
                //     $query->Where('course_name', 'like', "%$get_search%")
                //         ->orWhere('universities.university_name', 'like', "%$get_search%")
                //         ->orWhere('universities.country', 'like', "%$get_search%")
                //         ->orWhere('study_level', 'like', "%$get_search%")
                //         ->orWhere('university_courses.id', '=', "$get_search")
                //         ->orWhere('duration', 'like', "%$get_search%") 
                //         ->orWhere('intakes', 'like', "%$get_search%") 
                //         ->orWhere('year', 'like', "%$get_search%")
                //         ->orWhere('remarks', 'like', "%$get_search%")
                //         ->orWhere('university_courses.status', 'like', "%$get_search%");
                // });
            })       
            ->where('university_courses.status', 1)          
            ->count();
            // $queries = DB::getQueryLog();
            // dd(end($queries));  
        $users = DB::table('university_courses')
            ->join('universities', 'university_courses.university', '=', 'universities.id')
            ->select('universities.country','universities.university_name', 'university_courses.*')
            ->when(!empty($course_university_search), function ($query) use ($course_university_search) {
                return $query->Where(function ($query) use ($course_university_search) {
                    $query->where('university_courses.course_name', 'LIKE', "%$course_university_search%");
                    $query->orwhere('universities.university_name', 'LIKE', "%$course_university_search%");
                });
            })
            // ->when(!empty($courses), function ($query) use ($courses) {
            //     return $query->Where(function ($query) use ($courses) {
            //         for ($i = 0; $i < count($courses); $i++){
            //             $query->orwhere('universities.university_name', 'like',  '%' . $courses[$i] .'%');
            //             $query->orwhere('university_courses.course_name', 'like',  '%' . $courses[$i] .'%');
            //          }
                    
            //     });
            // })
            ->when(!empty($country), function ($query) use ($country) {
                return $query->where('universities.country', $country);
            })
            ->when(!empty($universities), function ($query) use ($universities) {
                return $query->where('universities.id',$universities);
            })
            ->when($study_level, function ($query) use ($study_level) {
                return $query->where('university_courses.study_level', $study_level);
            })
            ->when(!empty($duration), function ($query) use ($duration) {
                if($duration==12){
                    return $query->whereBetween('university_courses.duration', [1, 12]); 
                }else if($duration == 24){
                   return $query->whereBetween('university_courses.duration', [12, 24]); 
                }else if($duration == 36){
                   return $query->whereBetween('university_courses.duration', [24, 36]); 
                }else if($duration == 48){
                   return $query->whereBetween('university_courses.duration', [36, 48]); 
                }
                else{
                   return $query->where('university_courses.duration','>',48); 
                }
            })
            ->when(!empty($subcategory), function ($query) use ($subcategory) {
               return $query->where('university_courses.category', $subcategory);
            })
            ->when(!empty($subcategories) && count($subcategories), function ($query) use ($subcategories) {
               return $query->whereIn('university_courses.category', $subcategories);
            })
            ->when(!empty($category), function ($query) use ($category) {
                return $query->where('university_courses.category', $category);
             })
            ->when(!empty($campus), function ($query) use ($campus) {
                return $query->where('university_courses.campus', $campus);
             })
            ->when($intake && count($intake), function ($query) use ($intake) {
                return $query->Where(function ($query) use ($intake) {
                    foreach($intake as $keyword) {
                        $query->orWhere('university_courses.intakes', 'LIKE', "%$keyword%");
                    }
                });
            })
            ->when(!empty($ielts), function ($query) use ($ielts) {
                return $query->where('university_courses.ielts_score', "=", $ielts);
            })
            ->when(!empty($ielts_no_band), function ($query) use ($ielts_no_band) {
                return $query->where('university_courses.ielts_no_band_less_than', "=", $ielts_no_band);
            })
            ->when(!empty($toefl), function ($query) use ($toefl) {
                return $query->where('university_courses.toefl_score', ">=", $toefl);
            })
            ->when(!empty($toefl_no_band), function ($query) use ($toefl_no_band) {
                return $query->where('university_courses.toefl_no_band_less_than', ">=", $toefl_no_band);
            })
            ->when(!empty($pte), function ($query) use ($pte) {
                return $query->where('university_courses.pte_score', ">=", $pte);
            })
            ->when(!empty($pte_no_band), function ($query) use ($pte_no_band) {
                return $query->where('university_courses.pte_no_band_less_than', ">=", $pte_no_band);
            })
            ->when(!empty($gre), function ($query) use ($gre) {
                return $query->where('university_courses.gre_score', ">=", $gre);
            })
            ->when(!empty($gmat), function ($query) use ($gmat) {
                return $query->where('university_courses.gmat_score', ">=", $gmat);
            })
            ->when(!empty($sort_by), function ($query) use ($sort_by) {
                if($sort_by == "course_name"){
                    return $query->orderBy('course_name', 'asc');
                }
                else if($sort_by == "ielts_lth"){
                    return $query->orderBy('ielts_score', 'asc');
                }
                else if($sort_by == "ielts_htl"){
                    return $query->orderBy('ielts_score', 'desc');
                }
                else if($sort_by == "fee_lth"){
                    return $query->orderBy('yearly_tuition_fee', 'asc');
                }
                else if($sort_by == "fee_htl"){
                    return $query->orderBy('yearly_tuition_fee', 'desc');
                }
            })
            ->when(!empty($get_search), function ($query) use ($get_search) {
                return $query->Where(function ($query) use ($get_search) {
                    $query->where('university_courses.course_name', 'LIKE', "%$get_search%");
                    $query->orwhere('universities.university_name', 'LIKE', "%$get_search%");
                });
                // return $query->Where(function ($query) use ($get_search) {
                //     $query->Where('course_name', 'like', "%$get_search%")
                //         ->orWhere('universities.university_name', 'like', "%$get_search%")
                //         ->orWhere('universities.country', 'like', "%$get_search%")
                //         ->orWhere('study_level', 'like', "%$get_search%")
                //         ->orWhere('university_courses.id', '=', "$get_search")
                //         ->orWhere('duration', 'like', "%$get_search%") 
                //         ->orWhere('intakes', 'like', "%$get_search%") 
                //         ->orWhere('year', 'like', "%$get_search%")
                //         ->orWhere('remarks', 'like', "%$get_search%")
                //         ->orWhere('university_courses.status', 'like', "%$get_search%");
                // });
            })  
            ->where('university_courses.status', 1)               
            ->offset($start)
            ->limit($limit)
            ->orderBy($order, $dir)
            ->get();
    
        $totalFiltered = $totalData;
    
        $data = $courses = array();
        if (!empty($users)) {
            $count = 1;
            foreach ($users as $page) {
                $customResult['course_name'] = "<div class='row card py-3 rounded ' style=' margin-top: 0px; margin-top: 15px;'>";
                    $customResult['course_name'] .= "<div class='col-12 card-body pb-0' style='padding-top: 0px;'>";
                        $customResult['course_name'] .= "<div class='row'>";
                            $customResult['course_name'] .= "<div class='col-12'>";
                                $customResult['course_name'] .=  $page->course_name ? '<a href="' . route('frontend.course-finder.course-details', $page->id) . '" target="_blank" class="text-primary" style="font-size: 18px !important;"> <b>' . $page->course_name . '</b></a>' : "--";
                            $customResult['course_name'] .= "</div>";
                            $customResult['course_name'] .= "<div class='col-8'>";
                                $customResult['course_name'] .= $page->university_name ? '<br><b class="text-secondary"><i class="fa fa-university text-secondary"></i> </b> <a class="text-dark fw-bold" target="_blank" href="' . route('frontend.course-finder.university-details', $page->university) . '">' . $page->university_name . '</a>' : "--";
                            $customResult['course_name'] .= "</div>";
                            $customResult['course_name'] .= "<div class='col-4'>";
                                $customResult['course_name'] .= $page->country ? "<br><b class='text-secondary'><i class='fa fa-globe text-secondary'></i></b> <b class='fw-bold text-dark'>" . get_country_name($page->country) . "</b>" . "</b>" : "<br><b>Country:</b> --";
                            $customResult['course_name'] .= "</div>";
                        $customResult['course_name'] .= "</div>";

                        $customResult['course_name'] .= "<div class='row'>";
                            $customResult['course_name'] .= "<div class='col-4'>";
                                $customResult['course_name'] .= "<br><b class='text-secondary'><i class='fa fa-graduation-cap text-secondary'></i> Study Level:</b><br> <b class='fw-bold text-dark'>".$page->study_level . "</b>";
                            $customResult['course_name'] .= "</div>";
                            $customResult['course_name'] .= "<div class='col-4'>";
                                $customResult['course_name'] .= $page->duration ? "<br><b class='text-secondary'><i class='fa fa-clock-o text-secondary'></i> Duration:</b><br> <b class='fw-bold text-dark'>" . $page->duration . "</b>" : "<br><b class='text-secondary'><i class='fa fa-clock-o text-secondary'></i> Duration:</b><br> --";
                            $customResult['course_name'] .= "</div>";
                            $customResult['course_name'] .= "<div class='col-4'>";
                                $intakes = array();
                                if($page->intakes){
                                    $intakes = explode(",", $page->intakes);
                                }
                                $count = count($intakes);
                                $allIntake = "";
                                $i = 0;
                                foreach($intakes as $intake){
                                    $i++;
                                    $allIntake .= substr($intake, 0, 3);
                                    if($i < $count){
                                        $allIntake .= ", ";
                                    }
                                }
                                $customResult['course_name'] .= $page->intakes ? "<br><b class='text-secondary'><i class='fa fa-book text-secondary'></i> Intakes:</b><br> <b class='fw-bold text-dark'>" . $allIntake . "</b>" : "<br><b class='text-secondary'><i class='fa fa-book text-secondary'></i> Intakes:</b><br> --";
                            $customResult['course_name'] .= "</div>";
                            $customResult['course_name'] .= "<div class='col-4'>";
                                $customResult['course_name'] .= $page->application_fee ? "<br><b class='text-secondary'><i class='fa fa-money text-secondary'></i> Application Fees:</b><br> <b class='fw-bold text-dark'>". $page->currency.' '.$page->application_fee . "</b>" : "<br><b class='text-secondary'><i class='fa fa-money text-secondary'></i> Application Fees:</b><br> --";
                            $customResult['course_name'] .= "</div>";
                            $customResult['course_name'] .= "<div class='col-4'>";
                                $customResult['course_name'] .= $page->yearly_tuition_fee ? "<br><b class='text-secondary'><i class='fa fa-money text-secondary'></i> Tuition Fees:</b><br> <b class='fw-bold text-dark'>". $page->currency.' '.$page->yearly_tuition_fee . "</b>" : "<br><b class='text-secondary'><i class='fa fa-money text-secondary'></i> Tuition Fees:</b><br> --";
                            $customResult['course_name'] .= "</div>";
                        $customResult['course_name'] .= "</div>";
    
                // $customResult['university'] .= $page->country ? "<p class='mt-2'>" . get_country_name($page->country)."</p>" : "";
                
                // $customResult['course_name'] .= "<br><b>ID:</b> " . $page->id;
                
                
                // $customResult['sub_category'] = $page->category ? get_university_course_category_name($page->category ) : "--";
    
                // $customResult['course_name'] .= $page->entry_requirements ? "<br> <b>Entry Requirements:</b> <span style='word-wrap: break-word;''> <span class='text-sub'>" .$page->entry_requirements . "</span></span><br />" : "--";
    
                // $number = str_replace(',', '', $page->yearly_tuition_fee);
                // $customResult['course_name'] .= $page->yearly_tuition_fee ? "<br><b>Tuition Fees:</b> " . number_format($number, 2) : "<br><b>Tuition Fees:</b> --";
                
    
                // $customResult['course_name'] .= $page->institution_turnaround_time ? "<br><b>Institution Turnaround Time:</b> " . $page->institution_turnaround_time ." Days"  : "<br><b>Institution Turnaround Time:</b> --";
                if (auth()->check()) {
                    $customResult['course_name'] .= "<div class='row py-1 mt-3' style='background-color: rgb(244,244,244);'>";
                        $customResult['course_name'] .= "<div class='col-12'>";
                            $customResult['course_name'] .= '<p class="mb-1 mt-2 text-end"><a onclick="javascript:bookmark_course('.$page->id.')" type="button" class="btn btn-sm btn-themecolor text-white py-2 px-3">Bookmark</a> <a id="coursePreferenceButton" data-id="'.$page->id.'" class="btn btn-sm btn-themecolor text-white py-2 px-3">Apply</a> </p>';
                        $customResult['course_name'] .= "</div>";
                    $customResult['course_name'] .= "</div>";
                }else{
                    $customResult['course_name'] .= "<div class='row py-1 mt-3' style='background-color: rgb(244,244,244);'>";
                        $customResult['course_name'] .= "<div class='col-12'>";
                            $customResult['course_name'] .= '<p class="mb-1 mt-2 text-end"><a id="coursePreferenceButton" data-id="'.$page->id.'" class="btn btn-sm btn-themecolor text-white py-2 px-3">Apply</a> </p>';
                        $customResult['course_name'] .= "</div>";
                    $customResult['course_name'] .= "</div>";
                }

                $customResult['course_name'] .= "</div>";
                $customResult['course_name'] .= "</div>";                

                $data[] = $customResult;
            }
        }
        $json_data = array(
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $data,
            "search" => $get_search,
        );
        return json_encode($json_data);
    }
    //NEW


    // public function course_finder_result(Request $request)
    // {
    //     DB::enableQueryLog();
    //     $course = $request->course;
    //     $intake = $request->intake;
    //     $countries = $request->country;
    //     $study_level = $request->study_level;
    //     $campus = $request->campus;
    //     $duration = $request->duration;
    //     $ielts = $request->ielts;
    //     $ielts_no_band = $request->ielts_no_band;
    //     $toefl = $request->toefl;
    //     $toefl_no_band = $request->toefl_no_band;
    //     $pte = $request->pte;
    //     $pte_no_band = $request->pte_no_band;
    //     $gre = $request->gre;
    //     $gmat = $request->gmat;
    //     $subcategory = $category = "";
    //     $subcategories = array();

    //     if($request->category){
    //         if(!empty($request->sub_category)){
    //             $subcategory = $request->sub_category;
    //         }else{
    //             $subcategories = UniversityCourseCategories::where('parent_id',$request->category)->where('status',1)->pluck('id')->toArray();
    //             $subcategories = array_values($subcategories);
    //             $subcategories[] = $request->category;
    //         }
    //     }

    //     $result = DB::table('university_courses')
    //         ->join('universities', 'universities.id', '=', 'university_courses.university')
    //         ->when(!empty($course), function ($query) use ($course) {
    //             return $query->Where(function ($query) use ($course) {
    //                 $query->where('university_courses.course_name', 'LIKE', "%$course%");
    //                 $query->orwhere('universities.university_name', 'LIKE', "%$course%");
    //             });
    //         })
    //         ->when(!empty($study_level), function ($query) use ($study_level) {
    //             return $query->where('university_courses.study_level', $study_level);
    //         })
           
    //         ->when(!empty($duration), function ($query) use ($duration) {
    //             return $query->where('university_courses.duration', 'LIKE', "%$duration%");
    //         })
    //         ->when(!empty($subcategory), function ($query) use ($subcategory) {
    //             return $query->where('university_courses.category', $subcategory);
    //         })
    //         ->when(!empty($subcategories), function ($query) use ($subcategories) {
    //             return $query->whereIn('university_courses.category', $subcategories);
    //         })
    //         ->when(!empty($category), function ($query) use ($category) {
    //             return $query->where('university_courses.category', $category);
    //         })
    //         ->when(!empty($campus), function ($query) use ($campus) {
    //             return $query->where('university_courses.campus', $campus);
    //          })
    //         ->when($intake && count($intake), function ($query) use ($intake) {
    //             return $query->Where(function ($query) use ($intake) {
    //                 foreach ($intake as $keyword) {
    //                     $query->orWhere('university_courses.intakes', 'LIKE', "%$keyword%");
    //                 }
    //             });
    //         })
          
    //         ->when($countries && count($countries), function ($query) use ($countries) {
    //             return $query->Where(function ($query) use ($countries) {
    //                 foreach ($countries as $country) {
    //                     $query->orWhere('universities.country',$country);
    //                 }
    //             });
    //         })
    //         ->when(!empty($ielts), function ($query) use ($ielts) {
    //             return $query->where('university_courses.ielts_score', "=", $ielts);
    //         })
    //         ->when(!empty($ielts_no_band), function ($query) use ($ielts_no_band) {
    //             return $query->where('university_courses.ielts_no_band_less_than', "=", $ielts_no_band);
    //         })
    //         ->when(!empty($toefl), function ($query) use ($toefl) {
    //             return $query->where('university_courses.toefl_score', ">=", $toefl);
    //         })
    //         ->when(!empty($toefl_no_band), function ($query) use ($toefl_no_band) {
    //             return $query->where('university_courses.toefl_no_band_less_than', ">=", $toefl_no_band);
    //         })
    //         ->when(!empty($pte), function ($query) use ($pte) {
    //             return $query->where('university_courses.pte_score', ">=", $pte);
    //         })
    //         ->when(!empty($pte_no_band), function ($query) use ($pte_no_band) {
    //             return $query->where('university_courses.pte_no_band_less_than', ">=", $pte_no_band);
    //         })
    //         ->when(!empty($gre), function ($query) use ($gre) {
    //             return $query->where('university_courses.gre_score', ">=", $gre);
    //         })
    //         ->when(!empty($gmat), function ($query) use ($gmat) {
    //             return $query->where('university_courses.gmat_score', ">=", $gmat);
    //         })
    //         ->where('status', "1")
    //         ->select(DB::raw('university_courses.*, universities.country, universities.university_name, universities.id as uni_id'))
    //         ->orderBy('created_at', 'desc')
    //         ->get();
    //     $queries = DB::getQueryLog();
    //     foreach($result as $res){
    //         $res->country = get_country_name($res->country);
    //     }
    //     return response()->json(['status' => 'success', 'data' => $result, 'query' => $queries]);
    // }

    public function fetchSubCat(Request $request)
    {
        $cat_data = UniversityCourseCategories::where('parent_id', '=', $request->category_id)->where('status', 1)->get(["title", "id"]);
        if (count($cat_data) > 0) {
            $data['subcategories'] = $cat_data;
            return response()->json($data);
        } else {
            $data['subcategories'] = "No Sub Category Found!";
            return response()->json($data);
        }
    }

    public function fetchCampus(Request $request)
    {
        $campus = Universities::where('country', $request->country_id)
        ->Join('university_courses','university_courses.university',"=",'universities.id')
        ->where('status',1)
        ->whereNotNull('campus')
        ->distinct()
        ->get(["campus"]);
         if(count($campus)>0){
          $data['campus'] = $campus;
          return response()->json($data);
         }else{
          $data['campus'] = "No Campus Found!";
          return response()->json($data);
         } 
    }


    public function course_details($id)
    {
        if(!(\Auth::check())){
            return redirect()->route('frontend.auth.login');
        }
        if(\Auth::check()){
            $cms_page = 0;
            $main_menu_arr = "";
        }else{
            $cms_page = 1;
            $main_menu_arr = $this->menu_details;
        }
        $course = UniversityCourses::find($id);
        return view("frontend.user.studyabroad_apply.course_details", compact('cms_page','main_menu_arr','course'));
    }

    public function university_details($id)
    {
        if(!(\Auth::check())){
            return redirect()->route('frontend.auth.login');
        }
        $university = Universities::find($id);
        if(!$university){
            return redirect()->back()->withFlashDanger('University not found!');
        }
        if(\Auth::check()){
            $cms_page = 0;
            $main_menu_arr = "";
        }else{
            $cms_page = 1;
            $main_menu_arr = $this->menu_details;
        }
        return view("frontend.user.studyabroad_apply.university_details",compact('cms_page','main_menu_arr','university'));
    }

    public function fetch_course_info($id)
    {
        $course = UniversityCourses::find($id);
        $courseYears = explode(',',$course->year);
        $courseMonths = explode(',',$course->intakes);

        foreach($courseMonths as $months){
            $monthNum[] = array('moName'=>date("M", strtotime($months)),'moNum' => date("m", strtotime($months)));
        }

        $data = (['course_years'=> $courseYears,'course_months'=>$monthNum, 'course_name'=> $course->course_name, 'id'=> $course->id, 'university_id' => $course->university,'course_uni' => get_university_data($course->university)->university_name, 'university_country_id' => get_university_data($course->university)->country,'course_country' => get_country_name(get_university_data($course->university)->country)]);
        return response()->json(['status'=>'success','data'=>$data]);
    }


    public function applyCourse(Request $request){
        
            if(($request->preference_course_id !='' && $request->course_preference_country !='' && $request->course_preference_uni !='' && $request->intake !='') && (!\Auth::check())){
            $data = [
                "course_id" => $request->preference_course_id,
                "country_id" => $request->course_preference_country,
                "university_id" => $request->course_preference_uni,
                "intake" => $request->intake
            ];
            session()->put('course_finder_apply_course', $data);
            return redirect('login');
        }
        if(session()->has('course_finder_apply_course') && \Auth::check()){
            $course = session()->get('course_finder_apply_course')['course_id'];
            $university = session()->get('course_finder_apply_course')['university_id'];
            $intake = session()->get('course_finder_apply_course')['intake'];
            $country = session()->get('course_finder_apply_course')['country_id'];
            
        }else{
            $course = $request->input('preference_course_id');
            $university = $request->input('course_preference_uni');
            $intake = $request->input('intake');
            $country = $request["course_preference_country"];
        }
       
        $user = \Auth::user();
        $userid = $user->id;
        $inta =  explode(" ",$intake);
        $chk_pref = DB::table('course_preference')
            ->where('userid',$userid)
            ->where('intake',$inta[0])
            ->where('intake_year',$inta[1])
            ->where('country_id',$country)
            ->where('course_id',$course)
            ->where('course_id',"!=",0)
            ->where('university_id',$university)
            ->where('university_id',"!=",0)
            ->first();

        if($chk_pref){
            session()->forget('course_finder_apply_course');
            return redirect()->route('frontend.user.studyabroad.coursepreference')->withFlashDanger("Course preferences already exists!");
        }
        else{
            DB::table('course_preference')
                ->insert(
                [
                    'userid' => $userid,
                    'country_id' => $country,
                    'course_id' => $course,
                    'university_id' => $university,
                    'intake_year' => $inta[1],
                    'intake' => $inta[0],
                    'created_by' => \Auth::user()->id,
                    'created_at' => now()
                ]
            );
        
        $user->profile_complete = 'course';
        $user->save();

        update_student_overseas_status($user->id);

        //store event in user activity
        UserActivity::create(['user_id' => $user->id, 'type' => 'user_event', 'title' => "Student Added Course Preferences", 'detail' => ""]);
        
        //Sending email Notification
        $subject = "Course Preference Added by "._label('backend_student').": " . $user->full_name." (". $user->id. ")";
        $email_message = "Hi, <br><br>Course Preference Added by "._label('backend_student')."<br /><strong>"._label('backend_student')." Details:</strong><br/>Name: " . $user->first_name ." ".$user->last_name. "<br />Mob: " . $user->mobile . "<br />Email: " . $user->email;
        send_mail_notification($userid,"","COURSE_PREFERENCE_ADDED_BY_STUDENT",$subject,$email_message);

        // Send Push App Notification
        $subject = "";
        $message = "Course Preference added by "._label('backend_student')." <strong>" . $user->full_name."</strong> (". $user->id. ")";
        send_in_app_notification(
            $user->id, 
            $user->id, 
            "COURSE_PREFERENCE_ADDED_BY_STUDENT", 
            $subject, 
            $message,
            "student", 
        );
        session()->forget('course_finder_apply_course');
        session()->forget('course_finder_filters');
        return redirect()->route('frontend.user.studyabroad.coursepreference')->withFlashSuccess("Course preferences added successfully");
        }
    }

    public function addBookmark(Request $request) { 
        \Log::debug("Course Bookmark Add:".$request->course_id);

        if(!$request->course_id) {
            return response()->json(['res'=> 'error', 'message'=>'Course ID Required.']);
        }

        $course_id = $request->course_id;
        $student = \Auth::user();

        if(!UniversityCourses::find($course_id)) {
            return response()->json(['res'=> 'error', 'message'=>'Course Not Found.']);
        }

        if(CourseShortlisted::where('student_id', $student->id)->where('course_id', $course_id)->exists()) {
            return response()->json(['res'=> 'error', 'message'=>'Course Already Bookmarked.']);
        }


        $created = CourseShortlisted::create([
            'student_id' => $student->id,
            'course_id' => $course_id
        ]);

        \Log::debug("Course $course_id Bookmarked By Student: ".$student->id);

        $course = CourseShortlisted::join('university_courses', 'university_courses.id', '=', 'course_shortlisted.course_id')
        ->join('universities', 'universities.id', '=', 'university_courses.university')
        ->select('course_shortlisted.*','university_courses.course_name','university_courses.university','university_courses.study_level','university_courses.campus','university_courses.duration','university_courses.intakes','universities.university_name','universities.country')
        ->where('course_shortlisted.id', $created->id)
        ->first();


        //Sending email Notification
        $subject = "Course Bookmarked by Student";
        $message = "Hi, <br><br>Student: ".$student->first_name." ".$student->last_name." (".$student->email.") has bookmarked a Course";
        $message .= "<br><br>Course:".$course->course_name;
        $message .= "<br>University:".$course->university_name . " / ".$course->campus." / ".get_country_name($course->country);
        $message .="<br><br><a href='".route('admin.auth.user.show', $student->id)."'>View Student Details</a>";
        send_mail_notification($student->id,"","COURSE_BOOKMARKED_BY_STUDENT",$subject,$message);

        // Send Push App Notification
        $subject = "";
        $message = "Bookmarked Course: <strong>".$course->course_name."</strong>, ".$course->university_name . " (".$course->campus.", ".get_country_name($course->country).")";

        send_in_app_notification(
            $student->id, 
            $student->id, 
            "COURSE_BOOKMARKED_BY_STUDENT", 
            $subject, 
            $message,
            "lead", 
        );
     
        // $staff = User::find($student->assigned_to);
        
        // if($staff) {
        //     $message = "Dear ".$staff->first_name."<br><br>Student: ".$student->first_name." ".$student->last_name." (".$student->email.") has bookmarked a Course";
        //     $message .= "<br><br>Course:".$course->course_name;
        //     $message .= "<br>University:".$course->university_name . " / ".$course->campus." / ".$course->country;
        //     $message .="<br><br><a href='".route('admin.auth.user.show', $student->id)."'>View Student Details</a>";

        //     try{
        //         $staff->notify(new UserAlert("Course Bookmarked", $message));
        //         \Log::debug("Mail Success: (Course Bookmarked) ");   
        //     }catch (\Exception $e) {
        //         $message = $e->getMessage();
        //         \Log::debug("Mail Error: (Course Bookmarked) ".$message);   
        //     }  
        // }

        return response()->json(['res'=> 'success', 'message'=>'Course Bookmarked!']);
    }

    public function removeBookmark(Request $request) {
        //Is this needed?
        \Log::debug("Course Bookmark Remove");
    }
}
