<?php

namespace App\Http\Controllers\Frontend\User;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Repositories\Frontend\Auth\UserRepository;
use App\Http\Requests\Frontend\User\UpdateCourseSelectionRequest;
use App\Recipients\AdminRecipient;
use App\Notifications\Frontend\AdminAlert;
use App\Notifications\Backend\UserAlert;

/**
 * Class CourseSelectionController.
 */
class CourseSelectionController extends Controller {

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index() {
        $data = array();
        $userid = \Auth::user()->id;

        $rows = DB::table('course_preference')->where('userid', $userid)->get();
        //var_export($rows);
        if ($rows) {
            foreach ($rows as $row) {
                $intake = $row->intake;
                $intake_str = "";
                if ($intake) {
                    $month_nums = explode(",", $intake);
                    if (count($month_nums)) {
                        foreach ($month_nums as $month) {
                            if (is_numeric($month)) {
                                $str = date("Y") . "-" . $month . "-01";
                                $intake_str .= date("M", strtotime($str)) . ", ";
                            }
                        }
                    }
                }
                $data[] = array('country' => $row->country, 'course_name' => $row->course, 'university' => $row->university, 'intake' => $intake_str);
            }
        }

        return view('frontend.user.courseselection', ['data' => $data]);
    }

    public function save(UpdateCourseSelectionRequest $request) {
        $data = $request->all();
        $user = $request->user();
        $userid = $user->id;

        if (DB::table('course_preference')->where('userid', $userid)->exists()) {
            return redirect()->route('frontend.user.courseselection')->withFlashDanger("Course Selection data already exists!");
        } else {
            $sel_courses = "";
            //$email_message = "Dear Admin, <br /><br />User: " . $user->name . " (Mob: " . $user->mobile . ") has selected course preference.<br /><br />Details:";
            for ($i = 0; $i < count($data['course']); $i++) {
                $intake_csv = "";
                $course = $data['course'][$i];
                $course_name = $course['course_name'];
                $country = $course['country'];
                $university = $course['university'];
                //var_export($course);
                if (!empty($country)) {
                    if (isset($course['intake'])) {
                        $intake = $course['intake'];
                        if (count($intake)) {
                            $intake_csv = implode(",", $intake);
                            //\Log::debug("::san::  CourseSel save Intake:" . $intake_csv);
                        }
                    }
                    //$email_message .= "<br /><br />" . ($i + 1) . ".<br />COUNTRY: " . $country . "<br />COURSE: " . $course_name . "<br />UNIVERSITY: " . $university . "<br />INTAKE MONTHS: " . $intake_csv;
                    $sel_courses .= "<br /><br />Country: " . $country . "<br />Course: " . $course_name . "<br />University: " . $university . "<br />Intake Months: " . $intake_csv;

                    DB::table('course_preference')
                            ->insert(
                                    ['userid' => $userid, 'country' => $country, 'course' => $course_name, 'university' => $university,
                                        'intake' => $intake_csv
                                    ]
                    );
                }
            }
            //Raise a ticket
            $message = "<strong>User Details:</strong><br /><br />" . $user->name . "<br />Mob: " . $user->mobile . "<br />Email: " . $user->email . "<br /><br /><strong>Course Selection:</strong>" . $sel_courses;
            $ticket_id = create_new_ticket($userid, "Course Selection By User", $message);
            //Notify admin - not required, on create_new_ticket staff notified
            //$admin_email_message = "Ticket #$ticket_id is auto created.<br /><br /><hr>$message<hr><br /><br />View Ticket Details: <br /><a href=\"" . url("admin/ticket/" . $ticket_id) . "\">" . url("admin/ticket/" . $ticket_id) . "</a>";
            //$recipient = new AdminRecipient();
            //$recipient->notify(new AdminAlert("[Ticket ID: $ticket_id] Course Selection By User", $admin_email_message));

            //Notify user
            $user_email_message = "Ticket #$ticket_id is auto created.<br /><br /><hr>$message<hr><br /><br />";
            try{
                //$user->notify(new UserAlert("[Ticket ID: $ticket_id] Course Selection By User", $user_email_message));
                user_notify($user,"[Ticket ID: $ticket_id] Course Selection By User", $user_email_message);
            }catch (\Exception $e) {
                $message = $e->getMessage();
                \Log::debug("Mail Error: (Course Pref. Ticket) ".$message);   
            }
            return redirect()->route('frontend.user.courseselection')->withFlashSuccess("Course Selection data saved successfully");
        }
    }

}
