<?php

namespace App\Http\Controllers\Frontend\User;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Repositories\Frontend\Auth\UserRepository;
use App\Models\Auth\User;
use App\Models\CourseShortlisted;
use App\Recipients\AdminRecipient;
use App\Notifications\Frontend\AdminAlert;
use App\Notifications\Backend\UserAlert;
use Request;

/**
 * Class CourseSuggestionController.
 */
class CourseSuggestionController extends Controller
{

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {

        // if (get_site_config('course_preference_dropdown')) {
            //Course suggestions from course finder
            $data = CourseShortlisted::join('university_courses', 'university_courses.id', '=', 'course_shortlisted.course_id')
                ->join('universities', 'universities.id', '=', 'university_courses.university')
                ->where('student_id', \Auth::user()->id)
                ->select('course_shortlisted.*','university_courses.course_name','university_courses.university','university_courses.study_level','university_courses.campus','university_courses.duration','university_courses.intakes','universities.university_name','universities.country')
                ->orderBy('course_shortlisted.created_at', 'DESC')
                ->get();

            $docData = array();
            $userid = \Auth::user()->id;
            $rows = DB::table('course_recommendation')->where('userid', $userid)->orderBy('upload_date', 'desc')->get();
            //var_export($rows);
            if ($rows) {
                foreach ($rows as $row) {
                    $title = $row->title;
                    $upload_dt = date("j M Y", strtotime($row->upload_date));
                    $filename = $row->file;
                    $ext = pathinfo($filename, PATHINFO_EXTENSION);
                    $file_path = url('storage/' . $filename);
                    $doc = $title . " (" . $ext . ")";
                    $docData[] = array('id' => $row->id, 'date' => $upload_dt, 'doc' => $doc, 'file_path' => $file_path, 'satisfied' => $row->satisfied);
                }
            }

            return view('frontend.user.coursefinder_suggestion', compact('data','docData'));
        // } else {
        //     //Manually sent course suggestion documents

        //     $data = array();
        //     $userid = \Auth::user()->id;
        //     $rows = DB::table('course_recommendation')->where('userid', $userid)->orderBy('upload_date', 'desc')->get();
        //     //var_export($rows);
        //     if ($rows) {
        //         foreach ($rows as $row) {
        //             $title = $row->title;
        //             $upload_dt = date("j M Y", strtotime($row->upload_date));
        //             $filename = $row->file;
        //             $ext = pathinfo($filename, PATHINFO_EXTENSION);
        //             $file_path = url('storage/' . $filename);
        //             $doc = $title . " (" . $ext . ")";
        //             $data[] = array('id' => $row->id, 'date' => $upload_dt, 'doc' => $doc, 'file_path' => $file_path, 'satisfied' => $row->satisfied);
        //         }
        //     }

        //     return view('frontend.user.coursesuggestion', ['docData' => $data]);
        // }
    }

    public function feedback($suggestion_id, $feedback_value)
    {
        $data = array();
        $user = \Auth::user();
        $userid = $user->id;
        if (DB::table('course_recommendation')->where(['id' => $suggestion_id, 'userid' => $userid])->exists()) {
            $row = DB::table('course_recommendation')->where('id', $suggestion_id)->first();
            if ($row->satisfied != 'none') {
                return redirect()->route('frontend.user.coursesuggestion')->withFlashDanger("Course Suggestion Feedback already exists");
            } else {
                DB::table('course_recommendation')->where('id', $suggestion_id)->update(['satisfied' => $feedback_value]);
                if ($feedback_value == 'no') {
                    // $email_message = "Dear Admin, <br /><br />User: " . $user->name . " (Mob: " . $user->mobile . ") has provided feedback: NOT satisfied with Course Recommendation ID: $suggestion_id";
                    if($user->assigned_to != 0){
                        $staff = User::find($user->assigned_to);
                        if($staff) {
                            $email_message = "Dear ".$staff->first_name."<br /><br />User: " . $user->name . " (Mob: " . $user->mobile . ") has provided feedback: NOT satisfied with Course Recommendation ID: $suggestion_id";
                            try{
                                //$staff->notify(new UserAlert("Course Suggestion - Not Satisfied", $email_message));
                                user_notify($staff,"Course Suggestion - Not Satisfied", $email_message);
                            }catch (\Exception $e) {
                                $message = $e->getMessage();
                                \Log::debug("Mail Error: (Course Suggestion - Not Satisfied) ".$message);   
                            }                
                        }
                    }
                }

                //Sending email Notification
                $subject = "Course Suggested is approved by "._label('backend_student').": " . $user->full_name." (". $user->id. ")";
                $message = "Hi, <br><br>"._label('backend_student').": ".$user->first_name." ".$user->last_name." (".$user->email.") has approved a Course Suggestion";
                $message .= "<br><br>Title:".$row->title;
                $message .="<br><br><a href='".route('admin.auth.user.show', $user->id)."'>View Student Details</a>";
                send_mail_notification($user->id,"","COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT",$subject,$message);

                // Send Push App Notification
                $subject = "";
                $subject = "";
                $message = "Course Suggested is approved by "._label('backend_student').": " . $user->full_name." (". $user->id. ")" .
                $message .= "<br>Title:".$row->title;
                send_in_app_notification(
                    $user->id, 
                    $user->id, 
                    "COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT", 
                    $subject, 
                    $message,
                    "student", 
                );

                return redirect()->route('frontend.user.coursesuggestion')->withFlashSuccess("Course Suggestion Feedback submitted successfully");
            }
        } else {
            return redirect()->route('frontend.user.coursesuggestion')->withFlashDanger("Invalid Course Suggestion ID");
        }
    }

    public function approve($shortlist_id) {

        $done = CourseShortlisted::where('id', $shortlist_id)
        ->where('student_id', \Auth::user()->id)
        ->where('staff_suggested', 1)
        ->update(['student_approved' => 1]);

        if($done) {
            //Notify
            \Log::debug("Course shortlist: $shortlist_id Approved by Student!");
            $course = CourseShortlisted::join('university_courses', 'university_courses.id', '=', 'course_shortlisted.course_id')
            ->join('universities', 'universities.id', '=', 'university_courses.university')
            ->select('course_shortlisted.*','university_courses.course_name','university_courses.university','university_courses.study_level','university_courses.campus','university_courses.duration','university_courses.intakes','universities.university_name','universities.country')
            ->where('course_shortlisted.id', $shortlist_id)
            ->first();

            //$staff = User::find($course->staff_id);
            $student = \Auth::user();

        //Sending email Notification
            $subject = "Course Suggested is approved by student";
            $message = "Hi, <br><br>Student: ".$student->first_name." ".$student->last_name." (".$student->email.") has approved a Course Suggestion";
            $message .= "<br><br>Course:".$course->course_name;
            $message .= "<br>University:".$course->university_name . " / ".$course->campus." / ".get_country_name($course->country);
            $message .="<br><br><a href='".route('admin.auth.user.show', $student->id)."'>View Student Details</a>";
            send_mail_notification($student->id,"","COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT",$subject,$message);

            // Send Push App Notification
            $subject = "";
            $message .= "Course Suggestion approved by "._label('backend_student').". Course: ".$course->course_name;
            $message .= ", University: ".$course->university_name . " / ".$course->campus." / ".get_country_name($course->country);
            send_in_app_notification(
                $student->id, 
                $student->id, 
                "COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT", 
                $subject, 
                $message,
                "student", 
            );
            
            // if($staff) {
            //     $message = "Dear ".$staff->first_name."<br><br>Student: ".$student->first_name." ".$student->last_name." (".$student->email.") has approved a Course Suggestion";
            //     $message .= "<br><br>Course:".$course->course_name;
            //     $message .= "<br>University:".$course->university_name . " / ".$course->campus." / ".$course->country;
            //     $message .="<br><br><a href='".route('admin.auth.user.show', $student->id)."'>View Student Details</a>";

            //     try{
            //         $staff->notify(new UserAlert("Course Suggestion Approved", $message));
            //     }catch (\Exception $e) {
            //         $message = $e->getMessage();
            //         \Log::debug("Mail Error: (Course Suggestion Approved) ".$message);   
            //     }                
            // }

            return redirect()->route('frontend.user.coursesuggestion')->withFlashSuccess("Course Suggestion Approved Successfully");
        } else {
            return redirect()->route('frontend.user.coursesuggestion')->withFlashDanger("Something went wrong.");
        }
    }
}


