<?php

namespace App\Http\Controllers\Frontend\User;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

/**
 * Class DemoVideoController.
 */
class DemoVideoController extends Controller {

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index($folderid = 0) {
        $access_denied = false;
        $folders = array();
        $rows = DB::table('demo_class_category')->where('parent', $folderid)->get();
        if ($rows) {
            foreach ($rows as $row) {
                $folders[] = array("id" => $row->id, "name" => $row->name, "sharing" => $row->sharing);
            }
        }

        $cur_folder = $folderid;
        $folder_breadcrumb = array();
        $i = 0;
        while (true) {
            if ($cur_folder == 0) {
                $folder_breadcrumb[$i++] = array('id' => $cur_folder, 'name' => 'Videos');
                break;
            } else {
                $row = DB::table('demo_class_category')->where('id', $cur_folder)->first();
                $folder_breadcrumb[$i++] = array('id' => $row->id, 'name' => $row->name);
                $cur_folder = $row->parent;
            }
        }

        //docs
        $docs = array();
        if ($folderid > 0) {

            //check permissions
            $user = auth()->user();
            //\Log::debug("::LOGGEDINUSER id:" . $user->id);
            $allow_access = false;
            $folderinfo = DB::table('demo_class_category')->where('id', $folderid)->first();
            if ($folderinfo->sharing == 'public') {
                $allow_access = true;
            } elseif ($folderinfo->sharing == 'private') {
                if (DB::table('user_democlass_permission')->where(['userid' => $user->id, 'folderid' => $folderid ])->exists()) {
                    $allow_access = true;
                }                
            }

            if ($allow_access) {
                $rows = DB::table('demo_class_video')->where('folder', $folderid)->get();
                if ($rows) {
                    foreach ($rows as $row) {
                        $description = $row->description;
                        $docs[] = array("id" => $row->id, "title" => $row->title, "file" => $row->file_url, "description" => $description);
                    }
                }
            } else {
                $access_denied = true;
            }
        }
        return view('frontend.user.demovideo', ['folders' => $folders, 'docs' => $docs, 'folder_breadcrumb' => $folder_breadcrumb, 'current_folder' => $folderid, 'access_denied'=>$access_denied]);
    }

}
