<?php

namespace App\Http\Controllers\Frontend\User;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

/**
 * Class HostCountryInfoController.
 */
class HostCountryInfoController extends Controller {

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index($folderid = 0) {
        $access_denied = false;
        $folders = array();
        $rows = DB::table('country_info_folder')->where('parent', $folderid)->get();
        if ($rows) {
            foreach ($rows as $row) {
                $folders[] = array("id" => $row->id, "name" => $row->name, "sharing" => $row->sharing);
            }
        }

        $cur_folder = $folderid;
        $folder_breadcrumb = array();
        $i = 0;
        while (true) {
            if ($cur_folder == 0) {
                $folder_breadcrumb[$i++] = array('id' => $cur_folder, 'name' => ( __('labels.frontend.user.profile.documents') ));
                break;
            } else {
                $row = DB::table('country_info_folder')->where('id', $cur_folder)->first();
                $folder_breadcrumb[$i++] = array('id' => $row->id, 'name' => $row->name);
                $cur_folder = $row->parent;
            }
        }

        //docs
        $docs = array();
        if ($folderid > 0) {

            //check permissions
            $user = auth()->user();
            //\Log::debug("::LOGGEDINUSER id:" . $user->id);
            $allow_access = false;
            $folderinfo = DB::table('country_info_folder')->where('id', $folderid)->first();
            if ($folderinfo->sharing == 'public') {
                $allow_access = true;
            } elseif ($folderinfo->sharing == 'member') {
                if (DB::table('user_academics')->where('userid', $user->id)->exists()) {
                    $allow_access = true;
                }
            } elseif ($folderinfo->sharing == 'private') {
                if (DB::table('user_folder_permission')->where(['userid' => $user->id, 'folderid' => $folderid ])->exists()) {
                    $allow_access = true;
                }                
            }

            if ($allow_access) {
                $rows = DB::table('country_info_doc')->where('folder', $folderid)->get();
                if ($rows) {
                    foreach ($rows as $row) {
                        $description = $row->description;
                        $filepath = url('storage/' . $row->file);
                        $docs[] = array("id" => $row->id, "title" => $row->title, "file" => $filepath, "description" => $description);
                    }
                }
            } else {
                $access_denied = true;
            }
        }
        return view('frontend.user.hostcountryinfo', ['folders' => $folders, 'docs' => $docs, 'folder_breadcrumb' => $folder_breadcrumb, 'current_folder' => $folderid, 'access_denied'=>$access_denied]);
    }

}
