<?php

namespace App\Http\Controllers\Frontend\User;

use App\Models\Auth\BatchStudents;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Repositories\Frontend\Auth\UserRepository;
use App\Recipients\AdminRecipient;
use App\Notifications\Frontend\AdminAlert;
use App\Mail\MailSend;
use Illuminate\Support\Facades\Mail;
use App\Http\Requests\Frontend\User\MyCourseRequest;
use App\Models\Auth\Attendance;
use App\Models\Auth\Chat;
use App\Models\Auth\StudentOnlineCourse;

/**
 * Class MyCoursesController.
 */
class MyCoursesController extends Controller
{

    public $max_exam_attempt = 0;

    public function myCoachingClasses()
    {

        $userid = \Auth::user()->id;
        $this->max_exam_attempt = config('site_configs.exam.max_attempts');
        $courseObj = DB::table('batch_students')
            ->select('batch.code', 'batch.start_date', 'batch.days', 'courses.title', 'branch.branch_name', 'batch.start_hour', 'batch.start_min', 'batch.end_hour', 'batch.end_min', 'batch.id', 'batch.status', 'users.first_name', 'users.last_name', 'meeting_rooms.zoom_id')
            ->join('batch', 'batch.id', '=', 'batch_students.batch')
            ->leftJoin('courses', 'courses.id', '=', 'batch.course')
            ->join('branch', 'branch.id', '=', 'batch.branch')
            ->join('users', 'users.id', '=', 'batch.trainer')
            ->leftJoin('meeting_rooms', 'batch.meeting_room', '=', 'meeting_rooms.room_name')
            ->where('batch_students.student', $userid)
            ->orderBy('batch.created_at', 'DESC')
            ->get();
        $examObj = $onlineCourseObjects = $valid_exam_details = $total_attempts = $validated_exam = array();
        $today = date('Y-m-d 00:00:00');
        $student_batch_info = DB::table('batch_students')->select('batch_students.*', 'batch.course')->join('batch', 'batch.id', '=', 'batch_students.batch')->where('student', $userid)->get();

        if ($courseObj) {
            foreach ($student_batch_info as $each_batch_data) {
                $examDetails = '';
                $examDetails =  DB::table('exam')
                    ->select('exam.*', 'courses.title', 'courses.id as course_id')
                    ->join('batch', 'batch.id', '=', 'exam.batch_id')
                    ->join('courses', 'courses.id', '=', 'batch.course')
                    ->where('batch_id', '=', $each_batch_data->batch)
                    ->get();
                $examObj[$each_batch_data->batch] =  $examDetails;


                //---------check for exam completed / Validated -------------------------
                foreach ($examDetails as $eachExamDetail) {
                    $chk_attempt = DB::table('student_exams')
                        ->select('attempt')
                        ->where('exam_id', $eachExamDetail->id)
                        ->where('student_id', $userid)
                        ->where('completed', 1)
                        ->orderBy('attempt', 'DESC')
                        ->limit(1)->first();

                    empty($chk_attempt->attempt)  ? $attempted = '0' : $attempted = $chk_attempt->attempt;
                    $total_attempts[$each_batch_data->batch][$eachExamDetail->id] = $attempted;

                    if (!empty($attempted) && $attempted >= $this->max_exam_attempt) {
                        $valid_exam_details[$each_batch_data->batch][$eachExamDetail->id] = false;
                    } else {
                        $valid_exam_details[$each_batch_data->batch][$eachExamDetail->id] = true;
                    }


                    $chk_validated = DB::table('student_exam_result')
                        ->where('exam_id', $eachExamDetail->id)
                        ->where('student_id', $userid)
                        ->limit(1)->first();
                    empty($chk_validated->id)  ? $validated = '0' : $validated = 1;
                    $validated_exam[$each_batch_data->batch][$eachExamDetail->id] = $validated;
                }
                //-----------------------------------------------------------
                $onlineCourseObjects[$each_batch_data->batch] =  BatchStudents::getOnlineCourseObjByStudentIdAndBatchId($userid, $each_batch_data->batch);
            }
        } else {
            $examObj = $onlineCourseObjects = array();
        }

        return view('frontend.user.myclasses', ['courseObj' => $courseObj, 'onlineCourseObjects' => $onlineCourseObjects, 'examObj' => $examObj, 'student_batch_info' => $student_batch_info, 'valid_exam_details' => $valid_exam_details, 'validated_exam' => $validated_exam, 'total_attempts' => $total_attempts]);
    }


    public function rating(Request $request, $id)
    {
        $userid = \Auth::user()->id;
        $today = date("Y-m-d");
        $reviews = DB::table('batch')
            ->select('courses.title', 'branch.branch_name', 'batch.id')
            ->join('courses', 'courses.id', '=', 'batch.course')
            ->join('branch', 'branch.id', '=', 'batch.branch')
            ->where('batch.id', $id)
            ->get();
        $ratings = count(DB::table('trainer_student_attendance')
            ->where('batch_id', $id)->where('student_id', $userid)->where('date', $today)
            ->get());
        $pages = DB::table('batch')
            ->select('batch.start_date', 'batch.end_date', 'trainer_attendance.date', 'trainer_attendance.topics', 'batch.totalduration', 'trainer_attendance.duration')
            ->join('trainer_attendance', 'trainer_attendance.batch_id', '=', 'batch.id')
            ->where('trainer_attendance.batch_id', $id)
            ->orderBy('trainer_attendance.date', "DESC")
            ->get();
        $check = count(DB::table('trainer_attendance')
            ->where('batch_id', $id)
            ->get());
        if ($check != 0) {
            $calc = DB::table('batch')->select('totalduration')->where('id', $id)->first();

            $calculate = DB::table('trainer_attendance')->select('duration')->where('batch_id', $id)->sum('duration');

            if ($calc->totalduration == 0) {
                $finalcalc = 0;
            } else {
                $finalcalc = (($calculate / $calc->totalduration) * 100);
                if ($finalcalc < 1) {
                    $finalcalc = round($finalcalc, 1);
                } elseif ($finalcalc > 100) {
                    $finalcalc = 100;
                } else {
                    $finalcalc = floor($finalcalc);
                }
            }

            return view('frontend.user.rating', ['reviews' => $reviews, 'ratings' => $ratings, 'pages' => $pages, 'finalcalc' => $finalcalc]);
        } else {
            $finalcalc = 0;
            return view('frontend.user.rating', ['reviews' => $reviews, 'ratings' => $ratings, 'pages' => $pages, 'finalcalc' => $finalcalc]);
        }
    }

    public function messages($id)
    {
        $userid = \Auth::user()->id;

        $mybatch = DB::table('batch_students')
            ->select('id')
            ->where('batch', '=', $id)
            ->where('student', '=', $userid)
            ->get();
        if (count($mybatch)) {
            $messages = DB::table('batch')
                ->select('courses.title', 'branch.branch_name', 'batch.id', 'batch.days', 'batch.start_hour', 'batch.start_min', 'batch.end_hour', 'end_min')
                ->join('courses', 'courses.id', '=', 'batch.course')
                ->join('branch', 'branch.id', '=', 'batch.branch')
                ->where('batch.id', $id)
                ->get();

            $trainerid = DB::table('batch')
                ->select('users.id')
                ->join('courses', 'courses.id', '=', 'batch.course')
                ->join('branch', 'branch.id', '=', 'batch.branch')
                ->join('users', 'users.id', '=', 'batch.trainer')
                ->where('batch.id', $id)
                ->first();

            return view('frontend.user.studentchat', ['messages' => $messages, 'userid' => $userid, 'trainerid' => $trainerid]);
        } else {
            return abort(404);
        }
    }



    public function stored(MyCourseRequest $request, $id)
    {
        $today = date("Y-m-d");
        $userid = \Auth::user()->id;
        \Log::debug("save attendance: $today student:$userid batch:$id");

        $row_exists = DB::table('attendance')->where('student_id', $userid)->where('batch_id', $id)->where('date', $today)->first();
        if ($row_exists) {
            \Log::debug("save attendance: $today student:$userid batch:$id - Row already exists");
            return redirect()->route('frontend.user.review.rating', $id)->withFlashDanger('Review already exists!');
        }

        try {
            \Log::debug("save attendance: $today student:$userid batch:$id - Inserting");
            $insert_id = DB::table('attendance')->insertGetId([
                'student_id' => $userid,
                'batch_id' => $id,
                'date' => $today,
                'rating' => $request->get('rating'),
                'review' => $request->get('review'),
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s")
            ]);

            if ($insert_id) {
                \Log::debug("save attendance: $today student:$userid batch:$id - Inserted successfully. ID: $insert_id");
                return redirect()->route('frontend.user.review.rating', $id)->withFlashSuccess('Review Added Successfully!');
            } else {
                \Log::debug("save attendance: $today student:$userid batch:$id - Not Inserted!");
                return redirect()->route('frontend.user.review.rating', $id)->withFlashDanger('Error occured!');
            }
        } catch (\Illuminate\Database\QueryException $ex) {
            $err_msg = $ex->getMessage();
            \Log::debug("save attendance: $today student:$userid batch:$id - Exception: $err_msg");
            return redirect()->route('frontend.user.review.rating', $id)->withFlashDanger('Database Error occured!');
        }
    }

    public function myOnlineCourses()
    {
        $courses = StudentOnlineCourse::join('online_course', 'online_course.id', '=', 'student_online_course.online_course_id')
            ->where('student_id', auth()->user()->id)
            ->orderBy('student_online_course.created_at', 'DESC')
            ->get();

        return view('frontend.user.myonlinecourses', compact('courses'));
    }
}
