<?php

namespace App\Http\Controllers\Frontend\User;

use App\Models\Auth\BatchStudents;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Repositories\Frontend\Auth\UserRepository;
use App\Recipients\AdminRecipient;
use App\Notifications\Frontend\AdminAlert;
use App\Mail\MailSend;
use Illuminate\Support\Facades\Mail;
use App\Http\Requests\Frontend\User\MyCourseRequest;
use App\Models\Auth\Attendance;
use App\Models\Auth\Chat;
use Illuminate\Support\Str;

/**
 * Class MyExamController.
 */
class MyExamController extends Controller {
    
    public $max_exam_attempt = 0;
    
    public function index() {
      $userid = \Auth::user()->id;
      $this->max_exam_attempt = config('site_configs.exam.max_attempts');
    }
    
    
    
    
  public function results(Request $request, $batch_id, $exam_id) {
      $userid = \Auth::user()->id;
      $today = date("Y-m-d");
      $student_batch_id = (int)$batch_id;
      $this->max_exam_attempt = config('site_configs.exam.max_attempts');
      
      $batch_info = DB::table('batch')->where('id', $student_batch_id)->first();
      $course_info = DB::table('courses')->where('id', $batch_info->course)->first();
      $examObj = DB::table('exam')->where('id','=', $exam_id)->first();
      
      
      $exams_validated = DB::table('student_exam_result')->where('exam_id',$exam_id)->where('student_id',$userid)->get();
      
      //$exams_validated = DB::table('student_exam_result')
      //                                    ->select('student_exam_result.*','exam.type as exam_type', 'exam.exam_date as exam_date', 'exam.objective_question_count', 'exam.essay_question_count', 'exam.comprehension_question_count', 'exam.total_questions as exam_total_questions', 'exam.total_marks as exam_total_marks')
      //                                    ->leftJoin('exam', 'exam.id', '=', 'student_exam_result.exam_id')
      //                                    ->where('student_exam_result.exam_id',$exam_id)
      //                                    ->where('student_exam_result.student_id',$userid)->get();
      
      
      $max_attempt = DB::table('student_exams')->where('exam_id',$exam_id)->where('student_id',$userid)->max('attempt');;
      $highest_score = $highest_score_id = '';
      foreach($exams_validated as $eachExam){
        
          $student_exams_details = DB::table('student_exams')->where('exam_id',$exam_id)->where('student_id',$userid)->where('completed',1)->where('attempt',$eachExam->attempt)->limit(1)->first();
          $total_questions = DB::table('student_exam_answers')->where('student_exam_id',$student_exams_details->id)->count();
          $correct_ans_cnt = DB::table('student_exam_answers')->where('student_exam_id',$student_exams_details->id)->where('correct',1)->count();
          
          $eachExam->total_questions = $total_questions;
          $eachExam->correct_ans_cnt = $correct_ans_cnt;
          $eachExam->percentage = ($eachExam->score/$eachExam->total_exam_marks)*100;
          
          if($eachExam->passed == 1 && ($highest_score_id == '' || $highest_score =='' || $highest_score < $eachExam->score)){
            $highest_score = $eachExam->score;
            $highest_score_id = $eachExam->id;
          }
        
      }
      
      //echo '<pre>';
      //print_r($max_attempt);
      //exit();
      
      
      return view('frontend.user.exams', ['course_info' => $course_info, 'result_page'=>1,'student_batch_id'=>$student_batch_id,'max_exam_attempt'=>$this->max_exam_attempt,'exams_validated'=>$exams_validated,'examObj'=>$examObj,'max_attempt'=>$max_attempt, 'highest_score_id'=>$highest_score_id] );       
  }
    
    
    
    
    
  //public function results(Request $request, $batch_id, $type) {
  //    $userid = \Auth::user()->id;
  //    $today = date("Y-m-d");
  //    $student_batch_id = (int)$batch_id;
  //    $this->max_exam_attempt = config('site_configs.exam.max_attempts');
  //    
  //    $batch_info = DB::table('batch')->where('id', $student_batch_id)->first();
  //    $course_info = DB::table('courses')->where('id', $batch_info->course)->first();
  //    $examObj = DB::table('exam')->where('batch_id','=', $student_batch_id)->where('type','=',$type)->first();
  //    
  //    //need validation--------------
  //    
  //    //-----------------------------
  //  
  //    //--------------- Storing each attempt to array ----------------
  //    $answer_details = DB::table('student_exam_answer')->where('exam_id',$examObj->id)->where('student_id',$userid)->get();
  //    
  //    
  //    //echo "<pre>";
  //    //print_r($answer_details);
  //    //exit();
  //    
  //    if(!empty($answer_details) && !$answer_details->isEmpty()){
  //      $exam_results = $best_score = array();
  //      foreach($answer_details as $each_answer_data){
  //        
  //        if(!isset($exam_results[$each_answer_data->attempt]['correct']))
  //          $exam_results[$each_answer_data->attempt]['correct'] =0;
  //        if(!isset($exam_results[$each_answer_data->attempt]['wrong']))
  //          $exam_results[$each_answer_data->attempt]['wrong'] =0;
  //        
  //          !isset($exam_results[$each_answer_data->attempt]['count']) ? $exam_results[$each_answer_data->attempt]['count'] = 1: $exam_results[$each_answer_data->attempt]['count'] ++;
  //          
  //          if($each_answer_data->correct == 1){
  //            !isset($exam_results[$each_answer_data->attempt]['correct']) ? $exam_results[$each_answer_data->attempt]['correct'] = 1: $exam_results[$each_answer_data->attempt]['correct'] ++;
  //          }
  //          else{
  //            !isset($exam_results[$each_answer_data->attempt]['wrong']) ? $exam_results[$each_answer_data->attempt]['wrong'] = 1: $exam_results[$each_answer_data->attempt]['wrong'] ++;
  //          }
  //      }
  //      //-------------------------------------------------------------
  //      
  //      //echo "<pre>";
  //      //print_r($exam_results);
  //      //exit();
  //      
  //      //------------------finding the best score---------------------
  //      $best_score = $exam_results;
  //      $best_score = array_reduce($best_score, function ($a, $b) {
  //          return @$a['correct'] > $b['correct'] ? $a : $b ;
  //      });
  //      //------------------------------------------------------------
  //      
  //      $total_count = $best_score['count'];
  //      $correct_answer_cnt = $best_score['correct'];
  //      $percentage = ($correct_answer_cnt / $total_count)*100;
  //    }
  //    else{
  //        $percentage = 0;
  //        $correct_answer_cnt = 0;
  //    }
  //    $percentage = round($percentage , 2);
  //    return view('frontend.user.exams', ['course_info' => $course_info, 'examObj'=>$examObj, 'result_page'=>1,'percentage'=>$percentage, 'correct_answer_cnt'=>$correct_answer_cnt,'attempt' => $this->max_exam_attempt +1,'student_batch_id'=>'','max_exam_attempt'=>$this->max_exam_attempt] );       
  //}
    
  
  
  public function exams(Request $request, $batch_id, $type, $exam_id, $action='') {
    $userid = \Auth::user()->id;
    $this->max_exam_attempt = config('site_configs.exam.max_attempts');
    $today = date("Y-m-d");
    $answer_array = $post_data = array();
    $student_batch_id = (int)$batch_id;
    $student_exam_id = (int)$exam_id;
    $exam_finished = $error_on_question = false;
    
    //$student_info = DB::table('batch_students')->where('student', $userid)->first();
    $batch_info = DB::table('batch')->where('id', $student_batch_id)->first();
    $course_info = DB::table('courses')->where('id', $batch_info->course)->first();
    $examObj = DB::table('exam')->where('batch_id','=', $student_batch_id)->where('type','=',$type)->where('id','=',$student_exam_id)->first();
    
    // Validating exam date reached----------
    if(strtotime($examObj->exam_date) > strtotime(date('Y-m-d H:i:s')) || !isset($course_info) || empty($course_info) || !isset($examObj) || empty($examObj)){
          return redirect()->route('frontend.user.myclasses')->withFlashDanger('You have attempted all the exams!');
    }
    //---------------------------------------
    if($action == ''){
        return view('frontend.user.exams', ['course_info' => $course_info, 'examObj'=>$examObj, 'question_no'=>'','student_batch_id'=>$student_batch_id,'question_no'=>0]);
    }
    elseif($action != ''){
      
      //checking for valid exam
      $valid_question_details = DB::table('student_exams')
      ->where('exam_id',$examObj->id)
      ->where('student_id',$userid)
      ->where('completed',0)
      ->limit(1)->first();
        
      if(isset($valid_question_details) && $valid_question_details->id >= 1 && $valid_question_details->completed == 0)
      {
        $comprehension_text = '';
        $student_exam_id = $valid_question_details->id;
        $attempt = $valid_question_details->attempt;
        $iifl_exam_id = $valid_question_details->exam_id;
        $exam_started_time = $valid_question_details->exam_started_at;
        $total_questions = DB::table('student_exam_answers')->where('student_exam_id',$student_exam_id)->count();
        $has_essay_questions = DB::table('student_exam_answers')->where('student_exam_id',$student_exam_id)->where('question_type','essay')->count();
        
        
        //---------Checking - submited within the duration ---------
        $current_time = date('Y-m-d H:i:s');
        $current_timestamp = strtotime($current_time);
        $exam_end_timestamp = strtotime($valid_question_details->exam_started_at.' + '.$examObj->duration.' Minutes');
        //No need to validate the exam end date----
        if($current_timestamp > $exam_end_timestamp){
          $exam_finished = true;
        }
        //----------------------------------------------------------
        
        
        //---------Saving the results----------------------
        if($request->method() == 'POST'){
            $post_data = $request->all();
            $sea_id = isset($post_data['sea_id']) ? (int)$post_data['sea_id'] : '';
            $answer_arr = isset($post_data['answer']) ? $post_data['answer'] : '';
            if(isset($post_data['previous_qs'])){
                //Do nothing ----
            }
            else if(!empty($answer_arr) && $sea_id > 0){
              if(!$exam_finished){
                $answer_data = implode(',',$answer_arr);
                DB::table('student_exam_answers')->where('id',$sea_id)->update(['answers' => $answer_data]);
              }
            }
            else if($student_exam_id == $request->get('student_exam_id') && !$exam_finished){
              //------------File upload-------------------------
              
              if ($request->hasFile('exam_snapshots')) {
                  $files = $request->file('exam_snapshots');
                  foreach($files as $file){
                    $filename = $file->getClientOriginalName();
                    if($file->getSize() > 0){
                        \Log::debug("Exam snapshot uploading:" . $filename);
                        $filename = str_replace(" ", "-", $filename);
                        $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
                        if (strlen($filename) > 60) {
                            $filename = substr($filename, 0, 60);
                        }
                        $filename = $filename . Str::random(20) . "." . $file->getClientOriginalExtension();
                        $path = $file->storeAs('/exams', $filename , 'public');
                        \Log::debug("::savedpath::$path");
                        DB::table('student_exam_answers')->insert(["student_exam_id" => $student_exam_id, "documents" =>$path]);
                    }
                  }
              }
              //-----------------------------------------------
            }
            else{
                isset($post_data['next_qs']) ? $post_data['next_qs'] = (int)$post_data['next_qs'] - 1 : $post_data['next_qs'] =0;
                isset($post_data['previous_qs']) ? $post_data['previous_qs'] = (int)$post_data['previous_qs'] + 1  : $post_data['previous_qs'] =0;                    
            }
        }
        //-------------------------------------------------
            
            $valid_exam_attempt = $valid_question_details->attempt;
            if($exam_finished || (isset($post_data['sub_all_ans']) && (int)$post_data['sub_all_ans'] == 1)){
                            
                if($exam_finished && (!isset($attempt) || $attempt == '')){
                  $attempt = $valid_question_details->attempt;
                }
                else if(!isset($attempt) || $attempt == ''){
                  $attempt = $post_data['attempt'];
                }
                $answer_details = DB::table('student_exam_answers')->where('student_exam_id',$student_exam_id)->where('question_type','objective')->where('documents','=','')->where('order','<>','999999')->get();
                
                $correct_answer_cnt = 0;
                foreach($answer_details as $each_answer_data){
                    $question_n_answer = DB::table('q_a')->where('id',$each_answer_data->qa_id)->limit(1)->first();
                    $correct_answer = $question_n_answer->answers;
                    $answer_type = $question_n_answer->answer_type;
                    
                    if($answer_type == 'single'){
                        if(trim($each_answer_data->answers) == trim($correct_answer)){
                            DB::table('student_exam_answers')->where('id',$each_answer_data->id)->update(['correct' => 1]);
                            $correct_answer_cnt++;
                        }
                    }
                    else if($answer_type == 'multiple'){
                        $student_answer_arr = explode(',',$each_answer_data->answers);
                        $correct_answer_arr = explode(',',$correct_answer);
                        if($student_answer_arr === array_intersect($student_answer_arr, $correct_answer_arr) && $correct_answer_arr === array_intersect($correct_answer_arr, $student_answer_arr)) {
                            DB::table('student_exam_answers')->where('id',$each_answer_data->id)->update(['correct' => 1]);
                            $correct_answer_cnt++;
                        }                      
                    }
                    DB::table('student_exam_answers')->where('id',$each_answer_data->id)->where('answers','')->update(['answers' => '-']);
                }
                
                
                
              DB::table('student_exams')->where('id',$student_exam_id)->update(['completed' => '1']);
              $this->update_objective_results($student_exam_id);
              
              if($exam_finished){
                return redirect()->route('frontend.user.myclasses')->withFlashDanger('You have attempted all the exams!');
              }else{
                
                return redirect()->route('frontend.user.myclasses')->withFlashSuccess('Your answers submitted succesfully!');
                //$data = array('success' => true, 'message' => 'Successfully uploaded file.');
                //return response()->json($data, 200);
              }

                
            }
            else if($action == 'start' || isset($post_data['next_qs']) || (int)$post_data['next_qs'] > 0 || isset($post_data['previous_qs']) || (int)$post_data['previous_qs'] > 0 || isset($post_data['upload_documents'])){
                
              if(isset($post_data['upload_documents']) && $post_data['upload_documents'] == 1){
                $question_order_no = 'Snapshots';
                $upcoming_question = $answer = $sea_id = '';
                $exam_end_time = date('Y-m-d H:i:s', $exam_end_timestamp);
              }
              else
              {
                if(isset($post_data['next_qs']) && (int)$post_data['next_qs'] > 0 && $post_data['next_qs'] <= $total_questions){
                    $question_details = DB::table('student_exam_answers')->where('order',(int)$post_data['next_qs'])->where('student_exam_id',$student_exam_id)->limit(1)->first();
                }
                else if(isset($post_data['previous_qs']) && (int)$post_data['previous_qs'] > 0  && $post_data['previous_qs'] <= $total_questions){
                    $question_details = DB::table('student_exam_answers')->where('order',(int)$post_data['previous_qs'])->where('student_exam_id',$student_exam_id)->limit(1)->first();
                }
                else{
                    $question_details = DB::table('student_exam_answers')->where('student_exam_id',$student_exam_id)->orderBy('order','ASC')->limit(1)->first();
                }
                $comprehension_text = '';                                   
                if(!empty($question_details)){
                  
                  if($question_details->question_model == 'comprehension'){
                    $upcoming_question = DB::table('q_a')
                                                        ->select('q_a.*','q_a_comprehension_text.content as comprehension_text')
                                                        ->leftJoin('q_a_comprehension_text', 'q_a_comprehension_text.id', '=', 'q_a.comprehension_id')
                                                        ->where('q_a.id',$question_details->qa_id)->first();
                                                        
                    //$upcoming_question = DB::table('q_a')->where('comprehension_id',$question_details->comprehension_id)->get();
                    //$comprehension_text =  DB::table('q_a_comprehension_text')->where('id',$question_details->comprehension_id)->first();
                    //
                    
                    $question_order_no = $question_details->order;
                    $sea_id = $question_details->id;
                    $answer_array = explode(',',$question_details->answers);            
                    
                  }
                  else{
                    $upcoming_question = DB::table('q_a')->where('id',$question_details->qa_id)->first();
                    $question_order_no = $question_details->order;
                    $sea_id = $question_details->id;
                    $answer_array = explode(',',$question_details->answers);            
                  }
                  
                    $exam_end_time = date('Y-m-d H:i:s', $exam_end_timestamp);
                    
                    
                  //echo "<pre>";
                  //print_r($upcoming_question);
                  //exit();
                  
                }
                else{
                  $error_on_question = true;
                  $question_order_no = $attempt = $upcoming_question = $comprehension_text = $answer_array = $sea_id = $student_batch_id = $exam_end_time = '';
                }
              }
            }

        
      }        
      else
      {
     //There is no exam which is started and not completed.
     //Need to validate for attempt number.
     //inserting new exam data to table student_exam_answer from q_a
        $comprehension_text = '';
        $last_exam_details = DB::table('student_exams')->select('attempt')->where('exam_id',$examObj->id)->where('student_id',$userid)->orderBy('attempt','DESC')->orderBy('id','DESC')->limit(1)->first();
        if(isset($last_exam_details)){
            $last_attempt_number = $last_exam_details->attempt;
        }
        else{
            $last_attempt_number = 0;
        }
        
        if($last_attempt_number < $this->max_exam_attempt){
            $obj_question_details_rea = $obj_question_details_wri = $obj_question_details_lis = $essay_question_details =$comp_question_details = array();
            $obj_qst_limt = round($examObj->objective_question_count / 3);
            //$missing_cnt = $examObj->objective_question_count - ($obj_qst_limt * 3 );
            //$obj_qst_limt2 = $obj_qst_limt + $missing_cnt;
            $chapters_arr = explode(',',substr(trim($examObj->chapters),1,-1));
            
            //validating objective question limits - need to find out total questions available -----------------
            //Problem with less number of questions in each category and need to distribute the question equally.
            //assuming atleast one category(reading/writing/listening) has more quetions. so the missed question will add from any of the type with an order.
            
            if(!empty($chapters_arr)){
                $count_listening = DB::table('q_a')
                                    ->select(DB::raw('count(id) as total'))
                                    ->where('course_id',$course_info->id)
                                    ->where('question_model','obj_essay')
                                    ->where('question_type','objective')
                                    ->where('category','listening')
                                    ->where('status','1')
                                    ->whereIn('chapter',$chapters_arr)
                                    ->first();
                                    
                $count_reading = DB::table('q_a')
                                    ->select(DB::raw('count(id) as total'))
                                    ->where('course_id',$course_info->id)
                                    ->where('question_model','obj_essay')
                                    ->where('question_type','objective')
                                    ->where('category','reading')
                                    ->where('status','1')
                                    ->whereIn('chapter',$chapters_arr)
                                    ->first();
                                    
                $count_writing = DB::table('q_a')
                                    ->select(DB::raw('count(id) as total'))
                                    ->where('course_id',$course_info->id)
                                    ->where('question_model','obj_essay')
                                    ->where('question_type','objective')
                                    ->where('category','writing')
                                    ->where('status','1')
                                    ->whereIn('chapter',$chapters_arr)
                                    ->first();
                
            }
            else{
                
                $count_listening = DB::table('q_a')
                                    ->select(DB::raw('count(id) as total'))
                                    ->where('course_id',$course_info->id)
                                    ->where('question_model','obj_essay')
                                    ->where('question_type','objective')
                                    ->where('category','listening')
                                    ->where('status','1')
                                    ->first();
                                    
                $count_reading = DB::table('q_a')
                                    ->select(DB::raw('count(id) as total'))
                                    ->where('course_id',$course_info->id)
                                    ->where('question_model','obj_essay')
                                    ->where('question_type','objective')
                                    ->where('category','reading')
                                    ->where('status','1')
                                    ->first();
                                    
                $count_writing = DB::table('q_a')
                                    ->select(DB::raw('count(id) as total'))
                                    ->where('course_id',$course_info->id)
                                    ->where('question_model','obj_essay')
                                    ->where('question_type','objective')
                                    ->where('category','writing')
                                    ->where('status','1')
                                    ->first();
                
            }
            
            //echo "<br> Total Exis : List ".($count_listening->total);
            //echo "<br>-----------------------<br>";
            //echo "<br> Total Exis : Read ".($count_reading->total);
            //echo "<br>-----------------------<br>";
            //echo "<br> Total Exis : Wrie ".($count_writing->total);
            //echo "<br>*-----------------------*************------------------<br>";
            
            
            
            if($count_listening->total > $obj_qst_limt){
                $listening_qs_cnt = $obj_qst_limt;
            }
            else{
                $listening_qs_cnt = $count_listening->total;
            }
            
            if($count_reading->total > $obj_qst_limt){
                $reading_qs_cnt = $obj_qst_limt;
            }
            else{
                $reading_qs_cnt = $count_reading->total;
            }
            
            if($count_writing->total > $obj_qst_limt){
                $writing_qs_cnt = $obj_qst_limt;
            }
            else{
                $writing_qs_cnt = $count_writing->total;
            }
            
           $missed_count = $examObj->objective_question_count - ($reading_qs_cnt + $listening_qs_cnt + $writing_qs_cnt);
           
            //echo "<br> Total required : List ".($listening_qs_cnt);
            //echo "<br>-----------------------<br>";
            //echo "<br> Total required : Writ ".($writing_qs_cnt);
            //echo "<br>-----------------------<br>";
            //echo "<br> Total required : Read ".($reading_qs_cnt);
            //echo "<br>*-----------------------*************------------------<br>";
            //echo "<br> Total Missd : ".($missed_count);
            //echo "<br>*-----------------------*************------------------<br>";
            
            if($missed_count > 0){
                //find the max count------ and fix - find max value and return key - order by max to min, to store the question
                $array_qs_cnt_list = array('listening'=>$count_listening->total, 'writing'=>$count_writing->total, 'reading'=>$count_reading->total);
                arsort($array_qs_cnt_list);
                
                foreach($array_qs_cnt_list as $key=>$val){
                    if($missed_count > 0){
                        if(${'count_'.$key}->total >= ($obj_qst_limt + $missed_count)){
                            ${$key.'_qs_cnt'} = $obj_qst_limt + $missed_count;
                        }
                        else{
                            ${$key.'_qs_cnt'} = ${'count_'.$key}->total;
                        }
                        $missed_count = $examObj->objective_question_count - ($reading_qs_cnt + $listening_qs_cnt + $writing_qs_cnt);
                    }
                    else{
                        break;
                    }
                }                
                
                //if($count_listening->total >= ($obj_qst_limt + $missed_count)){
                //    $listening_qs_cnt = $obj_qst_limt + $missed_count;
                //}
                //elseif($count_writing->total >= ($obj_qst_limt + $missed_count)){
                //   $writing_qs_cnt = $obj_qst_limt + $missed_count;
                //}
                //elseif($count_reading->total >= ($obj_qst_limt + $missed_count)){
                //    $reading_qs_cnt = $obj_qst_limt + $missed_count;
                //}
            }
            //---------------------------------------------------------------------------------------------------
            
            
            //-------------This working with all questions------------            
            //$comp_passage_details = DB::table('q_a_comprehension_text')->where('course_id',$course_info->id)->where('status','1')->inRandomOrder()->limit($examObj->comprehension_question_count)->get();
            //
            //
            //foreach($comp_passage_details as $comp_passage_each){
            //    $comp_passage_each->question_model = 'comprehension';
            //    $comp_passage_each->questions = DB::table('q_a')->where('course_id',$course_info->id)->where('question_model','comprehension')->where('status','1')->where('comprehension_id',$comp_passage_each->id)->get();
            //}
            //----------------------------------------------------------                                                     
                                                
            if(!empty($chapters_arr)){
                
                $obj_question_details_lis = DB::table('q_a')->where('course_id',$course_info->id)->where('question_model','obj_essay')->where('question_type','objective')->where('category','listening')->where('status','1')->whereIn('chapter',$chapters_arr)->inRandomOrder()->limit($listening_qs_cnt)->get();
                
                $obj_question_details_rea = DB::table('q_a')->where('course_id',$course_info->id)->where('question_model','obj_essay')->where('question_type','objective')->where('category','reading')->where('status','1')->whereIn('chapter',$chapters_arr)->inRandomOrder()->limit($reading_qs_cnt)->get();
                
                $obj_question_details_wri = DB::table('q_a')->where('course_id',$course_info->id)->where('question_model','obj_essay')->where('question_type','objective')->where('category','writing')->where('status','1')->whereIn('chapter',$chapters_arr)->inRandomOrder()->limit($writing_qs_cnt)->get();
                
                
                
                $essay_question_details = DB::table('q_a')->where('course_id',$course_info->id)->where('question_model','obj_essay')->where('question_type','essay')->where('status','1')->whereIn('chapter',$chapters_arr)->inRandomOrder()->limit($examObj->essay_question_count)->get();
                
                //$comp_passage_details = DB::table('q_a_comprehension_text')
                //                                                        ->select(DB::raw("substring_index(group_concat(id ORDER BY rand()), ',',".$examObj->comprehension_question_count.") as comp_ids"))
                //                                                        ->where('course_id',$course_info->id)->where('status','1')
                //                                                        ->whereIn('chapter',$chapters_arr)
                //                                                        ->first();                
                $comp_passage_details = DB::select("SELECT substring_index(group_concat(id ORDER BY rand()), ',','".$examObj->comprehension_question_count."') as comp_ids FROM `q_a_comprehension_text` WHERE `course_id` = '".$course_info->id."' AND `status` = 1 AND `chapter` IN (".implode(',',$chapters_arr).") AND (SELECT count(id) FROM `q_a` WHERE `q_a`.`comprehension_id` = q_a_comprehension_text.id AND q_a.status = 1) > 0 LIMIT 1");
            }
            else{
                $obj_question_details_lis = DB::table('q_a')->where('course_id',$course_info->id)->where('question_model','obj_essay')->where('question_type','objective')->where('category','listening')->where('status','1')->inRandomOrder()->limit($listening_qs_cnt)->get();
                
                $obj_question_details_rea = DB::table('q_a')->where('course_id',$course_info->id)->where('question_model','obj_essay')->where('question_type','objective')->where('category','reading')->where('status','1')->inRandomOrder()->limit($reading_qs_cnt)->get();
                
                $obj_question_details_wri = DB::table('q_a')->where('course_id',$course_info->id)->where('question_model','obj_essay')->where('question_type','objective')->where('category','writing')->where('status','1')->inRandomOrder()->limit($writing_qs_cnt)->get();
                
                $essay_question_details = DB::table('q_a')->where('course_id',$course_info->id)->where('question_model','obj_essay')->where('question_type','essay')->where('status','1')->inRandomOrder()->limit($examObj->essay_question_count)->get();
                
                //$comp_passage_details = DB::table('q_a_comprehension_text')
                //                                                        ->select(DB::raw("substring_index(group_concat(id ORDER BY rand()), ',',".$examObj->comprehension_question_count.") as comp_ids"))
                //                                                        ->where('course_id',$course_info->id)->where('status','1')
                //                                                        ->first();
                $comp_passage_details = DB::select("SELECT substring_index(group_concat(id ORDER BY rand()), ',','".$examObj->comprehension_question_count."') as comp_ids FROM `q_a_comprehension_text` WHERE `course_id` = '".$course_info->id."' AND `status` = 1 AND (SELECT count(id) FROM `q_a` WHERE `q_a`.`comprehension_id` = q_a_comprehension_text.id AND q_a.status = 1) > 0 LIMIT 1");
            }
            
            //print_r($comp_passage_details);
            //echo $comp_passage_details[0]->comp_ids;
            //exit();
                                                                    
            $comp_question_details = DB::table('q_a')
                                                ->where('course_id',$course_info->id)
                                                ->where('question_model','comprehension')
                                                ->where('status','1')
                                                ->whereIn('comprehension_id',explode(',',$comp_passage_details[0]->comp_ids))
                                                ->orderBy('comprehension_id','ASC') //to show passage one by one.
                                                ->get();
            //print_r($comp_question_details);
            //exit();
            
            //If want to change the display order of objective,essay,comprehension - change it here
            $question_details =  $obj_question_details_rea->merge($obj_question_details_wri)->merge($obj_question_details_lis)->merge($essay_question_details)->merge($comp_question_details);
            
            
            //echo "<br> Total required Obj : ".$examObj->objective_question_count;
            //echo "<br> Total required : List ".($listening_qs_cnt);
            //echo "<br>-----------------------<br>";
            //echo "<br> Total required : Writ ".($writing_qs_cnt);
            //echo "<br>-----------------------<br>";
            //echo "<br> Total required : Read ".($reading_qs_cnt);
            //echo "<br>-----------------------<br>";
            //
            //echo "<pre>";
            //print_r($question_details);
            //echo "<br>=================<br>";
            //print_r($obj_question_details_rea);
            //echo "<br>=================<br>";
            //print_r($obj_question_details_wri);
            //echo "<br>=================<br>";
            //print_r($obj_question_details_lis);
            //exit();
            
            $comprehension_text = '';
            $upcoming_question = '';
            $order = 0;     //Order is added to show the same questions to and fro
            $attempt = $last_attempt_number + 1;
            $has_essay_questions = 0;
            
            if(!isset($question_details) || empty($question_details) || $question_details->isEmpty()){
                return redirect()->route('frontend.user.myclasses')->withFlashDanger('No Questions added yet!');
            }
            else{
                $exam_started_time = date('Y-m-d H:i:s');
                $exam_end_timestamp = strtotime($exam_started_time.' + '.$examObj->duration.' Minutes');
                $exam_end_time = date('Y-m-d H:i:s', $exam_end_timestamp);
                $student_exam_id = DB::table('student_exams')->insertGetId(['student_id' => $userid, 'exam_id' => $examObj->id, 'attempt'=>$attempt, 'exam_started_at'=>$exam_started_time]);
                
                foreach($question_details as $each_question){
                    $order++;
                    $inserted_id = DB::table('student_exam_answers')->insertGetId(['student_exam_id' => $student_exam_id, 'qa_id' => $each_question->id,'comprehension_id'=>$each_question->comprehension_id, 'question_model'=>$each_question->question_model, 'question_type'=>$each_question->question_type, 'order'=>$order]);
                    
                    if($each_question->question_type == 'essay'){
                      $has_essay_questions++;
                    }
                    
                    //if($upcoming_question == ''){
                    //  $upcoming_question = $each_question;
                    //  $question_order_no = $order;
                    //  $sea_id = $inserted_id;
                    //  $answer = '';
                    //}
                }
                $total_questions = $order;
                
                //Getting the first question from table----
                $question_details = DB::table('student_exam_answers')->where('student_exam_id',$student_exam_id)->orderBy('order','ASC')->limit(1)->first();
                $comprehension_text = '';                                   
                if(!empty($question_details)){
                  if($question_details->question_model == 'comprehension'){
                    $upcoming_question = DB::table('q_a')
                                                        ->select('q_a.*','q_a_comprehension_text.content as comprehension_text')
                                                        ->leftJoin('q_a_comprehension_text', 'q_a_comprehension_text.id', '=', 'q_a.comprehension_id')
                                                        ->where('q_a.id',$question_details->qa_id)->first();
                                                        
                    $question_order_no = $question_details->order;
                    $sea_id = $question_details->id;
                    $answer_array = explode(',',$question_details->answers);            
                    
                  }
                  else{
                    $upcoming_question = DB::table('q_a')->where('id',$question_details->qa_id)->first();
                    $question_order_no = $question_details->order;
                    $sea_id = $question_details->id;
                    $answer_array = explode(',',$question_details->answers);            
                  }
                }
                //--------------------------------------
                
            }
        }
        else{
            //Reached maximum attempt
            return redirect()->route('frontend.user.myclasses')->withFlashDanger('You have attempted all the exams!');
        }
      }
      
        return view('frontend.user.exams', ['course_info' => $course_info, 
                'examObj'=>$examObj, 'question_no'=>$question_order_no,'attempt'=>$attempt, 'question_details'=>$upcoming_question,'comprehension_text'=>$comprehension_text, 'answer_array'=>$answer_array,'sea_id'=>$sea_id,'student_batch_id'=>$student_batch_id, 'exam_end_time'=>$exam_end_time,'error_on_question'=>$error_on_question,'total_questions'=>$total_questions,'has_essay_questions'=>$has_essay_questions,'student_exam_id'=>$student_exam_id]);
    }
    else{
        return redirect()->route('frontend.user.myclasses')->withFlashDanger('You have attempted all the exams!');
    }
  }

  
  
  
  
  
  
  /*
   *Handling student answers - updating answer is correct or not
   *Only Objective type questions
   *function exist in TrainerController.php -> student_correct_answers()
   *
  */
  public function update_objective_results($student_exam_id)
  {
    $student_id = \Auth::user()->id;
    
    $exam_details = DB::table('exam')
      ->select('exam.*', 'student_exams.attempt', 'student_exams.exam_started_at')
      ->join('student_exams', 'exam.id', '=', 'student_exams.exam_id')
      ->where('student_exams.id', $student_exam_id)
      ->where('student_exams.completed', '1')
      ->first();
      
    //check the exam has only objective type - else return.
    if($exam_details->objective_question_count > 0 && $exam_details->essay_question_count == 0 && $exam_details->comprehension_question_count == 0 && $exam_details->objective_question_count == $exam_details->total_questions){
      //Proceed to update results ... Only Objective type questions
    }
    else{
        //Return ... Not Only Objective type questions.
        return;
    }
    
    //----------------------------------------------------
    
    
    $exam_answer_details = DB::table('student_exam_answers')
      ->select(DB::raw('count(qa_id) as total_questions, count(case when correct = 1 then 1 else NULL end) as correct_answer_cnt'))
      ->where('student_exam_id', $student_exam_id)->first();

    $objective_answer = DB::table('student_exam_answers')
      ->select(DB::raw('count(id) as total_correct'))
      ->where('correct', '1')
      ->where('question_type', 'objective')
      ->where('question_model', 'obj_essay')
      ->where('student_exam_id', $student_exam_id)->first();
      


    //------ getting marks for listening/reading/writing and update-------------------
    // Only Objective type question - data taking-----------
    $objective_ans_details = DB::table('q_a')
      ->select('student_exam_answers.id', 'student_exam_answers.qa_id', 'q_a.category')
      ->join('student_exam_answers', 'student_exam_answers.qa_id', '=', 'q_a.id')
      ->where('student_exam_answers.correct', '1')
      ->where('student_exam_answers.question_type', 'objective')
      ->where('student_exam_answers.question_model', 'obj_essay')
      ->where('student_exam_answers.student_exam_id', $student_exam_id)->get();

    $listening_correct = $reading_correct = $writing_correct = 0;
    foreach ($objective_ans_details as $objective_anwrs) {
      if ($objective_anwrs->category == 'listening') {
        $listening_correct++;
      } else if ($objective_anwrs->category == 'reading') {
        $reading_correct++;
      } else if ($objective_anwrs->category == 'writing') {
        $writing_correct++;
      }
    }
    //---------------------------------------------------------------------------------


    $total_marks = $exam_details->total_marks;
    $objective_mark_per_question = $exam_details->objective_question_mark;
    
    $correct_answer_cnt = $exam_answer_details->correct_answer_cnt > 0 ?  $exam_answer_details->correct_answer_cnt : 0;
    $questions_count = $exam_answer_details->total_questions;
    $percentage = ($correct_answer_cnt / $questions_count) * 100;


    $objective_correct_cnt = $objective_answer->total_correct > 0 ?  $objective_answer->total_correct : 0;
    $objective_score = $objective_correct_cnt * $objective_mark_per_question;

    $listening_marks = $listening_correct * $objective_mark_per_question;
    $reading_marks = $reading_correct * $objective_mark_per_question;
    $writing_marks = $writing_correct * $objective_mark_per_question;

    $score = $objective_score;
    $pass_percentage = config('site_configs.exam.pass_percentage');
    $percentage >= $pass_percentage ? $passed = 1 : $passed = 0;


    $student_exam_result_details = DB::table('student_exam_result')
      ->select('id')
      ->where('exam_id', $exam_details->id)
      ->where('student_id', $student_id)
      ->where('attempt', $exam_details->attempt)
      ->first();
    if (isset($student_exam_result_details) && isset($student_exam_result_details->id) && $student_exam_result_details->id > 0) {
        //DB::table('student_exam_result')->where('id', $student_exam_result_details->id)
        //->update(['score' => $score, 'passed' => $passed, 'attempt_date' => $exam_details->exam_started_at, 'total_exam_marks' => $total_marks, 'objective_marks' => $objective_score, 'essay_marks' => 0, 'comprehension_marks' => 0, 'listening_marks' => $listening_marks, 'reading_marks' => $reading_marks, 'writing_marks' => $writing_marks]);
    } else {
      $inserted_result_id = DB::table('student_exam_result')
        ->insertGetId(['student_id' => $student_id, 'exam_id' => $exam_details->id, 'attempt' => $exam_details->attempt, 'score' => $score, 'passed' => $passed, 'attempt_date' => $exam_details->exam_started_at, 'total_exam_marks' => $total_marks, 'objective_marks' => $objective_score, 'essay_marks' => 0, 'comprehension_marks' => 0, 'listening_marks' => $listening_marks, 'reading_marks' => $reading_marks, 'writing_marks' => $writing_marks]);
    }
    //-----------------------------------------------------------
  }
}
