<?php

namespace App\Http\Controllers\Frontend\User;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Models\Auth\Posts;
use App\Models\Auth\Products;
use App\Models\Auth\ProductCategories;
use App\Models\Auth\Categories;
use App\Models\Auth\ProductImages;
use App\Models\Auth\CurrencyRate;
use App\Models\Auth\ProductDownloads;
use App\Models\Auth\UserShippingAddress;
use App\Models\Auth\Orders;
use App\Models\Auth\Invoice;
use App\Models\Auth\TaxRates;
use App\Models\Auth\InvoicePayment;
use App\Models\Auth\InvoiceItems;
use App\Models\Auth\OrderItems;
use App\Models\Auth\OrderStatus;
use App\Models\Auth\PaymentGatewayTrans;
use App\Models\Auth\User;
use App\Models\Auth\OnlineCourse;
use App\Models\Auth\Course;
use App\Models\Auth\Country;
use App\Models\Auth\Shipping;
use App\Models\Auth\Downloads;
use App\Models\Auth\State;
use App\Models\Auth\City;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use PDF;

class MyInvoicesController extends Controller
{
  public function __construct()
  {
    $this->menu_details = array();
    //$main_menus = Posts::Select('id','title','menu_title','slug')->where('status', '=', 1)->where('show_in_main_menu', '=', 1)->where('module_type', '!=', 'home')->orderBy('order')->get();

    $main_menus = Posts::Select('id', 'title', 'menu_title', 'slug')
      ->where('status', '=', 1)
      ->where('show_in_main_menu', '=', 1)
      ->where(function ($query) {
        $query->Where('module_type', '<>', "home")
          ->orWhere('module_type', NULL);
      })
      ->orderBy('order')
      ->get();

    foreach ($main_menus as $main_menu) {
      $menu_title = $main_menu['menu_title'] != '' ? $main_menu['menu_title'] : $main_menu['title'];
      $this->menu_details[$menu_title] =  route('frontend.view-article', [$main_menu['slug']]);
    }
  }

  public function index()
  {
    return view('frontend.my-invoices.index');
  }

  public function invoices_list()
  {
    $id = auth()->user()->id;

    $data = Invoice::where('student_id', '=', $id)->latest()->get();
    return Datatables::of($data)
      ->editColumn('invoice_id', function ($data) {
        return $data->id;
      })
      ->editColumn('date', function ($data) {
        $date = strtotime($data->created_at);
        $new_date = date('d/m/Y', $date);
        return $new_date;
      })
      ->editColumn('invoice', function ($data) {
        return $data->invoice_num;
      })
      ->editColumn('amount', function ($data) {
        if(get_total_invoice_payment($data->id)){
            //$amt = get_currency_symbol($data->currency).' '.$data->grand_total;
            $amt = get_currency_symbol($data->currency).' '. $data->grand_total - get_total_invoice_payment($data->id);
        }
        else{
            $amt = get_currency_symbol($data->currency).' '.$data->grand_total;
        }
        return $amt;
      })
      ->editColumn('status', function ($data) {
          if($data->status=='due'){
            return '<span class="text-danger">'.ucfirst($data->status).'</span>';
          }else{
            return ucfirst($data->status);
          }
      })
      ->addColumn('action', function ($data) {
        $type = "all-orders";
        return view("frontend.my-invoices.btn", compact('data', 'type'));
      })
      ->rawColumns(['status','action'])
      ->make(true);
  }

    public function view_invoice($id)
    {
        $invoice = Invoice::find($id);
        if(!$invoice){
          	return redirect()->route("frontend.user.my-invoices")->withFlashDanger("Invoice Not Found!");
        }

        if($invoice->student_id != auth()->user()->id){
          return redirect()->route("frontend.user.my-invoices")->withFlashDanger("Invoice Not Found!");
        }
        $invoice_items = InvoiceItems::where("invoice_id", $invoice->id)->get();
        $stuData = User::find(auth()->user()->id);
        $payments = InvoicePayment::where('invoice_id', $invoice->id)->get();

        $total_payment = InvoicePayment::where('invoice_id', $invoice->id)->sum('amount');

        return view('frontend.my-invoices.invoice-detail', compact('invoice', 'stuData', 'payments', 'total_payment','invoice_items'));
    }

    public function pay_invoice($id)
    {
        $invoice = Invoice::find($id);
        if(!$invoice){
          return redirect()->route("frontend.user.my-invoices")->withFlashDanger("Invoice Not Found!");
        }
        if($invoice->student_id != auth()->user()->id){
          return redirect()->route("frontend.user.my-invoices")->withFlashDanger("Invoice Not Found!");
        }
        $stuData = User::find(auth()->user()->id);
        $payments = InvoicePayment::where('invoice_id', $invoice->id)->get();
        $total_payment = InvoicePayment::where('invoice_id', $invoice->id)->sum('amount');

        if (\Auth::user()) {
          $user_id = \Auth::user()->id;
          $userData = User::where('id', '=', $user_id)->first();
          $userShippingAddress = UserShippingAddress::where('user_id', '=', $user_id)->get();

          $country = Country::where('id', '=', $userData->country)->first();
          $state = State::where('id', '=', $userData->state)->first();
          $city = City::where('id', '=', $userData->city)->first();

          $countries = "";
          $dialcodes = "";
        } else {
          $userData = "";
          $country = "";
          $state = "";
          $city = "";
          $userShippingAddress = array();
          $countries = Country::get();
          $dialcodes = Country::get(['tel as code', 'title_en as name'])->sortBy('name');
        }

      $countries = Country::get(['id', 'title_en'])->sortBy('title_en');
      $cms_page = 1;
      $tax = 0;
      $notes = "";
      $type = "invoice";
      $main_menu_arr = $this->menu_details;
      $invoice_id = $id;
      $toti = ($total_payment) ? $invoice->grand_total - $total_payment : $invoice->grand_total;
      $tax_one_name = $tax_two_name = $tax_one_rate = $tax_two_rate = "";
      $tax_inclusive = $tax = $tax_one = $tax_two = $tax_two_amt = 0;
      $tax_one_amt = 0;
      $tax_type = "";

      if($country != "" && $state != ""){
        $taxData = TaxRates::where('country',$country->id)->where('state',$state->id)
              ->orWhere(function ($query) use ($country)  {
                $query->where('country',$country->id)->where('state',0);
              })
              ->orWhere(function ($query) use ($state)  {
                $query->where('country',0)->where('state',$state->id);
              })
              ->orWhere(function ($query) {
                $query->where('country',0)->where('state',0);
              })
              ->get();
          if(get_site_config('enabled_taxes') == 1){
                if(get_site_config('tax_exclusive')){
                if(count($taxData)){
                  $tax_one_amt = round($toti * $taxData[0]->tax_rate/100,2);
                  $tax_one_name = $taxData[0]->display_name;
                  $tax_one_rate = $taxData[0]->tax_rate;
                  if(isset($taxData[1])){
                    $tax_two_amt = round($toti * $taxData[1]->tax_rate/100,2);
                    $tax_two_name = $taxData[1]->display_name;
                    $tax_two_rate = $taxData[1]->tax_rate;
                  }
                  $tax = round($tax_one_amt+$tax_two_amt,2);
                }else{
                  $tax = 0;
                  $tax_one_name = $tax_two_name = $tax_one_rate = $tax_two_rate = "";
                  $tax_one_amt = $tax_two_amt = 0;
                }
                $tax_type = "exclusive";
                }
                if(get_site_config('tax_inclusive')){
                if(count($taxData)){
                  $tax_one_amt = round($toti * $taxData[0]->tax_rate/100,2);
                  $tax_one_name = $taxData[0]->display_name;
                  $tax_one_rate = $taxData[0]->tax_rate;
                  if(isset($taxData[1])){
                    $tax_two_amt = round($toti * $taxData[1]->tax_rate/100,2);
                    $tax_two_name = $taxData[1]->display_name;
                    $tax_two_rate = $taxData[1]->tax_rate;
                  }
                  $tax = round($tax_one_amt+$tax_two_amt,2);
                }else{
                  $tax = 0;
                  $tax_one_name = $tax_two_name = $tax_one_rate = $tax_two_rate = "";
                  $tax_one_amt = $tax_two_amt = 0;
                }
                $tax_type = "inclusive";
                }
              }else{
                $tax = 0;
                $tax_one_name = $tax_two_name = $tax_one_rate = $tax_two_rate = "";
                $tax_one_amt = $tax_two_amt = 0;
              }
        }
      $tax = 0;
      return view('frontend.checkout', 
        compact('cms_page', 'main_menu_arr', 'notes', 'userData', 'country', 'state', 'city', 'countries', 'toti', 'tax', 'userShippingAddress', 'type','invoice_id','tax_inclusive','tax_one','tax_two','tax_one_name','tax_two_name','tax_one_rate','tax_two_rate','tax_type'));
    }

    public function download_invoice($id)
    {
        $invoice = Invoice::find($id);
        $invoice_items = InvoiceItems::where("invoice_id", $invoice->id)->get();
        $stuData = User::find($invoice->student_id);
        $payments = InvoicePayment::where('invoice_id', $invoice->id)->get();
        $total_payment = InvoicePayment::where('invoice_id', $invoice->id)->sum('amount');

        $filename = "Invoice_" . $invoice->invoice_num;

        $pdf = PDF::loadView('frontend.invoice_pdf', ['invoice' => $invoice, 'stuData' => $stuData, 'payments' => $payments, 'total_payment' => $total_payment,'invoice_items' => $invoice_items]);
        return $pdf->stream($filename . ".pdf");
    }
}
